defmodule DaProductApp.Repo.Migrations.AddAlipayplusFieldsToSettlements do
  use Ecto.Migration

  def change do
    alter table(:settlements) do
      add :participant_id, :string
      add :settlement_batch_id, :string
      add :participant_agreement_id, :string
      add :value_date, :date
      add :fund_direction, :string
      add :transaction_currency, :string
      add :net_transaction_amount_value, :decimal, precision: 20, scale: 2
      add :extend_info, :text
    end

    create index(:settlements, [:participant_id])
    create index(:settlements, [:settlement_batch_id])
    create index(:settlements, [:participant_agreement_id])
  end
end
