// If you want to use Phoenix channels, run `mix help phx.gen.channel`
// to get started and then uncomment the line below.
// import "./user_socket.js"

// You can include dependencies in two ways.
//
// The simplest option is to put them in assets/vendor and
// import them using relative paths:
//
//     import "../vendor/some-package.js"
//
// Alternatively, you can `npm install some-package --prefix assets` and import
// them using a path starting with the package name:
//
//     import "some-package"
//

// Include phoenix_html to handle method=PUT/DELETE in forms and buttons.
import "phoenix_html"
// Establish Phoenix Socket and LiveView configuration.
import {Socket} from "phoenix"
import {LiveSocket} from "phoenix_live_view"
import {Hooks} from "./hooks"
// Uncomment if you use alpinejs
// import Alpine from "alpinejs"
// window.Alpine = Alpine
// Alpine.start()
import topbar from "../vendor/topbar"
import * as agGridCommunity from "../vendor/ag-grid-community.min.js";

window.agGrid = agGridCommunity;
//import "../vendor/ag-grid-community.min.js";
import "../vendor/ag-grid-enterprise.js";
//import "../vendor/ag-charts-community.js";
//import * as agChartsCommunity from "../vendor/ag-charts-community.js";
//window.agCharts = agChartsCommunity;
//import "../vendor/ag-charts-enterprise.js";
import * as agChartsCommunity from "../vendor/ag-charts-enterprise.js";
window.agCharts = agChartsCommunity;

import '../vendor/leaflet.css';
import '../vendor/leaflet.js';
window.Leaflet = window.L;


import * as jsPlumbModule from "../vendor/jsplumb.min.js";
window.jsPlumb = jsPlumbModule.jsPlumb;


let csrfToken = document.querySelector("meta[name='csrf-token']").getAttribute("content")
let liveSocket = new LiveSocket("/live", Socket, {
  hooks: Hooks,
  dom: {
    onBeforeElUpdated(from, to) {
      if (from._x_dataStack) {
        window.Alpine.clone(from, to)
      }
    }
  },

  longPollFallbackMs: 2500,
  params: {_csrf_token: csrfToken}
})

// Show progress bar on live navigation and form submits
topbar.config({barColors: {0: "#29d"}, shadowColor: "rgba(0, 0, 0, .3)"})
window.addEventListener("phx:page-loading-start", _info => topbar.show(300))
window.addEventListener("phx:page-loading-stop", _info => topbar.hide())

// connect if there are any LiveViews on the page
liveSocket.connect()

// expose liveSocket on window for web console debug logs and latency simulation:
// >> liveSocket.enableDebug()
// >> liveSocket.enableLatencySim(1000)  // enabled for duration of browser session
// >> liveSocket.disableLatencySim()
window.liveSocket = liveSocket


// Allows to execute JS commands from the server
window.addEventListener("phx:js-exec", ({detail}) => {
  document.querySelectorAll(detail.to).forEach(el => {
    liveSocket.execJS(el, el.getAttribute(detail.attr))
  })
})
