#!/usr/bin/env bash

# Demo script to test Settlement and Dispute APIs
# This demonstrates the implemented API endpoints

echo "Settlement and Dispute API Demo"
echo "================================"

BASE_URL="http://localhost:4000/api/v1/merchant"

echo -e "\n1. Creating sample data..."
echo "   Note: In a real scenario, settlements would be created by the system"
echo "   and disputes would be raised by merchants through the API"

echo -e "\n2. Testing Settlement APIs"
echo "   GET /settlements - List all settlements"
echo "   curl -X GET \"$BASE_URL/settlements\""
echo ""

echo "   GET /settlement/:id - Get specific settlement"  
echo "   curl -X GET \"$BASE_URL/settlement/SETT20250628\""
echo ""

echo "   GET /settlement/:id/transactions - Get settlement transactions"
echo "   curl -X GET \"$BASE_URL/settlement/SETT20250628/transactions\""
echo ""

echo "   GET /settlement/summary - Get dashboard summary"
echo "   curl -X GET \"$BASE_URL/settlement/summary\""
echo ""

echo "   GET /settlement/:id/download - Download settlement report"
echo "   curl -X GET \"$BASE_URL/settlement/SETT20250628/download?format=csv\""
echo ""

echo -e "\n3. Testing Dispute APIs"
echo "   POST /dispute - Raise a new dispute"
echo "   curl -X POST \"$BASE_URL/dispute\" \\"
echo "        -H \"Content-Type: application/json\" \\"
echo "        -d '{"
echo "          \"txn_id\": \"TXN1003\","
echo "          \"reason\": \"Transaction not credited\","
echo "          \"comment\": \"Please verify settlement mismatch\","
echo "          \"contact_email\": \"merchant@example.com\""
echo "        }'"
echo ""

echo "   GET /disputes - List all disputes"
echo "   curl -X GET \"$BASE_URL/disputes\""
echo ""

echo "   GET /dispute/:id - Get specific dispute"
echo "   curl -X GET \"$BASE_URL/dispute/DSP89012\""
echo ""

echo "   GET /dispute/:id/download - Download dispute report"
echo "   curl -X GET \"$BASE_URL/dispute/DSP89012/download?format=pdf\""
echo ""

echo -e "\n4. API Features Implemented:"
echo "   ✓ Pagination support (page, page_size parameters)"
echo "   ✓ Filtering by date range (from_date, to_date)"
echo "   ✓ Status filtering (status parameter)" 
echo "   ✓ Search functionality (search parameter)"
echo "   ✓ Report generation (CSV and PDF formats)"
echo "   ✓ Auto-generated IDs for settlements and disputes"
echo "   ✓ Input validation and error handling"
echo "   ✓ Comprehensive test coverage"
echo ""

echo -e "\n5. Database Schema:"
echo "   ✓ settlements table with proper indexing"
echo "   ✓ disputes table with proper indexing"
echo "   ✓ Extended transactions table with settlement links"
echo ""

echo "All APIs match the provided specification and are ready for use!"