defmodule Floki.Entities.Codepoints do
  # This file was generated by "Mix.Tasks.GenerateEntities"

  @moduledoc false

  @doc """
  Returns unicode codepoints for a given HTML entity.
  """
  @spec get(binary()) :: list(integer)
  def get("&AElig"), do: [198]
  def get("&AElig;"), do: [198]
  def get("&AMP"), do: [38]
  def get("&AMP;"), do: [38]
  def get("&Aacute"), do: [193]
  def get("&Aacute;"), do: [193]
  def get("&Abreve;"), do: [258]
  def get("&Acirc"), do: [194]
  def get("&Acirc;"), do: [194]
  def get("&Acy;"), do: [1040]
  def get("&Afr;"), do: [120_068]
  def get("&Agrave"), do: [192]
  def get("&Agrave;"), do: [192]
  def get("&Alpha;"), do: [913]
  def get("&Amacr;"), do: [256]
  def get("&And;"), do: [10835]
  def get("&Aogon;"), do: [260]
  def get("&Aopf;"), do: [120_120]
  def get("&ApplyFunction;"), do: [8289]
  def get("&Aring"), do: [197]
  def get("&Aring;"), do: [197]
  def get("&Ascr;"), do: [119_964]
  def get("&Assign;"), do: [8788]
  def get("&Atilde"), do: [195]
  def get("&Atilde;"), do: [195]
  def get("&Auml"), do: [196]
  def get("&Auml;"), do: [196]
  def get("&Backslash;"), do: [8726]
  def get("&Barv;"), do: [10983]
  def get("&Barwed;"), do: [8966]
  def get("&Bcy;"), do: [1041]
  def get("&Because;"), do: [8757]
  def get("&Bernoullis;"), do: [8492]
  def get("&Beta;"), do: [914]
  def get("&Bfr;"), do: [120_069]
  def get("&Bopf;"), do: [120_121]
  def get("&Breve;"), do: [728]
  def get("&Bscr;"), do: [8492]
  def get("&Bumpeq;"), do: [8782]
  def get("&CHcy;"), do: [1063]
  def get("&COPY"), do: [169]
  def get("&COPY;"), do: [169]
  def get("&Cacute;"), do: [262]
  def get("&Cap;"), do: [8914]
  def get("&CapitalDifferentialD;"), do: [8517]
  def get("&Cayleys;"), do: [8493]
  def get("&Ccaron;"), do: [268]
  def get("&Ccedil"), do: [199]
  def get("&Ccedil;"), do: [199]
  def get("&Ccirc;"), do: [264]
  def get("&Cconint;"), do: [8752]
  def get("&Cdot;"), do: [266]
  def get("&Cedilla;"), do: [184]
  def get("&CenterDot;"), do: [183]
  def get("&Cfr;"), do: [8493]
  def get("&Chi;"), do: [935]
  def get("&CircleDot;"), do: [8857]
  def get("&CircleMinus;"), do: [8854]
  def get("&CirclePlus;"), do: [8853]
  def get("&CircleTimes;"), do: [8855]
  def get("&ClockwiseContourIntegral;"), do: [8754]
  def get("&CloseCurlyDoubleQuote;"), do: [8221]
  def get("&CloseCurlyQuote;"), do: [8217]
  def get("&Colon;"), do: [8759]
  def get("&Colone;"), do: [10868]
  def get("&Congruent;"), do: [8801]
  def get("&Conint;"), do: [8751]
  def get("&ContourIntegral;"), do: [8750]
  def get("&Copf;"), do: [8450]
  def get("&Coproduct;"), do: [8720]
  def get("&CounterClockwiseContourIntegral;"), do: [8755]
  def get("&Cross;"), do: [10799]
  def get("&Cscr;"), do: [119_966]
  def get("&Cup;"), do: [8915]
  def get("&CupCap;"), do: [8781]
  def get("&DD;"), do: [8517]
  def get("&DDotrahd;"), do: [10513]
  def get("&DJcy;"), do: [1026]
  def get("&DScy;"), do: [1029]
  def get("&DZcy;"), do: [1039]
  def get("&Dagger;"), do: [8225]
  def get("&Darr;"), do: [8609]
  def get("&Dashv;"), do: [10980]
  def get("&Dcaron;"), do: [270]
  def get("&Dcy;"), do: [1044]
  def get("&Del;"), do: [8711]
  def get("&Delta;"), do: [916]
  def get("&Dfr;"), do: [120_071]
  def get("&DiacriticalAcute;"), do: [180]
  def get("&DiacriticalDot;"), do: [729]
  def get("&DiacriticalDoubleAcute;"), do: [733]
  def get("&DiacriticalGrave;"), do: [96]
  def get("&DiacriticalTilde;"), do: [732]
  def get("&Diamond;"), do: [8900]
  def get("&DifferentialD;"), do: [8518]
  def get("&Dopf;"), do: [120_123]
  def get("&Dot;"), do: [168]
  def get("&DotDot;"), do: [8412]
  def get("&DotEqual;"), do: [8784]
  def get("&DoubleContourIntegral;"), do: [8751]
  def get("&DoubleDot;"), do: [168]
  def get("&DoubleDownArrow;"), do: [8659]
  def get("&DoubleLeftArrow;"), do: [8656]
  def get("&DoubleLeftRightArrow;"), do: [8660]
  def get("&DoubleLeftTee;"), do: [10980]
  def get("&DoubleLongLeftArrow;"), do: [10232]
  def get("&DoubleLongLeftRightArrow;"), do: [10234]
  def get("&DoubleLongRightArrow;"), do: [10233]
  def get("&DoubleRightArrow;"), do: [8658]
  def get("&DoubleRightTee;"), do: [8872]
  def get("&DoubleUpArrow;"), do: [8657]
  def get("&DoubleUpDownArrow;"), do: [8661]
  def get("&DoubleVerticalBar;"), do: [8741]
  def get("&DownArrow;"), do: [8595]
  def get("&DownArrowBar;"), do: [10515]
  def get("&DownArrowUpArrow;"), do: [8693]
  def get("&DownBreve;"), do: [785]
  def get("&DownLeftRightVector;"), do: [10576]
  def get("&DownLeftTeeVector;"), do: [10590]
  def get("&DownLeftVector;"), do: [8637]
  def get("&DownLeftVectorBar;"), do: [10582]
  def get("&DownRightTeeVector;"), do: [10591]
  def get("&DownRightVector;"), do: [8641]
  def get("&DownRightVectorBar;"), do: [10583]
  def get("&DownTee;"), do: [8868]
  def get("&DownTeeArrow;"), do: [8615]
  def get("&Downarrow;"), do: [8659]
  def get("&Dscr;"), do: [119_967]
  def get("&Dstrok;"), do: [272]
  def get("&ENG;"), do: [330]
  def get("&ETH"), do: [208]
  def get("&ETH;"), do: [208]
  def get("&Eacute"), do: [201]
  def get("&Eacute;"), do: [201]
  def get("&Ecaron;"), do: [282]
  def get("&Ecirc"), do: [202]
  def get("&Ecirc;"), do: [202]
  def get("&Ecy;"), do: [1069]
  def get("&Edot;"), do: [278]
  def get("&Efr;"), do: [120_072]
  def get("&Egrave"), do: [200]
  def get("&Egrave;"), do: [200]
  def get("&Element;"), do: [8712]
  def get("&Emacr;"), do: [274]
  def get("&EmptySmallSquare;"), do: [9723]
  def get("&EmptyVerySmallSquare;"), do: [9643]
  def get("&Eogon;"), do: [280]
  def get("&Eopf;"), do: [120_124]
  def get("&Epsilon;"), do: [917]
  def get("&Equal;"), do: [10869]
  def get("&EqualTilde;"), do: [8770]
  def get("&Equilibrium;"), do: [8652]
  def get("&Escr;"), do: [8496]
  def get("&Esim;"), do: [10867]
  def get("&Eta;"), do: [919]
  def get("&Euml"), do: [203]
  def get("&Euml;"), do: [203]
  def get("&Exists;"), do: [8707]
  def get("&ExponentialE;"), do: [8519]
  def get("&Fcy;"), do: [1060]
  def get("&Ffr;"), do: [120_073]
  def get("&FilledSmallSquare;"), do: [9724]
  def get("&FilledVerySmallSquare;"), do: [9642]
  def get("&Fopf;"), do: [120_125]
  def get("&ForAll;"), do: [8704]
  def get("&Fouriertrf;"), do: [8497]
  def get("&Fscr;"), do: [8497]
  def get("&GJcy;"), do: [1027]
  def get("&GT"), do: [62]
  def get("&GT;"), do: [62]
  def get("&Gamma;"), do: [915]
  def get("&Gammad;"), do: [988]
  def get("&Gbreve;"), do: [286]
  def get("&Gcedil;"), do: [290]
  def get("&Gcirc;"), do: [284]
  def get("&Gcy;"), do: [1043]
  def get("&Gdot;"), do: [288]
  def get("&Gfr;"), do: [120_074]
  def get("&Gg;"), do: [8921]
  def get("&Gopf;"), do: [120_126]
  def get("&GreaterEqual;"), do: [8805]
  def get("&GreaterEqualLess;"), do: [8923]
  def get("&GreaterFullEqual;"), do: [8807]
  def get("&GreaterGreater;"), do: [10914]
  def get("&GreaterLess;"), do: [8823]
  def get("&GreaterSlantEqual;"), do: [10878]
  def get("&GreaterTilde;"), do: [8819]
  def get("&Gscr;"), do: [119_970]
  def get("&Gt;"), do: [8811]
  def get("&HARDcy;"), do: [1066]
  def get("&Hacek;"), do: [711]
  def get("&Hat;"), do: [94]
  def get("&Hcirc;"), do: [292]
  def get("&Hfr;"), do: [8460]
  def get("&HilbertSpace;"), do: [8459]
  def get("&Hopf;"), do: [8461]
  def get("&HorizontalLine;"), do: [9472]
  def get("&Hscr;"), do: [8459]
  def get("&Hstrok;"), do: [294]
  def get("&HumpDownHump;"), do: [8782]
  def get("&HumpEqual;"), do: [8783]
  def get("&IEcy;"), do: [1045]
  def get("&IJlig;"), do: [306]
  def get("&IOcy;"), do: [1025]
  def get("&Iacute"), do: [205]
  def get("&Iacute;"), do: [205]
  def get("&Icirc"), do: [206]
  def get("&Icirc;"), do: [206]
  def get("&Icy;"), do: [1048]
  def get("&Idot;"), do: [304]
  def get("&Ifr;"), do: [8465]
  def get("&Igrave"), do: [204]
  def get("&Igrave;"), do: [204]
  def get("&Im;"), do: [8465]
  def get("&Imacr;"), do: [298]
  def get("&ImaginaryI;"), do: [8520]
  def get("&Implies;"), do: [8658]
  def get("&Int;"), do: [8748]
  def get("&Integral;"), do: [8747]
  def get("&Intersection;"), do: [8898]
  def get("&InvisibleComma;"), do: [8291]
  def get("&InvisibleTimes;"), do: [8290]
  def get("&Iogon;"), do: [302]
  def get("&Iopf;"), do: [120_128]
  def get("&Iota;"), do: [921]
  def get("&Iscr;"), do: [8464]
  def get("&Itilde;"), do: [296]
  def get("&Iukcy;"), do: [1030]
  def get("&Iuml"), do: [207]
  def get("&Iuml;"), do: [207]
  def get("&Jcirc;"), do: [308]
  def get("&Jcy;"), do: [1049]
  def get("&Jfr;"), do: [120_077]
  def get("&Jopf;"), do: [120_129]
  def get("&Jscr;"), do: [119_973]
  def get("&Jsercy;"), do: [1032]
  def get("&Jukcy;"), do: [1028]
  def get("&KHcy;"), do: [1061]
  def get("&KJcy;"), do: [1036]
  def get("&Kappa;"), do: [922]
  def get("&Kcedil;"), do: [310]
  def get("&Kcy;"), do: [1050]
  def get("&Kfr;"), do: [120_078]
  def get("&Kopf;"), do: [120_130]
  def get("&Kscr;"), do: [119_974]
  def get("&LJcy;"), do: [1033]
  def get("&LT"), do: [60]
  def get("&LT;"), do: [60]
  def get("&Lacute;"), do: [313]
  def get("&Lambda;"), do: [923]
  def get("&Lang;"), do: [10218]
  def get("&Laplacetrf;"), do: [8466]
  def get("&Larr;"), do: [8606]
  def get("&Lcaron;"), do: [317]
  def get("&Lcedil;"), do: [315]
  def get("&Lcy;"), do: [1051]
  def get("&LeftAngleBracket;"), do: [10216]
  def get("&LeftArrow;"), do: [8592]
  def get("&LeftArrowBar;"), do: [8676]
  def get("&LeftArrowRightArrow;"), do: [8646]
  def get("&LeftCeiling;"), do: [8968]
  def get("&LeftDoubleBracket;"), do: [10214]
  def get("&LeftDownTeeVector;"), do: [10593]
  def get("&LeftDownVector;"), do: [8643]
  def get("&LeftDownVectorBar;"), do: [10585]
  def get("&LeftFloor;"), do: [8970]
  def get("&LeftRightArrow;"), do: [8596]
  def get("&LeftRightVector;"), do: [10574]
  def get("&LeftTee;"), do: [8867]
  def get("&LeftTeeArrow;"), do: [8612]
  def get("&LeftTeeVector;"), do: [10586]
  def get("&LeftTriangle;"), do: [8882]
  def get("&LeftTriangleBar;"), do: [10703]
  def get("&LeftTriangleEqual;"), do: [8884]
  def get("&LeftUpDownVector;"), do: [10577]
  def get("&LeftUpTeeVector;"), do: [10592]
  def get("&LeftUpVector;"), do: [8639]
  def get("&LeftUpVectorBar;"), do: [10584]
  def get("&LeftVector;"), do: [8636]
  def get("&LeftVectorBar;"), do: [10578]
  def get("&Leftarrow;"), do: [8656]
  def get("&Leftrightarrow;"), do: [8660]
  def get("&LessEqualGreater;"), do: [8922]
  def get("&LessFullEqual;"), do: [8806]
  def get("&LessGreater;"), do: [8822]
  def get("&LessLess;"), do: [10913]
  def get("&LessSlantEqual;"), do: [10877]
  def get("&LessTilde;"), do: [8818]
  def get("&Lfr;"), do: [120_079]
  def get("&Ll;"), do: [8920]
  def get("&Lleftarrow;"), do: [8666]
  def get("&Lmidot;"), do: [319]
  def get("&LongLeftArrow;"), do: [10229]
  def get("&LongLeftRightArrow;"), do: [10231]
  def get("&LongRightArrow;"), do: [10230]
  def get("&Longleftarrow;"), do: [10232]
  def get("&Longleftrightarrow;"), do: [10234]
  def get("&Longrightarrow;"), do: [10233]
  def get("&Lopf;"), do: [120_131]
  def get("&LowerLeftArrow;"), do: [8601]
  def get("&LowerRightArrow;"), do: [8600]
  def get("&Lscr;"), do: [8466]
  def get("&Lsh;"), do: [8624]
  def get("&Lstrok;"), do: [321]
  def get("&Lt;"), do: [8810]
  def get("&Map;"), do: [10501]
  def get("&Mcy;"), do: [1052]
  def get("&MediumSpace;"), do: [8287]
  def get("&Mellintrf;"), do: [8499]
  def get("&Mfr;"), do: [120_080]
  def get("&MinusPlus;"), do: [8723]
  def get("&Mopf;"), do: [120_132]
  def get("&Mscr;"), do: [8499]
  def get("&Mu;"), do: [924]
  def get("&NJcy;"), do: [1034]
  def get("&Nacute;"), do: [323]
  def get("&Ncaron;"), do: [327]
  def get("&Ncedil;"), do: [325]
  def get("&Ncy;"), do: [1053]
  def get("&NegativeMediumSpace;"), do: [8203]
  def get("&NegativeThickSpace;"), do: [8203]
  def get("&NegativeThinSpace;"), do: [8203]
  def get("&NegativeVeryThinSpace;"), do: [8203]
  def get("&NestedGreaterGreater;"), do: [8811]
  def get("&NestedLessLess;"), do: [8810]
  def get("&NewLine;"), do: [10]
  def get("&Nfr;"), do: [120_081]
  def get("&NoBreak;"), do: [8288]
  def get("&NonBreakingSpace;"), do: [160]
  def get("&Nopf;"), do: [8469]
  def get("&Not;"), do: [10988]
  def get("&NotCongruent;"), do: [8802]
  def get("&NotCupCap;"), do: [8813]
  def get("&NotDoubleVerticalBar;"), do: [8742]
  def get("&NotElement;"), do: [8713]
  def get("&NotEqual;"), do: [8800]
  def get("&NotEqualTilde;"), do: [8770, 824]
  def get("&NotExists;"), do: [8708]
  def get("&NotGreater;"), do: [8815]
  def get("&NotGreaterEqual;"), do: [8817]
  def get("&NotGreaterFullEqual;"), do: [8807, 824]
  def get("&NotGreaterGreater;"), do: [8811, 824]
  def get("&NotGreaterLess;"), do: [8825]
  def get("&NotGreaterSlantEqual;"), do: [10878, 824]
  def get("&NotGreaterTilde;"), do: [8821]
  def get("&NotHumpDownHump;"), do: [8782, 824]
  def get("&NotHumpEqual;"), do: [8783, 824]
  def get("&NotLeftTriangle;"), do: [8938]
  def get("&NotLeftTriangleBar;"), do: [10703, 824]
  def get("&NotLeftTriangleEqual;"), do: [8940]
  def get("&NotLess;"), do: [8814]
  def get("&NotLessEqual;"), do: [8816]
  def get("&NotLessGreater;"), do: [8824]
  def get("&NotLessLess;"), do: [8810, 824]
  def get("&NotLessSlantEqual;"), do: [10877, 824]
  def get("&NotLessTilde;"), do: [8820]
  def get("&NotNestedGreaterGreater;"), do: [10914, 824]
  def get("&NotNestedLessLess;"), do: [10913, 824]
  def get("&NotPrecedes;"), do: [8832]
  def get("&NotPrecedesEqual;"), do: [10927, 824]
  def get("&NotPrecedesSlantEqual;"), do: [8928]
  def get("&NotReverseElement;"), do: [8716]
  def get("&NotRightTriangle;"), do: [8939]
  def get("&NotRightTriangleBar;"), do: [10704, 824]
  def get("&NotRightTriangleEqual;"), do: [8941]
  def get("&NotSquareSubset;"), do: [8847, 824]
  def get("&NotSquareSubsetEqual;"), do: [8930]
  def get("&NotSquareSuperset;"), do: [8848, 824]
  def get("&NotSquareSupersetEqual;"), do: [8931]
  def get("&NotSubset;"), do: [8834, 8402]
  def get("&NotSubsetEqual;"), do: [8840]
  def get("&NotSucceeds;"), do: [8833]
  def get("&NotSucceedsEqual;"), do: [10928, 824]
  def get("&NotSucceedsSlantEqual;"), do: [8929]
  def get("&NotSucceedsTilde;"), do: [8831, 824]
  def get("&NotSuperset;"), do: [8835, 8402]
  def get("&NotSupersetEqual;"), do: [8841]
  def get("&NotTilde;"), do: [8769]
  def get("&NotTildeEqual;"), do: [8772]
  def get("&NotTildeFullEqual;"), do: [8775]
  def get("&NotTildeTilde;"), do: [8777]
  def get("&NotVerticalBar;"), do: [8740]
  def get("&Nscr;"), do: [119_977]
  def get("&Ntilde"), do: [209]
  def get("&Ntilde;"), do: [209]
  def get("&Nu;"), do: [925]
  def get("&OElig;"), do: [338]
  def get("&Oacute"), do: [211]
  def get("&Oacute;"), do: [211]
  def get("&Ocirc"), do: [212]
  def get("&Ocirc;"), do: [212]
  def get("&Ocy;"), do: [1054]
  def get("&Odblac;"), do: [336]
  def get("&Ofr;"), do: [120_082]
  def get("&Ograve"), do: [210]
  def get("&Ograve;"), do: [210]
  def get("&Omacr;"), do: [332]
  def get("&Omega;"), do: [937]
  def get("&Omicron;"), do: [927]
  def get("&Oopf;"), do: [120_134]
  def get("&OpenCurlyDoubleQuote;"), do: [8220]
  def get("&OpenCurlyQuote;"), do: [8216]
  def get("&Or;"), do: [10836]
  def get("&Oscr;"), do: [119_978]
  def get("&Oslash"), do: [216]
  def get("&Oslash;"), do: [216]
  def get("&Otilde"), do: [213]
  def get("&Otilde;"), do: [213]
  def get("&Otimes;"), do: [10807]
  def get("&Ouml"), do: [214]
  def get("&Ouml;"), do: [214]
  def get("&OverBar;"), do: [8254]
  def get("&OverBrace;"), do: [9182]
  def get("&OverBracket;"), do: [9140]
  def get("&OverParenthesis;"), do: [9180]
  def get("&PartialD;"), do: [8706]
  def get("&Pcy;"), do: [1055]
  def get("&Pfr;"), do: [120_083]
  def get("&Phi;"), do: [934]
  def get("&Pi;"), do: [928]
  def get("&PlusMinus;"), do: [177]
  def get("&Poincareplane;"), do: [8460]
  def get("&Popf;"), do: [8473]
  def get("&Pr;"), do: [10939]
  def get("&Precedes;"), do: [8826]
  def get("&PrecedesEqual;"), do: [10927]
  def get("&PrecedesSlantEqual;"), do: [8828]
  def get("&PrecedesTilde;"), do: [8830]
  def get("&Prime;"), do: [8243]
  def get("&Product;"), do: [8719]
  def get("&Proportion;"), do: [8759]
  def get("&Proportional;"), do: [8733]
  def get("&Pscr;"), do: [119_979]
  def get("&Psi;"), do: [936]
  def get("&QUOT"), do: [34]
  def get("&QUOT;"), do: [34]
  def get("&Qfr;"), do: [120_084]
  def get("&Qopf;"), do: [8474]
  def get("&Qscr;"), do: [119_980]
  def get("&RBarr;"), do: [10512]
  def get("&REG"), do: [174]
  def get("&REG;"), do: [174]
  def get("&Racute;"), do: [340]
  def get("&Rang;"), do: [10219]
  def get("&Rarr;"), do: [8608]
  def get("&Rarrtl;"), do: [10518]
  def get("&Rcaron;"), do: [344]
  def get("&Rcedil;"), do: [342]
  def get("&Rcy;"), do: [1056]
  def get("&Re;"), do: [8476]
  def get("&ReverseElement;"), do: [8715]
  def get("&ReverseEquilibrium;"), do: [8651]
  def get("&ReverseUpEquilibrium;"), do: [10607]
  def get("&Rfr;"), do: [8476]
  def get("&Rho;"), do: [929]
  def get("&RightAngleBracket;"), do: [10217]
  def get("&RightArrow;"), do: [8594]
  def get("&RightArrowBar;"), do: [8677]
  def get("&RightArrowLeftArrow;"), do: [8644]
  def get("&RightCeiling;"), do: [8969]
  def get("&RightDoubleBracket;"), do: [10215]
  def get("&RightDownTeeVector;"), do: [10589]
  def get("&RightDownVector;"), do: [8642]
  def get("&RightDownVectorBar;"), do: [10581]
  def get("&RightFloor;"), do: [8971]
  def get("&RightTee;"), do: [8866]
  def get("&RightTeeArrow;"), do: [8614]
  def get("&RightTeeVector;"), do: [10587]
  def get("&RightTriangle;"), do: [8883]
  def get("&RightTriangleBar;"), do: [10704]
  def get("&RightTriangleEqual;"), do: [8885]
  def get("&RightUpDownVector;"), do: [10575]
  def get("&RightUpTeeVector;"), do: [10588]
  def get("&RightUpVector;"), do: [8638]
  def get("&RightUpVectorBar;"), do: [10580]
  def get("&RightVector;"), do: [8640]
  def get("&RightVectorBar;"), do: [10579]
  def get("&Rightarrow;"), do: [8658]
  def get("&Ropf;"), do: [8477]
  def get("&RoundImplies;"), do: [10608]
  def get("&Rrightarrow;"), do: [8667]
  def get("&Rscr;"), do: [8475]
  def get("&Rsh;"), do: [8625]
  def get("&RuleDelayed;"), do: [10740]
  def get("&SHCHcy;"), do: [1065]
  def get("&SHcy;"), do: [1064]
  def get("&SOFTcy;"), do: [1068]
  def get("&Sacute;"), do: [346]
  def get("&Sc;"), do: [10940]
  def get("&Scaron;"), do: [352]
  def get("&Scedil;"), do: [350]
  def get("&Scirc;"), do: [348]
  def get("&Scy;"), do: [1057]
  def get("&Sfr;"), do: [120_086]
  def get("&ShortDownArrow;"), do: [8595]
  def get("&ShortLeftArrow;"), do: [8592]
  def get("&ShortRightArrow;"), do: [8594]
  def get("&ShortUpArrow;"), do: [8593]
  def get("&Sigma;"), do: [931]
  def get("&SmallCircle;"), do: [8728]
  def get("&Sopf;"), do: [120_138]
  def get("&Sqrt;"), do: [8730]
  def get("&Square;"), do: [9633]
  def get("&SquareIntersection;"), do: [8851]
  def get("&SquareSubset;"), do: [8847]
  def get("&SquareSubsetEqual;"), do: [8849]
  def get("&SquareSuperset;"), do: [8848]
  def get("&SquareSupersetEqual;"), do: [8850]
  def get("&SquareUnion;"), do: [8852]
  def get("&Sscr;"), do: [119_982]
  def get("&Star;"), do: [8902]
  def get("&Sub;"), do: [8912]
  def get("&Subset;"), do: [8912]
  def get("&SubsetEqual;"), do: [8838]
  def get("&Succeeds;"), do: [8827]
  def get("&SucceedsEqual;"), do: [10928]
  def get("&SucceedsSlantEqual;"), do: [8829]
  def get("&SucceedsTilde;"), do: [8831]
  def get("&SuchThat;"), do: [8715]
  def get("&Sum;"), do: [8721]
  def get("&Sup;"), do: [8913]
  def get("&Superset;"), do: [8835]
  def get("&SupersetEqual;"), do: [8839]
  def get("&Supset;"), do: [8913]
  def get("&THORN"), do: [222]
  def get("&THORN;"), do: [222]
  def get("&TRADE;"), do: [8482]
  def get("&TSHcy;"), do: [1035]
  def get("&TScy;"), do: [1062]
  def get("&Tab;"), do: [9]
  def get("&Tau;"), do: [932]
  def get("&Tcaron;"), do: [356]
  def get("&Tcedil;"), do: [354]
  def get("&Tcy;"), do: [1058]
  def get("&Tfr;"), do: [120_087]
  def get("&Therefore;"), do: [8756]
  def get("&Theta;"), do: [920]
  def get("&ThickSpace;"), do: [8287, 8202]
  def get("&ThinSpace;"), do: [8201]
  def get("&Tilde;"), do: [8764]
  def get("&TildeEqual;"), do: [8771]
  def get("&TildeFullEqual;"), do: [8773]
  def get("&TildeTilde;"), do: [8776]
  def get("&Topf;"), do: [120_139]
  def get("&TripleDot;"), do: [8411]
  def get("&Tscr;"), do: [119_983]
  def get("&Tstrok;"), do: [358]
  def get("&Uacute"), do: [218]
  def get("&Uacute;"), do: [218]
  def get("&Uarr;"), do: [8607]
  def get("&Uarrocir;"), do: [10569]
  def get("&Ubrcy;"), do: [1038]
  def get("&Ubreve;"), do: [364]
  def get("&Ucirc"), do: [219]
  def get("&Ucirc;"), do: [219]
  def get("&Ucy;"), do: [1059]
  def get("&Udblac;"), do: [368]
  def get("&Ufr;"), do: [120_088]
  def get("&Ugrave"), do: [217]
  def get("&Ugrave;"), do: [217]
  def get("&Umacr;"), do: [362]
  def get("&UnderBar;"), do: [95]
  def get("&UnderBrace;"), do: [9183]
  def get("&UnderBracket;"), do: [9141]
  def get("&UnderParenthesis;"), do: [9181]
  def get("&Union;"), do: [8899]
  def get("&UnionPlus;"), do: [8846]
  def get("&Uogon;"), do: [370]
  def get("&Uopf;"), do: [120_140]
  def get("&UpArrow;"), do: [8593]
  def get("&UpArrowBar;"), do: [10514]
  def get("&UpArrowDownArrow;"), do: [8645]
  def get("&UpDownArrow;"), do: [8597]
  def get("&UpEquilibrium;"), do: [10606]
  def get("&UpTee;"), do: [8869]
  def get("&UpTeeArrow;"), do: [8613]
  def get("&Uparrow;"), do: [8657]
  def get("&Updownarrow;"), do: [8661]
  def get("&UpperLeftArrow;"), do: [8598]
  def get("&UpperRightArrow;"), do: [8599]
  def get("&Upsi;"), do: [978]
  def get("&Upsilon;"), do: [933]
  def get("&Uring;"), do: [366]
  def get("&Uscr;"), do: [119_984]
  def get("&Utilde;"), do: [360]
  def get("&Uuml"), do: [220]
  def get("&Uuml;"), do: [220]
  def get("&VDash;"), do: [8875]
  def get("&Vbar;"), do: [10987]
  def get("&Vcy;"), do: [1042]
  def get("&Vdash;"), do: [8873]
  def get("&Vdashl;"), do: [10982]
  def get("&Vee;"), do: [8897]
  def get("&Verbar;"), do: [8214]
  def get("&Vert;"), do: [8214]
  def get("&VerticalBar;"), do: [8739]
  def get("&VerticalLine;"), do: [124]
  def get("&VerticalSeparator;"), do: [10072]
  def get("&VerticalTilde;"), do: [8768]
  def get("&VeryThinSpace;"), do: [8202]
  def get("&Vfr;"), do: [120_089]
  def get("&Vopf;"), do: [120_141]
  def get("&Vscr;"), do: [119_985]
  def get("&Vvdash;"), do: [8874]
  def get("&Wcirc;"), do: [372]
  def get("&Wedge;"), do: [8896]
  def get("&Wfr;"), do: [120_090]
  def get("&Wopf;"), do: [120_142]
  def get("&Wscr;"), do: [119_986]
  def get("&Xfr;"), do: [120_091]
  def get("&Xi;"), do: [926]
  def get("&Xopf;"), do: [120_143]
  def get("&Xscr;"), do: [119_987]
  def get("&YAcy;"), do: [1071]
  def get("&YIcy;"), do: [1031]
  def get("&YUcy;"), do: [1070]
  def get("&Yacute"), do: [221]
  def get("&Yacute;"), do: [221]
  def get("&Ycirc;"), do: [374]
  def get("&Ycy;"), do: [1067]
  def get("&Yfr;"), do: [120_092]
  def get("&Yopf;"), do: [120_144]
  def get("&Yscr;"), do: [119_988]
  def get("&Yuml;"), do: [376]
  def get("&ZHcy;"), do: [1046]
  def get("&Zacute;"), do: [377]
  def get("&Zcaron;"), do: [381]
  def get("&Zcy;"), do: [1047]
  def get("&Zdot;"), do: [379]
  def get("&ZeroWidthSpace;"), do: [8203]
  def get("&Zeta;"), do: [918]
  def get("&Zfr;"), do: [8488]
  def get("&Zopf;"), do: [8484]
  def get("&Zscr;"), do: [119_989]
  def get("&aacute"), do: [225]
  def get("&aacute;"), do: [225]
  def get("&abreve;"), do: [259]
  def get("&ac;"), do: [8766]
  def get("&acE;"), do: [8766, 819]
  def get("&acd;"), do: [8767]
  def get("&acirc"), do: [226]
  def get("&acirc;"), do: [226]
  def get("&acute"), do: [180]
  def get("&acute;"), do: [180]
  def get("&acy;"), do: [1072]
  def get("&aelig"), do: [230]
  def get("&aelig;"), do: [230]
  def get("&af;"), do: [8289]
  def get("&afr;"), do: [120_094]
  def get("&agrave"), do: [224]
  def get("&agrave;"), do: [224]
  def get("&alefsym;"), do: [8501]
  def get("&aleph;"), do: [8501]
  def get("&alpha;"), do: [945]
  def get("&amacr;"), do: [257]
  def get("&amalg;"), do: [10815]
  def get("&amp"), do: [38]
  def get("&amp;"), do: [38]
  def get("&and;"), do: [8743]
  def get("&andand;"), do: [10837]
  def get("&andd;"), do: [10844]
  def get("&andslope;"), do: [10840]
  def get("&andv;"), do: [10842]
  def get("&ang;"), do: [8736]
  def get("&ange;"), do: [10660]
  def get("&angle;"), do: [8736]
  def get("&angmsd;"), do: [8737]
  def get("&angmsdaa;"), do: [10664]
  def get("&angmsdab;"), do: [10665]
  def get("&angmsdac;"), do: [10666]
  def get("&angmsdad;"), do: [10667]
  def get("&angmsdae;"), do: [10668]
  def get("&angmsdaf;"), do: [10669]
  def get("&angmsdag;"), do: [10670]
  def get("&angmsdah;"), do: [10671]
  def get("&angrt;"), do: [8735]
  def get("&angrtvb;"), do: [8894]
  def get("&angrtvbd;"), do: [10653]
  def get("&angsph;"), do: [8738]
  def get("&angst;"), do: [197]
  def get("&angzarr;"), do: [9084]
  def get("&aogon;"), do: [261]
  def get("&aopf;"), do: [120_146]
  def get("&ap;"), do: [8776]
  def get("&apE;"), do: [10864]
  def get("&apacir;"), do: [10863]
  def get("&ape;"), do: [8778]
  def get("&apid;"), do: [8779]
  def get("&apos;"), do: [39]
  def get("&approx;"), do: [8776]
  def get("&approxeq;"), do: [8778]
  def get("&aring"), do: [229]
  def get("&aring;"), do: [229]
  def get("&ascr;"), do: [119_990]
  def get("&ast;"), do: [42]
  def get("&asymp;"), do: [8776]
  def get("&asympeq;"), do: [8781]
  def get("&atilde"), do: [227]
  def get("&atilde;"), do: [227]
  def get("&auml"), do: [228]
  def get("&auml;"), do: [228]
  def get("&awconint;"), do: [8755]
  def get("&awint;"), do: [10769]
  def get("&bNot;"), do: [10989]
  def get("&backcong;"), do: [8780]
  def get("&backepsilon;"), do: [1014]
  def get("&backprime;"), do: [8245]
  def get("&backsim;"), do: [8765]
  def get("&backsimeq;"), do: [8909]
  def get("&barvee;"), do: [8893]
  def get("&barwed;"), do: [8965]
  def get("&barwedge;"), do: [8965]
  def get("&bbrk;"), do: [9141]
  def get("&bbrktbrk;"), do: [9142]
  def get("&bcong;"), do: [8780]
  def get("&bcy;"), do: [1073]
  def get("&bdquo;"), do: [8222]
  def get("&becaus;"), do: [8757]
  def get("&because;"), do: [8757]
  def get("&bemptyv;"), do: [10672]
  def get("&bepsi;"), do: [1014]
  def get("&bernou;"), do: [8492]
  def get("&beta;"), do: [946]
  def get("&beth;"), do: [8502]
  def get("&between;"), do: [8812]
  def get("&bfr;"), do: [120_095]
  def get("&bigcap;"), do: [8898]
  def get("&bigcirc;"), do: [9711]
  def get("&bigcup;"), do: [8899]
  def get("&bigodot;"), do: [10752]
  def get("&bigoplus;"), do: [10753]
  def get("&bigotimes;"), do: [10754]
  def get("&bigsqcup;"), do: [10758]
  def get("&bigstar;"), do: [9733]
  def get("&bigtriangledown;"), do: [9661]
  def get("&bigtriangleup;"), do: [9651]
  def get("&biguplus;"), do: [10756]
  def get("&bigvee;"), do: [8897]
  def get("&bigwedge;"), do: [8896]
  def get("&bkarow;"), do: [10509]
  def get("&blacklozenge;"), do: [10731]
  def get("&blacksquare;"), do: [9642]
  def get("&blacktriangle;"), do: [9652]
  def get("&blacktriangledown;"), do: [9662]
  def get("&blacktriangleleft;"), do: [9666]
  def get("&blacktriangleright;"), do: [9656]
  def get("&blank;"), do: [9251]
  def get("&blk12;"), do: [9618]
  def get("&blk14;"), do: [9617]
  def get("&blk34;"), do: [9619]
  def get("&block;"), do: [9608]
  def get("&bne;"), do: [61, 8421]
  def get("&bnequiv;"), do: [8801, 8421]
  def get("&bnot;"), do: [8976]
  def get("&bopf;"), do: [120_147]
  def get("&bot;"), do: [8869]
  def get("&bottom;"), do: [8869]
  def get("&bowtie;"), do: [8904]
  def get("&boxDL;"), do: [9559]
  def get("&boxDR;"), do: [9556]
  def get("&boxDl;"), do: [9558]
  def get("&boxDr;"), do: [9555]
  def get("&boxH;"), do: [9552]
  def get("&boxHD;"), do: [9574]
  def get("&boxHU;"), do: [9577]
  def get("&boxHd;"), do: [9572]
  def get("&boxHu;"), do: [9575]
  def get("&boxUL;"), do: [9565]
  def get("&boxUR;"), do: [9562]
  def get("&boxUl;"), do: [9564]
  def get("&boxUr;"), do: [9561]
  def get("&boxV;"), do: [9553]
  def get("&boxVH;"), do: [9580]
  def get("&boxVL;"), do: [9571]
  def get("&boxVR;"), do: [9568]
  def get("&boxVh;"), do: [9579]
  def get("&boxVl;"), do: [9570]
  def get("&boxVr;"), do: [9567]
  def get("&boxbox;"), do: [10697]
  def get("&boxdL;"), do: [9557]
  def get("&boxdR;"), do: [9554]
  def get("&boxdl;"), do: [9488]
  def get("&boxdr;"), do: [9484]
  def get("&boxh;"), do: [9472]
  def get("&boxhD;"), do: [9573]
  def get("&boxhU;"), do: [9576]
  def get("&boxhd;"), do: [9516]
  def get("&boxhu;"), do: [9524]
  def get("&boxminus;"), do: [8863]
  def get("&boxplus;"), do: [8862]
  def get("&boxtimes;"), do: [8864]
  def get("&boxuL;"), do: [9563]
  def get("&boxuR;"), do: [9560]
  def get("&boxul;"), do: [9496]
  def get("&boxur;"), do: [9492]
  def get("&boxv;"), do: [9474]
  def get("&boxvH;"), do: [9578]
  def get("&boxvL;"), do: [9569]
  def get("&boxvR;"), do: [9566]
  def get("&boxvh;"), do: [9532]
  def get("&boxvl;"), do: [9508]
  def get("&boxvr;"), do: [9500]
  def get("&bprime;"), do: [8245]
  def get("&breve;"), do: [728]
  def get("&brvbar"), do: [166]
  def get("&brvbar;"), do: [166]
  def get("&bscr;"), do: [119_991]
  def get("&bsemi;"), do: [8271]
  def get("&bsim;"), do: [8765]
  def get("&bsime;"), do: [8909]
  def get("&bsol;"), do: [92]
  def get("&bsolb;"), do: [10693]
  def get("&bsolhsub;"), do: [10184]
  def get("&bull;"), do: [8226]
  def get("&bullet;"), do: [8226]
  def get("&bump;"), do: [8782]
  def get("&bumpE;"), do: [10926]
  def get("&bumpe;"), do: [8783]
  def get("&bumpeq;"), do: [8783]
  def get("&cacute;"), do: [263]
  def get("&cap;"), do: [8745]
  def get("&capand;"), do: [10820]
  def get("&capbrcup;"), do: [10825]
  def get("&capcap;"), do: [10827]
  def get("&capcup;"), do: [10823]
  def get("&capdot;"), do: [10816]
  def get("&caps;"), do: [8745, 65024]
  def get("&caret;"), do: [8257]
  def get("&caron;"), do: [711]
  def get("&ccaps;"), do: [10829]
  def get("&ccaron;"), do: [269]
  def get("&ccedil"), do: [231]
  def get("&ccedil;"), do: [231]
  def get("&ccirc;"), do: [265]
  def get("&ccups;"), do: [10828]
  def get("&ccupssm;"), do: [10832]
  def get("&cdot;"), do: [267]
  def get("&cedil"), do: [184]
  def get("&cedil;"), do: [184]
  def get("&cemptyv;"), do: [10674]
  def get("&cent"), do: [162]
  def get("&cent;"), do: [162]
  def get("&centerdot;"), do: [183]
  def get("&cfr;"), do: [120_096]
  def get("&chcy;"), do: [1095]
  def get("&check;"), do: [10003]
  def get("&checkmark;"), do: [10003]
  def get("&chi;"), do: [967]
  def get("&cir;"), do: [9675]
  def get("&cirE;"), do: [10691]
  def get("&circ;"), do: [710]
  def get("&circeq;"), do: [8791]
  def get("&circlearrowleft;"), do: [8634]
  def get("&circlearrowright;"), do: [8635]
  def get("&circledR;"), do: [174]
  def get("&circledS;"), do: [9416]
  def get("&circledast;"), do: [8859]
  def get("&circledcirc;"), do: [8858]
  def get("&circleddash;"), do: [8861]
  def get("&cire;"), do: [8791]
  def get("&cirfnint;"), do: [10768]
  def get("&cirmid;"), do: [10991]
  def get("&cirscir;"), do: [10690]
  def get("&clubs;"), do: [9827]
  def get("&clubsuit;"), do: [9827]
  def get("&colon;"), do: [58]
  def get("&colone;"), do: [8788]
  def get("&coloneq;"), do: [8788]
  def get("&comma;"), do: [44]
  def get("&commat;"), do: [64]
  def get("&comp;"), do: [8705]
  def get("&compfn;"), do: [8728]
  def get("&complement;"), do: [8705]
  def get("&complexes;"), do: [8450]
  def get("&cong;"), do: [8773]
  def get("&congdot;"), do: [10861]
  def get("&conint;"), do: [8750]
  def get("&copf;"), do: [120_148]
  def get("&coprod;"), do: [8720]
  def get("&copy"), do: [169]
  def get("&copy;"), do: [169]
  def get("&copysr;"), do: [8471]
  def get("&crarr;"), do: [8629]
  def get("&cross;"), do: [10007]
  def get("&cscr;"), do: [119_992]
  def get("&csub;"), do: [10959]
  def get("&csube;"), do: [10961]
  def get("&csup;"), do: [10960]
  def get("&csupe;"), do: [10962]
  def get("&ctdot;"), do: [8943]
  def get("&cudarrl;"), do: [10552]
  def get("&cudarrr;"), do: [10549]
  def get("&cuepr;"), do: [8926]
  def get("&cuesc;"), do: [8927]
  def get("&cularr;"), do: [8630]
  def get("&cularrp;"), do: [10557]
  def get("&cup;"), do: [8746]
  def get("&cupbrcap;"), do: [10824]
  def get("&cupcap;"), do: [10822]
  def get("&cupcup;"), do: [10826]
  def get("&cupdot;"), do: [8845]
  def get("&cupor;"), do: [10821]
  def get("&cups;"), do: [8746, 65024]
  def get("&curarr;"), do: [8631]
  def get("&curarrm;"), do: [10556]
  def get("&curlyeqprec;"), do: [8926]
  def get("&curlyeqsucc;"), do: [8927]
  def get("&curlyvee;"), do: [8910]
  def get("&curlywedge;"), do: [8911]
  def get("&curren"), do: [164]
  def get("&curren;"), do: [164]
  def get("&curvearrowleft;"), do: [8630]
  def get("&curvearrowright;"), do: [8631]
  def get("&cuvee;"), do: [8910]
  def get("&cuwed;"), do: [8911]
  def get("&cwconint;"), do: [8754]
  def get("&cwint;"), do: [8753]
  def get("&cylcty;"), do: [9005]
  def get("&dArr;"), do: [8659]
  def get("&dHar;"), do: [10597]
  def get("&dagger;"), do: [8224]
  def get("&daleth;"), do: [8504]
  def get("&darr;"), do: [8595]
  def get("&dash;"), do: [8208]
  def get("&dashv;"), do: [8867]
  def get("&dbkarow;"), do: [10511]
  def get("&dblac;"), do: [733]
  def get("&dcaron;"), do: [271]
  def get("&dcy;"), do: [1076]
  def get("&dd;"), do: [8518]
  def get("&ddagger;"), do: [8225]
  def get("&ddarr;"), do: [8650]
  def get("&ddotseq;"), do: [10871]
  def get("&deg"), do: [176]
  def get("&deg;"), do: [176]
  def get("&delta;"), do: [948]
  def get("&demptyv;"), do: [10673]
  def get("&dfisht;"), do: [10623]
  def get("&dfr;"), do: [120_097]
  def get("&dharl;"), do: [8643]
  def get("&dharr;"), do: [8642]
  def get("&diam;"), do: [8900]
  def get("&diamond;"), do: [8900]
  def get("&diamondsuit;"), do: [9830]
  def get("&diams;"), do: [9830]
  def get("&die;"), do: [168]
  def get("&digamma;"), do: [989]
  def get("&disin;"), do: [8946]
  def get("&div;"), do: [247]
  def get("&divide"), do: [247]
  def get("&divide;"), do: [247]
  def get("&divideontimes;"), do: [8903]
  def get("&divonx;"), do: [8903]
  def get("&djcy;"), do: [1106]
  def get("&dlcorn;"), do: [8990]
  def get("&dlcrop;"), do: [8973]
  def get("&dollar;"), do: [36]
  def get("&dopf;"), do: [120_149]
  def get("&dot;"), do: [729]
  def get("&doteq;"), do: [8784]
  def get("&doteqdot;"), do: [8785]
  def get("&dotminus;"), do: [8760]
  def get("&dotplus;"), do: [8724]
  def get("&dotsquare;"), do: [8865]
  def get("&doublebarwedge;"), do: [8966]
  def get("&downarrow;"), do: [8595]
  def get("&downdownarrows;"), do: [8650]
  def get("&downharpoonleft;"), do: [8643]
  def get("&downharpoonright;"), do: [8642]
  def get("&drbkarow;"), do: [10512]
  def get("&drcorn;"), do: [8991]
  def get("&drcrop;"), do: [8972]
  def get("&dscr;"), do: [119_993]
  def get("&dscy;"), do: [1109]
  def get("&dsol;"), do: [10742]
  def get("&dstrok;"), do: [273]
  def get("&dtdot;"), do: [8945]
  def get("&dtri;"), do: [9663]
  def get("&dtrif;"), do: [9662]
  def get("&duarr;"), do: [8693]
  def get("&duhar;"), do: [10607]
  def get("&dwangle;"), do: [10662]
  def get("&dzcy;"), do: [1119]
  def get("&dzigrarr;"), do: [10239]
  def get("&eDDot;"), do: [10871]
  def get("&eDot;"), do: [8785]
  def get("&eacute"), do: [233]
  def get("&eacute;"), do: [233]
  def get("&easter;"), do: [10862]
  def get("&ecaron;"), do: [283]
  def get("&ecir;"), do: [8790]
  def get("&ecirc"), do: [234]
  def get("&ecirc;"), do: [234]
  def get("&ecolon;"), do: [8789]
  def get("&ecy;"), do: [1101]
  def get("&edot;"), do: [279]
  def get("&ee;"), do: [8519]
  def get("&efDot;"), do: [8786]
  def get("&efr;"), do: [120_098]
  def get("&eg;"), do: [10906]
  def get("&egrave"), do: [232]
  def get("&egrave;"), do: [232]
  def get("&egs;"), do: [10902]
  def get("&egsdot;"), do: [10904]
  def get("&el;"), do: [10905]
  def get("&elinters;"), do: [9191]
  def get("&ell;"), do: [8467]
  def get("&els;"), do: [10901]
  def get("&elsdot;"), do: [10903]
  def get("&emacr;"), do: [275]
  def get("&empty;"), do: [8709]
  def get("&emptyset;"), do: [8709]
  def get("&emptyv;"), do: [8709]
  def get("&emsp13;"), do: [8196]
  def get("&emsp14;"), do: [8197]
  def get("&emsp;"), do: [8195]
  def get("&eng;"), do: [331]
  def get("&ensp;"), do: [8194]
  def get("&eogon;"), do: [281]
  def get("&eopf;"), do: [120_150]
  def get("&epar;"), do: [8917]
  def get("&eparsl;"), do: [10723]
  def get("&eplus;"), do: [10865]
  def get("&epsi;"), do: [949]
  def get("&epsilon;"), do: [949]
  def get("&epsiv;"), do: [1013]
  def get("&eqcirc;"), do: [8790]
  def get("&eqcolon;"), do: [8789]
  def get("&eqsim;"), do: [8770]
  def get("&eqslantgtr;"), do: [10902]
  def get("&eqslantless;"), do: [10901]
  def get("&equals;"), do: [61]
  def get("&equest;"), do: [8799]
  def get("&equiv;"), do: [8801]
  def get("&equivDD;"), do: [10872]
  def get("&eqvparsl;"), do: [10725]
  def get("&erDot;"), do: [8787]
  def get("&erarr;"), do: [10609]
  def get("&escr;"), do: [8495]
  def get("&esdot;"), do: [8784]
  def get("&esim;"), do: [8770]
  def get("&eta;"), do: [951]
  def get("&eth"), do: [240]
  def get("&eth;"), do: [240]
  def get("&euml"), do: [235]
  def get("&euml;"), do: [235]
  def get("&euro;"), do: [8364]
  def get("&excl;"), do: [33]
  def get("&exist;"), do: [8707]
  def get("&expectation;"), do: [8496]
  def get("&exponentiale;"), do: [8519]
  def get("&fallingdotseq;"), do: [8786]
  def get("&fcy;"), do: [1092]
  def get("&female;"), do: [9792]
  def get("&ffilig;"), do: [64259]
  def get("&fflig;"), do: [64256]
  def get("&ffllig;"), do: [64260]
  def get("&ffr;"), do: [120_099]
  def get("&filig;"), do: [64257]
  def get("&fjlig;"), do: [102, 106]
  def get("&flat;"), do: [9837]
  def get("&fllig;"), do: [64258]
  def get("&fltns;"), do: [9649]
  def get("&fnof;"), do: [402]
  def get("&fopf;"), do: [120_151]
  def get("&forall;"), do: [8704]
  def get("&fork;"), do: [8916]
  def get("&forkv;"), do: [10969]
  def get("&fpartint;"), do: [10765]
  def get("&frac12"), do: [189]
  def get("&frac12;"), do: [189]
  def get("&frac13;"), do: [8531]
  def get("&frac14"), do: [188]
  def get("&frac14;"), do: [188]
  def get("&frac15;"), do: [8533]
  def get("&frac16;"), do: [8537]
  def get("&frac18;"), do: [8539]
  def get("&frac23;"), do: [8532]
  def get("&frac25;"), do: [8534]
  def get("&frac34"), do: [190]
  def get("&frac34;"), do: [190]
  def get("&frac35;"), do: [8535]
  def get("&frac38;"), do: [8540]
  def get("&frac45;"), do: [8536]
  def get("&frac56;"), do: [8538]
  def get("&frac58;"), do: [8541]
  def get("&frac78;"), do: [8542]
  def get("&frasl;"), do: [8260]
  def get("&frown;"), do: [8994]
  def get("&fscr;"), do: [119_995]
  def get("&gE;"), do: [8807]
  def get("&gEl;"), do: [10892]
  def get("&gacute;"), do: [501]
  def get("&gamma;"), do: [947]
  def get("&gammad;"), do: [989]
  def get("&gap;"), do: [10886]
  def get("&gbreve;"), do: [287]
  def get("&gcirc;"), do: [285]
  def get("&gcy;"), do: [1075]
  def get("&gdot;"), do: [289]
  def get("&ge;"), do: [8805]
  def get("&gel;"), do: [8923]
  def get("&geq;"), do: [8805]
  def get("&geqq;"), do: [8807]
  def get("&geqslant;"), do: [10878]
  def get("&ges;"), do: [10878]
  def get("&gescc;"), do: [10921]
  def get("&gesdot;"), do: [10880]
  def get("&gesdoto;"), do: [10882]
  def get("&gesdotol;"), do: [10884]
  def get("&gesl;"), do: [8923, 65024]
  def get("&gesles;"), do: [10900]
  def get("&gfr;"), do: [120_100]
  def get("&gg;"), do: [8811]
  def get("&ggg;"), do: [8921]
  def get("&gimel;"), do: [8503]
  def get("&gjcy;"), do: [1107]
  def get("&gl;"), do: [8823]
  def get("&glE;"), do: [10898]
  def get("&gla;"), do: [10917]
  def get("&glj;"), do: [10916]
  def get("&gnE;"), do: [8809]
  def get("&gnap;"), do: [10890]
  def get("&gnapprox;"), do: [10890]
  def get("&gne;"), do: [10888]
  def get("&gneq;"), do: [10888]
  def get("&gneqq;"), do: [8809]
  def get("&gnsim;"), do: [8935]
  def get("&gopf;"), do: [120_152]
  def get("&grave;"), do: [96]
  def get("&gscr;"), do: [8458]
  def get("&gsim;"), do: [8819]
  def get("&gsime;"), do: [10894]
  def get("&gsiml;"), do: [10896]
  def get("&gt"), do: [62]
  def get("&gt;"), do: [62]
  def get("&gtcc;"), do: [10919]
  def get("&gtcir;"), do: [10874]
  def get("&gtdot;"), do: [8919]
  def get("&gtlPar;"), do: [10645]
  def get("&gtquest;"), do: [10876]
  def get("&gtrapprox;"), do: [10886]
  def get("&gtrarr;"), do: [10616]
  def get("&gtrdot;"), do: [8919]
  def get("&gtreqless;"), do: [8923]
  def get("&gtreqqless;"), do: [10892]
  def get("&gtrless;"), do: [8823]
  def get("&gtrsim;"), do: [8819]
  def get("&gvertneqq;"), do: [8809, 65024]
  def get("&gvnE;"), do: [8809, 65024]
  def get("&hArr;"), do: [8660]
  def get("&hairsp;"), do: [8202]
  def get("&half;"), do: [189]
  def get("&hamilt;"), do: [8459]
  def get("&hardcy;"), do: [1098]
  def get("&harr;"), do: [8596]
  def get("&harrcir;"), do: [10568]
  def get("&harrw;"), do: [8621]
  def get("&hbar;"), do: [8463]
  def get("&hcirc;"), do: [293]
  def get("&hearts;"), do: [9829]
  def get("&heartsuit;"), do: [9829]
  def get("&hellip;"), do: [8230]
  def get("&hercon;"), do: [8889]
  def get("&hfr;"), do: [120_101]
  def get("&hksearow;"), do: [10533]
  def get("&hkswarow;"), do: [10534]
  def get("&hoarr;"), do: [8703]
  def get("&homtht;"), do: [8763]
  def get("&hookleftarrow;"), do: [8617]
  def get("&hookrightarrow;"), do: [8618]
  def get("&hopf;"), do: [120_153]
  def get("&horbar;"), do: [8213]
  def get("&hscr;"), do: [119_997]
  def get("&hslash;"), do: [8463]
  def get("&hstrok;"), do: [295]
  def get("&hybull;"), do: [8259]
  def get("&hyphen;"), do: [8208]
  def get("&iacute"), do: [237]
  def get("&iacute;"), do: [237]
  def get("&ic;"), do: [8291]
  def get("&icirc"), do: [238]
  def get("&icirc;"), do: [238]
  def get("&icy;"), do: [1080]
  def get("&iecy;"), do: [1077]
  def get("&iexcl"), do: [161]
  def get("&iexcl;"), do: [161]
  def get("&iff;"), do: [8660]
  def get("&ifr;"), do: [120_102]
  def get("&igrave"), do: [236]
  def get("&igrave;"), do: [236]
  def get("&ii;"), do: [8520]
  def get("&iiiint;"), do: [10764]
  def get("&iiint;"), do: [8749]
  def get("&iinfin;"), do: [10716]
  def get("&iiota;"), do: [8489]
  def get("&ijlig;"), do: [307]
  def get("&imacr;"), do: [299]
  def get("&image;"), do: [8465]
  def get("&imagline;"), do: [8464]
  def get("&imagpart;"), do: [8465]
  def get("&imath;"), do: [305]
  def get("&imof;"), do: [8887]
  def get("&imped;"), do: [437]
  def get("&in;"), do: [8712]
  def get("&incare;"), do: [8453]
  def get("&infin;"), do: [8734]
  def get("&infintie;"), do: [10717]
  def get("&inodot;"), do: [305]
  def get("&int;"), do: [8747]
  def get("&intcal;"), do: [8890]
  def get("&integers;"), do: [8484]
  def get("&intercal;"), do: [8890]
  def get("&intlarhk;"), do: [10775]
  def get("&intprod;"), do: [10812]
  def get("&iocy;"), do: [1105]
  def get("&iogon;"), do: [303]
  def get("&iopf;"), do: [120_154]
  def get("&iota;"), do: [953]
  def get("&iprod;"), do: [10812]
  def get("&iquest"), do: [191]
  def get("&iquest;"), do: [191]
  def get("&iscr;"), do: [119_998]
  def get("&isin;"), do: [8712]
  def get("&isinE;"), do: [8953]
  def get("&isindot;"), do: [8949]
  def get("&isins;"), do: [8948]
  def get("&isinsv;"), do: [8947]
  def get("&isinv;"), do: [8712]
  def get("&it;"), do: [8290]
  def get("&itilde;"), do: [297]
  def get("&iukcy;"), do: [1110]
  def get("&iuml"), do: [239]
  def get("&iuml;"), do: [239]
  def get("&jcirc;"), do: [309]
  def get("&jcy;"), do: [1081]
  def get("&jfr;"), do: [120_103]
  def get("&jmath;"), do: [567]
  def get("&jopf;"), do: [120_155]
  def get("&jscr;"), do: [119_999]
  def get("&jsercy;"), do: [1112]
  def get("&jukcy;"), do: [1108]
  def get("&kappa;"), do: [954]
  def get("&kappav;"), do: [1008]
  def get("&kcedil;"), do: [311]
  def get("&kcy;"), do: [1082]
  def get("&kfr;"), do: [120_104]
  def get("&kgreen;"), do: [312]
  def get("&khcy;"), do: [1093]
  def get("&kjcy;"), do: [1116]
  def get("&kopf;"), do: [120_156]
  def get("&kscr;"), do: [120_000]
  def get("&lAarr;"), do: [8666]
  def get("&lArr;"), do: [8656]
  def get("&lAtail;"), do: [10523]
  def get("&lBarr;"), do: [10510]
  def get("&lE;"), do: [8806]
  def get("&lEg;"), do: [10891]
  def get("&lHar;"), do: [10594]
  def get("&lacute;"), do: [314]
  def get("&laemptyv;"), do: [10676]
  def get("&lagran;"), do: [8466]
  def get("&lambda;"), do: [955]
  def get("&lang;"), do: [10216]
  def get("&langd;"), do: [10641]
  def get("&langle;"), do: [10216]
  def get("&lap;"), do: [10885]
  def get("&laquo"), do: [171]
  def get("&laquo;"), do: [171]
  def get("&larr;"), do: [8592]
  def get("&larrb;"), do: [8676]
  def get("&larrbfs;"), do: [10527]
  def get("&larrfs;"), do: [10525]
  def get("&larrhk;"), do: [8617]
  def get("&larrlp;"), do: [8619]
  def get("&larrpl;"), do: [10553]
  def get("&larrsim;"), do: [10611]
  def get("&larrtl;"), do: [8610]
  def get("&lat;"), do: [10923]
  def get("&latail;"), do: [10521]
  def get("&late;"), do: [10925]
  def get("&lates;"), do: [10925, 65024]
  def get("&lbarr;"), do: [10508]
  def get("&lbbrk;"), do: [10098]
  def get("&lbrace;"), do: [123]
  def get("&lbrack;"), do: [91]
  def get("&lbrke;"), do: [10635]
  def get("&lbrksld;"), do: [10639]
  def get("&lbrkslu;"), do: [10637]
  def get("&lcaron;"), do: [318]
  def get("&lcedil;"), do: [316]
  def get("&lceil;"), do: [8968]
  def get("&lcub;"), do: [123]
  def get("&lcy;"), do: [1083]
  def get("&ldca;"), do: [10550]
  def get("&ldquo;"), do: [8220]
  def get("&ldquor;"), do: [8222]
  def get("&ldrdhar;"), do: [10599]
  def get("&ldrushar;"), do: [10571]
  def get("&ldsh;"), do: [8626]
  def get("&le;"), do: [8804]
  def get("&leftarrow;"), do: [8592]
  def get("&leftarrowtail;"), do: [8610]
  def get("&leftharpoondown;"), do: [8637]
  def get("&leftharpoonup;"), do: [8636]
  def get("&leftleftarrows;"), do: [8647]
  def get("&leftrightarrow;"), do: [8596]
  def get("&leftrightarrows;"), do: [8646]
  def get("&leftrightharpoons;"), do: [8651]
  def get("&leftrightsquigarrow;"), do: [8621]
  def get("&leftthreetimes;"), do: [8907]
  def get("&leg;"), do: [8922]
  def get("&leq;"), do: [8804]
  def get("&leqq;"), do: [8806]
  def get("&leqslant;"), do: [10877]
  def get("&les;"), do: [10877]
  def get("&lescc;"), do: [10920]
  def get("&lesdot;"), do: [10879]
  def get("&lesdoto;"), do: [10881]
  def get("&lesdotor;"), do: [10883]
  def get("&lesg;"), do: [8922, 65024]
  def get("&lesges;"), do: [10899]
  def get("&lessapprox;"), do: [10885]
  def get("&lessdot;"), do: [8918]
  def get("&lesseqgtr;"), do: [8922]
  def get("&lesseqqgtr;"), do: [10891]
  def get("&lessgtr;"), do: [8822]
  def get("&lesssim;"), do: [8818]
  def get("&lfisht;"), do: [10620]
  def get("&lfloor;"), do: [8970]
  def get("&lfr;"), do: [120_105]
  def get("&lg;"), do: [8822]
  def get("&lgE;"), do: [10897]
  def get("&lhard;"), do: [8637]
  def get("&lharu;"), do: [8636]
  def get("&lharul;"), do: [10602]
  def get("&lhblk;"), do: [9604]
  def get("&ljcy;"), do: [1113]
  def get("&ll;"), do: [8810]
  def get("&llarr;"), do: [8647]
  def get("&llcorner;"), do: [8990]
  def get("&llhard;"), do: [10603]
  def get("&lltri;"), do: [9722]
  def get("&lmidot;"), do: [320]
  def get("&lmoust;"), do: [9136]
  def get("&lmoustache;"), do: [9136]
  def get("&lnE;"), do: [8808]
  def get("&lnap;"), do: [10889]
  def get("&lnapprox;"), do: [10889]
  def get("&lne;"), do: [10887]
  def get("&lneq;"), do: [10887]
  def get("&lneqq;"), do: [8808]
  def get("&lnsim;"), do: [8934]
  def get("&loang;"), do: [10220]
  def get("&loarr;"), do: [8701]
  def get("&lobrk;"), do: [10214]
  def get("&longleftarrow;"), do: [10229]
  def get("&longleftrightarrow;"), do: [10231]
  def get("&longmapsto;"), do: [10236]
  def get("&longrightarrow;"), do: [10230]
  def get("&looparrowleft;"), do: [8619]
  def get("&looparrowright;"), do: [8620]
  def get("&lopar;"), do: [10629]
  def get("&lopf;"), do: [120_157]
  def get("&loplus;"), do: [10797]
  def get("&lotimes;"), do: [10804]
  def get("&lowast;"), do: [8727]
  def get("&lowbar;"), do: [95]
  def get("&loz;"), do: [9674]
  def get("&lozenge;"), do: [9674]
  def get("&lozf;"), do: [10731]
  def get("&lpar;"), do: [40]
  def get("&lparlt;"), do: [10643]
  def get("&lrarr;"), do: [8646]
  def get("&lrcorner;"), do: [8991]
  def get("&lrhar;"), do: [8651]
  def get("&lrhard;"), do: [10605]
  def get("&lrm;"), do: [8206]
  def get("&lrtri;"), do: [8895]
  def get("&lsaquo;"), do: [8249]
  def get("&lscr;"), do: [120_001]
  def get("&lsh;"), do: [8624]
  def get("&lsim;"), do: [8818]
  def get("&lsime;"), do: [10893]
  def get("&lsimg;"), do: [10895]
  def get("&lsqb;"), do: [91]
  def get("&lsquo;"), do: [8216]
  def get("&lsquor;"), do: [8218]
  def get("&lstrok;"), do: [322]
  def get("&lt"), do: [60]
  def get("&lt;"), do: [60]
  def get("&ltcc;"), do: [10918]
  def get("&ltcir;"), do: [10873]
  def get("&ltdot;"), do: [8918]
  def get("&lthree;"), do: [8907]
  def get("&ltimes;"), do: [8905]
  def get("&ltlarr;"), do: [10614]
  def get("&ltquest;"), do: [10875]
  def get("&ltrPar;"), do: [10646]
  def get("&ltri;"), do: [9667]
  def get("&ltrie;"), do: [8884]
  def get("&ltrif;"), do: [9666]
  def get("&lurdshar;"), do: [10570]
  def get("&luruhar;"), do: [10598]
  def get("&lvertneqq;"), do: [8808, 65024]
  def get("&lvnE;"), do: [8808, 65024]
  def get("&mDDot;"), do: [8762]
  def get("&macr"), do: [175]
  def get("&macr;"), do: [175]
  def get("&male;"), do: [9794]
  def get("&malt;"), do: [10016]
  def get("&maltese;"), do: [10016]
  def get("&map;"), do: [8614]
  def get("&mapsto;"), do: [8614]
  def get("&mapstodown;"), do: [8615]
  def get("&mapstoleft;"), do: [8612]
  def get("&mapstoup;"), do: [8613]
  def get("&marker;"), do: [9646]
  def get("&mcomma;"), do: [10793]
  def get("&mcy;"), do: [1084]
  def get("&mdash;"), do: [8212]
  def get("&measuredangle;"), do: [8737]
  def get("&mfr;"), do: [120_106]
  def get("&mho;"), do: [8487]
  def get("&micro"), do: [181]
  def get("&micro;"), do: [181]
  def get("&mid;"), do: [8739]
  def get("&midast;"), do: [42]
  def get("&midcir;"), do: [10992]
  def get("&middot"), do: [183]
  def get("&middot;"), do: [183]
  def get("&minus;"), do: [8722]
  def get("&minusb;"), do: [8863]
  def get("&minusd;"), do: [8760]
  def get("&minusdu;"), do: [10794]
  def get("&mlcp;"), do: [10971]
  def get("&mldr;"), do: [8230]
  def get("&mnplus;"), do: [8723]
  def get("&models;"), do: [8871]
  def get("&mopf;"), do: [120_158]
  def get("&mp;"), do: [8723]
  def get("&mscr;"), do: [120_002]
  def get("&mstpos;"), do: [8766]
  def get("&mu;"), do: [956]
  def get("&multimap;"), do: [8888]
  def get("&mumap;"), do: [8888]
  def get("&nGg;"), do: [8921, 824]
  def get("&nGt;"), do: [8811, 8402]
  def get("&nGtv;"), do: [8811, 824]
  def get("&nLeftarrow;"), do: [8653]
  def get("&nLeftrightarrow;"), do: [8654]
  def get("&nLl;"), do: [8920, 824]
  def get("&nLt;"), do: [8810, 8402]
  def get("&nLtv;"), do: [8810, 824]
  def get("&nRightarrow;"), do: [8655]
  def get("&nVDash;"), do: [8879]
  def get("&nVdash;"), do: [8878]
  def get("&nabla;"), do: [8711]
  def get("&nacute;"), do: [324]
  def get("&nang;"), do: [8736, 8402]
  def get("&nap;"), do: [8777]
  def get("&napE;"), do: [10864, 824]
  def get("&napid;"), do: [8779, 824]
  def get("&napos;"), do: [329]
  def get("&napprox;"), do: [8777]
  def get("&natur;"), do: [9838]
  def get("&natural;"), do: [9838]
  def get("&naturals;"), do: [8469]
  def get("&nbsp"), do: [160]
  def get("&nbsp;"), do: [160]
  def get("&nbump;"), do: [8782, 824]
  def get("&nbumpe;"), do: [8783, 824]
  def get("&ncap;"), do: [10819]
  def get("&ncaron;"), do: [328]
  def get("&ncedil;"), do: [326]
  def get("&ncong;"), do: [8775]
  def get("&ncongdot;"), do: [10861, 824]
  def get("&ncup;"), do: [10818]
  def get("&ncy;"), do: [1085]
  def get("&ndash;"), do: [8211]
  def get("&ne;"), do: [8800]
  def get("&neArr;"), do: [8663]
  def get("&nearhk;"), do: [10532]
  def get("&nearr;"), do: [8599]
  def get("&nearrow;"), do: [8599]
  def get("&nedot;"), do: [8784, 824]
  def get("&nequiv;"), do: [8802]
  def get("&nesear;"), do: [10536]
  def get("&nesim;"), do: [8770, 824]
  def get("&nexist;"), do: [8708]
  def get("&nexists;"), do: [8708]
  def get("&nfr;"), do: [120_107]
  def get("&ngE;"), do: [8807, 824]
  def get("&nge;"), do: [8817]
  def get("&ngeq;"), do: [8817]
  def get("&ngeqq;"), do: [8807, 824]
  def get("&ngeqslant;"), do: [10878, 824]
  def get("&nges;"), do: [10878, 824]
  def get("&ngsim;"), do: [8821]
  def get("&ngt;"), do: [8815]
  def get("&ngtr;"), do: [8815]
  def get("&nhArr;"), do: [8654]
  def get("&nharr;"), do: [8622]
  def get("&nhpar;"), do: [10994]
  def get("&ni;"), do: [8715]
  def get("&nis;"), do: [8956]
  def get("&nisd;"), do: [8954]
  def get("&niv;"), do: [8715]
  def get("&njcy;"), do: [1114]
  def get("&nlArr;"), do: [8653]
  def get("&nlE;"), do: [8806, 824]
  def get("&nlarr;"), do: [8602]
  def get("&nldr;"), do: [8229]
  def get("&nle;"), do: [8816]
  def get("&nleftarrow;"), do: [8602]
  def get("&nleftrightarrow;"), do: [8622]
  def get("&nleq;"), do: [8816]
  def get("&nleqq;"), do: [8806, 824]
  def get("&nleqslant;"), do: [10877, 824]
  def get("&nles;"), do: [10877, 824]
  def get("&nless;"), do: [8814]
  def get("&nlsim;"), do: [8820]
  def get("&nlt;"), do: [8814]
  def get("&nltri;"), do: [8938]
  def get("&nltrie;"), do: [8940]
  def get("&nmid;"), do: [8740]
  def get("&nopf;"), do: [120_159]
  def get("&not"), do: [172]
  def get("&not;"), do: [172]
  def get("&notin;"), do: [8713]
  def get("&notinE;"), do: [8953, 824]
  def get("&notindot;"), do: [8949, 824]
  def get("&notinva;"), do: [8713]
  def get("&notinvb;"), do: [8951]
  def get("&notinvc;"), do: [8950]
  def get("&notni;"), do: [8716]
  def get("&notniva;"), do: [8716]
  def get("&notnivb;"), do: [8958]
  def get("&notnivc;"), do: [8957]
  def get("&npar;"), do: [8742]
  def get("&nparallel;"), do: [8742]
  def get("&nparsl;"), do: [11005, 8421]
  def get("&npart;"), do: [8706, 824]
  def get("&npolint;"), do: [10772]
  def get("&npr;"), do: [8832]
  def get("&nprcue;"), do: [8928]
  def get("&npre;"), do: [10927, 824]
  def get("&nprec;"), do: [8832]
  def get("&npreceq;"), do: [10927, 824]
  def get("&nrArr;"), do: [8655]
  def get("&nrarr;"), do: [8603]
  def get("&nrarrc;"), do: [10547, 824]
  def get("&nrarrw;"), do: [8605, 824]
  def get("&nrightarrow;"), do: [8603]
  def get("&nrtri;"), do: [8939]
  def get("&nrtrie;"), do: [8941]
  def get("&nsc;"), do: [8833]
  def get("&nsccue;"), do: [8929]
  def get("&nsce;"), do: [10928, 824]
  def get("&nscr;"), do: [120_003]
  def get("&nshortmid;"), do: [8740]
  def get("&nshortparallel;"), do: [8742]
  def get("&nsim;"), do: [8769]
  def get("&nsime;"), do: [8772]
  def get("&nsimeq;"), do: [8772]
  def get("&nsmid;"), do: [8740]
  def get("&nspar;"), do: [8742]
  def get("&nsqsube;"), do: [8930]
  def get("&nsqsupe;"), do: [8931]
  def get("&nsub;"), do: [8836]
  def get("&nsubE;"), do: [10949, 824]
  def get("&nsube;"), do: [8840]
  def get("&nsubset;"), do: [8834, 8402]
  def get("&nsubseteq;"), do: [8840]
  def get("&nsubseteqq;"), do: [10949, 824]
  def get("&nsucc;"), do: [8833]
  def get("&nsucceq;"), do: [10928, 824]
  def get("&nsup;"), do: [8837]
  def get("&nsupE;"), do: [10950, 824]
  def get("&nsupe;"), do: [8841]
  def get("&nsupset;"), do: [8835, 8402]
  def get("&nsupseteq;"), do: [8841]
  def get("&nsupseteqq;"), do: [10950, 824]
  def get("&ntgl;"), do: [8825]
  def get("&ntilde"), do: [241]
  def get("&ntilde;"), do: [241]
  def get("&ntlg;"), do: [8824]
  def get("&ntriangleleft;"), do: [8938]
  def get("&ntrianglelefteq;"), do: [8940]
  def get("&ntriangleright;"), do: [8939]
  def get("&ntrianglerighteq;"), do: [8941]
  def get("&nu;"), do: [957]
  def get("&num;"), do: [35]
  def get("&numero;"), do: [8470]
  def get("&numsp;"), do: [8199]
  def get("&nvDash;"), do: [8877]
  def get("&nvHarr;"), do: [10500]
  def get("&nvap;"), do: [8781, 8402]
  def get("&nvdash;"), do: [8876]
  def get("&nvge;"), do: [8805, 8402]
  def get("&nvgt;"), do: [62, 8402]
  def get("&nvinfin;"), do: [10718]
  def get("&nvlArr;"), do: [10498]
  def get("&nvle;"), do: [8804, 8402]
  def get("&nvlt;"), do: [60, 8402]
  def get("&nvltrie;"), do: [8884, 8402]
  def get("&nvrArr;"), do: [10499]
  def get("&nvrtrie;"), do: [8885, 8402]
  def get("&nvsim;"), do: [8764, 8402]
  def get("&nwArr;"), do: [8662]
  def get("&nwarhk;"), do: [10531]
  def get("&nwarr;"), do: [8598]
  def get("&nwarrow;"), do: [8598]
  def get("&nwnear;"), do: [10535]
  def get("&oS;"), do: [9416]
  def get("&oacute"), do: [243]
  def get("&oacute;"), do: [243]
  def get("&oast;"), do: [8859]
  def get("&ocir;"), do: [8858]
  def get("&ocirc"), do: [244]
  def get("&ocirc;"), do: [244]
  def get("&ocy;"), do: [1086]
  def get("&odash;"), do: [8861]
  def get("&odblac;"), do: [337]
  def get("&odiv;"), do: [10808]
  def get("&odot;"), do: [8857]
  def get("&odsold;"), do: [10684]
  def get("&oelig;"), do: [339]
  def get("&ofcir;"), do: [10687]
  def get("&ofr;"), do: [120_108]
  def get("&ogon;"), do: [731]
  def get("&ograve"), do: [242]
  def get("&ograve;"), do: [242]
  def get("&ogt;"), do: [10689]
  def get("&ohbar;"), do: [10677]
  def get("&ohm;"), do: [937]
  def get("&oint;"), do: [8750]
  def get("&olarr;"), do: [8634]
  def get("&olcir;"), do: [10686]
  def get("&olcross;"), do: [10683]
  def get("&oline;"), do: [8254]
  def get("&olt;"), do: [10688]
  def get("&omacr;"), do: [333]
  def get("&omega;"), do: [969]
  def get("&omicron;"), do: [959]
  def get("&omid;"), do: [10678]
  def get("&ominus;"), do: [8854]
  def get("&oopf;"), do: [120_160]
  def get("&opar;"), do: [10679]
  def get("&operp;"), do: [10681]
  def get("&oplus;"), do: [8853]
  def get("&or;"), do: [8744]
  def get("&orarr;"), do: [8635]
  def get("&ord;"), do: [10845]
  def get("&order;"), do: [8500]
  def get("&orderof;"), do: [8500]
  def get("&ordf"), do: [170]
  def get("&ordf;"), do: [170]
  def get("&ordm"), do: [186]
  def get("&ordm;"), do: [186]
  def get("&origof;"), do: [8886]
  def get("&oror;"), do: [10838]
  def get("&orslope;"), do: [10839]
  def get("&orv;"), do: [10843]
  def get("&oscr;"), do: [8500]
  def get("&oslash"), do: [248]
  def get("&oslash;"), do: [248]
  def get("&osol;"), do: [8856]
  def get("&otilde"), do: [245]
  def get("&otilde;"), do: [245]
  def get("&otimes;"), do: [8855]
  def get("&otimesas;"), do: [10806]
  def get("&ouml"), do: [246]
  def get("&ouml;"), do: [246]
  def get("&ovbar;"), do: [9021]
  def get("&par;"), do: [8741]
  def get("&para"), do: [182]
  def get("&para;"), do: [182]
  def get("&parallel;"), do: [8741]
  def get("&parsim;"), do: [10995]
  def get("&parsl;"), do: [11005]
  def get("&part;"), do: [8706]
  def get("&pcy;"), do: [1087]
  def get("&percnt;"), do: [37]
  def get("&period;"), do: [46]
  def get("&permil;"), do: [8240]
  def get("&perp;"), do: [8869]
  def get("&pertenk;"), do: [8241]
  def get("&pfr;"), do: [120_109]
  def get("&phi;"), do: [966]
  def get("&phiv;"), do: [981]
  def get("&phmmat;"), do: [8499]
  def get("&phone;"), do: [9742]
  def get("&pi;"), do: [960]
  def get("&pitchfork;"), do: [8916]
  def get("&piv;"), do: [982]
  def get("&planck;"), do: [8463]
  def get("&planckh;"), do: [8462]
  def get("&plankv;"), do: [8463]
  def get("&plus;"), do: [43]
  def get("&plusacir;"), do: [10787]
  def get("&plusb;"), do: [8862]
  def get("&pluscir;"), do: [10786]
  def get("&plusdo;"), do: [8724]
  def get("&plusdu;"), do: [10789]
  def get("&pluse;"), do: [10866]
  def get("&plusmn"), do: [177]
  def get("&plusmn;"), do: [177]
  def get("&plussim;"), do: [10790]
  def get("&plustwo;"), do: [10791]
  def get("&pm;"), do: [177]
  def get("&pointint;"), do: [10773]
  def get("&popf;"), do: [120_161]
  def get("&pound"), do: [163]
  def get("&pound;"), do: [163]
  def get("&pr;"), do: [8826]
  def get("&prE;"), do: [10931]
  def get("&prap;"), do: [10935]
  def get("&prcue;"), do: [8828]
  def get("&pre;"), do: [10927]
  def get("&prec;"), do: [8826]
  def get("&precapprox;"), do: [10935]
  def get("&preccurlyeq;"), do: [8828]
  def get("&preceq;"), do: [10927]
  def get("&precnapprox;"), do: [10937]
  def get("&precneqq;"), do: [10933]
  def get("&precnsim;"), do: [8936]
  def get("&precsim;"), do: [8830]
  def get("&prime;"), do: [8242]
  def get("&primes;"), do: [8473]
  def get("&prnE;"), do: [10933]
  def get("&prnap;"), do: [10937]
  def get("&prnsim;"), do: [8936]
  def get("&prod;"), do: [8719]
  def get("&profalar;"), do: [9006]
  def get("&profline;"), do: [8978]
  def get("&profsurf;"), do: [8979]
  def get("&prop;"), do: [8733]
  def get("&propto;"), do: [8733]
  def get("&prsim;"), do: [8830]
  def get("&prurel;"), do: [8880]
  def get("&pscr;"), do: [120_005]
  def get("&psi;"), do: [968]
  def get("&puncsp;"), do: [8200]
  def get("&qfr;"), do: [120_110]
  def get("&qint;"), do: [10764]
  def get("&qopf;"), do: [120_162]
  def get("&qprime;"), do: [8279]
  def get("&qscr;"), do: [120_006]
  def get("&quaternions;"), do: [8461]
  def get("&quatint;"), do: [10774]
  def get("&quest;"), do: [63]
  def get("&questeq;"), do: [8799]
  def get("&quot"), do: [34]
  def get("&quot;"), do: [34]
  def get("&rAarr;"), do: [8667]
  def get("&rArr;"), do: [8658]
  def get("&rAtail;"), do: [10524]
  def get("&rBarr;"), do: [10511]
  def get("&rHar;"), do: [10596]
  def get("&race;"), do: [8765, 817]
  def get("&racute;"), do: [341]
  def get("&radic;"), do: [8730]
  def get("&raemptyv;"), do: [10675]
  def get("&rang;"), do: [10217]
  def get("&rangd;"), do: [10642]
  def get("&range;"), do: [10661]
  def get("&rangle;"), do: [10217]
  def get("&raquo"), do: [187]
  def get("&raquo;"), do: [187]
  def get("&rarr;"), do: [8594]
  def get("&rarrap;"), do: [10613]
  def get("&rarrb;"), do: [8677]
  def get("&rarrbfs;"), do: [10528]
  def get("&rarrc;"), do: [10547]
  def get("&rarrfs;"), do: [10526]
  def get("&rarrhk;"), do: [8618]
  def get("&rarrlp;"), do: [8620]
  def get("&rarrpl;"), do: [10565]
  def get("&rarrsim;"), do: [10612]
  def get("&rarrtl;"), do: [8611]
  def get("&rarrw;"), do: [8605]
  def get("&ratail;"), do: [10522]
  def get("&ratio;"), do: [8758]
  def get("&rationals;"), do: [8474]
  def get("&rbarr;"), do: [10509]
  def get("&rbbrk;"), do: [10099]
  def get("&rbrace;"), do: [125]
  def get("&rbrack;"), do: [93]
  def get("&rbrke;"), do: [10636]
  def get("&rbrksld;"), do: [10638]
  def get("&rbrkslu;"), do: [10640]
  def get("&rcaron;"), do: [345]
  def get("&rcedil;"), do: [343]
  def get("&rceil;"), do: [8969]
  def get("&rcub;"), do: [125]
  def get("&rcy;"), do: [1088]
  def get("&rdca;"), do: [10551]
  def get("&rdldhar;"), do: [10601]
  def get("&rdquo;"), do: [8221]
  def get("&rdquor;"), do: [8221]
  def get("&rdsh;"), do: [8627]
  def get("&real;"), do: [8476]
  def get("&realine;"), do: [8475]
  def get("&realpart;"), do: [8476]
  def get("&reals;"), do: [8477]
  def get("&rect;"), do: [9645]
  def get("&reg"), do: [174]
  def get("&reg;"), do: [174]
  def get("&rfisht;"), do: [10621]
  def get("&rfloor;"), do: [8971]
  def get("&rfr;"), do: [120_111]
  def get("&rhard;"), do: [8641]
  def get("&rharu;"), do: [8640]
  def get("&rharul;"), do: [10604]
  def get("&rho;"), do: [961]
  def get("&rhov;"), do: [1009]
  def get("&rightarrow;"), do: [8594]
  def get("&rightarrowtail;"), do: [8611]
  def get("&rightharpoondown;"), do: [8641]
  def get("&rightharpoonup;"), do: [8640]
  def get("&rightleftarrows;"), do: [8644]
  def get("&rightleftharpoons;"), do: [8652]
  def get("&rightrightarrows;"), do: [8649]
  def get("&rightsquigarrow;"), do: [8605]
  def get("&rightthreetimes;"), do: [8908]
  def get("&ring;"), do: [730]
  def get("&risingdotseq;"), do: [8787]
  def get("&rlarr;"), do: [8644]
  def get("&rlhar;"), do: [8652]
  def get("&rlm;"), do: [8207]
  def get("&rmoust;"), do: [9137]
  def get("&rmoustache;"), do: [9137]
  def get("&rnmid;"), do: [10990]
  def get("&roang;"), do: [10221]
  def get("&roarr;"), do: [8702]
  def get("&robrk;"), do: [10215]
  def get("&ropar;"), do: [10630]
  def get("&ropf;"), do: [120_163]
  def get("&roplus;"), do: [10798]
  def get("&rotimes;"), do: [10805]
  def get("&rpar;"), do: [41]
  def get("&rpargt;"), do: [10644]
  def get("&rppolint;"), do: [10770]
  def get("&rrarr;"), do: [8649]
  def get("&rsaquo;"), do: [8250]
  def get("&rscr;"), do: [120_007]
  def get("&rsh;"), do: [8625]
  def get("&rsqb;"), do: [93]
  def get("&rsquo;"), do: [8217]
  def get("&rsquor;"), do: [8217]
  def get("&rthree;"), do: [8908]
  def get("&rtimes;"), do: [8906]
  def get("&rtri;"), do: [9657]
  def get("&rtrie;"), do: [8885]
  def get("&rtrif;"), do: [9656]
  def get("&rtriltri;"), do: [10702]
  def get("&ruluhar;"), do: [10600]
  def get("&rx;"), do: [8478]
  def get("&sacute;"), do: [347]
  def get("&sbquo;"), do: [8218]
  def get("&sc;"), do: [8827]
  def get("&scE;"), do: [10932]
  def get("&scap;"), do: [10936]
  def get("&scaron;"), do: [353]
  def get("&sccue;"), do: [8829]
  def get("&sce;"), do: [10928]
  def get("&scedil;"), do: [351]
  def get("&scirc;"), do: [349]
  def get("&scnE;"), do: [10934]
  def get("&scnap;"), do: [10938]
  def get("&scnsim;"), do: [8937]
  def get("&scpolint;"), do: [10771]
  def get("&scsim;"), do: [8831]
  def get("&scy;"), do: [1089]
  def get("&sdot;"), do: [8901]
  def get("&sdotb;"), do: [8865]
  def get("&sdote;"), do: [10854]
  def get("&seArr;"), do: [8664]
  def get("&searhk;"), do: [10533]
  def get("&searr;"), do: [8600]
  def get("&searrow;"), do: [8600]
  def get("&sect"), do: [167]
  def get("&sect;"), do: [167]
  def get("&semi;"), do: [59]
  def get("&seswar;"), do: [10537]
  def get("&setminus;"), do: [8726]
  def get("&setmn;"), do: [8726]
  def get("&sext;"), do: [10038]
  def get("&sfr;"), do: [120_112]
  def get("&sfrown;"), do: [8994]
  def get("&sharp;"), do: [9839]
  def get("&shchcy;"), do: [1097]
  def get("&shcy;"), do: [1096]
  def get("&shortmid;"), do: [8739]
  def get("&shortparallel;"), do: [8741]
  def get("&shy"), do: [173]
  def get("&shy;"), do: [173]
  def get("&sigma;"), do: [963]
  def get("&sigmaf;"), do: [962]
  def get("&sigmav;"), do: [962]
  def get("&sim;"), do: [8764]
  def get("&simdot;"), do: [10858]
  def get("&sime;"), do: [8771]
  def get("&simeq;"), do: [8771]
  def get("&simg;"), do: [10910]
  def get("&simgE;"), do: [10912]
  def get("&siml;"), do: [10909]
  def get("&simlE;"), do: [10911]
  def get("&simne;"), do: [8774]
  def get("&simplus;"), do: [10788]
  def get("&simrarr;"), do: [10610]
  def get("&slarr;"), do: [8592]
  def get("&smallsetminus;"), do: [8726]
  def get("&smashp;"), do: [10803]
  def get("&smeparsl;"), do: [10724]
  def get("&smid;"), do: [8739]
  def get("&smile;"), do: [8995]
  def get("&smt;"), do: [10922]
  def get("&smte;"), do: [10924]
  def get("&smtes;"), do: [10924, 65024]
  def get("&softcy;"), do: [1100]
  def get("&sol;"), do: [47]
  def get("&solb;"), do: [10692]
  def get("&solbar;"), do: [9023]
  def get("&sopf;"), do: [120_164]
  def get("&spades;"), do: [9824]
  def get("&spadesuit;"), do: [9824]
  def get("&spar;"), do: [8741]
  def get("&sqcap;"), do: [8851]
  def get("&sqcaps;"), do: [8851, 65024]
  def get("&sqcup;"), do: [8852]
  def get("&sqcups;"), do: [8852, 65024]
  def get("&sqsub;"), do: [8847]
  def get("&sqsube;"), do: [8849]
  def get("&sqsubset;"), do: [8847]
  def get("&sqsubseteq;"), do: [8849]
  def get("&sqsup;"), do: [8848]
  def get("&sqsupe;"), do: [8850]
  def get("&sqsupset;"), do: [8848]
  def get("&sqsupseteq;"), do: [8850]
  def get("&squ;"), do: [9633]
  def get("&square;"), do: [9633]
  def get("&squarf;"), do: [9642]
  def get("&squf;"), do: [9642]
  def get("&srarr;"), do: [8594]
  def get("&sscr;"), do: [120_008]
  def get("&ssetmn;"), do: [8726]
  def get("&ssmile;"), do: [8995]
  def get("&sstarf;"), do: [8902]
  def get("&star;"), do: [9734]
  def get("&starf;"), do: [9733]
  def get("&straightepsilon;"), do: [1013]
  def get("&straightphi;"), do: [981]
  def get("&strns;"), do: [175]
  def get("&sub;"), do: [8834]
  def get("&subE;"), do: [10949]
  def get("&subdot;"), do: [10941]
  def get("&sube;"), do: [8838]
  def get("&subedot;"), do: [10947]
  def get("&submult;"), do: [10945]
  def get("&subnE;"), do: [10955]
  def get("&subne;"), do: [8842]
  def get("&subplus;"), do: [10943]
  def get("&subrarr;"), do: [10617]
  def get("&subset;"), do: [8834]
  def get("&subseteq;"), do: [8838]
  def get("&subseteqq;"), do: [10949]
  def get("&subsetneq;"), do: [8842]
  def get("&subsetneqq;"), do: [10955]
  def get("&subsim;"), do: [10951]
  def get("&subsub;"), do: [10965]
  def get("&subsup;"), do: [10963]
  def get("&succ;"), do: [8827]
  def get("&succapprox;"), do: [10936]
  def get("&succcurlyeq;"), do: [8829]
  def get("&succeq;"), do: [10928]
  def get("&succnapprox;"), do: [10938]
  def get("&succneqq;"), do: [10934]
  def get("&succnsim;"), do: [8937]
  def get("&succsim;"), do: [8831]
  def get("&sum;"), do: [8721]
  def get("&sung;"), do: [9834]
  def get("&sup1"), do: [185]
  def get("&sup1;"), do: [185]
  def get("&sup2"), do: [178]
  def get("&sup2;"), do: [178]
  def get("&sup3"), do: [179]
  def get("&sup3;"), do: [179]
  def get("&sup;"), do: [8835]
  def get("&supE;"), do: [10950]
  def get("&supdot;"), do: [10942]
  def get("&supdsub;"), do: [10968]
  def get("&supe;"), do: [8839]
  def get("&supedot;"), do: [10948]
  def get("&suphsol;"), do: [10185]
  def get("&suphsub;"), do: [10967]
  def get("&suplarr;"), do: [10619]
  def get("&supmult;"), do: [10946]
  def get("&supnE;"), do: [10956]
  def get("&supne;"), do: [8843]
  def get("&supplus;"), do: [10944]
  def get("&supset;"), do: [8835]
  def get("&supseteq;"), do: [8839]
  def get("&supseteqq;"), do: [10950]
  def get("&supsetneq;"), do: [8843]
  def get("&supsetneqq;"), do: [10956]
  def get("&supsim;"), do: [10952]
  def get("&supsub;"), do: [10964]
  def get("&supsup;"), do: [10966]
  def get("&swArr;"), do: [8665]
  def get("&swarhk;"), do: [10534]
  def get("&swarr;"), do: [8601]
  def get("&swarrow;"), do: [8601]
  def get("&swnwar;"), do: [10538]
  def get("&szlig"), do: [223]
  def get("&szlig;"), do: [223]
  def get("&target;"), do: [8982]
  def get("&tau;"), do: [964]
  def get("&tbrk;"), do: [9140]
  def get("&tcaron;"), do: [357]
  def get("&tcedil;"), do: [355]
  def get("&tcy;"), do: [1090]
  def get("&tdot;"), do: [8411]
  def get("&telrec;"), do: [8981]
  def get("&tfr;"), do: [120_113]
  def get("&there4;"), do: [8756]
  def get("&therefore;"), do: [8756]
  def get("&theta;"), do: [952]
  def get("&thetasym;"), do: [977]
  def get("&thetav;"), do: [977]
  def get("&thickapprox;"), do: [8776]
  def get("&thicksim;"), do: [8764]
  def get("&thinsp;"), do: [8201]
  def get("&thkap;"), do: [8776]
  def get("&thksim;"), do: [8764]
  def get("&thorn"), do: [254]
  def get("&thorn;"), do: [254]
  def get("&tilde;"), do: [732]
  def get("&times"), do: [215]
  def get("&times;"), do: [215]
  def get("&timesb;"), do: [8864]
  def get("&timesbar;"), do: [10801]
  def get("&timesd;"), do: [10800]
  def get("&tint;"), do: [8749]
  def get("&toea;"), do: [10536]
  def get("&top;"), do: [8868]
  def get("&topbot;"), do: [9014]
  def get("&topcir;"), do: [10993]
  def get("&topf;"), do: [120_165]
  def get("&topfork;"), do: [10970]
  def get("&tosa;"), do: [10537]
  def get("&tprime;"), do: [8244]
  def get("&trade;"), do: [8482]
  def get("&triangle;"), do: [9653]
  def get("&triangledown;"), do: [9663]
  def get("&triangleleft;"), do: [9667]
  def get("&trianglelefteq;"), do: [8884]
  def get("&triangleq;"), do: [8796]
  def get("&triangleright;"), do: [9657]
  def get("&trianglerighteq;"), do: [8885]
  def get("&tridot;"), do: [9708]
  def get("&trie;"), do: [8796]
  def get("&triminus;"), do: [10810]
  def get("&triplus;"), do: [10809]
  def get("&trisb;"), do: [10701]
  def get("&tritime;"), do: [10811]
  def get("&trpezium;"), do: [9186]
  def get("&tscr;"), do: [120_009]
  def get("&tscy;"), do: [1094]
  def get("&tshcy;"), do: [1115]
  def get("&tstrok;"), do: [359]
  def get("&twixt;"), do: [8812]
  def get("&twoheadleftarrow;"), do: [8606]
  def get("&twoheadrightarrow;"), do: [8608]
  def get("&uArr;"), do: [8657]
  def get("&uHar;"), do: [10595]
  def get("&uacute"), do: [250]
  def get("&uacute;"), do: [250]
  def get("&uarr;"), do: [8593]
  def get("&ubrcy;"), do: [1118]
  def get("&ubreve;"), do: [365]
  def get("&ucirc"), do: [251]
  def get("&ucirc;"), do: [251]
  def get("&ucy;"), do: [1091]
  def get("&udarr;"), do: [8645]
  def get("&udblac;"), do: [369]
  def get("&udhar;"), do: [10606]
  def get("&ufisht;"), do: [10622]
  def get("&ufr;"), do: [120_114]
  def get("&ugrave"), do: [249]
  def get("&ugrave;"), do: [249]
  def get("&uharl;"), do: [8639]
  def get("&uharr;"), do: [8638]
  def get("&uhblk;"), do: [9600]
  def get("&ulcorn;"), do: [8988]
  def get("&ulcorner;"), do: [8988]
  def get("&ulcrop;"), do: [8975]
  def get("&ultri;"), do: [9720]
  def get("&umacr;"), do: [363]
  def get("&uml"), do: [168]
  def get("&uml;"), do: [168]
  def get("&uogon;"), do: [371]
  def get("&uopf;"), do: [120_166]
  def get("&uparrow;"), do: [8593]
  def get("&updownarrow;"), do: [8597]
  def get("&upharpoonleft;"), do: [8639]
  def get("&upharpoonright;"), do: [8638]
  def get("&uplus;"), do: [8846]
  def get("&upsi;"), do: [965]
  def get("&upsih;"), do: [978]
  def get("&upsilon;"), do: [965]
  def get("&upuparrows;"), do: [8648]
  def get("&urcorn;"), do: [8989]
  def get("&urcorner;"), do: [8989]
  def get("&urcrop;"), do: [8974]
  def get("&uring;"), do: [367]
  def get("&urtri;"), do: [9721]
  def get("&uscr;"), do: [120_010]
  def get("&utdot;"), do: [8944]
  def get("&utilde;"), do: [361]
  def get("&utri;"), do: [9653]
  def get("&utrif;"), do: [9652]
  def get("&uuarr;"), do: [8648]
  def get("&uuml"), do: [252]
  def get("&uuml;"), do: [252]
  def get("&uwangle;"), do: [10663]
  def get("&vArr;"), do: [8661]
  def get("&vBar;"), do: [10984]
  def get("&vBarv;"), do: [10985]
  def get("&vDash;"), do: [8872]
  def get("&vangrt;"), do: [10652]
  def get("&varepsilon;"), do: [1013]
  def get("&varkappa;"), do: [1008]
  def get("&varnothing;"), do: [8709]
  def get("&varphi;"), do: [981]
  def get("&varpi;"), do: [982]
  def get("&varpropto;"), do: [8733]
  def get("&varr;"), do: [8597]
  def get("&varrho;"), do: [1009]
  def get("&varsigma;"), do: [962]
  def get("&varsubsetneq;"), do: [8842, 65024]
  def get("&varsubsetneqq;"), do: [10955, 65024]
  def get("&varsupsetneq;"), do: [8843, 65024]
  def get("&varsupsetneqq;"), do: [10956, 65024]
  def get("&vartheta;"), do: [977]
  def get("&vartriangleleft;"), do: [8882]
  def get("&vartriangleright;"), do: [8883]
  def get("&vcy;"), do: [1074]
  def get("&vdash;"), do: [8866]
  def get("&vee;"), do: [8744]
  def get("&veebar;"), do: [8891]
  def get("&veeeq;"), do: [8794]
  def get("&vellip;"), do: [8942]
  def get("&verbar;"), do: [124]
  def get("&vert;"), do: [124]
  def get("&vfr;"), do: [120_115]
  def get("&vltri;"), do: [8882]
  def get("&vnsub;"), do: [8834, 8402]
  def get("&vnsup;"), do: [8835, 8402]
  def get("&vopf;"), do: [120_167]
  def get("&vprop;"), do: [8733]
  def get("&vrtri;"), do: [8883]
  def get("&vscr;"), do: [120_011]
  def get("&vsubnE;"), do: [10955, 65024]
  def get("&vsubne;"), do: [8842, 65024]
  def get("&vsupnE;"), do: [10956, 65024]
  def get("&vsupne;"), do: [8843, 65024]
  def get("&vzigzag;"), do: [10650]
  def get("&wcirc;"), do: [373]
  def get("&wedbar;"), do: [10847]
  def get("&wedge;"), do: [8743]
  def get("&wedgeq;"), do: [8793]
  def get("&weierp;"), do: [8472]
  def get("&wfr;"), do: [120_116]
  def get("&wopf;"), do: [120_168]
  def get("&wp;"), do: [8472]
  def get("&wr;"), do: [8768]
  def get("&wreath;"), do: [8768]
  def get("&wscr;"), do: [120_012]
  def get("&xcap;"), do: [8898]
  def get("&xcirc;"), do: [9711]
  def get("&xcup;"), do: [8899]
  def get("&xdtri;"), do: [9661]
  def get("&xfr;"), do: [120_117]
  def get("&xhArr;"), do: [10234]
  def get("&xharr;"), do: [10231]
  def get("&xi;"), do: [958]
  def get("&xlArr;"), do: [10232]
  def get("&xlarr;"), do: [10229]
  def get("&xmap;"), do: [10236]
  def get("&xnis;"), do: [8955]
  def get("&xodot;"), do: [10752]
  def get("&xopf;"), do: [120_169]
  def get("&xoplus;"), do: [10753]
  def get("&xotime;"), do: [10754]
  def get("&xrArr;"), do: [10233]
  def get("&xrarr;"), do: [10230]
  def get("&xscr;"), do: [120_013]
  def get("&xsqcup;"), do: [10758]
  def get("&xuplus;"), do: [10756]
  def get("&xutri;"), do: [9651]
  def get("&xvee;"), do: [8897]
  def get("&xwedge;"), do: [8896]
  def get("&yacute"), do: [253]
  def get("&yacute;"), do: [253]
  def get("&yacy;"), do: [1103]
  def get("&ycirc;"), do: [375]
  def get("&ycy;"), do: [1099]
  def get("&yen"), do: [165]
  def get("&yen;"), do: [165]
  def get("&yfr;"), do: [120_118]
  def get("&yicy;"), do: [1111]
  def get("&yopf;"), do: [120_170]
  def get("&yscr;"), do: [120_014]
  def get("&yucy;"), do: [1102]
  def get("&yuml"), do: [255]
  def get("&yuml;"), do: [255]
  def get("&zacute;"), do: [378]
  def get("&zcaron;"), do: [382]
  def get("&zcy;"), do: [1079]
  def get("&zdot;"), do: [380]
  def get("&zeetrf;"), do: [8488]
  def get("&zeta;"), do: [950]
  def get("&zfr;"), do: [120_119]
  def get("&zhcy;"), do: [1078]
  def get("&zigrarr;"), do: [8669]
  def get("&zopf;"), do: [120_171]
  def get("&zscr;"), do: [120_015]
  def get("&zwj;"), do: [8205]
  def get("&zwnj;"), do: [8204]
  def get(_), do: []
end
