# Terminal Parameter Push and File Download API Documentation

This document describes the new API endpoints for terminal parameter push and file download functionality.

## Parameter Push API

### Push Parameters to Single Device

**Endpoint:** `POST /api/parameter/push/:device_serial`

**Request Body:**
```json
{
  "parameters": {
    "merchant_id": "900890089008000",
    "terminal_id": "90080002",
    "mqtt_ip": "testapp.ariticapp.com",
    "mqtt_port": 1883,
    "http_ip": "demo.ctrmv.com",
    "http_port": 4001,
    "product_key": "pFppbioOCKlo5c8E",
    "product_secret": "sj2AJl102397fQAV",
    "username": "user001",
    "keepalive_time": 300,
    "play_language": -1,
    "heartbeat_interval": 300
  }
}
```

### Schedule Parameter Push

**Endpoint:** `POST /api/parameter/schedule/:device_serial`

**Request Body:**
```json
{
  "parameters": {
    "merchant_id": "900890089008000",
    "terminal_id": "90080002"
  },
  "schedule_at": "2024-01-15T10:30:00Z"
}
```

### Batch Parameter Push

**Endpoint:** `POST /api/parameter/batch/push`

**Request Body:**
```json
{
  "device_serials": ["device001", "device002", "device003"],
  "parameters": {
    "merchant_id": "900890089008000",
    "terminal_id": "90080002",
    "mqtt_ip": "testapp.ariticapp.com"
  }
}
```

### Quick Merchant Config Push

**Endpoint:** `POST /api/parameter/merchant/:device_serial`

**Request Body:**
```json
{
  "merchant_id": "900890089008000",
  "terminal_id": "90080002",
  "options": {
    "mqtt_ip": "custom.server.com",
    "mqtt_port": 1883
  }
}
```

## File Download API

### Send File Download Command

**Endpoint:** `POST /api/download/send/:device_serial`

**Request Body:**
```json
{
  "download_params": {
    "command": "file_download",
    "local_path_to_save": "exdata",
    "url_path_from_download": "https://example.com/files/logo.png",
    "file_name": "merchant_logo.png",
    "file_size": "2048",
    "file_category": "logo_image",
    "merchant_config": "true",
    "retry_count": "3",
    "request_id": "download_001"
  }
}
```

### Schedule File Download

**Endpoint:** `POST /api/download/schedule/:device_serial`

**Request Body:**
```json
{
  "download_params": {
    "command": "file_download",
    "local_path_to_save": "firmware",
    "url_path_from_download": "https://releases.example.com/firmware_v2.1.bin",
    "file_name": "firmware_v2.1.bin",
    "file_category": "firmware"
  },
  "schedule_at": "2024-01-15T02:00:00Z"
}
```

### Logo Download (Convenience Method)

**Endpoint:** `POST /api/download/logo/:device_serial`

**Request Body:**
```json
{
  "logo_url": "https://cdn.example.com/merchant_logos/logo123.png",
  "file_name": "merchant_logo.png"
}
```

### Firmware Download

**Endpoint:** `POST /api/download/firmware/:device_serial`

**Request Body:**
```json
{
  "firmware_url": "https://releases.example.com/firmware_v2.1.bin",
  "file_name": "firmware_v2.1.bin"
}
```

### Application Download

**Endpoint:** `POST /api/download/application/:device_serial`

**Request Body:**
```json
{
  "app_url": "https://apps.example.com/payment_app_v1.5.apk",
  "file_name": "payment_app_v1.5.apk"
}
```

### Batch File Download

**Endpoint:** `POST /api/download/batch/send`

**Request Body:**
```json
{
  "device_serials": ["device001", "device002"],
  "download_params": {
    "command": "file_download",
    "local_path_to_save": "exdata",
    "url_path_from_download": "https://example.com/logo.png",
    "file_name": "logo.png",
    "file_category": "logo_image"
  }
}
```

## Response Format

All endpoints return JSON responses in the following format:

**Success Response:**
```json
{
  "success": true,
  "message": "Operation completed successfully",
  "device_serial": "device001",
  "job_id": 12345
}
```

**Error Response:**
```json
{
  "success": false,
  "error": "Error description",
  "device_serial": "device001"
}
```

## MQTT Topics and Payloads

### Parameter Push Topic
`/ota/{product_key}/{device_sn}/update`

### Parameter Push Payload Example
```json
{
  "request_id": 197,
  "merchant_config": true,
  "merchant_id": "900890089008000",
  "terminal_id": "90080002",
  "mqtt_ip": "testapp.ariticapp.com",
  "mqtt_port": 1883,
  "http_ip": "demo.ctrmv.com",
  "http_port": 4001,
  "product_key": "pFppbioOCKlo5c8E",
  "product_secret": "sj2AJl102397fQAV",
  "client_id": "device001",
  "username": "user001",
  "mqtt_topic": "/ota/pFppbioOCKlo5c8E/device001/update",
  "keepalive_time": 300,
  "play_language": -1,
  "heartbeat_interval": 300
}
```

### File Download Topic
`/ota/{product_key}/{device_sn}/update`

### File Download Payload Example
```json
{
  "command": "file_download",
  "local_path_to_save": "exdata",
  "url_path_from_download": "https://example.com/files/mainb.png",
  "file_size": "2048",
  "file_category": "logo_image",
  "file_name": "mainb.png",
  "merchant_config": "true",
  "retry_count": "3",
  "request_id": "download_001"
}
```

## Device Response Handling

### Parameter Push Response Topic
`/ota/ack/{device_serial}`

### Parameter Push Response Payload
```json
{
  "request_id": "197",
  "status": "OK"
}
```

### File Download Response Topic
`/ota/file_download/{device_serial}`

### File Download Success Response
```json
{
  "request_id": "download_001",
  "status": "success",
  "file_name": "merchant_logo.png",
  "file_path": "exdata\\merchant_logo.png"
}
```

### File Download Failure Response
```json
{
  "request_id": "download_001",
  "status": "failed",
  "error_code": -2,
  "file_name": "merchant_logo.png"
}
```

## Usage Examples

### cURL Examples

**Push parameters to a device:**
```bash
curl -X POST http://localhost:4000/api/parameter/push/device001 \
  -H "Content-Type: application/json" \
  -d '{
    "parameters": {
      "merchant_id": "900890089008000",
      "terminal_id": "90080002"
    }
  }'
```

**Send logo download command:**
```bash
curl -X POST http://localhost:4000/api/download/logo/device001 \
  -H "Content-Type: application/json" \
  -d '{
    "logo_url": "https://example.com/logo.png",
    "file_name": "merchant_logo.png"
  }'
```

**Schedule firmware download:**
```bash
curl -X POST http://localhost:4000/api/download/schedule/device001 \
  -H "Content-Type: application/json" \
  -d '{
    "download_params": {
      "command": "file_download",
      "local_path_to_save": "firmware",
      "url_path_from_download": "https://example.com/firmware.bin",
      "file_name": "firmware_v2.1.bin",
      "file_category": "firmware"
    },
    "schedule_at": "2024-01-15T02:00:00Z"
  }'
```

## UI Integration

The web interface includes forms for both parameter push and file download operations accessible from the Application Upgrade page at `/appupgrade`. Users can:

1. **Push Parameters** - Configure and send terminal parameters to one or multiple devices
2. **File Download** - Send file download commands for logos, firmware, applications, etc.
3. **Schedule Jobs** - Both operations can be scheduled for later execution using Oban

## Job Monitoring

- All jobs are tracked using Oban and can be monitored via the job status
- Real-time updates are provided via Phoenix PubSub
- Job results and device responses are logged for debugging and audit trails
- Status can be viewed in the `/appupgrade/status` page

## Error Handling

- Comprehensive parameter validation before sending commands
- Automatic retry logic for failed MQTT publishes
- Device response correlation using request_id
- Detailed error logging and user feedback