# Testing and Playwright Organization Guide

## Directory Structure

```
testing/
├── .gitignore                    # Ignore test results and artifacts
├── elixir/                      # Elixir-specific tests
├── playwright/                  # Playwright configuration and shared specs
│   ├── .gitignore              # Playwright-specific ignores
│   ├── playwright.config.ts    # Main Playwright config
│   ├── playwright.config.enhanced.ts
│   └── specs/                  # Shared test specifications
├── scripts/                    # Test execution scripts
└── results/                    # Test results (IGNORED by git)
    ├── playwright-report/      # HTML reports (IGNORED)
    ├── test-results/          # Test artifacts (IGNORED)
    └── coverage/              # Coverage reports (IGNORED)

playwright/                     # Root-level Playwright tests
├── .gitignore                 # Playwright-specific ignores
├── *.spec.ts                  # Individual test specifications
├── global-setup.ts           # Global test setup
├── global-teardown.ts        # Global test teardown
└── playwright.config.simple.ts

Root Level Test Scripts:
├── test_all.sh               # Run all tests
├── test_enhanced.sh          # Enhanced test suite
├── test_enhanced_auth.sh     # Authentication tests
├── test_enhanced_visual.sh   # Visual regression tests
├── test_parameter_management.sh # Parameter management tests
├── test_remote.sh           # Remote testing
└── compare_tests.sh         # Test comparison utilities
```

## What Gets Committed to Git

### ✅ COMMITTED Files:
- Test specifications (*.spec.ts, *.spec.js)
- Configuration files (playwright.config.*, *.config.ts)
- Test scripts (*.sh files)
- Setup and teardown files (global-*.ts)
- Documentation files (*.md)
- Source code and application files

### ❌ IGNORED Files:
- Test results and reports (`test-results/`, `playwright-report/`)
- Screenshots and videos from test runs
- Coverage reports
- Temporary files (*.tmp, *.temp)
- Log files (*.log)
- Node modules and dependencies
- Environment files (.env)
- Editor swap files (*.swp, *.swo, *.swn)

## Usage Guidelines

1. **Test Specifications**: Keep all `.spec.ts` files committed for team collaboration
2. **Configuration**: Commit configuration files but not generated reports
3. **Scripts**: Commit shell scripts for consistent test execution across environments
4. **Results**: Test results are generated locally and should not be committed

## Clean Repository Commands

```bash
# Remove any accidentally committed test results
git rm -r --cached testing/results/ 2>/dev/null || true
git rm -r --cached playwright-report/ 2>/dev/null || true
git rm -r --cached test-results/ 2>/dev/null || true

# Add proper .gitignore files
git add testing/.gitignore
git add playwright/.gitignore
git add .gitignore
```

## Benefits of This Organization

1. **Clean Commits**: Only essential test files are committed
2. **Team Collaboration**: Shared test specifications and configurations
3. **Local Development**: Test results remain local to each developer
4. **CI/CD Ready**: Configuration files enable automated testing
5. **Maintainable**: Clear separation between code and generated artifacts
