# lib/da_product_app/device_registry.ex
defmodule DaProductApp.DeviceRegistry do
  use GenServer

  def start_link(_opts) do
    GenServer.start_link(__MODULE__, :ok, name: __MODULE__)
  end

  @impl true
  def init(:ok) do
    {:ok, %{}}
  end

  def track_online(device_id) do
    GenServer.cast(__MODULE__, {:online, device_id})
  end

  def track_offline(device_id) do
    GenServer.cast(__MODULE__, {:offline, device_id})
  end

  #def is_online?(device_id) do
  #  GenServer.call(__MODULE__, {:is_online, device_id})
  # end
  def is_online?(_device_id), do: true

  @impl true
  def handle_cast({:online, device_id}, state) do
    {:noreply, Map.put(state, device_id, true)}
  end

  def handle_cast({:offline, device_id}, state) do
    {:noreply, Map.delete(state, device_id)}
  end

  @impl true
  def handle_call({:is_online, device_id}, _from, state) do
    {:reply, Map.has_key?(state, device_id), state}
  end
end
