defmodule DaProductApp.Merchants.Merchant do
  use Ecto.Schema
  import Ecto.Changeset

  @primary_key {:id, :binary_id, autogenerate: true}
  @foreign_key_type :binary_id

  schema "merchants" do
    field :name, :string
    field :email, :string
    field :phone, :string
    field :status, :string
    field :merchant_id, :string
    # ... add additional fields if needed ...
    timestamps(type: :utc_datetime)
  end

  def changeset(merchant, attrs) do
    merchant
    |> cast(attrs, [:name, :email, :phone, :status, :merchant_id])
    |> validate_required([:name])
  end
end
