# lib/da_product_app/mqtt.ex
defmodule DaProductApp.MQTT do
  @doc """
  Start the Phoenix MQTT client using configured client id and server.
  """
  def start_phoenix_client do
    client_id = client_id()

    host = Application.get_env(:da_product_app, :mqtt_host, "20.233.19.152")
    port = Application.get_env(:da_product_app, :mqtt_port, 8883)

    # TLS/transport options can be extended and driven by config (certs, verify, etc.)
    server_opts = {Tortoise.Transport.Tcp, host: host, port: port}

    Tortoise.Supervisor.start_child(
      client_id: client_id,
      server: server_opts,
      handler: {DaProductApp.MQTT.Handler, [client_id: client_id]},
      subscriptions: [
        {"tms/status/+", 1},
        {"ota/ack/+", 1},
        {"ota/+/+/logpush", 1}
      ]
    )
  end

  @doc """
  Return the configured client id or default value.
  """
  def client_id do
    Application.get_env(:da_product_app, :mqtt_client_id, "phoenix_client_pr2111")
  end

  @doc """
  Publish a message using the central client id.

  Returns whatever Tortoise.publish/4 returns so callers remain compatible.
  """
  def publish(topic, payload, opts \\ []) do
    Tortoise.publish(client_id(), topic, payload, opts)
  end
end
