defmodule DaProductApp.ParameterManagement.ParameterPushDetail do
  use Ecto.Schema
  import Ecto.Changeset
  import Ecto.Query

  schema "parameter_push_details" do
    field :parameter_key, :string
    field :value_sent, :string
    field :previous_value, :string
    field :status, :string, default: "pending"
    field :error_message, :string

    belongs_to :push_log, DaProductApp.ParameterManagement.ParameterPushLog
    belongs_to :parameter_definition, DaProductApp.ParameterManagement.ParameterDefinition

    timestamps()
  end

  @valid_statuses ~w(pending acknowledged failed)

  def changeset(push_detail, attrs) do
    push_detail
    |> cast(attrs, [
      :push_log_id,
      :parameter_definition_id,
      :parameter_key,
      :value_sent,
      :previous_value,
      :status,
      :error_message
    ])
    |> validate_required([:push_log_id, :parameter_key, :value_sent])
    |> validate_inclusion(:status, @valid_statuses)
  end

  def by_push_log(query \\ __MODULE__, push_log_id) do
    from d in query, where: d.push_log_id == ^push_log_id, preload: [:parameter_definition]
  end

  def by_status(query \\ __MODULE__, status) do
    from d in query, where: d.status == ^status
  end
end
