defmodule DaProductApp.Providers do
  import Ecto.Query, warn: false
  alias DaProductApp.Repo
  alias DaProductApp.Providers.Provider

  def list_providers_for_user(user_id) do
    from(p in Provider,
      join: up in "users_providers",
      on: up.provider_id == p.id,
      where: up.user_id == ^user_id and p.status == "enable",
      select: p
    )
    |> Repo.all()
  end
end
