defmodule DaProductApp.Providers.Provider do
  use Ecto.Schema
  import Ecto.Changeset

  schema "providers" do
    field :name, :string
    field :status, :string
    field :production_url, :string
    field :production_mode, :string
    field :description, :string
    # ... add additional fields if needed ...
    timestamps()
  end

  def changeset(provider, attrs) do
    provider
    |> cast(attrs, [:name, :status, :production_url, :production_mode, :description])
    |> validate_required([:name, :status, :production_mode])
  end
end
