defmodule DaProductApp.QRProviderFactory do
  @providers Application.compile_env(:da_product_app, :qr_providers, %{})

  @spec fetch(String.t()) ::
          {:ok, module()} | {:error, :unknown_provider}
  def fetch(key) do
    case Map.fetch(@providers, key) do
      {:ok, mod} -> {:ok, mod}
      :error -> {:error, :unknown_provider}
    end
  end
end
