defmodule DaProductApp.Settlements.AaniSettlementAudit do
  use DaProductApp.Schema
  import Ecto.Changeset

  schema "aani_settlement_audits" do
    field :merchant_tag, :string
    field :bank_user_id, :string
    field :settlement_date, :date
    field :request_payload, :map
    field :response_payload, :map
    field :status, :string
    field :error_code, :string
    field :error_message, :string
    field :processing_time_ms, :integer
    field :ip_address, :string
    timestamps(type: :utc_datetime)
  end

  def changeset(audit, attrs) do
    audit
    |> cast(attrs, [
      :merchant_tag,
      :bank_user_id,
      :settlement_date,
      :request_payload,
      :response_payload,
      :status,
      :error_code,
      :error_message,
      :processing_time_ms,
      :ip_address
    ])
    |> validate_required([:request_payload, :status])
  end
end
