defmodule DaProductApp.Settlements.AlipayPlus.Scheduler do
  use GenServer
  require Logger

  # Check every 24 hours by default
  @check_interval :timer.hours(24)

  def start_link(_opts) do
    GenServer.start_link(__MODULE__, %{}, name: __MODULE__)
  end

  @impl true
  def init(state) do
    schedule_next_check()
    {:ok, state}
  end

  @impl true
  def handle_info(:check_sftp, state) do
    Logger.info("Starting scheduled SFTP check")

    # Enqueue the SFTP job using Oban
    %{}
    |> DaProductApp.Settlements.AlipayPlus.SftpFetcher.new()
    |> Oban.insert()

    schedule_next_check()
    {:noreply, state}
  end

  # Manual trigger function for testing
  def trigger_check do
    GenServer.cast(__MODULE__, :check_sftp)
  end

  @impl true
  def handle_cast(:check_sftp, state) do
    handle_info(:check_sftp, state)
    {:noreply, state}
  end

  defp schedule_next_check do
    Process.send_after(self(), :check_sftp, @check_interval)
  end
end
