defmodule DaProductApp.Settlements.MerchantBatchNumber do
  use Ecto.Schema
  import Ecto.Changeset

  @primary_key {:id, :binary_id, autogenerate: true}
  @foreign_key_type :binary_id

  schema "merchant_batch_numbers" do
    field :merchant_id, :string
    field :batch_number, :string, default: "1"
    field :provider_id, :integer

    timestamps(type: :utc_datetime)
  end

  @doc false
  def changeset(merchant_batch_number, attrs) do
  merchant_batch_number
  |> cast(attrs, [:merchant_id, :batch_number, :provider_id])
  |> validate_required([:merchant_id, :batch_number])
  |> unique_constraint(:merchant_id)
  end
end
