defmodule DaProductApp.Settlements.SettlementFile do
  use DaProductApp.Schema
  import Ecto.Changeset

  schema "settlement_files" do
    field :filename, :string
    field :uploader_id, :binary_id
    field :status, :string, default: "uploaded"
    field :error_message, :string
    field :processing_log, :string
    field :processed_at, :utc_datetime
    timestamps(type: :utc_datetime)
  end

  def changeset(settlement_file, attrs) do
    settlement_file
    |> cast(attrs, [
      :filename,
      :uploader_id,
      :status,
      :error_message,
      :processing_log,
      :processed_at
    ])
    |> validate_required([:filename, :status])
  end
end
