defmodule DaProductApp.Settlements.SettlementFileAudit do
  use DaProductApp.Schema
  import Ecto.Changeset

  schema "settlement_file_audits" do
    belongs_to :settlement_file, DaProductApp.Settlements.SettlementFile, type: :binary_id
    field :action, :string
    field :status, :string
    field :user_id, :binary_id
    field :metadata, :map
    field :error_message, :string
    field :details, :map
    timestamps(type: :utc_datetime)
  end

  def changeset(audit, attrs) do
    audit
    |> cast(attrs, [:settlement_file_id, :action, :status, :user_id, :metadata, :error_message])
    |> validate_required([:action])
    |> validate_inclusion(:status, ["success", "error", "pending"])
  end
end
