defmodule DaProductApp.Settlements.SettlementTransaction do
  use DaProductApp.Schema
  import Ecto.Changeset

  schema "settlement_transactions" do
    field :settlement_id, :string
    field :transaction_id, :string
    field :qr_id, :string
    field :terminal_id, :string
    field :transaction_amount, :decimal
    field :transaction_currency, :string
    field :transaction_status, :string
    field :transaction_time, :utc_datetime
    field :mdr_charge, :decimal
    field :mdr_charge_currency, :string
    field :tax_on_mdr, :decimal
    field :tax_on_mdr_currency, :string
    field :net_received_amount, :decimal
    field :net_received_currency, :string
    timestamps(type: :utc_datetime)
  end

  def changeset(settlement_transaction, attrs) do
    settlement_transaction
    |> cast(attrs, [
      :settlement_id,
      :transaction_id,
      :qr_id,
      :terminal_id,
      :transaction_amount,
      :transaction_currency,
      :transaction_status,
      :transaction_time,
      :mdr_charge,
      :mdr_charge_currency,
      :tax_on_mdr,
      :tax_on_mdr_currency,
      :net_received_amount,
      :net_received_currency
    ])
    |> validate_required([
      :settlement_id,
      :transaction_id,
      :transaction_amount,
      :transaction_status,
      :transaction_time
    ])
  end
end
