defmodule DaProductApp.Settlements.Settlements do
  use DaProductApp.Schema
  import Ecto.Changeset

  schema "settlements" do
    field :date, :date
    field :status, :string
    field :amount, :decimal
    field :details, :map
    field :merchant_tag, :string
    field :bank_user_id, :string
    field :qr_id, :string
    field :total_transaction_count, :integer
    field :gross_settlement_amount, :decimal
    field :gross_settlement_currency, :string
    field :mdr_charges, :decimal
    field :mdr_charges_currency, :string
    field :tax_on_mdr, :decimal
    field :tax_on_mdr_currency, :string
    field :net_settlement_amount, :decimal
    field :net_settlement_currency, :string
    field :settlement_timestamp, :utc_datetime
    belongs_to :merchant, DaProductApp.Merchants.Merchant, type: :string
    belongs_to :provider, DaProductApp.Providers.Provider, type: :integer
    timestamps(type: :utc_datetime)
  end

  def changeset(settlement, attrs) do
    settlement
    |> cast(attrs, [
      :merchant_id,
      :provider_id,
      :date,
      :status,
      :amount,
      :details,
      :merchant_tag,
      :bank_user_id,
      :qr_id,
      :total_transaction_count,
      :gross_settlement_amount,
      :gross_settlement_currency,
      :mdr_charges,
      :mdr_charges_currency,
      :tax_on_mdr,
      :tax_on_mdr_currency,
      :net_settlement_amount,
      :net_settlement_currency,
      :settlement_timestamp
    ])
    |> validate_required([:merchant_id, :provider_id, :date, :status, :amount])
  end
end
