defmodule DaProductApp.TCP.Server do
  use GenServer

  # Add this child_spec function
  def child_spec(opts) do
    %{
      id: __MODULE__,
      start: {__MODULE__, :start_link, [opts]},
      type: :supervisor,
      restart: :permanent,
      shutdown: :infinity
    }
  end

  def start_link(opts) do
    GenServer.start_link(__MODULE__, opts, name: __MODULE__)
  end

  def init(opts) do
    {:ok, _} =
      :ranch.start_listener(
        :iso8583_server,
        :ranch_tcp,
        %{socket_opts: [{:port, opts[:port]}]},
        DaProductApp.TCP.Handler,
        []
      )

    {:ok, %{}}
  end
end
