defmodule DaProductApp.TerminalManagement.AppPackage do
  use Ecto.Schema
  import Ecto.Changeset

  @primary_key {:id, :id, autogenerate: true}
  schema "app_packages" do
    field :version_name, :string
    field :model, :string
    field :vendor, :string
    field :app_version, :string
    field :data_version, :string
    field :system_version, :string
    field :file_path, :string
    field :remark, :string
    belongs_to :creator, DaProductApp.Users.User

    timestamps()
  end

  @doc false
  def changeset(app_package, attrs) do
    app_package
    |> cast(attrs, [
      :version_name,
      :model,
      :vendor,
      :app_version,
      :data_version,
      :system_version,
      :file_path,
      :remark,
      :creator_id
    ])
    |> validate_required([:version_name, :model, :vendor, :file_path])
  end
end
