defmodule DaProductApp.TerminalManagement.AppUpgradeConfig do
  use Ecto.Schema
  import Ecto.Changeset

  @primary_key {:id, :id, autogenerate: true}
  schema "app_upgrade_configs" do
    field :batch_code, :string
    field :force_upgrade, :boolean, default: false
    field :is_iterate, :boolean, default: false
    field :download_link, :string
    field :update_count, :integer
    field :upgrade_start_at, :utc_datetime
    field :upgrade_end_at, :utc_datetime
    field :old_app_version, :string
    field :old_data_version, :string
    field :old_sys_version, :string
    field :old_sp_version, :string
    field :scheduled_at, :utc_datetime
    field :status, :string, default: "pending"
    field :params, :map
    belongs_to :package, DaProductApp.TerminalManagement.AppPackage
    belongs_to :creator, DaProductApp.Users.User, foreign_key: :created_by

    timestamps()
  end

  @doc false
  def changeset(config, attrs) do
    config
    |> cast(attrs, [
      :package_id,
      :scheduled_at,
      :status,
      :params,
      :created_by,
      :batch_code,
      :force_upgrade,
      :is_iterate,
      :download_link,
      :update_count,
      :upgrade_start_at,
      :upgrade_end_at,
      :old_app_version,
      :old_data_version,
      :old_sys_version,
      :old_sp_version
    ])
    |> validate_required([:package_id])
  end
end
