defmodule DaProductApp.TerminalManagement.AppUpgradeDeviceStatus do
  use Ecto.Schema
  import Ecto.Changeset

  schema "app_upgrade_device_statuses" do
    belongs_to :config, DaProductApp.TerminalManagement.AppUpgradeConfig
    belongs_to :device, DaProductApp.TerminalManagement.TmsTerminal, type: :id
    field :device_sn, :string
    field :vendor, :string
    field :model, :string
    field :app_version, :string
    field :data_version, :string
    field :system_version, :string
    field :update_result, :string
    field :status, :string
    field :remark, :string
    field :finish_time, :utc_datetime
    field :pushed_time, :utc_datetime
    timestamps()
  end

  @doc false
  def changeset(status, attrs) do
    status
    |> cast(attrs, [
      :config_id,
      :device_id,
      :device_sn,
      :vendor,
      :model,
      :app_version,
      :data_version,
      :system_version,
      :update_result,
      :status,
      :remark,
      :finish_time,
      :pushed_time
    ])
    |> validate_required([:config_id, :device_id, :device_sn])
  end
end
