defmodule DaProductApp.TerminalManagement.TerminalEventSupervisor do
  @moduledoc """
  Supervisor for terminal event processing and rule management.
  This ensures automatic rule application is resilient and monitored.
  """

  use Supervisor
  require Logger

  def start_link(init_arg) do
    Supervisor.start_link(__MODULE__, init_arg, name: __MODULE__)
  end

  @impl true
  def init(_init_arg) do
    children = [
      # Event listener for terminal changes
      {DaProductApp.TerminalManagement.TerminalEventListener, []},

      # Periodic rule validator (runs every hour to ensure consistency)
      {DaProductApp.TerminalManagement.RuleValidationWorker, []},

      # Background task supervisor for rule processing
      {Task.Supervisor, name: DaProductApp.TerminalManagement.RuleTaskSupervisor}
    ]

    Supervisor.init(children, strategy: :one_for_one)
  end
end
