defmodule DaProductApp.TerminalManagement.TmsTerminalAppVersion do
  use Ecto.Schema
  import Ecto.Changeset

  @primary_key {:id, :id, autogenerate: true}
  @foreign_key_type :id
  schema "tms_terminal_app_versions" do
    field :app_version, :string
    field :firmware_version, :string
    belongs_to :terminal, DaProductApp.TerminalManagement.TmsTerminal, type: :id
    field :installed_at, :utc_datetime
    timestamps()
  end

  def changeset(app_version, attrs) do
    app_version
    |> cast(attrs, [:app_version, :firmware_version, :terminal_id, :installed_at])
    |> validate_required([:terminal_id])
  end
end
