defmodule DaProductApp.TerminalManagement.TmsTerminalStatusItem do
  use Ecto.Schema
  import Ecto.Changeset

  @primary_key {:id, :id, autogenerate: true}
  @foreign_key_type :id
  schema "tms_terminal_status_items" do
    field :itemkey, :string
    field :value, :string
    field :timestamp, :string
    field :message, :string
    belongs_to :status_log, DaProductApp.TerminalManagement.TmsTerminalStatusLog, type: :id
    timestamps()
  end

  def changeset(status_item, attrs) do
    status_item
    |> cast(attrs, [:itemkey, :value, :timestamp, :message, :status_log_id])
    |> validate_required([:itemkey, :status_log_id])
  end
end
