defmodule DaProductApp.TerminalManagement.TmsTerminalStatusLog do
  use Ecto.Schema
  import Ecto.Changeset

  @primary_key {:id, :id, autogenerate: true}
  @foreign_key_type :id
  schema "tms_terminal_status_logs" do
    field :oid, :string
    field :upload_time, :string
    belongs_to :terminal, DaProductApp.TerminalManagement.TmsTerminal, type: :id

    has_many :status_items, DaProductApp.TerminalManagement.TmsTerminalStatusItem,
      foreign_key: :status_log_id

    timestamps()
  end

  def changeset(status_log, attrs) do
    status_log
    |> cast(attrs, [:oid, :upload_time, :terminal_id])
    |> validate_required([:upload_time, :terminal_id])
  end
end
