defmodule DaProductApp.UsersProvider do
  use Ecto.Schema
  import Ecto.Changeset

  schema "users_providers" do
    field :assignment_status, :string, default: "active"
    belongs_to :user, DaProductApp.Users.User
    belongs_to :provider, DaProductApp.Providers.Provider
    timestamps()
  end

  def changeset(users_provider, attrs) do
    users_provider
    |> cast(attrs, [:user_id, :provider_id, :assignment_status])
    |> validate_required([:user_id, :provider_id])
  end
end
