defmodule DaProductApp.Users.Module do
  @moduledoc false
  use Ecto.Schema
  import Ecto.Changeset

  schema "modules" do
    field :name, :string
    field :description, :string
    field :active, :boolean, default: true

    has_many :permissions, DaProductApp.Users.Permission, foreign_key: :module_id

    timestamps(type: :utc_datetime)
  end

  @doc false
  def changeset(module, attrs) do
    module
    |> cast(attrs, [:name, :description, :active])
    |> validate_required([:name])
    |> unique_constraint(:name)
  end
end
