defmodule DaProductApp.Users.Permission do
  @moduledoc false
  use Ecto.Schema
  import Ecto.Changeset

  @primary_key {:id, :id, autogenerate: true}
  @foreign_key_type :id

  schema "permissions" do
    field :name, :string
    field :description, :string
    field :active, :boolean, default: true

    belongs_to :module, DaProductApp.Users.Module, foreign_key: :module_id
    many_to_many :users, DaProductApp.Users.User, join_through: "user_permissions"

    timestamps(type: :utc_datetime)
  end

  @doc false
  def changeset(permission, attrs) do
    permission
    |> cast(attrs, [:name, :description, :module_id, :active])
    |> validate_required([:name, :module_id])
    |> unique_constraint([:name, :module_id])
  end
end
