defmodule DaProductApp.Users.UserPermission do
  @moduledoc false
  use Ecto.Schema
  import Ecto.Changeset

  @primary_key {:id, :id, autogenerate: true}
  @foreign_key_type :id

  schema "user_permissions" do
    belongs_to :user, DaProductApp.Users.User, foreign_key: :user_id
    belongs_to :permission, DaProductApp.Users.Permission, foreign_key: :permission_id
    belongs_to :granted_by_user, DaProductApp.Users.User, foreign_key: :granted_by
    field :granted_at, :utc_datetime

    timestamps(type: :utc_datetime)
  end

  @doc false
  def changeset(user_permission, attrs) do
    user_permission
    |> cast(attrs, [:user_id, :permission_id, :granted_by, :granted_at])
    |> validate_required([:user_id, :permission_id])
    |> unique_constraint([:user_id, :permission_id])
  end
end
