defmodule DaProductApp.Utils.CSV do
  @moduledoc """
  Simple CSV utility functions for generating CSV content.
  """

  @doc """
  Encodes a list of lists into CSV lines.
  """
  def encode(rows) when is_list(rows) do
    Enum.map(rows, fn row ->
      row
      |> Enum.map(&escape_csv_field/1)
      |> Enum.join(",")
    end)
  end

  defp escape_csv_field(field) when is_nil(field), do: ""

  defp escape_csv_field(field) when is_binary(field) do
    if String.contains?(field, [",", "\"", "\n", "\r"]) do
      "\"" <> String.replace(field, "\"", "\"\"") <> "\""
    else
      field
    end
  end

  defp escape_csv_field(field), do: to_string(field)
end
