defmodule DaProductAppWeb.SidebarComponent do
  use Phoenix.LiveComponent
  use DaProductAppWeb, :verified_routes
  use PetalComponents

  def update(assigns, socket) do
    socket =
      socket
      |> assign(:collapsed, assigns[:collapsed] || false)
      |> assign(:current_page, assigns[:current_page] || :dashboard)

    {:ok, socket}
  end

  def render(assigns) do
    ~H"""
    <div class="w-48 bg-gray-100 h-screen fixed left-0 top-0 pt-16 flex flex-col">
      <div class="flex-shrink-0 p-4 pb-2">
        <div class="mt-[-2.5rem] mb-6">
          <img src={~p"/images/logo.png"} alt="Logo" class="w-32 h-auto" />
        </div>
      </div>
      <div class="flex-1 overflow-y-auto px-4 pb-4">
        <.vertical_menu
          title="Main menu"
          menu_items={[
            %{
              title: "Dashboard",
              menu_items: [
                %{name: :dashboard, label: "Overview", path: ~p"/dashboard", icon: "hero-home"},
                %{name: :analytics, label: "Analytics", path: ~p"/analytics", icon: "hero-chart-bar"},
                %{name: :alerts, label: "Alerts", path: ~p"/alerts", icon: "hero-bell"}
              ]
            },
            %{
              title: "Terminal Management",
              menu_items: [
                %{
                  name: :terminals,
                  label: "All Terminals",
                  path: ~p"/terminals",
                  icon: "hero-computer-desktop"
                },
                %{
                  name: :terminal_locations,
                  label: "Locations",
                  path: ~p"/terminals_all/locations",
                  icon: "hero-map-pin"
                },
                %{
                  name: :terminal_groups,
                  label: "Groups",
                  path: ~p"/terminals_all/groups",
                  icon: "hero-squares-2x2"
                }
              ]
            },
            %{
              title: "Parameter Management",
              menu_items: [
                %{
                  name: :parameters,
                  label: "Parameter Dashboard",
                  path: ~p"/admin/parameters",
                  icon: "hero-cog-8-tooth"
                },
                %{
                  name: :parameter_templates,
                  label: "Templates",
                  path: ~p"/admin/parameters/templates",
                  icon: "hero-document-duplicate"
                },
                %{
                  name: :parameter_logs,
                  label: "Push Logs",
                  path: ~p"/admin/parameters/logs",
                  icon: "hero-clipboard-document-list"
                },
                %{
                  name: :configurations,
                  label: "Device Config",
                  path: ~p"/admin/device-configs",
                  icon: "hero-wrench-screwdriver"
                }
              ]
            },
            %{
              title: "OTA Updates",
              menu_items: [
                %{
                  name: :app_packages,
                  label: "App Packages",
                  path: ~p"/ota/packages",
                  icon: "hero-archive-box"
                },
                %{
                  name: :ota_jobs,
                  label: "Update Jobs",
                  path: ~p"/ota/jobs",
                  icon: "hero-arrow-down-circle"
                },
                %{
                  name: :ota_status,
                  label: "Update Status",
                  path: ~p"/ota/status",
                  icon: "hero-check-badge"
                },
                %{name: :firmware, label: "Firmware", path: ~p"/ota/firmware", icon: "hero-cpu-chip"}
              ]
            },
            %{
              title: "Security & Compliance",
              menu_items: [
                %{
                  name: :audit_compliance,
                  label: "Audit & Compliance",
                  path: ~p"/audit-compliance",
                  icon: "hero-shield-check"
                },
                %{
                  name: :security_logs,
                  label: "Security Logs",
                  path: ~p"/security/logs",
                  icon: "hero-document-text"
                },
                %{
                  name: :certificates,
                  label: "Certificates",
                  path: ~p"/security/certificates",
                  icon: "hero-key"
                }
              ]
            },
            %{
              title: "System",
              menu_items: [
                %{
                  name: :user_management,
                  label: "User Management",
                  path: ~p"/admin/users",
                  icon: "hero-users"
                },
                %{
                  name: :system_settings,
                  label: "System Settings",
                  path: ~p"/admin/settings",
                  icon: "hero-cog-6-tooth"
                },
                %{
                  name: :profile,
                  label: "My Profile",
                  path: ~p"/users/settings",
                  icon: "hero-user-circle"
                }
              ]
            }
          ]}
          current_page={@current_page}
        />
      </div>
    </div>
    """
  end
end
