defmodule DaProductAppWeb.DashboardController do
  use DaProductAppWeb, :controller
  require Logger

  alias DaProductApp.TerminalManagement

  @doc """
  Get dashboard overview statistics.
  GET /api/dashboard/overview
  """
  def overview(conn, _params) do
    stats = TerminalManagement.get_dashboard_statistics()

    conn
    |> put_status(200)
    |> json(%{
      status: "success",
      data: stats
    })
  end

  @doc """
  Get update statistics for different time periods.
  GET /api/dashboard/update_stats
  """
  def update_stats(conn, %{"period" => period}) when period in ["today", "week", "month"] do
    stats = TerminalManagement.get_update_statistics(period)

    conn
    |> put_status(200)
    |> json(%{
      status: "success",
      data: stats
    })
  end

  def update_stats(conn, _params) do
    # Default to today
    update_stats(conn, %{"period" => "today"})
  end

  @doc """
  Get device online rate data for the gauge.
  GET /api/dashboard/online_rate
  """
  def online_rate(conn, _params) do
    rate_data = TerminalManagement.get_device_online_rate()

    conn
    |> put_status(200)
    |> json(%{
      status: "success",
      data: rate_data
    })
  end

  @doc """
  Get chart data for update statistics over time.
  GET /api/dashboard/chart_data
  """
  def chart_data(conn, %{"period" => period}) when period in ["today", "week", "month"] do
    chart_data = TerminalManagement.get_chart_data(period)

    conn
    |> put_status(200)
    |> json(%{
      status: "success",
      data: chart_data
    })
  end

  def chart_data(conn, _params) do
    # Default to today
    chart_data(conn, %{"period" => "today"})
  end
end
