# lib/da_product_app_web/controllers/device_controller.ex
defmodule DaProductAppWeb.DeviceController do
  use DaProductAppWeb, :controller
  require Logger

  def initiate(conn, %{"device_id" => device_id, "amount" => amount}) do
    # Added Message
    # hardcode topic
    topic = "ota/pos/12345678/NCA800111326/sub"
    terminalId = "90080001"
    phone = "919343712136"
    txnType = "card"
    # topic = "cmd/qr-device/#{device_id}"
    payload =
      Jason.encode!(%{
        amount: amount,
        type: txnType,
        terminalid: terminalId,
        phone: phone,
        ts: System.system_time(:second)
      })

    Logger.info("Publish payload for topic #{topic}: #{inspect(payload)}")

    case DaProductApp.MQTT.publish(topic, payload, qos: 0) do
      :ok ->
        conn
        |> put_status(200)
        |> json(%{status: "sent", device: topic})

      {:error, reason} ->
        Logger.error("Publish failed to #{device_id}: #{inspect(reason)}")

        conn
        |> put_status(503)
        |> json(%{error: "publish_failed"})
    end

    case DaProductApp.DeviceRegistry.is_online?(device_id) do
      true ->
        topic = "cmd/qr-device/#{device_id}"
        payload = Jason.encode!(%{amount: amount, ts: System.system_time(:second)})
        Logger.info("Publish payload #{device_id}: #{inspect(payload)}")

        case DaProductApp.MQTT.publish(topic, payload, qos: 1) do
          :ok ->
            conn
            |> put_status(200)
            |> json(%{status: "sent", device: device_id})

          {:error, reason} ->
            Logger.error("Publish failed to #{device_id}: #{inspect(reason)}")

            conn
            |> put_status(503)
            |> json(%{error: "publish_failed"})
        end

      false ->
        conn
        |> put_status(404)
        |> json(%{error: "device_offline"})
    end
  end
end
