defmodule DaProductAppWeb.DeviceMonitorController do
  use DaProductAppWeb, :controller
  require Logger

  alias DaProductApp.TerminalManagement

  @doc """
  Get device monitoring status.
  GET /api/device/:device_serial/monitor
  """
  def show(conn, %{"device_serial" => device_serial}) do
    case TerminalManagement.get_device_monitor_by_serial(device_serial) do
      nil ->
        conn
        |> put_status(404)
        |> json(%{status: "error", message: "Device not found"})

      monitor_data ->
        conn
        |> put_status(200)
        |> json(%{
          status: "success",
          data: monitor_data
        })
    end
  end

  @doc """
  Check for offline devices and send alerts.
  POST /api/device/monitor/check_offline
  """
  def check_offline(conn, _params) do
    TerminalManagement.check_offline_devices()

    conn
    |> put_status(200)
    |> json(%{status: "success", message: "Offline device check completed"})
  end

  @doc """
  Get dashboard statistics for device monitoring.
  GET /api/device/monitor/stats
  """
  def stats(conn, _params) do
    stats = TerminalManagement.get_device_monitoring_stats()

    conn
    |> put_status(200)
    |> json(%{
      status: "success",
      data: stats
    })
  end
end
