defmodule DaProductAppWeb.PageController do
  use DaProductAppWeb, :controller

  def home(conn, _params) do
    # The home page is often custom made,
    # so skip the default app layout.
    render(conn, :home, layout: false)
  end

  def redirect_root(conn, _params) do
    if conn.assigns[:current_user] do
      # User is authenticated, redirect to dashboard
      redirect(conn, to: ~p"/dashboard")
    else
      # User is not authenticated, redirect to login
      redirect(conn, to: ~p"/users/log_in")
    end
  end
end
