defmodule DaProductAppWeb.SettlementWebhookController do
  use DaProductAppWeb, :controller
  alias DaProductApp.Settlements
  alias DaProductApp.Settlements.Settlement
  alias DaProductApp.Settlements.SettlementTransaction
  alias DaProductApp.Repo

  defp changeset_errors(changeset) do
    Ecto.Changeset.traverse_errors(changeset, fn {msg, opts} ->
      Enum.reduce(opts, msg, fn {key, value}, acc ->
        String.replace(acc, "%{#{key}}", to_string(value))
      end)
    end)
  end

  def receive_settlement(conn, %{"type" => "qr_payment_settlement_summary"} = params) do
    changeset =
      Settlement.changeset(%Settlement{}, %{
        merchant_tag: params["merchantTag"],
        merchant_id: params["merchant_id"],
        bank_user_id: params["bankUserId"],
        qr_id: params["qrId"],
        date: params["settlementDate"],
        total_transaction_count: params["totalTransactionCount"],
        gross_settlement_amount: get_in(params, ["grossSettlementAmount", "value"]),
        gross_settlement_currency: get_in(params, ["grossSettlementAmount", "currency"]),
        mdr_charges: get_in(params, ["mdrCharges", "value"]),
        mdr_charges_currency: get_in(params, ["mdrCharges", "currency"]),
        tax_on_mdr: get_in(params, ["taxOnMdr", "value"]),
        tax_on_mdr_currency: get_in(params, ["taxOnMdr", "currency"]),
        net_settlement_amount: get_in(params, ["netSettlementAmount", "value"]),
        net_settlement_currency: get_in(params, ["netSettlementAmount", "currency"]),
        settlement_timestamp: params["settlementTimestamp"],
        status: "summary"
      })

    case Repo.insert(changeset) do
      {:ok, settlement} ->
        json(conn, %{status: "ok", settlement_id: settlement.id})

      {:error, changeset} ->
        conn
        |> put_status(:unprocessable_entity)
        |> json(%{error: changeset_errors(changeset)})
    end
  end

  def receive_settlement(conn, %{"fileType" => "QR_Payment_Settlement"} = params) do
    settlement_changeset =
      Settlement.changeset(%Settlement{}, %{
        merchant_tag: params["merchantTag"],
        merchant_id: params["merchant_id"],
        bank_user_id: params["bankUserId"],
        qr_id: params["qrId"],
        date: params["settlementDate"],
        total_transaction_count: params["totalTransactionCount"],
        gross_settlement_amount: get_in(params, ["grossSettlementAmount", "value"]),
        gross_settlement_currency: get_in(params, ["grossSettlementAmount", "currency"]),
        mdr_charges: get_in(params, ["mdrCharges", "value"]),
        mdr_charges_currency: get_in(params, ["mdrCharges", "currency"]),
        tax_on_mdr: get_in(params, ["taxOnMdr", "value"]),
        tax_on_mdr_currency: get_in(params, ["taxOnMdr", "currency"]),
        net_settlement_amount: get_in(params, ["netSettlementAmount", "value"]),
        net_settlement_currency: get_in(params, ["netSettlementAmount", "currency"]),
        settlement_timestamp: params["generatedTimestamp"],
        status: if(params["mismatchDetected"] == true, do: "mismatch", else: "detailed")
      })

    case Repo.insert(settlement_changeset) do
      {:ok, settlement} ->
        Enum.each(params["transactions"] || [], fn tx ->
          tx_changeset =
            SettlementTransaction.changeset(%SettlementTransaction{}, %{
              settlement_id: settlement.id,
              transaction_id: tx["transactionId"],
              qr_id: tx["qrId"],
              terminal_id: tx["terminal_id"],
              transaction_amount: get_in(tx, ["transactionAmount", "value"]),
              transaction_currency: get_in(tx, ["transactionAmount", "currency"]),
              transaction_status: tx["transactionStatus"],
              transaction_time: tx["transactionTime"],
              mdr_charge: get_in(tx, ["mdrCharge", "value"]),
              mdr_charge_currency: get_in(tx, ["mdrCharge", "currency"]),
              tax_on_mdr: get_in(tx, ["taxOnMdr", "value"]),
              tax_on_mdr_currency: get_in(tx, ["taxOnMdr", "currency"]),
              net_received_amount: get_in(tx, ["netReceivedAmount", "value"]),
              net_received_currency: get_in(tx, ["netReceivedAmount", "currency"])
            })

          Repo.insert(tx_changeset)
        end)

        json(conn, %{status: "ok", settlement_id: settlement.id})

      {:error, changeset} ->
        conn
        |> put_status(:unprocessable_entity)
        |> json(%{error: changeset_errors(changeset)})
    end
  end

  def receive_settlement(conn, _params) do
    conn |> put_status(:bad_request) |> json(%{error: "Invalid settlement payload"})
  end
end
