defmodule DaProductAppWeb.ApplicationUpgradeStatusLive.Index do
  use DaProductAppWeb, :live_view
  alias DaProductApp.TerminalManagement
  alias DaProductApp.ParameterManagement
  alias DaProductApp.TerminalManagement.AppUpgradeDeviceStatus

  @impl true
  def mount(_params, _session, socket) do
    {:ok,
     assign(socket,
       filters: %{},
       statuses: [],
       parameter_logs: [],
       current_tab: "app_upgrades",
       current_page: "app_upgrade_status"
     )}
  end

  @impl true
  def handle_params(_params, _url, socket) do
    statuses = TerminalManagement.list_app_upgrade_device_statuses()
    parameter_logs = ParameterManagement.list_recent_parameter_push_logs()
    {:noreply, assign(socket, statuses: statuses, parameter_logs: parameter_logs)}
  end

  @impl true
  def handle_event("search", _params, socket) do
    statuses = TerminalManagement.list_app_upgrade_device_statuses(socket.assigns.filters)
    parameter_logs = ParameterManagement.list_recent_parameter_push_logs(socket.assigns.filters)
    {:noreply, assign(socket, statuses: statuses, parameter_logs: parameter_logs)}
  end

  def handle_event("reset", _params, socket) do
    statuses = TerminalManagement.list_app_upgrade_device_statuses()
    parameter_logs = ParameterManagement.list_recent_parameter_push_logs()

    {:noreply,
     assign(socket,
       filters: %{},
       statuses: statuses,
       parameter_logs: parameter_logs
     )}
  end

  def handle_event("set_status_tab", %{"status" => status}, socket) do
    filters = Map.put(socket.assigns.filters, "status", status)
    statuses = TerminalManagement.list_app_upgrade_device_statuses(filters)
    parameter_logs = ParameterManagement.list_recent_parameter_push_logs(filters)

    {:noreply,
     assign(socket, filters: filters, statuses: statuses, parameter_logs: parameter_logs)}
  end

  def handle_event("switch_tab", %{"tab" => tab}, socket) do
    {:noreply, assign(socket, current_tab: tab)}
  end

  def handle_event("refresh_data", _params, socket) do
    statuses = TerminalManagement.list_app_upgrade_device_statuses(socket.assigns.filters)
    parameter_logs = ParameterManagement.list_recent_parameter_push_logs(socket.assigns.filters)
    {:noreply, assign(socket, statuses: statuses, parameter_logs: parameter_logs)}
  end

  def handle_event("get_device_details", %{"device_serial" => device_serial}, socket) do
    device_details = get_comprehensive_device_status(device_serial)
    {:noreply, assign(socket, selected_device: device_details)}
  end

  # Helper function to get comprehensive device status
  defp get_comprehensive_device_status(device_serial) do
    %{
      device_serial: device_serial,
      app_status: TerminalManagement.get_latest_app_status(device_serial),
      parameter_status: ParameterManagement.get_latest_parameter_status(device_serial),
      last_online: get_device_last_seen(device_serial),
      device_info: TerminalManagement.get_terminal_by_serial(device_serial)
    }
  end

  defp get_device_last_seen(device_serial) do
    # This would typically come from a heartbeat or monitoring service
    # For now, return a placeholder
    DateTime.utc_now() |> DateTime.add(-300, :second)
  end
end
