defmodule DaProductAppWeb.ParameterManagementLive.TemplateFormComponent do
  use DaProductAppWeb, :live_component
  alias DaProductApp.ParameterManagement

  embed_templates "template_form_component/*"

  def update(assigns, socket) do
    template = assigns.template || %ParameterManagement.ParameterTemplate{}
    changeset = ParameterManagement.change_parameter_template(template)
    form = to_form(changeset)

    {:ok,
     socket
     |> assign(assigns)
     |> assign(:changeset, changeset)
     |> assign(:form, form)
     |> assign(:template, template)}
  end

  def handle_event("validate", %{"parameter_template" => params}, socket) do
    changeset =
      socket.assigns.template
      |> ParameterManagement.change_parameter_template(params)
      |> Map.put(:action, :validate)

    {:noreply, assign(socket, changeset: changeset, form: to_form(changeset))}
  end

  def handle_event("save", %{"parameter_template" => params}, socket) do
    case socket.assigns.form_type do
      :new -> create_template(socket, params)
      :edit -> update_template(socket, params)
    end
  end

  def handle_event("cancel", _params, socket) do
    send(self(), :hide_forms)
    {:noreply, socket}
  end

  defp create_template(socket, params) do
    case ParameterManagement.create_parameter_template(params) do
      {:ok, _template} ->
        send(self(), {:template_saved, "Template created successfully"})
        {:noreply, socket}

      {:error, changeset} ->
        {:noreply, assign(socket, changeset: changeset, form: to_form(changeset))}
    end
  end

  defp update_template(socket, params) do
    case ParameterManagement.update_parameter_template(socket.assigns.template, params) do
      {:ok, _template} ->
        send(self(), {:template_saved, "Template updated successfully"})
        {:noreply, socket}

      {:error, changeset} ->
        {:noreply, assign(socket, changeset: changeset, form: to_form(changeset))}
    end
  end

  @impl true
  def handle_event("close_panel", _params, socket) do
    changeset =
      ParameterManagement.change_parameter_definition(%ParameterManagement.ParameterDefinition{})

    form = to_form(changeset)

    {:noreply,
     assign(socket,
       show_parameter_form: false,
       show_template_form: false,
       editing_parameter: nil,
       parameter_changeset: changeset,
       parameter_form: form
     )}
  end

  @impl true
  def handle_event("close_slide_over", _params, socket) do
    changeset =
      ParameterManagement.change_parameter_template(%ParameterManagement.ParameterTemplate{})

    form = to_form(changeset)

    {:noreply,
     assign(socket,
       show_parameter_form: false,
       show_template_form: false,
       editing_template: nil,
       template_changeset: changeset,
       template_form: form
     )}
  end

  def render(assigns), do: template_form(assigns)
end
