defmodule DaProductAppWeb.SettlementLive.FileTracker do
  use DaProductAppWeb, :live_view
  alias DaProductApp.Settlements.SettlementManagement

  @impl true
  def mount(_params, _session, socket) do
    files = SettlementManagement.list_settlement_files()
    {:ok, assign(socket, files: files, current_page: "file_tracker", audits: %{})}
  end

  @impl true
  def handle_event("upload", %{"file" => upload}, socket) do
    {:ok, file} =
      SettlementManagement.create_settlement_file(%{
        filename: upload.filename,
        status: "uploaded"
      })

    SettlementManagement.create_file_audit(%{
      settlement_file_id: file.id,
      action: "upload",
      inserted_at: DateTime.utc_now()
    })

    files = SettlementManagement.list_settlement_files()
    {:noreply, assign(socket, files: files)}
  end

  @impl true
  def handle_event("reprocess", %{"id" => id}, socket) do
    # Simulate reprocessing logic
    {:ok, _audit} =
      SettlementManagement.create_file_audit(%{
        settlement_file_id: id,
        action: "reprocess",
        inserted_at: DateTime.utc_now()
      })

    # Here you would trigger actual reprocessing and update file status
    files = SettlementManagement.list_settlement_files()
    {:noreply, assign(socket, files: files)}
  end

  @impl true
  def handle_event("show_audits", %{"id" => id}, socket) do
    audits = SettlementManagement.list_file_audits(id)
    {:noreply, assign(socket, audits: Map.put(socket.assigns.audits, id, audits))}
  end
end
