defmodule DaProductAppWeb.TransactionLive.Show do
  use DaProductAppWeb, :live_view
  use PetalComponents
  alias DaProductApp.Transactions
  alias DaProductApp.Providers

  def mount(%{"id" => transaction_id} = params, session, socket) do
    if connected?(socket), do: DaProductAppWeb.Endpoint.subscribe("transaction:#{transaction_id}")
    transaction = Transactions.get_transaction!(transaction_id)

    # providers = Providers.list_providers_for_user(if transaction.user_id, do: transaction.user_id, else: 1)
    providers =
      Providers.list_providers_for_user(if transaction.user_id, do: transaction.user_id, else: 1)
      |> case do
        [] ->
          [
            %{id: "momentPay", name: "momentPay"},
            %{id: "Innoviti", name: "Innoviti"},
            %{id: "Pinelabs", name: "Pinelabs"}
          ]

        list ->
          list
      end

    # Get container_max_width from URL params if provided; default to 500px width
    container_max_width = Map.get(params, "container_max_width", "max-w-[500px]")

    # Set container_override to true so that our custom container is rendered
    {:ok,
     assign(socket,
       transaction: transaction,
       providers: providers,
       container_max_width: container_max_width,
       container_override: true
     )}
  end

  def handle_info(%{event: "transaction_updated", payload: updated_tx}, socket) do
    {:noreply, assign(socket, transaction: updated_tx)}
  end

  def render(assigns) do
    ~H"""
    <div class="min-h-screen flex items-center justify-center bg-gray-100 px-4">
      <div class={"w-full " <> @container_max_width <> " bg-white shadow rounded-lg p-6"}>
        
    <!-- Header Section -->
        <div class="mb-6">
          <img
            src="https://testapp.ariticapp.com/ma/media/uploads/designe/logo.png"
            alt="Logo"
            class="mx-auto md:mx-0 mb-4 max-w-[40px]"
          />
          <h2 class="text-xl font-bold text-center md:text-left">
            Location: {@transaction.transaction_location || "Demo"}
          </h2>
        </div>
        
    <!-- Loyalty Form Section -->
        <div class="bg-gray-50 shadow rounded-lg p-6 mb-6">
          <h3 class="text-lg font-bold mb-4">Enter number to give an offer</h3>
          <form>
            <label for="loyaltyInput" class="block mb-2">Enter Loyalty Number/Phone Number:</label>
            <input type="number" id="loyaltyInput" class="border rounded p-2 mb-4 w-full" />
            <button type="button" class="bg-green-500 text-white py-2 px-4 rounded">
              Know Points
            </button>
          </form>
        </div>
        
    <!-- Amount Banner Section -->
        <div class="bg-blue-500 text-white text-center py-4 mb-6 rounded">
          <h3 class="text-lg font-bold">
            Amount: ₹ {@transaction.transaction_amount || "0.00"}
          </h3>
        </div>
        
    <!-- Provider List Section -->
        <div class="bg-gray-50 shadow rounded-lg p-6 mb-6">
          <div class="flex flex-row justify-between">
            <%= for provider <- @providers do %>
              <div class="w-1/3 text-center">
                <input
                  type="radio"
                  id={"provider_" <> to_string(provider.id)}
                  name="pos_type"
                  value={provider.id}
                  class="hidden peer"
                />
                <label
                  for={"provider_" <> to_string(provider.id)}
                  class="cursor-pointer block p-2 rounded peer-checked:bg-gray-200"
                >
                  <img
                    src={"/images/providerimages/" <> provider.name <> ".png"}
                    alt={provider.name}
                    style="max-width: 120px; width: 100%;"
                    class="mx-auto mb-2"
                  />
                  <div class="text-sm font-medium">{provider.name}</div>
                </label>
              </div>
            <% end %>
          </div>
        </div>
        
    <!-- Action Buttons -->
        <div class="flex justify-between">
          <button type="button" class="bg-green-500 text-white py-2 px-4 rounded">
            Pay ₹ {@transaction.transaction_amount}
          </button>
          <button type="button" class="bg-red-500 text-white py-2 px-4 rounded">
            Cancel
          </button>
        </div>
      </div>
    </div>
    """

    # Phoenix.View.render(DaProductAppWeb.TransactionLive.ShowView, "show.html", assigns)
  end
end
