defmodule DaProductApp.MixProject do
  use Mix.Project

  def project do
    [
      app: :da_product_app,
      version: "0.1.0",
      elixir: "~> 1.14",
      elixirc_paths: elixirc_paths(Mix.env()),
      start_permanent: Mix.env() == :prod,
      aliases: aliases(),
      deps: deps()
    ]
  end

  # Configuration for the OTP application.
  #
  # Type `mix help compile.app` for more information.
  def application do
    [
      mod: {DaProductApp.Application, []},
      extra_applications: [:logger, :runtime_tools, :os_mon]
    ]
  end

  # Specifies which paths to compile per environment.
  defp elixirc_paths(:test), do: ["lib", "test/support"]
  defp elixirc_paths(_), do: ["lib"]

  # Specifies your project dependencies.
  #
  # Type `mix help deps` for examples and options.
  defp deps do
    [
      {:bcrypt_elixir, "~> 3.1"},
      # ADDITIONAL PACKAGES
      {:cachex, "~> 4.1.1"},
      {:premailex, "~> 0.3.20"},
      {:credo, "~> 1.7.11", only: [:dev, :test], runtime: false},
      {:sobelow, "~> 0.13.0", only: [:dev, :test], runtime: false},
      {:req, "~> 0.5.8"},

      # DEFAULT PACKAGES
      {:phoenix, "~> 1.7.18"},
      {:ecto_sql, "~> 3.13.2"},
      {:phoenix_ecto, "~> 4.6.5"},
      {:myxql, ">= 0.0.0"},
      {:phoenix_html, "~> 4.1"},
      {:phoenix_live_reload, "~> 1.6", only: :dev},
      {:phoenix_live_view, "~> 1.1.8"},
      {:floki, ">= 0.30.0"},
      {:phoenix_live_dashboard, "~> 0.8.3"},
      {:esbuild, "~> 0.10", runtime: Mix.env() == :dev},
      {:tailwind, "~> 0.2", runtime: Mix.env() == :dev},
      {:heroicons,
       github: "tailwindlabs/heroicons",
       tag: "v2.1.1",
       sparse: "optimized",
       app: false,
       compile: false,
       depth: 1},
      {:swoosh, "~> 1.5"},
      {:finch, "~> 0.13"},
      {:telemetry_metrics, "~> 1.0"},
      {:telemetry_poller, "~> 1.0"},
      {:gettext, "~> 0.26"},
      {:tortoise, "~> 0.10"},
      {:phoenix_pubsub, "~> 2.0"},
      {:jason, "~> 1.2"},
      {:dns_cluster, "~> 0.1.1"},
      {:bandit, "~> 1.5"},
      # For TCP socket handling
      {:ranch, "~> 2.1"},
      # For CORS handling
      {:cors_plug, "~> 3.0"},
      {:petal_components, "~> 2.8.1"},
      {:salad_ui, "~> 0.14"},
      {:timex, "~> 3.7"},
      # {:saas_kit, "~> 1.0.7", only: :dev}
      {:saas_kit, "~> 1.0.7"},
      {:oban, "~> 2.20.1"}
    ]
  end

  # Aliases are shortcuts or tasks specific to the current project.
  # For example, to install project dependencies and perform other setup tasks, run:
  #
  #     $ mix setup
  #
  # See the documentation for `Mix` for more info on aliases.
  defp aliases do
    [
      setup: ["deps.get", "ecto.setup", "assets.setup", "assets.build"],
      "ecto.setup": ["ecto.create", "ecto.migrate", "run priv/repo/seeds.exs"],
      "ecto.reset": ["ecto.drop", "ecto.setup"],
      test: ["ecto.create --quiet", "ecto.migrate --quiet", "test"],
      "assets.setup": ["tailwind.install --if-missing", "esbuild.install --if-missing"],
      "assets.build": ["tailwind da_product_app", "esbuild da_product_app"],
      "assets.deploy": [
        "tailwind da_product_app --minify",
        "esbuild da_product_app --minify",
        "phx.digest"
      ]
    ]
  end
end
