(() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __defProps = Object.defineProperties;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getOwnPropSymbols = Object.getOwnPropertySymbols;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __propIsEnum = Object.prototype.propertyIsEnumerable;
  var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
  var __spreadValues = (a, b) => {
    for (var prop in b || (b = {}))
      if (__hasOwnProp.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    if (__getOwnPropSymbols)
      for (var prop of __getOwnPropSymbols(b)) {
        if (__propIsEnum.call(b, prop))
          __defNormalProp(a, prop, b[prop]);
      }
    return a;
  };
  var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
  var __objRest = (source, exclude) => {
    var target = {};
    for (var prop in source)
      if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
        target[prop] = source[prop];
    if (source != null && __getOwnPropSymbols)
      for (var prop of __getOwnPropSymbols(source)) {
        if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
          target[prop] = source[prop];
      }
    return target;
  };
  var __commonJS = (cb, mod) => function __require() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));

  // vendor/topbar.js
  var require_topbar = __commonJS({
    "vendor/topbar.js"(exports, module) {
      (function(window2, document2) {
        "use strict";
        (function() {
          var lastTime = 0;
          var vendors = ["ms", "moz", "webkit", "o"];
          for (var x = 0; x < vendors.length && !window2.requestAnimationFrame; ++x) {
            window2.requestAnimationFrame = window2[vendors[x] + "RequestAnimationFrame"];
            window2.cancelAnimationFrame = window2[vendors[x] + "CancelAnimationFrame"] || window2[vendors[x] + "CancelRequestAnimationFrame"];
          }
          if (!window2.requestAnimationFrame)
            window2.requestAnimationFrame = function(callback, element) {
              var currTime = (/* @__PURE__ */ new Date()).getTime();
              var timeToCall = Math.max(0, 16 - (currTime - lastTime));
              var id = window2.setTimeout(function() {
                callback(currTime + timeToCall);
              }, timeToCall);
              lastTime = currTime + timeToCall;
              return id;
            };
          if (!window2.cancelAnimationFrame)
            window2.cancelAnimationFrame = function(id) {
              clearTimeout(id);
            };
        })();
        var canvas, currentProgress, showing, progressTimerId = null, fadeTimerId = null, delayTimerId = null, addEvent = function(elem, type, handler) {
          if (elem.addEventListener)
            elem.addEventListener(type, handler, false);
          else if (elem.attachEvent)
            elem.attachEvent("on" + type, handler);
          else
            elem["on" + type] = handler;
        }, options = {
          autoRun: true,
          barThickness: 3,
          barColors: {
            0: "rgba(26,  188, 156, .9)",
            ".25": "rgba(52,  152, 219, .9)",
            ".50": "rgba(241, 196, 15,  .9)",
            ".75": "rgba(230, 126, 34,  .9)",
            "1.0": "rgba(211, 84,  0,   .9)"
          },
          shadowBlur: 10,
          shadowColor: "rgba(0,   0,   0,   .6)",
          className: null
        }, repaint = function() {
          canvas.width = window2.innerWidth;
          canvas.height = options.barThickness * 5;
          var ctx = canvas.getContext("2d");
          ctx.shadowBlur = options.shadowBlur;
          ctx.shadowColor = options.shadowColor;
          var lineGradient = ctx.createLinearGradient(0, 0, canvas.width, 0);
          for (var stop in options.barColors)
            lineGradient.addColorStop(stop, options.barColors[stop]);
          ctx.lineWidth = options.barThickness;
          ctx.beginPath();
          ctx.moveTo(0, options.barThickness / 2);
          ctx.lineTo(
            Math.ceil(currentProgress * canvas.width),
            options.barThickness / 2
          );
          ctx.strokeStyle = lineGradient;
          ctx.stroke();
        }, createCanvas = function() {
          canvas = document2.createElement("canvas");
          var style = canvas.style;
          style.position = "fixed";
          style.top = style.left = style.right = style.margin = style.padding = 0;
          style.zIndex = 100001;
          style.display = "none";
          if (options.className)
            canvas.classList.add(options.className);
          document2.body.appendChild(canvas);
          addEvent(window2, "resize", repaint);
        }, topbar2 = {
          config: function(opts) {
            for (var key in opts)
              if (options.hasOwnProperty(key))
                options[key] = opts[key];
          },
          show: function(delay) {
            if (showing)
              return;
            if (delay) {
              if (delayTimerId)
                return;
              delayTimerId = setTimeout(() => topbar2.show(), delay);
            } else {
              showing = true;
              if (fadeTimerId !== null)
                window2.cancelAnimationFrame(fadeTimerId);
              if (!canvas)
                createCanvas();
              canvas.style.opacity = 1;
              canvas.style.display = "block";
              topbar2.progress(0);
              if (options.autoRun) {
                (function loop() {
                  progressTimerId = window2.requestAnimationFrame(loop);
                  topbar2.progress(
                    "+" + 0.05 * Math.pow(1 - Math.sqrt(currentProgress), 2)
                  );
                })();
              }
            }
          },
          progress: function(to) {
            if (typeof to === "undefined")
              return currentProgress;
            if (typeof to === "string") {
              to = (to.indexOf("+") >= 0 || to.indexOf("-") >= 0 ? currentProgress : 0) + parseFloat(to);
            }
            currentProgress = to > 1 ? 1 : to;
            repaint();
            return currentProgress;
          },
          hide: function() {
            clearTimeout(delayTimerId);
            delayTimerId = null;
            if (!showing)
              return;
            showing = false;
            if (progressTimerId != null) {
              window2.cancelAnimationFrame(progressTimerId);
              progressTimerId = null;
            }
            (function loop() {
              if (topbar2.progress("+.1") >= 1) {
                canvas.style.opacity -= 0.05;
                if (canvas.style.opacity <= 0.05) {
                  canvas.style.display = "none";
                  fadeTimerId = null;
                  return;
                }
              }
              fadeTimerId = window2.requestAnimationFrame(loop);
            })();
          }
        };
        if (typeof module === "object" && typeof module.exports === "object") {
          module.exports = topbar2;
        } else if (typeof define === "function" && define.amd) {
          define(function() {
            return topbar2;
          });
        } else {
          this.topbar = topbar2;
        }
      }).call(exports, window, document);
    }
  });

  // vendor/ag-grid-community.min.js
  var require_ag_grid_community_min = __commonJS({
    "vendor/ag-grid-community.min.js"(exports, module) {
      !function(e, t) {
        "object" == typeof exports && "object" == typeof module ? module.exports = t() : "function" == typeof define && define.amd ? define([], t) : "object" == typeof exports ? exports.agGrid = t() : e.agGrid = t();
      }(self, function() {
        return function() {
          "use strict";
          var e = { 8956: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(2487), a2.b), c = new URL(a2(6080), a2.b), g = i()(o()), u = s()(d), h = s()(c);
            g.push([e2.id, '.ag-measurement-container {\n  --ag-legacy-styles-loaded: "true";\n}\n\n.ag-icon {\n  font-family: var(--ag-icon-font-family);\n  font-weight: var(--ag-icon-font-weight);\n  color: var(--ag-icon-font-color);\n  font-size: var(--ag-icon-size);\n  line-height: var(--ag-icon-size);\n  font-style: normal;\n  font-feature-settings: normal;\n  font-variant: normal;\n  text-transform: none;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  width: var(--ag-icon-size);\n  height: var(--ag-icon-size);\n  position: relative;\n}\n.ag-icon::before {\n  content: "";\n  font-family: inherit;\n}\n.ag-icon::after {\n  background: transparent none center/contain no-repeat;\n  background: transparent var(--ag-icon-image, none) center/contain no-repeat;\n  display: var(--ag-icon-image-display);\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity, 0.9);\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  content: "";\n}\n\n.ag-icon-aggregation {\n  font-family: var(--ag-icon-font-family-aggregation, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-aggregation, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-aggregation, var(--ag-icon-font-color));\n}\n\n.ag-icon-aggregation::before {\n  content: "\\f101";\n  content: var(--ag-icon-font-code-aggregation, "\\f101");\n  display: var(--ag-icon-font-display-aggregation, var(--ag-icon-font-display));\n}\n\n.ag-icon-aggregation::after {\n  background-image: var(--ag-icon-image-aggregation, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-aggregation, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-aggregation, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-arrows {\n  font-family: var(--ag-icon-font-family-arrows, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-arrows, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-arrows, var(--ag-icon-font-color));\n}\n\n.ag-icon-arrows::before {\n  content: "\\f102";\n  content: var(--ag-icon-font-code-arrows, "\\f102");\n  display: var(--ag-icon-font-display-arrows, var(--ag-icon-font-display));\n}\n\n.ag-icon-arrows::after {\n  background-image: var(--ag-icon-image-arrows, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-arrows, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-arrows, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-asc {\n  font-family: var(--ag-icon-font-family-asc, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-asc, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-asc, var(--ag-icon-font-color));\n}\n\n.ag-icon-asc::before {\n  content: "\\f103";\n  content: var(--ag-icon-font-code-asc, "\\f103");\n  display: var(--ag-icon-font-display-asc, var(--ag-icon-font-display));\n}\n\n.ag-icon-asc::after {\n  background-image: var(--ag-icon-image-asc, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-asc, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-asc, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-cancel {\n  font-family: var(--ag-icon-font-family-cancel, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-cancel, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-cancel, var(--ag-icon-font-color));\n}\n\n.ag-icon-cancel::before {\n  content: "\\f104";\n  content: var(--ag-icon-font-code-cancel, "\\f104");\n  display: var(--ag-icon-font-display-cancel, var(--ag-icon-font-display));\n}\n\n.ag-icon-cancel::after {\n  background-image: var(--ag-icon-image-cancel, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-cancel, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-cancel, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-chart {\n  font-family: var(--ag-icon-font-family-chart, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-chart, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-chart, var(--ag-icon-font-color));\n}\n\n.ag-icon-chart::before {\n  content: "\\f105";\n  content: var(--ag-icon-font-code-chart, "\\f105");\n  display: var(--ag-icon-font-display-chart, var(--ag-icon-font-display));\n}\n\n.ag-icon-chart::after {\n  background-image: var(--ag-icon-image-chart, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-chart, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-chart, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-checkbox-checked {\n  font-family: var(--ag-icon-font-family-checkbox-checked, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-checkbox-checked, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-checkbox-checked, var(--ag-icon-font-color));\n}\n\n.ag-icon-checkbox-checked::before {\n  content: "\\f106";\n  content: var(--ag-icon-font-code-checkbox-checked, "\\f106");\n  display: var(--ag-icon-font-display-checkbox-checked, var(--ag-icon-font-display));\n}\n\n.ag-icon-checkbox-checked::after {\n  background-image: var(--ag-icon-image-checkbox-checked, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-checkbox-checked, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-checkbox-checked, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-checkbox-indeterminate {\n  font-family: var(--ag-icon-font-family-checkbox-indeterminate, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-checkbox-indeterminate, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-checkbox-indeterminate, var(--ag-icon-font-color));\n}\n\n.ag-icon-checkbox-indeterminate::before {\n  content: "\\f107";\n  content: var(--ag-icon-font-code-checkbox-indeterminate, "\\f107");\n  display: var(--ag-icon-font-display-checkbox-indeterminate, var(--ag-icon-font-display));\n}\n\n.ag-icon-checkbox-indeterminate::after {\n  background-image: var(--ag-icon-image-checkbox-indeterminate, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-checkbox-indeterminate, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-checkbox-indeterminate, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-checkbox-unchecked {\n  font-family: var(--ag-icon-font-family-checkbox-unchecked, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-checkbox-unchecked, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-checkbox-unchecked, var(--ag-icon-font-color));\n}\n\n.ag-icon-checkbox-unchecked::before {\n  content: "\\f108";\n  content: var(--ag-icon-font-code-checkbox-unchecked, "\\f108");\n  display: var(--ag-icon-font-display-checkbox-unchecked, var(--ag-icon-font-display));\n}\n\n.ag-icon-checkbox-unchecked::after {\n  background-image: var(--ag-icon-image-checkbox-unchecked, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-checkbox-unchecked, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-checkbox-unchecked, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-color-picker {\n  font-family: var(--ag-icon-font-family-color-picker, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-color-picker, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-color-picker, var(--ag-icon-font-color));\n}\n\n.ag-icon-color-picker::before {\n  content: "\\f109";\n  content: var(--ag-icon-font-code-color-picker, "\\f109");\n  display: var(--ag-icon-font-display-color-picker, var(--ag-icon-font-display));\n}\n\n.ag-icon-color-picker::after {\n  background-image: var(--ag-icon-image-color-picker, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-color-picker, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-color-picker, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-columns {\n  font-family: var(--ag-icon-font-family-columns, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-columns, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-columns, var(--ag-icon-font-color));\n}\n\n.ag-icon-columns::before {\n  content: "\\f10a";\n  content: var(--ag-icon-font-code-columns, "\\f10a");\n  display: var(--ag-icon-font-display-columns, var(--ag-icon-font-display));\n}\n\n.ag-icon-columns::after {\n  background-image: var(--ag-icon-image-columns, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-columns, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-columns, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-contracted {\n  font-family: var(--ag-icon-font-family-contracted, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-contracted, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-contracted, var(--ag-icon-font-color));\n}\n\n.ag-icon-contracted::before {\n  content: "\\f10b";\n  content: var(--ag-icon-font-code-contracted, "\\f10b");\n  display: var(--ag-icon-font-display-contracted, var(--ag-icon-font-display));\n}\n\n.ag-icon-contracted::after {\n  background-image: var(--ag-icon-image-contracted, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-contracted, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-contracted, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-copy {\n  font-family: var(--ag-icon-font-family-copy, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-copy, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-copy, var(--ag-icon-font-color));\n}\n\n.ag-icon-copy::before {\n  content: "\\f10c";\n  content: var(--ag-icon-font-code-copy, "\\f10c");\n  display: var(--ag-icon-font-display-copy, var(--ag-icon-font-display));\n}\n\n.ag-icon-copy::after {\n  background-image: var(--ag-icon-image-copy, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-copy, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-copy, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-cross {\n  font-family: var(--ag-icon-font-family-cross, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-cross, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-cross, var(--ag-icon-font-color));\n}\n\n.ag-icon-cross::before {\n  content: "\\f10d";\n  content: var(--ag-icon-font-code-cross, "\\f10d");\n  display: var(--ag-icon-font-display-cross, var(--ag-icon-font-display));\n}\n\n.ag-icon-cross::after {\n  background-image: var(--ag-icon-image-cross, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-cross, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-cross, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-csv {\n  font-family: var(--ag-icon-font-family-csv, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-csv, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-csv, var(--ag-icon-font-color));\n}\n\n.ag-icon-csv::before {\n  content: "\\f10e";\n  content: var(--ag-icon-font-code-csv, "\\f10e");\n  display: var(--ag-icon-font-display-csv, var(--ag-icon-font-display));\n}\n\n.ag-icon-csv::after {\n  background-image: var(--ag-icon-image-csv, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-csv, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-csv, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-cut {\n  font-family: var(--ag-icon-font-family-cut, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-cut, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-cut, var(--ag-icon-font-color));\n}\n\n.ag-icon-cut::before {\n  content: "\\f10f";\n  content: var(--ag-icon-font-code-cut, "\\f10f");\n  display: var(--ag-icon-font-display-cut, var(--ag-icon-font-display));\n}\n\n.ag-icon-cut::after {\n  background-image: var(--ag-icon-image-cut, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-cut, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-cut, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-desc {\n  font-family: var(--ag-icon-font-family-desc, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-desc, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-desc, var(--ag-icon-font-color));\n}\n\n.ag-icon-desc::before {\n  content: "\\f110";\n  content: var(--ag-icon-font-code-desc, "\\f110");\n  display: var(--ag-icon-font-display-desc, var(--ag-icon-font-display));\n}\n\n.ag-icon-desc::after {\n  background-image: var(--ag-icon-image-desc, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-desc, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-desc, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-excel {\n  font-family: var(--ag-icon-font-family-excel, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-excel, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-excel, var(--ag-icon-font-color));\n}\n\n.ag-icon-excel::before {\n  content: "\\f111";\n  content: var(--ag-icon-font-code-excel, "\\f111");\n  display: var(--ag-icon-font-display-excel, var(--ag-icon-font-display));\n}\n\n.ag-icon-excel::after {\n  background-image: var(--ag-icon-image-excel, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-excel, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-excel, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-expanded {\n  font-family: var(--ag-icon-font-family-expanded, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-expanded, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-expanded, var(--ag-icon-font-color));\n}\n\n.ag-icon-expanded::before {\n  content: "\\f112";\n  content: var(--ag-icon-font-code-expanded, "\\f112");\n  display: var(--ag-icon-font-display-expanded, var(--ag-icon-font-display));\n}\n\n.ag-icon-expanded::after {\n  background-image: var(--ag-icon-image-expanded, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-expanded, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-expanded, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-eye-slash {\n  font-family: var(--ag-icon-font-family-eye-slash, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-eye-slash, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-eye-slash, var(--ag-icon-font-color));\n}\n\n.ag-icon-eye-slash::before {\n  content: "\\f113";\n  content: var(--ag-icon-font-code-eye-slash, "\\f113");\n  display: var(--ag-icon-font-display-eye-slash, var(--ag-icon-font-display));\n}\n\n.ag-icon-eye-slash::after {\n  background-image: var(--ag-icon-image-eye-slash, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-eye-slash, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-eye-slash, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-eye {\n  font-family: var(--ag-icon-font-family-eye, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-eye, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-eye, var(--ag-icon-font-color));\n}\n\n.ag-icon-eye::before {\n  content: "\\f114";\n  content: var(--ag-icon-font-code-eye, "\\f114");\n  display: var(--ag-icon-font-display-eye, var(--ag-icon-font-display));\n}\n\n.ag-icon-eye::after {\n  background-image: var(--ag-icon-image-eye, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-eye, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-eye, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-filter {\n  font-family: var(--ag-icon-font-family-filter, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-filter, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-filter, var(--ag-icon-font-color));\n}\n\n.ag-icon-filter::before {\n  content: "\\f115";\n  content: var(--ag-icon-font-code-filter, "\\f115");\n  display: var(--ag-icon-font-display-filter, var(--ag-icon-font-display));\n}\n\n.ag-icon-filter::after {\n  background-image: var(--ag-icon-image-filter, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-filter, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-filter, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-first {\n  font-family: var(--ag-icon-font-family-first, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-first, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-first, var(--ag-icon-font-color));\n}\n\n.ag-icon-first::before {\n  content: "\\f116";\n  content: var(--ag-icon-font-code-first, "\\f116");\n  display: var(--ag-icon-font-display-first, var(--ag-icon-font-display));\n}\n\n.ag-icon-first::after {\n  background-image: var(--ag-icon-image-first, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-first, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-first, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-grip {\n  font-family: var(--ag-icon-font-family-grip, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-grip, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-grip, var(--ag-icon-font-color));\n}\n\n.ag-icon-grip::before {\n  content: "\\f117";\n  content: var(--ag-icon-font-code-grip, "\\f117");\n  display: var(--ag-icon-font-display-grip, var(--ag-icon-font-display));\n}\n\n.ag-icon-grip::after {\n  background-image: var(--ag-icon-image-grip, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-grip, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-grip, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-group {\n  font-family: var(--ag-icon-font-family-group, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-group, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-group, var(--ag-icon-font-color));\n}\n\n.ag-icon-group::before {\n  content: "\\f118";\n  content: var(--ag-icon-font-code-group, "\\f118");\n  display: var(--ag-icon-font-display-group, var(--ag-icon-font-display));\n}\n\n.ag-icon-group::after {\n  background-image: var(--ag-icon-image-group, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-group, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-group, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-last {\n  font-family: var(--ag-icon-font-family-last, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-last, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-last, var(--ag-icon-font-color));\n}\n\n.ag-icon-last::before {\n  content: "\\f119";\n  content: var(--ag-icon-font-code-last, "\\f119");\n  display: var(--ag-icon-font-display-last, var(--ag-icon-font-display));\n}\n\n.ag-icon-last::after {\n  background-image: var(--ag-icon-image-last, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-last, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-last, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-left {\n  font-family: var(--ag-icon-font-family-left, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-left, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-left, var(--ag-icon-font-color));\n}\n\n.ag-icon-left::before {\n  content: "\\f11a";\n  content: var(--ag-icon-font-code-left, "\\f11a");\n  display: var(--ag-icon-font-display-left, var(--ag-icon-font-display));\n}\n\n.ag-icon-left::after {\n  background-image: var(--ag-icon-image-left, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-left, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-left, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-linked {\n  font-family: var(--ag-icon-font-family-linked, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-linked, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-linked, var(--ag-icon-font-color));\n}\n\n.ag-icon-linked::before {\n  content: "\\f11b";\n  content: var(--ag-icon-font-code-linked, "\\f11b");\n  display: var(--ag-icon-font-display-linked, var(--ag-icon-font-display));\n}\n\n.ag-icon-linked::after {\n  background-image: var(--ag-icon-image-linked, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-linked, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-linked, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-loading {\n  font-family: var(--ag-icon-font-family-loading, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-loading, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-loading, var(--ag-icon-font-color));\n}\n\n.ag-icon-loading::before {\n  content: "\\f11c";\n  content: var(--ag-icon-font-code-loading, "\\f11c");\n  display: var(--ag-icon-font-display-loading, var(--ag-icon-font-display));\n}\n\n.ag-icon-loading::after {\n  background-image: var(--ag-icon-image-loading, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-loading, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-loading, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-maximize {\n  font-family: var(--ag-icon-font-family-maximize, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-maximize, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-maximize, var(--ag-icon-font-color));\n}\n\n.ag-icon-maximize::before {\n  content: "\\f11d";\n  content: var(--ag-icon-font-code-maximize, "\\f11d");\n  display: var(--ag-icon-font-display-maximize, var(--ag-icon-font-display));\n}\n\n.ag-icon-maximize::after {\n  background-image: var(--ag-icon-image-maximize, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-maximize, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-maximize, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-menu {\n  font-family: var(--ag-icon-font-family-menu, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-menu, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-menu, var(--ag-icon-font-color));\n}\n\n.ag-icon-menu::before {\n  content: "\\f11e";\n  content: var(--ag-icon-font-code-menu, "\\f11e");\n  display: var(--ag-icon-font-display-menu, var(--ag-icon-font-display));\n}\n\n.ag-icon-menu::after {\n  background-image: var(--ag-icon-image-menu, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-menu, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-menu, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-minimize {\n  font-family: var(--ag-icon-font-family-minimize, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-minimize, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-minimize, var(--ag-icon-font-color));\n}\n\n.ag-icon-minimize::before {\n  content: "\\f11f";\n  content: var(--ag-icon-font-code-minimize, "\\f11f");\n  display: var(--ag-icon-font-display-minimize, var(--ag-icon-font-display));\n}\n\n.ag-icon-minimize::after {\n  background-image: var(--ag-icon-image-minimize, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-minimize, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-minimize, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-next {\n  font-family: var(--ag-icon-font-family-next, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-next, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-next, var(--ag-icon-font-color));\n}\n\n.ag-icon-next::before {\n  content: "\\f120";\n  content: var(--ag-icon-font-code-next, "\\f120");\n  display: var(--ag-icon-font-display-next, var(--ag-icon-font-display));\n}\n\n.ag-icon-next::after {\n  background-image: var(--ag-icon-image-next, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-next, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-next, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-none {\n  font-family: var(--ag-icon-font-family-none, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-none, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-none, var(--ag-icon-font-color));\n}\n\n.ag-icon-none::before {\n  content: "\\f121";\n  content: var(--ag-icon-font-code-none, "\\f121");\n  display: var(--ag-icon-font-display-none, var(--ag-icon-font-display));\n}\n\n.ag-icon-none::after {\n  background-image: var(--ag-icon-image-none, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-none, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-none, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-not-allowed {\n  font-family: var(--ag-icon-font-family-not-allowed, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-not-allowed, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-not-allowed, var(--ag-icon-font-color));\n}\n\n.ag-icon-not-allowed::before {\n  content: "\\f122";\n  content: var(--ag-icon-font-code-not-allowed, "\\f122");\n  display: var(--ag-icon-font-display-not-allowed, var(--ag-icon-font-display));\n}\n\n.ag-icon-not-allowed::after {\n  background-image: var(--ag-icon-image-not-allowed, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-not-allowed, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-not-allowed, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-paste {\n  font-family: var(--ag-icon-font-family-paste, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-paste, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-paste, var(--ag-icon-font-color));\n}\n\n.ag-icon-paste::before {\n  content: "\\f123";\n  content: var(--ag-icon-font-code-paste, "\\f123");\n  display: var(--ag-icon-font-display-paste, var(--ag-icon-font-display));\n}\n\n.ag-icon-paste::after {\n  background-image: var(--ag-icon-image-paste, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-paste, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-paste, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-pin {\n  font-family: var(--ag-icon-font-family-pin, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-pin, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-pin, var(--ag-icon-font-color));\n}\n\n.ag-icon-pin::before {\n  content: "\\f124";\n  content: var(--ag-icon-font-code-pin, "\\f124");\n  display: var(--ag-icon-font-display-pin, var(--ag-icon-font-display));\n}\n\n.ag-icon-pin::after {\n  background-image: var(--ag-icon-image-pin, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-pin, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-pin, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-pivot {\n  font-family: var(--ag-icon-font-family-pivot, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-pivot, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-pivot, var(--ag-icon-font-color));\n}\n\n.ag-icon-pivot::before {\n  content: "\\f125";\n  content: var(--ag-icon-font-code-pivot, "\\f125");\n  display: var(--ag-icon-font-display-pivot, var(--ag-icon-font-display));\n}\n\n.ag-icon-pivot::after {\n  background-image: var(--ag-icon-image-pivot, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-pivot, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-pivot, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-previous {\n  font-family: var(--ag-icon-font-family-previous, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-previous, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-previous, var(--ag-icon-font-color));\n}\n\n.ag-icon-previous::before {\n  content: "\\f126";\n  content: var(--ag-icon-font-code-previous, "\\f126");\n  display: var(--ag-icon-font-display-previous, var(--ag-icon-font-display));\n}\n\n.ag-icon-previous::after {\n  background-image: var(--ag-icon-image-previous, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-previous, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-previous, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-radio-button-off {\n  font-family: var(--ag-icon-font-family-radio-button-off, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-radio-button-off, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-radio-button-off, var(--ag-icon-font-color));\n}\n\n.ag-icon-radio-button-off::before {\n  content: "\\f127";\n  content: var(--ag-icon-font-code-radio-button-off, "\\f127");\n  display: var(--ag-icon-font-display-radio-button-off, var(--ag-icon-font-display));\n}\n\n.ag-icon-radio-button-off::after {\n  background-image: var(--ag-icon-image-radio-button-off, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-radio-button-off, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-radio-button-off, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-radio-button-on {\n  font-family: var(--ag-icon-font-family-radio-button-on, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-radio-button-on, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-radio-button-on, var(--ag-icon-font-color));\n}\n\n.ag-icon-radio-button-on::before {\n  content: "\\f128";\n  content: var(--ag-icon-font-code-radio-button-on, "\\f128");\n  display: var(--ag-icon-font-display-radio-button-on, var(--ag-icon-font-display));\n}\n\n.ag-icon-radio-button-on::after {\n  background-image: var(--ag-icon-image-radio-button-on, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-radio-button-on, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-radio-button-on, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-right {\n  font-family: var(--ag-icon-font-family-right, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-right, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-right, var(--ag-icon-font-color));\n}\n\n.ag-icon-right::before {\n  content: "\\f129";\n  content: var(--ag-icon-font-code-right, "\\f129");\n  display: var(--ag-icon-font-display-right, var(--ag-icon-font-display));\n}\n\n.ag-icon-right::after {\n  background-image: var(--ag-icon-image-right, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-right, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-right, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-save {\n  font-family: var(--ag-icon-font-family-save, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-save, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-save, var(--ag-icon-font-color));\n}\n\n.ag-icon-save::before {\n  content: "\\f12a";\n  content: var(--ag-icon-font-code-save, "\\f12a");\n  display: var(--ag-icon-font-display-save, var(--ag-icon-font-display));\n}\n\n.ag-icon-save::after {\n  background-image: var(--ag-icon-image-save, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-save, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-save, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-small-down {\n  font-family: var(--ag-icon-font-family-small-down, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-small-down, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-small-down, var(--ag-icon-font-color));\n}\n\n.ag-icon-small-down::before {\n  content: "\\f12b";\n  content: var(--ag-icon-font-code-small-down, "\\f12b");\n  display: var(--ag-icon-font-display-small-down, var(--ag-icon-font-display));\n}\n\n.ag-icon-small-down::after {\n  background-image: var(--ag-icon-image-small-down, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-small-down, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-small-down, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-small-left {\n  font-family: var(--ag-icon-font-family-small-left, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-small-left, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-small-left, var(--ag-icon-font-color));\n}\n\n.ag-icon-small-left::before {\n  content: "\\f12c";\n  content: var(--ag-icon-font-code-small-left, "\\f12c");\n  display: var(--ag-icon-font-display-small-left, var(--ag-icon-font-display));\n}\n\n.ag-icon-small-left::after {\n  background-image: var(--ag-icon-image-small-left, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-small-left, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-small-left, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-small-right {\n  font-family: var(--ag-icon-font-family-small-right, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-small-right, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-small-right, var(--ag-icon-font-color));\n}\n\n.ag-icon-small-right::before {\n  content: "\\f12d";\n  content: var(--ag-icon-font-code-small-right, "\\f12d");\n  display: var(--ag-icon-font-display-small-right, var(--ag-icon-font-display));\n}\n\n.ag-icon-small-right::after {\n  background-image: var(--ag-icon-image-small-right, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-small-right, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-small-right, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-small-up {\n  font-family: var(--ag-icon-font-family-small-up, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-small-up, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-small-up, var(--ag-icon-font-color));\n}\n\n.ag-icon-small-up::before {\n  content: "\\f12e";\n  content: var(--ag-icon-font-code-small-up, "\\f12e");\n  display: var(--ag-icon-font-display-small-up, var(--ag-icon-font-display));\n}\n\n.ag-icon-small-up::after {\n  background-image: var(--ag-icon-image-small-up, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-small-up, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-small-up, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-tick {\n  font-family: var(--ag-icon-font-family-tick, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-tick, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-tick, var(--ag-icon-font-color));\n}\n\n.ag-icon-tick::before {\n  content: "\\f12f";\n  content: var(--ag-icon-font-code-tick, "\\f12f");\n  display: var(--ag-icon-font-display-tick, var(--ag-icon-font-display));\n}\n\n.ag-icon-tick::after {\n  background-image: var(--ag-icon-image-tick, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-tick, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-tick, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-tree-closed {\n  font-family: var(--ag-icon-font-family-tree-closed, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-tree-closed, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-tree-closed, var(--ag-icon-font-color));\n}\n\n.ag-icon-tree-closed::before {\n  content: "\\f130";\n  content: var(--ag-icon-font-code-tree-closed, "\\f130");\n  display: var(--ag-icon-font-display-tree-closed, var(--ag-icon-font-display));\n}\n\n.ag-icon-tree-closed::after {\n  background-image: var(--ag-icon-image-tree-closed, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-tree-closed, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-tree-closed, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-tree-indeterminate {\n  font-family: var(--ag-icon-font-family-tree-indeterminate, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-tree-indeterminate, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-tree-indeterminate, var(--ag-icon-font-color));\n}\n\n.ag-icon-tree-indeterminate::before {\n  content: "\\f131";\n  content: var(--ag-icon-font-code-tree-indeterminate, "\\f131");\n  display: var(--ag-icon-font-display-tree-indeterminate, var(--ag-icon-font-display));\n}\n\n.ag-icon-tree-indeterminate::after {\n  background-image: var(--ag-icon-image-tree-indeterminate, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-tree-indeterminate, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-tree-indeterminate, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-tree-open {\n  font-family: var(--ag-icon-font-family-tree-open, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-tree-open, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-tree-open, var(--ag-icon-font-color));\n}\n\n.ag-icon-tree-open::before {\n  content: "\\f132";\n  content: var(--ag-icon-font-code-tree-open, "\\f132");\n  display: var(--ag-icon-font-display-tree-open, var(--ag-icon-font-display));\n}\n\n.ag-icon-tree-open::after {\n  background-image: var(--ag-icon-image-tree-open, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-tree-open, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-tree-open, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-unlinked {\n  font-family: var(--ag-icon-font-family-unlinked, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-unlinked, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-unlinked, var(--ag-icon-font-color));\n}\n\n.ag-icon-unlinked::before {\n  content: "\\f133";\n  content: var(--ag-icon-font-code-unlinked, "\\f133");\n  display: var(--ag-icon-font-display-unlinked, var(--ag-icon-font-display));\n}\n\n.ag-icon-unlinked::after {\n  background-image: var(--ag-icon-image-unlinked, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-unlinked, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-unlinked, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-up {\n  font-family: var(--ag-icon-font-family-up, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-up, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-up, var(--ag-icon-font-color));\n}\n\n.ag-icon-up::before {\n  content: "\\f134";\n  content: var(--ag-icon-font-code-up, "\\f134");\n  display: var(--ag-icon-font-display-up, var(--ag-icon-font-display));\n}\n\n.ag-icon-up::after {\n  background-image: var(--ag-icon-image-up, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-up, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-up, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-down {\n  font-family: var(--ag-icon-font-family-down, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-down, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-down, var(--ag-icon-font-color));\n}\n\n.ag-icon-down::before {\n  content: "\\f135";\n  content: var(--ag-icon-font-code-down, "\\f135");\n  display: var(--ag-icon-font-display-down, var(--ag-icon-font-display));\n}\n\n.ag-icon-down::after {\n  background-image: var(--ag-icon-image-down, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-down, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-down, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-plus {\n  font-family: var(--ag-icon-font-family-plus, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-plus, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-plus, var(--ag-icon-font-color));\n}\n\n.ag-icon-plus::before {\n  content: "\\f136";\n  content: var(--ag-icon-font-code-plus, "\\f136");\n  display: var(--ag-icon-font-display-plus, var(--ag-icon-font-display));\n}\n\n.ag-icon-plus::after {\n  background-image: var(--ag-icon-image-plus, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-plus, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-plus, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-minus {\n  font-family: var(--ag-icon-font-family-minus, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-minus, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-minus, var(--ag-icon-font-color));\n}\n\n.ag-icon-minus::before {\n  content: "\\f137";\n  content: var(--ag-icon-font-code-minus, "\\f137");\n  display: var(--ag-icon-font-display-minus, var(--ag-icon-font-display));\n}\n\n.ag-icon-minus::after {\n  background-image: var(--ag-icon-image-minus, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-minus, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-minus, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-menu-alt {\n  font-family: var(--ag-icon-font-family-menu-alt, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-menu-alt, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-menu-alt, var(--ag-icon-font-color));\n}\n\n.ag-icon-menu-alt::before {\n  content: "\\f138";\n  content: var(--ag-icon-font-code-menu-alt, "\\f138");\n  display: var(--ag-icon-font-display-menu-alt, var(--ag-icon-font-display));\n}\n\n.ag-icon-menu-alt::after {\n  background-image: var(--ag-icon-image-menu-alt, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-menu-alt, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-menu-alt, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-settings {\n  font-family: var(--ag-icon-font-family-settings, var(--ag-icon-font-family));\n  font-weight: var(--ag-icon-font-weight-settings, var(--ag-icon-font-weight));\n  color: var(--ag-icon-font-color-settings, var(--ag-icon-font-color));\n}\n\n.ag-icon-settings::before {\n  content: "\\f139";\n  content: var(--ag-icon-font-code-settings, "\\f139");\n  display: var(--ag-icon-font-display-settings, var(--ag-icon-font-display));\n}\n\n.ag-icon-settings::after {\n  background-image: var(--ag-icon-image-settings, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-settings, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-settings, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-icon-row-drag::before {\n  content: var(--ag-icon-font-code-grip);\n}\n\n.ag-left-arrow::before {\n  content: var(--ag-icon-font-code-left);\n}\n\n.ag-right-arrow::before {\n  content: var(--ag-icon-font-code-right);\n}\n\n[class*=ag-theme-] {\n  --ag-foreground-color: #000;\n  --ag-data-color: var(--ag-foreground-color);\n  --ag-secondary-foreground-color: var(--ag-foreground-color);\n  --ag-header-foreground-color: var(--ag-secondary-foreground-color);\n  --ag-disabled-foreground-color: rgba(0, 0, 0, 0.5);\n  --ag-background-color: #fff;\n  --ag-header-background-color: transparent;\n  --ag-tooltip-background-color: transparent;\n  --ag-subheader-background-color: transparent;\n  --ag-subheader-toolbar-background-color: transparent;\n  --ag-control-panel-background-color: transparent;\n  --ag-side-button-selected-background-color: var(--ag-control-panel-background-color);\n  --ag-selected-row-background-color: #bbb;\n  --ag-odd-row-background-color: var(--ag-background-color);\n  --ag-modal-overlay-background-color: rgba(255, 255, 255, 0.66);\n  --ag-menu-background-color: var(--ag-background-color);\n  --ag-menu-border-color: var(--ag-border-color);\n  --ag-panel-background-color: var(--ag-background-color);\n  --ag-panel-border-color: var(--ag-border-color);\n  --ag-row-hover-color: transparent;\n  --ag-column-hover-color: transparent;\n  --ag-range-selection-border-color: var(--ag-foreground-color);\n  --ag-range-selection-border-style: solid;\n  --ag-range-selection-background-color: rgba(0, 0, 0, 0.2);\n  --ag-range-selection-background-color-2: var(--ag-range-selection-background-color);\n  --ag-range-selection-background-color-3: var(--ag-range-selection-background-color);\n  --ag-range-selection-background-color-4: var(--ag-range-selection-background-color);\n  --ag-range-selection-highlight-color: var(--ag-range-selection-border-color);\n  --ag-selected-tab-underline-color: var(--ag-range-selection-border-color);\n  --ag-selected-tab-underline-width: 0;\n  --ag-selected-tab-underline-transition-speed: 0s;\n  --ag-range-selection-chart-category-background-color: rgba(0, 255, 132, 0.1);\n  --ag-range-selection-chart-background-color: rgba(0, 88, 255, 0.1);\n  --ag-header-cell-hover-background-color: transparent;\n  --ag-header-cell-moving-background-color: var(--ag-background-color);\n  --ag-value-change-value-highlight-background-color: rgba(22, 160, 133, 0.5);\n  --ag-value-change-delta-up-color: #43a047;\n  --ag-value-change-delta-down-color: #e53935;\n  --ag-row-loading-skeleton-effect-color: rgba(66, 66, 66, 0.2);\n  --ag-chip-background-color: transparent;\n  --ag-chip-border-color: var(--ag-chip-background-color);\n  --ag-borders: solid 1px;\n  --ag-border-color: rgba(0, 0, 0, 0.25);\n  --ag-borders-critical: var(--ag-borders);\n  --ag-borders-secondary: var(--ag-borders);\n  --ag-secondary-border-color: var(--ag-border-color);\n  --ag-row-border-style: solid;\n  --ag-row-border-color: var(--ag-secondary-border-color);\n  --ag-row-border-width: 1px;\n  --ag-cell-horizontal-border: solid transparent;\n  --ag-borders-input: var(--ag-borders-secondary);\n  --ag-input-border-color: var(--ag-secondary-border-color);\n  --ag-borders-input-invalid: solid 2px;\n  --ag-input-border-color-invalid: var(--ag-invalid-color);\n  --ag-borders-side-button: var(--ag-borders);\n  --ag-border-radius: 0px;\n  --ag-wrapper-border-radius: var(--ag-border-radius);\n  --ag-row-border-color: var(--ag-secondary-border-color);\n  --ag-header-column-separator-display: none;\n  --ag-header-column-separator-height: 100%;\n  --ag-header-column-separator-width: 1px;\n  --ag-header-column-separator-color: var(--ag-secondary-border-color);\n  --ag-header-column-resize-handle-display: none;\n  --ag-header-column-resize-handle-height: 50%;\n  --ag-header-column-resize-handle-width: 1px;\n  --ag-header-column-resize-handle-color: var(--ag-secondary-border-color);\n  --ag-invalid-color: red;\n  --ag-input-disabled-border-color: var(--ag-input-border-color);\n  --ag-input-disabled-background-color: transparent;\n  --ag-checkbox-background-color: transparent;\n  --ag-checkbox-border-radius: var(--ag-border-radius);\n  --ag-checkbox-checked-color: var(--ag-foreground-color);\n  --ag-checkbox-unchecked-color: var(--ag-foreground-color);\n  --ag-checkbox-indeterminate-color: var(--ag-checkbox-unchecked-color);\n  --ag-toggle-button-off-border-color: var(--ag-checkbox-unchecked-color);\n  --ag-toggle-button-off-background-color: var(--ag-checkbox-unchecked-color);\n  --ag-toggle-button-on-border-color: var(--ag-checkbox-checked-color);\n  --ag-toggle-button-on-background-color: var(--ag-checkbox-checked-color);\n  --ag-toggle-button-switch-background-color: var(--ag-background-color);\n  --ag-toggle-button-switch-border-color: var(--ag-toggle-button-off-border-color);\n  --ag-toggle-button-border-width: 1px;\n  --ag-toggle-button-height: var(--ag-icon-size);\n  --ag-toggle-button-width: calc(var(--ag-toggle-button-height) * 2);\n  --ag-input-focus-box-shadow: none;\n  --ag-input-focus-border-color: none;\n  --ag-minichart-selected-chart-color: var(--ag-checkbox-checked-color);\n  --ag-minichart-selected-page-color: var(--ag-checkbox-checked-color);\n  --ag-grid-size: 4px;\n  --ag-icon-size: 12px;\n  --ag-icon-font-weight: normal;\n  --ag-icon-font-color: var(--ag-foreground-color);\n  --ag-icon-image-display: block;\n  --ag-widget-container-horizontal-padding: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-container-vertical-padding: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-horizontal-spacing: calc(var(--ag-grid-size) * 2);\n  --ag-widget-vertical-spacing: var(--ag-grid-size);\n  --ag-cell-horizontal-padding: calc(var(--ag-grid-size) * 3);\n  --ag-cell-widget-spacing: var(--ag-cell-horizontal-padding);\n  --ag-row-height: calc(var(--ag-grid-size) * 6 + 1px);\n  --ag-header-height: var(--ag-row-height);\n  --ag-list-item-height: calc(var(--ag-grid-size) * 5);\n  --ag-column-select-indent-size: calc(var(--ag-grid-size) + var(--ag-icon-size));\n  --ag-set-filter-indent-size: calc(var(--ag-grid-size) + var(--ag-icon-size));\n  --ag-advanced-filter-builder-indent-size: calc(var(--ag-grid-size) * 2 + var(--ag-icon-size));\n  --ag-row-group-indent-size: calc(var(--ag-cell-widget-spacing) + var(--ag-icon-size));\n  --ag-filter-tool-panel-group-indent: 16px;\n  --ag-tab-min-width: 220px;\n  --ag-chart-menu-panel-width: var(--ag-tab-min-width);\n  --ag-menu-min-width: 181px;\n  --ag-side-bar-panel-width: 200px;\n  --ag-font-family: "Helvetica Neue", sans-serif;\n  --ag-font-size: 14px;\n  --ag-card-radius: var(--ag-border-radius);\n  --ag-card-shadow: none;\n  --ag-popup-shadow: 5px 5px 10px rgba(0, 0, 0, 0.3);\n  --ag-advanced-filter-join-pill-color: #f08e8d;\n  --ag-advanced-filter-column-pill-color: #a6e194;\n  --ag-advanced-filter-option-pill-color: #f3c08b;\n  --ag-advanced-filter-value-pill-color: #85c0e4;\n}\n\n.ag-root-wrapper,\n.ag-sticky-top,\n.ag-sticky-bottom,\n.ag-dnd-ghost {\n  background-color: var(--ag-background-color);\n}\n\n.ag-sticky-bottom {\n  border-top: var(--ag-row-border-style) var(--ag-row-border-color) var(--ag-row-border-width);\n}\n\n.ag-root-wrapper,\n.ag-popup {\n  --ag-indentation-level: 0;\n}\n\n[class*=ag-theme-] {\n  -webkit-font-smoothing: antialiased;\n  font-family: var(--ag-font-family);\n  font-size: var(--ag-font-size);\n  line-height: normal;\n  color: var(--ag-foreground-color);\n}\n\nag-grid,\nag-grid-angular,\nag-grid-ng2,\nag-grid-polymer,\nag-grid-aurelia {\n  display: block;\n}\n\n.ag-aria-description-container {\n  z-index: 9999;\n  border: 0px;\n  clip: rect(1px, 1px, 1px, 1px);\n  height: 1px;\n  width: 1px;\n  position: absolute;\n  overflow: hidden;\n  padding: 0px;\n  white-space: nowrap;\n}\n\n.ag-hidden {\n  display: none !important;\n}\n\n.ag-invisible {\n  visibility: hidden !important;\n}\n\n.ag-drag-handle {\n  cursor: grab;\n}\n\n.ag-column-drop-wrapper {\n  display: flex;\n}\n\n.ag-column-drop-horizontal-half-width {\n  display: inline-block;\n  width: 50% !important;\n}\n\n.ag-unselectable {\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n}\n\n.ag-selectable {\n  -moz-user-select: text;\n  -webkit-user-select: text;\n  user-select: text;\n}\n\n.ag-tab {\n  position: relative;\n}\n\n.ag-tab-guard {\n  position: absolute;\n  width: 0;\n  height: 0;\n  display: block;\n}\n\n.ag-virtual-list-viewport .ag-tab-guard {\n  position: sticky;\n}\n\n.ag-tab-guard-top {\n  top: 1px;\n}\n\n.ag-tab-guard-bottom {\n  bottom: 1px;\n}\n\n.ag-select-agg-func-popup {\n  position: absolute;\n}\n\n.ag-input-wrapper,\n.ag-picker-field-wrapper {\n  display: flex;\n  flex: 1 1 auto;\n  align-items: center;\n  line-height: normal;\n  position: relative;\n}\n\n.ag-shake-left-to-right {\n  animation-direction: alternate;\n  animation-duration: 0.2s;\n  animation-iteration-count: infinite;\n  animation-name: ag-shake-left-to-right;\n}\n\n@keyframes ag-shake-left-to-right {\n  from {\n    padding-left: 6px;\n    padding-right: 2px;\n  }\n  to {\n    padding-left: 2px;\n    padding-right: 6px;\n  }\n}\n.ag-root-wrapper {\n  cursor: default;\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  overflow: hidden;\n  white-space: normal;\n}\n.ag-root-wrapper.ag-layout-normal {\n  height: 100%;\n}\n\n.ag-watermark {\n  position: absolute;\n  bottom: 20px;\n  right: 25px;\n  opacity: 0.7;\n  transition: opacity 1s ease-out 3s;\n  color: #9b9b9b;\n}\n.ag-watermark::before {\n  content: "";\n  background-image: url(' + u + ");\n  background-repeat: no-repeat;\n  background-size: 170px 40px;\n  display: block;\n  height: 40px;\n  width: 170px;\n}\n\n.ag-watermark-text {\n  opacity: 0.5;\n  font-weight: bold;\n  font-family: Impact, sans-serif;\n  font-size: 19px;\n  padding-left: 0.7rem;\n}\n\n.ag-root-wrapper-body {\n  display: flex;\n  flex-direction: row;\n}\n.ag-root-wrapper-body.ag-layout-normal {\n  flex: 1 1 auto;\n  height: 0;\n  min-height: 0;\n}\n\n.ag-root {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n}\n.ag-root.ag-layout-normal, .ag-root.ag-layout-auto-height {\n  overflow: hidden;\n  flex: 1 1 auto;\n  width: 0;\n}\n.ag-root.ag-layout-normal {\n  height: 100%;\n}\n\n.ag-header-viewport,\n.ag-floating-top-viewport,\n.ag-body-viewport,\n.ag-center-cols-viewport,\n.ag-floating-bottom-viewport,\n.ag-body-horizontal-scroll-viewport,\n.ag-body-vertical-scroll-viewport,\n.ag-virtual-list-viewport,\n.ag-sticky-top-viewport,\n.ag-sticky-bottom-viewport {\n  position: relative;\n  height: 100%;\n  min-width: 0px;\n  overflow: hidden;\n  flex: 1 1 auto;\n}\n\n.ag-body-viewport,\n.ag-center-cols-viewport,\n.ag-header-viewport,\n.ag-floating-top-viewport,\n.ag-floating-bottom-viewport,\n.ag-sticky-top-viewport,\n.ag-sticky-bottom-viewport {\n  overflow-x: auto;\n  -ms-overflow-style: none !important;\n  scrollbar-width: none !important;\n}\n.ag-body-viewport::-webkit-scrollbar,\n.ag-center-cols-viewport::-webkit-scrollbar,\n.ag-header-viewport::-webkit-scrollbar,\n.ag-floating-top-viewport::-webkit-scrollbar,\n.ag-floating-bottom-viewport::-webkit-scrollbar,\n.ag-sticky-top-viewport::-webkit-scrollbar,\n.ag-sticky-bottom-viewport::-webkit-scrollbar {\n  display: none !important;\n}\n\n.ag-body-viewport {\n  display: flex;\n  overflow-x: hidden;\n}\n.ag-body-viewport.ag-layout-normal {\n  overflow-y: auto;\n  -webkit-overflow-scrolling: touch;\n}\n\n.ag-sticky-top-container,\n.ag-sticky-bottom-container {\n  min-height: 1px;\n}\n\n.ag-center-cols-viewport {\n  min-height: 100%;\n  width: 100%;\n}\n\n.ag-body-horizontal-scroll-viewport {\n  overflow-x: scroll;\n}\n\n.ag-body-vertical-scroll-viewport {\n  overflow-y: scroll;\n}\n\n.ag-virtual-list-viewport {\n  overflow: auto;\n  width: 100%;\n}\n\n.ag-header-container,\n.ag-floating-top-container,\n.ag-body-container,\n.ag-pinned-right-cols-container,\n.ag-center-cols-container,\n.ag-pinned-left-cols-container,\n.ag-floating-bottom-container,\n.ag-body-horizontal-scroll-container,\n.ag-body-vertical-scroll-container,\n.ag-full-width-container,\n.ag-floating-bottom-full-width-container,\n.ag-virtual-list-container,\n.ag-sticky-top-container,\n.ag-sticky-bottom-container {\n  position: relative;\n}\n\n.ag-header-container,\n.ag-floating-top-container,\n.ag-floating-bottom-container,\n.ag-sticky-top-container,\n.ag-sticky-bottom-container {\n  height: 100%;\n  white-space: nowrap;\n}\n\n.ag-center-cols-container {\n  display: block;\n}\n\n.ag-pinned-right-cols-container {\n  display: block;\n}\n\n.ag-body-horizontal-scroll-container {\n  height: 100%;\n}\n\n.ag-body-vertical-scroll-container {\n  width: 100%;\n}\n\n.ag-full-width-container,\n.ag-floating-top-full-width-container,\n.ag-floating-bottom-full-width-container,\n.ag-sticky-top-full-width-container,\n.ag-sticky-bottom-full-width-container {\n  position: absolute;\n  top: 0px;\n  pointer-events: none;\n}\n.ag-ltr .ag-full-width-container,\n.ag-ltr .ag-floating-top-full-width-container,\n.ag-ltr .ag-floating-bottom-full-width-container,\n.ag-ltr .ag-sticky-top-full-width-container,\n.ag-ltr .ag-sticky-bottom-full-width-container {\n  left: 0;\n}\n.ag-rtl .ag-full-width-container,\n.ag-rtl .ag-floating-top-full-width-container,\n.ag-rtl .ag-floating-bottom-full-width-container,\n.ag-rtl .ag-sticky-top-full-width-container,\n.ag-rtl .ag-sticky-bottom-full-width-container {\n  right: 0;\n}\n\n.ag-full-width-container {\n  width: 100%;\n}\n\n.ag-floating-bottom-full-width-container,\n.ag-floating-top-full-width-container {\n  display: inline-block;\n  overflow: hidden;\n  height: 100%;\n  width: 100%;\n}\n\n.ag-virtual-list-container {\n  overflow: hidden;\n}\n\n.ag-body {\n  position: relative;\n  display: flex;\n  flex: 1 1 auto;\n  flex-direction: row !important;\n  min-height: 0;\n}\n\n.ag-body-horizontal-scroll,\n.ag-body-vertical-scroll {\n  min-height: 0;\n  min-width: 0;\n  display: flex;\n  position: relative;\n}\n.ag-body-horizontal-scroll.ag-scrollbar-invisible,\n.ag-body-vertical-scroll.ag-scrollbar-invisible {\n  position: absolute;\n  bottom: 0;\n}\n.ag-body-horizontal-scroll.ag-scrollbar-invisible.ag-apple-scrollbar,\n.ag-body-vertical-scroll.ag-scrollbar-invisible.ag-apple-scrollbar {\n  opacity: 0;\n  transition: opacity 400ms;\n  visibility: hidden;\n}\n.ag-body-horizontal-scroll.ag-scrollbar-invisible.ag-apple-scrollbar.ag-scrollbar-scrolling, .ag-body-horizontal-scroll.ag-scrollbar-invisible.ag-apple-scrollbar.ag-scrollbar-active,\n.ag-body-vertical-scroll.ag-scrollbar-invisible.ag-apple-scrollbar.ag-scrollbar-scrolling,\n.ag-body-vertical-scroll.ag-scrollbar-invisible.ag-apple-scrollbar.ag-scrollbar-active {\n  visibility: visible;\n  opacity: 1;\n}\n\n.ag-body-horizontal-scroll {\n  width: 100%;\n}\n.ag-body-horizontal-scroll.ag-scrollbar-invisible {\n  left: 0;\n  right: 0;\n}\n\n.ag-body-vertical-scroll {\n  height: 100%;\n}\n.ag-body-vertical-scroll.ag-scrollbar-invisible {\n  top: 0;\n  z-index: 10;\n}\n.ag-ltr .ag-body-vertical-scroll.ag-scrollbar-invisible {\n  right: 0;\n}\n.ag-rtl .ag-body-vertical-scroll.ag-scrollbar-invisible {\n  left: 0;\n}\n\n.ag-force-vertical-scroll {\n  overflow-y: scroll !important;\n}\n\n.ag-horizontal-left-spacer,\n.ag-horizontal-right-spacer {\n  height: 100%;\n  min-width: 0;\n  overflow-x: scroll;\n}\n.ag-horizontal-left-spacer.ag-scroller-corner,\n.ag-horizontal-right-spacer.ag-scroller-corner {\n  overflow-x: hidden;\n}\n\n.ag-header,\n.ag-pinned-left-header,\n.ag-pinned-right-header {\n  display: inline-block;\n  overflow: hidden;\n  position: relative;\n}\n\n.ag-header-cell-sortable .ag-header-cell-label {\n  cursor: pointer;\n}\n\n.ag-header {\n  display: flex;\n  width: 100%;\n  white-space: nowrap;\n}\n\n.ag-pinned-left-header {\n  height: 100%;\n}\n\n.ag-pinned-right-header {\n  height: 100%;\n}\n\n.ag-header-row {\n  position: absolute;\n}\n\n.ag-header-row:not(.ag-header-row-column-group) {\n  overflow: hidden;\n}\n\n.ag-header.ag-header-allow-overflow .ag-header-row {\n  overflow: visible;\n}\n\n.ag-header-cell {\n  display: inline-flex;\n  align-items: center;\n  position: absolute;\n  height: 100%;\n  overflow: hidden;\n}\n\n.ag-header-cell.ag-header-active .ag-header-cell-menu-button,\n.ag-header-cell-filter-button {\n  opacity: 1;\n}\n\n.ag-header-cell-menu-button:not(.ag-header-menu-always-show) {\n  transition: opacity 0.2s;\n  opacity: 0;\n}\n\n.ag-header-group-cell-label,\n.ag-header-cell-label {\n  display: flex;\n  flex: 1 1 auto;\n  align-self: stretch;\n  align-items: center;\n  overflow: hidden;\n}\n\n.ag-header-cell-label {\n  text-overflow: ellipsis;\n}\n\n.ag-header-group-cell-label.ag-sticky-label {\n  position: sticky;\n  flex: none;\n  max-width: 100%;\n  overflow: visible;\n}\n\n.ag-header-group-text {\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.ag-header-cell-text {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  word-break: break-word;\n}\n\n.ag-header-group-cell .ag-header-cell-comp-wrapper {\n  display: flex;\n}\n\n.ag-header-cell:not(.ag-header-cell-auto-height) .ag-header-cell-comp-wrapper {\n  height: 100%;\n  display: flex;\n  align-items: center;\n}\n\n.ag-header-cell-comp-wrapper {\n  width: 100%;\n}\n\n.ag-header-cell-wrap-text .ag-header-cell-comp-wrapper {\n  white-space: normal;\n}\n\n.ag-header-cell-comp-wrapper-limited-height > div {\n  overflow: hidden;\n}\n\n.ag-right-aligned-header .ag-header-cell-label {\n  flex-direction: row-reverse;\n}\n\n.ag-header-cell-resize {\n  position: absolute;\n  z-index: 2;\n  height: 100%;\n  width: 8px;\n  top: 0;\n  cursor: ew-resize;\n}\n.ag-ltr .ag-header-cell-resize {\n  right: -3px;\n}\n.ag-rtl .ag-header-cell-resize {\n  left: -3px;\n}\n\n.ag-pinned-left-header .ag-header-cell-resize {\n  right: -3px;\n}\n\n.ag-pinned-right-header .ag-header-cell-resize {\n  left: -3px;\n}\n\n.ag-header-select-all {\n  display: flex;\n}\n\n.ag-header-cell-menu-button,\n.ag-header-cell-filter-button,\n.ag-side-button-button,\n.ag-panel-title-bar-button,\n.ag-floating-filter-button-button {\n  cursor: pointer;\n}\n\n.ag-column-moving .ag-cell {\n  transition: left 0.2s;\n}\n.ag-column-moving .ag-header-cell {\n  transition: left 0.2s;\n}\n.ag-column-moving .ag-header-group-cell {\n  transition: left 0.2s, width 0.2s;\n}\n\n.ag-column-panel {\n  display: flex;\n  flex-direction: column;\n  overflow: hidden;\n  flex: 1 1 auto;\n}\n\n.ag-column-select {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  overflow: hidden;\n  flex: 3 1 0px;\n}\n\n.ag-column-select-header {\n  position: relative;\n  display: flex;\n  flex: none;\n}\n\n.ag-column-select-header-icon {\n  position: relative;\n}\n\n.ag-column-select-header-filter-wrapper {\n  flex: 1 1 auto;\n}\n\n.ag-column-select-header-filter {\n  width: 100%;\n}\n\n.ag-column-select-list {\n  flex: 1 1 0px;\n  overflow: hidden;\n}\n\n.ag-column-drop {\n  position: relative;\n  display: inline-flex;\n  align-items: center;\n  overflow: auto;\n  width: 100%;\n}\n\n.ag-column-drop-list {\n  display: flex;\n  align-items: center;\n}\n\n.ag-column-drop-cell {\n  position: relative;\n  display: flex;\n  align-items: center;\n}\n\n.ag-column-drop-cell-text {\n  overflow: hidden;\n  flex: 1 1 auto;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n.ag-column-drop-vertical {\n  display: flex;\n  flex-direction: column;\n  overflow: hidden;\n  align-items: stretch;\n  flex: 1 1 0px;\n}\n\n.ag-column-drop-vertical-title-bar {\n  display: flex;\n  align-items: center;\n  flex: none;\n}\n\n.ag-column-drop-vertical-list {\n  position: relative;\n  align-items: stretch;\n  flex-grow: 1;\n  flex-direction: column;\n  overflow-x: auto;\n}\n.ag-column-drop-vertical-list > * {\n  flex: none;\n}\n\n.ag-column-drop-empty .ag-column-drop-vertical-list {\n  overflow: hidden;\n}\n\n.ag-column-drop-vertical-empty-message {\n  display: block;\n}\n\n.ag-column-drop.ag-column-drop-horizontal {\n  white-space: nowrap;\n  overflow: hidden;\n}\n\n.ag-column-drop-cell-button {\n  cursor: pointer;\n}\n\n.ag-filter-toolpanel {\n  flex: 1 1 0px;\n  min-width: 0;\n}\n\n.ag-filter-toolpanel-header {\n  position: relative;\n}\n\n.ag-filter-toolpanel-header,\n.ag-filter-toolpanel-search {\n  display: flex;\n  align-items: center;\n}\n.ag-filter-toolpanel-header > *,\n.ag-filter-toolpanel-search > * {\n  display: flex;\n  align-items: center;\n}\n\n.ag-filter-apply-panel {\n  display: flex;\n  justify-content: flex-end;\n  overflow: hidden;\n}\n\n.ag-row-animation .ag-row {\n  transition: transform 0.4s, top 0.4s, opacity 0.2s;\n}\n\n.ag-row-animation .ag-row.ag-after-created {\n  transition: transform 0.4s, top 0.4s, height 0.4s, opacity 0.2s;\n}\n\n.ag-row-no-animation .ag-row {\n  transition: none;\n}\n\n.ag-row {\n  white-space: nowrap;\n  width: 100%;\n}\n\n.ag-row-loading {\n  display: flex;\n  align-items: center;\n}\n\n.ag-row-position-absolute {\n  position: absolute;\n}\n\n.ag-row-position-relative {\n  position: relative;\n}\n\n.ag-full-width-row {\n  overflow: hidden;\n  pointer-events: all;\n}\n\n.ag-row-inline-editing {\n  z-index: 1;\n}\n\n.ag-row-dragging {\n  z-index: 2;\n}\n\n.ag-stub-cell {\n  display: flex;\n  align-items: center;\n}\n\n.ag-cell {\n  display: inline-block;\n  position: absolute;\n  white-space: nowrap;\n  height: 100%;\n}\n\n.ag-cell-value {\n  flex: 1 1 auto;\n}\n\n.ag-cell-value,\n.ag-group-value {\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.ag-cell-wrap-text {\n  white-space: normal;\n  word-break: break-word;\n}\n\n.ag-cell-wrapper {\n  display: flex;\n  align-items: center;\n}\n.ag-cell-wrapper.ag-row-group {\n  align-items: flex-start;\n}\n\n.ag-sparkline-wrapper {\n  position: absolute;\n  height: 100%;\n  width: 100%;\n  left: 0;\n  top: 0;\n}\n\n.ag-sparkline-wrapper :where(canvas) {\n  position: absolute;\n}\n\n.ag-full-width-row .ag-cell-wrapper.ag-row-group {\n  height: 100%;\n  align-items: center;\n}\n\n.ag-cell-inline-editing {\n  z-index: 1;\n}\n.ag-cell-inline-editing .ag-cell-wrapper,\n.ag-cell-inline-editing .ag-cell-edit-wrapper,\n.ag-cell-inline-editing .ag-cell-editor,\n.ag-cell-inline-editing .ag-cell-editor .ag-wrapper,\n.ag-cell-inline-editing .ag-cell-editor input {\n  height: 100%;\n  width: 100%;\n  line-height: normal;\n}\n\n.ag-cell .ag-icon {\n  display: inline-block;\n  vertical-align: middle;\n}\n\n.ag-set-filter-item {\n  display: flex;\n  align-items: center;\n  height: 100%;\n}\n\n.ag-set-filter-item-checkbox {\n  display: flex;\n  width: 100%;\n  height: 100%;\n}\n\n.ag-set-filter-group-icons {\n  display: block;\n}\n.ag-set-filter-group-icons > * {\n  cursor: pointer;\n}\n\n.ag-filter-body-wrapper {\n  display: flex;\n  flex-direction: column;\n}\n\n.ag-filter-filter {\n  flex: 1 1 0px;\n}\n\n.ag-filter-condition {\n  display: flex;\n  justify-content: center;\n}\n\n.ag-floating-filter-body {\n  position: relative;\n  display: flex;\n  flex: 1 1 auto;\n  height: 100%;\n}\n\n.ag-floating-filter-full-body {\n  display: flex;\n  flex: 1 1 auto;\n  height: 100%;\n  width: 100%;\n  align-items: center;\n  overflow: hidden;\n}\n\n.ag-floating-filter-full-body > div {\n  flex: 1 1 auto;\n}\n\n.ag-floating-filter-input {\n  align-items: center;\n  display: flex;\n  width: 100%;\n}\n.ag-floating-filter-input > * {\n  flex: 1 1 auto;\n}\n\n.ag-floating-filter-button {\n  display: flex;\n  flex: none;\n}\n\n.ag-set-floating-filter-input input[disabled] {\n  pointer-events: none;\n}\n\n.ag-dnd-ghost {\n  display: inline-flex;\n  align-items: center;\n  cursor: move;\n  white-space: nowrap;\n}\n\n.ag-overlay {\n  height: 100%;\n  left: 0;\n  pointer-events: none;\n  position: absolute;\n  top: 0;\n  width: 100%;\n  z-index: 2;\n}\n\n.ag-overlay-panel {\n  display: flex;\n  height: 100%;\n  width: 100%;\n}\n\n.ag-overlay-wrapper {\n  display: flex;\n  flex: none;\n  width: 100%;\n  height: 100%;\n  align-items: center;\n  justify-content: center;\n  text-align: center;\n}\n\n.ag-overlay-loading-wrapper {\n  pointer-events: all;\n}\n\n.ag-popup-child {\n  z-index: 5;\n  top: 0;\n}\n\n.ag-popup-editor {\n  position: absolute;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n}\n\n.ag-large-text-input {\n  display: block;\n}\n\n.ag-virtual-list-item {\n  position: absolute;\n  width: 100%;\n}\n\n.ag-floating-top {\n  overflow: hidden;\n  white-space: nowrap;\n  width: 100%;\n  position: relative;\n  display: flex;\n}\n\n.ag-pinned-left-floating-top {\n  display: inline-block;\n  overflow: hidden;\n  position: relative;\n  min-width: 0px;\n}\n\n.ag-pinned-right-floating-top {\n  display: inline-block;\n  overflow: hidden;\n  position: relative;\n  min-width: 0px;\n}\n\n.ag-floating-bottom {\n  overflow: hidden;\n  white-space: nowrap;\n  width: 100%;\n  position: relative;\n  display: flex;\n}\n\n.ag-pinned-left-floating-bottom {\n  display: inline-block;\n  overflow: hidden;\n  position: relative;\n  min-width: 0px;\n}\n\n.ag-pinned-right-floating-bottom {\n  display: inline-block;\n  overflow: hidden;\n  position: relative;\n  min-width: 0px;\n}\n\n.ag-sticky-top,\n.ag-sticky-bottom {\n  position: absolute;\n  display: flex;\n  width: 100%;\n  overflow: hidden;\n  height: 0px;\n}\n\n.ag-sticky-bottom {\n  box-sizing: content-box !important;\n}\n\n.ag-pinned-left-sticky-top,\n.ag-pinned-right-sticky-top {\n  position: relative;\n  height: 100%;\n  overflow: hidden;\n}\n\n.ag-sticky-top-full-width-container,\n.ag-sticky-bottom-full-width-container {\n  overflow: hidden;\n  width: 100%;\n  height: 100%;\n}\n\n.ag-dialog,\n.ag-panel {\n  display: flex;\n  flex-direction: column;\n  position: relative;\n  overflow: hidden;\n}\n\n.ag-panel-title-bar {\n  display: flex;\n  flex: none;\n  align-items: center;\n  cursor: default;\n}\n\n.ag-panel-title-bar-title {\n  flex: 1 1 auto;\n}\n\n.ag-panel-title-bar-buttons {\n  display: flex;\n}\n\n.ag-panel-title-bar-button {\n  cursor: pointer;\n}\n\n.ag-panel-content-wrapper {\n  display: flex;\n  flex: 1 1 auto;\n  position: relative;\n  overflow: hidden;\n}\n\n.ag-dialog {\n  position: absolute;\n}\n\n.ag-resizer {\n  position: absolute;\n  pointer-events: none;\n  z-index: 1;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n}\n.ag-resizer.ag-resizer-topLeft {\n  top: 0;\n  left: 0;\n  height: 5px;\n  width: 5px;\n  cursor: nwse-resize;\n}\n.ag-resizer.ag-resizer-top {\n  top: 0;\n  left: 5px;\n  right: 5px;\n  height: 5px;\n  cursor: ns-resize;\n}\n.ag-resizer.ag-resizer-topRight {\n  top: 0;\n  right: 0;\n  height: 5px;\n  width: 5px;\n  cursor: nesw-resize;\n}\n.ag-resizer.ag-resizer-right {\n  top: 5px;\n  right: 0;\n  bottom: 5px;\n  width: 5px;\n  cursor: ew-resize;\n}\n.ag-resizer.ag-resizer-bottomRight {\n  bottom: 0;\n  right: 0;\n  height: 5px;\n  width: 5px;\n  cursor: nwse-resize;\n}\n.ag-resizer.ag-resizer-bottom {\n  bottom: 0;\n  left: 5px;\n  right: 5px;\n  height: 5px;\n  cursor: ns-resize;\n}\n.ag-resizer.ag-resizer-bottomLeft {\n  bottom: 0;\n  left: 0;\n  height: 5px;\n  width: 5px;\n  cursor: nesw-resize;\n}\n.ag-resizer.ag-resizer-left {\n  left: 0;\n  top: 5px;\n  bottom: 5px;\n  width: 5px;\n  cursor: ew-resize;\n}\n\n.ag-tooltip {\n  position: absolute;\n  z-index: 99999;\n}\n\n.ag-tooltip-custom {\n  position: absolute;\n  z-index: 99999;\n}\n\n.ag-tooltip:not(.ag-tooltip-interactive),\n.ag-tooltip-custom:not(.ag-tooltip-interactive) {\n  pointer-events: none;\n}\n\n.ag-value-slide-out {\n  margin-right: 5px;\n  opacity: 1;\n  transition: opacity 3s, margin-right 3s;\n  transition-timing-function: linear;\n}\n\n.ag-value-slide-out-end {\n  margin-right: 10px;\n  opacity: 0;\n}\n\n.ag-opacity-zero {\n  opacity: 0 !important;\n}\n\n.ag-menu {\n  max-height: 100%;\n  overflow-y: auto;\n  position: absolute;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n}\n\n.ag-menu-column-select-wrapper {\n  height: 265px;\n  overflow: auto;\n}\n.ag-menu-column-select-wrapper .ag-column-select {\n  height: 100%;\n}\n\n.ag-dialog .ag-panel-content-wrapper .ag-column-select {\n  -webkit-user-select: none;\n     -moz-user-select: none;\n          user-select: none;\n}\n\n.ag-menu-list {\n  display: table;\n  width: 100%;\n}\n\n.ag-menu-option,\n.ag-menu-separator {\n  display: table-row;\n}\n\n.ag-menu-option-part,\n.ag-menu-separator-part {\n  display: table-cell;\n  vertical-align: middle;\n}\n\n.ag-menu-option-text {\n  white-space: nowrap;\n}\n\n.ag-menu-option-custom {\n  display: contents;\n}\n\n.ag-compact-menu-option {\n  width: 100%;\n  display: flex;\n  flex-wrap: nowrap;\n}\n\n.ag-compact-menu-option-text {\n  white-space: nowrap;\n  flex: 1 1 auto;\n}\n\n.ag-context-menu-loading-icon {\n  position: absolute;\n  pointer-events: none;\n}\n\n.ag-pill-container {\n  display: flex;\n  gap: 0.25rem;\n  flex-wrap: nowrap;\n}\n\n.ag-pill {\n  display: flex;\n  white-space: nowrap;\n  padding: 0 0.25rem;\n  align-items: center;\n}\n\n.ag-pill .ag-pill-button {\n  border: none;\n  padding: 0;\n}\n\n.ag-rich-select {\n  cursor: default;\n  outline: none;\n  height: 100%;\n}\n\n.ag-rich-select-value {\n  display: flex;\n  align-items: center;\n  height: 100%;\n}\n.ag-rich-select-value .ag-picker-field-display {\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n.ag-rich-select-value .ag-picker-field-display.ag-display-as-placeholder {\n  opacity: 0.5;\n}\n\n.ag-rich-select-list {\n  position: relative;\n}\n.ag-rich-select-list .ag-loading-text {\n  min-height: 2rem;\n}\n\n.ag-rich-select-row {\n  display: flex;\n  flex: 1 1 auto;\n  align-items: center;\n  white-space: nowrap;\n  overflow: hidden;\n  height: 100%;\n}\n\n.ag-rich-select-field-input {\n  flex: 1 1 auto;\n}\n.ag-rich-select-field-input .ag-input-field-input {\n  padding: 0 !important;\n  border: none !important;\n  box-shadow: none !important;\n  text-overflow: ellipsis;\n}\n.ag-rich-select-field-input .ag-input-field-input::-moz-placeholder {\n  opacity: 0.8;\n}\n.ag-rich-select-field-input .ag-input-field-input::placeholder {\n  opacity: 0.8;\n}\n\n.ag-autocomplete {\n  align-items: center;\n  display: flex;\n}\n.ag-autocomplete > * {\n  flex: 1 1 auto;\n}\n\n.ag-autocomplete-list-popup {\n  position: absolute;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n}\n\n.ag-autocomplete-list {\n  position: relative;\n}\n\n.ag-autocomplete-virtual-list-item {\n  display: flex;\n}\n\n.ag-autocomplete-row {\n  display: flex;\n  flex: 1 1 auto;\n  align-items: center;\n  overflow: hidden;\n}\n\n.ag-autocomplete-row-label {\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.ag-paging-panel {\n  align-items: center;\n  display: flex;\n  justify-content: flex-end;\n}\n\n.ag-paging-page-summary-panel {\n  display: flex;\n  align-items: center;\n}\n\n.ag-paging-button {\n  position: relative;\n}\n\n.ag-disabled .ag-paging-page-summary-panel {\n  pointer-events: none;\n}\n\n.ag-tool-panel-wrapper {\n  display: flex;\n  overflow-y: auto;\n  overflow-x: hidden;\n  cursor: default;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n}\n\n.ag-column-select-column,\n.ag-column-select-column-group,\n.ag-select-agg-func-item {\n  position: relative;\n  align-items: center;\n  display: flex;\n  flex-direction: row;\n  flex-wrap: nowrap;\n  height: 100%;\n}\n.ag-column-select-column > *,\n.ag-column-select-column-group > *,\n.ag-select-agg-func-item > * {\n  flex: none;\n}\n\n.ag-select-agg-func-item,\n.ag-column-select-column-label {\n  flex: 1 1 auto;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n.ag-column-select-checkbox {\n  display: flex;\n}\n\n.ag-tool-panel-horizontal-resize {\n  cursor: ew-resize;\n  height: 100%;\n  position: absolute;\n  top: 0;\n  width: 5px;\n  z-index: 1;\n}\n\n.ag-ltr .ag-side-bar-left .ag-tool-panel-horizontal-resize {\n  right: -3px;\n}\n.ag-rtl .ag-side-bar-left .ag-tool-panel-horizontal-resize {\n  left: -3px;\n}\n\n.ag-ltr .ag-side-bar-right .ag-tool-panel-horizontal-resize {\n  left: -3px;\n}\n.ag-rtl .ag-side-bar-right .ag-tool-panel-horizontal-resize {\n  right: -3px;\n}\n\n.ag-details-row {\n  width: 100%;\n}\n\n.ag-details-row-fixed-height {\n  height: 100%;\n}\n\n.ag-details-grid {\n  width: 100%;\n}\n\n.ag-details-grid-fixed-height {\n  height: 100%;\n}\n\n.ag-header-group-cell {\n  display: flex;\n  align-items: center;\n  height: 100%;\n  position: absolute;\n}\n\n.ag-header-group-cell-no-group.ag-header-span-height {\n  display: none;\n}\n\n.ag-cell-label-container {\n  display: flex;\n  justify-content: space-between;\n  flex-direction: row-reverse;\n  align-items: center;\n  height: 100%;\n  width: 100%;\n}\n\n.ag-header-group-cell-label,\n.ag-cell-label-container {\n  padding: 5px 0px;\n}\n\n.ag-right-aligned-header .ag-cell-label-container {\n  flex-direction: row;\n}\n.ag-right-aligned-header .ag-header-cell-text {\n  text-align: right;\n}\n\n.ag-side-bar {\n  display: flex;\n  flex-direction: row-reverse;\n}\n\n.ag-side-bar-left {\n  order: -1;\n  flex-direction: row;\n}\n\n.ag-side-button-button {\n  position: relative;\n  display: flex;\n  flex-direction: column;\n  align-items: center;\n  justify-content: center;\n  flex-wrap: nowrap;\n  white-space: nowrap;\n  outline: none;\n  cursor: pointer;\n}\n\n.ag-side-button-label {\n  writing-mode: vertical-lr;\n}\n\n.ag-status-bar {\n  display: flex;\n  justify-content: space-between;\n  overflow: hidden;\n}\n\n.ag-status-panel {\n  display: inline-flex;\n}\n\n.ag-status-name-value {\n  white-space: nowrap;\n}\n\n.ag-status-bar-left {\n  display: inline-flex;\n}\n\n.ag-status-bar-center {\n  display: inline-flex;\n}\n\n.ag-status-bar-right {\n  display: inline-flex;\n}\n\n.ag-icon {\n  display: block;\n  speak: none;\n}\n\n.ag-group {\n  position: relative;\n  width: 100%;\n}\n\n.ag-group-title-bar {\n  display: flex;\n  align-items: center;\n}\n\n.ag-group-title {\n  display: inline;\n  min-width: 0;\n  overflow: hidden;\n  white-space: nowrap;\n  text-overflow: ellipsis;\n}\n\n.ag-group-title-bar .ag-group-title {\n  cursor: default;\n}\n\n.ag-group-toolbar {\n  display: flex;\n  align-items: center;\n}\n\n.ag-group-container {\n  display: flex;\n}\n\n.ag-disabled .ag-group-container {\n  pointer-events: none;\n}\n\n.ag-group-container-horizontal {\n  flex-direction: row;\n  flex-wrap: wrap;\n}\n\n.ag-group-container-vertical {\n  flex-direction: column;\n}\n\n.ag-column-group-icons {\n  display: block;\n}\n.ag-column-group-icons > * {\n  cursor: pointer;\n}\n\n.ag-group-item-alignment-stretch .ag-group-item {\n  align-items: stretch;\n}\n\n.ag-group-item-alignment-start .ag-group-item {\n  align-items: flex-start;\n}\n\n.ag-group-item-alignment-end .ag-group-item {\n  align-items: flex-end;\n}\n\n.ag-toggle-button-icon {\n  transition: right 0.3s;\n  position: absolute;\n  top: -1px;\n}\n\n.ag-input-field,\n.ag-select {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n}\n\n.ag-input-field-input {\n  flex: 1 1 auto;\n}\n\n.ag-floating-filter-input .ag-input-field-input[type=date] {\n  width: 1px;\n}\n\n.ag-range-field {\n  display: flex;\n  align-items: center;\n}\n\n.ag-angle-select {\n  display: flex;\n  align-items: center;\n}\n\n.ag-angle-select-wrapper {\n  display: flex;\n}\n\n.ag-angle-select-parent-circle {\n  display: block;\n  position: relative;\n}\n\n.ag-angle-select-child-circle {\n  position: absolute;\n}\n\n.ag-slider-wrapper {\n  display: flex;\n}\n.ag-slider-wrapper .ag-input-field {\n  flex: 1 1 auto;\n}\n\n.ag-picker-field-display {\n  flex: 1 1 auto;\n}\n\n.ag-picker-field {\n  display: flex;\n  align-items: center;\n}\n\n.ag-picker-field-icon {\n  display: flex;\n  border: 0;\n  padding: 0;\n  margin: 0;\n  cursor: pointer;\n}\n\n.ag-picker-field-wrapper {\n  overflow: hidden;\n}\n\n.ag-label-align-right .ag-label {\n  order: 1;\n}\n.ag-label-align-right > * {\n  flex: none;\n}\n\n.ag-label-align-top {\n  flex-direction: column;\n  align-items: flex-start;\n}\n.ag-label-align-top > * {\n  align-self: stretch;\n}\n\n.ag-label-ellipsis {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  flex: 1;\n}\n\n.ag-color-panel {\n  width: 100%;\n  display: flex;\n  flex-direction: column;\n  text-align: center;\n}\n\n.ag-spectrum-color {\n  flex: 1 1 auto;\n  position: relative;\n  overflow: visible;\n  cursor: default;\n}\n\n.ag-spectrum-fill {\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n\n.ag-spectrum-val {\n  cursor: pointer;\n}\n\n.ag-spectrum-dragger {\n  position: absolute;\n  pointer-events: none;\n  cursor: pointer;\n}\n\n.ag-spectrum-hue,\n.ag-spectrum-alpha {\n  cursor: default;\n}\n\n.ag-spectrum-hue-background {\n  background: linear-gradient(to left, #ff0000 3%, #ffff00 17%, #00ff00 33%, #00ffff 50%, #0000ff 67%, #ff00ff 83%, #ff0000 100%);\n  width: 100%;\n  height: 100%;\n}\n\n.ag-spectrum-alpha {\n  --ag-spectrum-alpha-background-checked: url(" + h + ');\n}\n\n.ag-spectrum-alpha-background {\n  background: linear-gradient(to right, var(--ag-internal-spectrum-alpha-color-from), var(--ag-internal-spectrum-alpha-color-to)), var(--ag-spectrum-alpha-background-checked) top left/4px 4px;\n  width: 100%;\n  height: 100%;\n}\n\n.ag-spectrum-tool {\n  cursor: pointer;\n  position: relative;\n}\n\n.ag-spectrum-slider {\n  position: absolute;\n  pointer-events: none;\n}\n\n.ag-spectrum-alpha .ag-spectrum-slider {\n  background: linear-gradient(to bottom, var(--ag-internal-spectrum-alpha-color), var(--ag-internal-spectrum-alpha-color)) white;\n}\n\n.ag-recent-colors {\n  display: flex;\n}\n\n.ag-recent-color {\n  cursor: pointer;\n}\n\n.ag-pill-select {\n  display: flex;\n  flex-direction: column;\n}\n.ag-pill-select .ag-column-drop {\n  flex: initial;\n}\n\n.ag-ltr {\n  direction: ltr;\n}\n.ag-ltr .ag-body,\n.ag-ltr .ag-floating-top,\n.ag-ltr .ag-floating-bottom,\n.ag-ltr .ag-header,\n.ag-ltr .ag-sticky-top,\n.ag-ltr .ag-sticky-bottom,\n.ag-ltr .ag-body-viewport,\n.ag-ltr .ag-body-horizontal-scroll {\n  flex-direction: row;\n}\n\n.ag-rtl {\n  direction: rtl;\n}\n.ag-rtl .ag-body,\n.ag-rtl .ag-floating-top,\n.ag-rtl .ag-floating-bottom,\n.ag-rtl .ag-header,\n.ag-rtl .ag-sticky-top,\n.ag-rtl .ag-sticky-bottom,\n.ag-rtl .ag-body-viewport,\n.ag-rtl .ag-body-horizontal-scroll {\n  flex-direction: row-reverse;\n}\n.ag-rtl .ag-icon-contracted,\n.ag-rtl .ag-icon-expanded,\n.ag-rtl .ag-icon-tree-closed {\n  display: block;\n  transform: rotate(180deg);\n}\n\n.ag-body .ag-body-viewport {\n  -webkit-overflow-scrolling: touch;\n}\n\n.ag-measurement-container {\n  width: 0;\n  overflow: hidden;\n  visibility: hidden;\n}\n.ag-measurement-container div {\n  position: absolute;\n}\n\n.ag-layout-print.ag-body {\n  display: block;\n  height: auto;\n  height: initial;\n}\n.ag-layout-print.ag-root-wrapper {\n  display: inline-block;\n}\n.ag-layout-print .ag-body-vertical-scroll {\n  display: none;\n}\n.ag-layout-print .ag-body-horizontal-scroll {\n  display: none;\n}\n.ag-layout-print.ag-force-vertical-scroll {\n  overflow-y: visible !important;\n}\n\n@media print {\n  .ag-root-wrapper.ag-layout-print {\n    display: table;\n  }\n  .ag-root-wrapper.ag-layout-print .ag-root-wrapper-body,\n  .ag-root-wrapper.ag-layout-print .ag-root,\n  .ag-root-wrapper.ag-layout-print .ag-body-viewport,\n  .ag-root-wrapper.ag-layout-print .ag-center-cols-container,\n  .ag-root-wrapper.ag-layout-print .ag-center-cols-viewport,\n  .ag-root-wrapper.ag-layout-print .ag-body-horizontal-scroll-viewport,\n  .ag-root-wrapper.ag-layout-print .ag-virtual-list-viewport {\n    height: auto !important;\n    overflow: hidden !important;\n    display: block !important;\n  }\n  .ag-root-wrapper.ag-layout-print .ag-row,\n  .ag-root-wrapper.ag-layout-print .ag-cell {\n    page-break-inside: avoid;\n    -moz-column-break-inside: avoid;\n         break-inside: avoid;\n  }\n}\n[class^=ag-],\n[class^=ag-]:focus,\n[class^=ag-]:after,\n[class^=ag-]:before {\n  box-sizing: border-box;\n  outline: none;\n}\n\n[class^=ag-]::-ms-clear {\n  display: none;\n}\n\n.ag-checkbox .ag-input-wrapper,\n.ag-radio-button .ag-input-wrapper {\n  overflow: visible;\n}\n\n.ag-range-field .ag-input-wrapper {\n  height: 100%;\n}\n\n.ag-toggle-button {\n  flex: none;\n  width: auto;\n  width: initial;\n  min-width: 0;\n  min-width: initial;\n}\n\n.ag-button {\n  border-radius: 0px;\n  color: var(--ag-foreground-color);\n}\n\n.ag-button:hover {\n  background-color: transparent;\n}\n\n.ag-ltr .ag-label-align-right .ag-label {\n  margin-left: var(--ag-grid-size);\n}\n.ag-rtl .ag-label-align-right .ag-label {\n  margin-right: var(--ag-grid-size);\n}\n\ninput[class^=ag-] {\n  margin: 0;\n  background-color: var(--ag-background-color);\n}\n\ntextarea[class^=ag-],\nselect[class^=ag-] {\n  background-color: var(--ag-background-color);\n}\n\ninput[class^=ag-]:not([type]),\ninput[class^=ag-][type=text],\ninput[class^=ag-][type=number],\ninput[class^=ag-][type=tel],\ninput[class^=ag-][type=date],\ninput[class^=ag-][type=datetime-local],\ntextarea[class^=ag-] {\n  font-size: inherit;\n  line-height: inherit;\n  color: inherit;\n  font-family: inherit;\n  border: var(--ag-borders-input) var(--ag-input-border-color);\n}\ninput[class^=ag-]:not([type]):disabled,\ninput[class^=ag-][type=text]:disabled,\ninput[class^=ag-][type=number]:disabled,\ninput[class^=ag-][type=tel]:disabled,\ninput[class^=ag-][type=date]:disabled,\ninput[class^=ag-][type=datetime-local]:disabled,\ntextarea[class^=ag-]:disabled {\n  color: var(--ag-disabled-foreground-color);\n  background-color: var(--ag-input-disabled-background-color);\n  border-color: var(--ag-input-disabled-border-color);\n}\ninput[class^=ag-]:not([type]):focus,\ninput[class^=ag-][type=text]:focus,\ninput[class^=ag-][type=number]:focus,\ninput[class^=ag-][type=tel]:focus,\ninput[class^=ag-][type=date]:focus,\ninput[class^=ag-][type=datetime-local]:focus,\ntextarea[class^=ag-]:focus {\n  outline: none;\n  box-shadow: var(--ag-input-focus-box-shadow);\n  border-color: var(--ag-input-focus-border-color);\n}\ninput[class^=ag-]:not([type]):invalid,\ninput[class^=ag-][type=text]:invalid,\ninput[class^=ag-][type=number]:invalid,\ninput[class^=ag-][type=tel]:invalid,\ninput[class^=ag-][type=date]:invalid,\ninput[class^=ag-][type=datetime-local]:invalid,\ntextarea[class^=ag-]:invalid {\n  border: var(--ag-borders-input-invalid) var(--ag-input-border-color-invalid);\n}\n\ninput[class^=ag-][type=number]:not(.ag-number-field-input-stepper) {\n  -moz-appearance: textfield;\n}\ninput[class^=ag-][type=number]:not(.ag-number-field-input-stepper)::-webkit-outer-spin-button, input[class^=ag-][type=number]:not(.ag-number-field-input-stepper)::-webkit-inner-spin-button {\n  -webkit-appearance: none;\n  margin: 0;\n}\n\ninput[class^=ag-][type=range] {\n  padding: 0;\n}\n\ninput[class^=ag-][type=button]:focus,\nbutton[class^=ag-]:focus {\n  box-shadow: var(--ag-input-focus-box-shadow);\n}\n\n.ag-drag-handle {\n  color: var(--ag-secondary-foreground-color);\n}\n\n.ag-list-item,\n.ag-virtual-list-item {\n  height: var(--ag-list-item-height);\n}\n\n.ag-virtual-list-item:focus-visible {\n  outline: none;\n}\n.ag-virtual-list-item:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-select-list {\n  background-color: var(--ag-background-color);\n  overflow-y: auto;\n  overflow-x: hidden;\n  border-radius: var(--ag-border-radius);\n  border: var(--ag-borders) var(--ag-border-color);\n}\n\n.ag-list-item {\n  display: flex;\n  align-items: center;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n.ag-list-item.ag-active-item {\n  background-color: var(--ag-row-hover-color);\n}\n\n.ag-select-list-item {\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n  cursor: default;\n}\n.ag-ltr .ag-select-list-item {\n  padding-left: calc(var(--ag-cell-horizontal-padding) / 2);\n}\n.ag-rtl .ag-select-list-item {\n  padding-right: calc(var(--ag-cell-horizontal-padding) / 2);\n}\n.ag-select-list-item span {\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  overflow: hidden;\n}\n\n.ag-row-drag,\n.ag-selection-checkbox,\n.ag-group-expanded,\n.ag-group-contracted {\n  color: var(--ag-secondary-foreground-color);\n}\n.ag-ltr .ag-row-drag,\n.ag-ltr .ag-selection-checkbox,\n.ag-ltr .ag-group-expanded,\n.ag-ltr .ag-group-contracted {\n  margin-right: var(--ag-cell-widget-spacing);\n}\n.ag-rtl .ag-row-drag,\n.ag-rtl .ag-selection-checkbox,\n.ag-rtl .ag-group-expanded,\n.ag-rtl .ag-group-contracted {\n  margin-left: var(--ag-cell-widget-spacing);\n}\n\n.ag-cell-wrapper > *:not(.ag-cell-value):not(.ag-group-value) {\n  --ag-internal-calculated-line-height: var(\n      --ag-line-height,\n      calc(var(--ag-row-height) - var(--ag-row-border-width))\n  );\n  --ag-internal-padded-row-height: calc(var(--ag-row-height) - var(--ag-row-border-width));\n  height: min(var(--ag-internal-calculated-line-height), var(--ag-internal-padded-row-height));\n  display: flex;\n  align-items: center;\n  flex: none;\n}\n\n.ag-group-expanded,\n.ag-group-contracted {\n  cursor: pointer;\n}\n\n.ag-group-title-bar-icon {\n  cursor: pointer;\n  flex: none;\n  color: var(--ag-secondary-foreground-color);\n}\n\n.ag-ltr .ag-group-child-count {\n  margin-left: 2px;\n}\n.ag-rtl .ag-group-child-count {\n  margin-right: 2px;\n}\n\n.ag-group-title-bar {\n  background-color: var(--ag-subheader-background-color);\n  padding: var(--ag-grid-size);\n}\n\n.ag-group-toolbar {\n  padding: var(--ag-grid-size);\n  background-color: var(--ag-subheader-toolbar-background-color);\n}\n\n.ag-disabled-group-title-bar,\n.ag-disabled-group-container {\n  opacity: 0.5;\n}\n\n.group-item {\n  margin: calc(var(--ag-grid-size) * 0.5) 0;\n}\n\n.ag-label {\n  white-space: nowrap;\n}\n.ag-ltr .ag-label {\n  margin-right: var(--ag-grid-size);\n}\n.ag-rtl .ag-label {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-label-align-top .ag-label {\n  margin-bottom: calc(var(--ag-grid-size) * 0.5);\n}\n\n.ag-angle-select[disabled] {\n  color: var(--ag-disabled-foreground-color);\n  pointer-events: none;\n}\n.ag-angle-select[disabled] .ag-angle-select-field {\n  opacity: 0.4;\n}\n\n.ag-ltr .ag-slider-field,\n.ag-ltr .ag-angle-select-field {\n  margin-right: calc(var(--ag-grid-size) * 2);\n}\n.ag-rtl .ag-slider-field,\n.ag-rtl .ag-angle-select-field {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-angle-select-parent-circle {\n  width: 24px;\n  height: 24px;\n  border-radius: 12px;\n  border: solid 1px;\n  border-color: var(--ag-border-color);\n  background-color: var(--ag-background-color);\n}\n\n.ag-angle-select-child-circle {\n  top: 4px;\n  left: 12px;\n  width: 6px;\n  height: 6px;\n  margin-left: -3px;\n  margin-top: -4px;\n  border-radius: 3px;\n  background-color: var(--ag-secondary-foreground-color);\n}\n\n.ag-picker-field-wrapper {\n  border: var(--ag-borders);\n  border-color: var(--ag-border-color);\n  border-radius: 5px;\n  background-color: var(--ag-background-color);\n}\n.ag-picker-field-wrapper:disabled {\n  color: var(--ag-disabled-foreground-color);\n  background-color: var(--ag-input-disabled-background-color);\n  border-color: var(--ag-input-disabled-border-color);\n}\n.ag-picker-field-wrapper.ag-picker-has-focus, .ag-picker-field-wrapper:focus-within {\n  outline: none;\n  box-shadow: var(--ag-input-focus-box-shadow);\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-picker-field-button {\n  background-color: var(--ag-background-color);\n  color: var(--ag-secondary-foreground-color);\n}\n\n.ag-dialog.ag-color-dialog {\n  border-radius: 5px;\n}\n\n.ag-color-picker .ag-picker-field-wrapper {\n  padding-left: var(--ag-grid-size);\n  padding-right: var(--ag-grid-size);\n}\n.ag-color-picker .ag-picker-field-display {\n  display: flex;\n  flex-direction: row;\n  align-items: center;\n  min-height: var(--ag-list-item-height);\n}\n\n.ag-ltr .ag-color-picker-color,\n.ag-ltr .ag-color-picker-value {\n  margin-right: var(--ag-grid-size);\n}\n.ag-rtl .ag-color-picker-color,\n.ag-rtl .ag-color-picker-value {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-color-panel {\n  padding: var(--ag-grid-size);\n}\n\n.ag-spectrum-color {\n  background-color: rgb(255, 0, 0);\n  border-radius: 2px;\n}\n\n.ag-spectrum-tools {\n  padding: 10px;\n}\n\n.ag-spectrum-sat {\n  background-image: linear-gradient(to right, white, rgba(204, 154, 129, 0));\n}\n\n.ag-spectrum-val {\n  background-image: linear-gradient(to top, black, rgba(204, 154, 129, 0));\n}\n\n.ag-spectrum-dragger {\n  border-radius: 12px;\n  height: 12px;\n  width: 12px;\n  border: 2px solid white;\n  background: black;\n  box-shadow: 0 0 2px 0px rgba(0, 0, 0, 0.24);\n}\n\n.ag-spectrum-hue-background {\n  border-radius: 2px;\n}\n\n.ag-spectrum-alpha-background {\n  border-radius: 2px;\n}\n\n.ag-spectrum-tool {\n  margin-bottom: 10px;\n  height: 11px;\n  border-radius: 2px;\n}\n\n.ag-spectrum-slider {\n  margin-top: -12px;\n  width: 13px;\n  height: 13px;\n  border-radius: 13px;\n  border: 2px solid white;\n  box-shadow: 0 1px 4px 0 rgba(0, 0, 0, 0.37);\n}\n\n.ag-recent-colors {\n  margin-top: 10px;\n}\n\n.ag-recent-color {\n  margin: 0 3px;\n}\n.ag-recent-color:first-child {\n  margin-left: 0;\n}\n.ag-recent-color:last-child {\n  margin-right: 0;\n}\n\n.ag-spectrum-color:focus-visible:not(:disabled):not([readonly]),\n.ag-spectrum-slider:focus-visible:not(:disabled):not([readonly]),\n.ag-recent-color:focus-visible:not(:disabled):not([readonly]) {\n  box-shadow: var(--ag-input-focus-box-shadow);\n}\n\n.ag-ltr .ag-color-input input[class^=ag-][type=text].ag-input-field-input {\n  padding-left: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n}\n.ag-rtl .ag-color-input input[class^=ag-][type=text].ag-input-field-input {\n  padding-right: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n}\n.ag-color-input .ag-color-input-color {\n  position: absolute;\n}\n.ag-ltr .ag-color-input .ag-color-input-color {\n  margin-left: var(--ag-grid-size);\n}\n.ag-rtl .ag-color-input .ag-color-input-color {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-color-picker-color,\n.ag-color-input-color {\n  width: var(--ag-icon-size);\n  height: var(--ag-icon-size);\n  border: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n  border-radius: 2px;\n}\n\n.ag-dnd-ghost {\n  border: var(--ag-borders) var(--ag-border-color);\n  background: var(--ag-background-color);\n  border-radius: var(--ag-card-radius);\n  box-shadow: var(--ag-card-shadow);\n  padding: var(--ag-grid-size);\n  overflow: hidden;\n  text-overflow: ellipsis;\n  border: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n  color: var(--ag-secondary-foreground-color);\n  height: var(--ag-header-height);\n  line-height: var(--ag-header-height);\n  margin: 0;\n  padding: 0 calc(var(--ag-grid-size) * 2);\n  transform: translateY(calc(var(--ag-grid-size) * 2));\n}\n\n.ag-dnd-ghost-icon {\n  margin-right: var(--ag-grid-size);\n  color: var(--ag-foreground-color);\n}\n\n.ag-popup-child:not(.ag-tooltip-custom) {\n  box-shadow: var(--ag-popup-shadow);\n}\n\n.ag-select .ag-picker-field-wrapper {\n  min-height: var(--ag-list-item-height);\n  cursor: default;\n}\n.ag-ltr .ag-select .ag-picker-field-wrapper {\n  padding-left: calc(var(--ag-cell-horizontal-padding) / 2);\n}\n.ag-rtl .ag-select .ag-picker-field-wrapper {\n  padding-right: calc(var(--ag-cell-horizontal-padding) / 2);\n}\n.ag-ltr .ag-select .ag-picker-field-wrapper {\n  padding-right: var(--ag-grid-size);\n}\n.ag-rtl .ag-select .ag-picker-field-wrapper {\n  padding-left: var(--ag-grid-size);\n}\n.ag-select.ag-disabled .ag-picker-field-wrapper:focus {\n  box-shadow: none;\n}\n.ag-select:not(.ag-cell-editor):not(.ag-label-align-top) {\n  min-height: var(--ag-list-item-height);\n}\n.ag-select .ag-picker-field-display {\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n.ag-select .ag-picker-field-icon {\n  display: flex;\n  align-items: center;\n}\n.ag-select.ag-disabled {\n  opacity: 0.5;\n}\n\n.ag-rich-select-value,\n.ag-rich-select-list {\n  background-color: var(--ag-background-color);\n}\n\n.ag-rich-select-list {\n  width: 100%;\n  height: auto;\n  border-radius: var(--ag-border-radius);\n  border: var(--ag-borders) var(--ag-border-color);\n}\n.ag-rich-select-list .ag-loading-text {\n  padding: var(--ag-widget-vertical-spacing) var(--ag-widget-horizontal-spacing);\n}\n\n.ag-rich-select-value {\n  border-bottom: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n  padding-top: 0;\n  padding-bottom: 0;\n}\n.ag-ltr .ag-rich-select-value {\n  padding-left: calc(var(--ag-cell-horizontal-padding) / 2);\n}\n.ag-rtl .ag-rich-select-value {\n  padding-right: calc(var(--ag-cell-horizontal-padding) / 2);\n}\n.ag-ltr .ag-rich-select-value {\n  padding-right: var(--ag-grid-size);\n}\n.ag-rtl .ag-rich-select-value {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-ltr .ag-rich-select-field-input {\n  left: calc(var(--ag-cell-horizontal-padding));\n}\n.ag-rtl .ag-rich-select-field-input {\n  right: calc(var(--ag-cell-horizontal-padding));\n}\n\n.ag-popup-editor .ag-rich-select-value {\n  height: var(--ag-row-height);\n  min-width: 200px;\n}\n\n.ag-rich-select-virtual-list-item {\n  cursor: default;\n  height: var(--ag-list-item-height);\n}\n.ag-rich-select-virtual-list-item:focus-visible::after {\n  content: none;\n}\n\n.ag-ltr .ag-rich-select-row {\n  padding-left: calc(var(--ag-cell-horizontal-padding) / 2);\n}\n.ag-rtl .ag-rich-select-row {\n  padding-right: calc(var(--ag-cell-horizontal-padding) / 2);\n}\n\n.ag-rich-select-row-selected {\n  background-color: var(--ag-selected-row-background-color);\n}\n\n.ag-rich-select-row:hover,\n.ag-rich-select-row-highlighted {\n  background-image: linear-gradient(var(--ag-row-hover-color), var(--ag-row-hover-color));\n}\n\n.ag-rich-select-row-text-highlight {\n  font-weight: bold;\n}\n\n.ag-autocomplete {\n  width: 100%;\n}\n\n.ag-autocomplete-list {\n  width: 100%;\n  min-width: 200px;\n  height: calc(var(--ag-row-height) * 6.5);\n}\n\n.ag-autocomplete-virtual-list-item {\n  cursor: default;\n  height: var(--ag-list-item-height);\n}\n.ag-autocomplete-virtual-list-item:focus-visible::after {\n  content: none;\n}\n.ag-autocomplete-virtual-list-item:hover {\n  background-color: var(--ag-row-hover-color);\n}\n\n.ag-autocomplete-row-label {\n  margin: 0px var(--ag-widget-container-horizontal-padding);\n}\n\n.ag-autocomplete-row-selected {\n  background-color: var(--ag-selected-row-background-color);\n}\n\n.ag-pill {\n  border: 1px solid var(--ag-chip-border-color);\n  border-radius: var(--ag-border-radius);\n  background-color: var(--ag-chip-background-color);\n}\n\n.ag-ltr .ag-pill .ag-pill-button {\n  margin-left: var(--ag-grid-size);\n}\n.ag-rtl .ag-pill .ag-pill-button {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-pill:focus-visible {\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-pill .ag-pill-button:hover {\n  cursor: pointer;\n}\n\n.ag-dragging-range-handle .ag-dialog,\n.ag-dragging-fill-handle .ag-dialog {\n  opacity: 0.7;\n  pointer-events: none;\n}\n\n.ag-dialog {\n  border-radius: var(--ag-border-radius);\n  border: var(--ag-borders) var(--ag-border-color);\n  box-shadow: var(--ag-popup-shadow);\n}\n\n.ag-panel {\n  background-color: var(--ag-panel-background-color);\n  border-color: var(--ag-panel-border-color);\n}\n\n.ag-panel-title-bar {\n  color: var(--ag-header-foreground-color);\n  height: var(--ag-header-height);\n  padding: var(--ag-grid-size) var(--ag-cell-horizontal-padding);\n  border-bottom: var(--ag-borders) var(--ag-border-color);\n}\n\n.ag-ltr .ag-panel-title-bar-button {\n  margin-left: var(--ag-grid-size);\n}\n.ag-rtl .ag-panel-title-bar-button {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-tooltip {\n  background-color: var(--ag-tooltip-background-color);\n  color: var(--ag-foreground-color);\n  padding: var(--ag-grid-size);\n  border: var(--ag-borders) var(--ag-border-color);\n  border-radius: var(--ag-card-radius);\n  white-space: normal;\n}\n\n.ag-tooltip.ag-tooltip-animate,\n.ag-tooltip-custom.ag-tooltip-animate {\n  transition: opacity 1s;\n}\n.ag-tooltip.ag-tooltip-animate.ag-tooltip-hiding,\n.ag-tooltip-custom.ag-tooltip-animate.ag-tooltip-hiding {\n  opacity: 0;\n}\n\n.ag-ltr .ag-column-select-column,\n.ag-ltr .ag-column-select-column-group {\n  padding-left: calc(var(--ag-indentation-level) * var(--ag-column-select-indent-size));\n}\n.ag-rtl .ag-column-select-column,\n.ag-rtl .ag-column-select-column-group {\n  padding-right: calc(var(--ag-indentation-level) * var(--ag-column-select-indent-size));\n}\n\n.ag-column-select-header-icon {\n  cursor: pointer;\n}\n\n.ag-column-select-header-icon:focus-visible {\n  outline: none;\n}\n.ag-column-select-header-icon:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 0px;\n  left: 0px;\n  display: block;\n  width: calc(100% - 0px);\n  height: calc(100% - 0px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-ltr .ag-column-group-icons:not(:last-child),\n.ag-ltr .ag-column-select-header-icon:not(:last-child),\n.ag-ltr .ag-column-select-header-checkbox:not(:last-child),\n.ag-ltr .ag-column-select-header-filter-wrapper:not(:last-child),\n.ag-ltr .ag-column-select-checkbox:not(:last-child),\n.ag-ltr .ag-column-select-column-drag-handle:not(:last-child),\n.ag-ltr .ag-column-select-column-group-drag-handle:not(:last-child),\n.ag-ltr .ag-column-select-column-label:not(:last-child) {\n  margin-right: var(--ag-widget-horizontal-spacing);\n}\n.ag-rtl .ag-column-group-icons:not(:last-child),\n.ag-rtl .ag-column-select-header-icon:not(:last-child),\n.ag-rtl .ag-column-select-header-checkbox:not(:last-child),\n.ag-rtl .ag-column-select-header-filter-wrapper:not(:last-child),\n.ag-rtl .ag-column-select-checkbox:not(:last-child),\n.ag-rtl .ag-column-select-column-drag-handle:not(:last-child),\n.ag-rtl .ag-column-select-column-group-drag-handle:not(:last-child),\n.ag-rtl .ag-column-select-column-label:not(:last-child) {\n  margin-left: var(--ag-widget-horizontal-spacing);\n}\n\n.ag-column-select-virtual-list-item:focus-visible {\n  outline: none;\n}\n.ag-column-select-virtual-list-item:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 1px;\n  left: 1px;\n  display: block;\n  width: calc(100% - 2px);\n  height: calc(100% - 2px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-column-select-column-group:not(:last-child),\n.ag-column-select-column:not(:last-child) {\n  margin-bottom: var(--ag-widget-vertical-spacing);\n}\n\n.ag-column-select-column-readonly,\n.ag-column-select-column-group-readonly {\n  color: var(--ag-disabled-foreground-color);\n  pointer-events: none;\n}\n\n.ag-ltr .ag-column-select-add-group-indent {\n  margin-left: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n}\n.ag-rtl .ag-column-select-add-group-indent {\n  margin-right: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n}\n\n.ag-column-select-virtual-list-viewport {\n  padding: calc(var(--ag-widget-container-vertical-padding) * 0.5) 0px;\n}\n\n.ag-column-select-virtual-list-item {\n  padding: 0 var(--ag-widget-container-horizontal-padding);\n}\n\n.ag-checkbox-edit {\n  padding-left: var(--ag-cell-horizontal-padding);\n  padding-right: var(--ag-cell-horizontal-padding);\n}\n\n.ag-pill-select .ag-column-drop {\n  border-bottom: 0;\n  min-height: 0;\n  min-height: initial;\n}\n.ag-pill-select .ag-column-drop-list {\n  padding: 0;\n}\n.ag-pill-select .ag-select {\n  padding-top: var(--ag-grid-size);\n}\n.ag-pill-select .ag-picker-field-wrapper {\n  background-color: transparent;\n  border: 0;\n}\n.ag-pill-select .ag-picker-field-display {\n  cursor: pointer;\n}\n\n.ag-rtl {\n  text-align: right;\n}\n\n.ag-root-wrapper {\n  border-radius: var(--ag-wrapper-border-radius);\n  border: var(--ag-borders) var(--ag-border-color);\n}\n\n.ag-row > .ag-cell-wrapper.ag-row-group {\n  padding-left: calc(var(--ag-cell-horizontal-padding) + var(--ag-row-group-indent-size) * var(--ag-indentation-level));\n}\n\n.ag-cell-wrapper.ag-row-group,\n.ag-cell-wrapper.ag-row-group-leaf-indent,\n.ag-cell-wrapper.ag-pivot-leaf-group {\n  padding-left: calc(var(--ag-indentation-level) * var(--ag-row-group-indent-size));\n}\n\n.ag-ltr .ag-row-group-leaf-indent {\n  margin-left: var(--ag-row-group-indent-size);\n}\n.ag-rtl .ag-row-group-leaf-indent {\n  margin-right: var(--ag-row-group-indent-size);\n}\n\n.ag-row:not(.ag-row-level-0) .ag-pivot-leaf-group {\n  margin-left: var(--ag-row-group-indent-size);\n}\n\n.ag-value-change-delta {\n  padding-right: 2px;\n}\n\n.ag-value-change-delta-up {\n  color: var(--ag-value-change-delta-up-color);\n}\n\n.ag-value-change-delta-down {\n  color: var(--ag-value-change-delta-down-color);\n}\n\n.ag-value-change-value {\n  background-color: transparent;\n  border-radius: 1px;\n  padding-left: 1px;\n  padding-right: 1px;\n  transition: background-color 1s;\n}\n\n.ag-value-change-value-highlight {\n  background-color: var(--ag-value-change-value-highlight-background-color);\n  transition: background-color 0.1s;\n}\n\n.ag-cell-data-changed {\n  background-color: var(--ag-value-change-value-highlight-background-color) !important;\n}\n\n.ag-cell-data-changed-animation {\n  background-color: transparent;\n}\n\n.ag-cell-highlight {\n  background-color: var(--ag-range-selection-highlight-color) !important;\n}\n\n.ag-row {\n  height: var(--ag-row-height);\n  background-color: var(--ag-background-color);\n  color: var(--ag-data-color);\n  border-bottom: var(--ag-row-border-style) var(--ag-row-border-color) var(--ag-row-border-width);\n}\n\n.ag-row-highlight-above::after,\n.ag-row-highlight-below::after {\n  content: "";\n  position: absolute;\n  width: calc(100% - 1px);\n  height: 1px;\n  background-color: var(--ag-range-selection-border-color);\n  left: 1px;\n}\n\n.ag-row-highlight-above::after {\n  top: 0px;\n}\n\n.ag-row-highlight-below::after {\n  bottom: 0px;\n}\n\n.ag-row-odd {\n  background-color: var(--ag-odd-row-background-color);\n}\n\n.ag-body-horizontal-scroll:not(.ag-scrollbar-invisible) .ag-horizontal-left-spacer:not(.ag-scroller-corner) {\n  border-right: var(--ag-borders-critical) var(--ag-border-color);\n}\n.ag-body-horizontal-scroll:not(.ag-scrollbar-invisible) .ag-horizontal-right-spacer:not(.ag-scroller-corner) {\n  border-left: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-row-selected::before {\n  content: "";\n  background-color: var(--ag-selected-row-background-color);\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n}\n\n.ag-row-hover:not(.ag-full-width-row)::before,\n.ag-row-hover.ag-full-width-row.ag-row-group::before {\n  content: "";\n  background-color: var(--ag-row-hover-color);\n  display: block;\n  position: absolute;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  pointer-events: none;\n}\n\n.ag-row-hover.ag-full-width-row.ag-row-group > * {\n  position: relative;\n}\n\n.ag-row-hover.ag-row-selected::before {\n  background-color: var(--ag-row-hover-color);\n  background-image: linear-gradient(var(--ag-selected-row-background-color), var(--ag-selected-row-background-color));\n}\n\n.ag-column-hover {\n  background-color: var(--ag-column-hover-color);\n}\n\n.ag-ltr .ag-right-aligned-cell {\n  text-align: right;\n}\n.ag-rtl .ag-right-aligned-cell {\n  text-align: left;\n}\n\n.ag-ltr .ag-right-aligned-cell .ag-cell-value,\n.ag-ltr .ag-right-aligned-cell .ag-group-value {\n  margin-left: auto;\n}\n.ag-rtl .ag-right-aligned-cell .ag-cell-value,\n.ag-rtl .ag-right-aligned-cell .ag-group-value {\n  margin-right: auto;\n}\n\n.ag-ltr .ag-right-aligned-cell .ag-skeleton-effect {\n  margin-left: auto;\n}\n.ag-rtl .ag-right-aligned-cell .ag-skeleton-effect {\n  margin-right: auto;\n}\n\n.ag-cell,\n.ag-full-width-row .ag-cell-wrapper.ag-row-group {\n  --ag-internal-calculated-line-height: var(\n      --ag-line-height,\n      calc(var(--ag-row-height) - var(--ag-row-border-width))\n  );\n  --ag-internal-padded-row-height: calc(var(--ag-row-height) - var(--ag-row-border-width));\n  border: 1px solid transparent;\n  line-height: min(var(--ag-internal-calculated-line-height), var(--ag-internal-padded-row-height));\n  padding-left: calc(var(--ag-cell-horizontal-padding) - 1px + var(--ag-row-group-indent-size) * var(--ag-indentation-level));\n  padding-right: calc(var(--ag-cell-horizontal-padding) - 1px);\n  -webkit-font-smoothing: subpixel-antialiased;\n}\n\n.ag-row > .ag-cell-wrapper {\n  padding-left: calc(var(--ag-cell-horizontal-padding) - 1px);\n  padding-right: calc(var(--ag-cell-horizontal-padding) - 1px);\n}\n\n.ag-row-dragging {\n  cursor: move;\n  opacity: 0.5;\n}\n\n.ag-cell-inline-editing {\n  border: 1px solid var(--ag-border-color);\n  border-radius: var(--ag-card-radius);\n  box-shadow: var(--ag-card-shadow);\n  padding: 0;\n  background-color: var(--ag-control-panel-background-color);\n}\n\n.ag-popup-editor .ag-large-text,\n.ag-autocomplete-list-popup {\n  border: var(--ag-borders) var(--ag-border-color);\n  background: var(--ag-background-color);\n  border-radius: var(--ag-card-radius);\n  box-shadow: var(--ag-card-shadow);\n  padding: var(--ag-grid-size);\n  background-color: var(--ag-control-panel-background-color);\n  padding: 0;\n}\n\n.ag-large-text-input {\n  height: auto;\n  padding: var(--ag-cell-horizontal-padding);\n}\n\n.ag-rtl .ag-large-text-input textarea {\n  resize: none;\n}\n\n.ag-details-row {\n  padding: calc(var(--ag-grid-size) * 5);\n  background-color: var(--ag-background-color);\n}\n\n.ag-layout-auto-height .ag-center-cols-viewport,\n.ag-layout-auto-height .ag-center-cols-container,\n.ag-layout-print .ag-center-cols-viewport,\n.ag-layout-print .ag-center-cols-container {\n  min-height: 50px;\n}\n\n.ag-overlay-loading-wrapper {\n  background-color: var(--ag-modal-overlay-background-color);\n}\n\n.ag-overlay-loading-center {\n  border: var(--ag-borders) var(--ag-border-color);\n  background: var(--ag-background-color);\n  border-radius: var(--ag-card-radius);\n  box-shadow: var(--ag-card-shadow);\n  padding: var(--ag-grid-size);\n}\n\n.ag-skeleton-container {\n  width: 100%;\n  height: 100%;\n  align-content: center;\n}\n\n.ag-skeleton-effect {\n  background-color: var(--ag-row-loading-skeleton-effect-color);\n  width: 100%;\n  height: 1em;\n  border-radius: 0.25rem;\n  animation: ag-skeleton-loading 1.5s ease-in-out 0.5s infinite;\n}\n\n@keyframes ag-skeleton-loading {\n  0% {\n    opacity: 1;\n  }\n  50% {\n    opacity: 0.4;\n  }\n  100% {\n    opacity: 1;\n  }\n}\n.ag-loading {\n  display: flex;\n  height: 100%;\n  align-items: center;\n}\n.ag-ltr .ag-loading {\n  padding-left: var(--ag-cell-horizontal-padding);\n}\n.ag-rtl .ag-loading {\n  padding-right: var(--ag-cell-horizontal-padding);\n}\n\n.ag-ltr .ag-loading-icon {\n  padding-right: var(--ag-cell-widget-spacing);\n}\n.ag-rtl .ag-loading-icon {\n  padding-left: var(--ag-cell-widget-spacing);\n}\n\n.ag-icon-loading {\n  animation-name: spin;\n  animation-duration: 1000ms;\n  animation-iteration-count: infinite;\n  animation-timing-function: linear;\n}\n\n@keyframes spin {\n  from {\n    transform: rotate(0deg);\n  }\n  to {\n    transform: rotate(360deg);\n  }\n}\n.ag-floating-top {\n  border-bottom: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-floating-bottom {\n  border-top: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-ltr .ag-cell {\n  border-right: var(--ag-cell-horizontal-border);\n}\n.ag-rtl .ag-cell {\n  border-left: var(--ag-cell-horizontal-border);\n}\n.ag-ltr .ag-cell {\n  border-right-width: 1px;\n}\n.ag-rtl .ag-cell {\n  border-left-width: 1px;\n}\n\n.ag-cell.ag-cell-first-right-pinned:not(.ag-cell-range-left):not(.ag-cell-range-single-cell) {\n  border-left: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-cell.ag-cell-last-left-pinned:not(.ag-cell-range-right):not(.ag-cell-range-single-cell) {\n  border-right: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-cell-range-selected:not(.ag-cell-focus),\n.ag-cell-range-selected.ag-cell-range-chart,\n.ag-body-viewport:not(.ag-has-focus) .ag-cell-range-single-cell:not(.ag-cell-inline-editing) {\n  background-color: var(--ag-range-selection-background-color);\n}\n.ag-cell-range-selected:not(.ag-cell-focus).ag-cell-range-chart,\n.ag-cell-range-selected.ag-cell-range-chart.ag-cell-range-chart,\n.ag-body-viewport:not(.ag-has-focus) .ag-cell-range-single-cell:not(.ag-cell-inline-editing).ag-cell-range-chart {\n  background-color: var(--ag-range-selection-chart-background-color) !important;\n}\n.ag-cell-range-selected:not(.ag-cell-focus).ag-cell-range-chart.ag-cell-range-chart-category,\n.ag-cell-range-selected.ag-cell-range-chart.ag-cell-range-chart.ag-cell-range-chart-category,\n.ag-body-viewport:not(.ag-has-focus) .ag-cell-range-single-cell:not(.ag-cell-inline-editing).ag-cell-range-chart.ag-cell-range-chart-category {\n  background-color: var(--ag-range-selection-chart-category-background-color) !important;\n}\n\n.ag-cell-range-selected-1:not(.ag-cell-focus),\n.ag-cell-range-selected-1.ag-cell-range-chart,\n.ag-root:not(.ag-context-menu-open) .ag-body-viewport:not(.ag-has-focus) .ag-cell-range-selected-1:not(.ag-cell-inline-editing) {\n  background-color: var(--ag-range-selection-background-color);\n}\n\n.ag-cell-range-selected-2:not(.ag-cell-focus),\n.ag-cell-range-selected-2.ag-cell-range-chart,\n.ag-body-viewport:not(.ag-has-focus) .ag-cell-range-selected-2 {\n  background-color: var(--ag-range-selection-background-color-2);\n}\n\n.ag-cell-range-selected-3:not(.ag-cell-focus),\n.ag-cell-range-selected-3.ag-cell-range-chart,\n.ag-body-viewport:not(.ag-has-focus) .ag-cell-range-selected-3 {\n  background-color: var(--ag-range-selection-background-color-3);\n}\n\n.ag-cell-range-selected-4:not(.ag-cell-focus),\n.ag-cell-range-selected-4.ag-cell-range-chart,\n.ag-body-viewport:not(.ag-has-focus) .ag-cell-range-selected-4 {\n  background-color: var(--ag-range-selection-background-color-4);\n}\n\n.ag-cell.ag-cell-range-selected:not(.ag-cell-range-single-cell).ag-cell-range-top {\n  border-top-color: var(--ag-range-selection-border-color);\n  border-top-style: var(--ag-range-selection-border-style);\n}\n.ag-cell.ag-cell-range-selected:not(.ag-cell-range-single-cell).ag-cell-range-right {\n  border-right-color: var(--ag-range-selection-border-color);\n  border-right-style: var(--ag-range-selection-border-style);\n}\n.ag-cell.ag-cell-range-selected:not(.ag-cell-range-single-cell).ag-cell-range-bottom {\n  border-bottom-color: var(--ag-range-selection-border-color);\n  border-bottom-style: var(--ag-range-selection-border-style);\n}\n.ag-cell.ag-cell-range-selected:not(.ag-cell-range-single-cell).ag-cell-range-left {\n  border-left-color: var(--ag-range-selection-border-color);\n  border-left-style: var(--ag-range-selection-border-style);\n}\n\n.ag-ltr .ag-cell-focus:not(.ag-cell-range-selected):focus-within,\n.ag-ltr .ag-context-menu-open .ag-cell-focus:not(.ag-cell-range-selected),\n.ag-ltr .ag-full-width-row.ag-row-focus:focus .ag-cell-wrapper.ag-row-group,\n.ag-ltr .ag-cell-range-single-cell,\n.ag-ltr .ag-cell-range-single-cell.ag-cell-range-handle,\n.ag-rtl .ag-cell-focus:not(.ag-cell-range-selected):focus-within,\n.ag-rtl .ag-context-menu-open .ag-cell-focus:not(.ag-cell-range-selected),\n.ag-rtl .ag-full-width-row.ag-row-focus:focus .ag-cell-wrapper.ag-row-group,\n.ag-rtl .ag-cell-range-single-cell,\n.ag-rtl .ag-cell-range-single-cell.ag-cell-range-handle {\n  border: 1px solid;\n  border-color: var(--ag-range-selection-border-color);\n  border-style: var(--ag-range-selection-border-style);\n  outline: medium none currentcolor;\n  outline: initial;\n}\n\n.ag-cell.ag-selection-fill-top,\n.ag-cell.ag-selection-fill-top.ag-cell-range-selected {\n  border-top: 1px dashed;\n  border-top-color: var(--ag-range-selection-border-color);\n}\n\n.ag-ltr .ag-cell.ag-selection-fill-right,\n.ag-ltr .ag-cell.ag-selection-fill-right.ag-cell-range-selected {\n  border-right: 1px dashed var(--ag-range-selection-border-color) !important;\n}\n.ag-rtl .ag-cell.ag-selection-fill-right,\n.ag-rtl .ag-cell.ag-selection-fill-right.ag-cell-range-selected {\n  border-left: 1px dashed var(--ag-range-selection-border-color) !important;\n}\n\n.ag-cell.ag-selection-fill-bottom,\n.ag-cell.ag-selection-fill-bottom.ag-cell-range-selected {\n  border-bottom: 1px dashed;\n  border-bottom-color: var(--ag-range-selection-border-color);\n}\n\n.ag-ltr .ag-cell.ag-selection-fill-left,\n.ag-ltr .ag-cell.ag-selection-fill-left.ag-cell-range-selected {\n  border-left: 1px dashed var(--ag-range-selection-border-color) !important;\n}\n.ag-rtl .ag-cell.ag-selection-fill-left,\n.ag-rtl .ag-cell.ag-selection-fill-left.ag-cell-range-selected {\n  border-right: 1px dashed var(--ag-range-selection-border-color) !important;\n}\n\n.ag-fill-handle,\n.ag-range-handle {\n  position: absolute;\n  width: 6px;\n  height: 6px;\n  bottom: -1px;\n  background-color: var(--ag-range-selection-border-color);\n}\n.ag-ltr .ag-fill-handle,\n.ag-ltr .ag-range-handle {\n  right: -1px;\n}\n.ag-rtl .ag-fill-handle,\n.ag-rtl .ag-range-handle {\n  left: -1px;\n}\n\n.ag-fill-handle {\n  cursor: cell;\n}\n\n.ag-range-handle {\n  cursor: nwse-resize;\n}\n\n.ag-cell-inline-editing {\n  border-color: var(--ag-input-focus-border-color) !important;\n}\n\n.ag-menu {\n  border: var(--ag-borders) var(--ag-border-color);\n  background: var(--ag-background-color);\n  border-radius: var(--ag-card-radius);\n  box-shadow: var(--ag-card-shadow);\n  padding: var(--ag-grid-size);\n  background-color: var(--ag-menu-background-color);\n  border-color: var(--ag-menu-border-color);\n  padding: 0;\n}\n\n.ag-menu.ag-tabs {\n  min-width: var(--ag-tab-min-width);\n}\n\n.ag-menu-list {\n  cursor: default;\n  padding: var(--ag-grid-size) 0;\n}\n\n.ag-menu-separator {\n  height: calc(var(--ag-grid-size) * 2 + 1px);\n}\n\n.ag-menu-separator-part::after {\n  content: "";\n  display: block;\n  border-top: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-menu-option-active,\n.ag-compact-menu-option-active {\n  background-color: var(--ag-row-hover-color);\n}\n\n.ag-menu-option-part,\n.ag-compact-menu-option-part {\n  line-height: var(--ag-icon-size);\n  padding: calc(var(--ag-grid-size) + 2px) 0;\n}\n\n.ag-menu-option-disabled,\n.ag-compact-menu-option-disabled {\n  opacity: 0.5;\n}\n\n.ag-menu-option-icon,\n.ag-compact-menu-option-icon {\n  width: var(--ag-icon-size);\n}\n.ag-ltr .ag-menu-option-icon,\n.ag-ltr .ag-compact-menu-option-icon {\n  padding-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-rtl .ag-menu-option-icon,\n.ag-rtl .ag-compact-menu-option-icon {\n  padding-right: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-menu-option-text,\n.ag-compact-menu-option-text {\n  padding-left: calc(var(--ag-grid-size) * 2);\n  padding-right: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-ltr .ag-menu-option-shortcut,\n.ag-ltr .ag-compact-menu-option-shortcut {\n  padding-right: var(--ag-grid-size);\n}\n.ag-rtl .ag-menu-option-shortcut,\n.ag-rtl .ag-compact-menu-option-shortcut {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-ltr .ag-menu-option-popup-pointer,\n.ag-ltr .ag-compact-menu-option-popup-pointer {\n  padding-right: var(--ag-grid-size);\n}\n.ag-rtl .ag-menu-option-popup-pointer,\n.ag-rtl .ag-compact-menu-option-popup-pointer {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-tabs-header {\n  display: flex;\n}\n\n.ag-tabs-header-wrapper {\n  display: flex;\n}\n.ag-tabs-header-wrapper .ag-tabs-header {\n  flex: 1;\n}\n\n.ag-tabs-close-button-wrapper {\n  border: 0;\n  border-right: var(--ag-borders) var(--ag-border-color);\n  padding: var(--ag-grid-size);\n}\n\n.ag-tabs-close-button {\n  border: 0;\n  background-color: transparent;\n  background-color: initial;\n  cursor: pointer;\n  padding: 0;\n}\n\n.ag-tab {\n  border-bottom: var(--ag-selected-tab-underline-width) solid transparent;\n  transition: border-bottom var(--ag-selected-tab-underline-transition-speed);\n  display: flex;\n  flex: none;\n  align-items: center;\n  justify-content: center;\n  cursor: pointer;\n}\n\n.ag-tab:focus-visible {\n  outline: none;\n}\n.ag-tab:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-tab-selected {\n  border-bottom-color: var(--ag-selected-tab-underline-color);\n}\n\n.ag-menu-header {\n  color: var(--ag-secondary-foreground-color);\n}\n\n.ag-filter-separator {\n  border-top: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-filter-select .ag-picker-field-wrapper {\n  width: 0;\n}\n\n.ag-filter-condition-operator {\n  height: 17px;\n}\n\n.ag-ltr .ag-filter-condition-operator-or {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-rtl .ag-filter-condition-operator-or {\n  margin-right: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-set-filter-select-all {\n  padding-top: var(--ag-widget-container-vertical-padding);\n}\n\n.ag-set-filter-list,\n.ag-filter-no-matches {\n  height: calc(var(--ag-list-item-height) * 6);\n}\n\n.ag-set-filter-tree-list {\n  height: calc(var(--ag-list-item-height) * 10);\n}\n\n.ag-set-filter-filter {\n  margin-top: var(--ag-widget-container-vertical-padding);\n  margin-left: var(--ag-widget-container-horizontal-padding);\n  margin-right: var(--ag-widget-container-horizontal-padding);\n}\n\n.ag-filter-to {\n  margin-top: var(--ag-widget-vertical-spacing);\n}\n\n.ag-mini-filter {\n  margin: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n}\n\n.ag-set-filter {\n  --ag-indentation-level: 0;\n}\n\n.ag-ltr .ag-set-filter-item {\n  padding-left: calc(var(--ag-widget-container-horizontal-padding) + var(--ag-indentation-level) * var(--ag-set-filter-indent-size));\n}\n.ag-rtl .ag-set-filter-item {\n  padding-right: calc(var(--ag-widget-container-horizontal-padding) + var(--ag-indentation-level) * var(--ag-set-filter-indent-size));\n}\n\n.ag-ltr .ag-set-filter-add-group-indent {\n  margin-left: calc(var(--ag-icon-size) + var(--ag-widget-container-horizontal-padding));\n}\n.ag-rtl .ag-set-filter-add-group-indent {\n  margin-right: calc(var(--ag-icon-size) + var(--ag-widget-container-horizontal-padding));\n}\n\n.ag-ltr .ag-set-filter-group-icons {\n  margin-right: var(--ag-widget-container-horizontal-padding);\n}\n.ag-rtl .ag-set-filter-group-icons {\n  margin-left: var(--ag-widget-container-horizontal-padding);\n}\n\n.ag-filter-menu .ag-set-filter-list {\n  min-width: 200px;\n}\n\n.ag-filter-virtual-list-item:focus-visible {\n  outline: none;\n}\n.ag-filter-virtual-list-item:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 1px;\n  left: 1px;\n  display: block;\n  width: calc(100% - 2px);\n  height: calc(100% - 2px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-filter-apply-panel {\n  padding: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n\n.ag-filter-apply-panel-button {\n  line-height: 1.5;\n}\n.ag-ltr .ag-filter-apply-panel-button {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-rtl .ag-filter-apply-panel-button {\n  margin-right: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-simple-filter-body-wrapper {\n  padding: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n  padding-bottom: calc(var(--ag-widget-container-vertical-padding) - var(--ag-widget-vertical-spacing));\n  overflow-y: auto;\n  min-height: calc(var(--ag-list-item-height) + var(--ag-widget-container-vertical-padding) + var(--ag-widget-vertical-spacing));\n}\n.ag-simple-filter-body-wrapper > * {\n  margin-bottom: var(--ag-widget-vertical-spacing);\n}\n.ag-simple-filter-body-wrapper .ag-resizer-wrapper {\n  margin: 0;\n}\n\n.ag-menu:not(.ag-tabs) .ag-filter .ag-filter-body-wrapper,\n.ag-menu:not(.ag-tabs) .ag-filter > *:not(.ag-filter-wrapper) {\n  min-width: calc(var(--ag-menu-min-width) - 2px);\n}\n\n.ag-filter-no-matches {\n  padding: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n}\n\n.ag-multi-filter-menu-item {\n  margin: var(--ag-grid-size) 0;\n}\n\n.ag-multi-filter-group-title-bar {\n  padding: calc(var(--ag-grid-size) * 2) var(--ag-grid-size);\n  background-color: transparent;\n}\n\n.ag-group-filter-field-select-wrapper {\n  padding: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n  padding-bottom: calc(var(--ag-widget-container-vertical-padding) - var(--ag-widget-vertical-spacing));\n}\n.ag-group-filter-field-select-wrapper > * {\n  margin-bottom: var(--ag-widget-vertical-spacing);\n}\n\n.ag-multi-filter-group-title-bar:focus-visible {\n  outline: none;\n}\n.ag-multi-filter-group-title-bar:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-side-bar {\n  position: relative;\n}\n\n.ag-tool-panel-wrapper {\n  width: var(--ag-side-bar-panel-width);\n  background-color: var(--ag-control-panel-background-color);\n}\n\n.ag-side-buttons {\n  padding-top: calc(var(--ag-grid-size) * 4);\n  width: calc(var(--ag-icon-size) + 4px);\n  position: relative;\n  overflow: hidden;\n}\n\nbutton.ag-side-button-button {\n  color: inherit;\n  font-family: inherit;\n  font-size: inherit;\n  font-weight: inherit;\n  line-height: inherit;\n  background: transparent;\n  padding: calc(var(--ag-grid-size) * 2) 0 calc(var(--ag-grid-size) * 2) 0;\n  width: 100%;\n  margin: 0;\n  min-height: calc(var(--ag-grid-size) * 18);\n  background-position-y: center;\n  background-position-x: center;\n  background-repeat: no-repeat;\n  border: none;\n  border-top: var(--ag-borders-side-button) var(--ag-border-color);\n  border-bottom: var(--ag-borders-side-button) var(--ag-border-color);\n}\nbutton.ag-side-button-button:focus {\n  box-shadow: none;\n}\n\n.ag-side-button-button:focus-visible {\n  outline: none;\n}\n.ag-side-button-button:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-selected button.ag-side-button-button {\n  background-color: var(--ag-side-button-selected-background-color);\n}\n\n.ag-side-button-icon-wrapper {\n  margin-bottom: 3px;\n}\n\n.ag-ltr .ag-side-bar-left,\n.ag-rtl .ag-side-bar-right {\n  border-right: var(--ag-borders) var(--ag-border-color);\n}\n.ag-ltr .ag-side-bar-left .ag-tool-panel-wrapper,\n.ag-rtl .ag-side-bar-right .ag-tool-panel-wrapper {\n  border-left: var(--ag-borders) var(--ag-border-color);\n}\n.ag-ltr .ag-side-bar-left .ag-side-button-button,\n.ag-rtl .ag-side-bar-right .ag-side-button-button {\n  border-right: var(--ag-selected-tab-underline-width) solid transparent;\n  transition: border-right var(--ag-selected-tab-underline-transition-speed);\n}\n.ag-ltr .ag-side-bar-left .ag-selected .ag-side-button-button,\n.ag-rtl .ag-side-bar-right .ag-selected .ag-side-button-button {\n  border-right-color: var(--ag-selected-tab-underline-color);\n}\n\n.ag-rtl .ag-side-bar-left,\n.ag-ltr .ag-side-bar-right {\n  border-left: var(--ag-borders) var(--ag-border-color);\n}\n.ag-rtl .ag-side-bar-left .ag-tool-panel-wrapper,\n.ag-ltr .ag-side-bar-right .ag-tool-panel-wrapper {\n  border-right: var(--ag-borders) var(--ag-border-color);\n}\n.ag-rtl .ag-side-bar-left .ag-side-button-button,\n.ag-ltr .ag-side-bar-right .ag-side-button-button {\n  border-left: var(--ag-selected-tab-underline-width) solid transparent;\n  transition: border-left var(--ag-selected-tab-underline-transition-speed);\n}\n.ag-rtl .ag-side-bar-left .ag-selected .ag-side-button-button,\n.ag-ltr .ag-side-bar-right .ag-selected .ag-side-button-button {\n  border-left-color: var(--ag-selected-tab-underline-color);\n}\n\n.ag-filter-toolpanel-header {\n  height: calc(var(--ag-grid-size) * 6);\n}\n\n.ag-filter-toolpanel-header,\n.ag-filter-toolpanel-search {\n  padding: 0 var(--ag-grid-size);\n}\n\n.ag-filter-toolpanel-header:focus-visible {\n  outline: none;\n}\n.ag-filter-toolpanel-header:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-filter-toolpanel-group:not(.ag-has-filter) > .ag-group-title-bar .ag-filter-toolpanel-group-instance-header-icon {\n  display: none;\n}\n\n.ag-filter-toolpanel-group-level-0-header {\n  height: calc(var(--ag-grid-size) * 8);\n}\n\n.ag-filter-toolpanel-group-item {\n  margin-top: calc(var(--ag-grid-size) * 0.5);\n  margin-bottom: calc(var(--ag-grid-size) * 0.5);\n}\n\n.ag-filter-toolpanel-search {\n  height: var(--ag-header-height);\n}\n\n.ag-filter-toolpanel-search-input {\n  flex-grow: 1;\n  height: calc(var(--ag-grid-size) * 4);\n}\n.ag-ltr .ag-filter-toolpanel-search-input {\n  margin-right: var(--ag-grid-size);\n}\n.ag-rtl .ag-filter-toolpanel-search-input {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-filter-toolpanel-group-level-0 {\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n\n.ag-ltr .ag-filter-toolpanel-expand,\n.ag-ltr .ag-filter-toolpanel-group-title-bar-icon {\n  margin-right: var(--ag-grid-size);\n}\n.ag-rtl .ag-filter-toolpanel-expand,\n.ag-rtl .ag-filter-toolpanel-group-title-bar-icon {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-filter-toolpanel-group-title-bar {\n  background-color: transparent;\n}\n\n.ag-ltr .ag-filter-toolpanel-header {\n  padding-left: calc(var(--ag-filter-tool-panel-group-indent) * 0 + var(--ag-grid-size));\n  padding-left: calc(var(--ag-filter-tool-panel-group-indent) * var(--ag-indentation-level, 0) + var(--ag-grid-size));\n}\n.ag-rtl .ag-filter-toolpanel-header {\n  padding-right: calc(var(--ag-filter-tool-panel-group-indent) * 0 + var(--ag-grid-size));\n  padding-right: calc(var(--ag-filter-tool-panel-group-indent) * var(--ag-indentation-level, 0) + var(--ag-grid-size));\n}\n\n.ag-filter-toolpanel-instance-filter {\n  border-bottom: var(--ag-borders) var(--ag-border-color);\n  border-top: var(--ag-borders) var(--ag-border-color);\n  margin-top: var(--ag-grid-size);\n}\n\n.ag-ltr .ag-filter-toolpanel-group-instance-header-icon,\n.ag-ltr .ag-filter-toolpanel-instance-header-icon {\n  margin-left: var(--ag-grid-size);\n}\n.ag-rtl .ag-filter-toolpanel-group-instance-header-icon,\n.ag-rtl .ag-filter-toolpanel-instance-header-icon {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-set-filter-group-icons {\n  color: var(--ag-secondary-foreground-color);\n}\n\n.ag-pivot-mode-panel {\n  min-height: var(--ag-header-height);\n  height: var(--ag-header-height);\n  display: flex;\n}\n\n.ag-pivot-mode-select {\n  display: flex;\n  align-items: center;\n}\n.ag-ltr .ag-pivot-mode-select {\n  margin-left: var(--ag-widget-container-horizontal-padding);\n}\n.ag-rtl .ag-pivot-mode-select {\n  margin-right: var(--ag-widget-container-horizontal-padding);\n}\n\n.ag-column-select-header:focus-visible {\n  outline: none;\n}\n.ag-column-select-header:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-column-select-header {\n  height: var(--ag-header-height);\n  align-items: center;\n  padding: 0 var(--ag-widget-container-horizontal-padding);\n  border-bottom: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n\n.ag-column-panel-column-select {\n  border-bottom: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n\n.ag-column-group-icons,\n.ag-column-select-header-icon {\n  color: var(--ag-secondary-foreground-color);\n}\n\n.ag-column-select-list .ag-list-item-hovered::after {\n  content: "";\n  position: absolute;\n  left: 0;\n  right: 0;\n  height: 1px;\n}\n.ag-column-select-list .ag-item-highlight-top::after {\n  top: 0;\n}\n.ag-column-select-list .ag-item-highlight-bottom::after {\n  bottom: 0;\n}\n\n.ag-header,\n.ag-advanced-filter-header {\n  background-color: var(--ag-header-background-color);\n  border-bottom: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-header-row {\n  color: var(--ag-header-foreground-color);\n  height: var(--ag-header-height);\n}\n\n.ag-pinned-right-header {\n  border-left: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-pinned-left-header {\n  border-right: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-ltr .ag-header-cell:not(.ag-right-aligned-header) .ag-header-label-icon,\n.ag-ltr .ag-header-cell:not(.ag-right-aligned-header) .ag-header-menu-icon {\n  margin-left: var(--ag-grid-size);\n}\n.ag-rtl .ag-header-cell:not(.ag-right-aligned-header) .ag-header-label-icon,\n.ag-rtl .ag-header-cell:not(.ag-right-aligned-header) .ag-header-menu-icon {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-ltr .ag-header-cell.ag-right-aligned-header .ag-header-label-icon,\n.ag-ltr .ag-header-cell.ag-right-aligned-header .ag-header-menu-icon {\n  margin-right: var(--ag-grid-size);\n}\n.ag-rtl .ag-header-cell.ag-right-aligned-header .ag-header-label-icon,\n.ag-rtl .ag-header-cell.ag-right-aligned-header .ag-header-menu-icon {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-header-cell,\n.ag-header-group-cell {\n  padding-left: var(--ag-cell-horizontal-padding);\n  padding-right: var(--ag-cell-horizontal-padding);\n}\n.ag-header-cell.ag-header-cell-moving,\n.ag-header-group-cell.ag-header-cell-moving {\n  background-color: var(--ag-header-cell-moving-background-color);\n}\n\n.ag-ltr .ag-header-group-cell-label.ag-sticky-label {\n  left: var(--ag-cell-horizontal-padding);\n}\n.ag-rtl .ag-header-group-cell-label.ag-sticky-label {\n  right: var(--ag-cell-horizontal-padding);\n}\n\n.ag-header-cell:focus-visible {\n  outline: none;\n}\n.ag-header-cell:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-header-group-cell:focus-visible {\n  outline: none;\n}\n.ag-header-group-cell:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-advanced-filter-header-cell:focus-visible {\n  outline: none;\n}\n.ag-advanced-filter-header-cell:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-header-icon {\n  color: var(--ag-secondary-foreground-color);\n}\n\n.ag-header-expand-icon {\n  cursor: pointer;\n}\n.ag-ltr .ag-header-expand-icon {\n  margin-left: 4px;\n}\n.ag-rtl .ag-header-expand-icon {\n  margin-right: 4px;\n}\n\n.ag-header-row:not(:first-child) .ag-header-cell:not(.ag-header-span-height.ag-header-span-total):not(.ag-header-parent-hidden),\n.ag-header-row:not(:first-child) .ag-header-group-cell.ag-header-group-cell-with-group {\n  border-top: var(--ag-borders-critical) var(--ag-border-color);\n}\n\n.ag-header-group-cell:not(.ag-column-resizing) + .ag-header-group-cell:not(.ag-column-hover):not(.ag-header-cell-moving):hover, .ag-header-group-cell:not(.ag-column-resizing) + .ag-header-group-cell:not(.ag-column-hover).ag-column-resizing,\n.ag-header-cell:not(.ag-column-resizing) + .ag-header-cell:not(.ag-column-hover):not(.ag-header-cell-moving):hover,\n.ag-header-cell:not(.ag-column-resizing) + .ag-header-cell:not(.ag-column-hover).ag-column-resizing,\n.ag-header-group-cell:first-of-type:not(.ag-header-cell-moving):hover,\n.ag-header-group-cell:first-of-type.ag-column-resizing,\n.ag-header-cell:not(.ag-column-hover):first-of-type:not(.ag-header-cell-moving):hover,\n.ag-header-cell:not(.ag-column-hover):first-of-type.ag-column-resizing {\n  background-color: var(--ag-header-cell-hover-background-color);\n}\n\n.ag-header-cell::before,\n.ag-header-group-cell:not(.ag-header-span-height.ag-header-group-cell-no-group)::before {\n  content: "";\n  position: absolute;\n  z-index: 1;\n  display: var(--ag-header-column-separator-display);\n  width: var(--ag-header-column-separator-width);\n  height: var(--ag-header-column-separator-height);\n  top: calc(50% - var(--ag-header-column-separator-height) * 0.5);\n  background-color: var(--ag-header-column-separator-color);\n}\n.ag-ltr .ag-header-cell::before,\n.ag-ltr .ag-header-group-cell:not(.ag-header-span-height.ag-header-group-cell-no-group)::before {\n  right: 0;\n}\n.ag-rtl .ag-header-cell::before,\n.ag-rtl .ag-header-group-cell:not(.ag-header-span-height.ag-header-group-cell-no-group)::before {\n  left: 0;\n}\n\n.ag-header-highlight-before::after,\n.ag-header-highlight-after::after {\n  content: "";\n  position: absolute;\n  height: 100%;\n  width: 1px;\n}\n\n.ag-header-highlight-before::after {\n  left: 0px;\n}\n\n.ag-header-highlight-after::after {\n  right: 0px;\n}\n\n.ag-pinned-left-header .ag-header-highlight-after::after {\n  right: 1px;\n}\n\n.ag-header-cell-resize {\n  display: flex;\n  align-items: center;\n}\n\n.ag-header-cell-resize::after {\n  content: "";\n  position: absolute;\n  z-index: 1;\n  display: var(--ag-header-column-resize-handle-display);\n  width: var(--ag-header-column-resize-handle-width);\n  height: var(--ag-header-column-resize-handle-height);\n  top: calc(50% - var(--ag-header-column-resize-handle-height) * 0.5);\n  background-color: var(--ag-header-column-resize-handle-color);\n}\n.ag-header-cell.ag-header-span-height .ag-header-cell-resize::after {\n  height: calc(100% - var(--ag-grid-size) * 4);\n  top: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-ltr .ag-header-viewport .ag-header-cell-resize::after {\n  left: calc(50% - var(--ag-header-column-resize-handle-width));\n}\n.ag-rtl .ag-header-viewport .ag-header-cell-resize::after {\n  right: calc(50% - var(--ag-header-column-resize-handle-width));\n}\n\n.ag-pinned-left-header .ag-header-cell-resize::after {\n  left: calc(50% - var(--ag-header-column-resize-handle-width));\n}\n\n.ag-pinned-right-header .ag-header-cell-resize::after {\n  left: 50%;\n}\n\n.ag-ltr .ag-header-select-all {\n  margin-right: var(--ag-cell-horizontal-padding);\n}\n.ag-rtl .ag-header-select-all {\n  margin-left: var(--ag-cell-horizontal-padding);\n}\n\n.ag-ltr .ag-floating-filter-button {\n  margin-left: var(--ag-cell-widget-spacing);\n}\n.ag-rtl .ag-floating-filter-button {\n  margin-right: var(--ag-cell-widget-spacing);\n}\n\n.ag-floating-filter-button-button {\n  color: inherit;\n  font-family: inherit;\n  font-size: inherit;\n  font-weight: inherit;\n  line-height: inherit;\n  -webkit-appearance: none;\n     -moz-appearance: none;\n          appearance: none;\n  background: transparent;\n  border: none;\n  height: var(--ag-icon-size);\n  padding: 0;\n  width: var(--ag-icon-size);\n}\n\n.ag-filter-loading {\n  background-color: var(--ag-control-panel-background-color);\n  height: 100%;\n  padding: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n  position: absolute;\n  width: 100%;\n  z-index: 1;\n}\n\n.ag-paging-panel {\n  border-top: 1px solid;\n  border-top-color: var(--ag-border-color);\n  color: var(--ag-secondary-foreground-color);\n  height: var(--ag-header-height);\n}\n.ag-paging-panel > * {\n  margin: 0 var(--ag-cell-horizontal-padding);\n}\n.ag-paging-panel > .ag-paging-page-size .ag-wrapper {\n  min-width: calc(var(--ag-grid-size) * 10);\n}\n\n.ag-paging-button {\n  cursor: pointer;\n}\n\n.ag-paging-button.ag-disabled {\n  cursor: default;\n  color: var(--ag-disabled-foreground-color);\n}\n\n.ag-paging-button:focus-visible {\n  outline: none;\n}\n.ag-paging-button:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 0px;\n  left: 0px;\n  display: block;\n  width: calc(100% - 0px);\n  height: calc(100% - 0px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-paging-button,\n.ag-paging-description {\n  margin: 0 var(--ag-grid-size);\n}\n\n.ag-status-bar {\n  border-top: var(--ag-borders) var(--ag-border-color);\n  color: var(--ag-disabled-foreground-color);\n  padding-right: calc(var(--ag-grid-size) * 4);\n  padding-left: calc(var(--ag-grid-size) * 4);\n  line-height: 1.5;\n}\n\n.ag-status-name-value-value {\n  color: var(--ag-foreground-color);\n}\n\n.ag-status-bar-center {\n  text-align: center;\n}\n\n.ag-status-name-value {\n  margin-left: var(--ag-grid-size);\n  margin-right: var(--ag-grid-size);\n  padding-top: calc(var(--ag-grid-size) * 2);\n  padding-bottom: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-column-drop-cell {\n  background: var(--ag-chip-background-color);\n  border-radius: calc(var(--ag-grid-size) * 4);\n  height: calc(var(--ag-grid-size) * 4);\n  padding: 0 calc(var(--ag-grid-size) * 0.5);\n  border: 1px solid var(--ag-chip-border-color);\n}\n\n.ag-column-drop-cell:focus-visible {\n  outline: none;\n}\n.ag-column-drop-cell:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 2px;\n  left: 2px;\n  display: block;\n  width: calc(100% - 4px);\n  height: calc(100% - 4px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-column-drop-cell-text {\n  margin: 0 var(--ag-grid-size);\n}\n\n.ag-column-drop-cell-button {\n  min-width: calc(var(--ag-grid-size) * 4);\n  margin: 0 calc(var(--ag-grid-size) * 0.5);\n  color: var(--ag-secondary-foreground-color);\n}\n\n.ag-column-drop-cell-drag-handle {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-column-drop-cell-ghost {\n  opacity: 0.5;\n}\n\n.ag-column-drop-horizontal {\n  background-color: var(--ag-header-background-color);\n  color: var(--ag-secondary-foreground-color);\n  height: var(--ag-header-height);\n  border-bottom: var(--ag-borders) var(--ag-border-color);\n}\n.ag-ltr .ag-column-drop-horizontal {\n  padding-left: var(--ag-cell-horizontal-padding);\n}\n.ag-rtl .ag-column-drop-horizontal {\n  padding-right: var(--ag-cell-horizontal-padding);\n}\n\n.ag-ltr .ag-column-drop-horizontal-half-width:not(:last-child) {\n  border-right: var(--ag-borders) var(--ag-border-color);\n}\n.ag-rtl .ag-column-drop-horizontal-half-width:not(:last-child) {\n  border-left: var(--ag-borders) var(--ag-border-color);\n}\n\n.ag-column-drop-horizontal-cell-separator {\n  margin: 0 var(--ag-grid-size);\n  color: var(--ag-secondary-foreground-color);\n}\n\n.ag-column-drop-horizontal-empty-message {\n  color: var(--ag-disabled-foreground-color);\n}\n\n.ag-ltr .ag-column-drop-horizontal-icon {\n  margin-right: var(--ag-cell-horizontal-padding);\n}\n.ag-rtl .ag-column-drop-horizontal-icon {\n  margin-left: var(--ag-cell-horizontal-padding);\n}\n\n.ag-column-drop-vertical-list {\n  padding-bottom: var(--ag-grid-size);\n  padding-right: var(--ag-grid-size);\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-column-drop-vertical-cell {\n  margin-top: var(--ag-grid-size);\n}\n\n.ag-column-drop-vertical {\n  min-height: 50px;\n  border-bottom: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n.ag-column-drop-vertical.ag-last-column-drop {\n  border-bottom: none;\n}\n\n.ag-column-drop-vertical-icon {\n  margin-left: var(--ag-grid-size);\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-column-drop-vertical-empty-message {\n  position: absolute;\n  top: 0;\n  bottom: 0;\n  left: 0;\n  right: 0;\n  overflow: hidden;\n  color: var(--ag-disabled-foreground-color);\n  margin-top: var(--ag-grid-size);\n}\n\n.ag-select-agg-func-popup {\n  border: var(--ag-borders) var(--ag-border-color);\n  background: var(--ag-background-color);\n  border-radius: var(--ag-card-radius);\n  box-shadow: var(--ag-card-shadow);\n  padding: var(--ag-grid-size);\n  background: var(--ag-background-color);\n  height: calc(var(--ag-grid-size) * 5 * 3.5);\n  padding: 0;\n}\n\n.ag-select-agg-func-virtual-list-item {\n  cursor: default;\n}\n.ag-ltr .ag-select-agg-func-virtual-list-item {\n  padding-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-rtl .ag-select-agg-func-virtual-list-item {\n  padding-right: calc(var(--ag-grid-size) * 2);\n}\n.ag-select-agg-func-virtual-list-item:hover {\n  background-color: var(--ag-selected-row-background-color);\n}\n\n.ag-select-agg-func-virtual-list-item:focus-visible {\n  outline: none;\n}\n.ag-select-agg-func-virtual-list-item:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 1px;\n  left: 1px;\n  display: block;\n  width: calc(100% - 2px);\n  height: calc(100% - 2px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-sort-indicator-container {\n  display: flex;\n}\n\n.ag-ltr .ag-sort-indicator-icon {\n  padding-left: var(--ag-grid-size);\n}\n.ag-rtl .ag-sort-indicator-icon {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-chart {\n  position: relative;\n  display: flex;\n  width: 100%;\n  height: 100%;\n}\n\n.ag-chart-components-wrapper {\n  position: relative;\n  display: flex;\n  flex: 1 1 auto;\n}\n\n.ag-chart-canvas-wrapper {\n  position: relative;\n  flex: 1 1 auto;\n}\n\n.ag-chart-menu {\n  position: absolute;\n  top: 16px;\n  display: flex;\n  flex-direction: column;\n}\n.ag-ltr .ag-chart-menu {\n  right: 20px;\n}\n.ag-rtl .ag-chart-menu {\n  left: 20px;\n}\n\n.ag-chart-docked-container {\n  position: relative;\n  min-width: var(--ag-chart-menu-panel-width);\n}\n\n.ag-chart-menu-hidden ~ .ag-chart-docked-container {\n  display: none;\n}\n\n.ag-chart-tabbed-menu {\n  width: 100%;\n  height: 100%;\n  display: flex;\n  flex-direction: column;\n  overflow: hidden;\n}\n\n.ag-chart-tabbed-menu-header {\n  flex: none;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n  cursor: default;\n}\n\n.ag-chart-tabbed-menu-body {\n  display: flex;\n  flex: 1 1 auto;\n  align-items: stretch;\n  overflow: hidden;\n}\n\n.ag-chart-tab {\n  width: 100%;\n  overflow: hidden;\n  overflow-y: auto;\n}\n\n.ag-chart-settings {\n  overflow-x: hidden;\n}\n\n.ag-chart-settings-wrapper {\n  position: relative;\n  flex-direction: column;\n  width: 100%;\n  height: 100%;\n  display: flex;\n  overflow: hidden;\n}\n\n.ag-chart-settings-nav-bar {\n  display: flex;\n  align-items: center;\n  width: 100%;\n  height: 30px;\n  padding: 0 10px;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n}\n\n.ag-chart-settings-card-selector {\n  display: flex;\n  align-items: center;\n  justify-content: space-around;\n  flex: 1 1 auto;\n  height: 100%;\n  padding: 0 10px;\n}\n\n.ag-chart-settings-card-item {\n  cursor: pointer;\n  width: 10px;\n  height: 10px;\n  background-color: #000;\n  position: relative;\n}\n.ag-chart-settings-card-item.ag-not-selected {\n  opacity: 0.2;\n}\n.ag-chart-settings-card-item::before {\n  content: " ";\n  display: block;\n  position: absolute;\n  background-color: transparent;\n  left: 50%;\n  top: 50%;\n  margin-left: -10px;\n  margin-top: -10px;\n  width: 20px;\n  height: 20px;\n}\n\n.ag-chart-settings-prev,\n.ag-chart-settings-next {\n  position: relative;\n  flex: none;\n}\n.ag-chart-settings-prev:focus-within,\n.ag-chart-settings-next:focus-within {\n  box-shadow: var(--ag-input-focus-box-shadow);\n  border-radius: 1px;\n}\n\n.ag-chart-settings-prev-button,\n.ag-chart-settings-next-button {\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 100%;\n  height: 100%;\n  cursor: pointer;\n  opacity: 0;\n}\n\n.ag-chart-settings-mini-charts-container {\n  position: relative;\n  flex: 1 1 auto;\n  overflow-x: hidden;\n  overflow-y: auto;\n}\n\n.ag-chart-settings-mini-wrapper {\n  position: absolute;\n  top: 0;\n  left: 0;\n  display: flex;\n  flex-direction: column;\n  width: 100%;\n  min-height: 100%;\n  overflow: hidden;\n}\n.ag-chart-settings-mini-wrapper.ag-animating {\n  transition: left 0.3s;\n  transition-timing-function: ease-in-out;\n}\n\n.ag-chart-mini-thumbnail {\n  cursor: pointer;\n}\n\n.ag-chart-mini-thumbnail-canvas {\n  display: block;\n}\n\n.ag-chart-data-wrapper,\n.ag-chart-format-wrapper,\n.ag-chart-advanced-settings-wrapper {\n  display: flex;\n  flex-direction: column;\n  position: relative;\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n  padding-bottom: 16px;\n}\n\n.ag-chart-data-wrapper,\n.ag-chart-advanced-settings-wrapper {\n  height: 100%;\n  overflow-y: auto;\n}\n\n.ag-chart-advanced-settings {\n  background-color: var(--ag-control-panel-background-color);\n}\n\n.ag-chart-advanced-settings-wrapper,\n.ag-chart-advanced-settings {\n  width: 100%;\n}\n\n.ag-chart-advanced-settings-wrapper {\n  padding-bottom: 0;\n}\n\n.ag-chart-data-section,\n.ag-chart-format-section,\n.ag-chart-advanced-settings-section {\n  display: flex;\n  margin: 0;\n}\n\n.ag-chart-advanced-settings-section {\n  padding-top: var(--ag-grid-size);\n  padding-bottom: var(--ag-grid-size);\n}\n.ag-chart-advanced-settings-section:not(:last-child) {\n  border-bottom: 1px solid var(--ag-secondary-border-color);\n}\n\n.ag-chart-empty-text {\n  display: flex;\n  top: 0;\n  width: 100%;\n  height: 100%;\n  align-items: center;\n  justify-content: center;\n  background-color: var(--ag-background-color);\n}\n\n.ag-chart .ag-chart-menu {\n  display: none;\n}\n\n.ag-chart-menu-hidden:hover .ag-chart-menu {\n  display: block;\n}\n\n.ag-chart .ag-chart-menu-wrapper .ag-chart-menu {\n  display: flex;\n  flex-direction: row;\n  top: 8px;\n  gap: 20px;\n  width: auto;\n}\n.ag-ltr .ag-chart .ag-chart-menu-wrapper .ag-chart-menu {\n  right: calc(var(--ag-cell-horizontal-padding) + var(--ag-grid-size) - 4px);\n  justify-content: right;\n}\n.ag-rtl .ag-chart .ag-chart-menu-wrapper .ag-chart-menu {\n  left: calc(var(--ag-cell-horizontal-padding) + var(--ag-grid-size) - 4px);\n  justify-content: left;\n}\n\n.ag-charts-font-size-color {\n  display: flex;\n  align-self: stretch;\n  justify-content: space-between;\n}\n\n.ag-charts-data-group-item {\n  position: relative;\n}\n\n.ag-charts-data-group-item:not(:last-child) {\n  margin-bottom: var(--ag-grid-size);\n}\n\n.ag-chart-menu {\n  border-radius: var(--ag-card-radius);\n  background: var(--ag-background-color);\n}\n\n.ag-chart-menu-icon {\n  opacity: 0.5;\n  margin: 2px 0;\n  cursor: pointer;\n  border-radius: var(--ag-card-radius);\n  color: var(--ag-secondary-foreground-color);\n}\n.ag-chart-menu-icon:hover {\n  opacity: 1;\n}\n\n.ag-chart-menu-toolbar-button {\n  border: 0;\n  background-color: transparent;\n  background-color: initial;\n  padding: 0 2px;\n  border-radius: 1px;\n}\n\n.ag-chart-mini-thumbnail {\n  border: 1px solid var(--ag-secondary-border-color);\n  border-radius: 5px;\n}\n.ag-chart-mini-thumbnail.ag-selected {\n  border-color: var(--ag-minichart-selected-chart-color);\n  border-width: 2px;\n}\n.ag-chart-mini-thumbnail:focus-visible {\n  outline: none;\n  border-color: var(--ag-minichart-selected-chart-color);\n  box-shadow: var(--ag-input-focus-box-shadow);\n}\n\n.ag-chart-settings-card-item {\n  background: var(--ag-foreground-color);\n  width: 8px;\n  height: 8px;\n  border-radius: 4px;\n}\n.ag-chart-settings-card-item.ag-selected {\n  background-color: var(--ag-minichart-selected-page-color);\n}\n\n.ag-chart-data-column-drag-handle {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-charts-settings-group-title-bar,\n.ag-charts-data-group-title-bar,\n.ag-charts-format-top-level-group-title-bar {\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n  position: relative;\n}\n\n.ag-charts-advanced-settings-top-level-group-title-bar {\n  position: relative;\n  background-color: transparent;\n  background-color: initial;\n}\n\n.ag-charts-data-group-title-bar:focus-visible {\n  outline: none;\n}\n.ag-charts-data-group-title-bar:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-charts-format-top-level-group-title-bar:focus-visible {\n  outline: none;\n}\n.ag-charts-format-top-level-group-title-bar:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: 4px;\n  left: 4px;\n  display: block;\n  width: calc(100% - 8px);\n  height: calc(100% - 8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-charts-data-group-title-bar .ag-charts-data-group-title,\n.ag-charts-format-top-level-group-title-bar .ag-charts-format-top-level-group-title {\n  cursor: pointer;\n}\n\n.ag-charts-data-group-container {\n  padding: calc(var(--ag-widget-container-vertical-padding) * 0.5) var(--ag-widget-container-horizontal-padding);\n}\n.ag-charts-data-group-container .ag-charts-data-group-item:not(.ag-charts-format-sub-level-group):not(.ag-pill-select):not(.ag-select) {\n  height: var(--ag-list-item-height);\n}\n.ag-charts-data-group-container .ag-charts-data-group-item.ag-picker-field {\n  margin-top: var(--ag-grid-size);\n}\n.ag-charts-data-group-container .ag-list-item-hovered::after {\n  content: "";\n  position: absolute;\n  left: 0;\n  right: 0;\n  height: 1px;\n}\n.ag-charts-data-group-container .ag-item-highlight-top::after {\n  top: 0;\n}\n.ag-charts-data-group-container .ag-item-highlight-bottom::after {\n  bottom: 0;\n}\n\n.ag-charts-format-top-level-group-container,\n.ag-charts-advanced-settings-top-level-group-container {\n  padding: var(--ag-grid-size);\n}\n.ag-ltr .ag-charts-format-top-level-group-container,\n.ag-ltr .ag-charts-advanced-settings-top-level-group-container {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-rtl .ag-charts-format-top-level-group-container,\n.ag-rtl .ag-charts-advanced-settings-top-level-group-container {\n  margin-right: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-charts-format-top-level-group-item,\n.ag-charts-advanced-settings-top-level-group-item {\n  margin: var(--ag-grid-size) 0;\n}\n\n.ag-charts-format-sub-level-group-container {\n  padding: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n  padding-bottom: calc(var(--ag-widget-container-vertical-padding) - var(--ag-widget-vertical-spacing));\n}\n.ag-charts-format-sub-level-group-container > * {\n  margin-bottom: var(--ag-widget-vertical-spacing);\n}\n\n.ag-charts-format-sub-level-no-header-group-container > * {\n  margin-bottom: var(--ag-widget-vertical-spacing);\n}\n\n.ag-charts-format-sub-level-group-container .ag-charts-format-sub-level-group-item.ag-font-panel-no-header {\n  margin: 0;\n}\n\n.ag-charts-settings-group-container {\n  padding: var(--ag-grid-size);\n  grid-row-gap: 8px;\n  row-gap: 8px;\n  display: grid;\n  grid-template-columns: 60px 1fr 60px 1fr 60px;\n}\n.ag-charts-settings-group-container .ag-chart-mini-thumbnail:nth-child(3n+1) {\n  grid-column: 1;\n}\n.ag-charts-settings-group-container .ag-chart-mini-thumbnail:nth-child(3n+2) {\n  grid-column: 3;\n}\n.ag-charts-settings-group-container .ag-chart-mini-thumbnail:nth-child(3n+3) {\n  grid-column: 5;\n}\n\n.ag-chart-menu-panel {\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-ltr .ag-chart-menu-panel {\n  border-left: solid 1px var(--ag-border-color);\n}\n.ag-rtl .ag-chart-menu-panel {\n  border-right: solid 1px var(--ag-border-color);\n}\n\n.ag-charts-theme-default {\n  --ag-charts-align: none !important;\n  --ag-charts-justify: none !important;\n}\n\n.ag-date-time-list-page-title-bar {\n  display: flex;\n}\n\n.ag-date-time-list-page-title {\n  flex-grow: 1;\n  text-align: center;\n}\n\n.ag-date-time-list-page-column-labels-row,\n.ag-date-time-list-page-entries-row {\n  display: flex;\n}\n\n.ag-date-time-list-page-column-label,\n.ag-date-time-list-page-entry {\n  flex-basis: 0;\n  flex-grow: 1;\n}\n\n.ag-date-time-list-page-entry {\n  cursor: pointer;\n  text-align: center;\n}\n\n.ag-date-time-list-page-column-label {\n  text-align: center;\n}\n\n.ag-advanced-filter-header {\n  position: relative;\n  display: flex;\n  align-items: center;\n  padding-left: var(--ag-cell-horizontal-padding);\n  padding-right: var(--ag-cell-horizontal-padding);\n}\n\n.ag-advanced-filter {\n  display: flex;\n  align-items: center;\n  width: 100%;\n}\n\n.ag-advanced-filter-apply-button,\n.ag-advanced-filter-builder-button {\n  line-height: normal;\n  white-space: nowrap;\n}\n.ag-ltr .ag-advanced-filter-apply-button,\n.ag-ltr .ag-advanced-filter-builder-button {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-rtl .ag-advanced-filter-apply-button,\n.ag-rtl .ag-advanced-filter-builder-button {\n  margin-right: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-advanced-filter-builder-button {\n  display: flex;\n  align-items: center;\n  border: 0;\n  background-color: transparent;\n  background-color: initial;\n  color: var(--ag-foreground-color);\n  font-size: var(--ag-font-size);\n  font-weight: 600;\n}\n.ag-advanced-filter-builder-button:hover:not(:disabled) {\n  background-color: var(--ag-row-hover-color);\n}\n.ag-advanced-filter-builder-button:not(:disabled) {\n  cursor: pointer;\n}\n\n.ag-advanced-filter-builder-button-label {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-advanced-filter-builder {\n  -moz-user-select: none;\n  -webkit-user-select: none;\n  user-select: none;\n  width: 100%;\n  background-color: var(--ag-control-panel-background-color);\n  display: flex;\n  flex-direction: column;\n}\n\n.ag-advanced-filter-builder-list {\n  flex: 1;\n  overflow: auto;\n}\n.ag-advanced-filter-builder-list .ag-list-item-hovered::after {\n  content: "";\n  position: absolute;\n  left: 0;\n  right: 0;\n  height: 1px;\n}\n.ag-advanced-filter-builder-list .ag-item-highlight-top::after {\n  top: 0;\n}\n.ag-advanced-filter-builder-list .ag-item-highlight-bottom::after {\n  bottom: 0;\n}\n\n.ag-advanced-filter-builder-button-panel {\n  display: flex;\n  justify-content: flex-end;\n  padding: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n\n.ag-advanced-filter-builder .ag-advanced-filter-builder-button-panel .ag-advanced-filter-builder-apply-button,\n.ag-advanced-filter-builder .ag-advanced-filter-builder-button-panel .ag-advanced-filter-builder-cancel-button {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n\n.ag-advanced-filter-builder-item-wrapper {\n  display: flex;\n  flex: 1 1 auto;\n  align-items: center;\n  justify-content: space-between;\n  overflow: hidden;\n  padding-left: calc(var(--ag-icon-size) / 2);\n  padding-right: var(--ag-icon-size);\n}\n\n.ag-virtual-list-viewport .ag-advanced-filter-builder-item-wrapper .ag-tab-guard {\n  position: absolute;\n}\n\n.ag-advanced-filter-builder-item-tree-lines > * {\n  width: var(--ag-advanced-filter-builder-indent-size);\n}\n\n.ag-advanced-filter-builder-item-tree-lines .ag-advanced-filter-builder-item-tree-line-root {\n  width: var(--ag-icon-size);\n}\n.ag-advanced-filter-builder-item-tree-lines .ag-advanced-filter-builder-item-tree-line-root::before {\n  top: 50%;\n  height: 50%;\n}\n\n.ag-advanced-filter-builder-item-tree-line-horizontal,\n.ag-advanced-filter-builder-item-tree-line-vertical,\n.ag-advanced-filter-builder-item-tree-line-vertical-top,\n.ag-advanced-filter-builder-item-tree-line-vertical-bottom {\n  position: relative;\n  height: 100%;\n  display: flex;\n  align-items: center;\n}\n.ag-advanced-filter-builder-item-tree-line-horizontal::before, .ag-advanced-filter-builder-item-tree-line-horizontal::after,\n.ag-advanced-filter-builder-item-tree-line-vertical::before,\n.ag-advanced-filter-builder-item-tree-line-vertical::after,\n.ag-advanced-filter-builder-item-tree-line-vertical-top::before,\n.ag-advanced-filter-builder-item-tree-line-vertical-top::after,\n.ag-advanced-filter-builder-item-tree-line-vertical-bottom::before,\n.ag-advanced-filter-builder-item-tree-line-vertical-bottom::after {\n  content: "";\n  position: absolute;\n  height: 100%;\n}\n\n.ag-advanced-filter-builder-item-tree-line-horizontal::after {\n  height: 50%;\n  width: calc(var(--ag-advanced-filter-builder-indent-size) - var(--ag-icon-size));\n  top: 0;\n  left: calc(var(--ag-icon-size) / 2);\n  border-bottom: 1px solid;\n  border-color: var(--ag-border-color);\n}\n\n.ag-advanced-filter-builder-item-tree-line-vertical::before {\n  width: calc(var(--ag-advanced-filter-builder-indent-size) - var(--ag-icon-size) / 2);\n  top: 0;\n  left: calc(var(--ag-icon-size) / 2);\n  border-left: 1px solid;\n  border-color: var(--ag-border-color);\n}\n\n.ag-advanced-filter-builder-item-tree-line-vertical-top::before {\n  height: 50%;\n  width: calc(var(--ag-advanced-filter-builder-indent-size) - var(--ag-icon-size) / 2);\n  top: 0;\n  left: calc(var(--ag-icon-size) / 2);\n  border-left: 1px solid;\n  border-color: var(--ag-border-color);\n}\n\n.ag-advanced-filter-builder-item-tree-line-vertical-bottom::before {\n  height: calc((100% - 1.5 * var(--ag-icon-size)) / 2);\n  width: calc(var(--ag-icon-size) / 2);\n  top: calc((100% + 1.5 * var(--ag-icon-size)) / 2);\n  left: calc(var(--ag-icon-size) / 2);\n  border-left: 1px solid;\n  border-color: var(--ag-border-color);\n}\n\n.ag-advanced-filter-builder-item-condition {\n  padding-top: var(--ag-grid-size);\n  padding-bottom: var(--ag-grid-size);\n}\n\n.ag-advanced-filter-builder-item,\n.ag-advanced-filter-builder-item-condition,\n.ag-advanced-filter-builder-pill-wrapper,\n.ag-advanced-filter-builder-pill,\n.ag-advanced-filter-builder-item-buttons,\n.ag-advanced-filter-builder-item-tree-lines {\n  display: flex;\n  align-items: center;\n  height: 100%;\n}\n\n.ag-advanced-filter-builder-pill-wrapper {\n  margin: 0px var(--ag-grid-size);\n}\n\n.ag-advanced-filter-builder-pill {\n  position: relative;\n  border-radius: var(--ag-border-radius);\n  padding: var(--ag-grid-size) calc(var(--ag-grid-size) * 2);\n  min-height: calc(100% - var(--ag-grid-size) * 3);\n  min-width: calc(var(--ag-grid-size) * 2);\n}\n.ag-advanced-filter-builder-pill .ag-picker-field-display {\n  margin-right: var(--ag-grid-size);\n}\n.ag-advanced-filter-builder-pill .ag-advanced-filter-builder-value-number {\n  font-family: monospace;\n  font-weight: 700;\n}\n.ag-advanced-filter-builder-pill .ag-advanced-filter-builder-value-empty {\n  color: var(--ag-disabled-foreground-color);\n}\n\n.ag-advanced-filter-builder-pill:focus-visible {\n  outline: none;\n}\n.ag-advanced-filter-builder-pill:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: -4px;\n  left: -4px;\n  display: block;\n  width: calc(100% - -8px);\n  height: calc(100% - -8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-advanced-filter-builder-item-button:focus-visible {\n  outline: none;\n}\n.ag-advanced-filter-builder-item-button:focus-visible::after {\n  content: "";\n  position: absolute;\n  background-color: transparent;\n  pointer-events: none;\n  top: -4px;\n  left: -4px;\n  display: block;\n  width: calc(100% - -8px);\n  height: calc(100% - -8px);\n  border: 1px solid;\n  border-color: var(--ag-input-focus-border-color);\n}\n\n.ag-advanced-filter-builder-pill-display {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n  font-weight: 500;\n}\n\n.ag-advanced-filter-builder-join-pill {\n  color: var(--ag-foreground-color);\n  background-color: var(--ag-advanced-filter-join-pill-color);\n  cursor: pointer;\n}\n\n.ag-advanced-filter-builder-column-pill {\n  color: var(--ag-foreground-color);\n  background-color: var(--ag-advanced-filter-column-pill-color);\n  cursor: pointer;\n}\n\n.ag-advanced-filter-builder-option-pill {\n  color: var(--ag-foreground-color);\n  background-color: var(--ag-advanced-filter-option-pill-color);\n  cursor: pointer;\n}\n\n.ag-advanced-filter-builder-value-pill {\n  color: var(--ag-foreground-color);\n  background-color: var(--ag-advanced-filter-value-pill-color);\n  cursor: text;\n  max-width: 140px;\n}\n.ag-advanced-filter-builder-value-pill .ag-advanced-filter-builder-pill-display {\n  display: block;\n}\n\n.ag-advanced-filter-builder-item-buttons > * {\n  margin: 0 calc(var(--ag-grid-size) * 0.5);\n}\n\n.ag-advanced-filter-builder-item-button {\n  position: relative;\n  cursor: pointer;\n  color: var(--ag-secondary-foreground-color);\n  opacity: 0.5;\n}\n\n.ag-advanced-filter-builder-item-button-disabled {\n  color: var(--ag-disabled-foreground-color);\n  cursor: default;\n}\n\n.ag-advanced-filter-builder-virtual-list-container {\n  top: var(--ag-grid-size);\n}\n\n.ag-advanced-filter-builder-virtual-list-item {\n  display: flex;\n  cursor: default;\n  height: var(--ag-list-item-height);\n}\n.ag-advanced-filter-builder-virtual-list-item:hover {\n  background-color: var(--ag-row-hover-color);\n}\n.ag-advanced-filter-builder-virtual-list-item:hover .ag-advanced-filter-builder-item-button {\n  opacity: 1;\n}\n\n.ag-advanced-filter-builder-virtual-list-item-highlight .ag-advanced-filter-builder-item-button:focus-visible,\n.ag-advanced-filter-builder-validation .ag-advanced-filter-builder-invalid {\n  opacity: 1;\n}\n\n.ag-advanced-filter-builder-invalid {\n  margin: 0 var(--ag-grid-size);\n  color: var(--ag-invalid-color);\n  cursor: default;\n}\n\n.ag-input-field-input {\n  width: 100%;\n  min-width: 0;\n}\n\n.ag-checkbox-input-wrapper {\n  font-family: var(--ag-icon-font-family);\n  font-weight: var(--ag-icon-font-weight);\n  color: var(--ag-icon-font-color);\n  font-size: var(--ag-icon-size);\n  line-height: var(--ag-icon-size);\n  font-style: normal;\n  font-feature-settings: normal;\n  font-variant: normal;\n  text-transform: none;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  width: var(--ag-icon-size);\n  height: var(--ag-icon-size);\n  background-color: var(--ag-checkbox-background-color);\n  border-radius: var(--ag-checkbox-border-radius);\n  display: inline-block;\n  vertical-align: middle;\n  flex: none;\n}\n.ag-checkbox-input-wrapper input,\n.ag-checkbox-input-wrapper input {\n  -webkit-appearance: none;\n  opacity: 0;\n  width: 100%;\n  height: 100%;\n}\n.ag-checkbox-input-wrapper:focus-within, .ag-checkbox-input-wrapper:active {\n  outline: none;\n  box-shadow: var(--ag-input-focus-box-shadow);\n}\n.ag-checkbox-input-wrapper.ag-disabled {\n  opacity: 0.5;\n}\n.ag-checkbox-input-wrapper::after {\n  content: "\\f108";\n  content: var(--ag-icon-font-code-checkbox-unchecked, "\\f108");\n  font-family: inherit;\n  color: var(--ag-checkbox-unchecked-color);\n  display: var(--ag-icon-font-display-checkbox-unchecked, var(--ag-icon-font-display));\n  position: absolute;\n  top: 0;\n  left: 0;\n  pointer-events: none;\n}\n.ag-checkbox-input-wrapper.ag-checked::after {\n  content: "\\f106";\n  content: var(--ag-icon-font-code-checkbox-checked, "\\f106");\n  color: var(--ag-checkbox-checked-color);\n  display: var(--ag-icon-font-display-checkbox-checked, var(--ag-icon-font-display));\n  position: absolute;\n  top: 0;\n  left: 0;\n  pointer-events: none;\n}\n.ag-checkbox-input-wrapper.ag-indeterminate::after {\n  content: "\\f107";\n  content: var(--ag-icon-font-code-checkbox-indeterminate, "\\f107");\n  color: var(--ag-checkbox-indeterminate-color);\n  display: var(--ag-icon-font-display-checkbox-indeterminate, var(--ag-icon-font-display));\n  position: absolute;\n  top: 0;\n  left: 0;\n  pointer-events: none;\n}\n.ag-checkbox-input-wrapper::before {\n  content: "";\n  background: transparent center/contain no-repeat;\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  background-image: var(--ag-icon-image-checkbox-unchecked, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-checkbox-unchecked, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-checkbox-unchecked, var(--ag-icon-image-opacity, 0.9));\n}\n.ag-checkbox-input-wrapper.ag-checked::before {\n  background-image: var(--ag-icon-image-checkbox-checked, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-checkbox-checked, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-checkbox-checked, var(--ag-icon-image-opacity, 0.9));\n}\n.ag-checkbox-input-wrapper.ag-indeterminate::before {\n  background-image: var(--ag-icon-image-checkbox-indeterminate, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-checkbox-indeterminate, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-checkbox-indeterminate, var(--ag-icon-image-opacity, 0.9));\n}\n\n.ag-toggle-button-input-wrapper {\n  box-sizing: border-box;\n  width: var(--ag-toggle-button-width);\n  min-width: var(--ag-toggle-button-width);\n  max-width: var(--ag-toggle-button-width);\n  height: var(--ag-toggle-button-height);\n  background-color: var(--ag-toggle-button-off-background-color);\n  border-radius: calc(var(--ag-toggle-button-height) * 0.5);\n  position: relative;\n  flex: none;\n  border: var(--ag-toggle-button-border-width) solid;\n  border-color: var(--ag-toggle-button-off-border-color);\n}\n.ag-toggle-button-input-wrapper input {\n  opacity: 0;\n  height: 100%;\n  width: 100%;\n}\n.ag-toggle-button-input-wrapper:focus-within {\n  outline: none;\n  box-shadow: var(--ag-input-focus-box-shadow);\n}\n.ag-toggle-button-input-wrapper.ag-disabled {\n  opacity: 0.5;\n}\n.ag-toggle-button-input-wrapper.ag-checked {\n  background-color: var(--ag-toggle-button-on-background-color);\n  border-color: var(--ag-toggle-button-on-border-color);\n}\n.ag-toggle-button-input-wrapper::before {\n  content: " ";\n  position: absolute;\n  top: calc(0px - var(--ag-toggle-button-border-width));\n  left: calc(0px - var(--ag-toggle-button-border-width));\n  display: block;\n  box-sizing: border-box;\n  height: var(--ag-toggle-button-height);\n  width: var(--ag-toggle-button-height);\n  background-color: var(--ag-toggle-button-switch-background-color);\n  border-radius: 100%;\n  transition: left 100ms;\n  border: var(--ag-toggle-button-border-width) solid;\n  border-color: var(--ag-toggle-button-switch-border-color);\n}\n.ag-toggle-button-input-wrapper.ag-checked::before {\n  left: calc(100% - var(--ag-toggle-button-height) + var(--ag-toggle-button-border-width));\n  border-color: var(--ag-toggle-button-on-border-color);\n}\n\n.ag-radio-button-input-wrapper {\n  font-family: var(--ag-icon-font-family);\n  font-weight: var(--ag-icon-font-weight);\n  color: var(--ag-icon-font-color);\n  font-size: var(--ag-icon-size);\n  line-height: var(--ag-icon-size);\n  font-style: normal;\n  font-feature-settings: normal;\n  font-variant: normal;\n  text-transform: none;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n  width: var(--ag-icon-size);\n  height: var(--ag-icon-size);\n  background-color: var(--ag-checkbox-background-color);\n  border-radius: var(--ag-checkbox-border-radius);\n  display: inline-block;\n  vertical-align: middle;\n  flex: none;\n  border-radius: var(--ag-icon-size);\n}\n.ag-radio-button-input-wrapper input,\n.ag-radio-button-input-wrapper input {\n  -webkit-appearance: none;\n  opacity: 0;\n  width: 100%;\n  height: 100%;\n}\n.ag-radio-button-input-wrapper:focus-within, .ag-radio-button-input-wrapper:active {\n  outline: none;\n  box-shadow: var(--ag-input-focus-box-shadow);\n}\n.ag-radio-button-input-wrapper.ag-disabled {\n  opacity: 0.5;\n}\n.ag-radio-button-input-wrapper::after {\n  content: "\\f127";\n  content: var(--ag-icon-font-code-radio-button-off, "\\f127");\n  color: var(--ag-checkbox-unchecked-color);\n  display: var(--ag-icon-font-display-radio-button-off, var(--ag-icon-font-display));\n  position: absolute;\n  top: 0;\n  left: 0;\n  pointer-events: none;\n}\n.ag-radio-button-input-wrapper.ag-checked::after {\n  content: "\\f128";\n  content: var(--ag-icon-font-code-radio-button-on, "\\f128");\n  color: var(--ag-checkbox-checked-color);\n  display: var(--ag-icon-font-display-radio-button-on, var(--ag-icon-font-display));\n  position: absolute;\n  top: 0;\n  left: 0;\n  pointer-events: none;\n}\n.ag-radio-button-input-wrapper::before {\n  content: "";\n  background: transparent center/contain no-repeat;\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n  background-image: var(--ag-icon-image-radio-button-off, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-radio-button-off, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-radio-button-off, var(--ag-icon-image-opacity, 0.9));\n}\n.ag-radio-button-input-wrapper.ag-checked::before {\n  background-image: var(--ag-icon-image-radio-button-on, var(--ag-icon-image));\n  display: var(--ag-icon-image-display-radio-button-on, var(--ag-icon-image-display));\n  opacity: 0.9;\n  opacity: var(--ag-icon-image-opacity-radio-button-on, var(--ag-icon-image-opacity, 0.9));\n}\n\ninput[class^=ag-][type=range] {\n  -webkit-appearance: none;\n  width: 100%;\n  height: 100%;\n  background: none;\n  overflow: visible;\n}\ninput[class^=ag-][type=range]::-webkit-slider-runnable-track {\n  margin: 0;\n  padding: 0;\n  width: 100%;\n  height: 3px;\n  background-color: var(--ag-border-color);\n  border-radius: var(--ag-border-radius);\n  border-radius: var(--ag-checkbox-border-radius);\n}\ninput[class^=ag-][type=range]::-moz-range-track {\n  margin: 0;\n  padding: 0;\n  width: 100%;\n  height: 3px;\n  background-color: var(--ag-border-color);\n  border-radius: var(--ag-border-radius);\n  border-radius: var(--ag-checkbox-border-radius);\n}\ninput[class^=ag-][type=range]::-ms-track {\n  margin: 0;\n  padding: 0;\n  width: 100%;\n  height: 3px;\n  background-color: var(--ag-border-color);\n  border-radius: var(--ag-border-radius);\n  border-radius: var(--ag-checkbox-border-radius);\n  color: transparent;\n  width: calc(100% - 2px);\n}\ninput[class^=ag-][type=range]::-webkit-slider-thumb {\n  margin: 0;\n  padding: 0;\n  -webkit-appearance: none;\n  width: var(--ag-icon-size);\n  height: var(--ag-icon-size);\n  background-color: var(--ag-background-color);\n  border: 1px solid;\n  border-color: var(--ag-checkbox-unchecked-color);\n  border-radius: var(--ag-icon-size);\n  transform: translateY(calc(var(--ag-icon-size) * -0.5 + 1.5px));\n}\ninput[class^=ag-][type=range]::-ms-thumb {\n  margin: 0;\n  padding: 0;\n  -webkit-appearance: none;\n  width: var(--ag-icon-size);\n  height: var(--ag-icon-size);\n  background-color: var(--ag-background-color);\n  border: 1px solid;\n  border-color: var(--ag-checkbox-unchecked-color);\n  border-radius: var(--ag-icon-size);\n}\ninput[class^=ag-][type=range]::-moz-ag-range-thumb {\n  margin: 0;\n  padding: 0;\n  -webkit-appearance: none;\n  width: var(--ag-icon-size);\n  height: var(--ag-icon-size);\n  background-color: var(--ag-background-color);\n  border: 1px solid;\n  border-color: var(--ag-checkbox-unchecked-color);\n  border-radius: var(--ag-icon-size);\n}\ninput[class^=ag-][type=range]:focus {\n  outline: none;\n}\ninput[class^=ag-][type=range]:focus::-webkit-slider-thumb {\n  box-shadow: var(--ag-input-focus-box-shadow);\n  border-color: var(--ag-checkbox-checked-color);\n}\ninput[class^=ag-][type=range]:focus::-ms-thumb {\n  box-shadow: var(--ag-input-focus-box-shadow);\n  border-color: var(--ag-checkbox-checked-color);\n}\ninput[class^=ag-][type=range]:focus::-moz-ag-range-thumb {\n  box-shadow: var(--ag-input-focus-box-shadow);\n  border-color: var(--ag-checkbox-checked-color);\n}\ninput[class^=ag-][type=range]:active::-webkit-slider-runnable-track {\n  background-color: var(--ag-input-focus-border-color);\n}\ninput[class^=ag-][type=range]:active::-moz-ag-range-track {\n  background-color: var(--ag-input-focus-border-color);\n}\ninput[class^=ag-][type=range]:active::-ms-track {\n  background-color: var(--ag-input-focus-border-color);\n}\ninput[class^=ag-][type=range]:disabled {\n  opacity: 0.5;\n}\n', ""]), t2.A = g;
          }, 8483: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r)()(o());
            i.push([e2.id, '.ag-theme-alpine,\n.ag-theme-alpine-dark,\n.ag-theme-alpine-auto-dark {\n  --ag-alpine-active-color: #2196f3;\n  --ag-selected-row-background-color: rgba(33, 150, 243, 0.3);\n  --ag-row-hover-color: rgba(33, 150, 243, 0.1);\n  --ag-column-hover-color: rgba(33, 150, 243, 0.1);\n  --ag-input-focus-border-color: rgba(33, 150, 243, 0.4);\n  --ag-range-selection-background-color: rgba(33, 150, 243, 0.2);\n  --ag-range-selection-background-color-2: rgba(33, 150, 243, 0.36);\n  --ag-range-selection-background-color-3: rgba(33, 150, 243, 0.49);\n  --ag-range-selection-background-color-4: rgba(33, 150, 243, 0.59);\n  --ag-background-color: #fff;\n  --ag-foreground-color: #181d1f;\n  --ag-border-color: #babfc7;\n  --ag-secondary-border-color: #dde2eb;\n  --ag-header-background-color: #f8f8f8;\n  --ag-tooltip-background-color: #f8f8f8;\n  --ag-odd-row-background-color: #fcfcfc;\n  --ag-control-panel-background-color: #f8f8f8;\n  --ag-subheader-background-color: #fff;\n  --ag-invalid-color: #e02525;\n  --ag-checkbox-unchecked-color: #999;\n  --ag-advanced-filter-join-pill-color: #f08e8d;\n  --ag-advanced-filter-column-pill-color: #a6e194;\n  --ag-advanced-filter-option-pill-color: #f3c08b;\n  --ag-advanced-filter-value-pill-color: #85c0e4;\n  --ag-checkbox-background-color: var(--ag-background-color);\n  --ag-checkbox-checked-color: var(--ag-alpine-active-color);\n  --ag-range-selection-border-color: var(--ag-alpine-active-color);\n  --ag-secondary-foreground-color: var(--ag-foreground-color);\n  --ag-input-border-color: var(--ag-border-color);\n  --ag-input-border-color-invalid: var(--ag-invalid-color);\n  --ag-input-focus-box-shadow: 0 0 2px 0.1rem var(--ag-input-focus-border-color);\n  --ag-panel-background-color: var(--ag-header-background-color);\n  --ag-menu-background-color: var(--ag-header-background-color);\n  --ag-disabled-foreground-color: rgba(24, 29, 31, 0.5);\n  --ag-chip-background-color: rgba(24, 29, 31, 0.07);\n  --ag-input-disabled-border-color: rgba(186, 191, 199, 0.3);\n  --ag-input-disabled-background-color: rgba(186, 191, 199, 0.15);\n  --ag-borders: solid 1px;\n  --ag-border-radius: 3px;\n  --ag-borders-side-button: none;\n  --ag-side-button-selected-background-color: transparent;\n  --ag-header-column-resize-handle-display: block;\n  --ag-header-column-resize-handle-width: 2px;\n  --ag-header-column-resize-handle-height: 30%;\n  --ag-grid-size: 6px;\n  --ag-icon-size: 16px;\n  --ag-row-height: calc(var(--ag-grid-size) * 7);\n  --ag-header-height: calc(var(--ag-grid-size) * 8);\n  --ag-list-item-height: calc(var(--ag-grid-size) * 4);\n  --ag-column-select-indent-size: var(--ag-icon-size);\n  --ag-set-filter-indent-size: var(--ag-icon-size);\n  --ag-advanced-filter-builder-indent-size: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  --ag-cell-horizontal-padding: calc(var(--ag-grid-size) * 3);\n  --ag-cell-widget-spacing: calc(var(--ag-grid-size) * 2);\n  --ag-widget-container-vertical-padding: calc(var(--ag-grid-size) * 2);\n  --ag-widget-container-horizontal-padding: calc(var(--ag-grid-size) * 2);\n  --ag-widget-vertical-spacing: calc(var(--ag-grid-size) * 1.5);\n  --ag-toggle-button-height: 18px;\n  --ag-toggle-button-width: 28px;\n  --ag-font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell,\n      "Helvetica Neue", sans-serif;\n  --ag-font-size: 13px;\n  --ag-icon-font-family: agGridAlpine;\n  --ag-selected-tab-underline-color: var(--ag-alpine-active-color);\n  --ag-selected-tab-underline-width: 2px;\n  --ag-selected-tab-underline-transition-speed: 0.3s;\n  --ag-tab-min-width: 240px;\n  --ag-card-shadow: 0 1px 4px 1px rgba(186, 191, 199, 0.4);\n  --ag-popup-shadow: var(--ag-card-shadow);\n  --ag-side-bar-panel-width: 250px;\n}\n\n.ag-theme-alpine-dark {\n  --ag-background-color: #181d1f;\n  --ag-foreground-color: #fff;\n  --ag-border-color: #68686e;\n  --ag-secondary-border-color: rgba(88, 86, 82, 0.5);\n  --ag-modal-overlay-background-color: rgba(24, 29, 31, 0.66);\n  --ag-header-background-color: #222628;\n  --ag-tooltip-background-color: #222628;\n  --ag-odd-row-background-color: #222628;\n  --ag-control-panel-background-color: #222628;\n  --ag-subheader-background-color: #000;\n  --ag-input-disabled-background-color: #282c2f;\n  --ag-input-focus-box-shadow: 0 0 2px 0.5px rgba(255, 255, 255, 0.5), 0 0 4px 3px var(--ag-input-focus-border-color);\n  --ag-card-shadow: 0 1px 20px 1px black;\n  --ag-disabled-foreground-color: rgba(255, 255, 255, 0.5);\n  --ag-chip-background-color: rgba(255, 255, 255, 0.07);\n  --ag-input-disabled-border-color: rgba(104, 104, 110, 0.3);\n  --ag-input-disabled-background-color: rgba(104, 104, 110, 0.07);\n  --ag-advanced-filter-join-pill-color: #7a3a37;\n  --ag-advanced-filter-column-pill-color: #355f2d;\n  --ag-advanced-filter-option-pill-color: #5a3168;\n  --ag-advanced-filter-value-pill-color: #374c86;\n  --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n  --csstools-color-scheme--dark: initial;\n  color-scheme: dark;\n}\n\n@media (prefers-color-scheme: dark) {\n  .ag-theme-alpine-auto-dark {\n    --ag-background-color: #181d1f;\n    --ag-foreground-color: #fff;\n    --ag-border-color: #68686e;\n    --ag-secondary-border-color: rgba(88, 86, 82, 0.5);\n    --ag-modal-overlay-background-color: rgba(24, 29, 31, 0.66);\n    --ag-header-background-color: #222628;\n    --ag-tooltip-background-color: #222628;\n    --ag-odd-row-background-color: #222628;\n    --ag-control-panel-background-color: #222628;\n    --ag-subheader-background-color: #000;\n    --ag-input-disabled-background-color: #282c2f;\n    --ag-input-focus-box-shadow: 0 0 2px 0.5px rgba(255, 255, 255, 0.5), 0 0 4px 3px var(--ag-input-focus-border-color);\n    --ag-card-shadow: 0 1px 20px 1px black;\n    --ag-disabled-foreground-color: rgba(255, 255, 255, 0.5);\n    --ag-chip-background-color: rgba(255, 255, 255, 0.07);\n    --ag-input-disabled-border-color: rgba(104, 104, 110, 0.3);\n    --ag-input-disabled-background-color: rgba(104, 104, 110, 0.07);\n    --ag-advanced-filter-join-pill-color: #7a3a37;\n    --ag-advanced-filter-column-pill-color: #355f2d;\n    --ag-advanced-filter-option-pill-color: #5a3168;\n    --ag-advanced-filter-value-pill-color: #374c86;\n    --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n    --csstools-color-scheme--dark: initial;\n    color-scheme: dark;\n  }\n}\n.ag-theme-alpine .ag-filter-toolpanel-header,\n.ag-theme-alpine .ag-filter-toolpanel-search,\n.ag-theme-alpine .ag-status-bar,\n.ag-theme-alpine .ag-header-row,\n.ag-theme-alpine .ag-panel-title-bar-title,\n.ag-theme-alpine .ag-multi-filter-group-title-bar,\n.ag-theme-alpine-dark .ag-filter-toolpanel-header,\n.ag-theme-alpine-dark .ag-filter-toolpanel-search,\n.ag-theme-alpine-dark .ag-status-bar,\n.ag-theme-alpine-dark .ag-header-row,\n.ag-theme-alpine-dark .ag-panel-title-bar-title,\n.ag-theme-alpine-dark .ag-multi-filter-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-filter-toolpanel-header,\n.ag-theme-alpine-auto-dark .ag-filter-toolpanel-search,\n.ag-theme-alpine-auto-dark .ag-status-bar,\n.ag-theme-alpine-auto-dark .ag-header-row,\n.ag-theme-alpine-auto-dark .ag-panel-title-bar-title,\n.ag-theme-alpine-auto-dark .ag-multi-filter-group-title-bar {\n  font-weight: 700;\n  color: var(--ag-header-foreground-color);\n}\n.ag-theme-alpine .ag-row,\n.ag-theme-alpine-dark .ag-row,\n.ag-theme-alpine-auto-dark .ag-row {\n  font-size: calc(var(--ag-font-size) + 1px);\n}\n.ag-theme-alpine input[class^=ag-]:not([type]),\n.ag-theme-alpine input[class^=ag-][type=text],\n.ag-theme-alpine input[class^=ag-][type=number],\n.ag-theme-alpine input[class^=ag-][type=tel],\n.ag-theme-alpine input[class^=ag-][type=date],\n.ag-theme-alpine input[class^=ag-][type=datetime-local],\n.ag-theme-alpine textarea[class^=ag-],\n.ag-theme-alpine-dark input[class^=ag-]:not([type]),\n.ag-theme-alpine-dark input[class^=ag-][type=text],\n.ag-theme-alpine-dark input[class^=ag-][type=number],\n.ag-theme-alpine-dark input[class^=ag-][type=tel],\n.ag-theme-alpine-dark input[class^=ag-][type=date],\n.ag-theme-alpine-dark input[class^=ag-][type=datetime-local],\n.ag-theme-alpine-dark textarea[class^=ag-],\n.ag-theme-alpine-auto-dark input[class^=ag-]:not([type]),\n.ag-theme-alpine-auto-dark input[class^=ag-][type=text],\n.ag-theme-alpine-auto-dark input[class^=ag-][type=number],\n.ag-theme-alpine-auto-dark input[class^=ag-][type=tel],\n.ag-theme-alpine-auto-dark input[class^=ag-][type=date],\n.ag-theme-alpine-auto-dark input[class^=ag-][type=datetime-local],\n.ag-theme-alpine-auto-dark textarea[class^=ag-] {\n  min-height: calc(var(--ag-grid-size) * 4);\n  border-radius: var(--ag-border-radius);\n}\n.ag-theme-alpine .ag-ltr input[class^=ag-]:not([type]), .ag-theme-alpine .ag-ltr input[class^=ag-][type=text], .ag-theme-alpine .ag-ltr input[class^=ag-][type=number], .ag-theme-alpine .ag-ltr input[class^=ag-][type=tel], .ag-theme-alpine .ag-ltr input[class^=ag-][type=date], .ag-theme-alpine .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-alpine .ag-ltr textarea[class^=ag-], .ag-theme-alpine-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-alpine-dark .ag-ltr textarea[class^=ag-], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-alpine-auto-dark .ag-ltr textarea[class^=ag-] {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-rtl input[class^=ag-]:not([type]), .ag-theme-alpine .ag-rtl input[class^=ag-][type=text], .ag-theme-alpine .ag-rtl input[class^=ag-][type=number], .ag-theme-alpine .ag-rtl input[class^=ag-][type=tel], .ag-theme-alpine .ag-rtl input[class^=ag-][type=date], .ag-theme-alpine .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-alpine .ag-rtl textarea[class^=ag-], .ag-theme-alpine-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-alpine-dark .ag-rtl textarea[class^=ag-], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-alpine-auto-dark .ag-rtl textarea[class^=ag-] {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-tab,\n.ag-theme-alpine-dark .ag-tab,\n.ag-theme-alpine-auto-dark .ag-tab {\n  padding: calc(var(--ag-grid-size) * 1.5);\n  transition: color 0.4s;\n  flex: 1 1 auto;\n}\n.ag-theme-alpine .ag-tab-selected,\n.ag-theme-alpine-dark .ag-tab-selected,\n.ag-theme-alpine-auto-dark .ag-tab-selected {\n  color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-menu,\n.ag-theme-alpine-dark .ag-menu,\n.ag-theme-alpine-auto-dark .ag-menu {\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-alpine .ag-panel-content-wrapper .ag-column-select,\n.ag-theme-alpine-dark .ag-panel-content-wrapper .ag-column-select,\n.ag-theme-alpine-auto-dark .ag-panel-content-wrapper .ag-column-select {\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-alpine .ag-menu-header,\n.ag-theme-alpine-dark .ag-menu-header,\n.ag-theme-alpine-auto-dark .ag-menu-header {\n  background-color: var(--ag-control-panel-background-color);\n  padding-top: 1px;\n}\n.ag-theme-alpine .ag-tabs-header,\n.ag-theme-alpine-dark .ag-tabs-header,\n.ag-theme-alpine-auto-dark .ag-tabs-header {\n  border-bottom: var(--ag-borders) var(--ag-border-color);\n}\n.ag-theme-alpine .ag-charts-settings-group-title-bar,\n.ag-theme-alpine .ag-charts-data-group-title-bar,\n.ag-theme-alpine .ag-charts-format-top-level-group-title-bar,\n.ag-theme-alpine .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-settings-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-data-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-settings-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-data-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-advanced-settings-top-level-group-title-bar {\n  padding: var(--ag-grid-size) calc(var(--ag-grid-size) * 2);\n  line-height: calc(var(--ag-icon-size) + var(--ag-grid-size) - 2px);\n}\n.ag-theme-alpine .ag-chart-mini-thumbnail,\n.ag-theme-alpine-dark .ag-chart-mini-thumbnail,\n.ag-theme-alpine-auto-dark .ag-chart-mini-thumbnail {\n  background-color: var(--ag-background-color);\n}\n.ag-theme-alpine .ag-chart-settings-nav-bar,\n.ag-theme-alpine-dark .ag-chart-settings-nav-bar,\n.ag-theme-alpine-auto-dark .ag-chart-settings-nav-bar {\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n.ag-theme-alpine .ag-ltr .ag-group-title-bar-icon, .ag-theme-alpine-dark .ag-ltr .ag-group-title-bar-icon, .ag-theme-alpine-auto-dark .ag-ltr .ag-group-title-bar-icon {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-rtl .ag-group-title-bar-icon, .ag-theme-alpine-dark .ag-rtl .ag-group-title-bar-icon, .ag-theme-alpine-auto-dark .ag-rtl .ag-group-title-bar-icon {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-charts-format-top-level-group-toolbar,\n.ag-theme-alpine .ag-charts-advanced-settings-top-level-group-toolbar,\n.ag-theme-alpine-dark .ag-charts-format-top-level-group-toolbar,\n.ag-theme-alpine-dark .ag-charts-advanced-settings-top-level-group-toolbar,\n.ag-theme-alpine-auto-dark .ag-charts-format-top-level-group-toolbar,\n.ag-theme-alpine-auto-dark .ag-charts-advanced-settings-top-level-group-toolbar {\n  margin-top: var(--ag-grid-size);\n}\n.ag-theme-alpine .ag-ltr .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine .ag-ltr .ag-charts-advanced-settings-top-level-group-toolbar, .ag-theme-alpine-dark .ag-ltr .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine-dark .ag-ltr .ag-charts-advanced-settings-top-level-group-toolbar, .ag-theme-alpine-auto-dark .ag-ltr .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine-auto-dark .ag-ltr .ag-charts-advanced-settings-top-level-group-toolbar {\n  padding-left: calc(var(--ag-icon-size) * 0.5 + var(--ag-grid-size) * 2);\n}\n\n.ag-theme-alpine .ag-rtl .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine .ag-rtl .ag-charts-advanced-settings-top-level-group-toolbar, .ag-theme-alpine-dark .ag-rtl .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine-dark .ag-rtl .ag-charts-advanced-settings-top-level-group-toolbar, .ag-theme-alpine-auto-dark .ag-rtl .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine-auto-dark .ag-rtl .ag-charts-advanced-settings-top-level-group-toolbar {\n  padding-right: calc(var(--ag-icon-size) * 0.5 + var(--ag-grid-size) * 2);\n}\n\n.ag-theme-alpine .ag-charts-format-sub-level-group,\n.ag-theme-alpine-dark .ag-charts-format-sub-level-group,\n.ag-theme-alpine-auto-dark .ag-charts-format-sub-level-group {\n  border-left: dashed 1px;\n  border-left-color: var(--ag-border-color);\n  padding-left: var(--ag-grid-size);\n  margin-bottom: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-alpine .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-format-sub-level-group-title-bar {\n  padding-top: 0;\n  padding-bottom: 0;\n  background: none;\n  font-weight: 700;\n}\n.ag-theme-alpine .ag-charts-format-sub-level-group-container,\n.ag-theme-alpine-dark .ag-charts-format-sub-level-group-container,\n.ag-theme-alpine-auto-dark .ag-charts-format-sub-level-group-container {\n  padding-bottom: 0;\n}\n.ag-theme-alpine .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-alpine-dark .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-alpine-auto-dark .ag-charts-format-sub-level-group-item:last-child {\n  margin-bottom: 0;\n}\n.ag-theme-alpine.ag-dnd-ghost,\n.ag-theme-alpine-dark.ag-dnd-ghost,\n.ag-theme-alpine-auto-dark.ag-dnd-ghost {\n  font-size: calc(var(--ag-font-size) - 1px);\n  font-weight: 700;\n}\n.ag-theme-alpine .ag-side-buttons,\n.ag-theme-alpine-dark .ag-side-buttons,\n.ag-theme-alpine-auto-dark .ag-side-buttons {\n  width: calc(var(--ag-grid-size) * 5);\n}\n.ag-theme-alpine .ag-standard-button,\n.ag-theme-alpine-dark .ag-standard-button,\n.ag-theme-alpine-auto-dark .ag-standard-button {\n  font-family: inherit;\n  -moz-appearance: none;\n       appearance: none;\n  -webkit-appearance: none;\n  border-radius: var(--ag-border-radius);\n  border: 1px solid;\n  border-color: var(--ag-alpine-active-color);\n  color: var(--ag-alpine-active-color);\n  background-color: var(--ag-background-color);\n  font-weight: 600;\n  padding: var(--ag-grid-size) calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-alpine .ag-standard-button:hover,\n.ag-theme-alpine-dark .ag-standard-button:hover,\n.ag-theme-alpine-auto-dark .ag-standard-button:hover {\n  border-color: var(--ag-alpine-active-color);\n  background-color: var(--ag-row-hover-color);\n}\n.ag-theme-alpine .ag-standard-button:active,\n.ag-theme-alpine-dark .ag-standard-button:active,\n.ag-theme-alpine-auto-dark .ag-standard-button:active {\n  border-color: var(--ag-alpine-active-color);\n  background-color: var(--ag-alpine-active-color);\n  color: var(--ag-background-color);\n}\n.ag-theme-alpine .ag-standard-button:disabled,\n.ag-theme-alpine-dark .ag-standard-button:disabled,\n.ag-theme-alpine-auto-dark .ag-standard-button:disabled {\n  color: var(--ag-disabled-foreground-color);\n  background-color: var(--ag-input-disabled-background-color);\n  border-color: var(--ag-input-disabled-border-color);\n}\n.ag-theme-alpine .ag-column-drop-vertical,\n.ag-theme-alpine-dark .ag-column-drop-vertical,\n.ag-theme-alpine-auto-dark .ag-column-drop-vertical {\n  min-height: 75px;\n}\n.ag-theme-alpine .ag-column-drop-vertical-title-bar,\n.ag-theme-alpine-dark .ag-column-drop-vertical-title-bar,\n.ag-theme-alpine-auto-dark .ag-column-drop-vertical-title-bar {\n  padding: calc(var(--ag-grid-size) * 2);\n  padding-bottom: 0px;\n}\n.ag-theme-alpine .ag-column-drop-vertical-empty-message,\n.ag-theme-alpine-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-alpine-auto-dark .ag-column-drop-vertical-empty-message {\n  display: flex;\n  align-items: center;\n  border: dashed 1px;\n  border-color: var(--ag-border-color);\n  margin: calc(var(--ag-grid-size) * 2);\n  padding: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-alpine .ag-column-drop-empty-message,\n.ag-theme-alpine-dark .ag-column-drop-empty-message,\n.ag-theme-alpine-auto-dark .ag-column-drop-empty-message {\n  color: var(--ag-foreground-color);\n  opacity: 0.75;\n}\n.ag-theme-alpine .ag-pill-select .ag-column-drop,\n.ag-theme-alpine-dark .ag-pill-select .ag-column-drop,\n.ag-theme-alpine-auto-dark .ag-pill-select .ag-column-drop {\n  min-height: 0;\n  min-height: initial;\n}\n.ag-theme-alpine .ag-status-bar,\n.ag-theme-alpine-dark .ag-status-bar,\n.ag-theme-alpine-auto-dark .ag-status-bar {\n  font-weight: normal;\n}\n.ag-theme-alpine .ag-status-name-value-value,\n.ag-theme-alpine-dark .ag-status-name-value-value,\n.ag-theme-alpine-auto-dark .ag-status-name-value-value {\n  font-weight: 700;\n}\n.ag-theme-alpine .ag-paging-number,\n.ag-theme-alpine .ag-paging-row-summary-panel-number,\n.ag-theme-alpine-dark .ag-paging-number,\n.ag-theme-alpine-dark .ag-paging-row-summary-panel-number,\n.ag-theme-alpine-auto-dark .ag-paging-number,\n.ag-theme-alpine-auto-dark .ag-paging-row-summary-panel-number {\n  font-weight: 700;\n}\n.ag-theme-alpine .ag-column-drop-cell-button,\n.ag-theme-alpine-dark .ag-column-drop-cell-button,\n.ag-theme-alpine-auto-dark .ag-column-drop-cell-button {\n  opacity: 0.5;\n}\n.ag-theme-alpine .ag-column-drop-cell-button:hover,\n.ag-theme-alpine-dark .ag-column-drop-cell-button:hover,\n.ag-theme-alpine-auto-dark .ag-column-drop-cell-button:hover {\n  opacity: 0.75;\n}\n.ag-theme-alpine .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-alpine .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-alpine-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-alpine-dark .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-alpine-auto-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-alpine-auto-dark .ag-column-select-column-readonly .ag-icon-grip {\n  opacity: 0.35;\n}\n.ag-theme-alpine .ag-header-cell-menu-button:hover,\n.ag-theme-alpine .ag-header-cell-filter-button:hover,\n.ag-theme-alpine .ag-side-button-button:hover,\n.ag-theme-alpine .ag-tab:hover,\n.ag-theme-alpine .ag-panel-title-bar-button:hover,\n.ag-theme-alpine .ag-header-expand-icon:hover,\n.ag-theme-alpine .ag-column-group-icons:hover,\n.ag-theme-alpine .ag-set-filter-group-icons:hover,\n.ag-theme-alpine .ag-group-expanded .ag-icon:hover,\n.ag-theme-alpine .ag-group-contracted .ag-icon:hover,\n.ag-theme-alpine .ag-chart-settings-prev:hover,\n.ag-theme-alpine .ag-chart-settings-next:hover,\n.ag-theme-alpine .ag-group-title-bar-icon:hover,\n.ag-theme-alpine .ag-column-select-header-icon:hover,\n.ag-theme-alpine .ag-floating-filter-button-button:hover,\n.ag-theme-alpine .ag-filter-toolpanel-expand:hover,\n.ag-theme-alpine .ag-chart-menu-icon:hover,\n.ag-theme-alpine-dark .ag-header-cell-menu-button:hover,\n.ag-theme-alpine-dark .ag-header-cell-filter-button:hover,\n.ag-theme-alpine-dark .ag-side-button-button:hover,\n.ag-theme-alpine-dark .ag-tab:hover,\n.ag-theme-alpine-dark .ag-panel-title-bar-button:hover,\n.ag-theme-alpine-dark .ag-header-expand-icon:hover,\n.ag-theme-alpine-dark .ag-column-group-icons:hover,\n.ag-theme-alpine-dark .ag-set-filter-group-icons:hover,\n.ag-theme-alpine-dark .ag-group-expanded .ag-icon:hover,\n.ag-theme-alpine-dark .ag-group-contracted .ag-icon:hover,\n.ag-theme-alpine-dark .ag-chart-settings-prev:hover,\n.ag-theme-alpine-dark .ag-chart-settings-next:hover,\n.ag-theme-alpine-dark .ag-group-title-bar-icon:hover,\n.ag-theme-alpine-dark .ag-column-select-header-icon:hover,\n.ag-theme-alpine-dark .ag-floating-filter-button-button:hover,\n.ag-theme-alpine-dark .ag-filter-toolpanel-expand:hover,\n.ag-theme-alpine-dark .ag-chart-menu-icon:hover,\n.ag-theme-alpine-auto-dark .ag-header-cell-menu-button:hover,\n.ag-theme-alpine-auto-dark .ag-header-cell-filter-button:hover,\n.ag-theme-alpine-auto-dark .ag-side-button-button:hover,\n.ag-theme-alpine-auto-dark .ag-tab:hover,\n.ag-theme-alpine-auto-dark .ag-panel-title-bar-button:hover,\n.ag-theme-alpine-auto-dark .ag-header-expand-icon:hover,\n.ag-theme-alpine-auto-dark .ag-column-group-icons:hover,\n.ag-theme-alpine-auto-dark .ag-set-filter-group-icons:hover,\n.ag-theme-alpine-auto-dark .ag-group-expanded .ag-icon:hover,\n.ag-theme-alpine-auto-dark .ag-group-contracted .ag-icon:hover,\n.ag-theme-alpine-auto-dark .ag-chart-settings-prev:hover,\n.ag-theme-alpine-auto-dark .ag-chart-settings-next:hover,\n.ag-theme-alpine-auto-dark .ag-group-title-bar-icon:hover,\n.ag-theme-alpine-auto-dark .ag-column-select-header-icon:hover,\n.ag-theme-alpine-auto-dark .ag-floating-filter-button-button:hover,\n.ag-theme-alpine-auto-dark .ag-filter-toolpanel-expand:hover,\n.ag-theme-alpine-auto-dark .ag-chart-menu-icon:hover {\n  color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-header-cell-menu-button:hover .ag-icon,\n.ag-theme-alpine .ag-header-cell-filter-button:hover .ag-icon,\n.ag-theme-alpine .ag-side-button-button:hover .ag-icon,\n.ag-theme-alpine .ag-panel-title-bar-button:hover .ag-icon,\n.ag-theme-alpine .ag-floating-filter-button-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-header-cell-menu-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-header-cell-filter-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-side-button-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-panel-title-bar-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-floating-filter-button-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-header-cell-menu-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-header-cell-filter-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-side-button-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-panel-title-bar-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-floating-filter-button-button:hover .ag-icon {\n  color: inherit;\n}\n.ag-theme-alpine .ag-filter-active .ag-icon-filter,\n.ag-theme-alpine-dark .ag-filter-active .ag-icon-filter,\n.ag-theme-alpine-auto-dark .ag-filter-active .ag-icon-filter {\n  color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-chart-settings-card-item.ag-not-selected:hover,\n.ag-theme-alpine-dark .ag-chart-settings-card-item.ag-not-selected:hover,\n.ag-theme-alpine-auto-dark .ag-chart-settings-card-item.ag-not-selected:hover {\n  opacity: 0.35;\n}\n.ag-theme-alpine .ag-ltr .ag-panel-title-bar-button, .ag-theme-alpine-dark .ag-ltr .ag-panel-title-bar-button, .ag-theme-alpine-auto-dark .ag-ltr .ag-panel-title-bar-button {\n  margin-left: calc(var(--ag-grid-size) * 2);\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-rtl .ag-panel-title-bar-button, .ag-theme-alpine-dark .ag-rtl .ag-panel-title-bar-button, .ag-theme-alpine-auto-dark .ag-rtl .ag-panel-title-bar-button {\n  margin-right: calc(var(--ag-grid-size) * 2);\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-ltr .ag-filter-toolpanel-group-container, .ag-theme-alpine-dark .ag-ltr .ag-filter-toolpanel-group-container, .ag-theme-alpine-auto-dark .ag-ltr .ag-filter-toolpanel-group-container {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-rtl .ag-filter-toolpanel-group-container, .ag-theme-alpine-dark .ag-rtl .ag-filter-toolpanel-group-container, .ag-theme-alpine-auto-dark .ag-rtl .ag-filter-toolpanel-group-container {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-filter-toolpanel-instance-filter,\n.ag-theme-alpine-dark .ag-filter-toolpanel-instance-filter,\n.ag-theme-alpine-auto-dark .ag-filter-toolpanel-instance-filter {\n  border: none;\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-alpine .ag-ltr .ag-filter-toolpanel-instance-filter, .ag-theme-alpine-dark .ag-ltr .ag-filter-toolpanel-instance-filter, .ag-theme-alpine-auto-dark .ag-ltr .ag-filter-toolpanel-instance-filter {\n  border-left: dashed 1px;\n  border-left-color: var(--ag-border-color);\n  margin-left: calc(var(--ag-icon-size) * 0.5);\n}\n\n.ag-theme-alpine .ag-rtl .ag-filter-toolpanel-instance-filter, .ag-theme-alpine-dark .ag-rtl .ag-filter-toolpanel-instance-filter, .ag-theme-alpine-auto-dark .ag-rtl .ag-filter-toolpanel-instance-filter {\n  border-right: dashed 1px;\n  border-right-color: var(--ag-border-color);\n  margin-right: calc(var(--ag-icon-size) * 0.5);\n}\n\n.ag-theme-alpine .ag-set-filter-list,\n.ag-theme-alpine-dark .ag-set-filter-list,\n.ag-theme-alpine-auto-dark .ag-set-filter-list {\n  padding-top: calc(var(--ag-grid-size) * 0.5);\n  padding-bottom: calc(var(--ag-grid-size) * 0.5);\n}\n.ag-theme-alpine .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-alpine .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-alpine .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-alpine .ag-layout-print .ag-center-cols-container,\n.ag-theme-alpine-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-alpine-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-alpine-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-alpine-dark .ag-layout-print .ag-center-cols-container,\n.ag-theme-alpine-auto-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-alpine-auto-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-alpine-auto-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-alpine-auto-dark .ag-layout-print .ag-center-cols-container {\n  min-height: 150px;\n}\n.ag-theme-alpine .ag-date-time-list-page-entry-is-current,\n.ag-theme-alpine-dark .ag-date-time-list-page-entry-is-current,\n.ag-theme-alpine-auto-dark .ag-date-time-list-page-entry-is-current {\n  background-color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-advanced-filter-builder-button,\n.ag-theme-alpine-dark .ag-advanced-filter-builder-button,\n.ag-theme-alpine-auto-dark .ag-advanced-filter-builder-button {\n  padding: var(--ag-grid-size);\n  font-weight: 600;\n}\n.ag-theme-alpine .ag-list-item-hovered::after,\n.ag-theme-alpine-dark .ag-list-item-hovered::after,\n.ag-theme-alpine-auto-dark .ag-list-item-hovered::after {\n  background-color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-pill .ag-pill-button:hover,\n.ag-theme-alpine-dark .ag-pill .ag-pill-button:hover,\n.ag-theme-alpine-auto-dark .ag-pill .ag-pill-button:hover {\n  color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-header-highlight-before::after,\n.ag-theme-alpine .ag-header-highlight-after::after,\n.ag-theme-alpine-dark .ag-header-highlight-before::after,\n.ag-theme-alpine-dark .ag-header-highlight-after::after,\n.ag-theme-alpine-auto-dark .ag-header-highlight-before::after,\n.ag-theme-alpine-auto-dark .ag-header-highlight-after::after {\n  background-color: var(--ag-alpine-active-color);\n}\n', ""]), t2.A = i;
          }, 7521: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(8430), a2.b), c = i()(o()), g = s()(d);
            c.push([e2.id, '@font-face {\n  font-family: "agGridAlpine";\n  src: url(' + g + ');\n  font-weight: normal;\n  font-style: normal;\n}\n.ag-theme-alpine,\n.ag-theme-alpine-dark,\n.ag-theme-alpine-auto-dark {\n  --ag-alpine-active-color: #2196f3;\n  --ag-selected-row-background-color: rgba(33, 150, 243, 0.3);\n  --ag-row-hover-color: rgba(33, 150, 243, 0.1);\n  --ag-column-hover-color: rgba(33, 150, 243, 0.1);\n  --ag-input-focus-border-color: rgba(33, 150, 243, 0.4);\n  --ag-range-selection-background-color: rgba(33, 150, 243, 0.2);\n  --ag-range-selection-background-color-2: rgba(33, 150, 243, 0.36);\n  --ag-range-selection-background-color-3: rgba(33, 150, 243, 0.49);\n  --ag-range-selection-background-color-4: rgba(33, 150, 243, 0.59);\n  --ag-background-color: #fff;\n  --ag-foreground-color: #181d1f;\n  --ag-border-color: #babfc7;\n  --ag-secondary-border-color: #dde2eb;\n  --ag-header-background-color: #f8f8f8;\n  --ag-tooltip-background-color: #f8f8f8;\n  --ag-odd-row-background-color: #fcfcfc;\n  --ag-control-panel-background-color: #f8f8f8;\n  --ag-subheader-background-color: #fff;\n  --ag-invalid-color: #e02525;\n  --ag-checkbox-unchecked-color: #999;\n  --ag-advanced-filter-join-pill-color: #f08e8d;\n  --ag-advanced-filter-column-pill-color: #a6e194;\n  --ag-advanced-filter-option-pill-color: #f3c08b;\n  --ag-advanced-filter-value-pill-color: #85c0e4;\n  --ag-checkbox-background-color: var(--ag-background-color);\n  --ag-checkbox-checked-color: var(--ag-alpine-active-color);\n  --ag-range-selection-border-color: var(--ag-alpine-active-color);\n  --ag-secondary-foreground-color: var(--ag-foreground-color);\n  --ag-input-border-color: var(--ag-border-color);\n  --ag-input-border-color-invalid: var(--ag-invalid-color);\n  --ag-input-focus-box-shadow: 0 0 2px 0.1rem var(--ag-input-focus-border-color);\n  --ag-panel-background-color: var(--ag-header-background-color);\n  --ag-menu-background-color: var(--ag-header-background-color);\n  --ag-disabled-foreground-color: rgba(24, 29, 31, 0.5);\n  --ag-chip-background-color: rgba(24, 29, 31, 0.07);\n  --ag-input-disabled-border-color: rgba(186, 191, 199, 0.3);\n  --ag-input-disabled-background-color: rgba(186, 191, 199, 0.15);\n  --ag-borders: solid 1px;\n  --ag-border-radius: 3px;\n  --ag-borders-side-button: none;\n  --ag-side-button-selected-background-color: transparent;\n  --ag-header-column-resize-handle-display: block;\n  --ag-header-column-resize-handle-width: 2px;\n  --ag-header-column-resize-handle-height: 30%;\n  --ag-grid-size: 6px;\n  --ag-icon-size: 16px;\n  --ag-row-height: calc(var(--ag-grid-size) * 7);\n  --ag-header-height: calc(var(--ag-grid-size) * 8);\n  --ag-list-item-height: calc(var(--ag-grid-size) * 4);\n  --ag-column-select-indent-size: var(--ag-icon-size);\n  --ag-set-filter-indent-size: var(--ag-icon-size);\n  --ag-advanced-filter-builder-indent-size: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  --ag-cell-horizontal-padding: calc(var(--ag-grid-size) * 3);\n  --ag-cell-widget-spacing: calc(var(--ag-grid-size) * 2);\n  --ag-widget-container-vertical-padding: calc(var(--ag-grid-size) * 2);\n  --ag-widget-container-horizontal-padding: calc(var(--ag-grid-size) * 2);\n  --ag-widget-vertical-spacing: calc(var(--ag-grid-size) * 1.5);\n  --ag-toggle-button-height: 18px;\n  --ag-toggle-button-width: 28px;\n  --ag-font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell,\n      "Helvetica Neue", sans-serif;\n  --ag-font-size: 13px;\n  --ag-icon-font-family: agGridAlpine;\n  --ag-selected-tab-underline-color: var(--ag-alpine-active-color);\n  --ag-selected-tab-underline-width: 2px;\n  --ag-selected-tab-underline-transition-speed: 0.3s;\n  --ag-tab-min-width: 240px;\n  --ag-card-shadow: 0 1px 4px 1px rgba(186, 191, 199, 0.4);\n  --ag-popup-shadow: var(--ag-card-shadow);\n  --ag-side-bar-panel-width: 250px;\n}\n\n.ag-theme-alpine-dark {\n  --ag-background-color: #181d1f;\n  --ag-foreground-color: #fff;\n  --ag-border-color: #68686e;\n  --ag-secondary-border-color: rgba(88, 86, 82, 0.5);\n  --ag-modal-overlay-background-color: rgba(24, 29, 31, 0.66);\n  --ag-header-background-color: #222628;\n  --ag-tooltip-background-color: #222628;\n  --ag-odd-row-background-color: #222628;\n  --ag-control-panel-background-color: #222628;\n  --ag-subheader-background-color: #000;\n  --ag-input-disabled-background-color: #282c2f;\n  --ag-input-focus-box-shadow: 0 0 2px 0.5px rgba(255, 255, 255, 0.5), 0 0 4px 3px var(--ag-input-focus-border-color);\n  --ag-card-shadow: 0 1px 20px 1px black;\n  --ag-disabled-foreground-color: rgba(255, 255, 255, 0.5);\n  --ag-chip-background-color: rgba(255, 255, 255, 0.07);\n  --ag-input-disabled-border-color: rgba(104, 104, 110, 0.3);\n  --ag-input-disabled-background-color: rgba(104, 104, 110, 0.07);\n  --ag-advanced-filter-join-pill-color: #7a3a37;\n  --ag-advanced-filter-column-pill-color: #355f2d;\n  --ag-advanced-filter-option-pill-color: #5a3168;\n  --ag-advanced-filter-value-pill-color: #374c86;\n  --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n  --csstools-color-scheme--dark: initial;\n  color-scheme: dark;\n}\n\n@media (prefers-color-scheme: dark) {\n  .ag-theme-alpine-auto-dark {\n    --ag-background-color: #181d1f;\n    --ag-foreground-color: #fff;\n    --ag-border-color: #68686e;\n    --ag-secondary-border-color: rgba(88, 86, 82, 0.5);\n    --ag-modal-overlay-background-color: rgba(24, 29, 31, 0.66);\n    --ag-header-background-color: #222628;\n    --ag-tooltip-background-color: #222628;\n    --ag-odd-row-background-color: #222628;\n    --ag-control-panel-background-color: #222628;\n    --ag-subheader-background-color: #000;\n    --ag-input-disabled-background-color: #282c2f;\n    --ag-input-focus-box-shadow: 0 0 2px 0.5px rgba(255, 255, 255, 0.5), 0 0 4px 3px var(--ag-input-focus-border-color);\n    --ag-card-shadow: 0 1px 20px 1px black;\n    --ag-disabled-foreground-color: rgba(255, 255, 255, 0.5);\n    --ag-chip-background-color: rgba(255, 255, 255, 0.07);\n    --ag-input-disabled-border-color: rgba(104, 104, 110, 0.3);\n    --ag-input-disabled-background-color: rgba(104, 104, 110, 0.07);\n    --ag-advanced-filter-join-pill-color: #7a3a37;\n    --ag-advanced-filter-column-pill-color: #355f2d;\n    --ag-advanced-filter-option-pill-color: #5a3168;\n    --ag-advanced-filter-value-pill-color: #374c86;\n    --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n    --csstools-color-scheme--dark: initial;\n    color-scheme: dark;\n  }\n}\n.ag-theme-alpine .ag-filter-toolpanel-header,\n.ag-theme-alpine .ag-filter-toolpanel-search,\n.ag-theme-alpine .ag-status-bar,\n.ag-theme-alpine .ag-header-row,\n.ag-theme-alpine .ag-panel-title-bar-title,\n.ag-theme-alpine .ag-multi-filter-group-title-bar,\n.ag-theme-alpine-dark .ag-filter-toolpanel-header,\n.ag-theme-alpine-dark .ag-filter-toolpanel-search,\n.ag-theme-alpine-dark .ag-status-bar,\n.ag-theme-alpine-dark .ag-header-row,\n.ag-theme-alpine-dark .ag-panel-title-bar-title,\n.ag-theme-alpine-dark .ag-multi-filter-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-filter-toolpanel-header,\n.ag-theme-alpine-auto-dark .ag-filter-toolpanel-search,\n.ag-theme-alpine-auto-dark .ag-status-bar,\n.ag-theme-alpine-auto-dark .ag-header-row,\n.ag-theme-alpine-auto-dark .ag-panel-title-bar-title,\n.ag-theme-alpine-auto-dark .ag-multi-filter-group-title-bar {\n  font-weight: 700;\n  color: var(--ag-header-foreground-color);\n}\n.ag-theme-alpine .ag-row,\n.ag-theme-alpine-dark .ag-row,\n.ag-theme-alpine-auto-dark .ag-row {\n  font-size: calc(var(--ag-font-size) + 1px);\n}\n.ag-theme-alpine input[class^=ag-]:not([type]),\n.ag-theme-alpine input[class^=ag-][type=text],\n.ag-theme-alpine input[class^=ag-][type=number],\n.ag-theme-alpine input[class^=ag-][type=tel],\n.ag-theme-alpine input[class^=ag-][type=date],\n.ag-theme-alpine input[class^=ag-][type=datetime-local],\n.ag-theme-alpine textarea[class^=ag-],\n.ag-theme-alpine-dark input[class^=ag-]:not([type]),\n.ag-theme-alpine-dark input[class^=ag-][type=text],\n.ag-theme-alpine-dark input[class^=ag-][type=number],\n.ag-theme-alpine-dark input[class^=ag-][type=tel],\n.ag-theme-alpine-dark input[class^=ag-][type=date],\n.ag-theme-alpine-dark input[class^=ag-][type=datetime-local],\n.ag-theme-alpine-dark textarea[class^=ag-],\n.ag-theme-alpine-auto-dark input[class^=ag-]:not([type]),\n.ag-theme-alpine-auto-dark input[class^=ag-][type=text],\n.ag-theme-alpine-auto-dark input[class^=ag-][type=number],\n.ag-theme-alpine-auto-dark input[class^=ag-][type=tel],\n.ag-theme-alpine-auto-dark input[class^=ag-][type=date],\n.ag-theme-alpine-auto-dark input[class^=ag-][type=datetime-local],\n.ag-theme-alpine-auto-dark textarea[class^=ag-] {\n  min-height: calc(var(--ag-grid-size) * 4);\n  border-radius: var(--ag-border-radius);\n}\n.ag-theme-alpine .ag-ltr input[class^=ag-]:not([type]), .ag-theme-alpine .ag-ltr input[class^=ag-][type=text], .ag-theme-alpine .ag-ltr input[class^=ag-][type=number], .ag-theme-alpine .ag-ltr input[class^=ag-][type=tel], .ag-theme-alpine .ag-ltr input[class^=ag-][type=date], .ag-theme-alpine .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-alpine .ag-ltr textarea[class^=ag-], .ag-theme-alpine-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-alpine-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-alpine-dark .ag-ltr textarea[class^=ag-], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-alpine-auto-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-alpine-auto-dark .ag-ltr textarea[class^=ag-] {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-rtl input[class^=ag-]:not([type]), .ag-theme-alpine .ag-rtl input[class^=ag-][type=text], .ag-theme-alpine .ag-rtl input[class^=ag-][type=number], .ag-theme-alpine .ag-rtl input[class^=ag-][type=tel], .ag-theme-alpine .ag-rtl input[class^=ag-][type=date], .ag-theme-alpine .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-alpine .ag-rtl textarea[class^=ag-], .ag-theme-alpine-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-alpine-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-alpine-dark .ag-rtl textarea[class^=ag-], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-alpine-auto-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-alpine-auto-dark .ag-rtl textarea[class^=ag-] {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-tab,\n.ag-theme-alpine-dark .ag-tab,\n.ag-theme-alpine-auto-dark .ag-tab {\n  padding: calc(var(--ag-grid-size) * 1.5);\n  transition: color 0.4s;\n  flex: 1 1 auto;\n}\n.ag-theme-alpine .ag-tab-selected,\n.ag-theme-alpine-dark .ag-tab-selected,\n.ag-theme-alpine-auto-dark .ag-tab-selected {\n  color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-menu,\n.ag-theme-alpine-dark .ag-menu,\n.ag-theme-alpine-auto-dark .ag-menu {\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-alpine .ag-panel-content-wrapper .ag-column-select,\n.ag-theme-alpine-dark .ag-panel-content-wrapper .ag-column-select,\n.ag-theme-alpine-auto-dark .ag-panel-content-wrapper .ag-column-select {\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-alpine .ag-menu-header,\n.ag-theme-alpine-dark .ag-menu-header,\n.ag-theme-alpine-auto-dark .ag-menu-header {\n  background-color: var(--ag-control-panel-background-color);\n  padding-top: 1px;\n}\n.ag-theme-alpine .ag-tabs-header,\n.ag-theme-alpine-dark .ag-tabs-header,\n.ag-theme-alpine-auto-dark .ag-tabs-header {\n  border-bottom: var(--ag-borders) var(--ag-border-color);\n}\n.ag-theme-alpine .ag-charts-settings-group-title-bar,\n.ag-theme-alpine .ag-charts-data-group-title-bar,\n.ag-theme-alpine .ag-charts-format-top-level-group-title-bar,\n.ag-theme-alpine .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-settings-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-data-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-settings-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-data-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-advanced-settings-top-level-group-title-bar {\n  padding: var(--ag-grid-size) calc(var(--ag-grid-size) * 2);\n  line-height: calc(var(--ag-icon-size) + var(--ag-grid-size) - 2px);\n}\n.ag-theme-alpine .ag-chart-mini-thumbnail,\n.ag-theme-alpine-dark .ag-chart-mini-thumbnail,\n.ag-theme-alpine-auto-dark .ag-chart-mini-thumbnail {\n  background-color: var(--ag-background-color);\n}\n.ag-theme-alpine .ag-chart-settings-nav-bar,\n.ag-theme-alpine-dark .ag-chart-settings-nav-bar,\n.ag-theme-alpine-auto-dark .ag-chart-settings-nav-bar {\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n.ag-theme-alpine .ag-ltr .ag-group-title-bar-icon, .ag-theme-alpine-dark .ag-ltr .ag-group-title-bar-icon, .ag-theme-alpine-auto-dark .ag-ltr .ag-group-title-bar-icon {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-rtl .ag-group-title-bar-icon, .ag-theme-alpine-dark .ag-rtl .ag-group-title-bar-icon, .ag-theme-alpine-auto-dark .ag-rtl .ag-group-title-bar-icon {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-charts-format-top-level-group-toolbar,\n.ag-theme-alpine .ag-charts-advanced-settings-top-level-group-toolbar,\n.ag-theme-alpine-dark .ag-charts-format-top-level-group-toolbar,\n.ag-theme-alpine-dark .ag-charts-advanced-settings-top-level-group-toolbar,\n.ag-theme-alpine-auto-dark .ag-charts-format-top-level-group-toolbar,\n.ag-theme-alpine-auto-dark .ag-charts-advanced-settings-top-level-group-toolbar {\n  margin-top: var(--ag-grid-size);\n}\n.ag-theme-alpine .ag-ltr .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine .ag-ltr .ag-charts-advanced-settings-top-level-group-toolbar, .ag-theme-alpine-dark .ag-ltr .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine-dark .ag-ltr .ag-charts-advanced-settings-top-level-group-toolbar, .ag-theme-alpine-auto-dark .ag-ltr .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine-auto-dark .ag-ltr .ag-charts-advanced-settings-top-level-group-toolbar {\n  padding-left: calc(var(--ag-icon-size) * 0.5 + var(--ag-grid-size) * 2);\n}\n\n.ag-theme-alpine .ag-rtl .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine .ag-rtl .ag-charts-advanced-settings-top-level-group-toolbar, .ag-theme-alpine-dark .ag-rtl .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine-dark .ag-rtl .ag-charts-advanced-settings-top-level-group-toolbar, .ag-theme-alpine-auto-dark .ag-rtl .ag-charts-format-top-level-group-toolbar, .ag-theme-alpine-auto-dark .ag-rtl .ag-charts-advanced-settings-top-level-group-toolbar {\n  padding-right: calc(var(--ag-icon-size) * 0.5 + var(--ag-grid-size) * 2);\n}\n\n.ag-theme-alpine .ag-charts-format-sub-level-group,\n.ag-theme-alpine-dark .ag-charts-format-sub-level-group,\n.ag-theme-alpine-auto-dark .ag-charts-format-sub-level-group {\n  border-left: dashed 1px;\n  border-left-color: var(--ag-border-color);\n  padding-left: var(--ag-grid-size);\n  margin-bottom: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-alpine .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-alpine-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-alpine-auto-dark .ag-charts-format-sub-level-group-title-bar {\n  padding-top: 0;\n  padding-bottom: 0;\n  background: none;\n  font-weight: 700;\n}\n.ag-theme-alpine .ag-charts-format-sub-level-group-container,\n.ag-theme-alpine-dark .ag-charts-format-sub-level-group-container,\n.ag-theme-alpine-auto-dark .ag-charts-format-sub-level-group-container {\n  padding-bottom: 0;\n}\n.ag-theme-alpine .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-alpine-dark .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-alpine-auto-dark .ag-charts-format-sub-level-group-item:last-child {\n  margin-bottom: 0;\n}\n.ag-theme-alpine.ag-dnd-ghost,\n.ag-theme-alpine-dark.ag-dnd-ghost,\n.ag-theme-alpine-auto-dark.ag-dnd-ghost {\n  font-size: calc(var(--ag-font-size) - 1px);\n  font-weight: 700;\n}\n.ag-theme-alpine .ag-side-buttons,\n.ag-theme-alpine-dark .ag-side-buttons,\n.ag-theme-alpine-auto-dark .ag-side-buttons {\n  width: calc(var(--ag-grid-size) * 5);\n}\n.ag-theme-alpine .ag-standard-button,\n.ag-theme-alpine-dark .ag-standard-button,\n.ag-theme-alpine-auto-dark .ag-standard-button {\n  font-family: inherit;\n  -moz-appearance: none;\n       appearance: none;\n  -webkit-appearance: none;\n  border-radius: var(--ag-border-radius);\n  border: 1px solid;\n  border-color: var(--ag-alpine-active-color);\n  color: var(--ag-alpine-active-color);\n  background-color: var(--ag-background-color);\n  font-weight: 600;\n  padding: var(--ag-grid-size) calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-alpine .ag-standard-button:hover,\n.ag-theme-alpine-dark .ag-standard-button:hover,\n.ag-theme-alpine-auto-dark .ag-standard-button:hover {\n  border-color: var(--ag-alpine-active-color);\n  background-color: var(--ag-row-hover-color);\n}\n.ag-theme-alpine .ag-standard-button:active,\n.ag-theme-alpine-dark .ag-standard-button:active,\n.ag-theme-alpine-auto-dark .ag-standard-button:active {\n  border-color: var(--ag-alpine-active-color);\n  background-color: var(--ag-alpine-active-color);\n  color: var(--ag-background-color);\n}\n.ag-theme-alpine .ag-standard-button:disabled,\n.ag-theme-alpine-dark .ag-standard-button:disabled,\n.ag-theme-alpine-auto-dark .ag-standard-button:disabled {\n  color: var(--ag-disabled-foreground-color);\n  background-color: var(--ag-input-disabled-background-color);\n  border-color: var(--ag-input-disabled-border-color);\n}\n.ag-theme-alpine .ag-column-drop-vertical,\n.ag-theme-alpine-dark .ag-column-drop-vertical,\n.ag-theme-alpine-auto-dark .ag-column-drop-vertical {\n  min-height: 75px;\n}\n.ag-theme-alpine .ag-column-drop-vertical-title-bar,\n.ag-theme-alpine-dark .ag-column-drop-vertical-title-bar,\n.ag-theme-alpine-auto-dark .ag-column-drop-vertical-title-bar {\n  padding: calc(var(--ag-grid-size) * 2);\n  padding-bottom: 0px;\n}\n.ag-theme-alpine .ag-column-drop-vertical-empty-message,\n.ag-theme-alpine-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-alpine-auto-dark .ag-column-drop-vertical-empty-message {\n  display: flex;\n  align-items: center;\n  border: dashed 1px;\n  border-color: var(--ag-border-color);\n  margin: calc(var(--ag-grid-size) * 2);\n  padding: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-alpine .ag-column-drop-empty-message,\n.ag-theme-alpine-dark .ag-column-drop-empty-message,\n.ag-theme-alpine-auto-dark .ag-column-drop-empty-message {\n  color: var(--ag-foreground-color);\n  opacity: 0.75;\n}\n.ag-theme-alpine .ag-pill-select .ag-column-drop,\n.ag-theme-alpine-dark .ag-pill-select .ag-column-drop,\n.ag-theme-alpine-auto-dark .ag-pill-select .ag-column-drop {\n  min-height: 0;\n  min-height: initial;\n}\n.ag-theme-alpine .ag-status-bar,\n.ag-theme-alpine-dark .ag-status-bar,\n.ag-theme-alpine-auto-dark .ag-status-bar {\n  font-weight: normal;\n}\n.ag-theme-alpine .ag-status-name-value-value,\n.ag-theme-alpine-dark .ag-status-name-value-value,\n.ag-theme-alpine-auto-dark .ag-status-name-value-value {\n  font-weight: 700;\n}\n.ag-theme-alpine .ag-paging-number,\n.ag-theme-alpine .ag-paging-row-summary-panel-number,\n.ag-theme-alpine-dark .ag-paging-number,\n.ag-theme-alpine-dark .ag-paging-row-summary-panel-number,\n.ag-theme-alpine-auto-dark .ag-paging-number,\n.ag-theme-alpine-auto-dark .ag-paging-row-summary-panel-number {\n  font-weight: 700;\n}\n.ag-theme-alpine .ag-column-drop-cell-button,\n.ag-theme-alpine-dark .ag-column-drop-cell-button,\n.ag-theme-alpine-auto-dark .ag-column-drop-cell-button {\n  opacity: 0.5;\n}\n.ag-theme-alpine .ag-column-drop-cell-button:hover,\n.ag-theme-alpine-dark .ag-column-drop-cell-button:hover,\n.ag-theme-alpine-auto-dark .ag-column-drop-cell-button:hover {\n  opacity: 0.75;\n}\n.ag-theme-alpine .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-alpine .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-alpine-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-alpine-dark .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-alpine-auto-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-alpine-auto-dark .ag-column-select-column-readonly .ag-icon-grip {\n  opacity: 0.35;\n}\n.ag-theme-alpine .ag-header-cell-menu-button:hover,\n.ag-theme-alpine .ag-header-cell-filter-button:hover,\n.ag-theme-alpine .ag-side-button-button:hover,\n.ag-theme-alpine .ag-tab:hover,\n.ag-theme-alpine .ag-panel-title-bar-button:hover,\n.ag-theme-alpine .ag-header-expand-icon:hover,\n.ag-theme-alpine .ag-column-group-icons:hover,\n.ag-theme-alpine .ag-set-filter-group-icons:hover,\n.ag-theme-alpine .ag-group-expanded .ag-icon:hover,\n.ag-theme-alpine .ag-group-contracted .ag-icon:hover,\n.ag-theme-alpine .ag-chart-settings-prev:hover,\n.ag-theme-alpine .ag-chart-settings-next:hover,\n.ag-theme-alpine .ag-group-title-bar-icon:hover,\n.ag-theme-alpine .ag-column-select-header-icon:hover,\n.ag-theme-alpine .ag-floating-filter-button-button:hover,\n.ag-theme-alpine .ag-filter-toolpanel-expand:hover,\n.ag-theme-alpine .ag-chart-menu-icon:hover,\n.ag-theme-alpine-dark .ag-header-cell-menu-button:hover,\n.ag-theme-alpine-dark .ag-header-cell-filter-button:hover,\n.ag-theme-alpine-dark .ag-side-button-button:hover,\n.ag-theme-alpine-dark .ag-tab:hover,\n.ag-theme-alpine-dark .ag-panel-title-bar-button:hover,\n.ag-theme-alpine-dark .ag-header-expand-icon:hover,\n.ag-theme-alpine-dark .ag-column-group-icons:hover,\n.ag-theme-alpine-dark .ag-set-filter-group-icons:hover,\n.ag-theme-alpine-dark .ag-group-expanded .ag-icon:hover,\n.ag-theme-alpine-dark .ag-group-contracted .ag-icon:hover,\n.ag-theme-alpine-dark .ag-chart-settings-prev:hover,\n.ag-theme-alpine-dark .ag-chart-settings-next:hover,\n.ag-theme-alpine-dark .ag-group-title-bar-icon:hover,\n.ag-theme-alpine-dark .ag-column-select-header-icon:hover,\n.ag-theme-alpine-dark .ag-floating-filter-button-button:hover,\n.ag-theme-alpine-dark .ag-filter-toolpanel-expand:hover,\n.ag-theme-alpine-dark .ag-chart-menu-icon:hover,\n.ag-theme-alpine-auto-dark .ag-header-cell-menu-button:hover,\n.ag-theme-alpine-auto-dark .ag-header-cell-filter-button:hover,\n.ag-theme-alpine-auto-dark .ag-side-button-button:hover,\n.ag-theme-alpine-auto-dark .ag-tab:hover,\n.ag-theme-alpine-auto-dark .ag-panel-title-bar-button:hover,\n.ag-theme-alpine-auto-dark .ag-header-expand-icon:hover,\n.ag-theme-alpine-auto-dark .ag-column-group-icons:hover,\n.ag-theme-alpine-auto-dark .ag-set-filter-group-icons:hover,\n.ag-theme-alpine-auto-dark .ag-group-expanded .ag-icon:hover,\n.ag-theme-alpine-auto-dark .ag-group-contracted .ag-icon:hover,\n.ag-theme-alpine-auto-dark .ag-chart-settings-prev:hover,\n.ag-theme-alpine-auto-dark .ag-chart-settings-next:hover,\n.ag-theme-alpine-auto-dark .ag-group-title-bar-icon:hover,\n.ag-theme-alpine-auto-dark .ag-column-select-header-icon:hover,\n.ag-theme-alpine-auto-dark .ag-floating-filter-button-button:hover,\n.ag-theme-alpine-auto-dark .ag-filter-toolpanel-expand:hover,\n.ag-theme-alpine-auto-dark .ag-chart-menu-icon:hover {\n  color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-header-cell-menu-button:hover .ag-icon,\n.ag-theme-alpine .ag-header-cell-filter-button:hover .ag-icon,\n.ag-theme-alpine .ag-side-button-button:hover .ag-icon,\n.ag-theme-alpine .ag-panel-title-bar-button:hover .ag-icon,\n.ag-theme-alpine .ag-floating-filter-button-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-header-cell-menu-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-header-cell-filter-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-side-button-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-panel-title-bar-button:hover .ag-icon,\n.ag-theme-alpine-dark .ag-floating-filter-button-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-header-cell-menu-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-header-cell-filter-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-side-button-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-panel-title-bar-button:hover .ag-icon,\n.ag-theme-alpine-auto-dark .ag-floating-filter-button-button:hover .ag-icon {\n  color: inherit;\n}\n.ag-theme-alpine .ag-filter-active .ag-icon-filter,\n.ag-theme-alpine-dark .ag-filter-active .ag-icon-filter,\n.ag-theme-alpine-auto-dark .ag-filter-active .ag-icon-filter {\n  color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-chart-settings-card-item.ag-not-selected:hover,\n.ag-theme-alpine-dark .ag-chart-settings-card-item.ag-not-selected:hover,\n.ag-theme-alpine-auto-dark .ag-chart-settings-card-item.ag-not-selected:hover {\n  opacity: 0.35;\n}\n.ag-theme-alpine .ag-ltr .ag-panel-title-bar-button, .ag-theme-alpine-dark .ag-ltr .ag-panel-title-bar-button, .ag-theme-alpine-auto-dark .ag-ltr .ag-panel-title-bar-button {\n  margin-left: calc(var(--ag-grid-size) * 2);\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-rtl .ag-panel-title-bar-button, .ag-theme-alpine-dark .ag-rtl .ag-panel-title-bar-button, .ag-theme-alpine-auto-dark .ag-rtl .ag-panel-title-bar-button {\n  margin-right: calc(var(--ag-grid-size) * 2);\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-ltr .ag-filter-toolpanel-group-container, .ag-theme-alpine-dark .ag-ltr .ag-filter-toolpanel-group-container, .ag-theme-alpine-auto-dark .ag-ltr .ag-filter-toolpanel-group-container {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-rtl .ag-filter-toolpanel-group-container, .ag-theme-alpine-dark .ag-rtl .ag-filter-toolpanel-group-container, .ag-theme-alpine-auto-dark .ag-rtl .ag-filter-toolpanel-group-container {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-alpine .ag-filter-toolpanel-instance-filter,\n.ag-theme-alpine-dark .ag-filter-toolpanel-instance-filter,\n.ag-theme-alpine-auto-dark .ag-filter-toolpanel-instance-filter {\n  border: none;\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-alpine .ag-ltr .ag-filter-toolpanel-instance-filter, .ag-theme-alpine-dark .ag-ltr .ag-filter-toolpanel-instance-filter, .ag-theme-alpine-auto-dark .ag-ltr .ag-filter-toolpanel-instance-filter {\n  border-left: dashed 1px;\n  border-left-color: var(--ag-border-color);\n  margin-left: calc(var(--ag-icon-size) * 0.5);\n}\n\n.ag-theme-alpine .ag-rtl .ag-filter-toolpanel-instance-filter, .ag-theme-alpine-dark .ag-rtl .ag-filter-toolpanel-instance-filter, .ag-theme-alpine-auto-dark .ag-rtl .ag-filter-toolpanel-instance-filter {\n  border-right: dashed 1px;\n  border-right-color: var(--ag-border-color);\n  margin-right: calc(var(--ag-icon-size) * 0.5);\n}\n\n.ag-theme-alpine .ag-set-filter-list,\n.ag-theme-alpine-dark .ag-set-filter-list,\n.ag-theme-alpine-auto-dark .ag-set-filter-list {\n  padding-top: calc(var(--ag-grid-size) * 0.5);\n  padding-bottom: calc(var(--ag-grid-size) * 0.5);\n}\n.ag-theme-alpine .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-alpine .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-alpine .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-alpine .ag-layout-print .ag-center-cols-container,\n.ag-theme-alpine-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-alpine-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-alpine-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-alpine-dark .ag-layout-print .ag-center-cols-container,\n.ag-theme-alpine-auto-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-alpine-auto-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-alpine-auto-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-alpine-auto-dark .ag-layout-print .ag-center-cols-container {\n  min-height: 150px;\n}\n.ag-theme-alpine .ag-date-time-list-page-entry-is-current,\n.ag-theme-alpine-dark .ag-date-time-list-page-entry-is-current,\n.ag-theme-alpine-auto-dark .ag-date-time-list-page-entry-is-current {\n  background-color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-advanced-filter-builder-button,\n.ag-theme-alpine-dark .ag-advanced-filter-builder-button,\n.ag-theme-alpine-auto-dark .ag-advanced-filter-builder-button {\n  padding: var(--ag-grid-size);\n  font-weight: 600;\n}\n.ag-theme-alpine .ag-list-item-hovered::after,\n.ag-theme-alpine-dark .ag-list-item-hovered::after,\n.ag-theme-alpine-auto-dark .ag-list-item-hovered::after {\n  background-color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-pill .ag-pill-button:hover,\n.ag-theme-alpine-dark .ag-pill .ag-pill-button:hover,\n.ag-theme-alpine-auto-dark .ag-pill .ag-pill-button:hover {\n  color: var(--ag-alpine-active-color);\n}\n.ag-theme-alpine .ag-header-highlight-before::after,\n.ag-theme-alpine .ag-header-highlight-after::after,\n.ag-theme-alpine-dark .ag-header-highlight-before::after,\n.ag-theme-alpine-dark .ag-header-highlight-after::after,\n.ag-theme-alpine-auto-dark .ag-header-highlight-before::after,\n.ag-theme-alpine-auto-dark .ag-header-highlight-after::after {\n  background-color: var(--ag-alpine-active-color);\n}\n', ""]), t2.A = c;
          }, 4991: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r)()(o());
            i.push([e2.id, '.ag-theme-balham,\n.ag-theme-balham-dark,\n.ag-theme-balham-auto-dark {\n  --ag-balham-active-color: #0091ea;\n  --ag-foreground-color: #000;\n  --ag-background-color: #fff;\n  --ag-header-background-color: #f5f7f7;\n  --ag-tooltip-background-color: #cbd0d3;\n  --ag-subheader-background-color: #e2e9eb;\n  --ag-control-panel-background-color: #f5f7f7;\n  --ag-border-color: #bdc3c7;\n  --ag-odd-row-background-color: #fcfdfe;\n  --ag-row-hover-color: #ecf0f1;\n  --ag-column-hover-color: #ecf0f1;\n  --ag-input-border-color: #95a5a6;\n  --ag-invalid-color: #e02525;\n  --ag-input-disabled-background-color: #ebebeb;\n  --ag-checkbox-unchecked-color: #7f8c8d;\n  --ag-input-focus-border-color: #719ece;\n  --ag-advanced-filter-join-pill-color: #f08e8d;\n  --ag-advanced-filter-column-pill-color: #a6e194;\n  --ag-advanced-filter-option-pill-color: #f3c08b;\n  --ag-advanced-filter-value-pill-color: #85c0e4;\n  --ag-input-focus-box-shadow: 0 0 2px 1px var(--ag-input-focus-border-color);\n  --ag-range-selection-border-color: var(--ag-balham-active-color);\n  --ag-checkbox-checked-color: var(--ag-balham-active-color);\n  --ag-checkbox-background-color: var(--ag-background-color);\n  --ag-panel-background-color: var(--ag-header-background-color);\n  --ag-secondary-foreground-color: rgba(0, 0, 0, 0.54);\n  --ag-disabled-foreground-color: rgba(0, 0, 0, 0.38);\n  --ag-subheader-toolbar-background-color: rgba(226, 233, 235, 0.5);\n  --ag-row-border-color: rgba(189, 195, 199, 0.58);\n  --ag-chip-background-color: rgba(0, 0, 0, 0.1);\n  --ag-range-selection-background-color: rgba(0, 145, 234, 0.2);\n  --ag-range-selection-background-color-2: rgba(0, 145, 234, 0.36);\n  --ag-range-selection-background-color-3: rgba(0, 145, 234, 0.49);\n  --ag-range-selection-background-color-4: rgba(0, 145, 234, 0.59);\n  --ag-selected-row-background-color: rgba(0, 145, 234, 0.28);\n  --ag-header-column-separator-color: rgba(189, 195, 199, 0.5);\n  --ag-input-disabled-border-color: rgba(149, 165, 166, 0.3);\n  --ag-header-column-separator-display: block;\n  --ag-header-column-separator-height: 50%;\n  --ag-grid-size: 4px;\n  --ag-icon-size: 16px;\n  --ag-row-height: calc(var(--ag-grid-size) * 7);\n  --ag-header-height: calc(var(--ag-grid-size) * 8);\n  --ag-list-item-height: calc(var(--ag-grid-size) * 6);\n  --ag-row-group-indent-size: calc(var(--ag-grid-size) * 3 + var(--ag-icon-size));\n  --ag-cell-horizontal-padding: calc(var(--ag-grid-size) * 3);\n  --ag-input-height: calc(var(--ag-grid-size) * 4);\n  --ag-chart-menu-panel-width: 240px;\n  --ag-font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell,\n      "Helvetica Neue", sans-serif;\n  --ag-font-size: 12px;\n  --ag-icon-font-family: agGridBalham;\n  --ag-border-radius: 2px;\n  --ag-checkbox-border-radius: 3px;\n  --ag-card-shadow: none;\n}\n\n.ag-theme-balham-dark {\n  --ag-balham-active-color: #00b0ff;\n  --ag-foreground-color: #f5f5f5;\n  --ag-background-color: #2d3436;\n  --ag-header-background-color: #1c1c1c;\n  --ag-tooltip-background-color: #1c1f20;\n  --ag-subheader-background-color: #111;\n  --ag-control-panel-background-color: #202020;\n  --ag-border-color: #424242;\n  --ag-odd-row-background-color: #262c2e;\n  --ag-row-hover-color: #3d4749;\n  --ag-column-hover-color: #3d4749;\n  --ag-input-border-color: #f0f0f0;\n  --ag-input-disabled-background-color: rgba(48, 46, 46, 0.3);\n  --ag-modal-overlay-background-color: rgba(45, 52, 54, 0.66);\n  --ag-checkbox-unchecked-color: #ecf0f1;\n  --ag-advanced-filter-join-pill-color: #7a3a37;\n  --ag-advanced-filter-column-pill-color: #355f2d;\n  --ag-advanced-filter-option-pill-color: #5a3168;\n  --ag-advanced-filter-value-pill-color: #374c86;\n  --ag-secondary-foreground-color: var(--ag-foreground-color);\n  --ag-disabled-foreground-color: rgba(245, 245, 245, 0.38);\n  --ag-subheader-toolbar-background-color: rgba(17, 17, 17, 0.5);\n  --ag-row-border-color: #5c5c5c;\n  --ag-chip-background-color: rgba(245, 245, 245, 0.08);\n  --ag-range-selection-background-color: rgba(0, 176, 255, 0.2);\n  --ag-range-selection-background-color-2: rgba(0, 176, 255, 0.36);\n  --ag-range-selection-background-color-3: rgba(0, 176, 255, 0.49);\n  --ag-range-selection-background-color-4: rgba(0, 176, 255, 0.59);\n  --ag-selected-row-background-color: rgba(0, 176, 255, 0.28);\n  --ag-header-column-separator-color: rgba(66, 66, 66, 0.5);\n  --ag-input-disabled-border-color: rgba(240, 240, 240, 0.3);\n  --ag-header-foreground-color: rgba(245, 245, 245, 0.64);\n  --ag-toggle-button-off-background-color: transparent;\n  --ag-toggle-button-off-border-color: var(--ag-foreground-color);\n  --ag-range-selection-chart-category-background-color: rgba(26, 177, 74, 0.5);\n  --ag-range-selection-chart-background-color: rgba(45, 166, 255, 0.5);\n  --ag-input-focus-box-shadow: 0 0 4px 1.5px var(--ag-input-focus-border-color);\n  --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n  --csstools-color-scheme--dark: initial;\n  color-scheme: dark;\n}\n\n@media (prefers-color-scheme: dark) {\n  .ag-theme-balham-auto-dark {\n    --ag-balham-active-color: #00b0ff;\n    --ag-foreground-color: #f5f5f5;\n    --ag-background-color: #2d3436;\n    --ag-header-background-color: #1c1c1c;\n    --ag-tooltip-background-color: #1c1f20;\n    --ag-subheader-background-color: #111;\n    --ag-control-panel-background-color: #202020;\n    --ag-border-color: #424242;\n    --ag-odd-row-background-color: #262c2e;\n    --ag-row-hover-color: #3d4749;\n    --ag-column-hover-color: #3d4749;\n    --ag-input-border-color: #f0f0f0;\n    --ag-input-disabled-background-color: rgba(48, 46, 46, 0.3);\n    --ag-modal-overlay-background-color: rgba(45, 52, 54, 0.66);\n    --ag-checkbox-unchecked-color: #ecf0f1;\n    --ag-advanced-filter-join-pill-color: #7a3a37;\n    --ag-advanced-filter-column-pill-color: #355f2d;\n    --ag-advanced-filter-option-pill-color: #5a3168;\n    --ag-advanced-filter-value-pill-color: #374c86;\n    --ag-secondary-foreground-color: var(--ag-foreground-color);\n    --ag-disabled-foreground-color: rgba(245, 245, 245, 0.38);\n    --ag-subheader-toolbar-background-color: rgba(17, 17, 17, 0.5);\n    --ag-row-border-color: #5c5c5c;\n    --ag-chip-background-color: rgba(245, 245, 245, 0.08);\n    --ag-range-selection-background-color: rgba(0, 176, 255, 0.2);\n    --ag-range-selection-background-color-2: rgba(0, 176, 255, 0.36);\n    --ag-range-selection-background-color-3: rgba(0, 176, 255, 0.49);\n    --ag-range-selection-background-color-4: rgba(0, 176, 255, 0.59);\n    --ag-selected-row-background-color: rgba(0, 176, 255, 0.28);\n    --ag-header-column-separator-color: rgba(66, 66, 66, 0.5);\n    --ag-input-disabled-border-color: rgba(240, 240, 240, 0.3);\n    --ag-header-foreground-color: rgba(245, 245, 245, 0.64);\n    --ag-toggle-button-off-background-color: transparent;\n    --ag-toggle-button-off-border-color: var(--ag-foreground-color);\n    --ag-range-selection-chart-category-background-color: rgba(26, 177, 74, 0.5);\n    --ag-range-selection-chart-background-color: rgba(45, 166, 255, 0.5);\n    --ag-input-focus-box-shadow: 0 0 4px 1.5px var(--ag-input-focus-border-color);\n    --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n    --csstools-color-scheme--dark: initial;\n    color-scheme: dark;\n  }\n}\n.ag-theme-balham .ag-filter-toolpanel-header,\n.ag-theme-balham .ag-filter-toolpanel-search,\n.ag-theme-balham .ag-status-bar,\n.ag-theme-balham .ag-header-row,\n.ag-theme-balham .ag-multi-filter-group-title-bar,\n.ag-theme-balham-dark .ag-filter-toolpanel-header,\n.ag-theme-balham-dark .ag-filter-toolpanel-search,\n.ag-theme-balham-dark .ag-status-bar,\n.ag-theme-balham-dark .ag-header-row,\n.ag-theme-balham-dark .ag-multi-filter-group-title-bar,\n.ag-theme-balham-auto-dark .ag-filter-toolpanel-header,\n.ag-theme-balham-auto-dark .ag-filter-toolpanel-search,\n.ag-theme-balham-auto-dark .ag-status-bar,\n.ag-theme-balham-auto-dark .ag-header-row,\n.ag-theme-balham-auto-dark .ag-multi-filter-group-title-bar {\n  font-weight: 600;\n  color: var(--ag-header-foreground-color);\n}\n.ag-theme-balham .ag-ltr input[class^=ag-]:not([type]), .ag-theme-balham .ag-ltr input[class^=ag-][type=text], .ag-theme-balham .ag-ltr input[class^=ag-][type=number], .ag-theme-balham .ag-ltr input[class^=ag-][type=tel], .ag-theme-balham .ag-ltr input[class^=ag-][type=date], .ag-theme-balham .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-balham .ag-ltr textarea[class^=ag-], .ag-theme-balham-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-balham-dark .ag-ltr textarea[class^=ag-], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-balham-auto-dark .ag-ltr textarea[class^=ag-] {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-balham .ag-rtl input[class^=ag-]:not([type]), .ag-theme-balham .ag-rtl input[class^=ag-][type=text], .ag-theme-balham .ag-rtl input[class^=ag-][type=number], .ag-theme-balham .ag-rtl input[class^=ag-][type=tel], .ag-theme-balham .ag-rtl input[class^=ag-][type=date], .ag-theme-balham .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-balham .ag-rtl textarea[class^=ag-], .ag-theme-balham-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-balham-dark .ag-rtl textarea[class^=ag-], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-balham-auto-dark .ag-rtl textarea[class^=ag-] {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-balham .ag-column-drop-vertical-empty-message,\n.ag-theme-balham .ag-status-bar,\n.ag-theme-balham-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-balham-dark .ag-status-bar,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-balham-auto-dark .ag-status-bar {\n  font-weight: 600;\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-balham.ag-dnd-ghost,\n.ag-theme-balham-dark.ag-dnd-ghost,\n.ag-theme-balham-auto-dark.ag-dnd-ghost {\n  font-size: var(--ag-font-size);\n  font-weight: 600;\n}\n.ag-theme-balham .ag-tab,\n.ag-theme-balham-dark .ag-tab,\n.ag-theme-balham-auto-dark .ag-tab {\n  border: 1px solid transparent;\n  padding: var(--ag-grid-size) calc(var(--ag-grid-size) * 2);\n  margin: var(--ag-grid-size);\n  margin-bottom: -1px;\n}\n.ag-theme-balham .ag-tab-selected,\n.ag-theme-balham-dark .ag-tab-selected,\n.ag-theme-balham-auto-dark .ag-tab-selected {\n  background-color: var(--ag-background-color);\n  border-color: var(--ag-border-color);\n  border-bottom-color: transparent;\n}\n.ag-theme-balham .ag-tabs-header,\n.ag-theme-balham-dark .ag-tabs-header,\n.ag-theme-balham-auto-dark .ag-tabs-header {\n  border-bottom: 1px solid var(--ag-border-color);\n}\n.ag-theme-balham .ag-column-drop-cell,\n.ag-theme-balham-dark .ag-column-drop-cell,\n.ag-theme-balham-auto-dark .ag-column-drop-cell {\n  height: calc(var(--ag-grid-size) * 6);\n}\n.ag-theme-balham .ag-column-drop-vertical-title,\n.ag-theme-balham-dark .ag-column-drop-vertical-title,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-title {\n  color: var(--ag-foreground-color);\n}\n.ag-theme-balham .ag-column-drop-vertical-cell,\n.ag-theme-balham-dark .ag-column-drop-vertical-cell,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-cell {\n  margin-left: calc(var(--ag-grid-size) * 2);\n  margin-right: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-balham .ag-column-drop-vertical-cell-text,\n.ag-theme-balham-dark .ag-column-drop-vertical-cell-text,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-cell-text {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-balham .ag-column-drop-vertical-icon,\n.ag-theme-balham-dark .ag-column-drop-vertical-icon,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-icon {\n  color: var(--ag-secondary-foreground-color);\n}\n.ag-theme-balham .ag-ltr .ag-column-drop-vertical-empty-message, .ag-theme-balham-dark .ag-ltr .ag-column-drop-vertical-empty-message, .ag-theme-balham-auto-dark .ag-ltr .ag-column-drop-vertical-empty-message {\n  padding-left: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-balham .ag-rtl .ag-column-drop-vertical-empty-message, .ag-theme-balham-dark .ag-rtl .ag-column-drop-vertical-empty-message, .ag-theme-balham-auto-dark .ag-rtl .ag-column-drop-vertical-empty-message {\n  padding-right: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-balham .ag-column-drop-horizontal,\n.ag-theme-balham-dark .ag-column-drop-horizontal,\n.ag-theme-balham-auto-dark .ag-column-drop-horizontal {\n  height: var(--ag-header-height);\n}\n.ag-theme-balham .ag-column-drop-empty,\n.ag-theme-balham-dark .ag-column-drop-empty,\n.ag-theme-balham-auto-dark .ag-column-drop-empty {\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-balham .ag-column-drop-horizontal-cell-text,\n.ag-theme-balham-dark .ag-column-drop-horizontal-cell-text,\n.ag-theme-balham-auto-dark .ag-column-drop-horizontal-cell-text {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-balham .ag-column-drop-vertical,\n.ag-theme-balham-dark .ag-column-drop-vertical,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical {\n  padding-top: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-balham .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-balham .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-balham-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-balham-dark .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-balham-auto-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-balham-auto-dark .ag-column-select-column-readonly .ag-icon-grip {\n  opacity: 0.35;\n}\n.ag-theme-balham .ag-menu-header,\n.ag-theme-balham-dark .ag-menu-header,\n.ag-theme-balham-auto-dark .ag-menu-header {\n  background-color: var(--ag-header-background-color);\n}\n.ag-theme-balham .ag-overlay-loading-center,\n.ag-theme-balham-dark .ag-overlay-loading-center,\n.ag-theme-balham-auto-dark .ag-overlay-loading-center {\n  background-color: var(--ag-background-color);\n  border: 1px solid var(--ag-border-color);\n  color: var(--ag-foreground-color);\n  padding: calc(var(--ag-grid-size) * 4);\n}\n.ag-theme-balham .ag-tooltip,\n.ag-theme-balham-dark .ag-tooltip,\n.ag-theme-balham-auto-dark .ag-tooltip {\n  border: none;\n}\n.ag-theme-balham .ag-panel-title-bar-button-icon,\n.ag-theme-balham-dark .ag-panel-title-bar-button-icon,\n.ag-theme-balham-auto-dark .ag-panel-title-bar-button-icon {\n  font-size: calc(var(--ag-icon-size) + var(--ag-grid-size));\n}\n.ag-theme-balham .ag-panel,\n.ag-theme-balham-dark .ag-panel,\n.ag-theme-balham-auto-dark .ag-panel {\n  background-color: var(--ag-header-background-color);\n}\n.ag-theme-balham .ag-chart-data-section,\n.ag-theme-balham .ag-chart-format-section,\n.ag-theme-balham .ag-chart-advanced-settings-section,\n.ag-theme-balham-dark .ag-chart-data-section,\n.ag-theme-balham-dark .ag-chart-format-section,\n.ag-theme-balham-dark .ag-chart-advanced-settings-section,\n.ag-theme-balham-auto-dark .ag-chart-data-section,\n.ag-theme-balham-auto-dark .ag-chart-format-section,\n.ag-theme-balham-auto-dark .ag-chart-advanced-settings-section {\n  padding-bottom: calc(var(--ag-grid-size) * 0.5);\n}\n.ag-theme-balham .ag-group-toolbar,\n.ag-theme-balham-dark .ag-group-toolbar,\n.ag-theme-balham-auto-dark .ag-group-toolbar {\n  background-color: var(--ag-subheader-toolbar-background-color);\n}\n.ag-theme-balham .ag-chart-tab,\n.ag-theme-balham-dark .ag-chart-tab,\n.ag-theme-balham-auto-dark .ag-chart-tab {\n  padding-top: calc(var(--ag-grid-size) * 0.5);\n}\n.ag-theme-balham .ag-charts-format-sub-level-group-item,\n.ag-theme-balham-dark .ag-charts-format-sub-level-group-item,\n.ag-theme-balham-auto-dark .ag-charts-format-sub-level-group-item {\n  margin-bottom: calc(var(--ag-grid-size) * 1.5);\n}\n.ag-theme-balham .ag-filter-active .ag-icon-filter,\n.ag-theme-balham-dark .ag-filter-active .ag-icon-filter,\n.ag-theme-balham-auto-dark .ag-filter-active .ag-icon-filter {\n  color: var(--ag-balham-active-color);\n}\n.ag-theme-balham .ag-color-input input[class^=ag-][type=text].ag-input-field-input,\n.ag-theme-balham-dark .ag-color-input input[class^=ag-][type=text].ag-input-field-input,\n.ag-theme-balham-auto-dark .ag-color-input input[class^=ag-][type=text].ag-input-field-input {\n  min-height: calc(var(--ag-icon-size) + 4px);\n}\n.ag-theme-balham .ag-list-item-hovered::after,\n.ag-theme-balham-dark .ag-list-item-hovered::after,\n.ag-theme-balham-auto-dark .ag-list-item-hovered::after {\n  background-color: var(--ag-balham-active-color);\n}\n.ag-theme-balham .ag-pill .ag-pill-button:hover,\n.ag-theme-balham-dark .ag-pill .ag-pill-button:hover,\n.ag-theme-balham-auto-dark .ag-pill .ag-pill-button:hover {\n  color: var(--ag-balham-active-color);\n}\n.ag-theme-balham .ag-header-highlight-before::after,\n.ag-theme-balham .ag-header-highlight-after::after,\n.ag-theme-balham-dark .ag-header-highlight-before::after,\n.ag-theme-balham-dark .ag-header-highlight-after::after,\n.ag-theme-balham-auto-dark .ag-header-highlight-before::after,\n.ag-theme-balham-auto-dark .ag-header-highlight-after::after {\n  background-color: var(--ag-balham-active-color);\n}\n', ""]), t2.A = i;
          }, 2621: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(9377), a2.b), c = i()(o()), g = s()(d);
            c.push([e2.id, '@font-face {\n  font-family: "agGridBalham";\n  src: url(' + g + ');\n  font-weight: normal;\n  font-style: normal;\n}\n.ag-theme-balham,\n.ag-theme-balham-dark,\n.ag-theme-balham-auto-dark {\n  --ag-balham-active-color: #0091ea;\n  --ag-foreground-color: #000;\n  --ag-background-color: #fff;\n  --ag-header-background-color: #f5f7f7;\n  --ag-tooltip-background-color: #cbd0d3;\n  --ag-subheader-background-color: #e2e9eb;\n  --ag-control-panel-background-color: #f5f7f7;\n  --ag-border-color: #bdc3c7;\n  --ag-odd-row-background-color: #fcfdfe;\n  --ag-row-hover-color: #ecf0f1;\n  --ag-column-hover-color: #ecf0f1;\n  --ag-input-border-color: #95a5a6;\n  --ag-invalid-color: #e02525;\n  --ag-input-disabled-background-color: #ebebeb;\n  --ag-checkbox-unchecked-color: #7f8c8d;\n  --ag-input-focus-border-color: #719ece;\n  --ag-advanced-filter-join-pill-color: #f08e8d;\n  --ag-advanced-filter-column-pill-color: #a6e194;\n  --ag-advanced-filter-option-pill-color: #f3c08b;\n  --ag-advanced-filter-value-pill-color: #85c0e4;\n  --ag-input-focus-box-shadow: 0 0 2px 1px var(--ag-input-focus-border-color);\n  --ag-range-selection-border-color: var(--ag-balham-active-color);\n  --ag-checkbox-checked-color: var(--ag-balham-active-color);\n  --ag-checkbox-background-color: var(--ag-background-color);\n  --ag-panel-background-color: var(--ag-header-background-color);\n  --ag-secondary-foreground-color: rgba(0, 0, 0, 0.54);\n  --ag-disabled-foreground-color: rgba(0, 0, 0, 0.38);\n  --ag-subheader-toolbar-background-color: rgba(226, 233, 235, 0.5);\n  --ag-row-border-color: rgba(189, 195, 199, 0.58);\n  --ag-chip-background-color: rgba(0, 0, 0, 0.1);\n  --ag-range-selection-background-color: rgba(0, 145, 234, 0.2);\n  --ag-range-selection-background-color-2: rgba(0, 145, 234, 0.36);\n  --ag-range-selection-background-color-3: rgba(0, 145, 234, 0.49);\n  --ag-range-selection-background-color-4: rgba(0, 145, 234, 0.59);\n  --ag-selected-row-background-color: rgba(0, 145, 234, 0.28);\n  --ag-header-column-separator-color: rgba(189, 195, 199, 0.5);\n  --ag-input-disabled-border-color: rgba(149, 165, 166, 0.3);\n  --ag-header-column-separator-display: block;\n  --ag-header-column-separator-height: 50%;\n  --ag-grid-size: 4px;\n  --ag-icon-size: 16px;\n  --ag-row-height: calc(var(--ag-grid-size) * 7);\n  --ag-header-height: calc(var(--ag-grid-size) * 8);\n  --ag-list-item-height: calc(var(--ag-grid-size) * 6);\n  --ag-row-group-indent-size: calc(var(--ag-grid-size) * 3 + var(--ag-icon-size));\n  --ag-cell-horizontal-padding: calc(var(--ag-grid-size) * 3);\n  --ag-input-height: calc(var(--ag-grid-size) * 4);\n  --ag-chart-menu-panel-width: 240px;\n  --ag-font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell,\n      "Helvetica Neue", sans-serif;\n  --ag-font-size: 12px;\n  --ag-icon-font-family: agGridBalham;\n  --ag-border-radius: 2px;\n  --ag-checkbox-border-radius: 3px;\n  --ag-card-shadow: none;\n}\n\n.ag-theme-balham-dark {\n  --ag-balham-active-color: #00b0ff;\n  --ag-foreground-color: #f5f5f5;\n  --ag-background-color: #2d3436;\n  --ag-header-background-color: #1c1c1c;\n  --ag-tooltip-background-color: #1c1f20;\n  --ag-subheader-background-color: #111;\n  --ag-control-panel-background-color: #202020;\n  --ag-border-color: #424242;\n  --ag-odd-row-background-color: #262c2e;\n  --ag-row-hover-color: #3d4749;\n  --ag-column-hover-color: #3d4749;\n  --ag-input-border-color: #f0f0f0;\n  --ag-input-disabled-background-color: rgba(48, 46, 46, 0.3);\n  --ag-modal-overlay-background-color: rgba(45, 52, 54, 0.66);\n  --ag-checkbox-unchecked-color: #ecf0f1;\n  --ag-advanced-filter-join-pill-color: #7a3a37;\n  --ag-advanced-filter-column-pill-color: #355f2d;\n  --ag-advanced-filter-option-pill-color: #5a3168;\n  --ag-advanced-filter-value-pill-color: #374c86;\n  --ag-secondary-foreground-color: var(--ag-foreground-color);\n  --ag-disabled-foreground-color: rgba(245, 245, 245, 0.38);\n  --ag-subheader-toolbar-background-color: rgba(17, 17, 17, 0.5);\n  --ag-row-border-color: #5c5c5c;\n  --ag-chip-background-color: rgba(245, 245, 245, 0.08);\n  --ag-range-selection-background-color: rgba(0, 176, 255, 0.2);\n  --ag-range-selection-background-color-2: rgba(0, 176, 255, 0.36);\n  --ag-range-selection-background-color-3: rgba(0, 176, 255, 0.49);\n  --ag-range-selection-background-color-4: rgba(0, 176, 255, 0.59);\n  --ag-selected-row-background-color: rgba(0, 176, 255, 0.28);\n  --ag-header-column-separator-color: rgba(66, 66, 66, 0.5);\n  --ag-input-disabled-border-color: rgba(240, 240, 240, 0.3);\n  --ag-header-foreground-color: rgba(245, 245, 245, 0.64);\n  --ag-toggle-button-off-background-color: transparent;\n  --ag-toggle-button-off-border-color: var(--ag-foreground-color);\n  --ag-range-selection-chart-category-background-color: rgba(26, 177, 74, 0.5);\n  --ag-range-selection-chart-background-color: rgba(45, 166, 255, 0.5);\n  --ag-input-focus-box-shadow: 0 0 4px 1.5px var(--ag-input-focus-border-color);\n  --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n  --csstools-color-scheme--dark: initial;\n  color-scheme: dark;\n}\n\n@media (prefers-color-scheme: dark) {\n  .ag-theme-balham-auto-dark {\n    --ag-balham-active-color: #00b0ff;\n    --ag-foreground-color: #f5f5f5;\n    --ag-background-color: #2d3436;\n    --ag-header-background-color: #1c1c1c;\n    --ag-tooltip-background-color: #1c1f20;\n    --ag-subheader-background-color: #111;\n    --ag-control-panel-background-color: #202020;\n    --ag-border-color: #424242;\n    --ag-odd-row-background-color: #262c2e;\n    --ag-row-hover-color: #3d4749;\n    --ag-column-hover-color: #3d4749;\n    --ag-input-border-color: #f0f0f0;\n    --ag-input-disabled-background-color: rgba(48, 46, 46, 0.3);\n    --ag-modal-overlay-background-color: rgba(45, 52, 54, 0.66);\n    --ag-checkbox-unchecked-color: #ecf0f1;\n    --ag-advanced-filter-join-pill-color: #7a3a37;\n    --ag-advanced-filter-column-pill-color: #355f2d;\n    --ag-advanced-filter-option-pill-color: #5a3168;\n    --ag-advanced-filter-value-pill-color: #374c86;\n    --ag-secondary-foreground-color: var(--ag-foreground-color);\n    --ag-disabled-foreground-color: rgba(245, 245, 245, 0.38);\n    --ag-subheader-toolbar-background-color: rgba(17, 17, 17, 0.5);\n    --ag-row-border-color: #5c5c5c;\n    --ag-chip-background-color: rgba(245, 245, 245, 0.08);\n    --ag-range-selection-background-color: rgba(0, 176, 255, 0.2);\n    --ag-range-selection-background-color-2: rgba(0, 176, 255, 0.36);\n    --ag-range-selection-background-color-3: rgba(0, 176, 255, 0.49);\n    --ag-range-selection-background-color-4: rgba(0, 176, 255, 0.59);\n    --ag-selected-row-background-color: rgba(0, 176, 255, 0.28);\n    --ag-header-column-separator-color: rgba(66, 66, 66, 0.5);\n    --ag-input-disabled-border-color: rgba(240, 240, 240, 0.3);\n    --ag-header-foreground-color: rgba(245, 245, 245, 0.64);\n    --ag-toggle-button-off-background-color: transparent;\n    --ag-toggle-button-off-border-color: var(--ag-foreground-color);\n    --ag-range-selection-chart-category-background-color: rgba(26, 177, 74, 0.5);\n    --ag-range-selection-chart-background-color: rgba(45, 166, 255, 0.5);\n    --ag-input-focus-box-shadow: 0 0 4px 1.5px var(--ag-input-focus-border-color);\n    --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n    --csstools-color-scheme--dark: initial;\n    color-scheme: dark;\n  }\n}\n.ag-theme-balham .ag-filter-toolpanel-header,\n.ag-theme-balham .ag-filter-toolpanel-search,\n.ag-theme-balham .ag-status-bar,\n.ag-theme-balham .ag-header-row,\n.ag-theme-balham .ag-multi-filter-group-title-bar,\n.ag-theme-balham-dark .ag-filter-toolpanel-header,\n.ag-theme-balham-dark .ag-filter-toolpanel-search,\n.ag-theme-balham-dark .ag-status-bar,\n.ag-theme-balham-dark .ag-header-row,\n.ag-theme-balham-dark .ag-multi-filter-group-title-bar,\n.ag-theme-balham-auto-dark .ag-filter-toolpanel-header,\n.ag-theme-balham-auto-dark .ag-filter-toolpanel-search,\n.ag-theme-balham-auto-dark .ag-status-bar,\n.ag-theme-balham-auto-dark .ag-header-row,\n.ag-theme-balham-auto-dark .ag-multi-filter-group-title-bar {\n  font-weight: 600;\n  color: var(--ag-header-foreground-color);\n}\n.ag-theme-balham .ag-ltr input[class^=ag-]:not([type]), .ag-theme-balham .ag-ltr input[class^=ag-][type=text], .ag-theme-balham .ag-ltr input[class^=ag-][type=number], .ag-theme-balham .ag-ltr input[class^=ag-][type=tel], .ag-theme-balham .ag-ltr input[class^=ag-][type=date], .ag-theme-balham .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-balham .ag-ltr textarea[class^=ag-], .ag-theme-balham-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-balham-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-balham-dark .ag-ltr textarea[class^=ag-], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-balham-auto-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-balham-auto-dark .ag-ltr textarea[class^=ag-] {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-balham .ag-rtl input[class^=ag-]:not([type]), .ag-theme-balham .ag-rtl input[class^=ag-][type=text], .ag-theme-balham .ag-rtl input[class^=ag-][type=number], .ag-theme-balham .ag-rtl input[class^=ag-][type=tel], .ag-theme-balham .ag-rtl input[class^=ag-][type=date], .ag-theme-balham .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-balham .ag-rtl textarea[class^=ag-], .ag-theme-balham-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-balham-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-balham-dark .ag-rtl textarea[class^=ag-], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-balham-auto-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-balham-auto-dark .ag-rtl textarea[class^=ag-] {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-balham .ag-column-drop-vertical-empty-message,\n.ag-theme-balham .ag-status-bar,\n.ag-theme-balham-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-balham-dark .ag-status-bar,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-balham-auto-dark .ag-status-bar {\n  font-weight: 600;\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-balham.ag-dnd-ghost,\n.ag-theme-balham-dark.ag-dnd-ghost,\n.ag-theme-balham-auto-dark.ag-dnd-ghost {\n  font-size: var(--ag-font-size);\n  font-weight: 600;\n}\n.ag-theme-balham .ag-tab,\n.ag-theme-balham-dark .ag-tab,\n.ag-theme-balham-auto-dark .ag-tab {\n  border: 1px solid transparent;\n  padding: var(--ag-grid-size) calc(var(--ag-grid-size) * 2);\n  margin: var(--ag-grid-size);\n  margin-bottom: -1px;\n}\n.ag-theme-balham .ag-tab-selected,\n.ag-theme-balham-dark .ag-tab-selected,\n.ag-theme-balham-auto-dark .ag-tab-selected {\n  background-color: var(--ag-background-color);\n  border-color: var(--ag-border-color);\n  border-bottom-color: transparent;\n}\n.ag-theme-balham .ag-tabs-header,\n.ag-theme-balham-dark .ag-tabs-header,\n.ag-theme-balham-auto-dark .ag-tabs-header {\n  border-bottom: 1px solid var(--ag-border-color);\n}\n.ag-theme-balham .ag-column-drop-cell,\n.ag-theme-balham-dark .ag-column-drop-cell,\n.ag-theme-balham-auto-dark .ag-column-drop-cell {\n  height: calc(var(--ag-grid-size) * 6);\n}\n.ag-theme-balham .ag-column-drop-vertical-title,\n.ag-theme-balham-dark .ag-column-drop-vertical-title,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-title {\n  color: var(--ag-foreground-color);\n}\n.ag-theme-balham .ag-column-drop-vertical-cell,\n.ag-theme-balham-dark .ag-column-drop-vertical-cell,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-cell {\n  margin-left: calc(var(--ag-grid-size) * 2);\n  margin-right: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-balham .ag-column-drop-vertical-cell-text,\n.ag-theme-balham-dark .ag-column-drop-vertical-cell-text,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-cell-text {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-balham .ag-column-drop-vertical-icon,\n.ag-theme-balham-dark .ag-column-drop-vertical-icon,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical-icon {\n  color: var(--ag-secondary-foreground-color);\n}\n.ag-theme-balham .ag-ltr .ag-column-drop-vertical-empty-message, .ag-theme-balham-dark .ag-ltr .ag-column-drop-vertical-empty-message, .ag-theme-balham-auto-dark .ag-ltr .ag-column-drop-vertical-empty-message {\n  padding-left: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-balham .ag-rtl .ag-column-drop-vertical-empty-message, .ag-theme-balham-dark .ag-rtl .ag-column-drop-vertical-empty-message, .ag-theme-balham-auto-dark .ag-rtl .ag-column-drop-vertical-empty-message {\n  padding-right: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-balham .ag-column-drop-horizontal,\n.ag-theme-balham-dark .ag-column-drop-horizontal,\n.ag-theme-balham-auto-dark .ag-column-drop-horizontal {\n  height: var(--ag-header-height);\n}\n.ag-theme-balham .ag-column-drop-empty,\n.ag-theme-balham-dark .ag-column-drop-empty,\n.ag-theme-balham-auto-dark .ag-column-drop-empty {\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-balham .ag-column-drop-horizontal-cell-text,\n.ag-theme-balham-dark .ag-column-drop-horizontal-cell-text,\n.ag-theme-balham-auto-dark .ag-column-drop-horizontal-cell-text {\n  margin-left: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-balham .ag-column-drop-vertical,\n.ag-theme-balham-dark .ag-column-drop-vertical,\n.ag-theme-balham-auto-dark .ag-column-drop-vertical {\n  padding-top: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-balham .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-balham .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-balham-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-balham-dark .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-balham-auto-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-balham-auto-dark .ag-column-select-column-readonly .ag-icon-grip {\n  opacity: 0.35;\n}\n.ag-theme-balham .ag-menu-header,\n.ag-theme-balham-dark .ag-menu-header,\n.ag-theme-balham-auto-dark .ag-menu-header {\n  background-color: var(--ag-header-background-color);\n}\n.ag-theme-balham .ag-overlay-loading-center,\n.ag-theme-balham-dark .ag-overlay-loading-center,\n.ag-theme-balham-auto-dark .ag-overlay-loading-center {\n  background-color: var(--ag-background-color);\n  border: 1px solid var(--ag-border-color);\n  color: var(--ag-foreground-color);\n  padding: calc(var(--ag-grid-size) * 4);\n}\n.ag-theme-balham .ag-tooltip,\n.ag-theme-balham-dark .ag-tooltip,\n.ag-theme-balham-auto-dark .ag-tooltip {\n  border: none;\n}\n.ag-theme-balham .ag-panel-title-bar-button-icon,\n.ag-theme-balham-dark .ag-panel-title-bar-button-icon,\n.ag-theme-balham-auto-dark .ag-panel-title-bar-button-icon {\n  font-size: calc(var(--ag-icon-size) + var(--ag-grid-size));\n}\n.ag-theme-balham .ag-panel,\n.ag-theme-balham-dark .ag-panel,\n.ag-theme-balham-auto-dark .ag-panel {\n  background-color: var(--ag-header-background-color);\n}\n.ag-theme-balham .ag-chart-data-section,\n.ag-theme-balham .ag-chart-format-section,\n.ag-theme-balham .ag-chart-advanced-settings-section,\n.ag-theme-balham-dark .ag-chart-data-section,\n.ag-theme-balham-dark .ag-chart-format-section,\n.ag-theme-balham-dark .ag-chart-advanced-settings-section,\n.ag-theme-balham-auto-dark .ag-chart-data-section,\n.ag-theme-balham-auto-dark .ag-chart-format-section,\n.ag-theme-balham-auto-dark .ag-chart-advanced-settings-section {\n  padding-bottom: calc(var(--ag-grid-size) * 0.5);\n}\n.ag-theme-balham .ag-group-toolbar,\n.ag-theme-balham-dark .ag-group-toolbar,\n.ag-theme-balham-auto-dark .ag-group-toolbar {\n  background-color: var(--ag-subheader-toolbar-background-color);\n}\n.ag-theme-balham .ag-chart-tab,\n.ag-theme-balham-dark .ag-chart-tab,\n.ag-theme-balham-auto-dark .ag-chart-tab {\n  padding-top: calc(var(--ag-grid-size) * 0.5);\n}\n.ag-theme-balham .ag-charts-format-sub-level-group-item,\n.ag-theme-balham-dark .ag-charts-format-sub-level-group-item,\n.ag-theme-balham-auto-dark .ag-charts-format-sub-level-group-item {\n  margin-bottom: calc(var(--ag-grid-size) * 1.5);\n}\n.ag-theme-balham .ag-filter-active .ag-icon-filter,\n.ag-theme-balham-dark .ag-filter-active .ag-icon-filter,\n.ag-theme-balham-auto-dark .ag-filter-active .ag-icon-filter {\n  color: var(--ag-balham-active-color);\n}\n.ag-theme-balham .ag-color-input input[class^=ag-][type=text].ag-input-field-input,\n.ag-theme-balham-dark .ag-color-input input[class^=ag-][type=text].ag-input-field-input,\n.ag-theme-balham-auto-dark .ag-color-input input[class^=ag-][type=text].ag-input-field-input {\n  min-height: calc(var(--ag-icon-size) + 4px);\n}\n.ag-theme-balham .ag-list-item-hovered::after,\n.ag-theme-balham-dark .ag-list-item-hovered::after,\n.ag-theme-balham-auto-dark .ag-list-item-hovered::after {\n  background-color: var(--ag-balham-active-color);\n}\n.ag-theme-balham .ag-pill .ag-pill-button:hover,\n.ag-theme-balham-dark .ag-pill .ag-pill-button:hover,\n.ag-theme-balham-auto-dark .ag-pill .ag-pill-button:hover {\n  color: var(--ag-balham-active-color);\n}\n.ag-theme-balham .ag-header-highlight-before::after,\n.ag-theme-balham .ag-header-highlight-after::after,\n.ag-theme-balham-dark .ag-header-highlight-before::after,\n.ag-theme-balham-dark .ag-header-highlight-after::after,\n.ag-theme-balham-auto-dark .ag-header-highlight-before::after,\n.ag-theme-balham-auto-dark .ag-header-highlight-after::after {\n  background-color: var(--ag-balham-active-color);\n}\n', ""]), t2.A = c;
          }, 8981: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r)()(o());
            i.push([e2.id, '.ag-theme-material,\n.ag-theme-material-dark,\n.ag-theme-material-auto-dark {\n  --ag-material-primary-color: #3f51b5;\n  --ag-material-accent-color: #ff4081;\n  --ag-foreground-color: rgba(0, 0, 0, 0.87);\n  --ag-secondary-foreground-color: rgba(0, 0, 0, 0.54);\n  --ag-disabled-foreground-color: rgba(0, 0, 0, 0.38);\n  --ag-background-color: #fff;\n  --ag-header-background-color: #fff;\n  --ag-tooltip-background-color: #fff;\n  --ag-subheader-background-color: #eee;\n  --ag-subheader-toolbar-background-color: rgba(238, 238, 238, 0.5);\n  --ag-header-cell-hover-background-color: #f2f2f2;\n  --ag-chip-background-color: #e2e2e2;\n  --ag-range-selection-background-color: rgba(122, 134, 203, 0.1);\n  --ag-range-selection-background-color-2: rgba(122, 134, 203, 0.19);\n  --ag-range-selection-background-color-3: rgba(122, 134, 203, 0.27);\n  --ag-range-selection-background-color-4: rgba(122, 134, 203, 0.34);\n  --ag-range-selection-highlight-color: #fce4ec;\n  --ag-row-hover-color: #fafafa;\n  --ag-column-hover-color: #fafafa;\n  --ag-control-panel-background-color: #fafafa;\n  --ag-selected-row-background-color: rgba(33, 150, 243, 0.3);\n  --ag-checkbox-unchecked-color: #333;\n  --ag-value-change-value-highlight-background-color: #00acc1;\n  --ag-side-button-selected-background-color: transparent;\n  --ag-advanced-filter-join-pill-color: #f08e8d;\n  --ag-advanced-filter-column-pill-color: #a6e194;\n  --ag-advanced-filter-option-pill-color: #f3c08b;\n  --ag-advanced-filter-value-pill-color: #85c0e4;\n  --ag-range-selection-border-color: var(--ag-material-primary-color);\n  --ag-checkbox-checked-color: var(--ag-material-accent-color);\n  --ag-borders: none;\n  --ag-borders-critical: solid 1px;\n  --ag-border-color: #e2e2e2;\n  --ag-grid-size: 8px;\n  --ag-icon-size: 18px;\n  --ag-header-height: calc(var(--ag-grid-size) * 7);\n  --ag-row-height: calc(var(--ag-grid-size) * 6);\n  --ag-cell-horizontal-padding: calc(var(--ag-grid-size) * 3);\n  --ag-list-item-height: calc(var(--ag-grid-size) * 4);\n  --ag-row-group-indent-size: calc(var(--ag-grid-size) * 3 + var(--ag-icon-size));\n  --ag-filter-tool-panel-sub-level-row-height: calc(var(--ag-grid-size) * 4);\n  --ag-checkbox-border-radius: 2px;\n  --ag-toggle-button-switch-border-width: 2px;\n  --ag-toggle-button-height: var(--ag-icon-size);\n  --ag-widget-container-horizontal-padding: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-container-vertical-padding: calc(var(--ag-grid-size) * 2);\n  --ag-widget-vertical-spacing: calc(var(--ag-grid-size) * 1.75);\n  --ag-font-family: Roboto, -apple-system, BlinkMacSystemFont, "Segoe UI", Oxygen-Sans, Ubuntu, Cantarell,\n      "Helvetica Neue", sans-serif;\n  --ag-font-size: 13px;\n  --ag-icon-font-family: agGridMaterial;\n  --ag-selected-tab-underline-color: var(--ag-material-primary-color);\n  --ag-selected-tab-underline-width: 2px;\n  --ag-input-focus-border-color: var(--ag-material-primary-color);\n  --ag-input-focus-box-shadow: 0 0 0 5px rgba(32, 33, 36, 0.122);\n  --ag-card-shadow: 0 3px 1px -2px rgba(0, 0, 0, 0.2), 0 2px 2px 0 rgba(0, 0, 0, 0.14),\n      0 1px 5px 0 rgba(0, 0, 0, 0.12);\n  --ag-card-radius: 2px;\n  --ag-invalid-color: #e02525;\n}\n\n.ag-theme-material-dark {\n  --ag-material-primary-color: #3f51b5;\n  --ag-material-accent-color: rgba(187,134,252,1);\n  --ag-range-selection-border-color: var(--ag-material-accent-color);\n  --ag-background-color: rgba(18,18,18,1);\n  --ag-foreground-color: rgba(255,255,255,1);\n  --ag-data-color: rgba(245,245,245,1);\n  --ag-header-cell-hover-background-color: rgba(0,0,0,1);\n  --ag-advanced-filter-join-pill-color: rgba(122,58,55,1);\n  --ag-advanced-filter-column-pill-color: rgba(53,95,45,1);\n  --ag-advanced-filter-option-pill-color: rgba(90,49,104,1);\n  --ag-advanced-filter-value-pill-color: rgba(55,76,134,1);\n  --ag-input-disabled-border-color: rgba(58,67,78,1);\n  --ag-input-disabled-background-color: rgba(104,104,110,0.07059);\n  --ag-selected-row-background-color: rgba(187,134,252,0.2);\n  --ag-row-hover-color: rgba(187,134,252,0.2);\n  --ag-column-hover-color: rgba(245,245,245,0.05098);\n  --ag-range-selection-background-color: rgba(187,134,252,0.10196);\n  --ag-range-selection-background-color-2: rgba(187,134,252,0.18824);\n  --ag-range-selection-background-color-3: rgba(187,134,252,0.27059);\n  --ag-range-selection-background-color-4: rgba(187,134,252,0.34118);\n  --ag-border-color: rgba(56,56,56,1);\n  --ag-secondary-border-color: rgba(56,56,56,1);\n  --ag-header-background-color: rgba(18,18,18,1);\n  --ag-tooltip-background-color: rgba(33,43,56,1);\n  --ag-odd-row-background-color: rgba(18,18,18,1);\n  --ag-control-panel-background-color: rgba(44,44,44,1);\n  --ag-subheader-background-color: rgba(255,255,255,0.05098);\n  --ag-subheader-toolbar-background-color: rgba(44,44,44,1);\n  --ag-invalid-color: rgba(224,37,37,1);\n  --ag-checkbox-unchecked-color: rgba(121,126,135,1);\n  --ag-checkbox-background-color: rgba(18,18,18,1);\n  --ag-secondary-foreground-color: rgba(245,245,245,1);\n  --ag-input-border-color: rgba(56,56,56,1);\n  --ag-input-border-color-invalid: rgba(224,37,37,1);\n  --ag-disabled-foreground-color: rgba(245,245,245,0.50196);\n  --ag-chip-background-color: rgba(34,38,40,0.07059);\n  --ag-side-button-selected-background-color: rgba(44,44,44,1);\n  --ag-selected-tab-underline-color: rgba(63,81,181,1);\n  --ag-modal-overlay-background-color: rgba(18,18,18,0.65882);\n  --ag-value-change-delta-up-color: rgba(67,160,71,0.65882);\n  --ag-value-change-delta-down-color: rgba(229,57,53,1);\n  --ag-menu-background-color: rgba(44,44,44,1);\n  --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n  --csstools-color-scheme--dark: initial;\n  color-scheme: dark;\n}\n\n@media (prefers-color-scheme: dark) {\n  .ag-theme-material-auto-dark {\n    --ag-material-primary-color: #3f51b5;\n    --ag-material-accent-color: rgba(187,134,252,1);\n    --ag-range-selection-border-color: var(--ag-material-accent-color);\n    --ag-background-color: rgba(18,18,18,1);\n    --ag-foreground-color: rgba(255,255,255,1);\n    --ag-data-color: rgba(245,245,245,1);\n    --ag-header-cell-hover-background-color: rgba(0,0,0,1);\n    --ag-advanced-filter-join-pill-color: rgba(122,58,55,1);\n    --ag-advanced-filter-column-pill-color: rgba(53,95,45,1);\n    --ag-advanced-filter-option-pill-color: rgba(90,49,104,1);\n    --ag-advanced-filter-value-pill-color: rgba(55,76,134,1);\n    --ag-input-disabled-border-color: rgba(58,67,78,1);\n    --ag-input-disabled-background-color: rgba(104,104,110,0.07059);\n    --ag-selected-row-background-color: rgba(187,134,252,0.2);\n    --ag-row-hover-color: rgba(187,134,252,0.2);\n    --ag-column-hover-color: rgba(245,245,245,0.05098);\n    --ag-range-selection-background-color: rgba(187,134,252,0.10196);\n    --ag-range-selection-background-color-2: rgba(187,134,252,0.18824);\n    --ag-range-selection-background-color-3: rgba(187,134,252,0.27059);\n    --ag-range-selection-background-color-4: rgba(187,134,252,0.34118);\n    --ag-border-color: rgba(56,56,56,1);\n    --ag-secondary-border-color: rgba(56,56,56,1);\n    --ag-header-background-color: rgba(18,18,18,1);\n    --ag-tooltip-background-color: rgba(33,43,56,1);\n    --ag-odd-row-background-color: rgba(18,18,18,1);\n    --ag-control-panel-background-color: rgba(44,44,44,1);\n    --ag-subheader-background-color: rgba(255,255,255,0.05098);\n    --ag-subheader-toolbar-background-color: rgba(44,44,44,1);\n    --ag-invalid-color: rgba(224,37,37,1);\n    --ag-checkbox-unchecked-color: rgba(121,126,135,1);\n    --ag-checkbox-background-color: rgba(18,18,18,1);\n    --ag-secondary-foreground-color: rgba(245,245,245,1);\n    --ag-input-border-color: rgba(56,56,56,1);\n    --ag-input-border-color-invalid: rgba(224,37,37,1);\n    --ag-disabled-foreground-color: rgba(245,245,245,0.50196);\n    --ag-chip-background-color: rgba(34,38,40,0.07059);\n    --ag-side-button-selected-background-color: rgba(44,44,44,1);\n    --ag-selected-tab-underline-color: rgba(63,81,181,1);\n    --ag-modal-overlay-background-color: rgba(18,18,18,0.65882);\n    --ag-value-change-delta-up-color: rgba(67,160,71,0.65882);\n    --ag-value-change-delta-down-color: rgba(229,57,53,1);\n    --ag-menu-background-color: rgba(44,44,44,1);\n    --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n    --csstools-color-scheme--dark: initial;\n    color-scheme: dark;\n  }\n}\n.ag-theme-material .ag-filter-toolpanel-header,\n.ag-theme-material .ag-filter-toolpanel-search,\n.ag-theme-material .ag-status-bar,\n.ag-theme-material .ag-header-row,\n.ag-theme-material .ag-panel-title-bar-title,\n.ag-theme-material .ag-multi-filter-group-title-bar,\n.ag-theme-material-dark .ag-filter-toolpanel-header,\n.ag-theme-material-dark .ag-filter-toolpanel-search,\n.ag-theme-material-dark .ag-status-bar,\n.ag-theme-material-dark .ag-header-row,\n.ag-theme-material-dark .ag-panel-title-bar-title,\n.ag-theme-material-dark .ag-multi-filter-group-title-bar,\n.ag-theme-material-auto-dark .ag-filter-toolpanel-header,\n.ag-theme-material-auto-dark .ag-filter-toolpanel-search,\n.ag-theme-material-auto-dark .ag-status-bar,\n.ag-theme-material-auto-dark .ag-header-row,\n.ag-theme-material-auto-dark .ag-panel-title-bar-title,\n.ag-theme-material-auto-dark .ag-multi-filter-group-title-bar {\n  font-size: calc(var(--ag-font-size) - 1px);\n  font-weight: 600;\n  color: var(--ag-header-foreground-color);\n}\n.ag-theme-material .ag-tab,\n.ag-theme-material-dark .ag-tab,\n.ag-theme-material-auto-dark .ag-tab {\n  height: calc(var(--ag-grid-size) * 4.5);\n  flex: 1 1 auto;\n}\n.ag-theme-material .ag-tabs-header,\n.ag-theme-material .ag-column-drop-horizontal,\n.ag-theme-material-dark .ag-tabs-header,\n.ag-theme-material-dark .ag-column-drop-horizontal,\n.ag-theme-material-auto-dark .ag-tabs-header,\n.ag-theme-material-auto-dark .ag-column-drop-horizontal {\n  background-color: var(--ag-subheader-background-color);\n}\n.ag-theme-material .ag-tabs-body,\n.ag-theme-material-dark .ag-tabs-body,\n.ag-theme-material-auto-dark .ag-tabs-body {\n  padding: calc(var(--ag-grid-size) * 0.5) 0;\n}\n.ag-theme-material .ag-tabs-body .ag-menu-list,\n.ag-theme-material-dark .ag-tabs-body .ag-menu-list,\n.ag-theme-material-auto-dark .ag-tabs-body .ag-menu-list {\n  padding-top: 0;\n  padding-bottom: 0;\n}\n.ag-theme-material .ag-header-cell,\n.ag-theme-material .ag-header-group-cell,\n.ag-theme-material-dark .ag-header-cell,\n.ag-theme-material-dark .ag-header-group-cell,\n.ag-theme-material-auto-dark .ag-header-cell,\n.ag-theme-material-auto-dark .ag-header-group-cell {\n  transition: background-color 0.5s;\n}\n.ag-theme-material .ag-row-last:not(.ag-row-first) .ag-cell-inline-editing,\n.ag-theme-material-dark .ag-row-last:not(.ag-row-first) .ag-cell-inline-editing,\n.ag-theme-material-auto-dark .ag-row-last:not(.ag-row-first) .ag-cell-inline-editing {\n  bottom: 0;\n}\n.ag-theme-material .ag-cell-inline-editing,\n.ag-theme-material-dark .ag-cell-inline-editing,\n.ag-theme-material-auto-dark .ag-cell-inline-editing {\n  padding: var(--ag-grid-size);\n  height: calc(var(--ag-row-height) + var(--ag-grid-size) * 3);\n  border-color: var(--ag-border-color) !important;\n}\n.ag-theme-material .ag-has-focus .ag-cell-inline-editing,\n.ag-theme-material-dark .ag-has-focus .ag-cell-inline-editing,\n.ag-theme-material-auto-dark .ag-has-focus .ag-cell-inline-editing {\n  border-color: var(--ag-input-focus-border-color) !important;\n}\n.ag-theme-material .ag-column-drop-vertical,\n.ag-theme-material-dark .ag-column-drop-vertical,\n.ag-theme-material-auto-dark .ag-column-drop-vertical {\n  border-bottom: solid 1px;\n  border-bottom-color: var(--ag-border-color);\n  padding-top: var(--ag-grid-size);\n}\n.ag-theme-material .ag-column-drop-vertical.ag-last-column-drop,\n.ag-theme-material-dark .ag-column-drop-vertical.ag-last-column-drop,\n.ag-theme-material-auto-dark .ag-column-drop-vertical.ag-last-column-drop {\n  border-bottom: none;\n}\n.ag-theme-material .ag-column-drop-vertical-cell,\n.ag-theme-material-dark .ag-column-drop-vertical-cell,\n.ag-theme-material-auto-dark .ag-column-drop-vertical-cell {\n  margin-left: 0;\n}\n.ag-theme-material .ag-column-drop-vertical-empty-message,\n.ag-theme-material-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-material-auto-dark .ag-column-drop-vertical-empty-message {\n  font-size: calc(var(--ag-font-size) - 1px);\n  font-weight: 600;\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-material .ag-ltr .ag-column-drop-vertical-empty-message, .ag-theme-material-dark .ag-ltr .ag-column-drop-vertical-empty-message, .ag-theme-material-auto-dark .ag-ltr .ag-column-drop-vertical-empty-message {\n  padding-left: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-material .ag-rtl .ag-column-drop-vertical-empty-message, .ag-theme-material-dark .ag-rtl .ag-column-drop-vertical-empty-message, .ag-theme-material-auto-dark .ag-rtl .ag-column-drop-vertical-empty-message {\n  padding-right: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-material .ag-status-bar,\n.ag-theme-material-dark .ag-status-bar,\n.ag-theme-material-auto-dark .ag-status-bar {\n  border: solid 1px;\n  border-color: var(--ag-border-color);\n}\n.ag-theme-material .ag-column-panel-column-select,\n.ag-theme-material-dark .ag-column-panel-column-select,\n.ag-theme-material-auto-dark .ag-column-panel-column-select {\n  border-top: solid 1px;\n  border-top-color: var(--ag-border-color);\n}\n.ag-theme-material .ag-column-select,\n.ag-theme-material .ag-column-select-header,\n.ag-theme-material-dark .ag-column-select,\n.ag-theme-material-dark .ag-column-select-header,\n.ag-theme-material-auto-dark .ag-column-select,\n.ag-theme-material-auto-dark .ag-column-select-header {\n  border-bottom: solid 1px;\n  border-bottom-color: var(--ag-border-color);\n}\n.ag-theme-material .ag-column-select-header,\n.ag-theme-material-dark .ag-column-select-header,\n.ag-theme-material-auto-dark .ag-column-select-header {\n  height: var(--ag-header-height);\n}\n.ag-theme-material .ag-group-title-bar,\n.ag-theme-material-dark .ag-group-title-bar,\n.ag-theme-material-auto-dark .ag-group-title-bar {\n  padding: calc(var(--ag-grid-size) * 0.75) var(--ag-grid-size);\n}\n.ag-theme-material .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-material-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-material-auto-dark .ag-charts-format-sub-level-group-title-bar {\n  padding: calc(var(--ag-grid-size) * 0.5) var(--ag-grid-size);\n}\n.ag-theme-material .ag-chart-data-section,\n.ag-theme-material .ag-chart-format-section,\n.ag-theme-material .ag-chart-advanced-settings-section,\n.ag-theme-material-dark .ag-chart-data-section,\n.ag-theme-material-dark .ag-chart-format-section,\n.ag-theme-material-dark .ag-chart-advanced-settings-section,\n.ag-theme-material-auto-dark .ag-chart-data-section,\n.ag-theme-material-auto-dark .ag-chart-format-section,\n.ag-theme-material-auto-dark .ag-chart-advanced-settings-section {\n  padding-bottom: calc(var(--ag-grid-size) * 0.5);\n}\n.ag-theme-material input[class^=ag-]:not([type]),\n.ag-theme-material input[class^=ag-][type=text],\n.ag-theme-material input[class^=ag-][type=number],\n.ag-theme-material input[class^=ag-][type=tel],\n.ag-theme-material input[class^=ag-][type=date],\n.ag-theme-material input[class^=ag-][type=datetime-local],\n.ag-theme-material textarea[class^=ag-],\n.ag-theme-material-dark input[class^=ag-]:not([type]),\n.ag-theme-material-dark input[class^=ag-][type=text],\n.ag-theme-material-dark input[class^=ag-][type=number],\n.ag-theme-material-dark input[class^=ag-][type=tel],\n.ag-theme-material-dark input[class^=ag-][type=date],\n.ag-theme-material-dark input[class^=ag-][type=datetime-local],\n.ag-theme-material-dark textarea[class^=ag-],\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]),\n.ag-theme-material-auto-dark input[class^=ag-][type=text],\n.ag-theme-material-auto-dark input[class^=ag-][type=number],\n.ag-theme-material-auto-dark input[class^=ag-][type=tel],\n.ag-theme-material-auto-dark input[class^=ag-][type=date],\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local],\n.ag-theme-material-auto-dark textarea[class^=ag-] {\n  background: transparent;\n  color: var(--ag-foreground-color);\n  font-family: inherit;\n  font-size: inherit;\n  padding-bottom: var(--ag-grid-size);\n  border-width: 0;\n  border-radius: 0;\n  border-bottom: 2px solid;\n  border-bottom-color: var(--ag-border-color);\n}\n.ag-theme-material input[class^=ag-]:not([type]):not(textarea),\n.ag-theme-material input[class^=ag-][type=text]:not(textarea),\n.ag-theme-material input[class^=ag-][type=number]:not(textarea),\n.ag-theme-material input[class^=ag-][type=tel]:not(textarea),\n.ag-theme-material input[class^=ag-][type=date]:not(textarea),\n.ag-theme-material input[class^=ag-][type=datetime-local]:not(textarea),\n.ag-theme-material textarea[class^=ag-]:not(textarea),\n.ag-theme-material-dark input[class^=ag-]:not([type]):not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=text]:not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=number]:not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=tel]:not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=date]:not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]:not(textarea),\n.ag-theme-material-dark textarea[class^=ag-]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]):not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=text]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=number]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=date]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]:not(textarea),\n.ag-theme-material-auto-dark textarea[class^=ag-]:not(textarea) {\n  height: calc(var(--ag-grid-size) * 5);\n}\n.ag-theme-material input[class^=ag-]:not([type]):focus,\n.ag-theme-material input[class^=ag-][type=text]:focus,\n.ag-theme-material input[class^=ag-][type=number]:focus,\n.ag-theme-material input[class^=ag-][type=tel]:focus,\n.ag-theme-material input[class^=ag-][type=date]:focus,\n.ag-theme-material input[class^=ag-][type=datetime-local]:focus,\n.ag-theme-material textarea[class^=ag-]:focus,\n.ag-theme-material-dark input[class^=ag-]:not([type]):focus,\n.ag-theme-material-dark input[class^=ag-][type=text]:focus,\n.ag-theme-material-dark input[class^=ag-][type=number]:focus,\n.ag-theme-material-dark input[class^=ag-][type=tel]:focus,\n.ag-theme-material-dark input[class^=ag-][type=date]:focus,\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]:focus,\n.ag-theme-material-dark textarea[class^=ag-]:focus,\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]):focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=text]:focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=number]:focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]:focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=date]:focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]:focus,\n.ag-theme-material-auto-dark textarea[class^=ag-]:focus {\n  border-bottom: 2px solid;\n  border-bottom-color: var(--ag-material-primary-color);\n  outline: none;\n  box-shadow: none;\n}\n.ag-theme-material input[class^=ag-]:not([type])::-moz-placeholder, .ag-theme-material input[class^=ag-][type=text]::-moz-placeholder, .ag-theme-material input[class^=ag-][type=number]::-moz-placeholder, .ag-theme-material input[class^=ag-][type=tel]::-moz-placeholder, .ag-theme-material input[class^=ag-][type=date]::-moz-placeholder, .ag-theme-material input[class^=ag-][type=datetime-local]::-moz-placeholder, .ag-theme-material textarea[class^=ag-]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-]:not([type])::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=text]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=number]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=tel]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=date]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=datetime-local]::-moz-placeholder, .ag-theme-material-dark textarea[class^=ag-]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-]:not([type])::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=text]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=number]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=tel]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=date]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]::-moz-placeholder, .ag-theme-material-auto-dark textarea[class^=ag-]::-moz-placeholder {\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-material input[class^=ag-]:not([type])::placeholder,\n.ag-theme-material input[class^=ag-][type=text]::placeholder,\n.ag-theme-material input[class^=ag-][type=number]::placeholder,\n.ag-theme-material input[class^=ag-][type=tel]::placeholder,\n.ag-theme-material input[class^=ag-][type=date]::placeholder,\n.ag-theme-material input[class^=ag-][type=datetime-local]::placeholder,\n.ag-theme-material textarea[class^=ag-]::placeholder,\n.ag-theme-material-dark input[class^=ag-]:not([type])::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=text]::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=number]::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=tel]::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=date]::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]::placeholder,\n.ag-theme-material-dark textarea[class^=ag-]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-]:not([type])::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=text]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=number]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=date]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]::placeholder,\n.ag-theme-material-auto-dark textarea[class^=ag-]::placeholder {\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-material input[class^=ag-]:not([type]):disabled,\n.ag-theme-material input[class^=ag-][type=text]:disabled,\n.ag-theme-material input[class^=ag-][type=number]:disabled,\n.ag-theme-material input[class^=ag-][type=tel]:disabled,\n.ag-theme-material input[class^=ag-][type=date]:disabled,\n.ag-theme-material input[class^=ag-][type=datetime-local]:disabled,\n.ag-theme-material textarea[class^=ag-]:disabled,\n.ag-theme-material-dark input[class^=ag-]:not([type]):disabled,\n.ag-theme-material-dark input[class^=ag-][type=text]:disabled,\n.ag-theme-material-dark input[class^=ag-][type=number]:disabled,\n.ag-theme-material-dark input[class^=ag-][type=tel]:disabled,\n.ag-theme-material-dark input[class^=ag-][type=date]:disabled,\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]:disabled,\n.ag-theme-material-dark textarea[class^=ag-]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]):disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=text]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=number]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=date]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]:disabled,\n.ag-theme-material-auto-dark textarea[class^=ag-]:disabled {\n  border-bottom: 1px solid;\n  border-bottom-color: var(--ag-border-color);\n}\n.ag-theme-material input[class^=ag-]:not([type]):invalid,\n.ag-theme-material input[class^=ag-][type=text]:invalid,\n.ag-theme-material input[class^=ag-][type=number]:invalid,\n.ag-theme-material input[class^=ag-][type=tel]:invalid,\n.ag-theme-material input[class^=ag-][type=date]:invalid,\n.ag-theme-material input[class^=ag-][type=datetime-local]:invalid,\n.ag-theme-material textarea[class^=ag-]:invalid,\n.ag-theme-material-dark input[class^=ag-]:not([type]):invalid,\n.ag-theme-material-dark input[class^=ag-][type=text]:invalid,\n.ag-theme-material-dark input[class^=ag-][type=number]:invalid,\n.ag-theme-material-dark input[class^=ag-][type=tel]:invalid,\n.ag-theme-material-dark input[class^=ag-][type=date]:invalid,\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]:invalid,\n.ag-theme-material-dark textarea[class^=ag-]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]):invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=text]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=number]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=date]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]:invalid,\n.ag-theme-material-auto-dark textarea[class^=ag-]:invalid {\n  border-width: 0;\n  border-bottom: 1px solid;\n  border-bottom-color: var(--ag-invalid-color);\n  color: var(--ag-invalid-color);\n}\n.ag-theme-material .ag-standard-button,\n.ag-theme-material-dark .ag-standard-button,\n.ag-theme-material-auto-dark .ag-standard-button {\n  -webkit-appearance: none;\n     -moz-appearance: none;\n          appearance: none;\n  background-color: transparent;\n  border: 0;\n  color: var(--ag-material-primary-color);\n  font-family: inherit;\n  font-size: inherit;\n  margin: 0;\n  padding: 0;\n  text-transform: uppercase;\n}\n.ag-theme-material .ag-standard-button:disabled,\n.ag-theme-material-dark .ag-standard-button:disabled,\n.ag-theme-material-auto-dark .ag-standard-button:disabled {\n  color: var(--ag-disabled-foreground-color);\n  background-color: var(--ag-input-disabled-background-color);\n  border-color: var(--ag-input-disabled-border-color);\n}\n.ag-theme-material.ag-dnd-ghost,\n.ag-theme-material-dark.ag-dnd-ghost,\n.ag-theme-material-auto-dark.ag-dnd-ghost {\n  font-size: calc(var(--ag-font-size) - 1px);\n  font-weight: 600;\n}\n.ag-theme-material .ag-filter-toolpanel-header,\n.ag-theme-material-dark .ag-filter-toolpanel-header,\n.ag-theme-material-auto-dark .ag-filter-toolpanel-header {\n  height: calc(var(--ag-grid-size) * 4);\n}\n.ag-theme-material .ag-filter-toolpanel-group-level-0-header,\n.ag-theme-material-dark .ag-filter-toolpanel-group-level-0-header,\n.ag-theme-material-auto-dark .ag-filter-toolpanel-group-level-0-header {\n  height: calc(var(--ag-grid-size) * 7);\n}\n.ag-theme-material .ag-ltr .ag-filter-apply-panel-button, .ag-theme-material .ag-ltr .ag-advanced-filter-apply-button, .ag-theme-material .ag-ltr .ag-advanced-filter-builder-button, .ag-theme-material-dark .ag-ltr .ag-filter-apply-panel-button, .ag-theme-material-dark .ag-ltr .ag-advanced-filter-apply-button, .ag-theme-material-dark .ag-ltr .ag-advanced-filter-builder-button, .ag-theme-material-auto-dark .ag-ltr .ag-filter-apply-panel-button, .ag-theme-material-auto-dark .ag-ltr .ag-advanced-filter-apply-button, .ag-theme-material-auto-dark .ag-ltr .ag-advanced-filter-builder-button {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-material .ag-rtl .ag-filter-apply-panel-button, .ag-theme-material .ag-rtl .ag-advanced-filter-apply-button, .ag-theme-material .ag-rtl .ag-advanced-filter-builder-button, .ag-theme-material-dark .ag-rtl .ag-filter-apply-panel-button, .ag-theme-material-dark .ag-rtl .ag-advanced-filter-apply-button, .ag-theme-material-dark .ag-rtl .ag-advanced-filter-builder-button, .ag-theme-material-auto-dark .ag-rtl .ag-filter-apply-panel-button, .ag-theme-material-auto-dark .ag-rtl .ag-advanced-filter-apply-button, .ag-theme-material-auto-dark .ag-rtl .ag-advanced-filter-builder-button {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-material .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-material .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-material .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-material .ag-layout-print .ag-center-cols-container,\n.ag-theme-material-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-material-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-material-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-material-dark .ag-layout-print .ag-center-cols-container,\n.ag-theme-material-auto-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-material-auto-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-material-auto-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-material-auto-dark .ag-layout-print .ag-center-cols-container {\n  min-height: 150px;\n}\n.ag-theme-material .ag-picker-field-wrapper:focus-within,\n.ag-theme-material-dark .ag-picker-field-wrapper:focus-within,\n.ag-theme-material-auto-dark .ag-picker-field-wrapper:focus-within {\n  box-shadow: 0 0 0 1px var(--ag-material-primary-color);\n}\n.ag-theme-material .ag-rich-select-list,\n.ag-theme-material-dark .ag-rich-select-list,\n.ag-theme-material-auto-dark .ag-rich-select-list {\n  box-shadow: rgba(0, 0, 0, 0.2) 0px 5px 5px -3px, rgba(0, 0, 0, 0.14) 0px 8px 10px 1px, rgba(0, 0, 0, 0.12) 0px 3px 14px 2px;\n}\n.ag-theme-material .ag-advanced-filter-builder-button-label,\n.ag-theme-material-dark .ag-advanced-filter-builder-button-label,\n.ag-theme-material-auto-dark .ag-advanced-filter-builder-button-label {\n  text-transform: uppercase;\n}\n.ag-theme-material .ag-filter-active .ag-icon-filter,\n.ag-theme-material-dark .ag-filter-active .ag-icon-filter,\n.ag-theme-material-auto-dark .ag-filter-active .ag-icon-filter {\n  color: var(--ag-material-accent-color);\n}\n.ag-theme-material .ag-list-item-hovered::after,\n.ag-theme-material-dark .ag-list-item-hovered::after,\n.ag-theme-material-auto-dark .ag-list-item-hovered::after {\n  background-color: var(--ag-material-primary-color);\n}\n.ag-theme-material .ag-pill .ag-pill-button:hover,\n.ag-theme-material-dark .ag-pill .ag-pill-button:hover,\n.ag-theme-material-auto-dark .ag-pill .ag-pill-button:hover {\n  color: var(--ag-material-primary-color);\n}\n.ag-theme-material .ag-header-highlight-before::after,\n.ag-theme-material .ag-header-highlight-after::after,\n.ag-theme-material-dark .ag-header-highlight-before::after,\n.ag-theme-material-dark .ag-header-highlight-after::after,\n.ag-theme-material-auto-dark .ag-header-highlight-before::after,\n.ag-theme-material-auto-dark .ag-header-highlight-after::after {\n  background-color: var(--ag-material-primary-color);\n}\n', ""]), t2.A = i;
          }, 2935: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(6055), a2.b), c = i()(o()), g = s()(d);
            c.push([e2.id, '@font-face {\n  font-family: "agGridMaterial";\n  src: url(' + g + ');\n  font-weight: normal;\n  font-style: normal;\n}\n.ag-theme-material,\n.ag-theme-material-dark,\n.ag-theme-material-auto-dark {\n  --ag-material-primary-color: #3f51b5;\n  --ag-material-accent-color: #ff4081;\n  --ag-foreground-color: rgba(0, 0, 0, 0.87);\n  --ag-secondary-foreground-color: rgba(0, 0, 0, 0.54);\n  --ag-disabled-foreground-color: rgba(0, 0, 0, 0.38);\n  --ag-background-color: #fff;\n  --ag-header-background-color: #fff;\n  --ag-tooltip-background-color: #fff;\n  --ag-subheader-background-color: #eee;\n  --ag-subheader-toolbar-background-color: rgba(238, 238, 238, 0.5);\n  --ag-header-cell-hover-background-color: #f2f2f2;\n  --ag-chip-background-color: #e2e2e2;\n  --ag-range-selection-background-color: rgba(122, 134, 203, 0.1);\n  --ag-range-selection-background-color-2: rgba(122, 134, 203, 0.19);\n  --ag-range-selection-background-color-3: rgba(122, 134, 203, 0.27);\n  --ag-range-selection-background-color-4: rgba(122, 134, 203, 0.34);\n  --ag-range-selection-highlight-color: #fce4ec;\n  --ag-row-hover-color: #fafafa;\n  --ag-column-hover-color: #fafafa;\n  --ag-control-panel-background-color: #fafafa;\n  --ag-selected-row-background-color: rgba(33, 150, 243, 0.3);\n  --ag-checkbox-unchecked-color: #333;\n  --ag-value-change-value-highlight-background-color: #00acc1;\n  --ag-side-button-selected-background-color: transparent;\n  --ag-advanced-filter-join-pill-color: #f08e8d;\n  --ag-advanced-filter-column-pill-color: #a6e194;\n  --ag-advanced-filter-option-pill-color: #f3c08b;\n  --ag-advanced-filter-value-pill-color: #85c0e4;\n  --ag-range-selection-border-color: var(--ag-material-primary-color);\n  --ag-checkbox-checked-color: var(--ag-material-accent-color);\n  --ag-borders: none;\n  --ag-borders-critical: solid 1px;\n  --ag-border-color: #e2e2e2;\n  --ag-grid-size: 8px;\n  --ag-icon-size: 18px;\n  --ag-header-height: calc(var(--ag-grid-size) * 7);\n  --ag-row-height: calc(var(--ag-grid-size) * 6);\n  --ag-cell-horizontal-padding: calc(var(--ag-grid-size) * 3);\n  --ag-list-item-height: calc(var(--ag-grid-size) * 4);\n  --ag-row-group-indent-size: calc(var(--ag-grid-size) * 3 + var(--ag-icon-size));\n  --ag-filter-tool-panel-sub-level-row-height: calc(var(--ag-grid-size) * 4);\n  --ag-checkbox-border-radius: 2px;\n  --ag-toggle-button-switch-border-width: 2px;\n  --ag-toggle-button-height: var(--ag-icon-size);\n  --ag-widget-container-horizontal-padding: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-container-vertical-padding: calc(var(--ag-grid-size) * 2);\n  --ag-widget-vertical-spacing: calc(var(--ag-grid-size) * 1.75);\n  --ag-font-family: Roboto, -apple-system, BlinkMacSystemFont, "Segoe UI", Oxygen-Sans, Ubuntu, Cantarell,\n      "Helvetica Neue", sans-serif;\n  --ag-font-size: 13px;\n  --ag-icon-font-family: agGridMaterial;\n  --ag-selected-tab-underline-color: var(--ag-material-primary-color);\n  --ag-selected-tab-underline-width: 2px;\n  --ag-input-focus-border-color: var(--ag-material-primary-color);\n  --ag-input-focus-box-shadow: 0 0 0 5px rgba(32, 33, 36, 0.122);\n  --ag-card-shadow: 0 3px 1px -2px rgba(0, 0, 0, 0.2), 0 2px 2px 0 rgba(0, 0, 0, 0.14),\n      0 1px 5px 0 rgba(0, 0, 0, 0.12);\n  --ag-card-radius: 2px;\n  --ag-invalid-color: #e02525;\n}\n\n.ag-theme-material-dark {\n  --ag-material-primary-color: #3f51b5;\n  --ag-material-accent-color: rgba(187,134,252,1);\n  --ag-range-selection-border-color: var(--ag-material-accent-color);\n  --ag-background-color: rgba(18,18,18,1);\n  --ag-foreground-color: rgba(255,255,255,1);\n  --ag-data-color: rgba(245,245,245,1);\n  --ag-header-cell-hover-background-color: rgba(0,0,0,1);\n  --ag-advanced-filter-join-pill-color: rgba(122,58,55,1);\n  --ag-advanced-filter-column-pill-color: rgba(53,95,45,1);\n  --ag-advanced-filter-option-pill-color: rgba(90,49,104,1);\n  --ag-advanced-filter-value-pill-color: rgba(55,76,134,1);\n  --ag-input-disabled-border-color: rgba(58,67,78,1);\n  --ag-input-disabled-background-color: rgba(104,104,110,0.07059);\n  --ag-selected-row-background-color: rgba(187,134,252,0.2);\n  --ag-row-hover-color: rgba(187,134,252,0.2);\n  --ag-column-hover-color: rgba(245,245,245,0.05098);\n  --ag-range-selection-background-color: rgba(187,134,252,0.10196);\n  --ag-range-selection-background-color-2: rgba(187,134,252,0.18824);\n  --ag-range-selection-background-color-3: rgba(187,134,252,0.27059);\n  --ag-range-selection-background-color-4: rgba(187,134,252,0.34118);\n  --ag-border-color: rgba(56,56,56,1);\n  --ag-secondary-border-color: rgba(56,56,56,1);\n  --ag-header-background-color: rgba(18,18,18,1);\n  --ag-tooltip-background-color: rgba(33,43,56,1);\n  --ag-odd-row-background-color: rgba(18,18,18,1);\n  --ag-control-panel-background-color: rgba(44,44,44,1);\n  --ag-subheader-background-color: rgba(255,255,255,0.05098);\n  --ag-subheader-toolbar-background-color: rgba(44,44,44,1);\n  --ag-invalid-color: rgba(224,37,37,1);\n  --ag-checkbox-unchecked-color: rgba(121,126,135,1);\n  --ag-checkbox-background-color: rgba(18,18,18,1);\n  --ag-secondary-foreground-color: rgba(245,245,245,1);\n  --ag-input-border-color: rgba(56,56,56,1);\n  --ag-input-border-color-invalid: rgba(224,37,37,1);\n  --ag-disabled-foreground-color: rgba(245,245,245,0.50196);\n  --ag-chip-background-color: rgba(34,38,40,0.07059);\n  --ag-side-button-selected-background-color: rgba(44,44,44,1);\n  --ag-selected-tab-underline-color: rgba(63,81,181,1);\n  --ag-modal-overlay-background-color: rgba(18,18,18,0.65882);\n  --ag-value-change-delta-up-color: rgba(67,160,71,0.65882);\n  --ag-value-change-delta-down-color: rgba(229,57,53,1);\n  --ag-menu-background-color: rgba(44,44,44,1);\n  --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n  --csstools-color-scheme--dark: initial;\n  color-scheme: dark;\n}\n\n@media (prefers-color-scheme: dark) {\n  .ag-theme-material-auto-dark {\n    --ag-material-primary-color: #3f51b5;\n    --ag-material-accent-color: rgba(187,134,252,1);\n    --ag-range-selection-border-color: var(--ag-material-accent-color);\n    --ag-background-color: rgba(18,18,18,1);\n    --ag-foreground-color: rgba(255,255,255,1);\n    --ag-data-color: rgba(245,245,245,1);\n    --ag-header-cell-hover-background-color: rgba(0,0,0,1);\n    --ag-advanced-filter-join-pill-color: rgba(122,58,55,1);\n    --ag-advanced-filter-column-pill-color: rgba(53,95,45,1);\n    --ag-advanced-filter-option-pill-color: rgba(90,49,104,1);\n    --ag-advanced-filter-value-pill-color: rgba(55,76,134,1);\n    --ag-input-disabled-border-color: rgba(58,67,78,1);\n    --ag-input-disabled-background-color: rgba(104,104,110,0.07059);\n    --ag-selected-row-background-color: rgba(187,134,252,0.2);\n    --ag-row-hover-color: rgba(187,134,252,0.2);\n    --ag-column-hover-color: rgba(245,245,245,0.05098);\n    --ag-range-selection-background-color: rgba(187,134,252,0.10196);\n    --ag-range-selection-background-color-2: rgba(187,134,252,0.18824);\n    --ag-range-selection-background-color-3: rgba(187,134,252,0.27059);\n    --ag-range-selection-background-color-4: rgba(187,134,252,0.34118);\n    --ag-border-color: rgba(56,56,56,1);\n    --ag-secondary-border-color: rgba(56,56,56,1);\n    --ag-header-background-color: rgba(18,18,18,1);\n    --ag-tooltip-background-color: rgba(33,43,56,1);\n    --ag-odd-row-background-color: rgba(18,18,18,1);\n    --ag-control-panel-background-color: rgba(44,44,44,1);\n    --ag-subheader-background-color: rgba(255,255,255,0.05098);\n    --ag-subheader-toolbar-background-color: rgba(44,44,44,1);\n    --ag-invalid-color: rgba(224,37,37,1);\n    --ag-checkbox-unchecked-color: rgba(121,126,135,1);\n    --ag-checkbox-background-color: rgba(18,18,18,1);\n    --ag-secondary-foreground-color: rgba(245,245,245,1);\n    --ag-input-border-color: rgba(56,56,56,1);\n    --ag-input-border-color-invalid: rgba(224,37,37,1);\n    --ag-disabled-foreground-color: rgba(245,245,245,0.50196);\n    --ag-chip-background-color: rgba(34,38,40,0.07059);\n    --ag-side-button-selected-background-color: rgba(44,44,44,1);\n    --ag-selected-tab-underline-color: rgba(63,81,181,1);\n    --ag-modal-overlay-background-color: rgba(18,18,18,0.65882);\n    --ag-value-change-delta-up-color: rgba(67,160,71,0.65882);\n    --ag-value-change-delta-down-color: rgba(229,57,53,1);\n    --ag-menu-background-color: rgba(44,44,44,1);\n    --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n    --csstools-color-scheme--dark: initial;\n    color-scheme: dark;\n  }\n}\n.ag-theme-material .ag-filter-toolpanel-header,\n.ag-theme-material .ag-filter-toolpanel-search,\n.ag-theme-material .ag-status-bar,\n.ag-theme-material .ag-header-row,\n.ag-theme-material .ag-panel-title-bar-title,\n.ag-theme-material .ag-multi-filter-group-title-bar,\n.ag-theme-material-dark .ag-filter-toolpanel-header,\n.ag-theme-material-dark .ag-filter-toolpanel-search,\n.ag-theme-material-dark .ag-status-bar,\n.ag-theme-material-dark .ag-header-row,\n.ag-theme-material-dark .ag-panel-title-bar-title,\n.ag-theme-material-dark .ag-multi-filter-group-title-bar,\n.ag-theme-material-auto-dark .ag-filter-toolpanel-header,\n.ag-theme-material-auto-dark .ag-filter-toolpanel-search,\n.ag-theme-material-auto-dark .ag-status-bar,\n.ag-theme-material-auto-dark .ag-header-row,\n.ag-theme-material-auto-dark .ag-panel-title-bar-title,\n.ag-theme-material-auto-dark .ag-multi-filter-group-title-bar {\n  font-size: calc(var(--ag-font-size) - 1px);\n  font-weight: 600;\n  color: var(--ag-header-foreground-color);\n}\n.ag-theme-material .ag-tab,\n.ag-theme-material-dark .ag-tab,\n.ag-theme-material-auto-dark .ag-tab {\n  height: calc(var(--ag-grid-size) * 4.5);\n  flex: 1 1 auto;\n}\n.ag-theme-material .ag-tabs-header,\n.ag-theme-material .ag-column-drop-horizontal,\n.ag-theme-material-dark .ag-tabs-header,\n.ag-theme-material-dark .ag-column-drop-horizontal,\n.ag-theme-material-auto-dark .ag-tabs-header,\n.ag-theme-material-auto-dark .ag-column-drop-horizontal {\n  background-color: var(--ag-subheader-background-color);\n}\n.ag-theme-material .ag-tabs-body,\n.ag-theme-material-dark .ag-tabs-body,\n.ag-theme-material-auto-dark .ag-tabs-body {\n  padding: calc(var(--ag-grid-size) * 0.5) 0;\n}\n.ag-theme-material .ag-tabs-body .ag-menu-list,\n.ag-theme-material-dark .ag-tabs-body .ag-menu-list,\n.ag-theme-material-auto-dark .ag-tabs-body .ag-menu-list {\n  padding-top: 0;\n  padding-bottom: 0;\n}\n.ag-theme-material .ag-header-cell,\n.ag-theme-material .ag-header-group-cell,\n.ag-theme-material-dark .ag-header-cell,\n.ag-theme-material-dark .ag-header-group-cell,\n.ag-theme-material-auto-dark .ag-header-cell,\n.ag-theme-material-auto-dark .ag-header-group-cell {\n  transition: background-color 0.5s;\n}\n.ag-theme-material .ag-row-last:not(.ag-row-first) .ag-cell-inline-editing,\n.ag-theme-material-dark .ag-row-last:not(.ag-row-first) .ag-cell-inline-editing,\n.ag-theme-material-auto-dark .ag-row-last:not(.ag-row-first) .ag-cell-inline-editing {\n  bottom: 0;\n}\n.ag-theme-material .ag-cell-inline-editing,\n.ag-theme-material-dark .ag-cell-inline-editing,\n.ag-theme-material-auto-dark .ag-cell-inline-editing {\n  padding: var(--ag-grid-size);\n  height: calc(var(--ag-row-height) + var(--ag-grid-size) * 3);\n  border-color: var(--ag-border-color) !important;\n}\n.ag-theme-material .ag-has-focus .ag-cell-inline-editing,\n.ag-theme-material-dark .ag-has-focus .ag-cell-inline-editing,\n.ag-theme-material-auto-dark .ag-has-focus .ag-cell-inline-editing {\n  border-color: var(--ag-input-focus-border-color) !important;\n}\n.ag-theme-material .ag-column-drop-vertical,\n.ag-theme-material-dark .ag-column-drop-vertical,\n.ag-theme-material-auto-dark .ag-column-drop-vertical {\n  border-bottom: solid 1px;\n  border-bottom-color: var(--ag-border-color);\n  padding-top: var(--ag-grid-size);\n}\n.ag-theme-material .ag-column-drop-vertical.ag-last-column-drop,\n.ag-theme-material-dark .ag-column-drop-vertical.ag-last-column-drop,\n.ag-theme-material-auto-dark .ag-column-drop-vertical.ag-last-column-drop {\n  border-bottom: none;\n}\n.ag-theme-material .ag-column-drop-vertical-cell,\n.ag-theme-material-dark .ag-column-drop-vertical-cell,\n.ag-theme-material-auto-dark .ag-column-drop-vertical-cell {\n  margin-left: 0;\n}\n.ag-theme-material .ag-column-drop-vertical-empty-message,\n.ag-theme-material-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-material-auto-dark .ag-column-drop-vertical-empty-message {\n  font-size: calc(var(--ag-font-size) - 1px);\n  font-weight: 600;\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-material .ag-ltr .ag-column-drop-vertical-empty-message, .ag-theme-material-dark .ag-ltr .ag-column-drop-vertical-empty-message, .ag-theme-material-auto-dark .ag-ltr .ag-column-drop-vertical-empty-message {\n  padding-left: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-material .ag-rtl .ag-column-drop-vertical-empty-message, .ag-theme-material-dark .ag-rtl .ag-column-drop-vertical-empty-message, .ag-theme-material-auto-dark .ag-rtl .ag-column-drop-vertical-empty-message {\n  padding-right: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-material .ag-status-bar,\n.ag-theme-material-dark .ag-status-bar,\n.ag-theme-material-auto-dark .ag-status-bar {\n  border: solid 1px;\n  border-color: var(--ag-border-color);\n}\n.ag-theme-material .ag-column-panel-column-select,\n.ag-theme-material-dark .ag-column-panel-column-select,\n.ag-theme-material-auto-dark .ag-column-panel-column-select {\n  border-top: solid 1px;\n  border-top-color: var(--ag-border-color);\n}\n.ag-theme-material .ag-column-select,\n.ag-theme-material .ag-column-select-header,\n.ag-theme-material-dark .ag-column-select,\n.ag-theme-material-dark .ag-column-select-header,\n.ag-theme-material-auto-dark .ag-column-select,\n.ag-theme-material-auto-dark .ag-column-select-header {\n  border-bottom: solid 1px;\n  border-bottom-color: var(--ag-border-color);\n}\n.ag-theme-material .ag-column-select-header,\n.ag-theme-material-dark .ag-column-select-header,\n.ag-theme-material-auto-dark .ag-column-select-header {\n  height: var(--ag-header-height);\n}\n.ag-theme-material .ag-group-title-bar,\n.ag-theme-material-dark .ag-group-title-bar,\n.ag-theme-material-auto-dark .ag-group-title-bar {\n  padding: calc(var(--ag-grid-size) * 0.75) var(--ag-grid-size);\n}\n.ag-theme-material .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-material-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-material-auto-dark .ag-charts-format-sub-level-group-title-bar {\n  padding: calc(var(--ag-grid-size) * 0.5) var(--ag-grid-size);\n}\n.ag-theme-material .ag-chart-data-section,\n.ag-theme-material .ag-chart-format-section,\n.ag-theme-material .ag-chart-advanced-settings-section,\n.ag-theme-material-dark .ag-chart-data-section,\n.ag-theme-material-dark .ag-chart-format-section,\n.ag-theme-material-dark .ag-chart-advanced-settings-section,\n.ag-theme-material-auto-dark .ag-chart-data-section,\n.ag-theme-material-auto-dark .ag-chart-format-section,\n.ag-theme-material-auto-dark .ag-chart-advanced-settings-section {\n  padding-bottom: calc(var(--ag-grid-size) * 0.5);\n}\n.ag-theme-material input[class^=ag-]:not([type]),\n.ag-theme-material input[class^=ag-][type=text],\n.ag-theme-material input[class^=ag-][type=number],\n.ag-theme-material input[class^=ag-][type=tel],\n.ag-theme-material input[class^=ag-][type=date],\n.ag-theme-material input[class^=ag-][type=datetime-local],\n.ag-theme-material textarea[class^=ag-],\n.ag-theme-material-dark input[class^=ag-]:not([type]),\n.ag-theme-material-dark input[class^=ag-][type=text],\n.ag-theme-material-dark input[class^=ag-][type=number],\n.ag-theme-material-dark input[class^=ag-][type=tel],\n.ag-theme-material-dark input[class^=ag-][type=date],\n.ag-theme-material-dark input[class^=ag-][type=datetime-local],\n.ag-theme-material-dark textarea[class^=ag-],\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]),\n.ag-theme-material-auto-dark input[class^=ag-][type=text],\n.ag-theme-material-auto-dark input[class^=ag-][type=number],\n.ag-theme-material-auto-dark input[class^=ag-][type=tel],\n.ag-theme-material-auto-dark input[class^=ag-][type=date],\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local],\n.ag-theme-material-auto-dark textarea[class^=ag-] {\n  background: transparent;\n  color: var(--ag-foreground-color);\n  font-family: inherit;\n  font-size: inherit;\n  padding-bottom: var(--ag-grid-size);\n  border-width: 0;\n  border-radius: 0;\n  border-bottom: 2px solid;\n  border-bottom-color: var(--ag-border-color);\n}\n.ag-theme-material input[class^=ag-]:not([type]):not(textarea),\n.ag-theme-material input[class^=ag-][type=text]:not(textarea),\n.ag-theme-material input[class^=ag-][type=number]:not(textarea),\n.ag-theme-material input[class^=ag-][type=tel]:not(textarea),\n.ag-theme-material input[class^=ag-][type=date]:not(textarea),\n.ag-theme-material input[class^=ag-][type=datetime-local]:not(textarea),\n.ag-theme-material textarea[class^=ag-]:not(textarea),\n.ag-theme-material-dark input[class^=ag-]:not([type]):not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=text]:not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=number]:not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=tel]:not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=date]:not(textarea),\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]:not(textarea),\n.ag-theme-material-dark textarea[class^=ag-]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]):not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=text]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=number]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=date]:not(textarea),\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]:not(textarea),\n.ag-theme-material-auto-dark textarea[class^=ag-]:not(textarea) {\n  height: calc(var(--ag-grid-size) * 5);\n}\n.ag-theme-material input[class^=ag-]:not([type]):focus,\n.ag-theme-material input[class^=ag-][type=text]:focus,\n.ag-theme-material input[class^=ag-][type=number]:focus,\n.ag-theme-material input[class^=ag-][type=tel]:focus,\n.ag-theme-material input[class^=ag-][type=date]:focus,\n.ag-theme-material input[class^=ag-][type=datetime-local]:focus,\n.ag-theme-material textarea[class^=ag-]:focus,\n.ag-theme-material-dark input[class^=ag-]:not([type]):focus,\n.ag-theme-material-dark input[class^=ag-][type=text]:focus,\n.ag-theme-material-dark input[class^=ag-][type=number]:focus,\n.ag-theme-material-dark input[class^=ag-][type=tel]:focus,\n.ag-theme-material-dark input[class^=ag-][type=date]:focus,\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]:focus,\n.ag-theme-material-dark textarea[class^=ag-]:focus,\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]):focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=text]:focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=number]:focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]:focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=date]:focus,\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]:focus,\n.ag-theme-material-auto-dark textarea[class^=ag-]:focus {\n  border-bottom: 2px solid;\n  border-bottom-color: var(--ag-material-primary-color);\n  outline: none;\n  box-shadow: none;\n}\n.ag-theme-material input[class^=ag-]:not([type])::-moz-placeholder, .ag-theme-material input[class^=ag-][type=text]::-moz-placeholder, .ag-theme-material input[class^=ag-][type=number]::-moz-placeholder, .ag-theme-material input[class^=ag-][type=tel]::-moz-placeholder, .ag-theme-material input[class^=ag-][type=date]::-moz-placeholder, .ag-theme-material input[class^=ag-][type=datetime-local]::-moz-placeholder, .ag-theme-material textarea[class^=ag-]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-]:not([type])::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=text]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=number]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=tel]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=date]::-moz-placeholder, .ag-theme-material-dark input[class^=ag-][type=datetime-local]::-moz-placeholder, .ag-theme-material-dark textarea[class^=ag-]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-]:not([type])::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=text]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=number]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=tel]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=date]::-moz-placeholder, .ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]::-moz-placeholder, .ag-theme-material-auto-dark textarea[class^=ag-]::-moz-placeholder {\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-material input[class^=ag-]:not([type])::placeholder,\n.ag-theme-material input[class^=ag-][type=text]::placeholder,\n.ag-theme-material input[class^=ag-][type=number]::placeholder,\n.ag-theme-material input[class^=ag-][type=tel]::placeholder,\n.ag-theme-material input[class^=ag-][type=date]::placeholder,\n.ag-theme-material input[class^=ag-][type=datetime-local]::placeholder,\n.ag-theme-material textarea[class^=ag-]::placeholder,\n.ag-theme-material-dark input[class^=ag-]:not([type])::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=text]::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=number]::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=tel]::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=date]::placeholder,\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]::placeholder,\n.ag-theme-material-dark textarea[class^=ag-]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-]:not([type])::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=text]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=number]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=date]::placeholder,\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]::placeholder,\n.ag-theme-material-auto-dark textarea[class^=ag-]::placeholder {\n  color: var(--ag-disabled-foreground-color);\n}\n.ag-theme-material input[class^=ag-]:not([type]):disabled,\n.ag-theme-material input[class^=ag-][type=text]:disabled,\n.ag-theme-material input[class^=ag-][type=number]:disabled,\n.ag-theme-material input[class^=ag-][type=tel]:disabled,\n.ag-theme-material input[class^=ag-][type=date]:disabled,\n.ag-theme-material input[class^=ag-][type=datetime-local]:disabled,\n.ag-theme-material textarea[class^=ag-]:disabled,\n.ag-theme-material-dark input[class^=ag-]:not([type]):disabled,\n.ag-theme-material-dark input[class^=ag-][type=text]:disabled,\n.ag-theme-material-dark input[class^=ag-][type=number]:disabled,\n.ag-theme-material-dark input[class^=ag-][type=tel]:disabled,\n.ag-theme-material-dark input[class^=ag-][type=date]:disabled,\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]:disabled,\n.ag-theme-material-dark textarea[class^=ag-]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]):disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=text]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=number]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=date]:disabled,\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]:disabled,\n.ag-theme-material-auto-dark textarea[class^=ag-]:disabled {\n  border-bottom: 1px solid;\n  border-bottom-color: var(--ag-border-color);\n}\n.ag-theme-material input[class^=ag-]:not([type]):invalid,\n.ag-theme-material input[class^=ag-][type=text]:invalid,\n.ag-theme-material input[class^=ag-][type=number]:invalid,\n.ag-theme-material input[class^=ag-][type=tel]:invalid,\n.ag-theme-material input[class^=ag-][type=date]:invalid,\n.ag-theme-material input[class^=ag-][type=datetime-local]:invalid,\n.ag-theme-material textarea[class^=ag-]:invalid,\n.ag-theme-material-dark input[class^=ag-]:not([type]):invalid,\n.ag-theme-material-dark input[class^=ag-][type=text]:invalid,\n.ag-theme-material-dark input[class^=ag-][type=number]:invalid,\n.ag-theme-material-dark input[class^=ag-][type=tel]:invalid,\n.ag-theme-material-dark input[class^=ag-][type=date]:invalid,\n.ag-theme-material-dark input[class^=ag-][type=datetime-local]:invalid,\n.ag-theme-material-dark textarea[class^=ag-]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-]:not([type]):invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=text]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=number]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=tel]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=date]:invalid,\n.ag-theme-material-auto-dark input[class^=ag-][type=datetime-local]:invalid,\n.ag-theme-material-auto-dark textarea[class^=ag-]:invalid {\n  border-width: 0;\n  border-bottom: 1px solid;\n  border-bottom-color: var(--ag-invalid-color);\n  color: var(--ag-invalid-color);\n}\n.ag-theme-material .ag-standard-button,\n.ag-theme-material-dark .ag-standard-button,\n.ag-theme-material-auto-dark .ag-standard-button {\n  -webkit-appearance: none;\n     -moz-appearance: none;\n          appearance: none;\n  background-color: transparent;\n  border: 0;\n  color: var(--ag-material-primary-color);\n  font-family: inherit;\n  font-size: inherit;\n  margin: 0;\n  padding: 0;\n  text-transform: uppercase;\n}\n.ag-theme-material .ag-standard-button:disabled,\n.ag-theme-material-dark .ag-standard-button:disabled,\n.ag-theme-material-auto-dark .ag-standard-button:disabled {\n  color: var(--ag-disabled-foreground-color);\n  background-color: var(--ag-input-disabled-background-color);\n  border-color: var(--ag-input-disabled-border-color);\n}\n.ag-theme-material.ag-dnd-ghost,\n.ag-theme-material-dark.ag-dnd-ghost,\n.ag-theme-material-auto-dark.ag-dnd-ghost {\n  font-size: calc(var(--ag-font-size) - 1px);\n  font-weight: 600;\n}\n.ag-theme-material .ag-filter-toolpanel-header,\n.ag-theme-material-dark .ag-filter-toolpanel-header,\n.ag-theme-material-auto-dark .ag-filter-toolpanel-header {\n  height: calc(var(--ag-grid-size) * 4);\n}\n.ag-theme-material .ag-filter-toolpanel-group-level-0-header,\n.ag-theme-material-dark .ag-filter-toolpanel-group-level-0-header,\n.ag-theme-material-auto-dark .ag-filter-toolpanel-group-level-0-header {\n  height: calc(var(--ag-grid-size) * 7);\n}\n.ag-theme-material .ag-ltr .ag-filter-apply-panel-button, .ag-theme-material .ag-ltr .ag-advanced-filter-apply-button, .ag-theme-material .ag-ltr .ag-advanced-filter-builder-button, .ag-theme-material-dark .ag-ltr .ag-filter-apply-panel-button, .ag-theme-material-dark .ag-ltr .ag-advanced-filter-apply-button, .ag-theme-material-dark .ag-ltr .ag-advanced-filter-builder-button, .ag-theme-material-auto-dark .ag-ltr .ag-filter-apply-panel-button, .ag-theme-material-auto-dark .ag-ltr .ag-advanced-filter-apply-button, .ag-theme-material-auto-dark .ag-ltr .ag-advanced-filter-builder-button {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-material .ag-rtl .ag-filter-apply-panel-button, .ag-theme-material .ag-rtl .ag-advanced-filter-apply-button, .ag-theme-material .ag-rtl .ag-advanced-filter-builder-button, .ag-theme-material-dark .ag-rtl .ag-filter-apply-panel-button, .ag-theme-material-dark .ag-rtl .ag-advanced-filter-apply-button, .ag-theme-material-dark .ag-rtl .ag-advanced-filter-builder-button, .ag-theme-material-auto-dark .ag-rtl .ag-filter-apply-panel-button, .ag-theme-material-auto-dark .ag-rtl .ag-advanced-filter-apply-button, .ag-theme-material-auto-dark .ag-rtl .ag-advanced-filter-builder-button {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-material .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-material .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-material .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-material .ag-layout-print .ag-center-cols-container,\n.ag-theme-material-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-material-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-material-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-material-dark .ag-layout-print .ag-center-cols-container,\n.ag-theme-material-auto-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-material-auto-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-material-auto-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-material-auto-dark .ag-layout-print .ag-center-cols-container {\n  min-height: 150px;\n}\n.ag-theme-material .ag-picker-field-wrapper:focus-within,\n.ag-theme-material-dark .ag-picker-field-wrapper:focus-within,\n.ag-theme-material-auto-dark .ag-picker-field-wrapper:focus-within {\n  box-shadow: 0 0 0 1px var(--ag-material-primary-color);\n}\n.ag-theme-material .ag-rich-select-list,\n.ag-theme-material-dark .ag-rich-select-list,\n.ag-theme-material-auto-dark .ag-rich-select-list {\n  box-shadow: rgba(0, 0, 0, 0.2) 0px 5px 5px -3px, rgba(0, 0, 0, 0.14) 0px 8px 10px 1px, rgba(0, 0, 0, 0.12) 0px 3px 14px 2px;\n}\n.ag-theme-material .ag-advanced-filter-builder-button-label,\n.ag-theme-material-dark .ag-advanced-filter-builder-button-label,\n.ag-theme-material-auto-dark .ag-advanced-filter-builder-button-label {\n  text-transform: uppercase;\n}\n.ag-theme-material .ag-filter-active .ag-icon-filter,\n.ag-theme-material-dark .ag-filter-active .ag-icon-filter,\n.ag-theme-material-auto-dark .ag-filter-active .ag-icon-filter {\n  color: var(--ag-material-accent-color);\n}\n.ag-theme-material .ag-list-item-hovered::after,\n.ag-theme-material-dark .ag-list-item-hovered::after,\n.ag-theme-material-auto-dark .ag-list-item-hovered::after {\n  background-color: var(--ag-material-primary-color);\n}\n.ag-theme-material .ag-pill .ag-pill-button:hover,\n.ag-theme-material-dark .ag-pill .ag-pill-button:hover,\n.ag-theme-material-auto-dark .ag-pill .ag-pill-button:hover {\n  color: var(--ag-material-primary-color);\n}\n.ag-theme-material .ag-header-highlight-before::after,\n.ag-theme-material .ag-header-highlight-after::after,\n.ag-theme-material-dark .ag-header-highlight-before::after,\n.ag-theme-material-dark .ag-header-highlight-after::after,\n.ag-theme-material-auto-dark .ag-header-highlight-before::after,\n.ag-theme-material-auto-dark .ag-header-highlight-after::after {\n  background-color: var(--ag-material-primary-color);\n}\n', ""]), t2.A = c;
          }, 7899: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(7249), a2.b), c = i()(o()), g = s()(d);
            c.push([e2.id, '.ag-theme-quartz,\n.ag-theme-quartz-dark,\n.ag-theme-quartz-auto-dark {\n  --ag-active-color: #2196f3;\n  --ag-background-color: #fff;\n  --ag-foreground-color: #181d1f;\n  --ag-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 15%);\n  --ag-secondary-border-color: var(--ag-border-color);\n  --ag-header-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 2%);\n  --ag-tooltip-background-color: var(--ag-header-background-color);\n  --ag-control-panel-background-color: var(--ag-header-background-color);\n  --ag-subheader-background-color: transparent;\n  --ag-invalid-color: #e02525;\n  --ag-checkbox-unchecked-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 30%);\n  --ag-advanced-filter-join-pill-color: #f08e8d;\n  --ag-advanced-filter-column-pill-color: #a6e194;\n  --ag-advanced-filter-option-pill-color: #f3c08b;\n  --ag-advanced-filter-value-pill-color: #85c0e4;\n  --ag-header-column-resize-handle-color: var(--ag-secondary-border-color);\n  --ag-icon-font-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 90%);\n  --ag-panel-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 3%);\n  --ag-panel-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 20%);\n  --ag-menu-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 3%);\n  --ag-menu-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 20%);\n  --ag-selected-row-background-color: color-mix(in srgb, transparent, var(--ag-active-color) 8%);\n  --ag-row-hover-color: color-mix(in srgb, transparent, var(--ag-active-color) 12%);\n  --ag-column-hover-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 5%);\n  --ag-input-focus-border-color: var(--ag-active-color);\n  --ag-input-focus-box-shadow: 0 0 0 3px color-mix(in srgb, transparent, var(--ag-input-focus-border-color) 47%);\n  --ag-range-selection-background-color: color-mix(in srgb, transparent, var(--ag-active-color) 20%);\n  --ag-range-selection-background-color-2: color-mix(in srgb, transparent, var(--ag-active-color) 36%);\n  --ag-range-selection-background-color-3: color-mix(in srgb, transparent, var(--ag-active-color) 49%);\n  --ag-range-selection-background-color-4: color-mix(in srgb, transparent, var(--ag-active-color) 59%);\n  --ag-checkbox-background-color: var(--ag-background-color);\n  --ag-checkbox-checked-color: var(--ag-active-color);\n  --ag-range-selection-border-color: var(--ag-active-color);\n  --ag-secondary-foreground-color: var(--ag-foreground-color);\n  --ag-input-border-color: var(--ag-border-color);\n  --ag-input-border-color-invalid: var(--ag-invalid-color);\n  --ag-disabled-foreground-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 50%);\n  --ag-chip-background-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 7%);\n  --ag-chip-border-color: color-mix(in srgb, var(--ag-header-background-color), var(--ag-foreground-color) 13%);\n  --ag-input-disabled-border-color: var(--ag-border-color);\n  --ag-input-disabled-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 6%);\n  --ag-modal-overlay-background-color: color-mix(in srgb, transparent, var(--ag-background-color) 66%);\n  --ag-chart-menu-label-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 80%);\n  --ag-chart-menu-pill-select-button-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 70%);\n  --ag-borders: solid 1px;\n  --ag-border-radius: 4px;\n  --ag-wrapper-border-radius: 8px;\n  --ag-borders-side-button: none;\n  --ag-side-button-selected-background-color: transparent;\n  --ag-header-column-resize-handle-display: block;\n  --ag-header-column-resize-handle-width: 2px;\n  --ag-header-column-resize-handle-height: 30%;\n  --ag-grid-size: 8px;\n  --ag-icon-size: 16px;\n  --ag-header-height: calc(var(--ag-font-size) + var(--ag-grid-size) * 4.25);\n  --ag-row-height: calc(var(--ag-font-size) + var(--ag-grid-size) * 3.5);\n  --ag-list-item-height: calc(\n      var(--ag-icon-size) + var(--ag-widget-vertical-spacing)\n  );\n  --ag-column-select-indent-size: var(--ag-icon-size);\n  --ag-set-filter-indent-size: var(--ag-icon-size);\n  --ag-filter-tool-panel-group-indent: var(--ag-grid-size);\n  --ag-advanced-filter-builder-indent-size: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  --ag-cell-horizontal-padding: calc(var(--ag-grid-size) * 2);\n  --ag-cell-widget-spacing: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-container-vertical-padding: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-container-horizontal-padding: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-horizontal-spacing: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-vertical-spacing: calc(var(--ag-grid-size) * 1);\n  --ag-toggle-button-height: 18px;\n  --ag-toggle-button-width: 28px;\n  --ag-toggle-button-border-width: 2px;\n  --ag-font-family: "IBM Plex Sans", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu,\n      Cantarell, "Helvetica Neue", sans-serif;\n  --ag-font-size: 14px;\n  --ag-icon-font-family: agGridQuartz;\n  --ag-tab-min-width: 290px;\n  --ag-chart-menu-panel-width: 260px;\n  --ag-card-shadow: 0 1px 4px 1px rgba(186, 191, 199, 0.4);\n  --ag-popup-shadow: 0 0 16px 0 rgba(0, 0, 0, 0.15);\n  --ag-side-bar-panel-width: 250px;\n}\n\n.ag-theme-quartz-dark {\n  --ag-background-color: rgb(31, 41, 54);\n  --ag-foreground-color: #fff;\n  --ag-border-color: rgba(255, 255, 255, 0.16);\n  --ag-secondary-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n  --ag-header-background-color: rgb(40, 49, 62);\n  --ag-tooltip-background-color: rgb(33, 43, 56);\n  --ag-control-panel-background-color: rgb(40, 49, 62);\n  --ag-input-disabled-background-color: rgba(104,104,110,0.07059);\n  --ag-card-shadow: 0 1px 20px 1px black;\n  --ag-input-border-color: var(--ag-border-color);\n  --ag-input-disabled-border-color: rgba(255, 255, 255, 0.07);\n  --ag-checkbox-unchecked-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 40%);\n  --ag-row-hover-color: color-mix(in srgb, transparent, var(--ag-active-color) 20%);\n  --ag-selected-row-background-color: var(--ag-row-hover-color);\n  --ag-panel-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 10%);\n  --ag-panel-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n  --ag-menu-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 10%);\n  --ag-menu-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n  --ag-advanced-filter-join-pill-color: #7a3a37;\n  --ag-advanced-filter-column-pill-color: #355f2d;\n  --ag-advanced-filter-option-pill-color: #5a3168;\n  --ag-advanced-filter-value-pill-color: #374c86;\n  --ag-popup-shadow: 0 0px 20px rgba(0, 0, 0, 0.3);\n  --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n  --csstools-color-scheme--dark: initial;\n  color-scheme: dark;\n}\n\n@media (prefers-color-scheme: dark) {\n  .ag-theme-quartz-auto-dark {\n    --ag-background-color: rgb(31, 41, 54);\n    --ag-foreground-color: #fff;\n    --ag-border-color: rgba(255, 255, 255, 0.16);\n    --ag-secondary-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n    --ag-header-background-color: rgb(40, 49, 62);\n    --ag-tooltip-background-color: rgb(33, 43, 56);\n    --ag-control-panel-background-color: rgb(40, 49, 62);\n    --ag-input-disabled-background-color: rgba(104,104,110,0.07059);\n    --ag-card-shadow: 0 1px 20px 1px black;\n    --ag-input-border-color: var(--ag-border-color);\n    --ag-input-disabled-border-color: rgba(255, 255, 255, 0.07);\n    --ag-checkbox-unchecked-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 40%);\n    --ag-row-hover-color: color-mix(in srgb, transparent, var(--ag-active-color) 20%);\n    --ag-selected-row-background-color: var(--ag-row-hover-color);\n    --ag-panel-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 10%);\n    --ag-panel-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n    --ag-menu-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 10%);\n    --ag-menu-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n    --ag-advanced-filter-join-pill-color: #7a3a37;\n    --ag-advanced-filter-column-pill-color: #355f2d;\n    --ag-advanced-filter-option-pill-color: #5a3168;\n    --ag-advanced-filter-value-pill-color: #374c86;\n    --ag-popup-shadow: 0 0px 20px rgba(0, 0, 0, 0.3);\n    --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n    --csstools-color-scheme--dark: initial;\n    color-scheme: dark;\n  }\n}\n.ag-theme-quartz .ag-filter-toolpanel-header,\n.ag-theme-quartz .ag-filter-toolpanel-search,\n.ag-theme-quartz .ag-status-bar,\n.ag-theme-quartz .ag-header-row,\n.ag-theme-quartz .ag-panel-title-bar-title,\n.ag-theme-quartz .ag-multi-filter-group-title-bar,\n.ag-theme-quartz-dark .ag-filter-toolpanel-header,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search,\n.ag-theme-quartz-dark .ag-status-bar,\n.ag-theme-quartz-dark .ag-header-row,\n.ag-theme-quartz-dark .ag-panel-title-bar-title,\n.ag-theme-quartz-dark .ag-multi-filter-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-header,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-search,\n.ag-theme-quartz-auto-dark .ag-status-bar,\n.ag-theme-quartz-auto-dark .ag-header-row,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-title,\n.ag-theme-quartz-auto-dark .ag-multi-filter-group-title-bar {\n  font-weight: 500;\n  color: var(--ag-header-foreground-color);\n}\n.ag-theme-quartz input[class^=ag-]:not([type]),\n.ag-theme-quartz input[class^=ag-][type=text],\n.ag-theme-quartz input[class^=ag-][type=number],\n.ag-theme-quartz input[class^=ag-][type=tel],\n.ag-theme-quartz input[class^=ag-][type=date],\n.ag-theme-quartz input[class^=ag-][type=datetime-local],\n.ag-theme-quartz textarea[class^=ag-],\n.ag-theme-quartz-dark input[class^=ag-]:not([type]),\n.ag-theme-quartz-dark input[class^=ag-][type=text],\n.ag-theme-quartz-dark input[class^=ag-][type=number],\n.ag-theme-quartz-dark input[class^=ag-][type=tel],\n.ag-theme-quartz-dark input[class^=ag-][type=date],\n.ag-theme-quartz-dark input[class^=ag-][type=datetime-local],\n.ag-theme-quartz-dark textarea[class^=ag-],\n.ag-theme-quartz-auto-dark input[class^=ag-]:not([type]),\n.ag-theme-quartz-auto-dark input[class^=ag-][type=text],\n.ag-theme-quartz-auto-dark input[class^=ag-][type=number],\n.ag-theme-quartz-auto-dark input[class^=ag-][type=tel],\n.ag-theme-quartz-auto-dark input[class^=ag-][type=date],\n.ag-theme-quartz-auto-dark input[class^=ag-][type=datetime-local],\n.ag-theme-quartz-auto-dark textarea[class^=ag-] {\n  min-height: calc(var(--ag-grid-size) * 4);\n  border-radius: var(--ag-border-radius);\n}\n.ag-theme-quartz .ag-ltr input[class^=ag-]:not([type]), .ag-theme-quartz .ag-ltr input[class^=ag-][type=text], .ag-theme-quartz .ag-ltr input[class^=ag-][type=number], .ag-theme-quartz .ag-ltr input[class^=ag-][type=tel], .ag-theme-quartz .ag-ltr input[class^=ag-][type=date], .ag-theme-quartz .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-quartz .ag-ltr textarea[class^=ag-], .ag-theme-quartz-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-quartz-dark .ag-ltr textarea[class^=ag-], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-quartz-auto-dark .ag-ltr textarea[class^=ag-] {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl input[class^=ag-]:not([type]), .ag-theme-quartz .ag-rtl input[class^=ag-][type=text], .ag-theme-quartz .ag-rtl input[class^=ag-][type=number], .ag-theme-quartz .ag-rtl input[class^=ag-][type=tel], .ag-theme-quartz .ag-rtl input[class^=ag-][type=date], .ag-theme-quartz .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-quartz .ag-rtl textarea[class^=ag-], .ag-theme-quartz-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-quartz-dark .ag-rtl textarea[class^=ag-], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-quartz-auto-dark .ag-rtl textarea[class^=ag-] {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-picker-field-wrapper,\n.ag-theme-quartz-dark .ag-picker-field-wrapper,\n.ag-theme-quartz-auto-dark .ag-picker-field-wrapper {\n  min-height: calc(var(--ag-grid-size) * 4);\n}\n.ag-theme-quartz .ag-tab,\n.ag-theme-quartz-dark .ag-tab,\n.ag-theme-quartz-auto-dark .ag-tab {\n  padding: var(--ag-grid-size);\n  border-left: var(--ag-borders) transparent;\n  border-right: var(--ag-borders) transparent;\n  flex: 1 1 auto;\n}\n.ag-theme-quartz .ag-tab-selected,\n.ag-theme-quartz-dark .ag-tab-selected,\n.ag-theme-quartz-auto-dark .ag-tab-selected {\n  background-color: var(--ag-background-color);\n}\n.ag-theme-quartz .ag-ltr .ag-tab-selected:not(:first-of-type), .ag-theme-quartz-dark .ag-ltr .ag-tab-selected:not(:first-of-type), .ag-theme-quartz-auto-dark .ag-ltr .ag-tab-selected:not(:first-of-type) {\n  border-left-color: var(--ag-border-color);\n}\n\n.ag-theme-quartz .ag-rtl .ag-tab-selected:not(:first-of-type), .ag-theme-quartz-dark .ag-rtl .ag-tab-selected:not(:first-of-type), .ag-theme-quartz-auto-dark .ag-rtl .ag-tab-selected:not(:first-of-type) {\n  border-right-color: var(--ag-border-color);\n}\n\n.ag-theme-quartz .ag-ltr .ag-tab-selected:not(:last-of-type), .ag-theme-quartz-dark .ag-ltr .ag-tab-selected:not(:last-of-type), .ag-theme-quartz-auto-dark .ag-ltr .ag-tab-selected:not(:last-of-type) {\n  border-right-color: var(--ag-border-color);\n}\n\n.ag-theme-quartz .ag-rtl .ag-tab-selected:not(:last-of-type), .ag-theme-quartz-dark .ag-rtl .ag-tab-selected:not(:last-of-type), .ag-theme-quartz-auto-dark .ag-rtl .ag-tab-selected:not(:last-of-type) {\n  border-left-color: var(--ag-border-color);\n}\n\n.ag-theme-quartz .ag-tab:not(.ag-tab-selected),\n.ag-theme-quartz-dark .ag-tab:not(.ag-tab-selected),\n.ag-theme-quartz-auto-dark .ag-tab:not(.ag-tab-selected) {\n  opacity: 0.7;\n}\n.ag-theme-quartz .ag-tab:not(.ag-tab-selected):hover,\n.ag-theme-quartz-dark .ag-tab:not(.ag-tab-selected):hover,\n.ag-theme-quartz-auto-dark .ag-tab:not(.ag-tab-selected):hover {\n  opacity: 1;\n}\n.ag-theme-quartz .ag-menu,\n.ag-theme-quartz-dark .ag-menu,\n.ag-theme-quartz-auto-dark .ag-menu {\n  color: color-mix(in srgb, transparent, var(--ag-foreground-color) 95%);\n}\n.ag-theme-quartz .ag-panel-content-wrapper .ag-column-select,\n.ag-theme-quartz-dark .ag-panel-content-wrapper .ag-column-select,\n.ag-theme-quartz-auto-dark .ag-panel-content-wrapper .ag-column-select {\n  background-color: var(--ag-control-panel-background-color);\n  color: color-mix(in srgb, transparent, var(--ag-foreground-color) 95%);\n}\n.ag-theme-quartz .ag-menu-header,\n.ag-theme-quartz-dark .ag-menu-header,\n.ag-theme-quartz-auto-dark .ag-menu-header {\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-quartz .ag-menu-option,\n.ag-theme-quartz-dark .ag-menu-option,\n.ag-theme-quartz-auto-dark .ag-menu-option {\n  font-weight: 500;\n  cursor: pointer;\n}\n.ag-theme-quartz .ag-ltr .ag-menu-option-popup-pointer .ag-icon, .ag-theme-quartz-dark .ag-ltr .ag-menu-option-popup-pointer .ag-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-menu-option-popup-pointer .ag-icon {\n  text-align: right;\n}\n\n.ag-theme-quartz .ag-rtl .ag-menu-option-popup-pointer .ag-icon, .ag-theme-quartz-dark .ag-rtl .ag-menu-option-popup-pointer .ag-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-menu-option-popup-pointer .ag-icon {\n  text-align: left;\n}\n\n.ag-theme-quartz .ag-tabs-header,\n.ag-theme-quartz-dark .ag-tabs-header,\n.ag-theme-quartz-auto-dark .ag-tabs-header {\n  border-bottom: var(--ag-borders) var(--ag-border-color);\n  display: flex;\n  background-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 5%);\n}\n.ag-theme-quartz .ag-side-bar,\n.ag-theme-quartz-dark .ag-side-bar,\n.ag-theme-quartz-auto-dark .ag-side-bar {\n  background-color: var(--ag-control-panel-background-color);\n  min-width: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n}\n.ag-theme-quartz .ag-side-buttons,\n.ag-theme-quartz-dark .ag-side-buttons,\n.ag-theme-quartz-auto-dark .ag-side-buttons {\n  padding: 0;\n  align-self: stretch;\n  width: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  background: var(--ag-control-panel-background-color);\n}\n.ag-theme-quartz .ag-side-button,\n.ag-theme-quartz-dark .ag-side-button,\n.ag-theme-quartz-auto-dark .ag-side-button {\n  border-top: var(--ag-borders) transparent;\n  border-bottom: var(--ag-borders) transparent;\n}\n@media (-webkit-max-device-pixel-ratio: 1.5), (max-resolution: 1.5x) {\n  .ag-theme-quartz .ag-side-button-label,\n  .ag-theme-quartz-dark .ag-side-button-label,\n  .ag-theme-quartz-auto-dark .ag-side-button-label {\n    font-family: "Segoe UI", var(--ag-font-family);\n    transform: rotate(0.05deg);\n  }\n}\n.ag-theme-quartz .ag-side-button.ag-selected,\n.ag-theme-quartz-dark .ag-side-button.ag-selected,\n.ag-theme-quartz-auto-dark .ag-side-button.ag-selected {\n  border-bottom-color: var(--ag-border-color);\n  background-color: var(--ag-background-color);\n}\n.ag-theme-quartz .ag-side-button.ag-selected:not(:first-of-type),\n.ag-theme-quartz-dark .ag-side-button.ag-selected:not(:first-of-type),\n.ag-theme-quartz-auto-dark .ag-side-button.ag-selected:not(:first-of-type) {\n  border-top-color: var(--ag-border-color);\n}\n.ag-theme-quartz .ag-column-panel-column-select,\n.ag-theme-quartz-dark .ag-column-panel-column-select,\n.ag-theme-quartz-auto-dark .ag-column-panel-column-select {\n  border-top: none;\n  border-bottom: 1px solid var(--ag-secondary-border-color);\n}\n.ag-theme-quartz .ag-filter-toolpanel-search,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-search {\n  height: auto;\n  height: initial;\n  margin-top: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-filter-toolpanel-search-input,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search-input,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-search-input {\n  margin: 0;\n}\n.ag-theme-quartz .ag-filter-apply-panel,\n.ag-theme-quartz-dark .ag-filter-apply-panel,\n.ag-theme-quartz-auto-dark .ag-filter-apply-panel {\n  border: none;\n  padding-top: var(--ag-widget-vertical-spacing);\n}\n.ag-theme-quartz .ag-chart-tabbed-menu-body,\n.ag-theme-quartz-dark .ag-chart-tabbed-menu-body,\n.ag-theme-quartz-auto-dark .ag-chart-tabbed-menu-body {\n  position: relative;\n}\n.ag-theme-quartz .ag-chart-tabbed-menu-body::after,\n.ag-theme-quartz-dark .ag-chart-tabbed-menu-body::after,\n.ag-theme-quartz-auto-dark .ag-chart-tabbed-menu-body::after {\n  content: "";\n  position: absolute;\n  display: block;\n  top: 0;\n  left: 0;\n  right: 0;\n  height: 16px;\n  background: linear-gradient(var(--ag-control-panel-background-color), transparent);\n}\n.ag-theme-quartz .ag-charts-settings-group-title-bar,\n.ag-theme-quartz .ag-charts-data-group-title-bar,\n.ag-theme-quartz .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-settings-group-container,\n.ag-theme-quartz-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-settings-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-container {\n  border-top: none;\n  font-weight: 500;\n}\n.ag-theme-quartz .ag-chart-mini-thumbnail,\n.ag-theme-quartz-dark .ag-chart-mini-thumbnail,\n.ag-theme-quartz-auto-dark .ag-chart-mini-thumbnail {\n  background-color: var(--ag-background-color);\n  margin-top: 0;\n  margin-bottom: 0;\n}\n.ag-theme-quartz .ag-chart-settings-nav-bar,\n.ag-theme-quartz-dark .ag-chart-settings-nav-bar,\n.ag-theme-quartz-auto-dark .ag-chart-settings-nav-bar {\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n.ag-theme-quartz .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-title-bar {\n  background: none;\n  font-weight: 500;\n}\n.ag-theme-quartz .ag-chart-data-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz .ag-chart-format-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz-dark .ag-chart-data-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz-dark .ag-chart-format-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz-auto-dark .ag-chart-data-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz-auto-dark .ag-chart-format-section .ag-label:not(.ag-group-title-bar) {\n  color: var(--ag-chart-menu-label-color);\n}\n.ag-theme-quartz .ag-chart-data-section .ag-label-align-top .ag-label,\n.ag-theme-quartz .ag-chart-format-section .ag-label-align-top .ag-label,\n.ag-theme-quartz-dark .ag-chart-data-section .ag-label-align-top .ag-label,\n.ag-theme-quartz-dark .ag-chart-format-section .ag-label-align-top .ag-label,\n.ag-theme-quartz-auto-dark .ag-chart-data-section .ag-label-align-top .ag-label,\n.ag-theme-quartz-auto-dark .ag-chart-format-section .ag-label-align-top .ag-label {\n  margin-top: calc(var(--ag-widget-vertical-spacing) * 0.5);\n  margin-bottom: var(--ag-widget-vertical-spacing);\n}\n.ag-theme-quartz .ag-chart-data-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz .ag-chart-format-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz-dark .ag-chart-data-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz-dark .ag-chart-format-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz-auto-dark .ag-chart-data-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz-auto-dark .ag-chart-format-section .ag-slider.ag-label-align-top .ag-label {\n  margin-bottom: 0;\n}\n.ag-theme-quartz .ag-chart-data-section label,\n.ag-theme-quartz .ag-chart-format-section label,\n.ag-theme-quartz-dark .ag-chart-data-section label,\n.ag-theme-quartz-dark .ag-chart-format-section label,\n.ag-theme-quartz-auto-dark .ag-chart-data-section label,\n.ag-theme-quartz-auto-dark .ag-chart-format-section label {\n  display: inline-block;\n}\n.ag-theme-quartz .ag-chart-format-wrapper,\n.ag-theme-quartz .ag-chart-data-wrapper,\n.ag-theme-quartz .ag-charts-format-top-level-group,\n.ag-theme-quartz .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz .ag-charts-format-top-level-group-item,\n.ag-theme-quartz .ag-charts-format-sub-level-group,\n.ag-theme-quartz .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-quartz .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz .ag-charts-data-group-title-bar,\n.ag-theme-quartz .ag-charts-data-group-container,\n.ag-theme-quartz .ag-charts-settings-group-title-bar,\n.ag-theme-quartz .ag-charts-settings-group-container,\n.ag-theme-quartz-dark .ag-chart-format-wrapper,\n.ag-theme-quartz-dark .ag-chart-data-wrapper,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-item,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-data-group-container,\n.ag-theme-quartz-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-settings-group-container,\n.ag-theme-quartz-auto-dark .ag-chart-format-wrapper,\n.ag-theme-quartz-auto-dark .ag-chart-data-wrapper,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-item,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-container {\n  padding: 0;\n  margin: 0;\n}\n.ag-theme-quartz .ag-charts-format-top-level-group,\n.ag-theme-quartz .ag-charts-data-group,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group,\n.ag-theme-quartz-dark .ag-charts-data-group,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group,\n.ag-theme-quartz-auto-dark .ag-charts-data-group {\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n.ag-theme-quartz .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-data-group-title-bar,\n.ag-theme-quartz .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-title-bar {\n  padding: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n}\n.ag-theme-quartz .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz .ag-charts-data-group .ag-charts-data-group-container,\n.ag-theme-quartz .ag-charts-settings-group .ag-charts-settings-group-container,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz-dark .ag-charts-data-group .ag-charts-data-group-container,\n.ag-theme-quartz-dark .ag-charts-settings-group .ag-charts-settings-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-data-group .ag-charts-data-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group .ag-charts-settings-group-container {\n  padding: 0 var(--ag-widget-container-horizontal-padding);\n}\n.ag-theme-quartz .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-title-bar {\n  padding: var(--ag-widget-vertical-spacing) 0;\n}\n.ag-theme-quartz .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-container {\n  padding-top: var(--ag-widget-vertical-spacing);\n  padding-bottom: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-charts-format-top-level-group-container > *,\n.ag-theme-quartz .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-container > *,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-container > *,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-container > * {\n  margin-bottom: var(--ag-widget-vertical-spacing);\n}\n.ag-theme-quartz .ag-charts-data-group-item,\n.ag-theme-quartz-dark .ag-charts-data-group-item,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-item {\n  padding-bottom: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-chart-settings-mini-wrapper,\n.ag-theme-quartz-dark .ag-chart-settings-mini-wrapper,\n.ag-theme-quartz-auto-dark .ag-chart-settings-mini-wrapper {\n  padding-bottom: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-chart-advanced-settings-section,\n.ag-theme-quartz-dark .ag-chart-advanced-settings-section,\n.ag-theme-quartz-auto-dark .ag-chart-advanced-settings-section {\n  padding-top: var(--ag-widget-container-vertical-padding);\n  padding-bottom: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-container,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-container {\n  padding: 0 var(--ag-widget-container-horizontal-padding);\n}\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group-container,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group-container {\n  margin: 0;\n}\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group-item,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group-item,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group-item {\n  margin-top: calc(var(--ag-widget-vertical-spacing) * 2);\n  margin-bottom: 0;\n}\n.ag-theme-quartz .ag-ltr .ag-group-title-bar-icon, .ag-theme-quartz-dark .ag-ltr .ag-group-title-bar-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-group-title-bar-icon {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl .ag-group-title-bar-icon, .ag-theme-quartz-dark .ag-rtl .ag-group-title-bar-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-group-title-bar-icon {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-spectrum-color,\n.ag-theme-quartz .ag-spectrum-fill,\n.ag-theme-quartz-dark .ag-spectrum-color,\n.ag-theme-quartz-dark .ag-spectrum-fill,\n.ag-theme-quartz-auto-dark .ag-spectrum-color,\n.ag-theme-quartz-auto-dark .ag-spectrum-fill {\n  border-radius: var(--ag-border-radius);\n}\n.ag-theme-quartz .ag-spectrum-dragger,\n.ag-theme-quartz-dark .ag-spectrum-dragger,\n.ag-theme-quartz-auto-dark .ag-spectrum-dragger {\n  border-radius: 18px;\n  height: 18px;\n  width: 18px;\n  border: 3px solid white;\n}\n.ag-theme-quartz .ag-spectrum-tools,\n.ag-theme-quartz-dark .ag-spectrum-tools,\n.ag-theme-quartz-auto-dark .ag-spectrum-tools {\n  padding-left: 0;\n  padding-right: 0;\n  padding-bottom: 0;\n}\n.ag-theme-quartz .ag-spectrum-tool,\n.ag-theme-quartz-dark .ag-spectrum-tool,\n.ag-theme-quartz-auto-dark .ag-spectrum-tool {\n  height: 12px;\n}\n.ag-theme-quartz .ag-spectrum-hue-background,\n.ag-theme-quartz .ag-spectrum-alpha-background,\n.ag-theme-quartz-dark .ag-spectrum-hue-background,\n.ag-theme-quartz-dark .ag-spectrum-alpha-background,\n.ag-theme-quartz-auto-dark .ag-spectrum-hue-background,\n.ag-theme-quartz-auto-dark .ag-spectrum-alpha-background {\n  border-radius: 12px;\n}\n.ag-theme-quartz .ag-spectrum-slider,\n.ag-theme-quartz-dark .ag-spectrum-slider,\n.ag-theme-quartz-auto-dark .ag-spectrum-slider {\n  margin-top: -15px;\n  width: 18px;\n  height: 18px;\n  border-radius: 18px;\n  border: 3px solid rgb(248, 248, 248);\n}\n.ag-theme-quartz .ag-recent-colors,\n.ag-theme-quartz-dark .ag-recent-colors,\n.ag-theme-quartz-auto-dark .ag-recent-colors {\n  margin-left: var(--ag-grid-size);\n  margin-right: var(--ag-grid-size);\n  margin-bottom: 2px;\n}\n.ag-theme-quartz .ag-color-input-color,\n.ag-theme-quartz .ag-color-picker-color,\n.ag-theme-quartz .ag-recent-color,\n.ag-theme-quartz-dark .ag-color-input-color,\n.ag-theme-quartz-dark .ag-color-picker-color,\n.ag-theme-quartz-dark .ag-recent-color,\n.ag-theme-quartz-auto-dark .ag-color-input-color,\n.ag-theme-quartz-auto-dark .ag-color-picker-color,\n.ag-theme-quartz-auto-dark .ag-recent-color {\n  border-radius: 4px;\n}\n.ag-theme-quartz .ag-recent-color,\n.ag-theme-quartz-dark .ag-recent-color,\n.ag-theme-quartz-auto-dark .ag-recent-color {\n  border: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n.ag-theme-quartz.ag-dnd-ghost,\n.ag-theme-quartz-dark.ag-dnd-ghost,\n.ag-theme-quartz-auto-dark.ag-dnd-ghost {\n  font-weight: 500;\n}\n.ag-theme-quartz .ag-standard-button,\n.ag-theme-quartz-dark .ag-standard-button,\n.ag-theme-quartz-auto-dark .ag-standard-button {\n  font-family: inherit;\n  -moz-appearance: none;\n       appearance: none;\n  -webkit-appearance: none;\n  border-radius: var(--ag-border-radius);\n  border: solid 1px var(--ag-input-border-color);\n  background-color: var(--ag-background-color);\n  padding: var(--ag-grid-size) calc(var(--ag-grid-size) * 2);\n  cursor: pointer;\n}\n.ag-theme-quartz .ag-standard-button:hover,\n.ag-theme-quartz-dark .ag-standard-button:hover,\n.ag-theme-quartz-auto-dark .ag-standard-button:hover {\n  background-color: var(--ag-row-hover-color);\n}\n.ag-theme-quartz .ag-standard-button:active,\n.ag-theme-quartz-dark .ag-standard-button:active,\n.ag-theme-quartz-auto-dark .ag-standard-button:active {\n  border-color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-standard-button:disabled,\n.ag-theme-quartz-dark .ag-standard-button:disabled,\n.ag-theme-quartz-auto-dark .ag-standard-button:disabled {\n  color: var(--ag-disabled-foreground-color);\n  background-color: var(--ag-input-disabled-background-color);\n  border-color: var(--ag-input-disabled-border-color);\n}\n.ag-theme-quartz .ag-column-drop-cell,\n.ag-theme-quartz-dark .ag-column-drop-cell,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell {\n  border-radius: calc(var(--ag-grid-size) * 3);\n  height: calc(var(--ag-grid-size) * 3);\n  padding: 0 var(--ag-grid-size);\n}\n.ag-theme-quartz .ag-column-drop-cell-button,\n.ag-theme-quartz-dark .ag-column-drop-cell-button,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell-button {\n  min-width: 0;\n  margin: 0;\n}\n.ag-theme-quartz .ag-column-drop-cell-drag-handle,\n.ag-theme-quartz-dark .ag-column-drop-cell-drag-handle,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell-drag-handle {\n  margin-left: 0;\n}\n.ag-theme-quartz .ag-column-drop-vertical,\n.ag-theme-quartz-dark .ag-column-drop-vertical,\n.ag-theme-quartz-auto-dark .ag-column-drop-vertical {\n  min-height: 75px;\n}\n.ag-theme-quartz .ag-column-drop-vertical-title-bar,\n.ag-theme-quartz-dark .ag-column-drop-vertical-title-bar,\n.ag-theme-quartz-auto-dark .ag-column-drop-vertical-title-bar {\n  padding: var(--ag-widget-container-vertical-padding) calc(var(--ag-grid-size) * 2) 0;\n}\n.ag-theme-quartz .ag-ltr .ag-column-drop-vertical-icon, .ag-theme-quartz-dark .ag-ltr .ag-column-drop-vertical-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-drop-vertical-icon {\n  margin-left: 0;\n  margin-right: var(--ag-widget-horizontal-spacing);\n}\n\n.ag-theme-quartz .ag-rtl .ag-column-drop-vertical-icon, .ag-theme-quartz-dark .ag-rtl .ag-column-drop-vertical-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-drop-vertical-icon {\n  margin-right: 0;\n  margin-left: var(--ag-widget-horizontal-spacing);\n}\n\n.ag-theme-quartz .ag-column-drop-vertical-empty-message,\n.ag-theme-quartz-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-quartz-auto-dark .ag-column-drop-vertical-empty-message {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border: dashed 1px;\n  border-color: var(--ag-border-color);\n  margin: calc(var(--ag-grid-size) * 1.5) calc(var(--ag-grid-size) * 2);\n  padding: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-quartz .ag-column-drop-empty-message,\n.ag-theme-quartz-dark .ag-column-drop-empty-message,\n.ag-theme-quartz-auto-dark .ag-column-drop-empty-message {\n  color: var(--ag-foreground-color);\n}\n.ag-theme-quartz .ag-pill-select .ag-column-drop,\n.ag-theme-quartz-dark .ag-pill-select .ag-column-drop,\n.ag-theme-quartz-auto-dark .ag-pill-select .ag-column-drop {\n  min-height: 0;\n  min-height: initial;\n}\n.ag-theme-quartz .ag-pill-select .ag-picker-field-display,\n.ag-theme-quartz-dark .ag-pill-select .ag-picker-field-display,\n.ag-theme-quartz-auto-dark .ag-pill-select .ag-picker-field-display {\n  font-weight: 500;\n  color: var(--ag-chart-menu-pill-select-button-color);\n}\n.ag-theme-quartz .ag-pill-select .ag-picker-field-icon .ag-icon,\n.ag-theme-quartz-dark .ag-pill-select .ag-picker-field-icon .ag-icon,\n.ag-theme-quartz-auto-dark .ag-pill-select .ag-picker-field-icon .ag-icon {\n  color: var(--ag-chart-menu-pill-select-button-color);\n}\n.ag-theme-quartz .ag-status-bar,\n.ag-theme-quartz-dark .ag-status-bar,\n.ag-theme-quartz-auto-dark .ag-status-bar {\n  font-weight: normal;\n}\n.ag-theme-quartz .ag-status-name-value,\n.ag-theme-quartz-dark .ag-status-name-value,\n.ag-theme-quartz-auto-dark .ag-status-name-value {\n  padding: var(--ag-widget-container-vertical-padding) 0;\n}\n.ag-theme-quartz .ag-status-name-value-value,\n.ag-theme-quartz .ag-paging-number,\n.ag-theme-quartz .ag-paging-row-summary-panel-number,\n.ag-theme-quartz-dark .ag-status-name-value-value,\n.ag-theme-quartz-dark .ag-paging-number,\n.ag-theme-quartz-dark .ag-paging-row-summary-panel-number,\n.ag-theme-quartz-auto-dark .ag-status-name-value-value,\n.ag-theme-quartz-auto-dark .ag-paging-number,\n.ag-theme-quartz-auto-dark .ag-paging-row-summary-panel-number {\n  font-weight: 500;\n}\n.ag-theme-quartz .ag-column-drop-cell-button,\n.ag-theme-quartz-dark .ag-column-drop-cell-button,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell-button {\n  opacity: 0.75;\n}\n.ag-theme-quartz .ag-column-drop-cell-button:hover,\n.ag-theme-quartz-dark .ag-column-drop-cell-button:hover,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell-button:hover {\n  opacity: 1;\n}\n.ag-theme-quartz .ag-header-cell-menu-button,\n.ag-theme-quartz .ag-header-cell-filter-button,\n.ag-theme-quartz .ag-panel-title-bar-button,\n.ag-theme-quartz .ag-header-expand-icon,\n.ag-theme-quartz .ag-column-group-icons,\n.ag-theme-quartz .ag-set-filter-group-icons,\n.ag-theme-quartz .ag-group-expanded .ag-icon,\n.ag-theme-quartz .ag-group-contracted .ag-icon,\n.ag-theme-quartz .ag-chart-settings-prev,\n.ag-theme-quartz .ag-chart-settings-next,\n.ag-theme-quartz .ag-group-title-bar-icon,\n.ag-theme-quartz .ag-column-select-header-icon,\n.ag-theme-quartz .ag-floating-filter-button-button,\n.ag-theme-quartz .ag-filter-toolpanel-expand,\n.ag-theme-quartz .ag-panel-title-bar-button-icon,\n.ag-theme-quartz .ag-chart-menu-icon,\n.ag-theme-quartz-dark .ag-header-cell-menu-button,\n.ag-theme-quartz-dark .ag-header-cell-filter-button,\n.ag-theme-quartz-dark .ag-panel-title-bar-button,\n.ag-theme-quartz-dark .ag-header-expand-icon,\n.ag-theme-quartz-dark .ag-column-group-icons,\n.ag-theme-quartz-dark .ag-set-filter-group-icons,\n.ag-theme-quartz-dark .ag-group-expanded .ag-icon,\n.ag-theme-quartz-dark .ag-group-contracted .ag-icon,\n.ag-theme-quartz-dark .ag-chart-settings-prev,\n.ag-theme-quartz-dark .ag-chart-settings-next,\n.ag-theme-quartz-dark .ag-group-title-bar-icon,\n.ag-theme-quartz-dark .ag-column-select-header-icon,\n.ag-theme-quartz-dark .ag-floating-filter-button-button,\n.ag-theme-quartz-dark .ag-filter-toolpanel-expand,\n.ag-theme-quartz-dark .ag-panel-title-bar-button-icon,\n.ag-theme-quartz-dark .ag-chart-menu-icon,\n.ag-theme-quartz-auto-dark .ag-header-cell-menu-button,\n.ag-theme-quartz-auto-dark .ag-header-cell-filter-button,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-button,\n.ag-theme-quartz-auto-dark .ag-header-expand-icon,\n.ag-theme-quartz-auto-dark .ag-column-group-icons,\n.ag-theme-quartz-auto-dark .ag-set-filter-group-icons,\n.ag-theme-quartz-auto-dark .ag-group-expanded .ag-icon,\n.ag-theme-quartz-auto-dark .ag-group-contracted .ag-icon,\n.ag-theme-quartz-auto-dark .ag-chart-settings-prev,\n.ag-theme-quartz-auto-dark .ag-chart-settings-next,\n.ag-theme-quartz-auto-dark .ag-group-title-bar-icon,\n.ag-theme-quartz-auto-dark .ag-column-select-header-icon,\n.ag-theme-quartz-auto-dark .ag-floating-filter-button-button,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-expand,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-button-icon,\n.ag-theme-quartz-auto-dark .ag-chart-menu-icon {\n  --ag-quartz-icon-hover-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n}\n.ag-theme-quartz .ag-header-cell-menu-button:hover,\n.ag-theme-quartz .ag-header-cell-filter-button:hover,\n.ag-theme-quartz .ag-panel-title-bar-button:hover,\n.ag-theme-quartz .ag-header-expand-icon:hover,\n.ag-theme-quartz .ag-column-group-icons:hover,\n.ag-theme-quartz .ag-set-filter-group-icons:hover,\n.ag-theme-quartz .ag-group-expanded .ag-icon:hover,\n.ag-theme-quartz .ag-group-contracted .ag-icon:hover,\n.ag-theme-quartz .ag-chart-settings-prev:hover,\n.ag-theme-quartz .ag-chart-settings-next:hover,\n.ag-theme-quartz .ag-group-title-bar-icon:hover,\n.ag-theme-quartz .ag-column-select-header-icon:hover,\n.ag-theme-quartz .ag-floating-filter-button-button:hover,\n.ag-theme-quartz .ag-filter-toolpanel-expand:hover,\n.ag-theme-quartz .ag-panel-title-bar-button-icon:hover,\n.ag-theme-quartz .ag-chart-menu-icon:hover,\n.ag-theme-quartz-dark .ag-header-cell-menu-button:hover,\n.ag-theme-quartz-dark .ag-header-cell-filter-button:hover,\n.ag-theme-quartz-dark .ag-panel-title-bar-button:hover,\n.ag-theme-quartz-dark .ag-header-expand-icon:hover,\n.ag-theme-quartz-dark .ag-column-group-icons:hover,\n.ag-theme-quartz-dark .ag-set-filter-group-icons:hover,\n.ag-theme-quartz-dark .ag-group-expanded .ag-icon:hover,\n.ag-theme-quartz-dark .ag-group-contracted .ag-icon:hover,\n.ag-theme-quartz-dark .ag-chart-settings-prev:hover,\n.ag-theme-quartz-dark .ag-chart-settings-next:hover,\n.ag-theme-quartz-dark .ag-group-title-bar-icon:hover,\n.ag-theme-quartz-dark .ag-column-select-header-icon:hover,\n.ag-theme-quartz-dark .ag-floating-filter-button-button:hover,\n.ag-theme-quartz-dark .ag-filter-toolpanel-expand:hover,\n.ag-theme-quartz-dark .ag-panel-title-bar-button-icon:hover,\n.ag-theme-quartz-dark .ag-chart-menu-icon:hover,\n.ag-theme-quartz-auto-dark .ag-header-cell-menu-button:hover,\n.ag-theme-quartz-auto-dark .ag-header-cell-filter-button:hover,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-button:hover,\n.ag-theme-quartz-auto-dark .ag-header-expand-icon:hover,\n.ag-theme-quartz-auto-dark .ag-column-group-icons:hover,\n.ag-theme-quartz-auto-dark .ag-set-filter-group-icons:hover,\n.ag-theme-quartz-auto-dark .ag-group-expanded .ag-icon:hover,\n.ag-theme-quartz-auto-dark .ag-group-contracted .ag-icon:hover,\n.ag-theme-quartz-auto-dark .ag-chart-settings-prev:hover,\n.ag-theme-quartz-auto-dark .ag-chart-settings-next:hover,\n.ag-theme-quartz-auto-dark .ag-group-title-bar-icon:hover,\n.ag-theme-quartz-auto-dark .ag-column-select-header-icon:hover,\n.ag-theme-quartz-auto-dark .ag-floating-filter-button-button:hover,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-expand:hover,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-button-icon:hover,\n.ag-theme-quartz-auto-dark .ag-chart-menu-icon:hover {\n  border-radius: 1px;\n  background-color: var(--ag-quartz-icon-hover-color);\n  box-shadow: 0 0 0 4px var(--ag-quartz-icon-hover-color);\n}\n.ag-theme-quartz .ag-filter-active,\n.ag-theme-quartz-dark .ag-filter-active,\n.ag-theme-quartz-auto-dark .ag-filter-active {\n  --ag-quartz-icon-active-color: color-mix(in srgb, transparent, var(--ag-active-color) 14%);\n  --ag-quartz-icon-hover-color: color-mix(in srgb, transparent, var(--ag-active-color) 28%);\n  position: relative;\n  border-radius: 1px;\n  background-color: var(--ag-quartz-icon-active-color);\n  box-shadow: 0 0 0 4px var(--ag-quartz-icon-active-color);\n}\n.ag-theme-quartz .ag-filter-active::after,\n.ag-theme-quartz-dark .ag-filter-active::after,\n.ag-theme-quartz-auto-dark .ag-filter-active::after {\n  content: "";\n  position: absolute;\n  width: 6px;\n  height: 6px;\n  top: -1px;\n  right: -1px;\n  border-radius: 50%;\n  background-color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-filter-active .ag-icon-filter,\n.ag-theme-quartz-dark .ag-filter-active .ag-icon-filter,\n.ag-theme-quartz-auto-dark .ag-filter-active .ag-icon-filter {\n  clip-path: path("M8,0C8,4.415 11.585,8 16,8L16,16L0,16L0,0L8,0Z");\n}\n.ag-theme-quartz .ag-chart-menu,\n.ag-theme-quartz-dark .ag-chart-menu,\n.ag-theme-quartz-auto-dark .ag-chart-menu {\n  --ag-icon-size: 20px;\n  background-color: color-mix(in srgb, transparent, var(--ag-background-color) 30%);\n  padding: 4px 2px;\n}\n.ag-theme-quartz .ag-chart-menu-icon,\n.ag-theme-quartz-dark .ag-chart-menu-icon,\n.ag-theme-quartz-auto-dark .ag-chart-menu-icon {\n  opacity: 0.8;\n}\n.ag-theme-quartz .ag-drag-handle,\n.ag-theme-quartz-dark .ag-drag-handle,\n.ag-theme-quartz-auto-dark .ag-drag-handle {\n  color: var(--ag-icon-font-color);\n}\n.ag-theme-quartz .ag-menu-option-icon,\n.ag-theme-quartz .ag-compact-menu-option-icon,\n.ag-theme-quartz-dark .ag-menu-option-icon,\n.ag-theme-quartz-dark .ag-compact-menu-option-icon,\n.ag-theme-quartz-auto-dark .ag-menu-option-icon,\n.ag-theme-quartz-auto-dark .ag-compact-menu-option-icon {\n  width: var(--ag-icon-size);\n  cursor: pointer;\n}\n.ag-theme-quartz .ag-ltr .ag-menu-option-icon, .ag-theme-quartz .ag-ltr .ag-compact-menu-option-icon, .ag-theme-quartz-dark .ag-ltr .ag-menu-option-icon, .ag-theme-quartz-dark .ag-ltr .ag-compact-menu-option-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-menu-option-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-compact-menu-option-icon {\n  padding-left: calc(var(--ag-grid-size) * 1.5);\n}\n\n.ag-theme-quartz .ag-rtl .ag-menu-option-icon, .ag-theme-quartz .ag-rtl .ag-compact-menu-option-icon, .ag-theme-quartz-dark .ag-rtl .ag-menu-option-icon, .ag-theme-quartz-dark .ag-rtl .ag-compact-menu-option-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-menu-option-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-compact-menu-option-icon {\n  padding-right: calc(var(--ag-grid-size) * 1.5);\n}\n\n.ag-theme-quartz .ag-chart-settings-card-item.ag-not-selected:hover,\n.ag-theme-quartz-dark .ag-chart-settings-card-item.ag-not-selected:hover,\n.ag-theme-quartz-auto-dark .ag-chart-settings-card-item.ag-not-selected:hover {\n  opacity: 0.35;\n}\n.ag-theme-quartz .ag-ltr .ag-panel-title-bar-button, .ag-theme-quartz-dark .ag-ltr .ag-panel-title-bar-button, .ag-theme-quartz-auto-dark .ag-ltr .ag-panel-title-bar-button {\n  margin-left: calc(var(--ag-grid-size) * 2);\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl .ag-panel-title-bar-button, .ag-theme-quartz-dark .ag-rtl .ag-panel-title-bar-button, .ag-theme-quartz-auto-dark .ag-rtl .ag-panel-title-bar-button {\n  margin-right: calc(var(--ag-grid-size) * 2);\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-multi-filter-group-title-bar,\n.ag-theme-quartz-dark .ag-multi-filter-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-multi-filter-group-title-bar {\n  padding: calc(var(--ag-grid-size) * 1.5) var(--ag-grid-size);\n}\n.ag-theme-quartz .ag-ltr .ag-filter-toolpanel-instance-body, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-instance-body, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-instance-body {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl .ag-filter-toolpanel-instance-body, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-instance-body, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-instance-body {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-filter-toolpanel-instance-filter,\n.ag-theme-quartz-dark .ag-filter-toolpanel-instance-filter,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-instance-filter {\n  border: none;\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-quartz .ag-ltr .ag-filter-toolpanel-instance-filter, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-instance-filter, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-instance-filter {\n  margin-left: calc(var(--ag-icon-size) * 0.5);\n}\n\n.ag-theme-quartz .ag-rtl .ag-filter-toolpanel-instance-filter, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-instance-filter, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-instance-filter {\n  margin-right: calc(var(--ag-icon-size) * 0.5);\n}\n\n.ag-theme-quartz .ag-filter-toolpanel-group-level-0,\n.ag-theme-quartz-dark .ag-filter-toolpanel-group-level-0,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-group-level-0 {\n  border-top: none;\n}\n.ag-theme-quartz .ag-filter-toolpanel-header,\n.ag-theme-quartz-dark .ag-filter-toolpanel-header,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-header {\n  height: auto;\n  height: initial;\n  padding-top: var(--ag-grid-size);\n  padding-bottom: var(--ag-grid-size);\n}\n.ag-theme-quartz .ag-filter-toolpanel-group-item,\n.ag-theme-quartz-dark .ag-filter-toolpanel-group-item,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-group-item {\n  margin: 0;\n}\n.ag-theme-quartz .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-quartz .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-quartz .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-quartz .ag-layout-print .ag-center-cols-container,\n.ag-theme-quartz-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-quartz-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-quartz-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-quartz-dark .ag-layout-print .ag-center-cols-container,\n.ag-theme-quartz-auto-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-quartz-auto-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-quartz-auto-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-quartz-auto-dark .ag-layout-print .ag-center-cols-container {\n  min-height: 150px;\n}\n.ag-theme-quartz .ag-date-time-list-page-entry-is-current,\n.ag-theme-quartz-dark .ag-date-time-list-page-entry-is-current,\n.ag-theme-quartz-auto-dark .ag-date-time-list-page-entry-is-current {\n  background-color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-advanced-filter-builder-button,\n.ag-theme-quartz-dark .ag-advanced-filter-builder-button,\n.ag-theme-quartz-auto-dark .ag-advanced-filter-builder-button {\n  padding: var(--ag-grid-size);\n  font-weight: 600;\n}\n.ag-theme-quartz .ag-advanced-filter-builder-item-button-disabled .ag-icon,\n.ag-theme-quartz .ag-disabled .ag-icon,\n.ag-theme-quartz .ag-column-select-column-group-readonly .ag-icon,\n.ag-theme-quartz [disabled] .ag-icon,\n.ag-theme-quartz-dark .ag-advanced-filter-builder-item-button-disabled .ag-icon,\n.ag-theme-quartz-dark .ag-disabled .ag-icon,\n.ag-theme-quartz-dark .ag-column-select-column-group-readonly .ag-icon,\n.ag-theme-quartz-dark [disabled] .ag-icon,\n.ag-theme-quartz-auto-dark .ag-advanced-filter-builder-item-button-disabled .ag-icon,\n.ag-theme-quartz-auto-dark .ag-disabled .ag-icon,\n.ag-theme-quartz-auto-dark .ag-column-select-column-group-readonly .ag-icon,\n.ag-theme-quartz-auto-dark [disabled] .ag-icon {\n  opacity: 0.6;\n}\n.ag-theme-quartz .ag-icon-grip,\n.ag-theme-quartz-dark .ag-icon-grip,\n.ag-theme-quartz-auto-dark .ag-icon-grip {\n  opacity: 0.7;\n}\n.ag-theme-quartz .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-quartz .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-quartz-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-quartz-dark .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-quartz-auto-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-quartz-auto-dark .ag-column-select-column-readonly .ag-icon-grip {\n  opacity: 0.35;\n}\n.ag-theme-quartz .ag-column-select-header-filter-wrapper .ag-input-wrapper::before,\n.ag-theme-quartz .ag-filter-toolpanel-search .ag-input-wrapper::before,\n.ag-theme-quartz .ag-mini-filter .ag-input-wrapper::before,\n.ag-theme-quartz .ag-filter-filter .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-column-select-header-filter-wrapper .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-mini-filter .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-filter-filter .ag-input-wrapper::before,\n.ag-theme-quartz-auto-dark .ag-column-select-header-filter-wrapper .ag-input-wrapper::before,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-search .ag-input-wrapper::before,\n.ag-theme-quartz-auto-dark .ag-mini-filter .ag-input-wrapper::before,\n.ag-theme-quartz-auto-dark .ag-filter-filter .ag-input-wrapper::before {\n  position: absolute;\n  display: block;\n  width: 12px;\n  height: 12px;\n  background-image: url(' + g + ');\n  background-position: 50% 50%;\n  background-size: contain;\n  opacity: 0.4;\n  content: "";\n  filter: var(--ag-icon-filter);\n}\n.ag-theme-quartz .ag-ltr .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz .ag-ltr .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz .ag-ltr .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz .ag-ltr .ag-filter-filter .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-ltr .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-ltr .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-ltr .ag-filter-filter .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-ltr .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-filter .ag-input-wrapper::before {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz .ag-rtl .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz .ag-rtl .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz .ag-rtl .ag-filter-filter .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-rtl .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-rtl .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-rtl .ag-filter-filter .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-rtl .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-filter .ag-input-wrapper::before {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-ltr .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz .ag-ltr .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz .ag-ltr .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz .ag-ltr .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz .ag-ltr .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz .ag-ltr .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz .ag-ltr .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz .ag-ltr .ag-filter-filter input.ag-number-field-input, .ag-theme-quartz-dark .ag-ltr .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz-dark .ag-ltr .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz-dark .ag-ltr .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz-dark .ag-ltr .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz-dark .ag-ltr .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz-dark .ag-ltr .ag-filter-filter input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-filter input.ag-number-field-input {\n  padding-left: 26px;\n}\n\n.ag-theme-quartz .ag-rtl .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz .ag-rtl .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz .ag-rtl .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz .ag-rtl .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz .ag-rtl .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz .ag-rtl .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz .ag-rtl .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz .ag-rtl .ag-filter-filter input.ag-number-field-input, .ag-theme-quartz-dark .ag-rtl .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz-dark .ag-rtl .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz-dark .ag-rtl .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz-dark .ag-rtl .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz-dark .ag-rtl .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz-dark .ag-rtl .ag-filter-filter input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-filter input.ag-number-field-input {\n  padding-right: 26px;\n}\n\n.ag-theme-quartz .ag-ltr .ag-column-select-add-group-indent, .ag-theme-quartz-dark .ag-ltr .ag-column-select-add-group-indent, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-select-add-group-indent {\n  margin-left: calc(var(--ag-icon-size) + var(--ag-grid-size) * 1.5);\n}\n\n.ag-theme-quartz .ag-rtl .ag-column-select-add-group-indent, .ag-theme-quartz-dark .ag-rtl .ag-column-select-add-group-indent, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-select-add-group-indent {\n  margin-right: calc(var(--ag-icon-size) + var(--ag-grid-size) * 1.5);\n}\n\n.ag-theme-quartz .ag-text-field-input[disabled],\n.ag-theme-quartz .ag-menu-option-disabled,\n.ag-theme-quartz-dark .ag-text-field-input[disabled],\n.ag-theme-quartz-dark .ag-menu-option-disabled,\n.ag-theme-quartz-auto-dark .ag-text-field-input[disabled],\n.ag-theme-quartz-auto-dark .ag-menu-option-disabled {\n  cursor: not-allowed;\n}\n.ag-theme-quartz .ag-checkbox-input-wrapper.ag-checked.ag-disabled,\n.ag-theme-quartz-dark .ag-checkbox-input-wrapper.ag-checked.ag-disabled,\n.ag-theme-quartz-auto-dark .ag-checkbox-input-wrapper.ag-checked.ag-disabled {\n  --ag-checkbox-checked-color: var(--ag-checkbox-unchecked-color);\n}\n.ag-theme-quartz .ag-checkbox-input,\n.ag-theme-quartz .ag-toggle-button-input,\n.ag-theme-quartz .ag-radio-button-input,\n.ag-theme-quartz input[class^=ag-][type=range],\n.ag-theme-quartz-dark .ag-checkbox-input,\n.ag-theme-quartz-dark .ag-toggle-button-input,\n.ag-theme-quartz-dark .ag-radio-button-input,\n.ag-theme-quartz-dark input[class^=ag-][type=range],\n.ag-theme-quartz-auto-dark .ag-checkbox-input,\n.ag-theme-quartz-auto-dark .ag-toggle-button-input,\n.ag-theme-quartz-auto-dark .ag-radio-button-input,\n.ag-theme-quartz-auto-dark input[class^=ag-][type=range] {\n  cursor: pointer;\n}\n.ag-theme-quartz .ag-details-row,\n.ag-theme-quartz-dark .ag-details-row,\n.ag-theme-quartz-auto-dark .ag-details-row {\n  padding: calc(var(--ag-grid-size) * 3.75);\n}\n.ag-theme-quartz .ag-list-item-hovered::after,\n.ag-theme-quartz-dark .ag-list-item-hovered::after,\n.ag-theme-quartz-auto-dark .ag-list-item-hovered::after {\n  background-color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-pill .ag-pill-button:hover,\n.ag-theme-quartz-dark .ag-pill .ag-pill-button:hover,\n.ag-theme-quartz-auto-dark .ag-pill .ag-pill-button:hover {\n  color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-header-highlight-before::after,\n.ag-theme-quartz .ag-header-highlight-after::after,\n.ag-theme-quartz-dark .ag-header-highlight-before::after,\n.ag-theme-quartz-dark .ag-header-highlight-after::after,\n.ag-theme-quartz-auto-dark .ag-header-highlight-before::after,\n.ag-theme-quartz-auto-dark .ag-header-highlight-after::after {\n  background-color: var(--ag-active-color);\n}\n\n.ag-theme-quartz-dark .ag-column-select-header-filter-wrapper .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-mini-filter .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-filter-filter .ag-input-wrapper::before {\n  opacity: 0.66;\n  filter: invert(100%);\n}\n.ag-theme-quartz-dark .ag-chart-menu {\n  background-color: color-mix(in srgb, rgba(24, 39, 50, 0.3), var(--ag-background-color) 30%);\n}\n.ag-theme-quartz-dark .ag-text-field-input::-moz-placeholder {\n  color: var(--ag-data-color);\n  opacity: 0.8;\n}\n.ag-theme-quartz-dark .ag-text-field-input::placeholder {\n  color: var(--ag-data-color);\n  opacity: 0.8;\n}\n', ""]), t2.A = c;
          }, 9561: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(2006), a2.b), c = new URL(a2(7249), a2.b), g = i()(o()), u = s()(d), h = s()(c);
            g.push([e2.id, '@font-face {\n  font-family: "agGridQuartz";\n  src: url(' + u + ');\n  font-weight: normal;\n  font-style: normal;\n}\n.ag-theme-quartz,\n.ag-theme-quartz-dark,\n.ag-theme-quartz-auto-dark {\n  --ag-active-color: #2196f3;\n  --ag-background-color: #fff;\n  --ag-foreground-color: #181d1f;\n  --ag-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 15%);\n  --ag-secondary-border-color: var(--ag-border-color);\n  --ag-header-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 2%);\n  --ag-tooltip-background-color: var(--ag-header-background-color);\n  --ag-control-panel-background-color: var(--ag-header-background-color);\n  --ag-subheader-background-color: transparent;\n  --ag-invalid-color: #e02525;\n  --ag-checkbox-unchecked-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 30%);\n  --ag-advanced-filter-join-pill-color: #f08e8d;\n  --ag-advanced-filter-column-pill-color: #a6e194;\n  --ag-advanced-filter-option-pill-color: #f3c08b;\n  --ag-advanced-filter-value-pill-color: #85c0e4;\n  --ag-header-column-resize-handle-color: var(--ag-secondary-border-color);\n  --ag-icon-font-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 90%);\n  --ag-panel-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 3%);\n  --ag-panel-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 20%);\n  --ag-menu-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 3%);\n  --ag-menu-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 20%);\n  --ag-selected-row-background-color: color-mix(in srgb, transparent, var(--ag-active-color) 8%);\n  --ag-row-hover-color: color-mix(in srgb, transparent, var(--ag-active-color) 12%);\n  --ag-column-hover-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 5%);\n  --ag-input-focus-border-color: var(--ag-active-color);\n  --ag-input-focus-box-shadow: 0 0 0 3px color-mix(in srgb, transparent, var(--ag-input-focus-border-color) 47%);\n  --ag-range-selection-background-color: color-mix(in srgb, transparent, var(--ag-active-color) 20%);\n  --ag-range-selection-background-color-2: color-mix(in srgb, transparent, var(--ag-active-color) 36%);\n  --ag-range-selection-background-color-3: color-mix(in srgb, transparent, var(--ag-active-color) 49%);\n  --ag-range-selection-background-color-4: color-mix(in srgb, transparent, var(--ag-active-color) 59%);\n  --ag-checkbox-background-color: var(--ag-background-color);\n  --ag-checkbox-checked-color: var(--ag-active-color);\n  --ag-range-selection-border-color: var(--ag-active-color);\n  --ag-secondary-foreground-color: var(--ag-foreground-color);\n  --ag-input-border-color: var(--ag-border-color);\n  --ag-input-border-color-invalid: var(--ag-invalid-color);\n  --ag-disabled-foreground-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 50%);\n  --ag-chip-background-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 7%);\n  --ag-chip-border-color: color-mix(in srgb, var(--ag-header-background-color), var(--ag-foreground-color) 13%);\n  --ag-input-disabled-border-color: var(--ag-border-color);\n  --ag-input-disabled-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 6%);\n  --ag-modal-overlay-background-color: color-mix(in srgb, transparent, var(--ag-background-color) 66%);\n  --ag-chart-menu-label-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 80%);\n  --ag-chart-menu-pill-select-button-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 70%);\n  --ag-borders: solid 1px;\n  --ag-border-radius: 4px;\n  --ag-wrapper-border-radius: 8px;\n  --ag-borders-side-button: none;\n  --ag-side-button-selected-background-color: transparent;\n  --ag-header-column-resize-handle-display: block;\n  --ag-header-column-resize-handle-width: 2px;\n  --ag-header-column-resize-handle-height: 30%;\n  --ag-grid-size: 8px;\n  --ag-icon-size: 16px;\n  --ag-header-height: calc(var(--ag-font-size) + var(--ag-grid-size) * 4.25);\n  --ag-row-height: calc(var(--ag-font-size) + var(--ag-grid-size) * 3.5);\n  --ag-list-item-height: calc(\n      var(--ag-icon-size) + var(--ag-widget-vertical-spacing)\n  );\n  --ag-column-select-indent-size: var(--ag-icon-size);\n  --ag-set-filter-indent-size: var(--ag-icon-size);\n  --ag-filter-tool-panel-group-indent: var(--ag-grid-size);\n  --ag-advanced-filter-builder-indent-size: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  --ag-cell-horizontal-padding: calc(var(--ag-grid-size) * 2);\n  --ag-cell-widget-spacing: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-container-vertical-padding: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-container-horizontal-padding: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-horizontal-spacing: calc(var(--ag-grid-size) * 1.5);\n  --ag-widget-vertical-spacing: calc(var(--ag-grid-size) * 1);\n  --ag-toggle-button-height: 18px;\n  --ag-toggle-button-width: 28px;\n  --ag-toggle-button-border-width: 2px;\n  --ag-font-family: "IBM Plex Sans", -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Oxygen-Sans, Ubuntu,\n      Cantarell, "Helvetica Neue", sans-serif;\n  --ag-font-size: 14px;\n  --ag-icon-font-family: agGridQuartz;\n  --ag-tab-min-width: 290px;\n  --ag-chart-menu-panel-width: 260px;\n  --ag-card-shadow: 0 1px 4px 1px rgba(186, 191, 199, 0.4);\n  --ag-popup-shadow: 0 0 16px 0 rgba(0, 0, 0, 0.15);\n  --ag-side-bar-panel-width: 250px;\n}\n\n.ag-theme-quartz-dark {\n  --ag-background-color: rgb(31, 41, 54);\n  --ag-foreground-color: #fff;\n  --ag-border-color: rgba(255, 255, 255, 0.16);\n  --ag-secondary-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n  --ag-header-background-color: rgb(40, 49, 62);\n  --ag-tooltip-background-color: rgb(33, 43, 56);\n  --ag-control-panel-background-color: rgb(40, 49, 62);\n  --ag-input-disabled-background-color: rgba(104,104,110,0.07059);\n  --ag-card-shadow: 0 1px 20px 1px black;\n  --ag-input-border-color: var(--ag-border-color);\n  --ag-input-disabled-border-color: rgba(255, 255, 255, 0.07);\n  --ag-checkbox-unchecked-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 40%);\n  --ag-row-hover-color: color-mix(in srgb, transparent, var(--ag-active-color) 20%);\n  --ag-selected-row-background-color: var(--ag-row-hover-color);\n  --ag-panel-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 10%);\n  --ag-panel-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n  --ag-menu-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 10%);\n  --ag-menu-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n  --ag-advanced-filter-join-pill-color: #7a3a37;\n  --ag-advanced-filter-column-pill-color: #355f2d;\n  --ag-advanced-filter-option-pill-color: #5a3168;\n  --ag-advanced-filter-value-pill-color: #374c86;\n  --ag-popup-shadow: 0 0px 20px rgba(0, 0, 0, 0.3);\n  --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n  --csstools-color-scheme--dark: initial;\n  color-scheme: dark;\n}\n\n@media (prefers-color-scheme: dark) {\n  .ag-theme-quartz-auto-dark {\n    --ag-background-color: rgb(31, 41, 54);\n    --ag-foreground-color: #fff;\n    --ag-border-color: rgba(255, 255, 255, 0.16);\n    --ag-secondary-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n    --ag-header-background-color: rgb(40, 49, 62);\n    --ag-tooltip-background-color: rgb(33, 43, 56);\n    --ag-control-panel-background-color: rgb(40, 49, 62);\n    --ag-input-disabled-background-color: rgba(104,104,110,0.07059);\n    --ag-card-shadow: 0 1px 20px 1px black;\n    --ag-input-border-color: var(--ag-border-color);\n    --ag-input-disabled-border-color: rgba(255, 255, 255, 0.07);\n    --ag-checkbox-unchecked-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 40%);\n    --ag-row-hover-color: color-mix(in srgb, transparent, var(--ag-active-color) 20%);\n    --ag-selected-row-background-color: var(--ag-row-hover-color);\n    --ag-panel-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 10%);\n    --ag-panel-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n    --ag-menu-background-color: color-mix(in srgb, var(--ag-background-color), var(--ag-foreground-color) 10%);\n    --ag-menu-border-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n    --ag-advanced-filter-join-pill-color: #7a3a37;\n    --ag-advanced-filter-column-pill-color: #355f2d;\n    --ag-advanced-filter-option-pill-color: #5a3168;\n    --ag-advanced-filter-value-pill-color: #374c86;\n    --ag-popup-shadow: 0 0px 20px rgba(0, 0, 0, 0.3);\n    --ag-row-loading-skeleton-effect-color: rgba(202, 203, 204, 0.4);\n    --csstools-color-scheme--dark: initial;\n    color-scheme: dark;\n  }\n}\n.ag-theme-quartz .ag-filter-toolpanel-header,\n.ag-theme-quartz .ag-filter-toolpanel-search,\n.ag-theme-quartz .ag-status-bar,\n.ag-theme-quartz .ag-header-row,\n.ag-theme-quartz .ag-panel-title-bar-title,\n.ag-theme-quartz .ag-multi-filter-group-title-bar,\n.ag-theme-quartz-dark .ag-filter-toolpanel-header,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search,\n.ag-theme-quartz-dark .ag-status-bar,\n.ag-theme-quartz-dark .ag-header-row,\n.ag-theme-quartz-dark .ag-panel-title-bar-title,\n.ag-theme-quartz-dark .ag-multi-filter-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-header,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-search,\n.ag-theme-quartz-auto-dark .ag-status-bar,\n.ag-theme-quartz-auto-dark .ag-header-row,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-title,\n.ag-theme-quartz-auto-dark .ag-multi-filter-group-title-bar {\n  font-weight: 500;\n  color: var(--ag-header-foreground-color);\n}\n.ag-theme-quartz input[class^=ag-]:not([type]),\n.ag-theme-quartz input[class^=ag-][type=text],\n.ag-theme-quartz input[class^=ag-][type=number],\n.ag-theme-quartz input[class^=ag-][type=tel],\n.ag-theme-quartz input[class^=ag-][type=date],\n.ag-theme-quartz input[class^=ag-][type=datetime-local],\n.ag-theme-quartz textarea[class^=ag-],\n.ag-theme-quartz-dark input[class^=ag-]:not([type]),\n.ag-theme-quartz-dark input[class^=ag-][type=text],\n.ag-theme-quartz-dark input[class^=ag-][type=number],\n.ag-theme-quartz-dark input[class^=ag-][type=tel],\n.ag-theme-quartz-dark input[class^=ag-][type=date],\n.ag-theme-quartz-dark input[class^=ag-][type=datetime-local],\n.ag-theme-quartz-dark textarea[class^=ag-],\n.ag-theme-quartz-auto-dark input[class^=ag-]:not([type]),\n.ag-theme-quartz-auto-dark input[class^=ag-][type=text],\n.ag-theme-quartz-auto-dark input[class^=ag-][type=number],\n.ag-theme-quartz-auto-dark input[class^=ag-][type=tel],\n.ag-theme-quartz-auto-dark input[class^=ag-][type=date],\n.ag-theme-quartz-auto-dark input[class^=ag-][type=datetime-local],\n.ag-theme-quartz-auto-dark textarea[class^=ag-] {\n  min-height: calc(var(--ag-grid-size) * 4);\n  border-radius: var(--ag-border-radius);\n}\n.ag-theme-quartz .ag-ltr input[class^=ag-]:not([type]), .ag-theme-quartz .ag-ltr input[class^=ag-][type=text], .ag-theme-quartz .ag-ltr input[class^=ag-][type=number], .ag-theme-quartz .ag-ltr input[class^=ag-][type=tel], .ag-theme-quartz .ag-ltr input[class^=ag-][type=date], .ag-theme-quartz .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-quartz .ag-ltr textarea[class^=ag-], .ag-theme-quartz-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-quartz-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-quartz-dark .ag-ltr textarea[class^=ag-], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-]:not([type]), .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=text], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=number], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=tel], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=date], .ag-theme-quartz-auto-dark .ag-ltr input[class^=ag-][type=datetime-local], .ag-theme-quartz-auto-dark .ag-ltr textarea[class^=ag-] {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl input[class^=ag-]:not([type]), .ag-theme-quartz .ag-rtl input[class^=ag-][type=text], .ag-theme-quartz .ag-rtl input[class^=ag-][type=number], .ag-theme-quartz .ag-rtl input[class^=ag-][type=tel], .ag-theme-quartz .ag-rtl input[class^=ag-][type=date], .ag-theme-quartz .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-quartz .ag-rtl textarea[class^=ag-], .ag-theme-quartz-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-quartz-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-quartz-dark .ag-rtl textarea[class^=ag-], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-]:not([type]), .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=text], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=number], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=tel], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=date], .ag-theme-quartz-auto-dark .ag-rtl input[class^=ag-][type=datetime-local], .ag-theme-quartz-auto-dark .ag-rtl textarea[class^=ag-] {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-picker-field-wrapper,\n.ag-theme-quartz-dark .ag-picker-field-wrapper,\n.ag-theme-quartz-auto-dark .ag-picker-field-wrapper {\n  min-height: calc(var(--ag-grid-size) * 4);\n}\n.ag-theme-quartz .ag-tab,\n.ag-theme-quartz-dark .ag-tab,\n.ag-theme-quartz-auto-dark .ag-tab {\n  padding: var(--ag-grid-size);\n  border-left: var(--ag-borders) transparent;\n  border-right: var(--ag-borders) transparent;\n  flex: 1 1 auto;\n}\n.ag-theme-quartz .ag-tab-selected,\n.ag-theme-quartz-dark .ag-tab-selected,\n.ag-theme-quartz-auto-dark .ag-tab-selected {\n  background-color: var(--ag-background-color);\n}\n.ag-theme-quartz .ag-ltr .ag-tab-selected:not(:first-of-type), .ag-theme-quartz-dark .ag-ltr .ag-tab-selected:not(:first-of-type), .ag-theme-quartz-auto-dark .ag-ltr .ag-tab-selected:not(:first-of-type) {\n  border-left-color: var(--ag-border-color);\n}\n\n.ag-theme-quartz .ag-rtl .ag-tab-selected:not(:first-of-type), .ag-theme-quartz-dark .ag-rtl .ag-tab-selected:not(:first-of-type), .ag-theme-quartz-auto-dark .ag-rtl .ag-tab-selected:not(:first-of-type) {\n  border-right-color: var(--ag-border-color);\n}\n\n.ag-theme-quartz .ag-ltr .ag-tab-selected:not(:last-of-type), .ag-theme-quartz-dark .ag-ltr .ag-tab-selected:not(:last-of-type), .ag-theme-quartz-auto-dark .ag-ltr .ag-tab-selected:not(:last-of-type) {\n  border-right-color: var(--ag-border-color);\n}\n\n.ag-theme-quartz .ag-rtl .ag-tab-selected:not(:last-of-type), .ag-theme-quartz-dark .ag-rtl .ag-tab-selected:not(:last-of-type), .ag-theme-quartz-auto-dark .ag-rtl .ag-tab-selected:not(:last-of-type) {\n  border-left-color: var(--ag-border-color);\n}\n\n.ag-theme-quartz .ag-tab:not(.ag-tab-selected),\n.ag-theme-quartz-dark .ag-tab:not(.ag-tab-selected),\n.ag-theme-quartz-auto-dark .ag-tab:not(.ag-tab-selected) {\n  opacity: 0.7;\n}\n.ag-theme-quartz .ag-tab:not(.ag-tab-selected):hover,\n.ag-theme-quartz-dark .ag-tab:not(.ag-tab-selected):hover,\n.ag-theme-quartz-auto-dark .ag-tab:not(.ag-tab-selected):hover {\n  opacity: 1;\n}\n.ag-theme-quartz .ag-menu,\n.ag-theme-quartz-dark .ag-menu,\n.ag-theme-quartz-auto-dark .ag-menu {\n  color: color-mix(in srgb, transparent, var(--ag-foreground-color) 95%);\n}\n.ag-theme-quartz .ag-panel-content-wrapper .ag-column-select,\n.ag-theme-quartz-dark .ag-panel-content-wrapper .ag-column-select,\n.ag-theme-quartz-auto-dark .ag-panel-content-wrapper .ag-column-select {\n  background-color: var(--ag-control-panel-background-color);\n  color: color-mix(in srgb, transparent, var(--ag-foreground-color) 95%);\n}\n.ag-theme-quartz .ag-menu-header,\n.ag-theme-quartz-dark .ag-menu-header,\n.ag-theme-quartz-auto-dark .ag-menu-header {\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-quartz .ag-menu-option,\n.ag-theme-quartz-dark .ag-menu-option,\n.ag-theme-quartz-auto-dark .ag-menu-option {\n  font-weight: 500;\n  cursor: pointer;\n}\n.ag-theme-quartz .ag-ltr .ag-menu-option-popup-pointer .ag-icon, .ag-theme-quartz-dark .ag-ltr .ag-menu-option-popup-pointer .ag-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-menu-option-popup-pointer .ag-icon {\n  text-align: right;\n}\n\n.ag-theme-quartz .ag-rtl .ag-menu-option-popup-pointer .ag-icon, .ag-theme-quartz-dark .ag-rtl .ag-menu-option-popup-pointer .ag-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-menu-option-popup-pointer .ag-icon {\n  text-align: left;\n}\n\n.ag-theme-quartz .ag-tabs-header,\n.ag-theme-quartz-dark .ag-tabs-header,\n.ag-theme-quartz-auto-dark .ag-tabs-header {\n  border-bottom: var(--ag-borders) var(--ag-border-color);\n  display: flex;\n  background-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 5%);\n}\n.ag-theme-quartz .ag-side-bar,\n.ag-theme-quartz-dark .ag-side-bar,\n.ag-theme-quartz-auto-dark .ag-side-bar {\n  background-color: var(--ag-control-panel-background-color);\n  min-width: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n}\n.ag-theme-quartz .ag-side-buttons,\n.ag-theme-quartz-dark .ag-side-buttons,\n.ag-theme-quartz-auto-dark .ag-side-buttons {\n  padding: 0;\n  align-self: stretch;\n  width: calc(var(--ag-icon-size) + var(--ag-grid-size) * 2);\n  background: var(--ag-control-panel-background-color);\n}\n.ag-theme-quartz .ag-side-button,\n.ag-theme-quartz-dark .ag-side-button,\n.ag-theme-quartz-auto-dark .ag-side-button {\n  border-top: var(--ag-borders) transparent;\n  border-bottom: var(--ag-borders) transparent;\n}\n@media (-webkit-max-device-pixel-ratio: 1.5), (max-resolution: 1.5x) {\n  .ag-theme-quartz .ag-side-button-label,\n  .ag-theme-quartz-dark .ag-side-button-label,\n  .ag-theme-quartz-auto-dark .ag-side-button-label {\n    font-family: "Segoe UI", var(--ag-font-family);\n    transform: rotate(0.05deg);\n  }\n}\n.ag-theme-quartz .ag-side-button.ag-selected,\n.ag-theme-quartz-dark .ag-side-button.ag-selected,\n.ag-theme-quartz-auto-dark .ag-side-button.ag-selected {\n  border-bottom-color: var(--ag-border-color);\n  background-color: var(--ag-background-color);\n}\n.ag-theme-quartz .ag-side-button.ag-selected:not(:first-of-type),\n.ag-theme-quartz-dark .ag-side-button.ag-selected:not(:first-of-type),\n.ag-theme-quartz-auto-dark .ag-side-button.ag-selected:not(:first-of-type) {\n  border-top-color: var(--ag-border-color);\n}\n.ag-theme-quartz .ag-column-panel-column-select,\n.ag-theme-quartz-dark .ag-column-panel-column-select,\n.ag-theme-quartz-auto-dark .ag-column-panel-column-select {\n  border-top: none;\n  border-bottom: 1px solid var(--ag-secondary-border-color);\n}\n.ag-theme-quartz .ag-filter-toolpanel-search,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-search {\n  height: auto;\n  height: initial;\n  margin-top: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-filter-toolpanel-search-input,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search-input,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-search-input {\n  margin: 0;\n}\n.ag-theme-quartz .ag-filter-apply-panel,\n.ag-theme-quartz-dark .ag-filter-apply-panel,\n.ag-theme-quartz-auto-dark .ag-filter-apply-panel {\n  border: none;\n  padding-top: var(--ag-widget-vertical-spacing);\n}\n.ag-theme-quartz .ag-chart-tabbed-menu-body,\n.ag-theme-quartz-dark .ag-chart-tabbed-menu-body,\n.ag-theme-quartz-auto-dark .ag-chart-tabbed-menu-body {\n  position: relative;\n}\n.ag-theme-quartz .ag-chart-tabbed-menu-body::after,\n.ag-theme-quartz-dark .ag-chart-tabbed-menu-body::after,\n.ag-theme-quartz-auto-dark .ag-chart-tabbed-menu-body::after {\n  content: "";\n  position: absolute;\n  display: block;\n  top: 0;\n  left: 0;\n  right: 0;\n  height: 16px;\n  background: linear-gradient(var(--ag-control-panel-background-color), transparent);\n}\n.ag-theme-quartz .ag-charts-settings-group-title-bar,\n.ag-theme-quartz .ag-charts-data-group-title-bar,\n.ag-theme-quartz .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-settings-group-container,\n.ag-theme-quartz-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-settings-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-container {\n  border-top: none;\n  font-weight: 500;\n}\n.ag-theme-quartz .ag-chart-mini-thumbnail,\n.ag-theme-quartz-dark .ag-chart-mini-thumbnail,\n.ag-theme-quartz-auto-dark .ag-chart-mini-thumbnail {\n  background-color: var(--ag-background-color);\n  margin-top: 0;\n  margin-bottom: 0;\n}\n.ag-theme-quartz .ag-chart-settings-nav-bar,\n.ag-theme-quartz-dark .ag-chart-settings-nav-bar,\n.ag-theme-quartz-auto-dark .ag-chart-settings-nav-bar {\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n.ag-theme-quartz .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-title-bar {\n  background: none;\n  font-weight: 500;\n}\n.ag-theme-quartz .ag-chart-data-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz .ag-chart-format-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz-dark .ag-chart-data-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz-dark .ag-chart-format-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz-auto-dark .ag-chart-data-section .ag-label:not(.ag-group-title-bar),\n.ag-theme-quartz-auto-dark .ag-chart-format-section .ag-label:not(.ag-group-title-bar) {\n  color: var(--ag-chart-menu-label-color);\n}\n.ag-theme-quartz .ag-chart-data-section .ag-label-align-top .ag-label,\n.ag-theme-quartz .ag-chart-format-section .ag-label-align-top .ag-label,\n.ag-theme-quartz-dark .ag-chart-data-section .ag-label-align-top .ag-label,\n.ag-theme-quartz-dark .ag-chart-format-section .ag-label-align-top .ag-label,\n.ag-theme-quartz-auto-dark .ag-chart-data-section .ag-label-align-top .ag-label,\n.ag-theme-quartz-auto-dark .ag-chart-format-section .ag-label-align-top .ag-label {\n  margin-top: calc(var(--ag-widget-vertical-spacing) * 0.5);\n  margin-bottom: var(--ag-widget-vertical-spacing);\n}\n.ag-theme-quartz .ag-chart-data-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz .ag-chart-format-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz-dark .ag-chart-data-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz-dark .ag-chart-format-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz-auto-dark .ag-chart-data-section .ag-slider.ag-label-align-top .ag-label,\n.ag-theme-quartz-auto-dark .ag-chart-format-section .ag-slider.ag-label-align-top .ag-label {\n  margin-bottom: 0;\n}\n.ag-theme-quartz .ag-chart-data-section label,\n.ag-theme-quartz .ag-chart-format-section label,\n.ag-theme-quartz-dark .ag-chart-data-section label,\n.ag-theme-quartz-dark .ag-chart-format-section label,\n.ag-theme-quartz-auto-dark .ag-chart-data-section label,\n.ag-theme-quartz-auto-dark .ag-chart-format-section label {\n  display: inline-block;\n}\n.ag-theme-quartz .ag-chart-format-wrapper,\n.ag-theme-quartz .ag-chart-data-wrapper,\n.ag-theme-quartz .ag-charts-format-top-level-group,\n.ag-theme-quartz .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz .ag-charts-format-top-level-group-item,\n.ag-theme-quartz .ag-charts-format-sub-level-group,\n.ag-theme-quartz .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-quartz .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz .ag-charts-data-group-title-bar,\n.ag-theme-quartz .ag-charts-data-group-container,\n.ag-theme-quartz .ag-charts-settings-group-title-bar,\n.ag-theme-quartz .ag-charts-settings-group-container,\n.ag-theme-quartz-dark .ag-chart-format-wrapper,\n.ag-theme-quartz-dark .ag-chart-data-wrapper,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-item,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-data-group-container,\n.ag-theme-quartz-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-settings-group-container,\n.ag-theme-quartz-auto-dark .ag-chart-format-wrapper,\n.ag-theme-quartz-auto-dark .ag-chart-data-wrapper,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-item,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-item:last-child,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-container {\n  padding: 0;\n  margin: 0;\n}\n.ag-theme-quartz .ag-charts-format-top-level-group,\n.ag-theme-quartz .ag-charts-data-group,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group,\n.ag-theme-quartz-dark .ag-charts-data-group,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group,\n.ag-theme-quartz-auto-dark .ag-charts-data-group {\n  border-top: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n.ag-theme-quartz .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-data-group-title-bar,\n.ag-theme-quartz .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-settings-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group-title-bar {\n  padding: var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);\n}\n.ag-theme-quartz .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz .ag-charts-data-group .ag-charts-data-group-container,\n.ag-theme-quartz .ag-charts-settings-group .ag-charts-settings-group-container,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz-dark .ag-charts-data-group .ag-charts-data-group-container,\n.ag-theme-quartz-dark .ag-charts-settings-group .ag-charts-settings-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group .ag-charts-format-top-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-data-group .ag-charts-data-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-settings-group .ag-charts-settings-group-container {\n  padding: 0 var(--ag-widget-container-horizontal-padding);\n}\n.ag-theme-quartz .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-title-bar {\n  padding: var(--ag-widget-vertical-spacing) 0;\n}\n.ag-theme-quartz .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-container {\n  padding-top: var(--ag-widget-vertical-spacing);\n  padding-bottom: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-charts-format-top-level-group-container > *,\n.ag-theme-quartz .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz-dark .ag-charts-format-top-level-group-container > *,\n.ag-theme-quartz-dark .ag-charts-format-sub-level-group-container > *,\n.ag-theme-quartz-auto-dark .ag-charts-format-top-level-group-container > *,\n.ag-theme-quartz-auto-dark .ag-charts-format-sub-level-group-container > * {\n  margin-bottom: var(--ag-widget-vertical-spacing);\n}\n.ag-theme-quartz .ag-charts-data-group-item,\n.ag-theme-quartz-dark .ag-charts-data-group-item,\n.ag-theme-quartz-auto-dark .ag-charts-data-group-item {\n  padding-bottom: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-chart-settings-mini-wrapper,\n.ag-theme-quartz-dark .ag-chart-settings-mini-wrapper,\n.ag-theme-quartz-auto-dark .ag-chart-settings-mini-wrapper {\n  padding-bottom: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-chart-advanced-settings-section,\n.ag-theme-quartz-dark .ag-chart-advanced-settings-section,\n.ag-theme-quartz-auto-dark .ag-chart-advanced-settings-section {\n  padding-top: var(--ag-widget-container-vertical-padding);\n  padding-bottom: var(--ag-widget-container-vertical-padding);\n}\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-container,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group .ag-charts-advanced-settings-top-level-group-container {\n  padding: 0 var(--ag-widget-container-horizontal-padding);\n}\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group-container,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group-container,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group-container {\n  margin: 0;\n}\n.ag-theme-quartz .ag-charts-advanced-settings-top-level-group-item,\n.ag-theme-quartz-dark .ag-charts-advanced-settings-top-level-group-item,\n.ag-theme-quartz-auto-dark .ag-charts-advanced-settings-top-level-group-item {\n  margin-top: calc(var(--ag-widget-vertical-spacing) * 2);\n  margin-bottom: 0;\n}\n.ag-theme-quartz .ag-ltr .ag-group-title-bar-icon, .ag-theme-quartz-dark .ag-ltr .ag-group-title-bar-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-group-title-bar-icon {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl .ag-group-title-bar-icon, .ag-theme-quartz-dark .ag-rtl .ag-group-title-bar-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-group-title-bar-icon {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-spectrum-color,\n.ag-theme-quartz .ag-spectrum-fill,\n.ag-theme-quartz-dark .ag-spectrum-color,\n.ag-theme-quartz-dark .ag-spectrum-fill,\n.ag-theme-quartz-auto-dark .ag-spectrum-color,\n.ag-theme-quartz-auto-dark .ag-spectrum-fill {\n  border-radius: var(--ag-border-radius);\n}\n.ag-theme-quartz .ag-spectrum-dragger,\n.ag-theme-quartz-dark .ag-spectrum-dragger,\n.ag-theme-quartz-auto-dark .ag-spectrum-dragger {\n  border-radius: 18px;\n  height: 18px;\n  width: 18px;\n  border: 3px solid white;\n}\n.ag-theme-quartz .ag-spectrum-tools,\n.ag-theme-quartz-dark .ag-spectrum-tools,\n.ag-theme-quartz-auto-dark .ag-spectrum-tools {\n  padding-left: 0;\n  padding-right: 0;\n  padding-bottom: 0;\n}\n.ag-theme-quartz .ag-spectrum-tool,\n.ag-theme-quartz-dark .ag-spectrum-tool,\n.ag-theme-quartz-auto-dark .ag-spectrum-tool {\n  height: 12px;\n}\n.ag-theme-quartz .ag-spectrum-hue-background,\n.ag-theme-quartz .ag-spectrum-alpha-background,\n.ag-theme-quartz-dark .ag-spectrum-hue-background,\n.ag-theme-quartz-dark .ag-spectrum-alpha-background,\n.ag-theme-quartz-auto-dark .ag-spectrum-hue-background,\n.ag-theme-quartz-auto-dark .ag-spectrum-alpha-background {\n  border-radius: 12px;\n}\n.ag-theme-quartz .ag-spectrum-slider,\n.ag-theme-quartz-dark .ag-spectrum-slider,\n.ag-theme-quartz-auto-dark .ag-spectrum-slider {\n  margin-top: -15px;\n  width: 18px;\n  height: 18px;\n  border-radius: 18px;\n  border: 3px solid rgb(248, 248, 248);\n}\n.ag-theme-quartz .ag-recent-colors,\n.ag-theme-quartz-dark .ag-recent-colors,\n.ag-theme-quartz-auto-dark .ag-recent-colors {\n  margin-left: var(--ag-grid-size);\n  margin-right: var(--ag-grid-size);\n  margin-bottom: 2px;\n}\n.ag-theme-quartz .ag-color-input-color,\n.ag-theme-quartz .ag-color-picker-color,\n.ag-theme-quartz .ag-recent-color,\n.ag-theme-quartz-dark .ag-color-input-color,\n.ag-theme-quartz-dark .ag-color-picker-color,\n.ag-theme-quartz-dark .ag-recent-color,\n.ag-theme-quartz-auto-dark .ag-color-input-color,\n.ag-theme-quartz-auto-dark .ag-color-picker-color,\n.ag-theme-quartz-auto-dark .ag-recent-color {\n  border-radius: 4px;\n}\n.ag-theme-quartz .ag-recent-color,\n.ag-theme-quartz-dark .ag-recent-color,\n.ag-theme-quartz-auto-dark .ag-recent-color {\n  border: var(--ag-borders-secondary) var(--ag-secondary-border-color);\n}\n.ag-theme-quartz.ag-dnd-ghost,\n.ag-theme-quartz-dark.ag-dnd-ghost,\n.ag-theme-quartz-auto-dark.ag-dnd-ghost {\n  font-weight: 500;\n}\n.ag-theme-quartz .ag-standard-button,\n.ag-theme-quartz-dark .ag-standard-button,\n.ag-theme-quartz-auto-dark .ag-standard-button {\n  font-family: inherit;\n  -moz-appearance: none;\n       appearance: none;\n  -webkit-appearance: none;\n  border-radius: var(--ag-border-radius);\n  border: solid 1px var(--ag-input-border-color);\n  background-color: var(--ag-background-color);\n  padding: var(--ag-grid-size) calc(var(--ag-grid-size) * 2);\n  cursor: pointer;\n}\n.ag-theme-quartz .ag-standard-button:hover,\n.ag-theme-quartz-dark .ag-standard-button:hover,\n.ag-theme-quartz-auto-dark .ag-standard-button:hover {\n  background-color: var(--ag-row-hover-color);\n}\n.ag-theme-quartz .ag-standard-button:active,\n.ag-theme-quartz-dark .ag-standard-button:active,\n.ag-theme-quartz-auto-dark .ag-standard-button:active {\n  border-color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-standard-button:disabled,\n.ag-theme-quartz-dark .ag-standard-button:disabled,\n.ag-theme-quartz-auto-dark .ag-standard-button:disabled {\n  color: var(--ag-disabled-foreground-color);\n  background-color: var(--ag-input-disabled-background-color);\n  border-color: var(--ag-input-disabled-border-color);\n}\n.ag-theme-quartz .ag-column-drop-cell,\n.ag-theme-quartz-dark .ag-column-drop-cell,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell {\n  border-radius: calc(var(--ag-grid-size) * 3);\n  height: calc(var(--ag-grid-size) * 3);\n  padding: 0 var(--ag-grid-size);\n}\n.ag-theme-quartz .ag-column-drop-cell-button,\n.ag-theme-quartz-dark .ag-column-drop-cell-button,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell-button {\n  min-width: 0;\n  margin: 0;\n}\n.ag-theme-quartz .ag-column-drop-cell-drag-handle,\n.ag-theme-quartz-dark .ag-column-drop-cell-drag-handle,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell-drag-handle {\n  margin-left: 0;\n}\n.ag-theme-quartz .ag-column-drop-vertical,\n.ag-theme-quartz-dark .ag-column-drop-vertical,\n.ag-theme-quartz-auto-dark .ag-column-drop-vertical {\n  min-height: 75px;\n}\n.ag-theme-quartz .ag-column-drop-vertical-title-bar,\n.ag-theme-quartz-dark .ag-column-drop-vertical-title-bar,\n.ag-theme-quartz-auto-dark .ag-column-drop-vertical-title-bar {\n  padding: var(--ag-widget-container-vertical-padding) calc(var(--ag-grid-size) * 2) 0;\n}\n.ag-theme-quartz .ag-ltr .ag-column-drop-vertical-icon, .ag-theme-quartz-dark .ag-ltr .ag-column-drop-vertical-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-drop-vertical-icon {\n  margin-left: 0;\n  margin-right: var(--ag-widget-horizontal-spacing);\n}\n\n.ag-theme-quartz .ag-rtl .ag-column-drop-vertical-icon, .ag-theme-quartz-dark .ag-rtl .ag-column-drop-vertical-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-drop-vertical-icon {\n  margin-right: 0;\n  margin-left: var(--ag-widget-horizontal-spacing);\n}\n\n.ag-theme-quartz .ag-column-drop-vertical-empty-message,\n.ag-theme-quartz-dark .ag-column-drop-vertical-empty-message,\n.ag-theme-quartz-auto-dark .ag-column-drop-vertical-empty-message {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  border: dashed 1px;\n  border-color: var(--ag-border-color);\n  margin: calc(var(--ag-grid-size) * 1.5) calc(var(--ag-grid-size) * 2);\n  padding: calc(var(--ag-grid-size) * 2);\n}\n.ag-theme-quartz .ag-column-drop-empty-message,\n.ag-theme-quartz-dark .ag-column-drop-empty-message,\n.ag-theme-quartz-auto-dark .ag-column-drop-empty-message {\n  color: var(--ag-foreground-color);\n}\n.ag-theme-quartz .ag-pill-select .ag-column-drop,\n.ag-theme-quartz-dark .ag-pill-select .ag-column-drop,\n.ag-theme-quartz-auto-dark .ag-pill-select .ag-column-drop {\n  min-height: 0;\n  min-height: initial;\n}\n.ag-theme-quartz .ag-pill-select .ag-picker-field-display,\n.ag-theme-quartz-dark .ag-pill-select .ag-picker-field-display,\n.ag-theme-quartz-auto-dark .ag-pill-select .ag-picker-field-display {\n  font-weight: 500;\n  color: var(--ag-chart-menu-pill-select-button-color);\n}\n.ag-theme-quartz .ag-pill-select .ag-picker-field-icon .ag-icon,\n.ag-theme-quartz-dark .ag-pill-select .ag-picker-field-icon .ag-icon,\n.ag-theme-quartz-auto-dark .ag-pill-select .ag-picker-field-icon .ag-icon {\n  color: var(--ag-chart-menu-pill-select-button-color);\n}\n.ag-theme-quartz .ag-status-bar,\n.ag-theme-quartz-dark .ag-status-bar,\n.ag-theme-quartz-auto-dark .ag-status-bar {\n  font-weight: normal;\n}\n.ag-theme-quartz .ag-status-name-value,\n.ag-theme-quartz-dark .ag-status-name-value,\n.ag-theme-quartz-auto-dark .ag-status-name-value {\n  padding: var(--ag-widget-container-vertical-padding) 0;\n}\n.ag-theme-quartz .ag-status-name-value-value,\n.ag-theme-quartz .ag-paging-number,\n.ag-theme-quartz .ag-paging-row-summary-panel-number,\n.ag-theme-quartz-dark .ag-status-name-value-value,\n.ag-theme-quartz-dark .ag-paging-number,\n.ag-theme-quartz-dark .ag-paging-row-summary-panel-number,\n.ag-theme-quartz-auto-dark .ag-status-name-value-value,\n.ag-theme-quartz-auto-dark .ag-paging-number,\n.ag-theme-quartz-auto-dark .ag-paging-row-summary-panel-number {\n  font-weight: 500;\n}\n.ag-theme-quartz .ag-column-drop-cell-button,\n.ag-theme-quartz-dark .ag-column-drop-cell-button,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell-button {\n  opacity: 0.75;\n}\n.ag-theme-quartz .ag-column-drop-cell-button:hover,\n.ag-theme-quartz-dark .ag-column-drop-cell-button:hover,\n.ag-theme-quartz-auto-dark .ag-column-drop-cell-button:hover {\n  opacity: 1;\n}\n.ag-theme-quartz .ag-header-cell-menu-button,\n.ag-theme-quartz .ag-header-cell-filter-button,\n.ag-theme-quartz .ag-panel-title-bar-button,\n.ag-theme-quartz .ag-header-expand-icon,\n.ag-theme-quartz .ag-column-group-icons,\n.ag-theme-quartz .ag-set-filter-group-icons,\n.ag-theme-quartz .ag-group-expanded .ag-icon,\n.ag-theme-quartz .ag-group-contracted .ag-icon,\n.ag-theme-quartz .ag-chart-settings-prev,\n.ag-theme-quartz .ag-chart-settings-next,\n.ag-theme-quartz .ag-group-title-bar-icon,\n.ag-theme-quartz .ag-column-select-header-icon,\n.ag-theme-quartz .ag-floating-filter-button-button,\n.ag-theme-quartz .ag-filter-toolpanel-expand,\n.ag-theme-quartz .ag-panel-title-bar-button-icon,\n.ag-theme-quartz .ag-chart-menu-icon,\n.ag-theme-quartz-dark .ag-header-cell-menu-button,\n.ag-theme-quartz-dark .ag-header-cell-filter-button,\n.ag-theme-quartz-dark .ag-panel-title-bar-button,\n.ag-theme-quartz-dark .ag-header-expand-icon,\n.ag-theme-quartz-dark .ag-column-group-icons,\n.ag-theme-quartz-dark .ag-set-filter-group-icons,\n.ag-theme-quartz-dark .ag-group-expanded .ag-icon,\n.ag-theme-quartz-dark .ag-group-contracted .ag-icon,\n.ag-theme-quartz-dark .ag-chart-settings-prev,\n.ag-theme-quartz-dark .ag-chart-settings-next,\n.ag-theme-quartz-dark .ag-group-title-bar-icon,\n.ag-theme-quartz-dark .ag-column-select-header-icon,\n.ag-theme-quartz-dark .ag-floating-filter-button-button,\n.ag-theme-quartz-dark .ag-filter-toolpanel-expand,\n.ag-theme-quartz-dark .ag-panel-title-bar-button-icon,\n.ag-theme-quartz-dark .ag-chart-menu-icon,\n.ag-theme-quartz-auto-dark .ag-header-cell-menu-button,\n.ag-theme-quartz-auto-dark .ag-header-cell-filter-button,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-button,\n.ag-theme-quartz-auto-dark .ag-header-expand-icon,\n.ag-theme-quartz-auto-dark .ag-column-group-icons,\n.ag-theme-quartz-auto-dark .ag-set-filter-group-icons,\n.ag-theme-quartz-auto-dark .ag-group-expanded .ag-icon,\n.ag-theme-quartz-auto-dark .ag-group-contracted .ag-icon,\n.ag-theme-quartz-auto-dark .ag-chart-settings-prev,\n.ag-theme-quartz-auto-dark .ag-chart-settings-next,\n.ag-theme-quartz-auto-dark .ag-group-title-bar-icon,\n.ag-theme-quartz-auto-dark .ag-column-select-header-icon,\n.ag-theme-quartz-auto-dark .ag-floating-filter-button-button,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-expand,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-button-icon,\n.ag-theme-quartz-auto-dark .ag-chart-menu-icon {\n  --ag-quartz-icon-hover-color: color-mix(in srgb, transparent, var(--ag-foreground-color) 10%);\n}\n.ag-theme-quartz .ag-header-cell-menu-button:hover,\n.ag-theme-quartz .ag-header-cell-filter-button:hover,\n.ag-theme-quartz .ag-panel-title-bar-button:hover,\n.ag-theme-quartz .ag-header-expand-icon:hover,\n.ag-theme-quartz .ag-column-group-icons:hover,\n.ag-theme-quartz .ag-set-filter-group-icons:hover,\n.ag-theme-quartz .ag-group-expanded .ag-icon:hover,\n.ag-theme-quartz .ag-group-contracted .ag-icon:hover,\n.ag-theme-quartz .ag-chart-settings-prev:hover,\n.ag-theme-quartz .ag-chart-settings-next:hover,\n.ag-theme-quartz .ag-group-title-bar-icon:hover,\n.ag-theme-quartz .ag-column-select-header-icon:hover,\n.ag-theme-quartz .ag-floating-filter-button-button:hover,\n.ag-theme-quartz .ag-filter-toolpanel-expand:hover,\n.ag-theme-quartz .ag-panel-title-bar-button-icon:hover,\n.ag-theme-quartz .ag-chart-menu-icon:hover,\n.ag-theme-quartz-dark .ag-header-cell-menu-button:hover,\n.ag-theme-quartz-dark .ag-header-cell-filter-button:hover,\n.ag-theme-quartz-dark .ag-panel-title-bar-button:hover,\n.ag-theme-quartz-dark .ag-header-expand-icon:hover,\n.ag-theme-quartz-dark .ag-column-group-icons:hover,\n.ag-theme-quartz-dark .ag-set-filter-group-icons:hover,\n.ag-theme-quartz-dark .ag-group-expanded .ag-icon:hover,\n.ag-theme-quartz-dark .ag-group-contracted .ag-icon:hover,\n.ag-theme-quartz-dark .ag-chart-settings-prev:hover,\n.ag-theme-quartz-dark .ag-chart-settings-next:hover,\n.ag-theme-quartz-dark .ag-group-title-bar-icon:hover,\n.ag-theme-quartz-dark .ag-column-select-header-icon:hover,\n.ag-theme-quartz-dark .ag-floating-filter-button-button:hover,\n.ag-theme-quartz-dark .ag-filter-toolpanel-expand:hover,\n.ag-theme-quartz-dark .ag-panel-title-bar-button-icon:hover,\n.ag-theme-quartz-dark .ag-chart-menu-icon:hover,\n.ag-theme-quartz-auto-dark .ag-header-cell-menu-button:hover,\n.ag-theme-quartz-auto-dark .ag-header-cell-filter-button:hover,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-button:hover,\n.ag-theme-quartz-auto-dark .ag-header-expand-icon:hover,\n.ag-theme-quartz-auto-dark .ag-column-group-icons:hover,\n.ag-theme-quartz-auto-dark .ag-set-filter-group-icons:hover,\n.ag-theme-quartz-auto-dark .ag-group-expanded .ag-icon:hover,\n.ag-theme-quartz-auto-dark .ag-group-contracted .ag-icon:hover,\n.ag-theme-quartz-auto-dark .ag-chart-settings-prev:hover,\n.ag-theme-quartz-auto-dark .ag-chart-settings-next:hover,\n.ag-theme-quartz-auto-dark .ag-group-title-bar-icon:hover,\n.ag-theme-quartz-auto-dark .ag-column-select-header-icon:hover,\n.ag-theme-quartz-auto-dark .ag-floating-filter-button-button:hover,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-expand:hover,\n.ag-theme-quartz-auto-dark .ag-panel-title-bar-button-icon:hover,\n.ag-theme-quartz-auto-dark .ag-chart-menu-icon:hover {\n  border-radius: 1px;\n  background-color: var(--ag-quartz-icon-hover-color);\n  box-shadow: 0 0 0 4px var(--ag-quartz-icon-hover-color);\n}\n.ag-theme-quartz .ag-filter-active,\n.ag-theme-quartz-dark .ag-filter-active,\n.ag-theme-quartz-auto-dark .ag-filter-active {\n  --ag-quartz-icon-active-color: color-mix(in srgb, transparent, var(--ag-active-color) 14%);\n  --ag-quartz-icon-hover-color: color-mix(in srgb, transparent, var(--ag-active-color) 28%);\n  position: relative;\n  border-radius: 1px;\n  background-color: var(--ag-quartz-icon-active-color);\n  box-shadow: 0 0 0 4px var(--ag-quartz-icon-active-color);\n}\n.ag-theme-quartz .ag-filter-active::after,\n.ag-theme-quartz-dark .ag-filter-active::after,\n.ag-theme-quartz-auto-dark .ag-filter-active::after {\n  content: "";\n  position: absolute;\n  width: 6px;\n  height: 6px;\n  top: -1px;\n  right: -1px;\n  border-radius: 50%;\n  background-color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-filter-active .ag-icon-filter,\n.ag-theme-quartz-dark .ag-filter-active .ag-icon-filter,\n.ag-theme-quartz-auto-dark .ag-filter-active .ag-icon-filter {\n  clip-path: path("M8,0C8,4.415 11.585,8 16,8L16,16L0,16L0,0L8,0Z");\n}\n.ag-theme-quartz .ag-chart-menu,\n.ag-theme-quartz-dark .ag-chart-menu,\n.ag-theme-quartz-auto-dark .ag-chart-menu {\n  --ag-icon-size: 20px;\n  background-color: color-mix(in srgb, transparent, var(--ag-background-color) 30%);\n  padding: 4px 2px;\n}\n.ag-theme-quartz .ag-chart-menu-icon,\n.ag-theme-quartz-dark .ag-chart-menu-icon,\n.ag-theme-quartz-auto-dark .ag-chart-menu-icon {\n  opacity: 0.8;\n}\n.ag-theme-quartz .ag-drag-handle,\n.ag-theme-quartz-dark .ag-drag-handle,\n.ag-theme-quartz-auto-dark .ag-drag-handle {\n  color: var(--ag-icon-font-color);\n}\n.ag-theme-quartz .ag-menu-option-icon,\n.ag-theme-quartz .ag-compact-menu-option-icon,\n.ag-theme-quartz-dark .ag-menu-option-icon,\n.ag-theme-quartz-dark .ag-compact-menu-option-icon,\n.ag-theme-quartz-auto-dark .ag-menu-option-icon,\n.ag-theme-quartz-auto-dark .ag-compact-menu-option-icon {\n  width: var(--ag-icon-size);\n  cursor: pointer;\n}\n.ag-theme-quartz .ag-ltr .ag-menu-option-icon, .ag-theme-quartz .ag-ltr .ag-compact-menu-option-icon, .ag-theme-quartz-dark .ag-ltr .ag-menu-option-icon, .ag-theme-quartz-dark .ag-ltr .ag-compact-menu-option-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-menu-option-icon, .ag-theme-quartz-auto-dark .ag-ltr .ag-compact-menu-option-icon {\n  padding-left: calc(var(--ag-grid-size) * 1.5);\n}\n\n.ag-theme-quartz .ag-rtl .ag-menu-option-icon, .ag-theme-quartz .ag-rtl .ag-compact-menu-option-icon, .ag-theme-quartz-dark .ag-rtl .ag-menu-option-icon, .ag-theme-quartz-dark .ag-rtl .ag-compact-menu-option-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-menu-option-icon, .ag-theme-quartz-auto-dark .ag-rtl .ag-compact-menu-option-icon {\n  padding-right: calc(var(--ag-grid-size) * 1.5);\n}\n\n.ag-theme-quartz .ag-chart-settings-card-item.ag-not-selected:hover,\n.ag-theme-quartz-dark .ag-chart-settings-card-item.ag-not-selected:hover,\n.ag-theme-quartz-auto-dark .ag-chart-settings-card-item.ag-not-selected:hover {\n  opacity: 0.35;\n}\n.ag-theme-quartz .ag-ltr .ag-panel-title-bar-button, .ag-theme-quartz-dark .ag-ltr .ag-panel-title-bar-button, .ag-theme-quartz-auto-dark .ag-ltr .ag-panel-title-bar-button {\n  margin-left: calc(var(--ag-grid-size) * 2);\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl .ag-panel-title-bar-button, .ag-theme-quartz-dark .ag-rtl .ag-panel-title-bar-button, .ag-theme-quartz-auto-dark .ag-rtl .ag-panel-title-bar-button {\n  margin-right: calc(var(--ag-grid-size) * 2);\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-multi-filter-group-title-bar,\n.ag-theme-quartz-dark .ag-multi-filter-group-title-bar,\n.ag-theme-quartz-auto-dark .ag-multi-filter-group-title-bar {\n  padding: calc(var(--ag-grid-size) * 1.5) var(--ag-grid-size);\n}\n.ag-theme-quartz .ag-ltr .ag-filter-toolpanel-instance-body, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-instance-body, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-instance-body {\n  padding-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl .ag-filter-toolpanel-instance-body, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-instance-body, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-instance-body {\n  padding-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-filter-toolpanel-instance-filter,\n.ag-theme-quartz-dark .ag-filter-toolpanel-instance-filter,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-instance-filter {\n  border: none;\n  background-color: var(--ag-control-panel-background-color);\n}\n.ag-theme-quartz .ag-ltr .ag-filter-toolpanel-instance-filter, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-instance-filter, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-instance-filter {\n  margin-left: calc(var(--ag-icon-size) * 0.5);\n}\n\n.ag-theme-quartz .ag-rtl .ag-filter-toolpanel-instance-filter, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-instance-filter, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-instance-filter {\n  margin-right: calc(var(--ag-icon-size) * 0.5);\n}\n\n.ag-theme-quartz .ag-filter-toolpanel-group-level-0,\n.ag-theme-quartz-dark .ag-filter-toolpanel-group-level-0,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-group-level-0 {\n  border-top: none;\n}\n.ag-theme-quartz .ag-filter-toolpanel-header,\n.ag-theme-quartz-dark .ag-filter-toolpanel-header,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-header {\n  height: auto;\n  height: initial;\n  padding-top: var(--ag-grid-size);\n  padding-bottom: var(--ag-grid-size);\n}\n.ag-theme-quartz .ag-filter-toolpanel-group-item,\n.ag-theme-quartz-dark .ag-filter-toolpanel-group-item,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-group-item {\n  margin: 0;\n}\n.ag-theme-quartz .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-quartz .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-quartz .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-quartz .ag-layout-print .ag-center-cols-container,\n.ag-theme-quartz-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-quartz-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-quartz-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-quartz-dark .ag-layout-print .ag-center-cols-container,\n.ag-theme-quartz-auto-dark .ag-layout-auto-height .ag-center-cols-viewport,\n.ag-theme-quartz-auto-dark .ag-layout-auto-height .ag-center-cols-container,\n.ag-theme-quartz-auto-dark .ag-layout-print .ag-center-cols-viewport,\n.ag-theme-quartz-auto-dark .ag-layout-print .ag-center-cols-container {\n  min-height: 150px;\n}\n.ag-theme-quartz .ag-date-time-list-page-entry-is-current,\n.ag-theme-quartz-dark .ag-date-time-list-page-entry-is-current,\n.ag-theme-quartz-auto-dark .ag-date-time-list-page-entry-is-current {\n  background-color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-advanced-filter-builder-button,\n.ag-theme-quartz-dark .ag-advanced-filter-builder-button,\n.ag-theme-quartz-auto-dark .ag-advanced-filter-builder-button {\n  padding: var(--ag-grid-size);\n  font-weight: 600;\n}\n.ag-theme-quartz .ag-advanced-filter-builder-item-button-disabled .ag-icon,\n.ag-theme-quartz .ag-disabled .ag-icon,\n.ag-theme-quartz .ag-column-select-column-group-readonly .ag-icon,\n.ag-theme-quartz [disabled] .ag-icon,\n.ag-theme-quartz-dark .ag-advanced-filter-builder-item-button-disabled .ag-icon,\n.ag-theme-quartz-dark .ag-disabled .ag-icon,\n.ag-theme-quartz-dark .ag-column-select-column-group-readonly .ag-icon,\n.ag-theme-quartz-dark [disabled] .ag-icon,\n.ag-theme-quartz-auto-dark .ag-advanced-filter-builder-item-button-disabled .ag-icon,\n.ag-theme-quartz-auto-dark .ag-disabled .ag-icon,\n.ag-theme-quartz-auto-dark .ag-column-select-column-group-readonly .ag-icon,\n.ag-theme-quartz-auto-dark [disabled] .ag-icon {\n  opacity: 0.6;\n}\n.ag-theme-quartz .ag-icon-grip,\n.ag-theme-quartz-dark .ag-icon-grip,\n.ag-theme-quartz-auto-dark .ag-icon-grip {\n  opacity: 0.7;\n}\n.ag-theme-quartz .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-quartz .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-quartz-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-quartz-dark .ag-column-select-column-readonly .ag-icon-grip,\n.ag-theme-quartz-auto-dark .ag-column-select-column-readonly.ag-icon-grip,\n.ag-theme-quartz-auto-dark .ag-column-select-column-readonly .ag-icon-grip {\n  opacity: 0.35;\n}\n.ag-theme-quartz .ag-column-select-header-filter-wrapper .ag-input-wrapper::before,\n.ag-theme-quartz .ag-filter-toolpanel-search .ag-input-wrapper::before,\n.ag-theme-quartz .ag-mini-filter .ag-input-wrapper::before,\n.ag-theme-quartz .ag-filter-filter .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-column-select-header-filter-wrapper .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-mini-filter .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-filter-filter .ag-input-wrapper::before,\n.ag-theme-quartz-auto-dark .ag-column-select-header-filter-wrapper .ag-input-wrapper::before,\n.ag-theme-quartz-auto-dark .ag-filter-toolpanel-search .ag-input-wrapper::before,\n.ag-theme-quartz-auto-dark .ag-mini-filter .ag-input-wrapper::before,\n.ag-theme-quartz-auto-dark .ag-filter-filter .ag-input-wrapper::before {\n  position: absolute;\n  display: block;\n  width: 12px;\n  height: 12px;\n  background-image: url(' + h + ');\n  background-position: 50% 50%;\n  background-size: contain;\n  opacity: 0.4;\n  content: "";\n  filter: var(--ag-icon-filter);\n}\n.ag-theme-quartz .ag-ltr .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz .ag-ltr .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz .ag-ltr .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz .ag-ltr .ag-filter-filter .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-ltr .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-ltr .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-ltr .ag-filter-filter .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-ltr .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-filter .ag-input-wrapper::before {\n  margin-left: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-rtl .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz .ag-rtl .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz .ag-rtl .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz .ag-rtl .ag-filter-filter .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-rtl .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-rtl .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz-dark .ag-rtl .ag-filter-filter .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-select-header-filter-wrapper .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-search .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-rtl .ag-mini-filter .ag-input-wrapper::before, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-filter .ag-input-wrapper::before {\n  margin-right: var(--ag-grid-size);\n}\n\n.ag-theme-quartz .ag-ltr .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz .ag-ltr .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz .ag-ltr .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz .ag-ltr .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz .ag-ltr .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz .ag-ltr .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz .ag-ltr .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz .ag-ltr .ag-filter-filter input.ag-number-field-input, .ag-theme-quartz-dark .ag-ltr .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz-dark .ag-ltr .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz-dark .ag-ltr .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz-dark .ag-ltr .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz-dark .ag-ltr .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz-dark .ag-ltr .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz-dark .ag-ltr .ag-filter-filter input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-ltr .ag-filter-filter input.ag-number-field-input {\n  padding-left: 26px;\n}\n\n.ag-theme-quartz .ag-rtl .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz .ag-rtl .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz .ag-rtl .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz .ag-rtl .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz .ag-rtl .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz .ag-rtl .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz .ag-rtl .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz .ag-rtl .ag-filter-filter input.ag-number-field-input, .ag-theme-quartz-dark .ag-rtl .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz-dark .ag-rtl .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz-dark .ag-rtl .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz-dark .ag-rtl .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz-dark .ag-rtl .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz-dark .ag-rtl .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz-dark .ag-rtl .ag-filter-filter input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-select-header-filter-wrapper input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-select-header-filter-wrapper input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-search input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-toolpanel-search input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-mini-filter input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-mini-filter input.ag-number-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-filter input.ag-text-field-input, .ag-theme-quartz-auto-dark .ag-rtl .ag-filter-filter input.ag-number-field-input {\n  padding-right: 26px;\n}\n\n.ag-theme-quartz .ag-ltr .ag-column-select-add-group-indent, .ag-theme-quartz-dark .ag-ltr .ag-column-select-add-group-indent, .ag-theme-quartz-auto-dark .ag-ltr .ag-column-select-add-group-indent {\n  margin-left: calc(var(--ag-icon-size) + var(--ag-grid-size) * 1.5);\n}\n\n.ag-theme-quartz .ag-rtl .ag-column-select-add-group-indent, .ag-theme-quartz-dark .ag-rtl .ag-column-select-add-group-indent, .ag-theme-quartz-auto-dark .ag-rtl .ag-column-select-add-group-indent {\n  margin-right: calc(var(--ag-icon-size) + var(--ag-grid-size) * 1.5);\n}\n\n.ag-theme-quartz .ag-text-field-input[disabled],\n.ag-theme-quartz .ag-menu-option-disabled,\n.ag-theme-quartz-dark .ag-text-field-input[disabled],\n.ag-theme-quartz-dark .ag-menu-option-disabled,\n.ag-theme-quartz-auto-dark .ag-text-field-input[disabled],\n.ag-theme-quartz-auto-dark .ag-menu-option-disabled {\n  cursor: not-allowed;\n}\n.ag-theme-quartz .ag-checkbox-input-wrapper.ag-checked.ag-disabled,\n.ag-theme-quartz-dark .ag-checkbox-input-wrapper.ag-checked.ag-disabled,\n.ag-theme-quartz-auto-dark .ag-checkbox-input-wrapper.ag-checked.ag-disabled {\n  --ag-checkbox-checked-color: var(--ag-checkbox-unchecked-color);\n}\n.ag-theme-quartz .ag-checkbox-input,\n.ag-theme-quartz .ag-toggle-button-input,\n.ag-theme-quartz .ag-radio-button-input,\n.ag-theme-quartz input[class^=ag-][type=range],\n.ag-theme-quartz-dark .ag-checkbox-input,\n.ag-theme-quartz-dark .ag-toggle-button-input,\n.ag-theme-quartz-dark .ag-radio-button-input,\n.ag-theme-quartz-dark input[class^=ag-][type=range],\n.ag-theme-quartz-auto-dark .ag-checkbox-input,\n.ag-theme-quartz-auto-dark .ag-toggle-button-input,\n.ag-theme-quartz-auto-dark .ag-radio-button-input,\n.ag-theme-quartz-auto-dark input[class^=ag-][type=range] {\n  cursor: pointer;\n}\n.ag-theme-quartz .ag-details-row,\n.ag-theme-quartz-dark .ag-details-row,\n.ag-theme-quartz-auto-dark .ag-details-row {\n  padding: calc(var(--ag-grid-size) * 3.75);\n}\n.ag-theme-quartz .ag-list-item-hovered::after,\n.ag-theme-quartz-dark .ag-list-item-hovered::after,\n.ag-theme-quartz-auto-dark .ag-list-item-hovered::after {\n  background-color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-pill .ag-pill-button:hover,\n.ag-theme-quartz-dark .ag-pill .ag-pill-button:hover,\n.ag-theme-quartz-auto-dark .ag-pill .ag-pill-button:hover {\n  color: var(--ag-active-color);\n}\n.ag-theme-quartz .ag-header-highlight-before::after,\n.ag-theme-quartz .ag-header-highlight-after::after,\n.ag-theme-quartz-dark .ag-header-highlight-before::after,\n.ag-theme-quartz-dark .ag-header-highlight-after::after,\n.ag-theme-quartz-auto-dark .ag-header-highlight-before::after,\n.ag-theme-quartz-auto-dark .ag-header-highlight-after::after {\n  background-color: var(--ag-active-color);\n}\n\n.ag-theme-quartz-dark .ag-column-select-header-filter-wrapper .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-filter-toolpanel-search .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-mini-filter .ag-input-wrapper::before,\n.ag-theme-quartz-dark .ag-filter-filter .ag-input-wrapper::before {\n  opacity: 0.66;\n  filter: invert(100%);\n}\n.ag-theme-quartz-dark .ag-chart-menu {\n  background-color: color-mix(in srgb, rgba(24, 39, 50, 0.3), var(--ag-background-color) 30%);\n}\n.ag-theme-quartz-dark .ag-text-field-input::-moz-placeholder {\n  color: var(--ag-data-color);\n  opacity: 0.8;\n}\n.ag-theme-quartz-dark .ag-text-field-input::placeholder {\n  color: var(--ag-data-color);\n  opacity: 0.8;\n}\n', ""]), t2.A = g;
          }, 4131: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(8430), a2.b), c = i()(o()), g = s()(d);
            c.push([e2.id, '@font-face {\n  font-family: "agGridAlpine";\n  src: url(' + g + ");\n  font-weight: normal;\n  font-style: normal;\n}\n", ""]), t2.A = c;
          }, 679: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(9377), a2.b), c = i()(o()), g = s()(d);
            c.push([e2.id, '@font-face {\n  font-family: "agGridBalham";\n  src: url(' + g + ");\n  font-weight: normal;\n  font-style: normal;\n}\n", ""]), t2.A = c;
          }, 4086: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(7738), a2.b), c = i()(o()), g = s()(d);
            c.push([e2.id, '@font-face {\n  font-family: "agGridClassic";\n  src: url(' + g + ");\n  font-weight: normal;\n  font-style: normal;\n}\n", ""]), t2.A = c;
          }, 2249: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(6055), a2.b), c = i()(o()), g = s()(d);
            c.push([e2.id, '@font-face {\n  font-family: "agGridMaterial";\n  src: url(' + g + ");\n  font-weight: normal;\n  font-style: normal;\n}\n", ""]), t2.A = c;
          }, 4011: function(e2, t2, a2) {
            var n = a2(6758), o = a2.n(n), r = a2(935), i = a2.n(r), l = a2(62), s = a2.n(l), d = new URL(a2(2006), a2.b), c = i()(o()), g = s()(d);
            c.push([e2.id, '@font-face {\n  font-family: "agGridQuartz";\n  src: url(' + g + ");\n  font-weight: normal;\n  font-style: normal;\n}\n", ""]), t2.A = c;
          }, 935: function(e2) {
            e2.exports = function(e3) {
              var t2 = [];
              return t2.toString = function() {
                return this.map(function(t3) {
                  var a2 = "", n = void 0 !== t3[5];
                  return t3[4] && (a2 += "@supports (".concat(t3[4], ") {")), t3[2] && (a2 += "@media ".concat(t3[2], " {")), n && (a2 += "@layer".concat(t3[5].length > 0 ? " ".concat(t3[5]) : "", " {")), a2 += e3(t3), n && (a2 += "}"), t3[2] && (a2 += "}"), t3[4] && (a2 += "}"), a2;
                }).join("");
              }, t2.i = function(e4, a2, n, o, r) {
                "string" == typeof e4 && (e4 = [[null, e4, void 0]]);
                var i = {};
                if (n)
                  for (var l = 0; l < this.length; l++) {
                    var s = this[l][0];
                    null != s && (i[s] = true);
                  }
                for (var d = 0; d < e4.length; d++) {
                  var c = [].concat(e4[d]);
                  n && i[c[0]] || (void 0 !== r && (void 0 === c[5] || (c[1] = "@layer".concat(c[5].length > 0 ? " ".concat(c[5]) : "", " {").concat(c[1], "}")), c[5] = r), a2 && (c[2] ? (c[1] = "@media ".concat(c[2], " {").concat(c[1], "}"), c[2] = a2) : c[2] = a2), o && (c[4] ? (c[1] = "@supports (".concat(c[4], ") {").concat(c[1], "}"), c[4] = o) : c[4] = "".concat(o)), t2.push(c));
                }
              }, t2;
            };
          }, 62: function(e2) {
            e2.exports = function(e3, t2) {
              return t2 || (t2 = {}), e3 ? (e3 = String(e3.__esModule ? e3.default : e3), /^['"].*['"]$/.test(e3) && (e3 = e3.slice(1, -1)), t2.hash && (e3 += t2.hash), /["'() \t\n]|(%20)/.test(e3) || t2.needQuotes ? '"'.concat(e3.replace(/"/g, '\\"').replace(/\n/g, "\\n"), '"') : e3) : e3;
            };
          }, 6758: function(e2) {
            e2.exports = function(e3) {
              return e3[1];
            };
          }, 140: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(8956), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 3795: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(8483), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 8481: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(7521), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 6655: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(4991), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 7229: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(2621), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 2885: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(8981), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 391: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(2935), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 9563: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(7899), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 4169: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(9561), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 8931: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(4131), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 5479: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(679), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 7894: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(4086), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 4665: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(2249), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 8811: function(e2, t2, a2) {
            a2.r(t2);
            var n = a2(2591), o = a2.n(n), r = a2(1740), i = a2.n(r), l = a2(8128), s = a2.n(l), d = a2(8021), c = a2.n(d), g = a2(3051), u = a2.n(g), h = a2(3656), p = a2.n(h), m = a2(4011), f = { attributes: { "data-ag-scope": "legacy" } };
            f.styleTagTransform = p(), f.setAttributes = c(), f.insert = s().bind(null, "head"), f.domAPI = i(), f.insertStyleElement = u();
            o()(m.A, f);
            t2.default = m.A && m.A.locals ? m.A.locals : void 0;
          }, 2591: function(e2) {
            var t2 = [];
            function a2(e3) {
              for (var a3 = -1, n2 = 0; n2 < t2.length; n2++)
                if (t2[n2].identifier === e3) {
                  a3 = n2;
                  break;
                }
              return a3;
            }
            function n(e3, n2) {
              for (var r = {}, i = [], l = 0; l < e3.length; l++) {
                var s = e3[l], d = n2.base ? s[0] + n2.base : s[0], c = r[d] || 0, g = "".concat(d, " ").concat(c);
                r[d] = c + 1;
                var u = a2(g), h = { css: s[1], media: s[2], sourceMap: s[3], supports: s[4], layer: s[5] };
                if (-1 !== u)
                  t2[u].references++, t2[u].updater(h);
                else {
                  var p = o(h, n2);
                  n2.byIndex = l, t2.splice(l, 0, { identifier: g, updater: p, references: 1 });
                }
                i.push(g);
              }
              return i;
            }
            function o(e3, t3) {
              var a3 = t3.domAPI(t3);
              a3.update(e3);
              return function(t4) {
                if (t4) {
                  if (t4.css === e3.css && t4.media === e3.media && t4.sourceMap === e3.sourceMap && t4.supports === e3.supports && t4.layer === e3.layer)
                    return;
                  a3.update(e3 = t4);
                } else
                  a3.remove();
              };
            }
            e2.exports = function(e3, o2) {
              var r = n(e3 = e3 || [], o2 = o2 || {});
              return function(e4) {
                e4 = e4 || [];
                for (var i = 0; i < r.length; i++) {
                  var l = a2(r[i]);
                  t2[l].references--;
                }
                for (var s = n(e4, o2), d = 0; d < r.length; d++) {
                  var c = a2(r[d]);
                  0 === t2[c].references && (t2[c].updater(), t2.splice(c, 1));
                }
                r = s;
              };
            };
          }, 8128: function(e2) {
            var t2 = {};
            e2.exports = function(e3, a2) {
              var n = function(e4) {
                if (void 0 === t2[e4]) {
                  var a3 = document.querySelector(e4);
                  if (window.HTMLIFrameElement && a3 instanceof window.HTMLIFrameElement)
                    try {
                      a3 = a3.contentDocument.head;
                    } catch (e5) {
                      a3 = null;
                    }
                  t2[e4] = a3;
                }
                return t2[e4];
              }(e3);
              if (!n)
                throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");
              n.appendChild(a2);
            };
          }, 3051: function(e2) {
            e2.exports = function(e3) {
              var t2 = document.createElement("style");
              return e3.setAttributes(t2, e3.attributes), e3.insert(t2, e3.options), t2;
            };
          }, 8021: function(e2) {
            e2.exports = function(e3, t2) {
              Object.keys(t2).forEach(function(a2) {
                e3.setAttribute(a2, t2[a2]);
              });
            };
          }, 1740: function(e2) {
            e2.exports = function(e3) {
              if ("undefined" == typeof document)
                return { update: function() {
                }, remove: function() {
                } };
              var t2 = e3.insertStyleElement(e3);
              return { update: function(a2) {
                !function(e4, t3, a3) {
                  var n = "";
                  a3.supports && (n += "@supports (".concat(a3.supports, ") {")), a3.media && (n += "@media ".concat(a3.media, " {"));
                  var o = void 0 !== a3.layer;
                  o && (n += "@layer".concat(a3.layer.length > 0 ? " ".concat(a3.layer) : "", " {")), n += a3.css, o && (n += "}"), a3.media && (n += "}"), a3.supports && (n += "}");
                  var r = a3.sourceMap;
                  r && "undefined" != typeof btoa && (n += "\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(r)))), " */")), t3.styleTagTransform(n, e4, t3.options);
                }(t2, e3, a2);
              }, remove: function() {
                !function(e4) {
                  if (null === e4.parentNode)
                    return false;
                  e4.parentNode.removeChild(e4);
                }(t2);
              } };
            };
          }, 3656: function(e2) {
            e2.exports = function(e3, t2) {
              if (t2.styleSheet)
                t2.styleSheet.cssText = e3;
              else {
                for (; t2.firstChild; )
                  t2.removeChild(t2.firstChild);
                t2.appendChild(document.createTextNode(e3));
              }
            };
          }, 2074: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.AlignedGridsModule = void 0;
            const n = a2(7205), o = a2(8963);
            t2.AlignedGridsModule = { moduleName: "AlignedGrids", version: n.VERSION, beans: [o.AlignedGridsService] };
          }, 8963: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.AlignedGridsService = void 0;
            const n = a2(5266), o = a2(8731), r = a2(7764);
            class i extends o.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "alignedGridsSvc", this.consuming = false;
              }
              getAlignedGridApis() {
                var _a;
                let e3 = (_a = this.gos.get("alignedGrids")) != null ? _a : [];
                const t3 = "function" == typeof e3;
                "function" == typeof e3 && (e3 = e3());
                return e3.map((e4) => {
                  var _a2;
                  if (!e4)
                    return (0, r._error)(18), void (t3 || (0, r._error)(20));
                  if (this.isGridApi(e4))
                    return e4;
                  const a3 = e4;
                  return "current" in a3 ? (_a2 = a3.current) == null ? void 0 : _a2.api : (a3.api || (0, r._error)(19), a3.api);
                }).filter((e4) => !!e4 && !e4.isDestroyed());
              }
              isGridApi(e3) {
                return !!e3 && !!e3.dispatchEvent;
              }
              postConstruct() {
                const e3 = this.fireColumnEvent.bind(this);
                this.addManagedEventListeners({ columnMoved: e3, columnVisible: e3, columnPinned: e3, columnGroupOpened: e3, columnResized: e3, bodyScroll: this.fireScrollEvent.bind(this), alignedGridColumn: ({ event: e4 }) => this.onColumnEvent(e4), alignedGridScroll: ({ event: e4 }) => this.onScrollEvent(e4) });
              }
              fireEvent(e3) {
                this.consuming || this.getAlignedGridApis().forEach((t3) => {
                  t3.isDestroyed() || t3.dispatchEvent(e3);
                });
              }
              onEvent(e3) {
                this.consuming = true, e3(), this.consuming = false;
              }
              fireColumnEvent(e3) {
                this.fireEvent({ type: "alignedGridColumn", event: e3 });
              }
              fireScrollEvent(e3) {
                "horizontal" === e3.direction && this.fireEvent({ type: "alignedGridScroll", event: e3 });
              }
              onScrollEvent(e3) {
                this.onEvent(() => {
                  this.beans.ctrlsSvc.getScrollFeature().setHorizontalScrollPosition(e3.left, true);
                });
              }
              extractDataFromEvent(e3, t3) {
                const a3 = [];
                return e3.columns ? e3.columns.forEach((e4) => {
                  a3.push(t3(e4));
                }) : e3.column && a3.push(t3(e3.column)), a3;
              }
              getMasterColumns(e3) {
                return this.extractDataFromEvent(e3, (e4) => e4);
              }
              getColumnIds(e3) {
                return this.extractDataFromEvent(e3, (e4) => e4.getColId());
              }
              onColumnEvent(e3) {
                this.onEvent(() => {
                  switch (e3.type) {
                    case "columnMoved":
                    case "columnVisible":
                    case "columnPinned":
                    case "columnResized":
                      this.processColumnEvent(e3);
                      break;
                    case "columnGroupOpened":
                      this.processGroupOpenedEvent(e3);
                      break;
                    case "columnPivotChanged":
                      (0, r._warn)(21);
                  }
                });
              }
              processGroupOpenedEvent(e3) {
                const { colGroupSvc: t3 } = this.beans;
                t3 && e3.columnGroups.forEach((e4) => {
                  let a3 = null;
                  e4 && (a3 = t3.getProvidedColGroup(e4.getGroupId())), e4 && !a3 || t3.setColumnGroupOpened(a3, e4.isExpanded(), "alignedGridChanged");
                });
              }
              processColumnEvent(e3) {
                var _a;
                const t3 = e3.column;
                let a3 = null;
                const o2 = this.beans, { colResize: r2, ctrlsSvc: i2, colModel: l } = o2;
                if (t3 && (a3 = l.getColDefCol(t3.getColId())), t3 && !a3)
                  return;
                const s = this.getMasterColumns(e3);
                switch (e3.type) {
                  case "columnMoved":
                    {
                      const t4 = e3.api.getColumnState().map((e4) => ({ colId: e4.colId }));
                      (0, n._applyColumnState)(o2, { state: t4, applyOrder: true }, "alignedGridChanged");
                    }
                    break;
                  case "columnVisible":
                    {
                      const t4 = e3.api.getColumnState().map((e4) => ({ colId: e4.colId, hide: e4.hide }));
                      (0, n._applyColumnState)(o2, { state: t4 }, "alignedGridChanged");
                    }
                    break;
                  case "columnPinned":
                    {
                      const t4 = e3.api.getColumnState().map((e4) => ({ colId: e4.colId, pinned: e4.pinned }));
                      (0, n._applyColumnState)(o2, { state: t4 }, "alignedGridChanged");
                    }
                    break;
                  case "columnResized": {
                    const t4 = e3, a4 = {};
                    s.forEach((e4) => {
                      a4[e4.getId()] = { key: e4.getColId(), newWidth: e4.getActualWidth() };
                    }), (_a = t4.flexColumns) == null ? void 0 : _a.forEach((e4) => {
                      a4[e4.getId()] && delete a4[e4.getId()];
                    }), r2 == null ? void 0 : r2.setColumnWidths(Object.values(a4), false, t4.finished, "alignedGridChanged");
                    break;
                  }
                }
                const d = i2.getGridBodyCtrl().isVerticalScrollShowing();
                this.getAlignedGridApis().forEach((e4) => {
                  e4.setGridOption("alwaysShowVerticalScroll", d);
                });
              }
            }
            t2.AlignedGridsService = i;
          }, 1621: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.AllCommunityModule = void 0;
            const n = a2(2074), o = a2(9642), r = a2(9722), i = a2(9722), l = a2(3856), s = a2(1690), d = a2(2027), c = a2(9734), g = a2(4388), u = a2(4652), h = a2(5432), p = a2(4002), m = a2(9410), f = a2(9519), v = a2(6989), b = a2(1824), C = a2(5423), w = a2(3498), y = a2(6964), S = a2(4577), k = a2(3352), x = a2(8594), R = a2(4658), M = a2(5010), P = a2(6431), F = a2(7205);
            t2.AllCommunityModule = { moduleName: "AllCommunity", version: F.VERSION, dependsOn: [r.ClientSideRowModelModule, c.CsvExportModule, p.InfiniteRowModelModule, M.ValidationModule, u.TextEditorModule, u.NumberEditorModule, u.DateEditorModule, u.CheckboxEditorModule, u.SelectEditorModule, u.LargeTextEditorModule, u.CustomEditorModule, u.UndoRedoEditModule, h.TextFilterModule, h.NumberFilterModule, h.DateFilterModule, h.CustomFilterModule, h.QuickFilterModule, h.ExternalFilterModule, v.GridStateModule, n.AlignedGridsModule, b.PaginationModule, d.ColumnApiModule, o.RowApiModule, o.ScrollApiModule, y.RenderApiModule, l.ColumnAutoSizeModule, g.RowDragModule, C.PinnedRowModule, k.RowSelectionModule, P.ValueCacheModule, x.CellStyleModule, s.ColumnHoverModule, x.RowStyleModule, m.EventApiModule, P.CellApiModule, w.HighlightChangesModule, R.TooltipModule, f.LocaleModule, S.RowAutoHeightModule, g.DragAndDropModule, i.ClientSideRowModelApiModule] };
          }, 3907: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ApiFunctionService = void 0;
            const n = a2(8731), o = a2(7764), r = a2(7689), i = { isDestroyed: () => true, destroy() {
            }, preConstruct() {
            }, postConstruct() {
            }, preWireBeans() {
            }, wireBeans() {
            } }, l = (e3, t3) => e3.eventSvc.dispatchEvent(t3);
            class s {
            }
            Reflect.defineProperty(s, "name", { value: "GridApi" });
            class d extends n.BeanStub {
              constructor() {
                super(), this.beanName = "apiFunctionSvc", this.api = new s(), this.fns = __spreadProps(__spreadValues({}, i), { dispatchEvent: l }), this.preDestroyLink = "";
                const { api: e3 } = this;
                for (const t3 of Object.keys(r.gridApiFunctionsMap))
                  e3[t3] = this.makeApi(t3)[t3];
              }
              postConstruct() {
                this.preDestroyLink = this.beans.frameworkOverrides.getDocLink("grid-lifecycle/#grid-pre-destroyed");
              }
              addFunction(e3, t3) {
                var _a, _b;
                const { fns: a3, beans: n2 } = this;
                a3 !== i && (a3[e3] = (_b = (_a = n2 == null ? void 0 : n2.validation) == null ? void 0 : _a.validateApiFunction(e3, t3)) != null ? _b : t3);
              }
              makeApi(e3) {
                return { [e3]: (...t3) => {
                  const { beans: a3, fns: { [e3]: n2 } } = this;
                  return n2 ? n2(a3, ...t3) : this.apiNotFound(e3);
                } };
              }
              apiNotFound(e3) {
                const { beans: t3, gos: a3, preDestroyLink: n2 } = this;
                if (t3) {
                  const t4 = r.gridApiFunctionsMap[e3];
                  a3.assertModuleRegistered(t4, `api.${e3}`) && (0, o._warn)(27, { fnName: e3, module: t4 });
                } else
                  (0, o._warn)(26, { fnName: e3, preDestroyLink: n2 });
              }
              destroy() {
                super.destroy(), this.fns = i, this.beans = null;
              }
            }
            t2.ApiFunctionService = d;
          }, 9642: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ScrollApiModule = t2.RowApiModule = void 0;
            const n = a2(7205), o = a2(8192), r = a2(1765);
            t2.RowApiModule = { moduleName: "RowApi", version: n.VERSION, apiFunctions: { redrawRows: o.redrawRows, setRowNodeExpanded: o.setRowNodeExpanded, getRowNode: o.getRowNode, addRenderedRowListener: o.addRenderedRowListener, getRenderedNodes: o.getRenderedNodes, forEachNode: o.forEachNode, getFirstDisplayedRowIndex: o.getFirstDisplayedRowIndex, getLastDisplayedRowIndex: o.getLastDisplayedRowIndex, getDisplayedRowAtIndex: o.getDisplayedRowAtIndex, getDisplayedRowCount: o.getDisplayedRowCount } }, t2.ScrollApiModule = { moduleName: "ScrollApi", version: n.VERSION, apiFunctions: { getVerticalPixelRange: r.getVerticalPixelRange, getHorizontalPixelRange: r.getHorizontalPixelRange, ensureColumnVisible: r.ensureColumnVisible, ensureIndexVisible: r.ensureIndexVisible, ensureNodeVisible: r.ensureNodeVisible } };
          }, 6433: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.createGridApi = void 0, t2.createGridApi = function(e3) {
              return { beanName: "gridApi", bean: e3.getBean("apiFunctionSvc").api };
            };
          }, 9875: function(e2, t2) {
            function a2(e3, t3) {
              e3.gos.updateGridOptions({ options: t3 });
            }
            Object.defineProperty(t2, "__esModule", { value: true }), t2.updateGridOptions = t2.setGridOption = t2.getGridOption = t2.isDestroyed = t2.destroy = t2.getGridId = void 0, t2.getGridId = function(e3) {
              return e3.context.getGridId();
            }, t2.destroy = function(e3) {
              e3.gridDestroySvc.destroy();
            }, t2.isDestroyed = function(e3) {
              return e3.gridDestroySvc.destroyCalled;
            }, t2.getGridOption = function(e3, t3) {
              return e3.gos.get(t3);
            }, t2.setGridOption = function(e3, t3, n) {
              a2(e3, { [t3]: n });
            }, t2.updateGridOptions = a2;
          }, 9513: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.onRowHeightChanged = t2.collapseAll = t2.expandAll = void 0;
            const n = a2(6876);
            t2.expandAll = function(e3) {
              var _a;
              (_a = e3.expansionSvc) == null ? void 0 : _a.expandAll(true);
            }, t2.collapseAll = function(e3) {
              var _a;
              (_a = e3.expansionSvc) == null ? void 0 : _a.expandAll(false);
            }, t2.onRowHeightChanged = function(e3) {
              const t3 = (0, n._getClientSideRowModel)(e3), a3 = (0, n._getServerSideRowModel)(e3);
              t3 ? t3.onRowHeightChanged() : a3 && a3.onRowHeightChanged();
            };
          }, 7689: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.gridApiFunctionsMap = void 0;
            const a2 = (e3, t3) => {
              for (const a3 of Object.keys(t3))
                t3[a3] = e3;
              return t3;
            };
            t2.gridApiFunctionsMap = __spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues(__spreadValues({ dispatchEvent: "CommunityCore" }, a2("CommunityCore", { destroy: 0, getGridId: 0, getGridOption: 0, isDestroyed: 0, setGridOption: 0, updateGridOptions: 0 })), a2("GridState", { getState: 0 })), a2("SharedRowSelection", { setNodesSelected: 0, selectAll: 0, deselectAll: 0, selectAllFiltered: 0, deselectAllFiltered: 0, selectAllOnCurrentPage: 0, deselectAllOnCurrentPage: 0, getSelectedNodes: 0, getSelectedRows: 0 })), a2("RowApi", { redrawRows: 0, setRowNodeExpanded: 0, getRowNode: 0, addRenderedRowListener: 0, getRenderedNodes: 0, forEachNode: 0, getFirstDisplayedRowIndex: 0, getLastDisplayedRowIndex: 0, getDisplayedRowAtIndex: 0, getDisplayedRowCount: 0 })), a2("ScrollApi", { getVerticalPixelRange: 0, getHorizontalPixelRange: 0, ensureColumnVisible: 0, ensureIndexVisible: 0, ensureNodeVisible: 0 })), a2("KeyboardNavigation", { getFocusedCell: 0, clearFocusedCell: 0, setFocusedCell: 0, tabToNextCell: 0, tabToPreviousCell: 0, setFocusedHeader: 0 })), a2("EventApi", { addEventListener: 0, addGlobalListener: 0, removeEventListener: 0, removeGlobalListener: 0 })), a2("ValueCache", { expireValueCache: 0 })), a2("CellApi", { getCellValue: 0 })), a2("SharedMenu", { showColumnMenu: 0, hidePopupMenu: 0 })), a2("Sort", { onSortChanged: 0 })), a2("PinnedRow", { getPinnedTopRowCount: 0, getPinnedBottomRowCount: 0, getPinnedTopRow: 0, getPinnedBottomRow: 0 })), a2("Overlay", { showLoadingOverlay: 0, showNoRowsOverlay: 0, hideOverlay: 0 })), a2("RenderApi", { setGridAriaProperty: 0, refreshCells: 0, refreshHeader: 0, isAnimationFrameQueueEmpty: 0, flushAllAnimationFrames: 0, getSizesForCurrentTheme: 0, getCellRendererInstances: 0 })), a2("HighlightChanges", { flashCells: 0 })), a2("RowDrag", { addRowDropZone: 0, removeRowDropZone: 0, getRowDropZoneParams: 0 })), a2("ColumnApi", { getColumnDefs: 0, getColumnDef: 0, getDisplayNameForColumn: 0, getColumn: 0, getColumns: 0, applyColumnState: 0, getColumnState: 0, resetColumnState: 0, isPinning: 0, isPinningLeft: 0, isPinningRight: 0, getDisplayedColAfter: 0, getDisplayedColBefore: 0, setColumnsVisible: 0, setColumnsPinned: 0, getAllGridColumns: 0, getDisplayedLeftColumns: 0, getDisplayedCenterColumns: 0, getDisplayedRightColumns: 0, getAllDisplayedColumns: 0, getAllDisplayedVirtualColumns: 0 })), a2("ColumnAutoSize", { sizeColumnsToFit: 0, autoSizeColumns: 0, autoSizeAllColumns: 0 })), a2("ColumnGroup", { setColumnGroupOpened: 0, getColumnGroup: 0, getProvidedColumnGroup: 0, getDisplayNameForColumnGroup: 0, getColumnGroupState: 0, setColumnGroupState: 0, resetColumnGroupState: 0, getLeftDisplayedColumnGroups: 0, getCenterDisplayedColumnGroups: 0, getRightDisplayedColumnGroups: 0, getAllDisplayedColumnGroups: 0 })), a2("ColumnMove", { moveColumnByIndex: 0, moveColumns: 0 })), a2("ColumnResize", { setColumnWidths: 0 })), a2("ColumnHover", { isColumnHovered: 0 })), a2("EditCore", { getCellEditorInstances: 0, getEditingCells: 0, stopEditing: 0, startEditingCell: 0 })), a2("UndoRedoEdit", { undoCellEditing: 0, redoCellEditing: 0, getCurrentUndoSize: 0, getCurrentRedoSize: 0 })), a2("FilterCore", { isAnyFilterPresent: 0, onFilterChanged: 0 })), a2("ColumnFilter", { isColumnFilterPresent: 0, getColumnFilterInstance: 0, destroyFilter: 0, setFilterModel: 0, getFilterModel: 0, getColumnFilterModel: 0, setColumnFilterModel: 0, showColumnFilter: 0 })), a2("QuickFilter", { isQuickFilterPresent: 0, getQuickFilter: 0, resetQuickFilter: 0 })), a2("Pagination", { paginationIsLastPageFound: 0, paginationGetPageSize: 0, paginationGetCurrentPage: 0, paginationGetTotalPages: 0, paginationGetRowCount: 0, paginationGoToNextPage: 0, paginationGoToPreviousPage: 0, paginationGoToFirstPage: 0, paginationGoToLastPage: 0, paginationGoToPage: 0 })), a2("CsrmSsrmSharedApi", { expandAll: 0, collapseAll: 0, onRowHeightChanged: 0 })), a2("SsrmInfiniteSharedApi", { setRowCount: 0, getCacheBlockState: 0, isLastRowIndexKnown: 0 })), a2("ClientSideRowModelApi", { onGroupExpandedOrCollapsed: 0, refreshClientSideRowModel: 0, isRowDataEmpty: 0, forEachLeafNode: 0, forEachNodeAfterFilter: 0, forEachNodeAfterFilterAndSort: 0, resetRowHeights: 0, applyTransaction: 0, applyTransactionAsync: 0, flushAsyncTransactions: 0, getBestCostNodeSelection: 0 })), a2("CsvExport", { getDataAsCsv: 0, exportDataAsCsv: 0 })), a2("InfiniteRowModel", { refreshInfiniteCache: 0, purgeInfiniteCache: 0, getInfiniteRowCount: 0 })), a2("AdvancedFilter", { getAdvancedFilterModel: 0, setAdvancedFilterModel: 0, showAdvancedFilterBuilder: 0, hideAdvancedFilterBuilder: 0 })), a2("IntegratedCharts", { getChartModels: 0, getChartRef: 0, getChartImageDataURL: 0, downloadChart: 0, openChartToolPanel: 0, closeChartToolPanel: 0, createRangeChart: 0, createPivotChart: 0, createCrossFilterChart: 0, updateChart: 0, restoreChart: 0 })), a2("Clipboard", { copyToClipboard: 0, cutToClipboard: 0, copySelectedRowsToClipboard: 0, copySelectedRangeToClipboard: 0, copySelectedRangeDown: 0, pasteFromClipboard: 0 })), a2("ExcelExport", { getDataAsExcel: 0, exportDataAsExcel: 0, getSheetDataForExcel: 0, getMultipleSheetsAsExcel: 0, exportMultipleSheetsAsExcel: 0 })), a2("SharedMasterDetail", { addDetailGridInfo: 0, removeDetailGridInfo: 0, getDetailGridInfo: 0, forEachDetailGridInfo: 0 })), a2("ContextMenu", { showContextMenu: 0 })), a2("ColumnMenu", { showColumnChooser: 0, hideColumnChooser: 0 })), a2("CellSelection", { getCellRanges: 0, addCellRange: 0, clearRangeSelection: 0, clearCellSelection: 0 })), a2("SharedRowGrouping", { setRowGroupColumns: 0, removeRowGroupColumns: 0, addRowGroupColumns: 0, getRowGroupColumns: 0, moveRowGroupColumn: 0 })), a2("SharedAggregation", { addAggFuncs: 0, clearAggFuncs: 0, setColumnAggFunc: 0 })), a2("SharedPivot", { isPivotMode: 0, getPivotResultColumn: 0, setValueColumns: 0, getValueColumns: 0, removeValueColumns: 0, addValueColumns: 0, setPivotColumns: 0, removePivotColumns: 0, addPivotColumns: 0, getPivotColumns: 0, setPivotResultColumns: 0, getPivotResultColumns: 0 })), a2("ServerSideRowModelApi", { getServerSideSelectionState: 0, setServerSideSelectionState: 0, applyServerSideTransaction: 0, applyServerSideTransactionAsync: 0, applyServerSideRowData: 0, retryServerSideLoads: 0, flushServerSideAsyncTransactions: 0, refreshServerSide: 0, getServerSideGroupLevelState: 0 })), a2("SideBar", { isSideBarVisible: 0, setSideBarVisible: 0, setSideBarPosition: 0, openToolPanel: 0, closeToolPanel: 0, getOpenedToolPanel: 0, refreshToolPanel: 0, isToolPanelShowing: 0, getToolPanelInstance: 0, getSideBar: 0 })), a2("StatusBar", { getStatusPanel: 0 }));
          }, 8192: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.getDisplayedRowCount = t2.getDisplayedRowAtIndex = t2.getLastDisplayedRowIndex = t2.getFirstDisplayedRowIndex = t2.forEachNode = t2.getRenderedNodes = t2.addRenderedRowListener = t2.getRowNode = t2.setRowNodeExpanded = t2.redrawRows = void 0, t2.redrawRows = function(e3, t3 = {}) {
              const a2 = t3 ? t3.rowNodes : void 0;
              e3.frameworkOverrides.wrapIncoming(() => e3.rowRenderer.redrawRows(a2));
            }, t2.setRowNodeExpanded = function e3(t3, a2, n, o, r) {
              a2 && (o && a2.parent && -1 !== a2.parent.level && e3(t3, a2.parent, n, o, r), a2.setExpanded(n, void 0, r));
            }, t2.getRowNode = function(e3, t3) {
              return e3.rowModel.getRowNode(t3);
            }, t2.addRenderedRowListener = function(e3, t3, a2, n) {
              e3.rowRenderer.addRenderedRowListener(t3, a2, n);
            }, t2.getRenderedNodes = function(e3) {
              return e3.rowRenderer.getRenderedNodes();
            }, t2.forEachNode = function(e3, t3, a2) {
              e3.rowModel.forEachNode(t3, a2);
            }, t2.getFirstDisplayedRowIndex = function(e3) {
              return e3.rowRenderer.firstRenderedRow;
            }, t2.getLastDisplayedRowIndex = function(e3) {
              return e3.rowRenderer.lastRenderedRow;
            }, t2.getDisplayedRowAtIndex = function(e3, t3) {
              return e3.rowModel.getRow(t3);
            }, t2.getDisplayedRowCount = function(e3) {
              return e3.rowModel.getRowCount();
            };
          }, 6876: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2._getServerSideRowModel = t2._getInfiniteRowModel = t2._getClientSideRowModel = void 0, t2._getClientSideRowModel = function(e3) {
              const t3 = e3.rowModel;
              return "clientSide" === t3.getType() ? t3 : void 0;
            }, t2._getInfiniteRowModel = function(e3) {
              const t3 = e3.rowModel;
              return "infinite" === t3.getType() ? t3 : void 0;
            }, t2._getServerSideRowModel = function(e3) {
              const t3 = e3.rowModel;
              return "serverSide" === t3.getType() ? t3 : void 0;
            };
          }, 1765: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ensureNodeVisible = t2.ensureIndexVisible = t2.ensureColumnVisible = t2.getHorizontalPixelRange = t2.getVerticalPixelRange = void 0, t2.getVerticalPixelRange = function(e3) {
              return e3.ctrlsSvc.getScrollFeature().getVScrollPosition();
            }, t2.getHorizontalPixelRange = function(e3) {
              return e3.ctrlsSvc.getScrollFeature().getHScrollPosition();
            }, t2.ensureColumnVisible = function(e3, t3, a2 = "auto") {
              e3.frameworkOverrides.wrapIncoming(() => e3.ctrlsSvc.getScrollFeature().ensureColumnVisible(t3, a2), "ensureVisible");
            }, t2.ensureIndexVisible = function(e3, t3, a2) {
              e3.frameworkOverrides.wrapIncoming(() => e3.ctrlsSvc.getScrollFeature().ensureIndexVisible(t3, a2), "ensureVisible");
            }, t2.ensureNodeVisible = function(e3, t3, a2 = null) {
              e3.frameworkOverrides.wrapIncoming(() => e3.ctrlsSvc.getScrollFeature().ensureNodeVisible(t3, a2), "ensureVisible");
            };
          }, 6437: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.SsrmInfiniteSharedApiModule = t2.CsrmSsrmSharedApiModule = void 0;
            const n = a2(7205), o = a2(9513), r = a2(8496);
            t2.CsrmSsrmSharedApiModule = { moduleName: "CsrmSsrmSharedApi", version: n.VERSION, apiFunctions: { expandAll: o.expandAll, collapseAll: o.collapseAll, onRowHeightChanged: o.onRowHeightChanged } }, t2.SsrmInfiniteSharedApiModule = { moduleName: "SsrmInfiniteSharedApi", version: n.VERSION, apiFunctions: { setRowCount: r.setRowCount, getCacheBlockState: r.getCacheBlockState, isLastRowIndexKnown: r.isLastRowIndexKnown } };
          }, 8496: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.isLastRowIndexKnown = t2.getCacheBlockState = t2.setRowCount = void 0;
            const n = a2(7274), o = a2(7764), r = a2(6876);
            t2.setRowCount = function(e3, t3, a3) {
              var _a;
              const n2 = (0, r._getServerSideRowModel)(e3);
              if (n2)
                return 0 === ((_a = e3.rowGroupColsSvc) == null ? void 0 : _a.columns.length) ? t3 < 0 ? void (0, o._error)(238) : void n2.setRowCount(t3, a3) : void (0, o._error)(28);
              const i = (0, r._getInfiniteRowModel)(e3);
              i && i.setRowCount(t3, a3);
            }, t2.getCacheBlockState = function(e3) {
              var _a, _b;
              if ((0, n._isServerSideRowModel)(e3.gos)) {
                return e3.rowModel.getBlockStates();
              }
              return (_b = (_a = e3.rowNodeBlockLoader) == null ? void 0 : _a.getBlockState()) != null ? _b : {};
            }, t2.isLastRowIndexKnown = function(e3) {
              return e3.rowModel.isLastRowIndexKnown();
            };
          }, 5628: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.AutoScrollService = void 0;
            t2.AutoScrollService = class {
              constructor(e3) {
                this.tickingInterval = null, this.onScrollCallback = null, this.scrollContainer = e3.scrollContainer, this.scrollHorizontally = -1 !== e3.scrollAxis.indexOf("x"), this.scrollVertically = -1 !== e3.scrollAxis.indexOf("y"), this.scrollByTick = null != e3.scrollByTick ? e3.scrollByTick : 20, e3.onScrollCallback && (this.onScrollCallback = e3.onScrollCallback), this.scrollVertically && (this.getVerticalPosition = e3.getVerticalPosition, this.setVerticalPosition = e3.setVerticalPosition), this.scrollHorizontally && (this.getHorizontalPosition = e3.getHorizontalPosition, this.setHorizontalPosition = e3.setHorizontalPosition), this.shouldSkipVerticalScroll = e3.shouldSkipVerticalScroll || (() => false), this.shouldSkipHorizontalScroll = e3.shouldSkipHorizontalScroll || (() => false);
              }
              check(e3, t3 = false) {
                const a2 = t3 || this.shouldSkipVerticalScroll();
                if (a2 && this.shouldSkipHorizontalScroll())
                  return;
                const n = this.scrollContainer.getBoundingClientRect(), o = this.scrollByTick;
                this.tickLeft = e3.clientX < n.left + o, this.tickRight = e3.clientX > n.right - o, this.tickUp = e3.clientY < n.top + o && !a2, this.tickDown = e3.clientY > n.bottom - o && !a2, this.tickLeft || this.tickRight || this.tickUp || this.tickDown ? this.ensureTickingStarted() : this.ensureCleared();
              }
              ensureTickingStarted() {
                null === this.tickingInterval && (this.tickingInterval = window.setInterval(this.doTick.bind(this), 100), this.tickCount = 0);
              }
              doTick() {
                this.tickCount++;
                const e3 = this.tickCount > 20 ? 200 : this.tickCount > 10 ? 80 : 40;
                if (this.scrollVertically) {
                  const t3 = this.getVerticalPosition();
                  this.tickUp && this.setVerticalPosition(t3 - e3), this.tickDown && this.setVerticalPosition(t3 + e3);
                }
                if (this.scrollHorizontally) {
                  const t3 = this.getHorizontalPosition();
                  this.tickLeft && this.setHorizontalPosition(t3 - e3), this.tickRight && this.setHorizontalPosition(t3 + e3);
                }
                this.onScrollCallback && this.onScrollCallback();
              }
              ensureCleared() {
                this.tickingInterval && (window.clearInterval(this.tickingInterval), this.tickingInterval = null);
              }
            };
          }, 3263: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.BASE_URL = void 0, t2.BASE_URL = "https://www.ag-grid.com";
          }, 1954: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.AbstractClientSideNodeManager = void 0;
            const n = a2(8731), o = a2(3373), r = a2(7274), i = a2(4422), l = a2(7764);
            class s extends n.BeanStub {
              constructor() {
                super(...arguments), this.nextId = 0, this.allNodesMap = {}, this.rootNode = null;
              }
              get treeData() {
                return false;
              }
              getRowNode(e3) {
                return this.allNodesMap[e3];
              }
              extractRowData() {
                var _a, _b;
                return (_b = (_a = this.rootNode) == null ? void 0 : _a.allLeafChildren) == null ? void 0 : _b.map((e3) => e3.data);
              }
              activate(e3) {
                this.rootNode = e3, e3.group = true, e3.level = -1, e3.id = "ROOT_NODE_ID", e3.allLeafChildren = [], e3.childrenAfterGroup = [], e3.childrenAfterSort = [], e3.childrenAfterAggFilter = [], e3.childrenAfterFilter = [], this.updateRootSiblingArrays(e3);
              }
              deactivate() {
                this.rootNode && (this.allNodesMap = {}, this.rootNode = null);
              }
              destroy() {
                super.destroy(), this.allNodesMap = {}, this.rootNode = null;
              }
              setNewRowData(e3) {
                const t3 = this.rootNode;
                t3 && (this.dispatchRowDataUpdateStartedEvent(e3), t3.childrenAfterFilter = null, t3.childrenAfterGroup = null, t3.childrenAfterAggFilter = null, t3.childrenAfterSort = null, t3.childrenMapped = null, t3.updateHasChildren(), this.allNodesMap = {}, this.nextId = 0, this.loadNewRowData(e3), this.updateRootSiblingArrays(t3));
              }
              updateRootSiblingArrays(e3) {
                const t3 = e3.sibling;
                t3 && (t3.childrenAfterFilter = e3.childrenAfterFilter, t3.childrenAfterGroup = e3.childrenAfterGroup, t3.childrenAfterAggFilter = e3.childrenAfterAggFilter, t3.childrenAfterSort = e3.childrenAfterSort, t3.childrenMapped = e3.childrenMapped, t3.allLeafChildren = e3.allLeafChildren);
              }
              loadNewRowData(e3) {
                var _a;
                this.rootNode.allLeafChildren = (_a = e3 == null ? void 0 : e3.map((e4, t3) => this.createRowNode(e4, t3))) != null ? _a : [];
              }
              setImmutableRowData(e3, t3) {
                const a3 = this.createTransactionForRowData(t3), n2 = this.updateRowData(a3, e3.changedRowNodes);
                let o2 = false;
                this.gos.get("suppressMaintainUnsortedOrder") || (o2 = this.updateRowOrderFromRowData(t3));
                const { rowNodeTransaction: r2, rowsInserted: i2 } = n2, { add: l2, remove: s2, update: d } = r2;
                (i2 || o2 || l2.length || s2.length || d.length) && (e3.step = "group", e3.rowDataUpdated = true, e3.rowNodeTransactions = [r2], e3.rowNodesOrderChanged = i2 || o2);
              }
              updateRowData(e3, t3) {
                this.dispatchRowDataUpdateStartedEvent(e3.add);
                const a3 = { changedRowNodes: t3, rowNodeTransaction: { remove: [], update: [], add: [] }, rowsInserted: false }, n2 = [], o2 = (0, r._getRowIdCallback)(this.gos);
                return this.executeRemove(o2, e3, a3, n2), this.executeUpdate(o2, e3, a3, n2), this.executeAdd(e3, a3), this.deselectNodes(n2), a3;
              }
              createTransactionForRowData(e3) {
                const t3 = (0, r._getRowIdCallback)(this.gos), a3 = __spreadValues({}, this.allNodesMap), n2 = [], o2 = [], l2 = [];
                (0, i._exists)(e3) && e3.forEach((e4) => {
                  const n3 = t3({ data: e4, level: 0 }), r2 = a3[n3];
                  if (r2) {
                    r2.data !== e4 && o2.push(e4), a3[n3] = void 0;
                  } else
                    l2.push(e4);
                });
                for (const e4 of Object.values(a3))
                  e4 && n2.push(e4.data);
                return { remove: n2, update: o2, add: l2 };
              }
              updateRowOrderFromRowData(e3) {
                var _a, _b;
                const t3 = (_a = this.rootNode) == null ? void 0 : _a.allLeafChildren, a3 = (_b = t3 == null ? void 0 : t3.length) != null ? _b : 0, n2 = /* @__PURE__ */ new Map();
                let o2 = -1, r2 = -1;
                for (let i2 = 0; i2 < a3; ++i2) {
                  const a4 = t3[i2], l2 = a4.data;
                  l2 !== e3[i2] && (r2 < 0 && (o2 = i2), r2 = i2, n2.set(l2, a4));
                }
                if (o2 < 0)
                  return false;
                for (let a4 = o2; a4 <= r2; ++a4) {
                  const o3 = n2.get(e3[a4]);
                  void 0 !== o3 && (t3[a4] = o3, o3.sourceRowIndex = a4);
                }
                return true;
              }
              executeAdd(e3, t3) {
                const a3 = e3.add;
                if (!(a3 == null ? void 0 : a3.length))
                  return;
                let n2 = this.rootNode.allLeafChildren, o2 = n2.length;
                if ("number" == typeof e3.addIndex && (o2 = this.sanitizeAddIndex(e3.addIndex), o2 > 0)) {
                  if (this.gos.get("treeData") && this.gos.get("getDataPath"))
                    for (let e4 = 0; e4 < n2.length; e4++) {
                      const t4 = n2[e4];
                      if ((t4 == null ? void 0 : t4.rowIndex) == o2 - 1) {
                        o2 = e4 + 1;
                        break;
                      }
                    }
                }
                const r2 = a3.length, i2 = t3.changedRowNodes, l2 = new Array(r2);
                for (let e4 = 0; e4 < r2; e4++) {
                  const t4 = this.createRowNode(a3[e4], o2 + e4);
                  i2.add(t4), l2[e4] = t4;
                }
                const s2 = this.rootNode;
                if (o2 < n2.length) {
                  const e4 = n2.slice(0, o2), a4 = n2.slice(o2, n2.length), r3 = e4.length + l2.length;
                  for (let e5 = 0, t4 = a4.length; e5 < t4; ++e5)
                    a4[e5].sourceRowIndex = r3 + e5;
                  n2 = [...e4, ...l2, ...a4], t3.rowsInserted = true;
                } else
                  n2 = n2.concat(l2);
                s2.allLeafChildren = n2;
                const d = s2.sibling;
                d && (d.allLeafChildren = n2), t3.rowNodeTransaction.add = l2;
              }
              executeRemove(e3, t3, { changedRowNodes: a3, rowNodeTransaction: n2 }, o2) {
                var _a, _b, _c;
                const { remove: r2 } = t3;
                if (!(r2 == null ? void 0 : r2.length))
                  return;
                const i2 = {};
                r2.forEach((t4) => {
                  const r3 = this.lookupRowNode(e3, t4);
                  r3 && (r3.isSelected() && o2.push(r3), r3.clearRowTopAndRowIndex(), i2[r3.id] = true, delete this.allNodesMap[r3.id], n2.remove.push(r3), a3.remove(r3));
                });
                const l2 = this.rootNode;
                l2.allLeafChildren = (_b = (_a = l2.allLeafChildren) == null ? void 0 : _a.filter((e4) => !i2[e4.id])) != null ? _b : null, (_c = l2.allLeafChildren) == null ? void 0 : _c.forEach((e4, t4) => {
                  e4.sourceRowIndex = t4;
                });
                const s2 = l2.sibling;
                s2 && (s2.allLeafChildren = l2.allLeafChildren);
              }
              executeUpdate(e3, t3, { changedRowNodes: a3, rowNodeTransaction: n2 }, o2) {
                const { update: r2 } = t3;
                (r2 == null ? void 0 : r2.length) && r2.forEach((t4) => {
                  const r3 = this.lookupRowNode(e3, t4);
                  r3 && (r3.updateData(t4), !r3.selectable && r3.isSelected() && o2.push(r3), n2.update.push(r3), a3.update(r3));
                });
              }
              dispatchRowDataUpdateStartedEvent(e3) {
                this.eventSvc.dispatchEvent({ type: "rowDataUpdateStarted", firstRowData: (e3 == null ? void 0 : e3.length) ? e3[0] : null });
              }
              deselectNodes(e3) {
                var _a;
                const t3 = "rowDataChanged", a3 = this.beans.selectionSvc, n2 = e3.length > 0;
                n2 && (a3 == null ? void 0 : a3.setNodesSelected({ newValue: false, nodes: e3, suppressFinishActions: true, source: t3 })), (_a = a3 == null ? void 0 : a3.updateGroupsFromChildrenSelections) == null ? void 0 : _a.call(a3, t3), n2 && this.eventSvc.dispatchEvent({ type: "selectionChanged", source: t3 });
              }
              sanitizeAddIndex(e3) {
                var _a, _b;
                const t3 = (_b = (_a = this.rootNode.allLeafChildren) == null ? void 0 : _a.length) != null ? _b : 0;
                return e3 < 0 || e3 >= t3 || Number.isNaN(e3) ? t3 : Math.ceil(e3);
              }
              createRowNode(e3, t3) {
                const a3 = new o.RowNode(this.beans);
                return a3.parent = this.rootNode, a3.level = 0, a3.group = false, a3.expanded = false, a3.sourceRowIndex = t3, a3.setDataAndId(e3, String(this.nextId)), this.allNodesMap[a3.id] && (0, l._warn)(2, { nodeId: a3.id }), this.allNodesMap[a3.id] = a3, this.nextId++, a3;
              }
              lookupRowNode(e3, t3) {
                var _a, _b;
                let a3;
                if (e3) {
                  const n2 = e3({ data: t3, level: 0 });
                  if (a3 = this.allNodesMap[n2], !a3)
                    return (0, l._error)(4, { id: n2 }), null;
                } else if (a3 = (_b = (_a = this.rootNode) == null ? void 0 : _a.allLeafChildren) == null ? void 0 : _b.find((e4) => e4.data === t3), !a3)
                  return (0, l._error)(5, { data: t3 }), null;
                return a3 || null;
              }
            }
            t2.AbstractClientSideNodeManager = s;
          }, 2106: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ChangedRowNodes = void 0;
            t2.ChangedRowNodes = class {
              constructor() {
                this.removals = /* @__PURE__ */ new Set(), this.updates = /* @__PURE__ */ new Map();
              }
              remove(e3) {
                this.removals.add(e3), this.updates.delete(e3);
              }
              update(e3) {
                this.updates.has(e3) || (this.removals.delete(e3), this.updates.set(e3, false));
              }
              add(e3) {
                this.removals.delete(e3), this.updates.set(e3, true);
              }
            };
          }, 5747: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ClientSideNodeManager = void 0;
            const n = a2(1954);
            class o extends n.AbstractClientSideNodeManager {
              constructor() {
                super(...arguments), this.beanName = "csrmNodeSvc";
              }
            }
            t2.ClientSideNodeManager = o;
          }, 3278: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ClientSideRowModel = void 0;
            const n = a2(8731), o = a2(3373), r = a2(7274), i = a2(1502), l = a2(6800), s = a2(2043), d = a2(7764), c = a2(2106), g = a2(8287), u = a2(9849);
            var h;
            !function(e3) {
              e3[e3.Normal = 0] = "Normal", e3[e3.AfterFilter = 1] = "AfterFilter", e3[e3.AfterFilterAndSort = 2] = "AfterFilterAndSort", e3[e3.PivotNodes = 3] = "PivotNodes";
            }(h || (h = {}));
            class p extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "rowModel", this.onRowHeightChanged_debounced = (0, s._debounce)(this, this.onRowHeightChanged.bind(this), 100), this.rootNode = null, this.rowsToDisplay = [], this.started = false, this.shouldSkipSettingDataOnStart = false, this.isRefreshingModel = false, this.rowNodesCountReady = false, this.rowCountReady = false;
              }
              wireBeans(e3) {
                this.colModel = e3.colModel, this.valueCache = e3.valueCache, this.filterStage = e3.filterStage, this.sortStage = e3.sortStage, this.flattenStage = e3.flattenStage, this.groupStage = e3.groupStage, this.aggStage = e3.aggStage, this.pivotStage = e3.pivotStage, this.filterAggStage = e3.filterAggStage;
              }
              postConstruct() {
                this.orderedStages = [this.groupStage, this.filterStage, this.pivotStage, this.aggStage, this.sortStage, this.filterAggStage, this.flattenStage].filter((e4) => !!e4);
                const e3 = this.refreshModel.bind(this, { step: "group" }), t3 = this.refreshModel.bind(this, { step: "group", afterColumnsChanged: true, keepRenderedRows: true, animate: !this.gos.get("suppressAnimationFrame") });
                this.addManagedEventListeners({ newColumnsLoaded: t3, columnRowGroupChanged: e3, columnValueChanged: this.onValueChanged.bind(this), columnPivotChanged: this.refreshModel.bind(this, { step: "pivot" }), filterChanged: this.onFilterChanged.bind(this), sortChanged: this.onSortChanged.bind(this), columnPivotModeChanged: e3, gridStylesChanged: this.onGridStylesChanges.bind(this), gridReady: this.onGridReady.bind(this) }), this.addPropertyListeners(), this.rootNode = new o.RowNode(this.beans), this.initRowManager();
              }
              initRowManager() {
                const { gos: e3, beans: t3, nodeManager: a3 } = this, n2 = e3.get("treeData"), o2 = e3.get("treeDataChildrenField");
                let r2;
                (o2 || n2) && (r2 = o2 ? t3.csrmChildrenTreeNodeSvc : t3.csrmPathTreeNodeSvc), r2 || (r2 = t3.csrmNodeSvc), a3 !== r2 && (a3 == null ? void 0 : a3.deactivate(), this.nodeManager = r2), r2.activate(this.rootNode);
              }
              addPropertyListeners() {
                const e3 = ["treeData", "treeDataChildrenField", ...this.orderedStages.flatMap(({ refreshProps: e4 }) => [...e4])];
                this.addManagedPropertyListeners(e3, (e4) => {
                  var _a;
                  const t3 = (_a = e4.changeSet) == null ? void 0 : _a.properties;
                  t3 && this.onPropChange(t3);
                }), this.addManagedPropertyListener("rowData", () => this.onPropChange(["rowData"])), this.addManagedPropertyListener("rowHeight", () => this.resetRowHeights());
              }
              start() {
                this.started = true, this.shouldSkipSettingDataOnStart ? this.refreshModel({ step: "group", newData: true, rowDataUpdated: true }) : this.setInitialData();
              }
              setInitialData() {
                this.gos.get("rowData") && (this.shouldSkipSettingDataOnStart = true, this.onPropChange(["rowData"]));
              }
              ensureRowHeightsValid(e3, t3, a3, n2) {
                let o2, i2 = false;
                do {
                  o2 = false;
                  const l2 = this.getRowIndexAtPixel(e3), s2 = this.getRowIndexAtPixel(t3), d2 = Math.max(l2, a3), c2 = Math.min(s2, n2);
                  for (let e4 = d2; e4 <= c2; e4++) {
                    const t4 = this.getRow(e4);
                    if (t4.rowHeightEstimated) {
                      const e5 = (0, r._getRowHeightForNode)(this.beans, t4);
                      t4.setRowHeight(e5.height), o2 = true, i2 = true;
                    }
                  }
                  o2 && this.setRowTopAndRowIndex();
                } while (o2);
                return i2;
              }
              onPropChange(e3) {
                var _a, _b, _c;
                if (!this.rootNode)
                  return;
                const t3 = this.gos, a3 = new Set(e3), n2 = { step: "nothing", changedProps: a3 }, o2 = a3.has("rowData"), r2 = a3.has("treeData"), i2 = a3.has("treeDataChildrenField") || r2 && !t3.get("treeDataChildrenField");
                let l2;
                if (r2 && (n2.step = "group"), (i2 || o2) && (l2 = t3.get("rowData"), null == l2 || Array.isArray(l2) || (l2 = null, (0, d._warn)(1))), i2 && (o2 || (l2 = (_b = (_a = this.nodeManager) == null ? void 0 : _a.extractRowData()) != null ? _b : l2), this.initRowManager()), l2) {
                  !i2 && this.started && !this.isEmpty() && l2.length > 0 && t3.exists("getRowId") && !t3.get("resetRowDataOnUpdate") ? (n2.keepRenderedRows = true, n2.animate = !this.gos.get("suppressAnimationFrame"), n2.changedRowNodes = new c.ChangedRowNodes(), this.nodeManager.setImmutableRowData(n2, l2)) : (n2.step = "group", n2.rowDataUpdated = true, n2.newData = true, (_c = this.beans.selectionSvc) == null ? void 0 : _c.reset("rowDataChanged"), this.rowNodesCountReady = true, this.nodeManager.setNewRowData(l2));
                }
                if ("nothing" === n2.step) {
                  for (const { refreshProps: t4, step: a4 } of this.orderedStages)
                    if (e3.some((e4) => t4.has(e4))) {
                      n2.step = a4;
                      break;
                    }
                }
                "nothing" !== n2.step && this.refreshModel(n2);
              }
              setRowTopAndRowIndex() {
                const { beans: e3 } = this, t3 = e3.environment.getDefaultRowHeight();
                let a3 = 0;
                const n2 = /* @__PURE__ */ new Set(), o2 = (0, r._isDomLayout)(this.gos, "normal"), i2 = this.rowsToDisplay;
                for (let l2 = 0, s2 = i2.length; l2 < s2; ++l2) {
                  const s3 = i2[l2];
                  if (null != s3.id && n2.add(s3.id), null == s3.rowHeight) {
                    const a4 = (0, r._getRowHeightForNode)(e3, s3, o2, t3);
                    s3.setRowHeight(a4.height, a4.estimated);
                  }
                  s3.setRowTop(a3), s3.setRowIndex(l2), a3 += s3.rowHeight;
                }
                return n2;
              }
              clearRowTopAndRowIndex(e3, t3) {
                const a3 = e3.active, n2 = (e4) => {
                  e4 && null != e4.id && !t3.has(e4.id) && e4.clearRowTopAndRowIndex();
                }, o2 = (e4) => {
                  if (null !== e4 && (n2(e4), n2(e4.detailNode), n2(e4.sibling), e4.hasChildren() && e4.childrenAfterGroup)) {
                    const t4 = -1 == e4.level;
                    a3 && !t4 && !e4.expanded || e4.childrenAfterGroup.forEach(o2);
                  }
                };
                o2(this.rootNode);
              }
              ensureRowsAtPixel(e3, t3, a3 = 0) {
                var _a;
                const n2 = this.getRowIndexAtPixel(t3), o2 = this.getRow(n2), r2 = !this.gos.get("suppressAnimationFrame");
                if (o2 === e3[0])
                  return false;
                const l2 = (_a = this.rootNode) == null ? void 0 : _a.allLeafChildren;
                return !!l2 && (e3.forEach((e4) => {
                  (0, i._removeFromArray)(l2, e4);
                }), e3.forEach((e4, t4) => {
                  l2.splice(Math.max(n2 + a3, 0) + t4, 0, e4);
                }), e3.forEach((e4, t4) => {
                  e4.sourceRowIndex = t4;
                }), this.refreshModel({ step: "group", keepRenderedRows: true, animate: r2, rowNodesOrderChanged: true }), true);
              }
              highlightRowAtPixel(e3, t3) {
                const a3 = null != t3 ? this.getRowIndexAtPixel(t3) : null, n2 = null != a3 ? this.getRow(a3) : null;
                if (!n2 || !e3 || null == t3)
                  return void this.clearHighlightedRow();
                const o2 = this.getHighlightPosition(t3, n2), r2 = this.isHighlightingCurrentPosition(e3, n2, o2), i2 = null != this.lastHighlightedRow && this.lastHighlightedRow !== n2;
                (r2 || i2) && (this.clearHighlightedRow(), r2) || (this.setRowNodeHighlighted(n2, o2), this.lastHighlightedRow = n2);
              }
              setRowNodeHighlighted(e3, t3) {
                e3.highlighted !== t3 && (e3.highlighted = t3, e3.dispatchRowEvent("rowHighlightChanged"));
              }
              getHighlightPosition(e3, t3) {
                if (!t3) {
                  const a4 = this.getRowIndexAtPixel(e3);
                  if (!(t3 = this.getRow(a4 || 0)))
                    return "Below";
                }
                const { rowTop: a3, rowHeight: n2 } = t3;
                return e3 - a3 < n2 / 2 ? "Above" : "Below";
              }
              getLastHighlightedRowNode() {
                return this.lastHighlightedRow;
              }
              isHighlightingCurrentPosition(e3, t3, a3) {
                if (e3 === t3)
                  return true;
                const n2 = "Above" === a3 ? -1 : 1;
                return this.getRow(t3.rowIndex + n2) === e3;
              }
              clearHighlightedRow() {
                this.lastHighlightedRow && (this.setRowNodeHighlighted(this.lastHighlightedRow, null), this.lastHighlightedRow = null);
              }
              isLastRowIndexKnown() {
                return true;
              }
              getRowCount() {
                return this.rowsToDisplay ? this.rowsToDisplay.length : 0;
              }
              getTopLevelRowCount() {
                const e3 = this.rootNode;
                if (!e3)
                  return 0;
                if (0 === this.rowsToDisplay.length)
                  return 0;
                if (this.rowsToDisplay && this.rowsToDisplay[0] === e3)
                  return 1;
                const t3 = e3.childrenAfterAggFilter, a3 = e3.sibling ? 1 : 0;
                return (t3 ? t3.length : 0) + a3;
              }
              getTopLevelRowDisplayedIndex(e3) {
                const { rootNode: t3, rowsToDisplay: a3 } = this;
                if (!t3 || !a3.length || a3[0] === t3)
                  return e3;
                const { childrenAfterSort: n2 } = t3, o2 = (e4) => {
                  let t4 = n2[e4];
                  if (this.gos.get("groupHideOpenParents"))
                    for (; t4.expanded && t4.childrenAfterSort && t4.childrenAfterSort.length > 0; )
                      t4 = t4.childrenAfterSort[0];
                  return t4.rowIndex;
                }, { footerSvc: r2 } = this.beans;
                return r2 ? r2.getTopDisplayIndex(a3, e3, n2, o2) : o2(e3);
              }
              getRowBounds(e3) {
                const t3 = this.rowsToDisplay[e3];
                return t3 ? { rowTop: t3.rowTop, rowHeight: t3.rowHeight } : null;
              }
              onRowGroupOpened() {
                const e3 = (0, r._isAnimateRows)(this.gos);
                this.refreshModel({ step: "map", keepRenderedRows: true, animate: e3 });
              }
              onFilterChanged(e3) {
                if (e3.afterDataChange)
                  return;
                const t3 = (0, r._isAnimateRows)(this.gos), a3 = 0 === e3.columns.length || e3.columns.some((e4) => e4.isPrimary()) ? "filter" : "filter_aggregates";
                this.refreshModel({ step: a3, keepRenderedRows: true, animate: t3 });
              }
              onSortChanged() {
                const e3 = (0, r._isAnimateRows)(this.gos);
                this.refreshModel({ step: "sort", keepRenderedRows: true, animate: e3 });
              }
              getType() {
                return "clientSide";
              }
              onValueChanged() {
                this.refreshModel({ step: this.colModel.isPivotActive() ? "pivot" : "aggregate" });
              }
              createChangePath(e3) {
                const t3 = !(e3 == null ? void 0 : e3.length), a3 = new l.ChangedPath(false, this.rootNode);
                return t3 && (a3.active = false), a3;
              }
              isSuppressModelUpdateAfterUpdateTransaction(e3) {
                if (!this.gos.get("suppressModelUpdateAfterUpdateTransaction"))
                  return false;
                const t3 = e3.rowNodeTransactions;
                if (!t3)
                  return false;
                return !t3.some((e4) => null != e4.add && e4.add.length > 0 || null != e4.remove && e4.remove.length > 0);
              }
              refreshModel(e3) {
                var _a, _b, _c;
                if (!this.rootNode)
                  return;
                const t3 = e3.rowNodeTransactions, a3 = (_a = e3.changedPath) != null ? _a : e3.changedPath = this.createChangePath(t3);
                if ((_c = (_b = this.nodeManager).refreshModel) == null ? void 0 : _c.call(_b, e3), this.eventSvc.dispatchEvent({ type: "beforeRefreshModel", params: e3 }), !this.started)
                  return;
                if (e3.rowDataUpdated && this.eventSvc.dispatchEvent({ type: "rowDataUpdated" }), this.isRefreshingModel || this.colModel.changeEventsDispatching || this.isSuppressModelUpdateAfterUpdateTransaction(e3))
                  return;
                switch (this.isRefreshingModel = true, e3.step) {
                  case "group":
                    this.doRowGrouping(e3.rowNodeTransactions, e3.changedRowNodes, a3, !!e3.rowNodesOrderChanged, !!e3.afterColumnsChanged);
                  case "filter":
                    this.doFilter(a3);
                  case "pivot":
                    this.doPivot(a3);
                  case "aggregate":
                    this.doAggregate(a3);
                  case "filter_aggregates":
                    this.doFilterAggregates(a3);
                  case "sort":
                    this.doSort(e3.changedRowNodes, a3);
                  case "map":
                    this.doRowsToDisplay();
                }
                const n2 = this.setRowTopAndRowIndex();
                this.clearRowTopAndRowIndex(a3, n2), this.isRefreshingModel = false, this.eventSvc.dispatchEvent({ type: "modelUpdated", animate: e3.animate, keepRenderedRows: e3.keepRenderedRows, newData: e3.newData, newPage: false, keepUndoRedoStack: e3.keepUndoRedoStack });
              }
              isEmpty() {
                var _a, _b, _c;
                return !((_b = (_a = this.rootNode) == null ? void 0 : _a.allLeafChildren) == null ? void 0 : _b.length) || !((_c = this.colModel) == null ? void 0 : _c.ready);
              }
              isRowsToRender() {
                return this.rowsToDisplay.length > 0;
              }
              getNodesInRangeForSelection(e3, t3) {
                let a3 = false, n2 = false;
                const o2 = [], i2 = (0, r._getGroupSelectsDescendants)(this.gos);
                return this.forEachNodeAfterFilterAndSort((r2) => {
                  if (n2)
                    return;
                  if (a3 && (r2 === t3 || r2 === e3) && (n2 = true, r2.group && i2))
                    return void o2.push(...r2.allLeafChildren);
                  if (!a3) {
                    if (r2 !== t3 && r2 !== e3)
                      return;
                    a3 = true;
                  }
                  (!r2.group || !i2) && o2.push(r2);
                }), o2;
              }
              getTopLevelNodes() {
                var _a, _b;
                return (_b = (_a = this.rootNode) == null ? void 0 : _a.childrenAfterGroup) != null ? _b : null;
              }
              getRow(e3) {
                return this.rowsToDisplay[e3];
              }
              isRowPresent(e3) {
                return this.rowsToDisplay.indexOf(e3) >= 0;
              }
              getRowIndexAtPixel(e3) {
                const t3 = this.rowsToDisplay;
                if (this.isEmpty() || 0 === t3.length)
                  return -1;
                let a3 = 0, n2 = t3.length - 1;
                if (e3 <= 0)
                  return 0;
                if ((0, i._last)(t3).rowTop <= e3)
                  return t3.length - 1;
                let o2 = -1, r2 = -1;
                for (; ; ) {
                  const i2 = Math.floor((a3 + n2) / 2), l2 = t3[i2];
                  if (this.isRowInPixel(l2, e3))
                    return i2;
                  l2.rowTop < e3 ? a3 = i2 + 1 : l2.rowTop > e3 && (n2 = i2 - 1);
                  if (o2 === a3 && r2 === n2)
                    return i2;
                  o2 = a3, r2 = n2;
                }
              }
              isRowInPixel(e3, t3) {
                const a3 = e3.rowTop, n2 = e3.rowTop + e3.rowHeight;
                return a3 <= t3 && n2 > t3;
              }
              forEachLeafNode(e3) {
                var _a, _b;
                (_b = (_a = this.rootNode) == null ? void 0 : _a.allLeafChildren) == null ? void 0 : _b.forEach((t3, a3) => e3(t3, a3));
              }
              forEachNode(e3, t3 = false) {
                var _a;
                this.recursivelyWalkNodesAndCallback({ nodes: [...((_a = this.rootNode) == null ? void 0 : _a.childrenAfterGroup) || []], callback: e3, recursionType: h.Normal, index: 0, includeFooterNodes: t3 });
              }
              forEachNodeAfterFilter(e3, t3 = false) {
                var _a;
                this.recursivelyWalkNodesAndCallback({ nodes: [...((_a = this.rootNode) == null ? void 0 : _a.childrenAfterAggFilter) || []], callback: e3, recursionType: h.AfterFilter, index: 0, includeFooterNodes: t3 });
              }
              forEachNodeAfterFilterAndSort(e3, t3 = false) {
                var _a;
                this.recursivelyWalkNodesAndCallback({ nodes: [...((_a = this.rootNode) == null ? void 0 : _a.childrenAfterSort) || []], callback: e3, recursionType: h.AfterFilterAndSort, index: 0, includeFooterNodes: t3 });
              }
              forEachPivotNode(e3, t3 = false) {
                const a3 = this.rootNode;
                a3 && this.recursivelyWalkNodesAndCallback({ nodes: [a3], callback: e3, recursionType: h.PivotNodes, index: 0, includeFooterNodes: t3 });
              }
              recursivelyWalkNodesAndCallback(e3) {
                const { nodes: t3, callback: a3, recursionType: n2, includeFooterNodes: o2 } = e3;
                let { index: r2 } = e3;
                const { footerSvc: i2 } = this.beans;
                i2 == null ? void 0 : i2.addNodes(e3, t3, a3, o2, this.rootNode, "top");
                for (let e4 = 0; e4 < t3.length; e4++) {
                  const i3 = t3[e4];
                  if (a3(i3, r2++), i3.hasChildren() && !i3.footer) {
                    let e5 = null;
                    switch (n2) {
                      case h.Normal:
                        e5 = i3.childrenAfterGroup;
                        break;
                      case h.AfterFilter:
                        e5 = i3.childrenAfterAggFilter;
                        break;
                      case h.AfterFilterAndSort:
                        e5 = i3.childrenAfterSort;
                        break;
                      case h.PivotNodes:
                        e5 = i3.leafGroup ? null : i3.childrenAfterSort;
                    }
                    e5 && (r2 = this.recursivelyWalkNodesAndCallback({ nodes: [...e5], callback: a3, recursionType: n2, index: r2, includeFooterNodes: o2 }));
                  }
                }
                return i2 == null ? void 0 : i2.addNodes(e3, t3, a3, o2, this.rootNode, "bottom"), r2;
              }
              doAggregate(e3) {
                var _a;
                const t3 = this.rootNode;
                t3 && ((_a = this.aggStage) == null ? void 0 : _a.execute({ rowNode: t3, changedPath: e3 }));
              }
              doFilterAggregates(e3) {
                const t3 = this.rootNode;
                this.filterAggStage ? this.filterAggStage.execute({ rowNode: t3, changedPath: e3 }) : t3.childrenAfterAggFilter = t3.childrenAfterFilter;
              }
              doSort(e3, t3) {
                const { groupHideOpenParentsSvc: a3 } = this.beans;
                this.sortStage ? this.sortStage.execute({ rowNode: this.rootNode, changedRowNodes: e3, changedPath: t3 }) : t3.forEachChangedNodeDepthFirst((e4) => {
                  a3 == null ? void 0 : a3.pullDownGroupDataForHideOpenParents(e4.childrenAfterAggFilter, true), e4.childrenAfterSort = e4.childrenAfterAggFilter.slice(0), (0, u.updateRowNodeAfterSort)(e4);
                }), a3 == null ? void 0 : a3.updateGroupDataForHideOpenParents(t3);
              }
              doRowGrouping(e3, t3, a3, n2, o2) {
                const r2 = this.nodeManager.treeData, i2 = this.rootNode;
                if (!r2) {
                  const r3 = this.groupStage;
                  if (r3)
                    r3.execute({ rowNode: i2, changedPath: a3, changedRowNodes: t3, rowNodeTransactions: e3, rowNodesOrderChanged: n2, afterColumnsChanged: o2 });
                  else {
                    const e4 = i2.sibling;
                    i2.childrenAfterGroup = i2.allLeafChildren, e4 && (e4.childrenAfterGroup = i2.childrenAfterGroup), i2.updateHasChildren();
                  }
                }
                this.rowNodesCountReady && (this.rowCountReady = true, this.eventSvc.dispatchEventOnce({ type: "rowCountReady" }));
              }
              doFilter(e3) {
                this.filterStage ? this.filterStage.execute({ rowNode: this.rootNode, changedPath: e3 }) : e3.forEachChangedNodeDepthFirst((e4) => {
                  e4.childrenAfterFilter = e4.childrenAfterGroup, (0, g.updateRowNodeAfterFilter)(e4);
                }, true);
              }
              doPivot(e3) {
                var _a;
                (_a = this.pivotStage) == null ? void 0 : _a.execute({ rowNode: this.rootNode, changedPath: e3 });
              }
              getRowNode(e3) {
                if ("string" == typeof e3 && 0 == e3.indexOf(o.ROW_ID_PREFIX_ROW_GROUP)) {
                  let t3;
                  return this.forEachNode((a3) => {
                    a3.id === e3 && (t3 = a3);
                  }), t3;
                }
                return this.nodeManager.getRowNode(e3);
              }
              batchUpdateRowData(e3, t3) {
                if (null == this.applyAsyncTransactionsTimeout) {
                  this.rowDataTransactionBatch = [];
                  const e4 = this.gos.get("asyncTransactionWaitMillis");
                  this.applyAsyncTransactionsTimeout = window.setTimeout(() => {
                    this.isAlive() && this.executeBatchUpdateRowData();
                  }, e4);
                }
                this.rowDataTransactionBatch.push({ rowDataTransaction: e3, callback: t3 });
              }
              flushAsyncTransactions() {
                null != this.applyAsyncTransactionsTimeout && (clearTimeout(this.applyAsyncTransactionsTimeout), this.executeBatchUpdateRowData());
              }
              executeBatchUpdateRowData() {
                var _a, _b;
                (_a = this.valueCache) == null ? void 0 : _a.onDataChanged();
                const e3 = [], t3 = [], a3 = new c.ChangedRowNodes();
                let n2 = false;
                (_b = this.rowDataTransactionBatch) == null ? void 0 : _b.forEach((o2) => {
                  this.rowNodesCountReady = true;
                  const { rowNodeTransaction: r2, rowsInserted: i2 } = this.nodeManager.updateRowData(o2.rowDataTransaction, a3);
                  i2 && (n2 = true), t3.push(r2), o2.callback && e3.push(o2.callback.bind(null, r2));
                }), this.commitTransactions(t3, n2, a3), e3.length > 0 && window.setTimeout(() => {
                  e3.forEach((e4) => e4());
                }, 0), t3.length > 0 && this.eventSvc.dispatchEvent({ type: "asyncTransactionsFlushed", results: t3 }), this.rowDataTransactionBatch = null, this.applyAsyncTransactionsTimeout = void 0;
              }
              updateRowData(e3) {
                var _a;
                (_a = this.valueCache) == null ? void 0 : _a.onDataChanged(), this.rowNodesCountReady = true;
                const t3 = new c.ChangedRowNodes(), { rowNodeTransaction: a3, rowsInserted: n2 } = this.nodeManager.updateRowData(e3, t3);
                return this.commitTransactions([a3], n2, t3), a3;
              }
              commitTransactions(e3, t3, a3) {
                this.refreshModel({ step: "group", rowDataUpdated: true, rowNodeTransactions: e3, rowNodesOrderChanged: t3, keepRenderedRows: true, animate: !this.gos.get("suppressAnimationFrame"), changedRowNodes: a3, changedPath: this.createChangePath(e3) });
              }
              doRowsToDisplay() {
                var _a;
                const { flattenStage: e3, rootNode: t3 } = this;
                let a3;
                if (e3)
                  a3 = e3.execute({ rowNode: t3 });
                else {
                  a3 = (_a = t3 == null ? void 0 : t3.childrenAfterSort) != null ? _a : [];
                  for (const e4 of a3)
                    e4.setUiLevel(0);
                }
                this.rowsToDisplay = a3;
              }
              onRowHeightChanged() {
                this.refreshModel({ step: "map", keepRenderedRows: true, keepUndoRedoStack: true });
              }
              onRowHeightChangedDebounced() {
                this.onRowHeightChanged_debounced();
              }
              resetRowHeights() {
                const e3 = this.rootNode;
                if (!e3)
                  return;
                const t3 = this.resetRowHeightsForAllRowNodes();
                e3.setRowHeight(e3.rowHeight, true), e3.sibling && e3.sibling.setRowHeight(e3.sibling.rowHeight, true), t3 && this.onRowHeightChanged();
              }
              resetRowHeightsForAllRowNodes() {
                let e3 = false;
                return this.forEachNode((t3) => {
                  t3.setRowHeight(t3.rowHeight, true);
                  const a3 = t3.detailNode;
                  a3 && a3.setRowHeight(a3.rowHeight, true), t3.sibling && t3.sibling.setRowHeight(t3.sibling.rowHeight, true), e3 = true;
                }), e3;
              }
              onGridStylesChanges(e3) {
                var _a;
                if (e3.rowHeightChanged) {
                  if ((_a = this.beans.rowAutoHeight) == null ? void 0 : _a.active)
                    return;
                  this.resetRowHeights();
                }
              }
              onGridReady() {
                this.started || this.setInitialData();
              }
              isRowDataLoaded() {
                return this.rowCountReady;
              }
              destroy() {
                super.destroy(), this.clearHighlightedRow(), this.started = false, this.rootNode = null, this.nodeManager = null, this.rowDataTransactionBatch = null, this.lastHighlightedRow = null, this.orderedStages = i._EmptyArray, this.rowsToDisplay = i._EmptyArray;
              }
            }
            t2.ClientSideRowModel = p;
          }, 4452: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.getBestCostNodeSelection = t2.flushAsyncTransactions = t2.applyTransactionAsync = t2.applyTransaction = t2.resetRowHeights = t2.forEachNodeAfterFilterAndSort = t2.forEachNodeAfterFilter = t2.forEachLeafNode = t2.isRowDataEmpty = t2.refreshClientSideRowModel = t2.onGroupExpandedOrCollapsed = void 0;
            const n = a2(6876), o = a2(7764);
            t2.onGroupExpandedOrCollapsed = function(e3) {
              var _a;
              (_a = e3.expansionSvc) == null ? void 0 : _a.onGroupExpandedOrCollapsed();
            }, t2.refreshClientSideRowModel = function(e3, t3) {
              const a3 = (0, n._getClientSideRowModel)(e3);
              a3 && (t3 && "everything" !== t3 || (t3 = "group"), a3.refreshModel({ step: t3, keepRenderedRows: true, animate: !e3.gos.get("suppressAnimationFrame") }));
            }, t2.isRowDataEmpty = function(e3) {
              var _a, _b;
              return (_b = (_a = (0, n._getClientSideRowModel)(e3)) == null ? void 0 : _a.isEmpty()) != null ? _b : true;
            }, t2.forEachLeafNode = function(e3, t3) {
              var _a;
              (_a = (0, n._getClientSideRowModel)(e3)) == null ? void 0 : _a.forEachLeafNode(t3);
            }, t2.forEachNodeAfterFilter = function(e3, t3) {
              var _a;
              (_a = (0, n._getClientSideRowModel)(e3)) == null ? void 0 : _a.forEachNodeAfterFilter(t3);
            }, t2.forEachNodeAfterFilterAndSort = function(e3, t3) {
              var _a;
              (_a = (0, n._getClientSideRowModel)(e3)) == null ? void 0 : _a.forEachNodeAfterFilterAndSort(t3);
            }, t2.resetRowHeights = function(e3) {
              var _a, _b;
              ((_a = e3.rowAutoHeight) == null ? void 0 : _a.active) ? (0, o._warn)(3) : (_b = (0, n._getClientSideRowModel)(e3)) == null ? void 0 : _b.resetRowHeights();
            }, t2.applyTransaction = function(e3, t3) {
              return e3.frameworkOverrides.wrapIncoming(() => {
                var _a;
                return (_a = (0, n._getClientSideRowModel)(e3)) == null ? void 0 : _a.updateRowData(t3);
              });
            }, t2.applyTransactionAsync = function(e3, t3, a3) {
              e3.frameworkOverrides.wrapIncoming(() => {
                var _a;
                return (_a = (0, n._getClientSideRowModel)(e3)) == null ? void 0 : _a.batchUpdateRowData(t3, a3);
              });
            }, t2.flushAsyncTransactions = function(e3) {
              e3.frameworkOverrides.wrapIncoming(() => {
                var _a;
                return (_a = (0, n._getClientSideRowModel)(e3)) == null ? void 0 : _a.flushAsyncTransactions();
              });
            }, t2.getBestCostNodeSelection = function(e3) {
              var _a;
              return (_a = e3.selectionSvc) == null ? void 0 : _a.getBestCostNodeSelection();
            };
          }, 9722: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ClientSideRowModelApiModule = t2.ClientSideRowModelModule = void 0;
            const n = a2(6437), o = a2(6620), r = a2(7205), i = a2(5747), l = a2(3278), s = a2(4452), d = a2(9849);
            t2.ClientSideRowModelModule = { moduleName: "ClientSideRowModel", version: r.VERSION, rowModels: ["clientSide"], beans: [i.ClientSideNodeManager, l.ClientSideRowModel, d.SortStage], dependsOn: [o.SortModule] }, t2.ClientSideRowModelApiModule = { moduleName: "ClientSideRowModelApi", version: r.VERSION, rowModels: ["clientSide"], apiFunctions: { onGroupExpandedOrCollapsed: s.onGroupExpandedOrCollapsed, refreshClientSideRowModel: s.refreshClientSideRowModel, isRowDataEmpty: s.isRowDataEmpty, forEachLeafNode: s.forEachLeafNode, forEachNodeAfterFilter: s.forEachNodeAfterFilter, forEachNodeAfterFilterAndSort: s.forEachNodeAfterFilterAndSort, resetRowHeights: s.resetRowHeights, applyTransaction: s.applyTransaction, applyTransactionAsync: s.applyTransactionAsync, flushAsyncTransactions: s.flushAsyncTransactions, getBestCostNodeSelection: s.getBestCostNodeSelection }, dependsOn: [n.CsrmSsrmSharedApiModule] };
          }, 8287: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.FilterStage = t2.updateRowNodeAfterFilter = void 0;
            const n = a2(8731);
            function o(e3) {
              e3.sibling && (e3.sibling.childrenAfterFilter = e3.childrenAfterFilter);
            }
            t2.updateRowNodeAfterFilter = o;
            class r extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "filterStage", this.refreshProps = /* @__PURE__ */ new Set(["excludeChildrenWhenTreeDataFiltering"]), this.step = "filter";
              }
              wireBeans(e3) {
                this.filterManager = e3.filterManager;
              }
              execute(e3) {
                const { changedPath: t3 } = e3;
                this.filter(t3);
              }
              filter(e3) {
                var _a;
                const t3 = !!((_a = this.filterManager) == null ? void 0 : _a.isChildFilterPresent());
                this.filterNodes(t3, e3);
              }
              filterNodes(e3, t3) {
                const a3 = (t4, a4) => {
                  t4.hasChildren() ? t4.childrenAfterFilter = e3 && !a4 ? t4.childrenAfterGroup.filter((e4) => {
                    const t5 = e4.childrenAfterFilter && e4.childrenAfterFilter.length > 0, a5 = e4.data && this.filterManager.doesRowPassFilter({ rowNode: e4 });
                    return t5 || a5;
                  }) : t4.childrenAfterGroup : t4.childrenAfterFilter = t4.childrenAfterGroup, o(t4);
                };
                if (this.doingTreeDataFiltering()) {
                  const e4 = (t4, n3) => {
                    if (t4.childrenAfterGroup)
                      for (let o2 = 0; o2 < t4.childrenAfterGroup.length; o2++) {
                        const r2 = t4.childrenAfterGroup[o2], i = n3 || this.filterManager.doesRowPassFilter({ rowNode: r2 });
                        r2.childrenAfterGroup ? e4(t4.childrenAfterGroup[o2], i) : a3(r2, i);
                      }
                    a3(t4, n3);
                  }, n2 = (t4) => e4(t4, false);
                  t3.executeFromRootNode(n2);
                } else {
                  const e4 = (e5) => a3(e5, false);
                  t3.forEachChangedNodeDepthFirst(e4, true);
                }
              }
              doingTreeDataFiltering() {
                return this.gos.get("treeData") && !this.gos.get("excludeChildrenWhenTreeDataFiltering");
              }
            }
            t2.FilterStage = r;
          }, 9849: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.SortStage = t2.updateRowNodeAfterSort = void 0;
            const n = a2(8731), o = a2(7274), r = a2(4422);
            function i(e3) {
              e3.sibling && (e3.sibling.childrenAfterSort = e3.childrenAfterSort), function(e4) {
                if ((0, r._missing)(e4.childrenAfterSort))
                  return;
                const t3 = e4.childrenAfterSort;
                for (let a3 = 0; a3 < t3.length; a3++) {
                  const n2 = t3[a3], o2 = 0 === a3, r2 = a3 === e4.childrenAfterSort.length - 1;
                  n2.setFirstChild(o2), n2.lastChild !== r2 && (n2.lastChild = r2, n2.dispatchRowEvent("lastChildChanged")), n2.childIndex !== a3 && (n2.childIndex = a3, n2.dispatchRowEvent("childIndexChanged"));
                }
              }(e3);
            }
            t2.updateRowNodeAfterSort = i;
            class l extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "sortStage", this.refreshProps = /* @__PURE__ */ new Set(["postSortRows", "groupDisplayType", "accentedSort"]), this.step = "sort";
              }
              execute(e3) {
                const t3 = this.beans, a3 = t3.sortSvc.getSortOptions(), n2 = (0, r._exists)(a3) && a3.length > 0, i2 = n2 && !!e3.changedRowNodes && this.gos.get("deltaSort"), l2 = a3.some(({ column: e4 }) => (0, o._isColumnsSortingCoupledToGroup)(t3.gos) ? e4.isPrimary() && e4.isRowGroupActive() : !!e4.getColDef().showRowGroup);
                this.sort(t3, a3, n2, i2, e3.changedRowNodes, e3.changedPath, l2);
              }
              sort(e3, t3, a3, n2, o2, r2, l2) {
                const { gos: s, colModel: d, rowGroupColsSvc: c, groupHideOpenParentsSvc: g, rowNodeSorter: u } = e3, h = s.get("groupMaintainOrder"), p = d.getCols().some((e4) => e4.isRowGroupActive()), m = d.isPivotMode(), f = s.getCallback("postSortRows");
                r2 == null ? void 0 : r2.forEachChangedNodeDepthFirst((e4) => {
                  var _a;
                  g == null ? void 0 : g.pullDownGroupDataForHideOpenParents(e4.childrenAfterAggFilter, true);
                  const s2 = m && e4.leafGroup;
                  let d2;
                  if (h && p && !e4.leafGroup && !l2) {
                    const t4 = (_a = c == null ? void 0 : c.columns) == null ? void 0 : _a[e4.level + 1], a4 = null === (t4 == null ? void 0 : t4.getSort()), n3 = e4.childrenAfterAggFilter.slice(0);
                    if (e4.childrenAfterSort && !a4) {
                      const t5 = {};
                      e4.childrenAfterSort.forEach((e5, a5) => {
                        t5[e5.id] = a5;
                      }), n3.sort((e5, a5) => {
                        var _a2, _b;
                        return ((_a2 = t5[e5.id]) != null ? _a2 : 0) - ((_b = t5[a5.id]) != null ? _b : 0);
                      });
                    }
                    d2 = n3;
                  } else
                    d2 = !a3 || s2 ? e4.childrenAfterAggFilter.slice(0) : n2 && o2 ? function(e5, t4, a4, n3, o3) {
                      const r3 = t4.childrenAfterAggFilter, i2 = t4.childrenAfterSort;
                      if (!i2)
                        return e5.doFullSort(r3, o3);
                      const l3 = /* @__PURE__ */ new Set(), s3 = [], d3 = a4.updates;
                      for (let e6 = 0, t5 = r3.length; e6 < t5; ++e6) {
                        const t6 = r3[e6];
                        d3.has(t6) || n3 && !n3.canSkip(t6) ? s3.push({ currentPos: s3.length, rowNode: t6 }) : l3.add(t6.id);
                      }
                      const c2 = i2.filter((e6) => l3.has(e6.id)).map((e6, t5) => ({ currentPos: t5, rowNode: e6 }));
                      return s3.sort((t5, a5) => e5.compareRowNodes(o3, t5, a5)), function(e6, t5, a5, n4) {
                        const o4 = [];
                        let r4 = 0, i3 = 0;
                        const l4 = a5.length, s4 = n4.length;
                        for (; r4 < l4 && i3 < s4; ) {
                          const l5 = a5[r4], s5 = n4[i3];
                          let d4;
                          e6.compareRowNodes(t5, l5, s5) < 0 ? (d4 = l5, ++r4) : (d4 = s5, ++i3), o4.push(d4.rowNode);
                        }
                        for (; r4 < l4; )
                          o4.push(a5[r4++].rowNode);
                        for (; i3 < s4; )
                          o4.push(n4[i3++].rowNode);
                        return o4;
                      }(e5, o3, s3, c2);
                    }(u, e4, o2, r2, t3) : u.doFullSort(e4.childrenAfterAggFilter, t3);
                  if (e4.childrenAfterSort = d2, i(e4), f) {
                    const t4 = { nodes: e4.childrenAfterSort };
                    f(t4);
                  }
                });
              }
            }
            t2.SortStage = l;
          }, 3218: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.autoSizeAllColumns = t2.autoSizeColumns = t2.sizeColumnsToFit = void 0, t2.sizeColumnsToFit = function(e3, t3) {
              var _a, _b;
              "number" == typeof t3 ? (_a = e3.colAutosize) == null ? void 0 : _a.sizeColumnsToFit(t3, "api") : (_b = e3.colAutosize) == null ? void 0 : _b.sizeColumnsToFitGridBody(t3);
            }, t2.autoSizeColumns = function(e3, t3, a2) {
              var _a;
              (_a = e3.colAutosize) == null ? void 0 : _a.autoSizeCols({ colKeys: t3, skipHeader: a2, source: "api" });
            }, t2.autoSizeAllColumns = function(e3, t3) {
              var _a;
              (_a = e3.colAutosize) == null ? void 0 : _a.autoSizeAllColumns("api", t3);
            };
          }, 3856: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnAutoSizeModule = void 0;
            const n = a2(447), o = a2(7205), r = a2(3218), i = a2(4817);
            t2.ColumnAutoSizeModule = { moduleName: "ColumnAutoSize", version: o.VERSION, beans: [i.ColumnAutosizeService], apiFunctions: { sizeColumnsToFit: r.sizeColumnsToFit, autoSizeColumns: r.autoSizeColumns, autoSizeAllColumns: r.autoSizeAllColumns }, dependsOn: [n.AutoWidthModule] };
          }, 4817: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnAutosizeService = void 0;
            const n = a2(2934), o = a2(3146), r = a2(8731), i = a2(1502), l = a2(3507), s = a2(7764), d = a2(9644);
            class c extends r.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colAutosize", this.timesDelayed = 0, this.shouldQueueResizeOperations = false, this.resizeOperationQueue = [];
              }
              postConstruct() {
                this.addManagedEventListeners({ firstDataRendered: () => this.onFirstDataRendered() });
              }
              autoSizeCols(e3) {
                if (this.shouldQueueResizeOperations)
                  return void this.pushResizeOperation(() => this.autoSizeCols(e3));
                const { colKeys: t3, skipHeader: a3, skipHeaderGroups: o2, stopAtGroup: r2, source: i2 = "api" } = e3, { animationFrameSvc: l2, renderStatus: s2, colModel: d2, autoWidthCalc: c2, visibleCols: u } = this.beans;
                if (l2 == null ? void 0 : l2.flushAllFrames(), this.timesDelayed < 5 && s2 && !s2.areHeaderCellsRendered())
                  return this.timesDelayed++, void setTimeout(() => {
                    this.isAlive() && this.autoSizeCols(e3);
                  });
                this.timesDelayed = 0;
                const h = [];
                let p = -1;
                const m = null != a3 ? a3 : this.gos.get("skipHeaderOnAutoSize"), f = null != o2 ? o2 : m;
                for (; 0 !== p; ) {
                  p = 0;
                  const e4 = [];
                  t3.forEach((t4) => {
                    if (!t4)
                      return;
                    const a4 = d2.getCol(t4);
                    if (!a4)
                      return;
                    if (h.indexOf(a4) >= 0)
                      return;
                    const n2 = c2.getPreferredWidthForColumn(a4, m);
                    if (n2 > 0) {
                      const e5 = g(a4, n2);
                      a4.setActualWidth(e5, i2), h.push(a4), p++;
                    }
                    e4.push(a4);
                  }), e4.length && u.refresh(i2);
                }
                f || this.autoSizeColumnGroupsByColumns(t3, i2, r2), (0, n.dispatchColumnResizedEvent)(this.eventSvc, h, true, "autosizeColumns");
              }
              autoSizeColumn(e3, t3, a3) {
                e3 && this.autoSizeCols({ colKeys: [e3], skipHeader: a3, skipHeaderGroups: true, source: t3 });
              }
              autoSizeColumnGroupsByColumns(e3, t3, a3) {
                const { colModel: n2, ctrlsSvc: o2 } = this.beans, r2 = /* @__PURE__ */ new Set();
                let i2;
                n2.getColsForKeys(e3).forEach((e4) => {
                  let t4 = e4.getParent();
                  for (; t4 && t4 != a3; )
                    t4.isPadding() || r2.add(t4), t4 = t4.getParent();
                });
                for (const e4 of r2) {
                  for (const t4 of o2.getHeaderRowContainerCtrls())
                    if (i2 = t4.getHeaderCtrlForColumn(e4), i2)
                      break;
                  i2 && i2.resizeLeafColumnsToFit(t3);
                }
                return [];
              }
              autoSizeAllColumns(e3, t3) {
                if (this.shouldQueueResizeOperations)
                  return void this.pushResizeOperation(() => this.autoSizeAllColumns(e3, t3));
                const a3 = this.beans.visibleCols.allCols;
                this.autoSizeCols({ colKeys: a3, skipHeader: t3, source: e3 });
              }
              addColumnAutosize(e3, t3) {
                const a3 = this.gos.get("skipHeaderOnAutoSize"), n2 = () => {
                  this.autoSizeColumn(t3, "uiColumnResized", a3);
                };
                e3.addEventListener("dblclick", n2);
                const o2 = new d.TouchListener(e3);
                return o2.addEventListener("doubleTap", n2), () => {
                  e3.removeEventListener("dblclick", n2), o2.removeEventListener("doubleTap", n2), o2.destroy();
                };
              }
              addColumnGroupResize(e3, t3, a3) {
                const n2 = this.gos.get("skipHeaderOnAutoSize"), o2 = () => {
                  const e4 = [];
                  t3.getDisplayedLeafColumns().forEach((t4) => {
                    t4.getColDef().suppressAutoSize || e4.push(t4.getColId());
                  }), e4.length > 0 && this.autoSizeCols({ colKeys: e4, skipHeader: n2, stopAtGroup: t3, source: "uiColumnResized" }), a3();
                };
                return e3.addEventListener("dblclick", o2), () => e3.removeEventListener("dblclick", o2);
              }
              sizeColumnsToFitGridBody(e3, t3) {
                if (!this.isAlive())
                  return;
                const { ctrlsSvc: a3, scrollVisibleSvc: n2 } = this.beans, o2 = a3.getGridBodyCtrl(), r2 = o2.isVerticalScrollShowing() ? n2.getScrollbarWidth() : 0, i2 = (0, l._getInnerWidth)(o2.eGridBody) - r2;
                i2 > 0 ? this.sizeColumnsToFit(i2, "sizeColumnsToFit", false, e3) : void 0 === t3 ? window.setTimeout(() => {
                  this.sizeColumnsToFitGridBody(e3, 100);
                }, 0) : 100 === t3 ? window.setTimeout(() => {
                  this.sizeColumnsToFitGridBody(e3, 500);
                }, 100) : 500 === t3 ? window.setTimeout(() => {
                  this.sizeColumnsToFitGridBody(e3, -1);
                }, 500) : (0, s._warn)(29);
              }
              sizeColumnsToFit(e3, t3 = "sizeColumnsToFit", a3, r2) {
                var _c2, _d, _e;
                if (this.shouldQueueResizeOperations)
                  return void this.pushResizeOperation(() => this.sizeColumnsToFit(e3, t3, a3, r2));
                const l2 = {};
                r2 && ((_c2 = r2 == null ? void 0 : r2.columnLimits) == null ? void 0 : _c2.forEach((_a) => {
                  var _b = _a, { key: e4 } = _b, t4 = __objRest(_b, ["key"]);
                  l2["string" == typeof e4 ? e4 : e4.getColId()] = t4;
                }));
                const s2 = this.beans.visibleCols.allCols, d2 = e3 === (0, o.getWidthOfColsInList)(s2);
                if (e3 <= 0 || !s2.length || d2)
                  return;
                const c2 = [], g2 = [];
                s2.forEach((e4) => {
                  true === e4.getColDef().suppressSizeToFit ? g2.push(e4) : c2.push(e4);
                });
                const u = c2.slice(0);
                let h = false;
                const p = (e4) => {
                  (0, i._removeFromArray)(c2, e4), g2.push(e4);
                };
                for (c2.forEach((e4) => {
                  var _a, _b;
                  e4.resetActualWidth(t3);
                  const a4 = l2 == null ? void 0 : l2[e4.getId()], n2 = (_a = a4 == null ? void 0 : a4.minWidth) != null ? _a : r2 == null ? void 0 : r2.defaultMinWidth, o2 = (_b = a4 == null ? void 0 : a4.maxWidth) != null ? _b : r2 == null ? void 0 : r2.defaultMaxWidth, i2 = e4.getActualWidth();
                  "number" == typeof n2 && i2 < n2 ? e4.setActualWidth(n2, t3, true) : "number" == typeof o2 && i2 > o2 && e4.setActualWidth(o2, t3, true);
                }); !h; ) {
                  h = true;
                  const a4 = e3 - (0, o.getWidthOfColsInList)(g2);
                  if (a4 <= 0)
                    c2.forEach((e4) => {
                      var _a, _b;
                      const a5 = (_b = (_a = l2 == null ? void 0 : l2[e4.getId()]) == null ? void 0 : _a.minWidth) != null ? _b : r2 == null ? void 0 : r2.defaultMinWidth;
                      "number" != typeof a5 ? e4.setActualWidth(e4.minWidth, t3) : e4.setActualWidth(a5, t3, true);
                    });
                  else {
                    const e4 = a4 / (0, o.getWidthOfColsInList)(c2);
                    let n2 = a4;
                    for (let a5 = c2.length - 1; a5 >= 0; a5--) {
                      const o2 = c2[a5], i2 = l2 == null ? void 0 : l2[o2.getId()], s3 = (_d = i2 == null ? void 0 : i2.minWidth) != null ? _d : r2 == null ? void 0 : r2.defaultMinWidth, d3 = (_e = i2 == null ? void 0 : i2.maxWidth) != null ? _e : r2 == null ? void 0 : r2.defaultMaxWidth, g3 = o2.getMinWidth(), u2 = o2.getMaxWidth(), m2 = "number" == typeof s3 && s3 > g3 ? s3 : g3, f = "number" == typeof d3 && d3 < u2 ? d3 : u2;
                      let v = Math.round(o2.getActualWidth() * e4);
                      v < m2 ? (v = m2, p(o2), h = false) : v > f ? (v = f, p(o2), h = false) : 0 === a5 && (v = n2), o2.setActualWidth(v, t3, true), n2 -= v;
                    }
                  }
                }
                u.forEach((e4) => {
                  e4.fireColumnWidthChangedEvent(t3);
                });
                const m = this.beans.visibleCols;
                m.setLeftValues(t3), m.updateBodyWidths(), a3 || (0, n.dispatchColumnResizedEvent)(this.eventSvc, u, true, t3);
              }
              applyAutosizeStrategy() {
                const e3 = this.gos.get("autoSizeStrategy");
                if (!e3)
                  return;
                const { type: t3 } = e3;
                setTimeout(() => {
                  if ("fitGridWidth" === t3) {
                    const { columnLimits: t4, defaultMinWidth: a3, defaultMaxWidth: n2 } = e3, o2 = t4 == null ? void 0 : t4.map(({ colId: e4, minWidth: t5, maxWidth: a4 }) => ({ key: e4, minWidth: t5, maxWidth: a4 }));
                    this.sizeColumnsToFitGridBody({ defaultMinWidth: a3, defaultMaxWidth: n2, columnLimits: o2 });
                  } else
                    "fitProvidedWidth" === t3 && this.sizeColumnsToFit(e3.width, "sizeColumnsToFit");
                });
              }
              onFirstDataRendered() {
                const e3 = this.gos.get("autoSizeStrategy");
                if ("fitCellContents" !== (e3 == null ? void 0 : e3.type))
                  return;
                const { colIds: t3, skipHeader: a3 } = e3;
                setTimeout(() => {
                  t3 ? this.autoSizeCols({ colKeys: t3, skipHeader: a3, source: "autosizeColumns" }) : this.autoSizeAllColumns("autosizeColumns", a3);
                });
              }
              processResizeOperations() {
                this.shouldQueueResizeOperations = false, this.resizeOperationQueue.forEach((e3) => e3()), this.resizeOperationQueue = [];
              }
              pushResizeOperation(e3) {
                this.resizeOperationQueue.push(e3);
              }
              destroy() {
                this.resizeOperationQueue.length = 0, super.destroy();
              }
            }
            function g(e3, t3) {
              const a3 = e3.getMinWidth();
              t3 < a3 && (t3 = a3);
              const n2 = e3.getMaxWidth();
              return e3.isGreaterThanMax(t3) && (t3 = n2), t3;
            }
            t2.ColumnAutosizeService = c;
          }, 9607: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.columnMovingCSS = void 0, t2.columnMovingCSS = ":where(.ag-ltr) :where(.ag-column-moving){.ag-cell,.ag-header-cell{transition:left .2s}.ag-header-group-cell{transition:left .2s,width .2s}}:where(.ag-rtl) :where(.ag-column-moving){.ag-cell,.ag-header-cell{transition:right .2s}.ag-header-group-cell{transition:right .2s,width .2s}}";
          }, 9122: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnAnimationService = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colAnimation", this.executeNextFuncs = [], this.executeLaterFuncs = [], this.active = false, this.activeNext = false, this.suppressAnimation = false, this.animationThreadCount = 0;
              }
              postConstruct() {
                this.beans.ctrlsSvc.whenReady(this, (e3) => this.gridBodyCtrl = e3.gridBodyCtrl);
              }
              isActive() {
                return this.active && !this.suppressAnimation;
              }
              setSuppressAnimation(e3) {
                this.suppressAnimation = e3;
              }
              start() {
                if (this.active)
                  return;
                const { gos: e3 } = this;
                e3.get("suppressColumnMoveAnimation") || e3.get("enableRtl") || (this.ensureAnimationCssClassPresent(), this.active = true, this.activeNext = true);
              }
              finish() {
                this.active && this.flush(() => this.activeNext = false, () => this.active = false);
              }
              executeNextVMTurn(e3) {
                this.activeNext ? this.executeNextFuncs.push(e3) : e3();
              }
              executeLaterVMTurn(e3) {
                this.active ? this.executeLaterFuncs.push(e3) : e3();
              }
              ensureAnimationCssClassPresent() {
                this.animationThreadCount++;
                const e3 = this.animationThreadCount, { gridBodyCtrl: t3 } = this;
                t3.setColumnMovingCss(true), this.executeLaterFuncs.push(() => {
                  this.animationThreadCount === e3 && t3.setColumnMovingCss(false);
                });
              }
              flush(e3, t3) {
                const { executeNextFuncs: a3, executeLaterFuncs: n2 } = this;
                if (0 === a3.length && 0 === n2.length)
                  return e3(), void t3();
                const o2 = (e4) => {
                  for (; e4.length; ) {
                    const t4 = e4.pop();
                    t4 && t4();
                  }
                };
                this.beans.frameworkOverrides.wrapIncoming(() => {
                  window.setTimeout(() => {
                    e3(), o2(a3);
                  }, 0), window.setTimeout(() => {
                    t3(), o2(n2);
                  }, 200);
                });
              }
            }
            t2.ColumnAnimationService = o;
          }, 3052: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.BodyDropPivotTarget = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
              constructor(e3) {
                super(), this.pinned = e3, this.columnsToAggregate = [], this.columnsToGroup = [], this.columnsToPivot = [];
              }
              onDragEnter(e3) {
                if (this.clearColumnsList(), this.gos.get("functionsReadOnly"))
                  return;
                const t3 = e3.dragItem.columns;
                t3 && t3.forEach((e4) => {
                  e4.isPrimary() && (e4.isAnyFunctionActive() || (e4.isAllowValue() ? this.columnsToAggregate.push(e4) : e4.isAllowRowGroup() ? this.columnsToGroup.push(e4) : e4.isAllowPivot() && this.columnsToPivot.push(e4)));
                });
              }
              getIconName() {
                return this.columnsToAggregate.length + this.columnsToGroup.length + this.columnsToPivot.length > 0 ? this.pinned ? "pinned" : "move" : null;
              }
              onDragLeave(e3) {
                this.clearColumnsList();
              }
              clearColumnsList() {
                this.columnsToAggregate.length = 0, this.columnsToGroup.length = 0, this.columnsToPivot.length = 0;
              }
              onDragging(e3) {
              }
              onDragStop(e3) {
                const { valueColsSvc: t3, rowGroupColsSvc: a3, pivotColsSvc: n2 } = this.beans;
                this.columnsToAggregate.length > 0 && (t3 == null ? void 0 : t3.addColumns(this.columnsToAggregate, "toolPanelDragAndDrop")), this.columnsToGroup.length > 0 && (a3 == null ? void 0 : a3.addColumns(this.columnsToGroup, "toolPanelDragAndDrop")), this.columnsToPivot.length > 0 && (n2 == null ? void 0 : n2.addColumns(this.columnsToPivot, "toolPanelDragAndDrop"));
              }
              onDragCancel() {
                this.clearColumnsList();
              }
            }
            t2.BodyDropPivotTarget = o;
          }, 7912: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.BodyDropTarget = void 0;
            const n = a2(8731), o = a2(2903), r = a2(3052), i = a2(2909);
            class l extends n.BeanStub {
              constructor(e3, t3) {
                super(), this.pinned = e3, this.eContainer = t3;
              }
              postConstruct() {
                const { ctrlsSvc: e3, dragAndDrop: t3 } = this.beans, a3 = this.pinned;
                e3.whenReady(this, (e4) => {
                  let t4;
                  const n2 = e4.gridBodyCtrl.eBodyViewport;
                  switch (a3) {
                    case "left":
                      t4 = [[n2, e4.left.eContainer], [e4.bottomLeft.eContainer], [e4.topLeft.eContainer]];
                      break;
                    case "right":
                      t4 = [[n2, e4.right.eContainer], [e4.bottomRight.eContainer], [e4.topRight.eContainer]];
                      break;
                    default:
                      t4 = [[n2, e4.center.eViewport], [e4.bottomCenter.eViewport], [e4.topCenter.eViewport]];
                  }
                  this.eSecondaryContainers = t4;
                }), this.moveColumnFeature = this.createManagedBean(new i.MoveColumnFeature(a3)), this.bodyDropPivotTarget = this.createManagedBean(new r.BodyDropPivotTarget(a3)), t3.addDropTarget(this), this.addDestroyFunc(() => t3.removeDropTarget(this));
              }
              isInterestedIn(e3) {
                return e3 === o.DragSourceType.HeaderCell || e3 === o.DragSourceType.ToolPanel && this.gos.get("allowDragFromColumnsToolPanel");
              }
              getSecondaryContainers() {
                return this.eSecondaryContainers;
              }
              getContainer() {
                return this.eContainer;
              }
              getIconName() {
                return this.currentDropListener.getIconName();
              }
              isDropColumnInPivotMode(e3) {
                return this.beans.colModel.isPivotMode() && e3.dragSource.type === o.DragSourceType.ToolPanel;
              }
              onDragEnter(e3) {
                this.currentDropListener = this.isDropColumnInPivotMode(e3) ? this.bodyDropPivotTarget : this.moveColumnFeature, this.currentDropListener.onDragEnter(e3);
              }
              onDragLeave(e3) {
                this.currentDropListener.onDragLeave(e3);
              }
              onDragging(e3) {
                this.currentDropListener.onDragging(e3);
              }
              onDragStop(e3) {
                this.currentDropListener.onDragStop(e3);
              }
              onDragCancel() {
                this.currentDropListener.onDragCancel();
              }
            }
            t2.BodyDropTarget = l;
          }, 2909: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.MoveColumnFeature = void 0;
            const n = a2(8731), o = a2(2903), r = a2(2783), i = a2(1502), l = a2(4422), s = a2(5446);
            class d extends n.BeanStub {
              constructor(e3) {
                super(), this.pinned = e3, this.needToMoveLeft = false, this.needToMoveRight = false, this.lastMovedInfo = null, this.isCenterContainer = !(0, l._exists)(e3);
              }
              postConstruct() {
                this.beans.ctrlsSvc.whenReady(this, (e3) => {
                  this.gridBodyCon = e3.gridBodyCtrl;
                });
              }
              getIconName() {
                var _a;
                const { pinned: e3, lastDraggingEvent: t3 } = this, a3 = (_a = t3 == null ? void 0 : t3.dragItem.columns) != null ? _a : [];
                for (const t4 of a3) {
                  const a4 = t4.getPinned();
                  if (t4.getColDef().lockPinned) {
                    if (a4 == e3)
                      return "move";
                  } else {
                    if (a4 === e3 || !e3)
                      return "move";
                    if (!a4 && e3)
                      return "pinned";
                  }
                }
                return "notAllowed";
              }
              onDragEnter(e3) {
                const t3 = e3.dragItem, a3 = t3.columns;
                if (e3.dragSource.type === o.DragSourceType.ToolPanel)
                  this.setColumnsVisible(a3, true, "uiColumnDragged");
                else {
                  const e4 = t3.visibleState, n2 = (a3 || []).filter((t4) => e4[t4.getId()]);
                  this.setColumnsVisible(n2, true, "uiColumnDragged");
                }
                this.gos.get("suppressMoveWhenColumnDragging") || this.attemptToPinColumns(a3, this.pinned), this.onDragging(e3, true, true);
              }
              onDragging(e3 = this.lastDraggingEvent, t3 = false, a3 = false, n2 = false) {
                const { gos: o2, ctrlsSvc: r2 } = this.beans, i2 = o2.get("suppressMoveWhenColumnDragging");
                if (n2 && !i2)
                  return void this.finishColumnMoving();
                if (this.lastDraggingEvent = e3, !e3 || !n2 && (0, l._missing)(e3.hDirection))
                  return;
                const d2 = (0, s.normaliseX)({ x: e3.x, pinned: this.pinned, gos: o2, ctrlsSvc: r2 });
                t3 || this.checkCenterForScrolling(d2), i2 ? this.handleColumnDragWhileSuppressingMovement(e3, t3, a3, d2, n2) : this.handleColumnDragWhileAllowingMovement(e3, t3, a3, d2, n2);
              }
              onDragLeave() {
                this.ensureIntervalCleared(), this.clearHighlighted(), this.lastMovedInfo = null;
              }
              onDragStop() {
                this.onDragging(this.lastDraggingEvent, false, true, true), this.ensureIntervalCleared(), this.lastMovedInfo = null;
              }
              onDragCancel() {
                this.clearHighlighted(), this.ensureIntervalCleared(), this.lastMovedInfo = null;
              }
              setColumnsVisible(e3, t3, a3) {
                if (!e3)
                  return;
                const n2 = e3.filter((e4) => !e4.getColDef().lockVisible);
                this.beans.colModel.setColsVisible(n2, t3, a3);
              }
              finishColumnMoving() {
                this.clearHighlighted();
                const e3 = this.lastMovedInfo;
                if (!e3)
                  return;
                const { columns: t3, toIndex: a3 } = e3;
                this.beans.colMoves.moveColumns(t3, a3, "uiColumnMoved", true);
              }
              handleColumnDragWhileSuppressingMovement(e3, t3, a3, n2, o2) {
                const r2 = this.getAllMovingColumns(e3, true);
                if (o2) {
                  const e4 = this.isAttemptingToPin(r2);
                  e4 && this.attemptToPinColumns(r2, void 0, true);
                  const { fromLeft: n3, xPosition: o3 } = this.getNormalisedXPositionInfo(r2, e4) || {};
                  if (null == n3 || null == o3)
                    return void this.finishColumnMoving();
                  this.moveColumnsAfterHighlight({ allMovingColumns: r2, xPosition: o3, fromEnter: t3, fakeEvent: a3, fromLeft: n3 });
                } else {
                  if (!this.beans.dragAndDrop.isDropZoneWithinThisGrid(e3))
                    return;
                  this.highlightHoveredColumn(r2, n2);
                }
              }
              handleColumnDragWhileAllowingMovement(e3, t3, a3, n2, r2) {
                const i2 = this.getAllMovingColumns(e3), l2 = "right" === this.normaliseDirection(e3.hDirection), d2 = e3.dragSource.type === o.DragSourceType.HeaderCell, c2 = this.getMoveColumnParams({ allMovingColumns: i2, isFromHeader: d2, xPosition: n2, fromLeft: l2, fromEnter: t3, fakeEvent: a3 }), g = (0, s.attemptMoveColumns)(__spreadProps(__spreadValues({}, c2), { finished: r2 }));
                g && (this.lastMovedInfo = g);
              }
              getAllMovingColumns(e3, t3 = false) {
                const a3 = e3.dragSource.getDragItem();
                let n2 = null;
                t3 ? (n2 = a3.columnsInSplit, n2 || (n2 = a3.columns)) : n2 = a3.columns;
                return n2 ? n2.filter((e4) => !e4.getColDef().lockPinned || e4.getPinned() == this.pinned) : [];
              }
              getMoveColumnParams(e3) {
                const { allMovingColumns: t3, isFromHeader: a3, xPosition: n2, fromLeft: o2, fromEnter: r2, fakeEvent: i2 } = e3, { gos: l2, colModel: s2, colMoves: d2, visibleCols: c2 } = this.beans;
                return { allMovingColumns: t3, isFromHeader: a3, fromLeft: o2, xPosition: n2, pinned: this.pinned, fromEnter: r2, fakeEvent: i2, gos: l2, colModel: s2, colMoves: d2, visibleCols: c2 };
              }
              highlightHoveredColumn(e3, t3) {
                var _a;
                const { gos: a3, colModel: n2 } = this.beans, o2 = a3.get("enableRtl"), l2 = n2.getCols().filter((e4) => e4.isVisible() && e4.getPinned() === this.pinned);
                let s2, d2 = null, g = null, u = null;
                for (const e4 of l2) {
                  if (g = e4.getActualWidth(), d2 = this.getNormalisedColumnLeft(e4, 0, o2), null != d2) {
                    if (d2 <= t3 && d2 + g >= t3) {
                      u = e4;
                      break;
                    }
                  }
                  d2 = null, g = null;
                }
                if (u)
                  -1 !== e3.indexOf(u) && (u = null);
                else {
                  for (let e4 = l2.length - 1; e4 >= 0; e4--) {
                    const t4 = l2[e4], a4 = l2[e4].getParent();
                    if (!a4) {
                      u = t4;
                      break;
                    }
                    const n3 = a4 == null ? void 0 : a4.getDisplayedLeafColumns();
                    if (n3.length) {
                      u = (0, i._last)(n3);
                      break;
                    }
                  }
                  if (!u)
                    return;
                  d2 = this.getNormalisedColumnLeft(u, 0, o2), g = u.getActualWidth();
                }
                ((_a = this.lastHighlightedColumn) == null ? void 0 : _a.column) !== u && this.clearHighlighted(), null != u && null != d2 && null != g && (s2 = t3 - d2 < g / 2 !== o2 ? r.ColumnHighlightPosition.Before : r.ColumnHighlightPosition.After, c(u, s2), this.lastHighlightedColumn = { column: u, position: s2 });
              }
              getNormalisedXPositionInfo(e3, t3) {
                const { gos: a3, visibleCols: n2 } = this.beans, o2 = a3.get("enableRtl"), { firstMovingCol: i2, column: l2, position: s2 } = this.getColumnMoveAndTargetInfo(e3, t3, o2);
                if (!i2 || !l2 || null == s2)
                  return;
                const d2 = n2.allCols, c2 = d2.indexOf(i2), g = d2.indexOf(l2), u = s2 === r.ColumnHighlightPosition.Before !== o2, h = c2 < g || c2 === g && !u;
                let p = 0;
                if (u ? h && (p -= 1) : h || (p += 1), g + p === c2)
                  return;
                const m = d2[g + p];
                if (!m)
                  return;
                return { fromLeft: h, xPosition: this.getNormalisedColumnLeft(m, 20, o2) };
              }
              getColumnMoveAndTargetInfo(e3, t3, a3) {
                const n2 = this.lastHighlightedColumn || {}, { firstMovingCol: o2, lastMovingCol: i2 } = function(e4) {
                  const t4 = e4.length;
                  let a4, n3;
                  for (let o3 = 0; o3 <= t4; o3++) {
                    if (!a4) {
                      const t5 = e4[o3];
                      null != t5.getLeft() && (a4 = t5);
                    }
                    if (!n3) {
                      const a5 = e4[t4 - 1 - o3];
                      null != a5.getLeft() && (n3 = a5);
                    }
                    if (a4 && n3)
                      break;
                  }
                  return { firstMovingCol: a4, lastMovingCol: n3 };
                }(e3);
                if (!o2 || !i2 || n2.column || !t3)
                  return __spreadValues({ firstMovingCol: o2 }, n2);
                const l2 = "left" === this.getPinDirection();
                return { firstMovingCol: o2, position: l2 ? r.ColumnHighlightPosition.After : r.ColumnHighlightPosition.Before, column: l2 !== a3 ? o2 : i2 };
              }
              normaliseDirection(e3) {
                if (this.gos.get("enableRtl"))
                  switch (e3) {
                    case "left":
                      return "right";
                    case "right":
                      return "left";
                  }
                return e3;
              }
              getNormalisedColumnLeft(e3, t3, a3) {
                const { gos: n2, ctrlsSvc: o2 } = this.beans, r2 = e3.getLeft();
                if (null == r2)
                  return null;
                const i2 = e3.getActualWidth();
                return (0, s.normaliseX)({ x: a3 ? r2 + i2 - t3 : r2 + t3, pinned: e3.getPinned(), useHeaderRow: a3, skipScrollPadding: true, gos: n2, ctrlsSvc: o2 });
              }
              isAttemptingToPin(e3) {
                const t3 = this.needToMoveLeft || this.needToMoveRight, a3 = this.failedMoveAttempts > 7;
                return t3 && a3 || e3.some((e4) => e4.getPinned() !== this.pinned);
              }
              moveColumnsAfterHighlight(e3) {
                const { allMovingColumns: t3, xPosition: a3, fromEnter: n2, fakeEvent: o2, fromLeft: r2 } = e3, i2 = this.getMoveColumnParams({ allMovingColumns: t3, isFromHeader: true, xPosition: a3, fromLeft: r2, fromEnter: n2, fakeEvent: o2 }), { columns: l2, toIndex: d2 } = (0, s.getBestColumnMoveIndexFromXPosition)(i2) || {};
                l2 && null != d2 && (this.lastMovedInfo = { columns: l2, toIndex: d2 }), this.finishColumnMoving();
              }
              clearHighlighted() {
                const { lastHighlightedColumn: e3 } = this;
                e3 && (c(e3.column, null), this.lastHighlightedColumn = null);
              }
              checkCenterForScrolling(e3) {
                if (!this.isCenterContainer)
                  return;
                const t3 = this.beans.ctrlsSvc.get("center"), a3 = t3.getCenterViewportScrollLeft(), n2 = a3 + t3.getCenterWidth();
                let o2, r2;
                this.gos.get("enableRtl") ? (o2 = e3 < a3 + 50, r2 = e3 > n2 - 50) : (r2 = e3 < a3 + 50, o2 = e3 > n2 - 50), this.needToMoveRight = o2, this.needToMoveLeft = r2, r2 || o2 ? this.ensureIntervalStarted() : this.ensureIntervalCleared();
              }
              ensureIntervalStarted() {
                var _a;
                this.movingIntervalId || (this.intervalCount = 0, this.failedMoveAttempts = 0, this.movingIntervalId = window.setInterval(this.moveInterval.bind(this), 100), (_a = this.beans.dragAndDrop.getDragAndDropImageComponent()) == null ? void 0 : _a.setIcon(this.needToMoveLeft ? "left" : "right", true));
              }
              ensureIntervalCleared() {
                var _a;
                this.movingIntervalId && (window.clearInterval(this.movingIntervalId), this.movingIntervalId = null, this.failedMoveAttempts = 0, (_a = this.beans.dragAndDrop.getDragAndDropImageComponent()) == null ? void 0 : _a.setIcon(this.getIconName(), false));
              }
              moveInterval() {
                var _a, _b;
                let e3;
                this.intervalCount++, e3 = 10 + 5 * this.intervalCount, e3 > 100 && (e3 = 100);
                let t3 = null;
                const a3 = this.gridBodyCon.scrollFeature;
                if (this.needToMoveLeft ? t3 = a3.scrollHorizontally(-e3) : this.needToMoveRight && (t3 = a3.scrollHorizontally(e3)), 0 !== t3)
                  this.onDragging(this.lastDraggingEvent), this.failedMoveAttempts = 0;
                else {
                  this.failedMoveAttempts++;
                  const { pinnedCols: e4, dragAndDrop: t4, gos: a4 } = this.beans;
                  if (this.failedMoveAttempts <= 8 || !e4)
                    return;
                  if ((_a = t4.getDragAndDropImageComponent()) == null ? void 0 : _a.setIcon("pinned", false), !a4.get("suppressMoveWhenColumnDragging")) {
                    const e5 = (_b = this.lastDraggingEvent) == null ? void 0 : _b.dragItem.columns;
                    this.attemptToPinColumns(e5, void 0, true);
                  }
                }
              }
              getPinDirection() {
                return this.needToMoveLeft || "left" === this.pinned ? "left" : this.needToMoveRight || "right" === this.pinned ? "right" : void 0;
              }
              attemptToPinColumns(e3, t3, a3 = false) {
                const n2 = (e3 || []).filter((e4) => !e4.getColDef().lockPinned);
                if (!n2.length)
                  return 0;
                a3 && (t3 = this.getPinDirection());
                const { pinnedCols: o2, dragAndDrop: r2 } = this.beans;
                return o2 == null ? void 0 : o2.setColsPinned(n2, t3, "uiColumnDragged"), a3 && r2.nudge(), n2.length;
              }
              destroy() {
                super.destroy(), this.lastDraggingEvent = null, this.clearHighlighted(), this.lastMovedInfo = null;
              }
            }
            function c(e3, t3) {
              e3.highlighted !== t3 && (e3.highlighted = t3, e3.dispatchColEvent("headerHighlightChanged", "uiColumnMoved"));
            }
            t2.MoveColumnFeature = d;
          }, 852: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.moveColumns = t2.moveColumnByIndex = void 0, t2.moveColumnByIndex = function(e3, t3, a2) {
              var _a;
              (_a = e3.colMoves) == null ? void 0 : _a.moveColumnByIndex(t3, a2, "api");
            }, t2.moveColumns = function(e3, t3, a2) {
              var _a;
              (_a = e3.colMoves) == null ? void 0 : _a.moveColumns(t3, a2, "api");
            };
          }, 4074: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnMoveModule = void 0;
            const n = a2(4388), o = a2(7205), r = a2(9607), i = a2(9122), l = a2(852), s = a2(4067);
            t2.ColumnMoveModule = { moduleName: "ColumnMove", version: o.VERSION, beans: [s.ColumnMoveService, i.ColumnAnimationService], apiFunctions: { moveColumnByIndex: l.moveColumnByIndex, moveColumns: l.moveColumns }, dependsOn: [n.SharedDragAndDropModule], css: [r.columnMovingCSS] };
          }, 4067: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnMoveService = void 0;
            const n = a2(8731), o = a2(2903), r = a2(6908), i = a2(1502), l = a2(7764), s = a2(7912), d = a2(3505), c = a2(5446);
            var g;
            !function(e3) {
              e3[e3.LEFT = -1] = "LEFT", e3[e3.NONE = 0] = "NONE", e3[e3.RIGHT = 1] = "RIGHT";
            }(g || (g = {}));
            class u extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colMoves";
              }
              moveColumnByIndex(e3, t3, a3) {
                const n2 = this.beans.colModel.getCols();
                if (!n2)
                  return;
                const o2 = n2[e3];
                this.moveColumns([o2], t3, a3);
              }
              moveColumns(e3, t3, a3, n2 = true) {
                const { colModel: o2, colAnimation: r2, visibleCols: s2, eventSvc: d2 } = this.beans, c2 = o2.getCols();
                if (!c2)
                  return;
                if (t3 > c2.length - e3.length)
                  return void (0, l._warn)(30, { toIndex: t3 });
                r2 == null ? void 0 : r2.start();
                const g2 = o2.getColsForKeys(e3);
                this.doesMovePassRules(g2, t3) && ((0, i._moveInArray)(o2.getCols(), g2, t3), s2.refresh(a3), d2.dispatchEvent({ type: "columnMoved", columns: g2, column: 1 === g2.length ? g2[0] : null, toIndex: t3, finished: n2, source: a3 })), r2 == null ? void 0 : r2.finish();
              }
              doesMovePassRules(e3, t3) {
                const a3 = this.getProposedColumnOrder(e3, t3);
                return this.doesOrderPassRules(a3);
              }
              doesOrderPassRules(e3) {
                const { colModel: t3, gos: a3 } = this.beans;
                if (!(0, d.doesMovePassMarryChildren)(e3, t3.getColTree()))
                  return false;
                return !!((e4) => {
                  const t4 = a3.get("enableRtl");
                  let n2 = t4 ? g.RIGHT : g.LEFT, o2 = true;
                  return e4.forEach((e5) => {
                    const a4 = (r2 = e5.getColDef().lockPosition) ? "left" === r2 || true === r2 ? g.LEFT : g.RIGHT : g.NONE;
                    var r2;
                    t4 ? a4 > n2 && (o2 = false) : a4 < n2 && (o2 = false), n2 = a4;
                  }), o2;
                })(e3);
              }
              getProposedColumnOrder(e3, t3) {
                const a3 = this.beans.colModel.getCols().slice();
                return (0, i._moveInArray)(a3, e3, t3), a3;
              }
              createBodyDropTarget(e3, t3) {
                return new s.BodyDropTarget(e3, t3);
              }
              moveHeader(e3, t3, a3, n2, o2) {
                const { ctrlsSvc: l2, gos: s2, colModel: d2, visibleCols: g2, focusSvc: u2 } = this.beans, h = t3.getBoundingClientRect(), p = h.left, m = (0, r.isColumnGroup)(a3), f = m ? h.width : a3.getActualWidth(), v = "left" === e3 !== s2.get("enableRtl"), b = (0, c.normaliseX)({ x: v ? p - 20 : p + f + 20, pinned: n2, fromKeyboard: true, gos: s2, ctrlsSvc: l2 }), C = u2.focusedHeader;
                let w;
                if ((0, c.attemptMoveColumns)({ allMovingColumns: m ? a3.getLeafColumns() : [a3], isFromHeader: true, fromLeft: "right" === e3, xPosition: b, pinned: n2, fromEnter: false, fakeEvent: false, gos: s2, colModel: d2, colMoves: this, visibleCols: g2, finished: true }), m) {
                  const e4 = a3.getDisplayedLeafColumns();
                  w = v ? e4[0] : (0, i._last)(e4);
                } else
                  w = a3;
                if (l2.getScrollFeature().ensureColumnVisible(w, "auto"), (!o2.isAlive() || s2.get("ensureDomOrder")) && C) {
                  let e4;
                  if (m) {
                    const t4 = a3.getGroupId(), n3 = a3.getLeafColumns();
                    if (!n3.length)
                      return;
                    const o3 = n3[0].getParent();
                    if (!o3)
                      return;
                    e4 = function(e5, t5) {
                      for (; e5; ) {
                        if (e5.getGroupId() === t5)
                          return e5;
                        e5 = e5.getParent();
                      }
                      return;
                    }(o3, t4);
                  } else
                    e4 = a3;
                  e4 && u2.focusHeaderPosition({ headerPosition: __spreadProps(__spreadValues({}, C), { column: e4 }) });
                }
              }
              setDragSourceForHeader(e3, t3, a3) {
                const { gos: n2, colModel: l2, dragAndDrop: s2, visibleCols: d2 } = this.beans;
                let g2 = !n2.get("suppressDragLeaveHidesColumns");
                const u2 = (0, r.isColumnGroup)(t3), h = u2 ? t3.getProvidedColumnGroup().getLeafColumns() : [t3], p = u2 ? () => function(e4, t4) {
                  const a4 = e4.getProvidedColumnGroup().getLeafColumns(), n3 = {};
                  a4.forEach((e5) => n3[e5.getId()] = e5.isVisible());
                  const o2 = [];
                  t4.forEach((e5) => {
                    a4.indexOf(e5) >= 0 && (o2.push(e5), (0, i._removeFromArray)(a4, e5));
                  }), a4.forEach((e5) => o2.push(e5));
                  const r2 = [], l3 = e4.getLeafColumns();
                  for (const e5 of o2)
                    -1 !== l3.indexOf(e5) && r2.push(e5);
                  return { columns: o2, columnsInSplit: r2, visibleState: n3 };
                }(t3, d2.allCols) : () => function(e4) {
                  const t4 = {};
                  return t4[e4.getId()] = e4.isVisible(), { columns: [e4], visibleState: t4 };
                }(t3), m = { type: o.DragSourceType.HeaderCell, eElement: e3, getDefaultIconName: () => g2 ? "hide" : "notAllowed", getDragItem: p, dragItemName: a3, onDragStarted: () => {
                  g2 = !n2.get("suppressDragLeaveHidesColumns"), (0, c.setColumnsMoving)(h, true);
                }, onDragStopped: () => (0, c.setColumnsMoving)(h, false), onDragCancelled: () => (0, c.setColumnsMoving)(h, false), onGridEnter: (e4) => {
                  if (g2) {
                    const { columns: t4 = [], visibleState: a4 } = e4 != null ? e4 : {}, n3 = u2 ? (e5) => !a4 || a4[e5.getColId()] : () => true, o2 = t4.filter((e5) => !e5.getColDef().lockVisible && n3(e5));
                    l2.setColsVisible(o2, true, "uiColumnMoved");
                  }
                }, onGridExit: (e4) => {
                  var _a;
                  if (g2) {
                    const t4 = ((_a = e4 == null ? void 0 : e4.columns) == null ? void 0 : _a.filter((e5) => !e5.getColDef().lockVisible)) || [];
                    l2.setColsVisible(t4, false, "uiColumnMoved");
                  }
                } };
                return s2.addDragSource(m, true), m;
              }
            }
            t2.ColumnMoveService = u;
          }, 3505: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.doesMovePassMarryChildren = t2.placeLockedColumns = void 0;
            const n = a2(2716), o = a2(9409);
            t2.placeLockedColumns = function(e3, t3) {
              const a3 = [], n2 = [], o2 = [];
              return e3.forEach((e4) => {
                const t4 = e4.getColDef().lockPosition;
                "right" === t4 ? o2.push(e4) : "left" === t4 || true === t4 ? a3.push(e4) : n2.push(e4);
              }), t3.get("enableRtl") ? [...o2, ...n2, ...a3] : [...a3, ...n2, ...o2];
            }, t2.doesMovePassMarryChildren = function(e3, t3) {
              let a3 = true;
              return (0, n.depthFirstOriginalTreeSearch)(null, t3, (t4) => {
                if (!(0, o.isProvidedColumnGroup)(t4))
                  return;
                const n2 = t4, r = n2.getColGroupDef();
                if (!(r && r.marryChildren))
                  return;
                const i = [];
                n2.getLeafColumns().forEach((t5) => {
                  const a4 = e3.indexOf(t5);
                  i.push(a4);
                });
                Math.max.apply(Math, i) - Math.min.apply(Math, i) > n2.getLeafColumns().length - 1 && (a3 = false);
              }), a3;
            };
          }, 5446: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.setColumnsMoving = t2.normaliseX = t2.attemptMoveColumns = t2.getBestColumnMoveIndexFromXPosition = void 0;
            const n = a2(1502);
            function o(e3) {
              const { isFromHeader: t3, fromLeft: a3, xPosition: o2, fromEnter: i, fakeEvent: l, pinned: s, gos: d, colModel: c, colMoves: g, visibleCols: u } = e3;
              let { allMovingColumns: h } = e3;
              if (t3) {
                const e4 = [];
                h.forEach((t4) => {
                  var _a;
                  let a4 = null, n2 = t4.getParent();
                  for (; null != n2 && 1 === n2.getDisplayedLeafColumns().length; )
                    a4 = n2, n2 = n2.getParent();
                  if (null != a4) {
                    (!!((_a = a4.getColGroupDef()) == null ? void 0 : _a.marryChildren) ? a4.getProvidedColumnGroup().getLeafColumns() : a4.getLeafColumns()).forEach((t5) => {
                      e4.includes(t5) || e4.push(t5);
                    });
                  } else
                    e4.includes(t4) || e4.push(t4);
                }), h = e4;
              }
              const p = h.slice();
              !function(e4, t4) {
                if (!t4 || t4.length <= 1)
                  return;
                t4.filter((t5) => e4.indexOf(t5) < 0).length > 0 || t4.sort((t5, a4) => e4.indexOf(t5) - e4.indexOf(a4));
              }(c.getCols(), p);
              const m = function(e4) {
                const { movingCols: t4, draggingRight: a4, xPosition: n2, pinned: o3, gos: r2, colModel: i2, visibleCols: l2 } = e4, s2 = r2.get("suppressMovableColumns") || t4.some((e5) => e5.getColDef().suppressMovable);
                if (s2)
                  return [];
                const d2 = function(e5, t5) {
                  switch (t5) {
                    case "left":
                      return e5.leftCols;
                    case "right":
                      return e5.rightCols;
                    default:
                      return e5.centerCols;
                  }
                }(l2, o3), c2 = i2.getCols(), g2 = d2.filter((e5) => t4.includes(e5)), u2 = d2.filter((e5) => !t4.includes(e5)), h2 = c2.filter((e5) => !t4.includes(e5));
                let p2, m2 = 0, f2 = n2;
                if (a4) {
                  let e5 = 0;
                  g2.forEach((t5) => e5 += t5.getActualWidth()), f2 -= e5;
                }
                if (f2 > 0) {
                  for (let e5 = 0; e5 < u2.length; e5++) {
                    if (f2 -= u2[e5].getActualWidth(), f2 < 0)
                      break;
                    m2++;
                  }
                  a4 && m2++;
                }
                if (m2 > 0) {
                  const e5 = u2[m2 - 1];
                  p2 = h2.indexOf(e5) + 1;
                } else
                  p2 = h2.indexOf(u2[0]), -1 === p2 && (p2 = 0);
                const v2 = [p2], b2 = (e5, t5) => e5 - t5;
                if (a4) {
                  let e5 = p2 + 1;
                  const t5 = c2.length - 1;
                  for (; e5 <= t5; )
                    v2.push(e5), e5++;
                  v2.sort(b2);
                } else {
                  let e5 = p2;
                  const t5 = c2.length - 1;
                  let a5 = c2[e5];
                  for (; e5 <= t5 && d2.indexOf(a5) < 0; )
                    e5++, v2.push(e5), a5 = c2[e5];
                  e5 = p2 - 1;
                  const n3 = 0;
                  for (; e5 >= n3; )
                    v2.push(e5), e5--;
                  v2.sort(b2).reverse();
                }
                return v2;
              }({ movingCols: p, draggingRight: a3, xPosition: o2, pinned: s, gos: d, colModel: c, visibleCols: u }), f = function(e4, t4) {
                const a4 = t4.getCols(), o3 = (0, n._sortNumerically)(e4.map((e5) => a4.indexOf(e5))), r2 = o3[0], i2 = (0, n._last)(o3);
                return i2 - r2 != o3.length - 1 ? null : r2;
              }(p, c);
              if (0 === m.length)
                return;
              const v = m[0];
              let b = null !== f && !i;
              if (t3 && (b = null !== f), b && !l) {
                if (!a3 && v >= f)
                  return;
                if (a3 && v <= f)
                  return;
              }
              const C = u.allCols, w = [];
              let y = null;
              for (let e4 = 0; e4 < m.length; e4++) {
                const t4 = m[e4], a4 = g.getProposedColumnOrder(p, t4);
                if (!g.doesOrderPassRules(a4))
                  continue;
                const o3 = a4.filter((e5) => C.includes(e5));
                if (null === y)
                  y = o3;
                else if (!(0, n._areEqual)(o3, y))
                  break;
                const i2 = r(a4);
                w.push({ move: t4, fragCount: i2 });
              }
              if (0 === w.length)
                return;
              w.sort((e4, t4) => e4.fragCount - t4.fragCount);
              const S = w[0].move;
              return S > c.getCols().length - h.length ? void 0 : { columns: h, toIndex: S };
            }
            function r(e3) {
              function t3(e4) {
                const t4 = [];
                let a4 = e4.getOriginalParent();
                for (; null != a4; )
                  t4.push(a4), a4 = a4.getOriginalParent();
                return t4;
              }
              let a3 = 0;
              for (let n2 = 0; n2 < e3.length - 1; n2++) {
                let o2 = t3(e3[n2]), r2 = t3(e3[n2 + 1]);
                [o2, r2] = o2.length > r2.length ? [o2, r2] : [r2, o2], o2.forEach((e4) => {
                  -1 === r2.indexOf(e4) && a3++;
                });
              }
              return a3;
            }
            t2.getBestColumnMoveIndexFromXPosition = o, t2.attemptMoveColumns = function(e3) {
              const { columns: t3, toIndex: a3 } = o(e3) || {}, { finished: n2, colMoves: r2 } = e3;
              return t3 && null != a3 ? (r2.moveColumns(t3, a3, "uiColumnMoved", n2), n2 ? null : { columns: t3, toIndex: a3 }) : null;
            }, t2.normaliseX = function(e3) {
              var _a;
              const { pinned: t3, fromKeyboard: a3, gos: n2, ctrlsSvc: o2, useHeaderRow: r2, skipScrollPadding: i } = e3;
              let l = (_a = o2.getHeaderRowContainerCtrl(t3)) == null ? void 0 : _a.eViewport, { x: s } = e3;
              return l ? (a3 && (s -= l.getBoundingClientRect().left), n2.get("enableRtl") && (r2 && (l = l.querySelector(".ag-header-row")), s = l.clientWidth - s), null != t3 || i || (s += o2.get("center").getCenterViewportScrollLeft()), s) : 0;
            }, t2.setColumnsMoving = function(e3, t3) {
              for (const a3 of e3)
                a3.moving = t3, a3.dispatchColEvent("movingChanged", "uiColumnMoved");
            };
          }, 9686: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.setColumnWidths = void 0, t2.setColumnWidths = function(e3, t3, a2 = true, n = "api") {
              var _a;
              (_a = e3.colResize) == null ? void 0 : _a.setColumnWidths(t3, false, a2, n);
            };
          }, 6924: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnResizeModule = void 0;
            const n = a2(4388), o = a2(447), r = a2(7205), i = a2(9686), l = a2(9677);
            t2.ColumnResizeModule = { moduleName: "ColumnResize", version: r.VERSION, beans: [l.ColumnResizeService], apiFunctions: { setColumnWidths: i.setColumnWidths }, dependsOn: [n.HorizontalResizeModule, o.AutoWidthModule] };
          }, 9677: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnResizeService = void 0;
            const n = a2(2934), o = a2(8731), r = a2(7764), i = a2(9033), l = a2(7438);
            class s extends o.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colResize";
              }
              setColumnWidths(e3, t3, a3, n2) {
                const o2 = [], { colModel: r2, gos: i2, visibleCols: l2 } = this.beans;
                e3.forEach((e4) => {
                  const a4 = r2.getColDefCol(e4.key) || r2.getCol(e4.key);
                  if (!a4)
                    return;
                  o2.push({ width: e4.newWidth, ratios: [1], columns: [a4] });
                  if ("shift" === i2.get("colResizeDefault") && (t3 = !t3), t3) {
                    const t4 = l2.getColAfter(a4);
                    if (!t4)
                      return;
                    const n3 = a4.getActualWidth() - e4.newWidth, r3 = t4.getActualWidth() + n3;
                    o2.push({ width: r3, ratios: [1], columns: [t4] });
                  }
                }), 0 !== o2.length && this.resizeColumnSets({ resizeSets: o2, finished: a3, source: n2 });
              }
              resizeColumnSets(e3) {
                var _a;
                const { resizeSets: t3, finished: a3, source: o2 } = e3;
                if (!(!t3 || t3.every((e4) => function(e5) {
                  const { columns: t4, width: a4 } = e5;
                  let n2 = 0, o3 = 0, r2 = true;
                  t4.forEach((e6) => {
                    const t5 = e6.getMinWidth();
                    n2 += t5 || 0;
                    const a5 = e6.getMaxWidth();
                    a5 > 0 ? o3 += a5 : r2 = false;
                  });
                  const i3 = !r2 || a4 <= o3;
                  return a4 >= n2 && i3;
                }(e4)))) {
                  if (a3) {
                    const e4 = t3 && t3.length > 0 ? t3[0].columns : null;
                    (0, n.dispatchColumnResizedEvent)(this.eventSvc, e4, a3, o2);
                  }
                  return;
                }
                const i2 = [], l2 = [];
                t3.forEach((e4) => {
                  const { width: t4, columns: a4, ratios: n2 } = e4, s3 = {}, d2 = {};
                  a4.forEach((e5) => l2.push(e5));
                  let c2 = true, g = 0;
                  for (; c2; ) {
                    if (g++, g > 1e3) {
                      (0, r._error)(31);
                      break;
                    }
                    c2 = false;
                    const e5 = [];
                    let o3 = 0, i3 = t4;
                    a4.forEach((t5, a5) => {
                      if (d2[t5.getId()])
                        i3 -= s3[t5.getId()];
                      else {
                        e5.push(t5);
                        const r2 = n2[a5];
                        o3 += r2;
                      }
                    });
                    const l3 = 1 / o3;
                    e5.forEach((a5, o4) => {
                      let r2;
                      o4 === e5.length - 1 ? r2 = i3 : (r2 = Math.round(n2[o4] * t4 * l3), i3 -= r2);
                      const g2 = a5.getMinWidth(), u = a5.getMaxWidth();
                      r2 < g2 ? (r2 = g2, d2[a5.getId()] = true, c2 = true) : u > 0 && r2 > u && (r2 = u, d2[a5.getId()] = true, c2 = true), s3[a5.getId()] = r2;
                    });
                  }
                  a4.forEach((e5) => {
                    const t5 = s3[e5.getId()];
                    e5.getActualWidth() !== t5 && (e5.setActualWidth(t5, o2), i2.push(e5));
                  });
                });
                const s2 = i2.length > 0;
                let d = [];
                if (s2) {
                  const { colFlex: e4, visibleCols: t4, colViewport: a4 } = this.beans;
                  d = (_a = e4 == null ? void 0 : e4.refreshFlexedColumns({ resizingCols: l2, skipSetLeft: true })) != null ? _a : [], t4.setLeftValues(o2), t4.updateBodyWidths(), a4.checkViewportColumns();
                }
                const c = l2.concat(d);
                (s2 || a3) && (0, n.dispatchColumnResizedEvent)(this.eventSvc, c, a3, o2, d);
              }
              resizeHeader(e3, t3, a3) {
                if (!e3.isResizable())
                  return;
                const n2 = e3.getActualWidth(), o2 = e3.getMinWidth(), r2 = e3.getMaxWidth(), i2 = Math.min(Math.max(n2 + t3, o2), r2);
                this.setColumnWidths([{ key: e3, newWidth: i2 }], a3, true, "uiColumnResized");
              }
              createResizeFeature(e3, t3, a3, n2, o2) {
                return new l.ResizeFeature(e3, t3, a3, n2, o2);
              }
              createGroupResizeFeature(e3, t3, a3, n2) {
                return new i.GroupResizeFeature(e3, t3, a3, n2);
              }
            }
            t2.ColumnResizeService = s;
          }, 9033: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.GroupResizeFeature = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
              constructor(e3, t3, a3, n2) {
                super(), this.comp = e3, this.eResize = t3, this.pinned = a3, this.columnGroup = n2;
              }
              postConstruct() {
                if (!this.columnGroup.isResizable())
                  return void this.comp.setResizableDisplayed(false);
                const { horizontalResizeSvc: e3, gos: t3, colAutosize: a3 } = this.beans, n2 = e3.addResizeBar({ eResizeBar: this.eResize, onResizeStart: this.onResizeStart.bind(this), onResizing: this.onResizing.bind(this, false), onResizeEnd: this.onResizing.bind(this, true) });
                this.addDestroyFunc(n2), !t3.get("suppressAutoSize") && a3 && this.addDestroyFunc(a3.addColumnGroupResize(this.eResize, this.columnGroup, () => this.resizeLeafColumnsToFit("uiColumnResized")));
              }
              onResizeStart(e3) {
                const { columnsToResize: t3, resizeStartWidth: a3, resizeRatios: n2, groupAfterColumns: o2, groupAfterStartWidth: r, groupAfterRatios: i } = this.getInitialValues(e3);
                this.resizeCols = t3, this.resizeStartWidth = a3, this.resizeRatios = n2, this.resizeTakeFromCols = o2, this.resizeTakeFromStartWidth = r, this.resizeTakeFromRatios = i, this.toggleColumnResizing(true);
              }
              onResizing(e3, t3, a3 = "uiColumnResized") {
                const n2 = this.normaliseDragChange(t3), o2 = this.resizeStartWidth + n2;
                this.resizeColumnsFromLocalValues(o2, a3, e3);
              }
              getInitialValues(e3) {
                var _a, _b;
                const t3 = (e4) => e4.reduce((e5, t4) => e5 + t4.getActualWidth(), 0), a3 = (e4, t4) => e4.map((e5) => e5.getActualWidth() / t4), n2 = this.getColumnsToResize(), o2 = t3(n2), r = { columnsToResize: n2, resizeStartWidth: o2, resizeRatios: a3(n2, o2) };
                let i = null;
                if (e3 && (i = (_b = (_a = this.beans.colGroupSvc) == null ? void 0 : _a.getGroupAtDirection(this.columnGroup, "After")) != null ? _b : null), i) {
                  const e4 = i.getDisplayedLeafColumns(), n3 = r.groupAfterColumns = e4.filter((e5) => e5.isResizable()), o3 = r.groupAfterStartWidth = t3(n3);
                  r.groupAfterRatios = a3(n3, o3);
                } else
                  r.groupAfterColumns = void 0, r.groupAfterStartWidth = void 0, r.groupAfterRatios = void 0;
                return r;
              }
              resizeLeafColumnsToFit(e3) {
                const t3 = this.beans.autoWidthCalc.getPreferredWidthForColumnGroup(this.columnGroup), a3 = this.getInitialValues();
                t3 > a3.resizeStartWidth && this.resizeColumns(a3, t3, e3, true);
              }
              resizeColumnsFromLocalValues(e3, t3, a3 = true) {
                if (!this.resizeCols || !this.resizeRatios)
                  return;
                const n2 = { columnsToResize: this.resizeCols, resizeStartWidth: this.resizeStartWidth, resizeRatios: this.resizeRatios, groupAfterColumns: this.resizeTakeFromCols, groupAfterStartWidth: this.resizeTakeFromStartWidth, groupAfterRatios: this.resizeTakeFromRatios };
                this.resizeColumns(n2, e3, t3, a3);
              }
              resizeColumns(e3, t3, a3, n2 = true) {
                var _a;
                const { columnsToResize: o2, resizeStartWidth: r, resizeRatios: i, groupAfterColumns: l, groupAfterStartWidth: s, groupAfterRatios: d } = e3, c = [];
                if (c.push({ columns: o2, ratios: i, width: t3 }), l) {
                  const e4 = t3 - r;
                  c.push({ columns: l, ratios: d, width: s - e4 });
                }
                (_a = this.beans.colResize) == null ? void 0 : _a.resizeColumnSets({ resizeSets: c, finished: n2, source: a3 }), n2 && this.toggleColumnResizing(false);
              }
              toggleColumnResizing(e3) {
                this.comp.addOrRemoveCssClass("ag-column-resizing", e3);
              }
              getColumnsToResize() {
                return this.columnGroup.getDisplayedLeafColumns().filter((e3) => e3.isResizable());
              }
              normaliseDragChange(e3) {
                let t3 = e3;
                return this.gos.get("enableRtl") ? "left" !== this.pinned && (t3 *= -1) : "right" === this.pinned && (t3 *= -1), t3;
              }
              destroy() {
                super.destroy(), this.resizeCols = void 0, this.resizeRatios = void 0, this.resizeTakeFromCols = void 0, this.resizeTakeFromRatios = void 0;
              }
            }
            t2.GroupResizeFeature = o;
          }, 7438: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ResizeFeature = void 0;
            const n = a2(8731), o = a2(3507);
            class r extends n.BeanStub {
              constructor(e3, t3, a3, n2, o2) {
                super(), this.pinned = e3, this.column = t3, this.eResize = a3, this.comp = n2, this.ctrl = o2;
              }
              postConstruct() {
                const e3 = [];
                let t3, a3;
                const n2 = () => {
                  if ((0, o._setDisplayed)(this.eResize, t3), !t3)
                    return;
                  const { horizontalResizeSvc: n3, colAutosize: r3 } = this.beans, i2 = n3.addResizeBar({ eResizeBar: this.eResize, onResizeStart: this.onResizeStart.bind(this), onResizing: this.onResizing.bind(this, false), onResizeEnd: this.onResizing.bind(this, true) });
                  e3.push(i2), a3 && r3 && e3.push(r3.addColumnAutosize(this.eResize, this.column));
                }, r2 = () => {
                  e3.forEach((e4) => e4()), e3.length = 0;
                }, i = () => {
                  const e4 = this.column.isResizable(), o2 = !this.gos.get("suppressAutoSize") && !this.column.getColDef().suppressAutoSize;
                  (e4 !== t3 || o2 !== a3) && (t3 = e4, a3 = o2, r2(), n2());
                };
                i(), this.addDestroyFunc(r2), this.ctrl.setRefreshFunction("resize", i);
              }
              onResizing(e3, t3) {
                var _a, _b;
                const { column: a3, lastResizeAmount: n2, resizeStartWidth: r2, beans: i } = this, l = this.normaliseResizeAmount(t3), s = [{ key: a3, newWidth: r2 + l }], { pinnedCols: d, ctrlsSvc: c, colResize: g } = i;
                if (this.column.getPinned()) {
                  if (((_a = d == null ? void 0 : d.leftWidth) != null ? _a : 0) + ((_b = d == null ? void 0 : d.rightWidth) != null ? _b : 0) + (l - n2) > (0, o._getInnerWidth)(c.getGridBodyCtrl().eBodyViewport) - 50)
                    return;
                }
                this.lastResizeAmount = l, g == null ? void 0 : g.setColumnWidths(s, this.resizeWithShiftKey, e3, "uiColumnResized"), e3 && this.toggleColumnResizing(false);
              }
              onResizeStart(e3) {
                this.resizeStartWidth = this.column.getActualWidth(), this.lastResizeAmount = 0, this.resizeWithShiftKey = e3, this.toggleColumnResizing(true);
              }
              toggleColumnResizing(e3) {
                this.comp.addOrRemoveCssClass("ag-column-resizing", e3);
              }
              normaliseResizeAmount(e3) {
                let t3 = e3;
                const a3 = "left" !== this.pinned, n2 = "right" === this.pinned;
                return this.gos.get("enableRtl") ? a3 && (t3 *= -1) : n2 && (t3 *= -1), t3;
              }
            }
            t2.ResizeFeature = r;
          }, 3600: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.BaseColsService = void 0;
            const n = a2(8731), o = a2(1502), r = a2(4422), i = a2(2934);
            class l extends n.BeanStub {
              constructor() {
                super(...arguments), this.dispatchColumnChangedEvent = i.dispatchColumnChangedEvent, this.columns = [];
              }
              wireBeans(e3) {
                this.colModel = e3.colModel, this.aggFuncSvc = e3.aggFuncSvc, this.visibleCols = e3.visibleCols;
              }
              sortColumns(e3) {
                this.columns.sort(e3);
              }
              setColumns(e3, t3) {
                this.setColList(e3, this.columns, this.eventName, true, true, this.columnProcessors.set, t3);
              }
              addColumns(e3, t3) {
                this.updateColList(e3, this.columns, true, true, this.columnProcessors.add, this.eventName, t3);
              }
              removeColumns(e3, t3) {
                this.updateColList(e3, this.columns, false, true, this.columnProcessors.remove, this.eventName, t3);
              }
              setColList(e3 = [], t3, a3, n2, o2, i2, l2) {
                const s = this.colModel.getCols();
                if (!s || 0 === s.length)
                  return;
                const d = /* @__PURE__ */ new Map();
                t3.forEach((e4, t4) => d.set(e4, t4)), t3.length = 0, (0, r._exists)(e3) && e3.forEach((e4) => {
                  const a4 = this.colModel.getColDefCol(e4);
                  a4 && t3.push(a4);
                }), t3.forEach((e4, t4) => {
                  const a4 = d.get(e4);
                  void 0 !== a4 ? n2 && a4 !== t4 || d.delete(e4) : d.set(e4, 0);
                });
                (this.colModel.getColDefCols() || []).forEach((e4) => {
                  const a4 = t3.indexOf(e4) >= 0;
                  i2(e4, a4, l2);
                }), o2 && this.colModel.refreshCols(false), this.visibleCols.refresh(l2), this.dispatchColumnChangedEvent(this.eventSvc, a3, [...d.keys()], l2);
              }
              updateColList(e3 = [], t3, a3, n2, r2, i2, l2) {
                if (!e3 || 0 === e3.length)
                  return;
                let s = false;
                const d = /* @__PURE__ */ new Set();
                if (e3.forEach((e4) => {
                  if (!e4)
                    return;
                  const n3 = this.colModel.getColDefCol(e4);
                  if (n3) {
                    if (d.add(n3), a3) {
                      if (t3.indexOf(n3) >= 0)
                        return;
                      t3.push(n3);
                    } else {
                      const e5 = t3.indexOf(n3);
                      if (e5 < 0)
                        return;
                      for (let a4 = e5 + 1; a4 < t3.length; a4++)
                        d.add(t3[a4]);
                      (0, o._removeFromArray)(t3, n3);
                    }
                    r2(n3, a3, l2), s = true;
                  }
                }), !s)
                  return;
                n2 && this.colModel.refreshCols(false), this.visibleCols.refresh(l2);
                const c = Array.from(d);
                this.eventSvc.dispatchEvent({ type: i2, columns: c, column: 1 === c.length ? c[0] : null, source: l2 });
              }
              extractCols(e3, t3 = []) {
                const a3 = this.columns, n2 = [], o2 = [], { setFlagFunc: r2, getIndexFunc: i2, getInitialIndexFunc: l2, getValueFunc: s, getInitialValueFunc: d } = this.columnExtractors;
                (this.colModel.getColDefCols() || []).forEach((e4) => {
                  const r3 = t3.indexOf(e4) < 0, c2 = e4.getColDef(), g2 = s(c2), u = d(c2), h = i2(c2), p = l2(c2);
                  let m;
                  if (m = void 0 !== g2 ? g2 : void 0 !== h ? null !== h && h >= 0 : r3 ? void 0 !== u ? u : !!(void 0 !== p) && (null != p && p >= 0) : a3.indexOf(e4) >= 0, m) {
                    (r3 ? null != h || null != p : null != h) ? n2.push(e4) : o2.push(e4);
                  }
                });
                const c = (e4) => {
                  const t4 = i2(e4.getColDef()), a4 = l2(e4.getColDef());
                  return null != t4 ? t4 : a4;
                };
                n2.sort((e4, t4) => {
                  const a4 = c(e4), n3 = c(t4);
                  return a4 === n3 ? 0 : a4 < n3 ? -1 : 1;
                });
                const g = [].concat(n2);
                return a3.forEach((e4) => {
                  o2.indexOf(e4) >= 0 && g.push(e4);
                }), o2.forEach((e4) => {
                  g.indexOf(e4) < 0 && g.push(e4);
                }), a3.forEach((t4) => {
                  g.indexOf(t4) < 0 && r2(t4, false, e3);
                }), g.forEach((t4) => {
                  a3.indexOf(t4) < 0 && r2(t4, true, e3);
                }), this.columns = g;
              }
              restoreColumnOrder(e3, t3) {
                const a3 = this.columns, n2 = this.colModel.getColDefCols();
                if (!a3.length || !n2)
                  return e3;
                const o2 = Object.keys(t3), r2 = new Set(o2), i2 = new Set(o2), l2 = new Set(a3.map((e4) => {
                  const t4 = e4.getColId();
                  return i2.delete(t4), t4;
                }).concat(o2)), s = [], d = {};
                let c = 0;
                for (let e4 = 0; e4 < n2.length; e4++) {
                  const t4 = n2[e4].getColId();
                  l2.has(t4) && (s.push(t4), d[t4] = c++);
                }
                let g = 1e3, u = false, h = 0;
                const p = this.columnOrdering.enableProp, m = this.columnOrdering.initialEnableProp, f = this.columnOrdering.indexProp, v = this.columnOrdering.initialIndexProp, b = (e4) => {
                  const a4 = d[e4];
                  for (let e5 = h; e5 < a4; e5++) {
                    const a5 = s[e5];
                    i2.has(a5) && (t3[a5][f] = g++, i2.delete(a5));
                  }
                  h = a4;
                };
                return a3.forEach((a4) => {
                  const n3 = a4.getColId();
                  if (r2.has(n3))
                    b(n3), t3[n3][f] = g++;
                  else {
                    const o3 = a4.getColDef();
                    if (null === o3[f] || void 0 === o3[f] && null == o3[v]) {
                      if (!u) {
                        o3[p] || void 0 === o3[p] && o3[m] ? b(n3) : (i2.forEach((e4) => {
                          t3[e4][f] = g + d[e4];
                        }), g += s.length, u = true);
                      }
                      e3[n3] || (e3[n3] = { colId: n3 }), e3[n3][f] = g++;
                    }
                  }
                }), e3;
              }
            }
            t2.BaseColsService = l;
          }, 1144: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.getAllDisplayedVirtualColumns = t2.getAllDisplayedColumns = t2.getDisplayedRightColumns = t2.getDisplayedCenterColumns = t2.getDisplayedLeftColumns = t2.getAllGridColumns = t2.setColumnsPinned = t2.setColumnsVisible = t2.getDisplayedColBefore = t2.getDisplayedColAfter = t2.isPinningRight = t2.isPinningLeft = t2.isPinning = t2.resetColumnState = t2.getColumnState = t2.applyColumnState = t2.getColumns = t2.getColumn = t2.getDisplayNameForColumn = t2.getColumnDefs = t2.getColumnDef = void 0;
            const n = a2(5266);
            t2.getColumnDef = function(e3, t3) {
              const a3 = e3.colModel.getColDefCol(t3);
              return a3 ? a3.getColDef() : null;
            }, t2.getColumnDefs = function(e3) {
              return e3.colModel.getColumnDefs();
            }, t2.getDisplayNameForColumn = function(e3, t3, a3) {
              return e3.colNames.getDisplayNameForColumn(t3, a3) || "";
            }, t2.getColumn = function(e3, t3) {
              return e3.colModel.getColDefCol(t3);
            }, t2.getColumns = function(e3) {
              return e3.colModel.getColDefCols();
            }, t2.applyColumnState = function(e3, t3) {
              return (0, n._applyColumnState)(e3, t3, "api");
            }, t2.getColumnState = function(e3) {
              return (0, n._getColumnState)(e3);
            }, t2.resetColumnState = function(e3) {
              (0, n._resetColumnState)(e3, "api");
            }, t2.isPinning = function(e3) {
              return e3.visibleCols.isPinningLeft() || e3.visibleCols.isPinningRight();
            }, t2.isPinningLeft = function(e3) {
              return e3.visibleCols.isPinningLeft();
            }, t2.isPinningRight = function(e3) {
              return e3.visibleCols.isPinningRight();
            }, t2.getDisplayedColAfter = function(e3, t3) {
              return e3.visibleCols.getColAfter(t3);
            }, t2.getDisplayedColBefore = function(e3, t3) {
              return e3.visibleCols.getColBefore(t3);
            }, t2.setColumnsVisible = function(e3, t3, a3) {
              e3.colModel.setColsVisible(t3, a3, "api");
            }, t2.setColumnsPinned = function(e3, t3, a3) {
              var _a;
              (_a = e3.pinnedCols) == null ? void 0 : _a.setColsPinned(t3, a3, "api");
            }, t2.getAllGridColumns = function(e3) {
              return e3.colModel.getCols();
            }, t2.getDisplayedLeftColumns = function(e3) {
              return e3.visibleCols.leftCols;
            }, t2.getDisplayedCenterColumns = function(e3) {
              return e3.visibleCols.centerCols;
            }, t2.getDisplayedRightColumns = function(e3) {
              return e3.visibleCols.rightCols;
            }, t2.getAllDisplayedColumns = function(e3) {
              return e3.visibleCols.allCols;
            }, t2.getAllDisplayedVirtualColumns = function(e3) {
              return e3.colViewport.getViewportColumns();
            };
          }, 4604: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnDefFactory = t2._deepCloneDefinition = void 0;
            const n = a2(8731), o = a2(6996);
            function r(e3, t3) {
              if (!e3)
                return;
              const a3 = e3, n2 = {};
              return Object.keys(a3).forEach((e4) => {
                if (t3 && t3.indexOf(e4) >= 0 || o.SKIP_JS_BUILTINS.has(e4))
                  return;
                const i2 = a3[e4], l = "object" == typeof i2 && null !== i2 && i2.constructor === Object;
                n2[e4] = l ? r(i2) : i2;
              }), n2;
            }
            t2._deepCloneDefinition = r;
            class i extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colDefFactory";
              }
              wireBeans(e3) {
                this.rowGroupColsSvc = e3.rowGroupColsSvc, this.pivotColsSvc = e3.pivotColsSvc;
              }
              getColumnDefs(e3, t3, a3, n2) {
                var _a, _b;
                const o2 = e3.slice();
                t3 ? o2.sort((e4, t4) => a3.indexOf(e4) - a3.indexOf(t4)) : a3 && o2.sort((e4, t4) => n2.indexOf(e4) - n2.indexOf(t4));
                const r2 = (_a = this.rowGroupColsSvc) == null ? void 0 : _a.columns, i2 = (_b = this.pivotColsSvc) == null ? void 0 : _b.columns;
                return this.buildColumnDefs(o2, r2, i2);
              }
              buildColumnDefs(e3, t3 = [], a3 = []) {
                const n2 = [], o2 = {};
                return e3.forEach((e4) => {
                  let r2 = true, i2 = this.createDefFromColumn(e4, t3, a3), l = e4.getOriginalParent(), s = null;
                  for (; l; ) {
                    let e5 = null;
                    if (l.isPadding()) {
                      l = l.getOriginalParent();
                      continue;
                    }
                    const t4 = o2[l.getGroupId()];
                    if (t4) {
                      t4.children.push(i2), r2 = false;
                      break;
                    }
                    if (e5 = this.createDefFromGroup(l), e5 && (e5.children = [i2], o2[e5.groupId] = e5, i2 = e5, l = l.getOriginalParent()), null != l && s === l) {
                      r2 = false;
                      break;
                    }
                    s = l;
                  }
                  r2 && n2.push(i2);
                }), n2;
              }
              createDefFromGroup(e3) {
                const t3 = r(e3.getColGroupDef(), ["children"]);
                return t3 && (t3.groupId = e3.getGroupId()), t3;
              }
              createDefFromColumn(e3, t3, a3) {
                const n2 = r(e3.getColDef());
                return n2.colId = e3.getColId(), n2.width = e3.getActualWidth(), n2.rowGroup = e3.isRowGroupActive(), n2.rowGroupIndex = e3.isRowGroupActive() ? t3.indexOf(e3) : null, n2.pivot = e3.isPivotActive(), n2.pivotIndex = e3.isPivotActive() ? a3.indexOf(e3) : null, n2.aggFunc = e3.isValueActive() ? e3.getAggFunc() : null, n2.hide = !e3.isVisible() || void 0, n2.pinned = e3.isPinned() ? e3.getPinned() : null, n2.sort = e3.getSort() ? e3.getSort() : null, n2.sortIndex = null != e3.getSortIndex() ? e3.getSortIndex() : null, n2;
              }
            }
            t2.ColumnDefFactory = i;
          }, 2934: function(e2, t2) {
            function a2(e3, t3) {
              if (!e3 || 0 == e3.length)
                return;
              const a3 = t3(e3[0]);
              for (let n = 1; n < e3.length; n++)
                if (a3 !== t3(e3[n]))
                  return;
              return a3;
            }
            Object.defineProperty(t2, "__esModule", { value: true }), t2.dispatchColumnResizedEvent = t2.dispatchColumnChangedEvent = t2.dispatchColumnVisibleEvent = t2.dispatchColumnPinnedEvent = void 0, t2.dispatchColumnPinnedEvent = function(e3, t3, n) {
              if (!t3.length)
                return;
              const o = 1 === t3.length ? t3[0] : null, r = a2(t3, (e4) => e4.getPinned());
              e3.dispatchEvent({ type: "columnPinned", pinned: null != r ? r : null, columns: t3, column: o, source: n });
            }, t2.dispatchColumnVisibleEvent = function(e3, t3, n) {
              if (!t3.length)
                return;
              const o = 1 === t3.length ? t3[0] : null, r = a2(t3, (e4) => e4.isVisible());
              e3.dispatchEvent({ type: "columnVisible", visible: r, columns: t3, column: o, source: n });
            }, t2.dispatchColumnChangedEvent = function(e3, t3, a3, n) {
              e3.dispatchEvent({ type: t3, columns: a3, column: a3 && 1 == a3.length ? a3[0] : null, source: n });
            }, t2.dispatchColumnResizedEvent = function(e3, t3, a3, n, o = null) {
              (t3 == null ? void 0 : t3.length) && e3.dispatchEvent({ type: "columnResized", columns: t3, column: 1 === t3.length ? t3[0] : null, flexColumns: o, finished: a3, source: n });
            };
          }, 2716: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.depthFirstOriginalTreeSearch = t2._addColumnDefaultAndTypes = t2._updateColumnState = t2.updateSomeColumnState = t2._recursivelyCreateColumns = t2._createColumnTree = void 0;
            const n = a2(3355), o = a2(9409), r = a2(5449), i = a2(7274), l = a2(6996), s = a2(7764), d = a2(2294), c = a2(3146);
            function g(e3, t3, a3, n2, o2, r2, i2, l2) {
              if (!t3)
                return [];
              const { colGroupSvc: s2 } = e3, d2 = new Array(t3.length);
              for (let c2 = 0; c2 < d2.length; c2++) {
                const g2 = t3[c2];
                s2 && void 0 !== g2.children ? d2[c2] = s2.createProvidedColumnGroup(n2, g2, a3, o2, r2, i2, l2) : d2[c2] = u(e3, n2, g2, o2, r2, l2);
              }
              return d2;
            }
            function u(e3, t3, a3, o2, r2, i2) {
              var _a;
              const l2 = function(e4, t4) {
                if (!t4)
                  return;
                for (let a4 = 0; a4 < t4.length; a4++) {
                  const n2 = t4[a4].getUserProvidedColDef();
                  if (!n2)
                    continue;
                  if (null != e4.colId) {
                    if (t4[a4].getId() === e4.colId)
                      return { idx: a4, column: t4[a4] };
                    continue;
                  }
                  if (null != e4.field) {
                    if (n2.field === e4.field)
                      return { idx: a4, column: t4[a4] };
                  } else if (n2 === e4)
                    return { idx: a4, column: t4[a4] };
                }
                return;
              }(a3, o2);
              l2 && (o2 == null ? void 0 : o2.splice(l2.idx, 1));
              let s2 = l2 == null ? void 0 : l2.column;
              if (s2) {
                const t4 = m(e3, a3, s2.getColId());
                s2.setColDef(t4, a3, i2), p(e3, s2, t4, i2);
              } else {
                const o3 = r2.getUniqueKey(a3.colId, a3.field), i3 = m(e3, a3, o3);
                s2 = new n.AgColumn(i3, a3, o3, t3), e3.context.createBean(s2);
              }
              return (_a = e3.dataTypeSvc) == null ? void 0 : _a.addColumnListeners(s2), s2;
            }
            function h(e3, t3, a3, n2, o2, r2, i2, l2) {
              const { sortSvc: s2, pinnedCols: d2, colFlex: c2 } = e3;
              void 0 !== a3 && t3.setVisible(!a3, l2), s2 && (s2.updateColSort(t3, n2, l2), void 0 !== o2 && s2.setColSortIndex(t3, o2)), void 0 !== r2 && (d2 == null ? void 0 : d2.setColPinned(t3, r2)), void 0 !== i2 && (c2 == null ? void 0 : c2.setColFlex(t3, i2));
            }
            function p(e3, t3, a3, n2) {
              h(e3, t3, a3.hide, a3.sort, a3.sortIndex, a3.pinned, a3.flex, n2);
              const o2 = t3.getFlex();
              if (!(null != o2 && o2 > 0))
                if (null != a3.width)
                  t3.setActualWidth(a3.width, n2);
                else {
                  const e4 = t3.getActualWidth();
                  t3.setActualWidth(e4, n2);
                }
            }
            function m(e3, t3, a3, n2) {
              const { gos: o2, dataTypeSvc: d2, validation: g2 } = e3, u2 = {}, h2 = o2.get("defaultColDef");
              (0, l._mergeDeep)(u2, h2, false, true);
              const p2 = function(e4, t4, a4, n3) {
                var _a, _b, _c;
                const o3 = (_a = e4.dataTypeSvc) == null ? void 0 : _a.updateColDefAndGetColumnType(t4, a4, n3), r2 = (_c = (_b = a4.type) != null ? _b : o3) != null ? _c : t4.type;
                return t4.type = r2, r2 ? (0, c.convertColumnTypes)(r2) : void 0;
              }(e3, u2, t3, a3);
              p2 && function(e4, t4, a4) {
                if (!t4.length)
                  return;
                const n3 = Object.assign({}, r.DefaultColumnTypes), o3 = e4.gos.get("columnTypes") || {};
                for (const [e5, t5] of Object.entries(o3))
                  if (e5 in n3)
                    (0, s._warn)(34, { key: e5 });
                  else {
                    t5.type && (0, s._warn)(35), n3[e5] = t5;
                  }
                t4.forEach((e5) => {
                  const t5 = n3[e5.trim()];
                  t5 ? (0, l._mergeDeep)(a4, t5, false, true) : (0, s._warn)(36, { t: e5 });
                });
              }(e3, p2, u2), (0, l._mergeDeep)(u2, t3, false, true);
              const m2 = o2.get("autoGroupColumnDef"), f2 = (0, i._isColumnsSortingCoupledToGroup)(o2);
              return t3.rowGroup && m2 && f2 && (0, l._mergeDeep)(u2, { sort: m2.sort, initialSort: m2.initialSort }, false, true), d2 == null ? void 0 : d2.validateColDef(u2), g2 == null ? void 0 : g2.validateColDef(u2, a3, n2), u2;
            }
            function f(e3, t3, a3) {
              if (t3)
                for (let n2 = 0; n2 < t3.length; n2++) {
                  const r2 = t3[n2];
                  (0, o.isProvidedColumnGroup)(r2) && f(r2, r2.getChildren(), a3), a3(r2, e3);
                }
            }
            t2._createColumnTree = function(e3, t3 = null, a3, n2, r2) {
              var _a;
              const i2 = new d.ColumnKeyCreator(), { existingCols: l2, existingGroups: s2, existingColKeys: c2 } = function(e4) {
                const t4 = [], a4 = [], n3 = [];
                e4 && f(null, e4, (e5) => {
                  if ((0, o.isProvidedColumnGroup)(e5)) {
                    const t5 = e5;
                    a4.push(t5);
                  } else {
                    const a5 = e5;
                    n3.push(a5.getId()), t4.push(a5);
                  }
                });
                return { existingCols: t4, existingGroups: a4, existingColKeys: n3 };
              }(n2);
              i2.addExistingKeys(c2);
              const u2 = g(e3, t3, 0, a3, l2, i2, s2, r2), { colGroupSvc: h2 } = e3, p2 = (_a = h2 == null ? void 0 : h2.findMaxDepth(u2, 0)) != null ? _a : 0, m2 = h2 ? h2.balanceColumnTree(u2, 0, p2, i2) : u2;
              return f(null, m2, (e4, t4) => {
                (0, o.isProvidedColumnGroup)(e4) && e4.setupExpandable(), e4.originalParent = t4;
              }), { columnTree: m2, treeDept: p2 };
            }, t2._recursivelyCreateColumns = g, t2.updateSomeColumnState = h, t2._updateColumnState = p, t2._addColumnDefaultAndTypes = m, t2.depthFirstOriginalTreeSearch = f;
          }, 2849: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnFlexService = void 0;
            const n = a2(8731), o = a2(2934);
            class r extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colFlex";
              }
              refreshFlexedColumns(e3 = {}) {
                const t3 = e3.source ? e3.source : "flex";
                null != e3.viewportWidth && (this.flexViewportWidth = e3.viewportWidth);
                const a3 = this.flexViewportWidth;
                if (!a3)
                  return [];
                const { visibleCols: n2 } = this.beans, r2 = n2.centerCols;
                let i = -1;
                if (e3.resizingCols) {
                  const t4 = new Set(e3.resizingCols);
                  for (let e4 = r2.length - 1; e4 >= 0; e4--)
                    if (t4.has(r2[e4])) {
                      i = e4;
                      break;
                    }
                }
                let l = false;
                const s = r2.map((e4, t4) => {
                  const a4 = e4.getFlex(), n3 = null != a4 && a4 > 0 && t4 > i;
                  return l || (l = n3), { col: e4, isFlex: n3, flex: Math.max(0, a4 != null ? a4 : 0), initialSize: e4.getActualWidth(), min: e4.getMinWidth(), max: e4.getMaxWidth(), targetSize: 0 };
                });
                if (!l)
                  return [];
                let d = s.length, c = s.reduce((e4, t4) => e4 + t4.flex, 0), g = a3;
                const u = (e4, a4) => {
                  e4.frozenSize = a4, e4.col.setActualWidth(a4, t3), g -= a4, c -= e4.flex, d -= 1;
                }, h = (e4) => null != e4.frozenSize;
                for (const e4 of s)
                  e4.isFlex || u(e4, e4.initialSize);
                for (; d > 0; ) {
                  const e4 = Math.round(c < 1 ? g * c : g);
                  let t4, a4 = 0, n3 = 0;
                  for (const o3 of s) {
                    if (h(o3))
                      continue;
                    t4 = o3, n3 += e4 * (o3.flex / c);
                    const r4 = n3 - a4, i2 = Math.round(r4);
                    o3.targetSize = i2, a4 += i2;
                  }
                  t4 && (t4.targetSize += e4 - a4);
                  let o2 = 0;
                  for (const e5 of s) {
                    if (h(e5))
                      continue;
                    const t5 = e5.targetSize, a5 = Math.min(Math.max(t5, e5.min), e5.max);
                    o2 += a5 - t5, e5.violationType = a5 === t5 ? void 0 : a5 < t5 ? "max" : "min", e5.targetSize = a5;
                  }
                  const r3 = 0 === o2 ? "all" : o2 > 0 ? "min" : "max";
                  for (const e5 of s)
                    h(e5) || "all" !== r3 && e5.violationType !== r3 || u(e5, e5.targetSize);
                }
                e3.skipSetLeft || n2.setLeftValues(t3), e3.updateBodyWidths && n2.updateBodyWidths();
                const p = s.filter((e4) => e4.isFlex && !e4.violationType).map((e4) => e4.col);
                if (e3.fireResizedEvent) {
                  const e4 = s.filter((e5) => e5.initialSize !== e5.frozenSize).map((e5) => e5.col), a4 = s.filter((e5) => e5.flex).map((e5) => e5.col);
                  (0, o.dispatchColumnResizedEvent)(this.eventSvc, e4, true, t3, a4);
                }
                return p;
              }
              initCol(e3) {
                const { flex: t3, initialFlex: a3 } = e3.colDef;
                void 0 !== t3 ? e3.flex = t3 : void 0 !== a3 && (e3.flex = a3);
              }
              setColFlex(e3, t3) {
                e3.flex = t3 != null ? t3 : null, e3.dispatchStateUpdatedEvent("flex");
              }
            }
            t2.ColumnFlexService = r;
          }, 6641: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.getAllDisplayedColumnGroups = t2.getRightDisplayedColumnGroups = t2.getCenterDisplayedColumnGroups = t2.getLeftDisplayedColumnGroups = t2.resetColumnGroupState = t2.setColumnGroupState = t2.getColumnGroupState = t2.getDisplayNameForColumnGroup = t2.getProvidedColumnGroup = t2.getColumnGroup = t2.setColumnGroupOpened = void 0, t2.setColumnGroupOpened = function(e3, t3, a2) {
              var _a;
              (_a = e3.colGroupSvc) == null ? void 0 : _a.setColumnGroupOpened(t3, a2, "api");
            }, t2.getColumnGroup = function(e3, t3, a2) {
              var _a, _b;
              return (_b = (_a = e3.colGroupSvc) == null ? void 0 : _a.getColumnGroup(t3, a2)) != null ? _b : null;
            }, t2.getProvidedColumnGroup = function(e3, t3) {
              var _a, _b;
              return (_b = (_a = e3.colGroupSvc) == null ? void 0 : _a.getProvidedColGroup(t3)) != null ? _b : null;
            }, t2.getDisplayNameForColumnGroup = function(e3, t3, a2) {
              return e3.colNames.getDisplayNameForColumnGroup(t3, a2) || "";
            }, t2.getColumnGroupState = function(e3) {
              var _a, _b;
              return (_b = (_a = e3.colGroupSvc) == null ? void 0 : _a.getColumnGroupState()) != null ? _b : [];
            }, t2.setColumnGroupState = function(e3, t3) {
              var _a;
              (_a = e3.colGroupSvc) == null ? void 0 : _a.setColumnGroupState(t3, "api");
            }, t2.resetColumnGroupState = function(e3) {
              var _a;
              (_a = e3.colGroupSvc) == null ? void 0 : _a.resetColumnGroupState("api");
            }, t2.getLeftDisplayedColumnGroups = function(e3) {
              return e3.visibleCols.treeLeft;
            }, t2.getCenterDisplayedColumnGroups = function(e3) {
              return e3.visibleCols.treeCenter;
            }, t2.getRightDisplayedColumnGroups = function(e3) {
              return e3.visibleCols.treeRight;
            }, t2.getAllDisplayedColumnGroups = function(e3) {
              return e3.visibleCols.getAllTrees();
            };
          }, 6041: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnGroupModule = void 0;
            const n = a2(84), o = a2(7205), r = a2(6641), i = a2(6266);
            t2.ColumnGroupModule = { moduleName: "ColumnGroup", version: o.VERSION, dynamicBeans: { headerGroupCellCtrl: n.HeaderGroupCellCtrl }, beans: [i.ColumnGroupService], apiFunctions: { getAllDisplayedColumnGroups: r.getAllDisplayedColumnGroups, getCenterDisplayedColumnGroups: r.getCenterDisplayedColumnGroups, getColumnGroup: r.getColumnGroup, getColumnGroupState: r.getColumnGroupState, getDisplayNameForColumnGroup: r.getDisplayNameForColumnGroup, getLeftDisplayedColumnGroups: r.getLeftDisplayedColumnGroups, getProvidedColumnGroup: r.getProvidedColumnGroup, getRightDisplayedColumnGroups: r.getRightDisplayedColumnGroups, resetColumnGroupState: r.resetColumnGroupState, setColumnGroupOpened: r.setColumnGroupOpened, setColumnGroupState: r.setColumnGroupState } };
          }, 6266: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnGroupService = void 0;
            const n = a2(8731), o = a2(6908), r = a2(6908), i = a2(9409), l = a2(9409), s = a2(1502), d = a2(4422), c = a2(2716), g = a2(6869);
            class u extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colGroupSvc";
              }
              getColumnGroupState() {
                const e3 = [], t3 = this.beans.colModel.getColTree();
                return (0, c.depthFirstOriginalTreeSearch)(null, t3, (t4) => {
                  (0, l.isProvidedColumnGroup)(t4) && e3.push({ groupId: t4.getGroupId(), open: t4.isExpanded() });
                }), e3;
              }
              resetColumnGroupState(e3) {
                const t3 = this.beans.colModel.getColDefColTree();
                if (!t3)
                  return;
                const a3 = [];
                (0, c.depthFirstOriginalTreeSearch)(null, t3, (e4) => {
                  if ((0, l.isProvidedColumnGroup)(e4)) {
                    const t4 = e4.getColGroupDef(), n2 = { groupId: e4.getGroupId(), open: t4 ? t4.openByDefault : void 0 };
                    a3.push(n2);
                  }
                }), this.setColumnGroupState(a3, e3);
              }
              setColumnGroupState(e3, t3) {
                const { colModel: a3, colAnimation: n2, visibleCols: o2, eventSvc: r2 } = this.beans;
                if (!a3.getColTree())
                  return;
                n2 == null ? void 0 : n2.start();
                const i2 = [];
                e3.forEach((e4) => {
                  const t4 = e4.groupId, a4 = e4.open, n3 = this.getProvidedColGroup(t4);
                  n3 && n3.isExpanded() !== a4 && (n3.setExpanded(a4), i2.push(n3));
                }), o2.refresh(t3, true), i2.length && r2.dispatchEvent({ type: "columnGroupOpened", columnGroup: 1 === i2.length ? i2[0] : void 0, columnGroups: i2 }), n2 == null ? void 0 : n2.finish();
              }
              setColumnGroupOpened(e3, t3, a3) {
                let n2;
                n2 = (0, l.isProvidedColumnGroup)(e3) ? e3.getId() : e3 || "", this.setColumnGroupState([{ groupId: n2, open: t3 }], a3);
              }
              getProvidedColGroup(e3) {
                let t3 = null;
                return (0, c.depthFirstOriginalTreeSearch)(null, this.beans.colModel.getColTree(), (a3) => {
                  (0, l.isProvidedColumnGroup)(a3) && a3.getId() === e3 && (t3 = a3);
                }), t3;
              }
              getGroupAtDirection(e3, t3) {
                const a3 = e3.getProvidedColumnGroup().getLevel() + e3.getPaddingLevel(), n2 = e3.getDisplayedLeafColumns(), o2 = "After" === t3 ? (0, s._last)(n2) : n2[0], r2 = `getCol${t3}`;
                for (; ; ) {
                  const t4 = this.beans.visibleCols[r2](o2);
                  if (!t4)
                    return null;
                  const n3 = this.getColGroupAtLevel(t4, a3);
                  if (n3 !== e3)
                    return n3;
                }
              }
              getColGroupAtLevel(e3, t3) {
                let a3, n2, o2 = e3.getParent();
                for (; ; ) {
                  if (a3 = o2.getProvidedColumnGroup().getLevel(), n2 = o2.getPaddingLevel(), a3 + n2 <= t3)
                    break;
                  o2 = o2.getParent();
                }
                return o2;
              }
              updateOpenClosedVisibility() {
                const e3 = this.beans.visibleCols.getAllTrees();
                (0, g.depthFirstAllColumnTreeSearch)(e3, false, (e4) => {
                  (0, o.isColumnGroup)(e4) && e4.calculateDisplayedColumns();
                });
              }
              getColumnGroup(e3, t3) {
                if (!e3)
                  return null;
                if ((0, o.isColumnGroup)(e3))
                  return e3;
                const a3 = this.beans.visibleCols.getAllTrees(), n2 = "number" == typeof t3;
                let r2 = null;
                return (0, g.depthFirstAllColumnTreeSearch)(a3, false, (a4) => {
                  if ((0, o.isColumnGroup)(a4)) {
                    const o2 = a4;
                    let i2;
                    i2 = n2 ? e3 === o2.getGroupId() && t3 === o2.getPartId() : e3 === o2.getGroupId(), i2 && (r2 = o2);
                  }
                }), r2;
              }
              createColumnGroups(e3) {
                const { columns: t3, idCreator: a3, pinned: n2, oldDisplayedGroups: r2, isStandaloneStructure: i2 } = e3, l2 = this.mapOldGroupsById(r2), s2 = [];
                let d2 = t3;
                for (; d2.length; ) {
                  const e4 = d2;
                  d2 = [];
                  let t4 = 0;
                  const r3 = (r4) => {
                    const c2 = t4;
                    t4 = r4;
                    const g2 = e4[c2], u2 = ((0, o.isColumnGroup)(g2) ? g2.getProvidedColumnGroup() : g2).getOriginalParent();
                    if (null == u2) {
                      for (let t5 = c2; t5 < r4; t5++)
                        s2.push(e4[t5]);
                      return;
                    }
                    const h = this.createColumnGroup(u2, a3, l2, n2, i2);
                    for (let t5 = c2; t5 < r4; t5++)
                      h.addChild(e4[t5]);
                    d2.push(h);
                  };
                  for (let a4 = 1; a4 < e4.length; a4++) {
                    const n3 = e4[a4], i3 = ((0, o.isColumnGroup)(n3) ? n3.getProvidedColumnGroup() : n3).getOriginalParent(), l3 = e4[t4];
                    i3 !== ((0, o.isColumnGroup)(l3) ? l3.getProvidedColumnGroup() : l3).getOriginalParent() && r3(a4);
                  }
                  t4 < e4.length && r3(e4.length);
                }
                return i2 || this.setupParentsIntoCols(s2, null), s2;
              }
              createProvidedColumnGroup(e3, t3, a3, n2, o2, r2, l2) {
                const s2 = o2.getUniqueKey(t3.groupId || null, null), d2 = this.createMergedColGroupDef(t3, s2), g2 = new i.AgProvidedColumnGroup(d2, s2, false, a3);
                this.createBean(g2);
                const u2 = this.findExistingGroup(t3, r2);
                u2 && r2.splice(u2.idx, 1);
                const h = u2 == null ? void 0 : u2.group;
                h && g2.setExpanded(h.isExpanded());
                const p = (0, c._recursivelyCreateColumns)(this.beans, d2.children, a3 + 1, e3, n2, o2, r2, l2);
                return g2.setChildren(p), g2;
              }
              balanceColumnTree(e3, t3, a3, n2) {
                const o2 = [];
                for (let r2 = 0; r2 < e3.length; r2++) {
                  const s2 = e3[r2];
                  if ((0, l.isProvidedColumnGroup)(s2)) {
                    const e4 = s2, r3 = this.balanceColumnTree(e4.getChildren(), t3 + 1, a3, n2);
                    e4.setChildren(r3), o2.push(e4);
                  } else {
                    let r3, d2;
                    for (let e4 = a3 - 1; e4 >= t3; e4--) {
                      const e5 = n2.getUniqueKey(null, null), a4 = this.createMergedColGroupDef(null, e5), o3 = new i.AgProvidedColumnGroup(a4, e5, true, t3);
                      this.createBean(o3), d2 && d2.setChildren([o3]), d2 = o3, r3 || (r3 = d2);
                    }
                    if (r3 && d2) {
                      o2.push(r3);
                      if (e3.some((e4) => (0, l.isProvidedColumnGroup)(e4))) {
                        d2.setChildren([s2]);
                        continue;
                      }
                      d2.setChildren(e3);
                      break;
                    }
                    o2.push(s2);
                  }
                }
                return o2;
              }
              findDepth(e3) {
                let t3 = 0, a3 = e3;
                for (; a3 && a3[0] && (0, l.isProvidedColumnGroup)(a3[0]); )
                  t3++, a3 = a3[0].getChildren();
                return t3;
              }
              findMaxDepth(e3, t3) {
                let a3 = t3;
                for (let n2 = 0; n2 < e3.length; n2++) {
                  const o2 = e3[n2];
                  if ((0, l.isProvidedColumnGroup)(o2)) {
                    const e4 = o2, n3 = this.findMaxDepth(e4.getChildren(), t3 + 1);
                    a3 < n3 && (a3 = n3);
                  }
                }
                return a3;
              }
              balanceTreeForAutoCols(e3, t3) {
                const a3 = [];
                return e3.forEach((e4) => {
                  let n2 = e4;
                  for (let a4 = t3 - 1; a4 >= 0; a4--) {
                    const t4 = new i.AgProvidedColumnGroup(null, `FAKE_PATH_${e4.getId()}}_${a4}`, true, a4);
                    this.createBean(t4), t4.setChildren([n2]), n2.originalParent = t4, n2 = t4;
                  }
                  0 === t3 && (e4.originalParent = null), a3.push(n2);
                }), a3;
              }
              createMergedColGroupDef(e3, t3) {
                const a3 = {}, { gos: n2, validation: o2 } = this.beans;
                return Object.assign(a3, n2.get("defaultColGroupDef")), Object.assign(a3, e3), o2 == null ? void 0 : o2.validateColDef(a3, t3), a3;
              }
              findExistingGroup(e3, t3) {
                if (null != e3.groupId)
                  for (let a3 = 0; a3 < t3.length; a3++) {
                    const n2 = t3[a3];
                    if (n2.getColGroupDef() && n2.getId() === e3.groupId)
                      return { idx: a3, group: n2 };
                  }
              }
              createColumnGroup(e3, t3, a3, n2, i2) {
                const l2 = e3.getGroupId(), s2 = t3.getInstanceIdForKey(l2);
                let c2 = a3[(0, o.createUniqueColumnGroupId)(l2, s2)];
                return c2 && c2.getProvidedColumnGroup() !== e3 && (c2 = null), (0, d._exists)(c2) ? c2.reset() : (c2 = new r.AgColumnGroup(e3, l2, s2, n2), i2 || this.createBean(c2)), c2;
              }
              mapOldGroupsById(e3) {
                const t3 = {}, a3 = (e4) => {
                  e4.forEach((e5) => {
                    if ((0, o.isColumnGroup)(e5)) {
                      const n2 = e5;
                      t3[e5.getUniqueId()] = n2, a3(n2.getChildren());
                    }
                  });
                };
                return e3 && a3(e3), t3;
              }
              setupParentsIntoCols(e3, t3) {
                e3.forEach((e4) => {
                  if (e4.parent = t3, (0, o.isColumnGroup)(e4)) {
                    const t4 = e4;
                    this.setupParentsIntoCols(t4.getChildren(), t4);
                  }
                });
              }
            }
            t2.ColumnGroupService = u;
          }, 3156: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.isColumnHovered = void 0, t2.isColumnHovered = function(e3, t3) {
              var _a;
              return !!((_a = e3.colHover) == null ? void 0 : _a.isHovered(t3));
            };
          }, 1690: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnHoverModule = void 0;
            const n = a2(7205), o = a2(3156), r = a2(7683);
            t2.ColumnHoverModule = { moduleName: "ColumnHover", version: n.VERSION, beans: [r.ColumnHoverService], apiFunctions: { isColumnHovered: o.isColumnHovered } };
          }, 7683: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnHoverService = void 0;
            const n = a2(8731), o = a2(5788);
            class r extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colHover";
              }
              setMouseOver(e3) {
                this.updateState(e3);
              }
              clearMouseOver() {
                this.updateState(null);
              }
              isHovered(e3) {
                const t3 = this.selectedColumns;
                return !!t3 && t3.indexOf(e3) >= 0;
              }
              addHeaderColumnHoverListener(e3, t3, a3) {
                const n2 = () => {
                  if (!this.gos.get("columnHoverHighlight"))
                    return;
                  const e4 = this.isHovered(a3);
                  t3.addOrRemoveCssClass("ag-column-hover", e4);
                };
                e3.addManagedEventListeners({ columnHoverChanged: n2 }), n2();
              }
              onCellColumnHover(e3, t3) {
                if (!t3)
                  return;
                if (!this.gos.get("columnHoverHighlight"))
                  return;
                const a3 = this.isHovered(e3);
                t3.addOrRemoveCssClass("ag-column-hover", a3);
              }
              addHeaderFilterColumnHoverListener(e3, t3, a3, n2) {
                this.createHoverFeature(e3, [a3], n2);
                const o2 = () => {
                  if (!this.gos.get("columnHoverHighlight"))
                    return;
                  const e4 = this.isHovered(a3);
                  t3.addOrRemoveCssClass("ag-column-hover", e4);
                };
                e3.addManagedEventListeners({ columnHoverChanged: o2 }), o2();
              }
              createHoverFeature(e3, t3, a3) {
                e3.createManagedBean(new o.HoverFeature(t3, a3));
              }
              updateState(e3) {
                this.selectedColumns = e3, this.eventSvc.dispatchEvent({ type: "columnHoverChanged" });
              }
            }
            t2.ColumnHoverService = r;
          }, 5788: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.HoverFeature = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
              constructor(e3, t3) {
                super(), this.columns = e3, this.element = t3;
              }
              postConstruct() {
                if (this.gos.get("columnHoverHighlight")) {
                  const e3 = this.beans.colHover;
                  this.addManagedListeners(this.element, { mouseout: e3.clearMouseOver.bind(e3), mouseover: e3.setMouseOver.bind(e3, this.columns) });
                }
              }
            }
            t2.HoverFeature = o;
          }, 2294: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnKeyCreator = void 0;
            const n = a2(4422);
            t2.ColumnKeyCreator = class {
              constructor() {
                this.existingKeys = {};
              }
              addExistingKeys(e3) {
                for (let t3 = 0; t3 < e3.length; t3++)
                  this.existingKeys[e3[t3]] = true;
              }
              getUniqueKey(e3, t3) {
                e3 = (0, n._toStringOrNull)(e3);
                let a3 = 0;
                for (; ; ) {
                  let n2 = e3 != null ? e3 : t3;
                  if (n2 ? 0 !== a3 && (n2 += "_" + a3) : n2 = a3, !this.existingKeys[n2])
                    return this.existingKeys[n2] = true, String(n2);
                  a3++;
                }
              }
            };
          }, 2986: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnModel = void 0;
            const n = a2(3505), o = a2(8731), r = a2(7274), i = a2(1502), l = a2(2716), s = a2(5266), d = a2(3146);
            class c extends o.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colModel", this.pivotMode = false, this.ready = false, this.changeEventsDispatching = false;
              }
              postConstruct() {
                this.pivotMode = this.gos.get("pivotMode"), this.addManagedPropertyListeners(["groupDisplayType", "treeData", "treeDataDisplayType", "groupHideOpenParents"], (e3) => this.refreshAll((0, d._convertColumnEventSourceType)(e3.source))), this.addManagedPropertyListeners(["defaultColDef", "defaultColGroupDef", "columnTypes", "suppressFieldDotNotation"], (e3) => this.recreateColumnDefs((0, d._convertColumnEventSourceType)(e3.source))), this.addManagedPropertyListener("pivotMode", (e3) => this.setPivotMode(this.gos.get("pivotMode"), (0, d._convertColumnEventSourceType)(e3.source)));
              }
              createColsFromColDefs(e3) {
                var _a, _b, _c2;
                const { beans: t3 } = this, { valueCache: a3, colAutosize: n2, rowGroupColsSvc: o2, pivotColsSvc: r2, valueColsSvc: i2, visibleCols: c2, colViewport: g, eventSvc: u } = t3, h = this.colDefs ? (0, s._compareColumnStatesAndDispatchEvents)(t3, e3) : void 0;
                a3 == null ? void 0 : a3.expire();
                const p = (_a = this.colDefCols) == null ? void 0 : _a.list, m = (_b = this.colDefCols) == null ? void 0 : _b.tree, f = (0, l._createColumnTree)(t3, this.colDefs, true, m, e3);
                (0, d._destroyColumnTree)(t3, (_c2 = this.colDefCols) == null ? void 0 : _c2.tree, f.columnTree);
                const v = f.columnTree, b = f.treeDept, C = (0, d._getColumnsFromTree)(v), w = {};
                C.forEach((e4) => w[e4.getId()] = e4), this.colDefCols = { tree: v, treeDepth: b, list: C, map: w }, o2 == null ? void 0 : o2.extractCols(e3, p), r2 == null ? void 0 : r2.extractCols(e3, p), i2 == null ? void 0 : i2.extractCols(e3, p), this.ready = true, this.refreshCols(true), c2.refresh(e3), g.checkViewportColumns(), u.dispatchEvent({ type: "columnEverythingChanged", source: e3 }), h && (this.changeEventsDispatching = true, h(), this.changeEventsDispatching = false), u.dispatchEvent({ type: "newColumnsLoaded", source: e3 }), "gridInitializing" === e3 && (n2 == null ? void 0 : n2.applyAutosizeStrategy());
              }
              refreshCols(e3) {
                var _a;
                if (!this.colDefCols)
                  return;
                const t3 = (_a = this.cols) == null ? void 0 : _a.tree;
                this.saveColOrder();
                const { autoColSvc: a3, selectionColSvc: n2, quickFilter: o2, pivotResultCols: l2, showRowGroupCols: s2, rowAutoHeight: d2, visibleCols: c2, colViewport: g, eventSvc: u } = this.beans, h = this.selectCols(l2, this.colDefCols);
                a3 == null ? void 0 : a3.createAutoCols(h, (e4) => {
                  this.lastOrder = e4(this.lastOrder), this.lastPivotOrder = e4(this.lastPivotOrder);
                }), a3 == null ? void 0 : a3.addAutoCols(h), n2 == null ? void 0 : n2.createSelectionCols(h, (e4) => {
                  var _a2, _b;
                  this.lastOrder = (_a2 = e4(this.lastOrder)) != null ? _a2 : null, this.lastPivotOrder = (_b = e4(this.lastPivotOrder)) != null ? _b : null;
                }), n2 == null ? void 0 : n2.addSelectionCols(h);
                const p = (0, r._shouldMaintainColumnOrder)(this.gos, this.showingPivotResult);
                e3 && !p || this.restoreColOrder(h), this.positionLockedCols(h), s2 == null ? void 0 : s2.refresh(), o2 == null ? void 0 : o2.refreshCols(), this.setColSpanActive(), d2 == null ? void 0 : d2.setAutoHeightActive(h), c2.clear(), g.clear();
                !(0, i._areEqual)(t3, this.cols.tree) && u.dispatchEvent({ type: "gridColumnsChanged" });
              }
              selectCols(e3, t3) {
                var _a;
                const a3 = (_a = e3 == null ? void 0 : e3.getPivotResultCols()) != null ? _a : null;
                this.showingPivotResult = null != a3;
                const { map: n2, list: o2, tree: r2, treeDepth: i2 } = a3 != null ? a3 : t3;
                if (this.cols = { list: o2.slice(), map: __spreadValues({}, n2), tree: r2.slice(), treeDepth: i2 }, a3) {
                  a3.list.some((e4) => {
                    var _a2;
                    return void 0 !== ((_a2 = this.cols) == null ? void 0 : _a2.map[e4.getColId()]);
                  }) || (this.lastPivotOrder = null);
                }
                return this.cols;
              }
              getColsToShow() {
                var _a;
                if (!this.cols)
                  return [];
                const e3 = this.isPivotMode() && !this.showingPivotResult, t3 = (_a = this.beans.valueColsSvc) == null ? void 0 : _a.columns;
                return this.cols.list.filter((a3) => {
                  const n2 = (0, d.isColumnGroupAutoCol)(a3);
                  if (e3) {
                    const e4 = t3 == null ? void 0 : t3.includes(a3);
                    return n2 || e4;
                  }
                  return n2 || a3.isVisible();
                });
              }
              refreshAll(e3) {
                this.ready && (this.refreshCols(false), this.beans.visibleCols.refresh(e3));
              }
              setColsVisible(e3, t3 = false, a3) {
                (0, s._applyColumnState)(this.beans, { state: e3.map((e4) => ({ colId: "string" == typeof e4 ? e4 : e4.getColId(), hide: !t3 })) }, a3);
              }
              restoreColOrder(e3) {
                const t3 = this.showingPivotResult ? this.lastPivotOrder : this.lastOrder;
                if (!t3)
                  return;
                const a3 = new Map(t3.map((e4, t4) => [e4, t4]));
                if (!e3.list.some((e4) => a3.has(e4)))
                  return;
                const n2 = new Map(e3.list.map((e4) => [e4, true])), o2 = t3.filter((e4) => n2.has(e4)), r2 = new Map(o2.map((e4) => [e4, true])), i2 = e3.list.filter((e4) => !r2.has(e4)), l2 = o2.slice();
                i2.forEach((e4) => {
                  let t4 = e4.getOriginalParent();
                  if (!t4)
                    return void l2.push(e4);
                  const a4 = [];
                  for (; !a4.length && t4; ) {
                    t4.getLeafColumns().forEach((e5) => {
                      const t5 = l2.indexOf(e5) >= 0, n4 = a4.indexOf(e5) < 0;
                      t5 && n4 && a4.push(e5);
                    }), t4 = t4.getOriginalParent();
                  }
                  if (!a4.length)
                    return void l2.push(e4);
                  const n3 = a4.map((e5) => l2.indexOf(e5)), o3 = Math.max(...n3);
                  l2.splice(o3 + 1, 0, e4);
                }), e3.list = l2;
              }
              positionLockedCols(e3) {
                e3.list = (0, n.placeLockedColumns)(e3.list, this.gos);
              }
              saveColOrder() {
                var _a, _b, _c2, _d;
                this.showingPivotResult ? this.lastPivotOrder = (_b = (_a = this.cols) == null ? void 0 : _a.list) != null ? _b : null : this.lastOrder = (_d = (_c2 = this.cols) == null ? void 0 : _c2.list) != null ? _d : null;
              }
              getColumnDefs() {
                var _a, _b, _c2;
                return this.colDefCols ? (_c2 = this.beans.colDefFactory) == null ? void 0 : _c2.getColumnDefs(this.colDefCols.list, this.showingPivotResult, this.lastOrder, (_b = (_a = this.cols) == null ? void 0 : _a.list) != null ? _b : []) : void 0;
              }
              setColSpanActive() {
                var _a;
                this.colSpanActive = !!((_a = this.cols) == null ? void 0 : _a.list.some((e3) => null != e3.getColDef().colSpan));
              }
              isPivotMode() {
                return this.pivotMode;
              }
              setPivotMode(e3, t3) {
                if (e3 === this.pivotMode)
                  return;
                if (this.pivotMode = e3, !this.ready)
                  return;
                this.refreshCols(false);
                const { visibleCols: a3, eventSvc: n2 } = this.beans;
                a3.refresh(t3), n2.dispatchEvent({ type: "columnPivotModeChanged" });
              }
              isPivotActive() {
                var _a;
                const e3 = (_a = this.beans.pivotColsSvc) == null ? void 0 : _a.columns;
                return this.pivotMode && !!(e3 == null ? void 0 : e3.length);
              }
              recreateColumnDefs(e3) {
                var _a;
                this.cols && ((_a = this.beans.autoColSvc) == null ? void 0 : _a.updateAutoCols(e3), this.createColsFromColDefs(e3));
              }
              setColumnDefs(e3, t3) {
                this.colDefs = e3, this.createColsFromColDefs(t3);
              }
              destroy() {
                var _a;
                (0, d._destroyColumnTree)(this.beans, (_a = this.colDefCols) == null ? void 0 : _a.tree), super.destroy();
              }
              getColTree() {
                var _a, _b;
                return (_b = (_a = this.cols) == null ? void 0 : _a.tree) != null ? _b : [];
              }
              getColDefColTree() {
                var _a, _b;
                return (_b = (_a = this.colDefCols) == null ? void 0 : _a.tree) != null ? _b : [];
              }
              getColDefCols() {
                var _a, _b;
                return (_b = (_a = this.colDefCols) == null ? void 0 : _a.list) != null ? _b : null;
              }
              getCols() {
                var _a, _b;
                return (_b = (_a = this.cols) == null ? void 0 : _a.list) != null ? _b : [];
              }
              getAllCols() {
                var _a, _b, _c2, _d, _e, _f, _g;
                const { pivotResultCols: e3, autoColSvc: t3, selectionColSvc: a3 } = this.beans, n2 = (_a = e3 == null ? void 0 : e3.getPivotResultCols()) == null ? void 0 : _a.list;
                return [(_c2 = (_b = this.colDefCols) == null ? void 0 : _b.list) != null ? _c2 : [], (_e = (_d = t3 == null ? void 0 : t3.autoCols) == null ? void 0 : _d.list) != null ? _e : [], (_g = (_f = a3 == null ? void 0 : a3.selectionCols) == null ? void 0 : _f.list) != null ? _g : [], n2 != null ? n2 : []].flat();
              }
              getColsForKeys(e3) {
                return e3 ? e3.map((e4) => this.getCol(e4)).filter((e4) => null != e4) : [];
              }
              getColDefCol(e3) {
                var _a;
                return ((_a = this.colDefCols) == null ? void 0 : _a.list) ? this.getColFromCollection(e3, this.colDefCols) : null;
              }
              getCol(e3) {
                return null == e3 ? null : this.getColFromCollection(e3, this.cols);
              }
              getColFromCollection(e3, t3) {
                var _a, _b;
                if (null == t3)
                  return null;
                const { map: a3, list: n2 } = t3;
                if ("string" == typeof e3 && a3[e3])
                  return a3[e3];
                for (let t4 = 0; t4 < n2.length; t4++)
                  if ((0, d._columnsMatch)(n2[t4], e3))
                    return n2[t4];
                return (_b = (_a = this.beans.autoColSvc) == null ? void 0 : _a.getAutoCol(e3)) != null ? _b : null;
              }
            }
            t2.ColumnModel = c;
          }, 2027: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnApiModule = t2.ColumnFlexModule = t2.DataTypeModule = void 0;
            const n = a2(7358), o = a2(7205), r = a2(1144), i = a2(4604), l = a2(2849), s = a2(6350);
            t2.DataTypeModule = { moduleName: "DataType", version: o.VERSION, beans: [s.DataTypeService], dependsOn: [n.CheckboxCellRendererModule] }, t2.ColumnFlexModule = { moduleName: "ColumnFlex", version: o.VERSION, beans: [l.ColumnFlexService] }, t2.ColumnApiModule = { moduleName: "ColumnApi", version: o.VERSION, beans: [i.ColumnDefFactory], apiFunctions: { getColumnDef: r.getColumnDef, getDisplayNameForColumn: r.getDisplayNameForColumn, getColumn: r.getColumn, getColumns: r.getColumns, applyColumnState: r.applyColumnState, getColumnState: r.getColumnState, resetColumnState: r.resetColumnState, isPinning: r.isPinning, isPinningLeft: r.isPinningLeft, isPinningRight: r.isPinningRight, getDisplayedColAfter: r.getDisplayedColAfter, getDisplayedColBefore: r.getDisplayedColBefore, setColumnsVisible: r.setColumnsVisible, setColumnsPinned: r.setColumnsPinned, getAllGridColumns: r.getAllGridColumns, getDisplayedLeftColumns: r.getDisplayedLeftColumns, getDisplayedCenterColumns: r.getDisplayedCenterColumns, getDisplayedRightColumns: r.getDisplayedRightColumns, getAllDisplayedColumns: r.getAllDisplayedColumns, getAllDisplayedVirtualColumns: r.getAllDisplayedVirtualColumns, getColumnDefs: r.getColumnDefs } };
          }, 8997: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnNameService = t2._camelCaseToHumanText = void 0;
            const n = a2(8731);
            function o(e3) {
              if (!e3 || null == e3)
                return null;
              return e3.replace(/([a-z])([A-Z])/g, "$1 $2").replace(/([A-Z]+)([A-Z])([a-z])/g, "$1 $2$3").replace(/\./g, " ").split(" ").map((e4) => e4.substring(0, 1).toUpperCase() + (e4.length > 1 ? e4.substring(1, e4.length) : "")).join(" ");
            }
            t2._camelCaseToHumanText = o;
            class r extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colNames";
              }
              getDisplayNameForColumn(e3, t3, a3 = false) {
                if (!e3)
                  return null;
                const n2 = this.getHeaderName(e3.getColDef(), e3, null, null, t3), { aggColNameSvc: o2 } = this.beans;
                return a3 && o2 ? o2.getHeaderName(e3, n2) : n2;
              }
              getDisplayNameForProvidedColumnGroup(e3, t3, a3) {
                const n2 = t3 == null ? void 0 : t3.getColGroupDef();
                return n2 ? this.getHeaderName(n2, null, e3, t3, a3) : null;
              }
              getDisplayNameForColumnGroup(e3, t3) {
                return this.getDisplayNameForProvidedColumnGroup(e3, e3.getProvidedColumnGroup(), t3);
              }
              getHeaderName(e3, t3, a3, n2, r2) {
                var _a, _b;
                const i = e3.headerValueGetter;
                if (i) {
                  const o2 = this.gos.addGridCommonParams({ colDef: e3, column: t3, columnGroup: a3, providedColumnGroup: n2, location: r2 });
                  return "function" == typeof i ? i(o2) : "string" == typeof i ? (_b = (_a = this.beans.expressionSvc) == null ? void 0 : _a.evaluate(i, o2)) != null ? _b : null : "";
                }
                return null != e3.headerName ? e3.headerName : e3.field ? o(e3.field) : "";
              }
            }
            t2.ColumnNameService = r;
          }, 5266: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.getColumnStateFromColDef = t2._getColumnState = t2._compareColumnStatesAndDispatchEvents = t2._resetColumnState = t2._applyColumnState = void 0;
            const n = a2(3505), o = a2(1502), r = a2(4422), i = a2(7764), l = a2(2934), s = a2(2716), d = a2(3146);
            function c(e3, t3, a3) {
              var _a, _b;
              const { colModel: l2, rowGroupColsSvc: c2, pivotColsSvc: u2, autoColSvc: h2, selectionColSvc: m, colAnimation: f, visibleCols: v, pivotResultCols: b, environment: C, valueColsSvc: w, eventSvc: y, gos: S } = e3, k = l2.getColDefCols() || [];
              if (!(k == null ? void 0 : k.length))
                return false;
              if ((t3 == null ? void 0 : t3.state) && !t3.state.forEach)
                return (0, i._warn)(32), false;
              const x = (n2, o2, r2, i2, l3) => {
                var _a2;
                if (!n2)
                  return;
                const g2 = (0, d.getValueFactory)(o2, t3.defaultState), h3 = g2("flex").value1;
                if ((0, s.updateSomeColumnState)(e3, n2, g2("hide").value1, g2("sort").value1, g2("sortIndex").value1, g2("pinned").value1, h3, a3), null == h3) {
                  const e4 = g2("width").value1;
                  if (null != e4) {
                    const t4 = (_a2 = n2.getColDef().minWidth) != null ? _a2 : C.getDefaultColumnMinWidth();
                    null != t4 && e4 >= t4 && n2.setActualWidth(e4, a3);
                  }
                }
                !l3 && n2.isPrimary() && (w == null ? void 0 : w.syncColumnWithState(n2, a3, g2), c2 == null ? void 0 : c2.syncColumnWithState(n2, a3, g2, r2), u2 == null ? void 0 : u2.syncColumnWithState(n2, a3, g2, i2));
              }, R = (r2, s2, f2) => {
                var _a2, _b2, _c, _d;
                const b2 = g(e3, a3), C2 = s2.slice(), w2 = {}, k2 = {}, R2 = [], M2 = [], P2 = [];
                let F = 0;
                const E = (_a2 = c2 == null ? void 0 : c2.columns.slice()) != null ? _a2 : [], z = (_b2 = u2 == null ? void 0 : u2.columns.slice()) != null ? _b2 : [];
                r2.forEach((e4) => {
                  const t4 = e4.colId;
                  if (t4.startsWith(d.GROUP_AUTO_COLUMN_ID))
                    return R2.push(e4), void P2.push(e4);
                  if ((0, d.isColumnSelectionCol)(t4))
                    return M2.push(e4), void P2.push(e4);
                  const a4 = f2(t4);
                  a4 ? (x(a4, e4, w2, k2, false), (0, o._removeFromArray)(C2, a4)) : (P2.push(e4), F += 1);
                });
                const D = (e4) => x(e4, null, w2, k2, false);
                C2.forEach(D), c2 == null ? void 0 : c2.sortColumns(p.bind(c2, w2, E)), u2 == null ? void 0 : u2.sortColumns(p.bind(u2, k2, z)), l2.refreshCols(false);
                const A = (e4, t4, a4 = []) => {
                  t4.forEach((t5) => {
                    const n2 = e4(t5.colId);
                    (0, o._removeFromArray)(a4, n2), x(n2, t5, null, null, true);
                  }), a4.forEach(D);
                };
                return A((e4) => {
                  var _a3;
                  return (_a3 = h2 == null ? void 0 : h2.getAutoCol(e4)) != null ? _a3 : null;
                }, R2, (_c = h2 == null ? void 0 : h2.getAutoCols()) == null ? void 0 : _c.slice()), A((e4) => {
                  var _a3;
                  return (_a3 = m == null ? void 0 : m.getSelectionCol(e4)) != null ? _a3 : null;
                }, M2, (_d = m == null ? void 0 : m.getSelectionCols()) == null ? void 0 : _d.slice()), function(e4, t4, a4) {
                  if (!e4.applyOrder || !e4.state)
                    return;
                  const o2 = [];
                  e4.state.forEach((e5) => {
                    null != e5.colId && o2.push(e5.colId);
                  }), function(e5, t5, a5, o3) {
                    if (null == e5)
                      return;
                    let r3 = [];
                    const l3 = {};
                    t5.forEach((t6) => {
                      if (l3[t6])
                        return;
                      const a6 = e5.map[t6];
                      a6 && (r3.push(a6), l3[t6] = true);
                    });
                    let s3 = 0;
                    if (e5.list.forEach((e6) => {
                      const t6 = e6.getColId();
                      if (null != l3[t6])
                        return;
                      t6.startsWith(d.GROUP_AUTO_COLUMN_ID) ? r3.splice(s3++, 0, e6) : r3.push(e6);
                    }), r3 = (0, n.placeLockedColumns)(r3, o3), !(0, n.doesMovePassMarryChildren)(r3, a5.getColTree()))
                      return void (0, i._warn)(39);
                    e5.list = r3;
                  }(t4.cols, o2, t4, a4);
                }(t3, l2, S), v.refresh(a3), y.dispatchEvent({ type: "columnEverythingChanged", source: a3 }), b2(), { unmatchedAndAutoStates: P2, unmatchedCount: F };
              };
              f == null ? void 0 : f.start();
              let { unmatchedAndAutoStates: M, unmatchedCount: P } = R(t3.state || [], k, (e4) => l2.getColDefCol(e4));
              if (M.length > 0 || (0, r._exists)(t3.defaultState)) {
                P = R(M, (_b = (_a = b == null ? void 0 : b.getPivotResultCols()) == null ? void 0 : _a.list) != null ? _b : [], (e4) => {
                  var _a2;
                  return (_a2 = b == null ? void 0 : b.getPivotResultCol(e4)) != null ? _a2 : null;
                }).unmatchedCount;
              }
              return f == null ? void 0 : f.finish(), 0 === P;
            }
            function g(e3, t3) {
              var _a, _b, _c;
              const { rowGroupColsSvc: a3, pivotColsSvc: n2, valueColsSvc: r2, colModel: i2, sortSvc: s2, eventSvc: d2 } = e3, c2 = { rowGroupColumns: (_a = a3 == null ? void 0 : a3.columns.slice()) != null ? _a : [], pivotColumns: (_b = n2 == null ? void 0 : n2.columns.slice()) != null ? _b : [], valueColumns: (_c = r2 == null ? void 0 : r2.columns.slice()) != null ? _c : [] }, g2 = u(e3), h2 = {};
              return g2.forEach((e4) => {
                h2[e4.colId] = e4;
              }), () => {
                var _a2, _b2;
                const r3 = i2.getAllCols(), p2 = (e4, a4, n3, r4) => {
                  const i3 = a4.map(r4), l2 = n3.map(r4);
                  if ((0, o._areEqual)(i3, l2))
                    return;
                  const s3 = new Set(a4);
                  n3.forEach((e5) => {
                    s3.delete(e5) || s3.add(e5);
                  });
                  const c3 = [...s3];
                  d2.dispatchEvent({ type: e4, columns: c3, column: 1 === c3.length ? c3[0] : null, source: t3 });
                }, m = (e4) => {
                  const t4 = [];
                  return r3.forEach((a4) => {
                    const n3 = h2[a4.getColId()];
                    n3 && e4(n3, a4) && t4.push(a4);
                  }), t4;
                }, f = (e4) => e4.getColId();
                p2("columnRowGroupChanged", c2.rowGroupColumns, (_a2 = a3 == null ? void 0 : a3.columns) != null ? _a2 : [], f), p2("columnPivotChanged", c2.pivotColumns, (_b2 = n2 == null ? void 0 : n2.columns) != null ? _b2 : [], f);
                const v = m((e4, t4) => {
                  const a4 = null != e4.aggFunc, n3 = a4 != t4.isValueActive(), o2 = a4 && e4.aggFunc != t4.getAggFunc();
                  return n3 || o2;
                });
                v.length > 0 && (0, l.dispatchColumnChangedEvent)(d2, "columnValueChanged", v, t3);
                (0, l.dispatchColumnResizedEvent)(d2, m((e4, t4) => e4.width != t4.getActualWidth()), true, t3);
                (0, l.dispatchColumnPinnedEvent)(d2, m((e4, t4) => e4.pinned != t4.getPinned()), t3);
                (0, l.dispatchColumnVisibleEvent)(d2, m((e4, t4) => e4.hide == t4.isVisible()), t3);
                const b = m((e4, t4) => e4.sort != t4.getSort() || e4.sortIndex != t4.getSortIndex());
                b.length > 0 && (s2 == null ? void 0 : s2.dispatchSortChangedEvents(t3, b));
                const C = u(e3);
                !function(e4, t4, a4, n3, o2) {
                  const r4 = {};
                  t4.forEach((e5) => r4[e5.colId] = e5);
                  const i3 = {};
                  e4.forEach((e5) => {
                    r4[e5.colId] && (i3[e5.colId] = true);
                  });
                  const l2 = e4.filter((e5) => i3[e5.colId]), s3 = t4.filter((e5) => i3[e5.colId]), d3 = [];
                  if (s3.forEach((e5, t5) => {
                    const a5 = l2 && l2[t5];
                    if (a5 && a5.colId !== e5.colId) {
                      const e6 = n3.getCol(a5.colId);
                      e6 && d3.push(e6);
                    }
                  }), !d3.length)
                    return;
                  o2.dispatchEvent({ type: "columnMoved", columns: d3, column: 1 === d3.length ? d3[0] : null, finished: true, source: a4 });
                }(g2, C, t3, i2, d2);
              };
            }
            function u(e3) {
              const { colModel: t3, rowGroupColsSvc: a3, pivotColsSvc: n2 } = e3, o2 = t3.getColDefCols();
              if ((0, r._missing)(o2) || !t3.isAlive())
                return [];
              const i2 = t3.getAllCols(), l2 = a3 == null ? void 0 : a3.columns, s2 = n2 == null ? void 0 : n2.columns, d2 = i2.map((e4) => ((e5) => {
                var _a;
                const t4 = e5.isRowGroupActive() && l2 ? l2.indexOf(e5) : null, a4 = e5.isPivotActive() && s2 ? s2.indexOf(e5) : null, n3 = e5.isValueActive() ? e5.getAggFunc() : null, o3 = null != e5.getSort() ? e5.getSort() : null, r2 = null != e5.getSortIndex() ? e5.getSortIndex() : null;
                return { colId: e5.getColId(), width: e5.getActualWidth(), hide: !e5.isVisible(), pinned: e5.getPinned(), sort: o3, sortIndex: r2, aggFunc: n3, rowGroup: e5.isRowGroupActive(), rowGroupIndex: t4, pivot: e5.isPivotActive(), pivotIndex: a4, flex: (_a = e5.getFlex()) != null ? _a : null };
              })(e4)), c2 = new Map(t3.getCols().map((e4, t4) => [e4.getColId(), t4]));
              return d2.sort((e4, t4) => (c2.has(e4.colId) ? c2.get(e4.colId) : -1) - (c2.has(t4.colId) ? c2.get(t4.colId) : -1)), d2;
            }
            function h(e3) {
              const t3 = (e4, t4) => null != e4 ? e4 : null != t4 ? t4 : null, a3 = e3.getColDef(), n2 = t3(a3.sort, a3.initialSort), o2 = t3(a3.sortIndex, a3.initialSortIndex), r2 = t3(a3.hide, a3.initialHide), i2 = t3(a3.pinned, a3.initialPinned), l2 = t3(a3.width, a3.initialWidth), s2 = t3(a3.flex, a3.initialFlex);
              let d2 = t3(a3.rowGroupIndex, a3.initialRowGroupIndex), c2 = t3(a3.rowGroup, a3.initialRowGroup);
              null != d2 || null != c2 && 0 != c2 || (d2 = null, c2 = null);
              let g2 = t3(a3.pivotIndex, a3.initialPivotIndex), u2 = t3(a3.pivot, a3.initialPivot);
              null != g2 || null != u2 && 0 != u2 || (g2 = null, u2 = null);
              const h2 = t3(a3.aggFunc, a3.initialAggFunc);
              return { colId: e3.getColId(), sort: n2, sortIndex: o2, hide: r2, pinned: i2, width: l2, flex: s2, rowGroup: c2, rowGroupIndex: d2, pivot: u2, pivotIndex: g2, aggFunc: h2 };
            }
            t2._applyColumnState = c, t2._resetColumnState = function(e3, t3) {
              const { colModel: a3, autoColSvc: n2 } = e3, o2 = a3.getColDefCols();
              if (!(o2 == null ? void 0 : o2.length))
                return;
              const i2 = a3.getColDefColTree(), l2 = (0, d._getColumnsFromTree)(i2), s2 = [];
              let g2 = 1e3, u2 = 1e3, p2 = [];
              const m = n2 == null ? void 0 : n2.getAutoCols();
              m && (p2 = p2.concat(m)), l2 && (p2 = p2.concat(l2)), p2.forEach((e4) => {
                const t4 = h(e4);
                (0, r._missing)(t4.rowGroupIndex) && t4.rowGroup && (t4.rowGroupIndex = g2++), (0, r._missing)(t4.pivotIndex) && t4.pivot && (t4.pivotIndex = u2++), s2.push(t4);
              }), c(e3, { state: s2, applyOrder: true }, t3);
            }, t2._compareColumnStatesAndDispatchEvents = g, t2._getColumnState = u, t2.getColumnStateFromColDef = h;
            const p = (e3, t3, a3, n2) => {
              const o2 = e3[a3.getId()], r2 = e3[n2.getId()], i2 = null != o2, l2 = null != r2;
              if (i2 && l2)
                return o2 - r2;
              if (i2)
                return -1;
              if (l2)
                return 1;
              const s2 = t3.indexOf(a3), d2 = t3.indexOf(n2), c2 = s2 >= 0;
              return c2 && d2 >= 0 ? s2 - d2 : c2 ? -1 : 1;
            };
          }, 3146: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.getValueFactory = t2._columnsMatch = t2._convertColumnEventSourceType = t2._updateColsMap = t2._areColIdsEqual = t2.convertColumnTypes = t2.isColumnSelectionCol = t2.isColumnGroupAutoCol = t2._destroyColumnTree = t2.getWidthOfColsInList = t2._getColumnsFromTree = t2.GROUP_AUTO_COLUMN_ID = void 0;
            const n = a2(3355), o = a2(9409), r = a2(1502), i = a2(4422), l = a2(2716), s = a2(5626);
            t2.GROUP_AUTO_COLUMN_ID = "ag-Grid-AutoColumn", t2._getColumnsFromTree = function(e3) {
              const t3 = [], a3 = (e4) => {
                for (let r2 = 0; r2 < e4.length; r2++) {
                  const i2 = e4[r2];
                  (0, n.isColumn)(i2) ? t3.push(i2) : (0, o.isProvidedColumnGroup)(i2) && a3(i2.getChildren());
                }
              };
              return a3(e3), t3;
            }, t2.getWidthOfColsInList = function(e3) {
              return e3.reduce((e4, t3) => e4 + t3.getActualWidth(), 0);
            }, t2._destroyColumnTree = function(e3, t3, a3) {
              const n2 = {};
              if (!t3)
                return;
              (0, l.depthFirstOriginalTreeSearch)(null, t3, (e4) => {
                n2[e4.getInstanceId()] = e4;
              }), a3 && (0, l.depthFirstOriginalTreeSearch)(null, a3, (e4) => {
                n2[e4.getInstanceId()] = null;
              });
              const o2 = Object.values(n2).filter((e4) => null != e4);
              e3.context.destroyBeans(o2);
            }, t2.isColumnGroupAutoCol = function(e3) {
              return e3.getId().startsWith(t2.GROUP_AUTO_COLUMN_ID);
            }, t2.isColumnSelectionCol = function(e3) {
              var _a;
              const t3 = "string" == typeof e3 ? e3 : "getColId" in e3 ? e3.getColId() : e3.colId;
              return (_a = t3 == null ? void 0 : t3.startsWith(s.CONTROLS_COLUMN_ID_PREFIX)) != null ? _a : false;
            }, t2.convertColumnTypes = function(e3) {
              let t3 = [];
              return e3 instanceof Array ? t3 = e3 : "string" == typeof e3 && (t3 = e3.split(",")), t3;
            }, t2._areColIdsEqual = function(e3, t3) {
              return (0, r._areEqual)(e3, t3, (e4, t4) => e4.getColId() === t4.getColId());
            }, t2._updateColsMap = function(e3) {
              e3.map = {}, e3.list.forEach((t3) => e3.map[t3.getId()] = t3);
            }, t2._convertColumnEventSourceType = function(e3) {
              return "gridOptionsUpdated" === e3 ? "gridOptionsChanged" : e3;
            }, t2._columnsMatch = function(e3, t3) {
              const a3 = e3 === t3, n2 = e3.getColDef() === t3, o2 = e3.getColId() == t3;
              return a3 || n2 || o2;
            };
            t2.getValueFactory = (e3, t3) => (a3, n2) => {
              const o2 = { value1: void 0, value2: void 0 };
              let r2 = false;
              return e3 && (void 0 !== e3[a3] && (o2.value1 = e3[a3], r2 = true), (0, i._exists)(n2) && void 0 !== e3[n2] && (o2.value2 = e3[n2], r2 = true)), !r2 && t3 && (void 0 !== t3[a3] && (o2.value1 = t3[a3]), (0, i._exists)(n2) && void 0 !== t3[n2] && (o2.value2 = t3[n2])), o2;
            };
          }, 5034: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnViewportService = void 0;
            const n = a2(8731), o = a2(3355), r = a2(4422);
            class i extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colViewport", this.colsWithinViewport = [], this.headerColsWithinViewport = [], this.colsWithinViewportHash = "", this.rowsOfHeadersToRenderLeft = {}, this.rowsOfHeadersToRenderRight = {}, this.rowsOfHeadersToRenderCenter = {};
              }
              wireBeans(e3) {
                this.visibleCols = e3.visibleCols, this.colModel = e3.colModel;
              }
              postConstruct() {
                this.suppressColumnVirtualisation = this.gos.get("suppressColumnVirtualisation");
              }
              setScrollPosition(e3, t3, a3 = false) {
                const { visibleCols: n2 } = this, o2 = n2.isBodyWidthDirty;
                if (!(e3 === this.scrollWidth && t3 === this.scrollPosition && !o2)) {
                  if (this.scrollWidth = e3, this.scrollPosition = t3, n2.isBodyWidthDirty = true, this.gos.get("enableRtl")) {
                    const a4 = n2.bodyWidth;
                    this.viewportLeft = a4 - t3 - e3, this.viewportRight = a4 - t3;
                  } else
                    this.viewportLeft = t3, this.viewportRight = e3 + t3;
                  this.colModel.ready && this.checkViewportColumns(a3);
                }
              }
              getHeadersToRender(e3, t3) {
                let a3;
                switch (e3) {
                  case "left":
                    a3 = this.rowsOfHeadersToRenderLeft[t3];
                    break;
                  case "right":
                    a3 = this.rowsOfHeadersToRenderRight[t3];
                    break;
                  default:
                    a3 = this.rowsOfHeadersToRenderCenter[t3];
                }
                return a3 || [];
              }
              extractViewportColumns() {
                const e3 = this.visibleCols.centerCols;
                this.isColumnVirtualisationSuppressed() ? (this.colsWithinViewport = e3, this.headerColsWithinViewport = e3) : (this.colsWithinViewport = e3.filter(this.isColumnInRowViewport.bind(this)), this.headerColsWithinViewport = e3.filter(this.isColumnInHeaderViewport.bind(this)));
              }
              isColumnVirtualisationSuppressed() {
                return this.suppressColumnVirtualisation || 0 === this.viewportRight;
              }
              clear(e3) {
                this.rowsOfHeadersToRenderLeft = {}, this.rowsOfHeadersToRenderRight = {}, this.rowsOfHeadersToRenderCenter = {}, e3 || (this.colsWithinViewportHash = "");
              }
              isColumnInHeaderViewport(e3) {
                return !(!e3.isAutoHeaderHeight() && !function(e4) {
                  for (; e4; ) {
                    if (e4.isAutoHeaderHeight())
                      return true;
                    e4 = e4.getParent();
                  }
                  return false;
                }(e3)) || this.isColumnInRowViewport(e3);
              }
              isColumnInRowViewport(e3) {
                if (e3.isAutoHeight())
                  return true;
                const t3 = e3.getLeft() || 0, a3 = t3 + e3.getActualWidth(), n2 = this.viewportLeft - 200, o2 = this.viewportRight + 200;
                return !(t3 < n2 && a3 < n2) && !(t3 > o2 && a3 > o2);
              }
              getViewportColumns() {
                const { leftCols: e3, rightCols: t3 } = this.visibleCols;
                return this.colsWithinViewport.concat(e3).concat(t3);
              }
              getColsWithinViewport(e3) {
                if (!this.colModel.colSpanActive)
                  return this.colsWithinViewport;
                const t3 = this.isColumnVirtualisationSuppressed() ? void 0 : this.isColumnInRowViewport.bind(this), { visibleCols: a3 } = this, n2 = a3.centerCols;
                return a3.getColsForRow(e3, n2, t3, (e4) => {
                  const t4 = e4.getLeft();
                  return (0, r._exists)(t4) && t4 > this.viewportLeft;
                });
              }
              checkViewportColumns(e3 = false) {
                this.extractViewport() && this.eventSvc.dispatchEvent({ type: "virtualColumnsChanged", afterScroll: e3 });
              }
              calculateHeaderRows() {
                this.clear(true);
                const e3 = {}, { leftCols: t3, rightCols: a3, treeLeft: n2, treeRight: r2, treeCenter: i2 } = this.visibleCols;
                this.headerColsWithinViewport.concat(t3).concat(a3).forEach((t4) => e3[t4.getId()] = true);
                const l = (t4, a4, n3) => {
                  let r3 = false;
                  for (let i3 = 0; i3 < t4.length; i3++) {
                    const s = t4[i3];
                    let d = false;
                    if ((0, o.isColumn)(s))
                      d = true === e3[s.getId()];
                    else {
                      const e4 = s.getDisplayedChildren();
                      e4 && (d = l(e4, a4, n3 + 1));
                    }
                    d && (r3 = true, a4[n3] || (a4[n3] = []), a4[n3].push(s));
                  }
                  return r3;
                };
                l(n2, this.rowsOfHeadersToRenderLeft, 0), l(r2, this.rowsOfHeadersToRenderRight, 0), l(i2, this.rowsOfHeadersToRenderCenter, 0);
              }
              extractViewport() {
                this.extractViewportColumns();
                const e3 = this.getViewportColumns().map((e4) => `${e4.getId()}-${e4.getPinned() || "normal"}`).join("#"), t3 = this.colsWithinViewportHash !== e3;
                return t3 && (this.colsWithinViewportHash = e3, this.calculateHeaderRows()), t3;
              }
            }
            t2.ColumnViewportService = i;
          }, 6350: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.DataTypeService = void 0;
            const n = a2(9853), o = a2(8731), r = a2(7274), i = a2(9827), l = a2(4422), s = a2(6996), d = a2(7764), c = a2(2716), g = a2(5266), u = a2(3146);
            class h extends o.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "dataTypeSvc", this.dataTypeDefinitions = {}, this.isPendingInference = false, this.isColumnTypeOverrideInDataTypeDefinitions = false, this.columnStateUpdatesPendingInference = {}, this.columnStateUpdateListenerDestroyFuncs = [];
              }
              wireBeans(e3) {
                this.colModel = e3.colModel;
              }
              postConstruct() {
                this.processDataTypeDefinitions(), this.addManagedPropertyListener("dataTypeDefinitions", (e3) => {
                  this.processDataTypeDefinitions(), this.colModel.recreateColumnDefs((0, u._convertColumnEventSourceType)(e3.source));
                });
              }
              processDataTypeDefinitions() {
                var _a;
                const e3 = this.getDefaultDataTypes(), t3 = {};
                this.dataTypeDefinitions = t3;
                const a3 = {};
                this.formatValueFuncs = a3;
                const n2 = (e4) => (t4) => {
                  const { column: a4, node: n3, value: o3 } = t4;
                  let r3 = a4.getColDef().valueFormatter;
                  return r3 === e4.groupSafeValueFormatter && (r3 = e4.valueFormatter), this.beans.valueSvc.formatValue(a4, n3, o3, r3);
                };
                Object.entries(e3).forEach(([e4, o3]) => {
                  const r3 = __spreadProps(__spreadValues({}, o3), { groupSafeValueFormatter: f(o3, this.gos) });
                  t3[e4] = r3, a3[e4] = n2(r3);
                });
                const o2 = (_a = this.gos.get("dataTypeDefinitions")) != null ? _a : {}, r2 = {};
                this.dataTypeMatchers = r2, Object.entries(o2).forEach(([i2, l2]) => {
                  const s2 = this.processDataTypeDefinition(l2, o2, [i2], e3);
                  s2 && (t3[i2] = s2, l2.dataTypeMatcher && (r2[i2] = l2.dataTypeMatcher), a3[i2] = n2(s2));
                }), this.checkObjectValueHandlers(e3), ["dateString", "text", "number", "boolean", "date"].forEach((t4) => {
                  const a4 = r2[t4];
                  a4 && delete r2[t4], r2[t4] = a4 != null ? a4 : e3[t4].dataTypeMatcher;
                });
              }
              processDataTypeDefinition(e3, t3, a3, n2) {
                let o2;
                const r2 = e3.extendsDataType;
                if (e3.columnTypes && (this.isColumnTypeOverrideInDataTypeDefinitions = true), e3.extendsDataType === e3.baseDataType) {
                  let a4 = n2[r2];
                  const i2 = t3[r2];
                  if (a4 && i2 && (a4 = i2), !m(e3, a4, r2))
                    return;
                  o2 = p(a4, e3);
                } else {
                  if (a3.includes(r2))
                    return void (0, d._warn)(44);
                  const i2 = t3[r2];
                  if (!m(e3, i2, r2))
                    return;
                  const l2 = this.processDataTypeDefinition(i2, t3, [...a3, r2], n2);
                  if (!l2)
                    return;
                  o2 = p(l2, e3);
                }
                return __spreadProps(__spreadValues({}, o2), { groupSafeValueFormatter: f(o2, this.gos) });
              }
              updateColDefAndGetColumnType(e3, t3, a3) {
                let { cellDataType: n2 } = t3;
                const { field: o2 } = t3;
                if (void 0 === n2 && (n2 = e3.cellDataType), null != n2 && true !== n2 || (n2 = !!this.canInferCellDataType(e3, t3) && this.inferCellDataType(o2, a3)), !n2)
                  return void (e3.cellDataType = false);
                const r2 = this.dataTypeDefinitions[n2];
                if (r2)
                  return e3.cellDataType = n2, r2.groupSafeValueFormatter && (e3.valueFormatter = r2.groupSafeValueFormatter), r2.valueParser && (e3.valueParser = r2.valueParser), r2.suppressDefaultProperties || this.setColDefPropertiesForBaseDataType(e3, n2, r2, a3), r2.columnTypes;
                (0, d._warn)(47, { cellDataType: n2 });
              }
              addColumnListeners(e3) {
                if (!this.isPendingInference)
                  return;
                const t3 = this.columnStateUpdatesPendingInference[e3.getColId()];
                if (!t3)
                  return;
                const a3 = (e4) => {
                  t3.add(e4.key);
                };
                e3.addEventListener("columnStateUpdated", a3), this.columnStateUpdateListenerDestroyFuncs.push(() => e3.removeEventListener("columnStateUpdated", a3));
              }
              canInferCellDataType(e3, t3) {
                var _a;
                const { gos: a3 } = this;
                if (!(0, r._isClientSideRowModel)(a3))
                  return false;
                const n2 = { cellRenderer: true, valueGetter: true, valueParser: true, refData: true };
                if (v(t3, n2))
                  return false;
                const o2 = null === t3.type ? e3.type : t3.type;
                if (o2) {
                  const e4 = (_a = a3.get("columnTypes")) != null ? _a : {};
                  if ((0, u.convertColumnTypes)(o2).some((t4) => {
                    const a4 = e4[t4.trim()];
                    return a4 && v(a4, n2);
                  }))
                    return false;
                }
                return !v(e3, n2);
              }
              inferCellDataType(e3, t3) {
                var _a;
                if (!e3)
                  return;
                let a3;
                const n2 = this.getInitialData();
                if (n2) {
                  const t4 = e3.indexOf(".") >= 0 && !this.gos.get("suppressFieldDotNotation");
                  a3 = (0, s._getValueUsingField)(n2, e3, t4);
                } else
                  this.initWaitForRowData(t3);
                if (null == a3)
                  return;
                const [o2] = (_a = Object.entries(this.dataTypeMatchers).find(([e4, t4]) => t4(a3))) != null ? _a : ["object"];
                return o2;
              }
              getInitialData() {
                var _a;
                const e3 = this.gos.get("rowData");
                if (e3 == null ? void 0 : e3.length)
                  return e3[0];
                if (this.initialData)
                  return this.initialData;
                {
                  const e4 = (_a = this.beans.rowModel.rootNode) == null ? void 0 : _a.allLeafChildren;
                  if (e4 == null ? void 0 : e4.length)
                    return e4[0].data;
                }
                return null;
              }
              initWaitForRowData(e3) {
                if (this.columnStateUpdatesPendingInference[e3] = /* @__PURE__ */ new Set(), this.isPendingInference)
                  return;
                this.isPendingInference = true;
                const t3 = this.isColumnTypeOverrideInDataTypeDefinitions, { colAutosize: a3, eventSvc: n2 } = this.beans;
                t3 && a3 && (a3.shouldQueueResizeOperations = true);
                const [o2] = this.addManagedEventListeners({ rowDataUpdateStarted: (e4) => {
                  const { firstRowData: r2 } = e4;
                  r2 && (o2 == null ? void 0 : o2(), this.isPendingInference = false, this.processColumnsPendingInference(r2, t3), this.columnStateUpdatesPendingInference = {}, t3 && (a3 == null ? void 0 : a3.processResizeOperations()), n2.dispatchEvent({ type: "dataTypesInferred" }));
                } });
              }
              processColumnsPendingInference(e3, t3) {
                this.initialData = e3;
                const a3 = [];
                this.destroyColumnStateUpdateListeners();
                const n2 = {}, o2 = {};
                Object.entries(this.columnStateUpdatesPendingInference).forEach(([e4, r2]) => {
                  const i2 = this.colModel.getCol(e4);
                  if (!i2)
                    return;
                  const l2 = i2.getColDef();
                  if (!this.resetColDefIntoCol(i2, "cellDataTypeInferred"))
                    return;
                  const s2 = i2.getColDef();
                  if (t3 && s2.type && s2.type !== l2.type) {
                    const t4 = function(e5, t5) {
                      const a4 = (0, g.getColumnStateFromColDef)(e5);
                      return t5.forEach((e6) => {
                        delete a4[e6], "rowGroup" === e6 ? delete a4.rowGroupIndex : "pivot" === e6 && delete a4.pivotIndex;
                      }), a4;
                    }(i2, r2);
                    t4.rowGroup && null == t4.rowGroupIndex && (n2[e4] = t4), t4.pivot && null == t4.pivotIndex && (o2[e4] = t4), a3.push(t4);
                  }
                }), t3 && a3.push(...this.generateColumnStateForRowGroupAndPivotIndexes(n2, o2)), a3.length && (0, g._applyColumnState)(this.beans, { state: a3 }, "cellDataTypeInferred"), this.initialData = null;
              }
              generateColumnStateForRowGroupAndPivotIndexes(e3, t3) {
                const a3 = {}, { rowGroupColsSvc: n2, pivotColsSvc: o2 } = this.beans;
                return n2 == null ? void 0 : n2.restoreColumnOrder(a3, e3), o2 == null ? void 0 : o2.restoreColumnOrder(a3, t3), Object.values(a3);
              }
              resetColDefIntoCol(e3, t3) {
                const a3 = e3.getUserProvidedColDef();
                if (!a3)
                  return false;
                const n2 = (0, c._addColumnDefaultAndTypes)(this.beans, a3, e3.getColId());
                return e3.setColDef(n2, a3, t3), true;
              }
              checkObjectValueHandlers(e3) {
                const t3 = this.dataTypeDefinitions.object, a3 = e3.object;
                this.hasObjectValueParser = t3.valueParser !== a3.valueParser, this.hasObjectValueFormatter = t3.valueFormatter !== a3.valueFormatter;
              }
              getDateStringTypeDefinition(e3) {
                var _a;
                const { dateString: t3 } = this.dataTypeDefinitions;
                return e3 ? (_a = this.getDataTypeDefinition(e3)) != null ? _a : t3 : t3;
              }
              getDateParserFunction(e3) {
                return this.getDateStringTypeDefinition(e3).dateParser;
              }
              getDateFormatterFunction(e3) {
                return this.getDateStringTypeDefinition(e3).dateFormatter;
              }
              getDataTypeDefinition(e3) {
                const t3 = e3.getColDef();
                if (t3.cellDataType)
                  return this.dataTypeDefinitions[t3.cellDataType];
              }
              getBaseDataType(e3) {
                var _a;
                return (_a = this.getDataTypeDefinition(e3)) == null ? void 0 : _a.baseDataType;
              }
              checkType(e3, t3) {
                var _a;
                if (null == t3)
                  return true;
                const a3 = (_a = this.getDataTypeDefinition(e3)) == null ? void 0 : _a.dataTypeMatcher;
                return !a3 || a3(t3);
              }
              validateColDef(e3) {
                const t3 = (e4) => (0, d._warn)(48, { property: e4 });
                if ("object" === e3.cellDataType) {
                  const { object: a3 } = this.dataTypeDefinitions;
                  e3.valueFormatter !== a3.groupSafeValueFormatter || this.hasObjectValueFormatter || t3("Formatter"), e3.editable && e3.valueParser === a3.valueParser && !this.hasObjectValueParser && t3("Parser");
                }
              }
              getFormatValue(e3) {
                return this.formatValueFuncs[e3];
              }
              isColPendingInference(e3) {
                return this.isPendingInference && !!this.columnStateUpdatesPendingInference[e3];
              }
              setColDefPropertiesForBaseDataType(e3, t3, a3, o2) {
                var _a;
                const r2 = this.formatValueFuncs[t3];
                switch (a3.baseDataType) {
                  case "number":
                    e3.cellEditor = "agNumberCellEditor";
                    break;
                  case "boolean":
                    e3.cellEditor = "agCheckboxCellEditor", e3.cellRenderer = "agCheckboxCellRenderer", e3.suppressKeyboardEvent = (e4) => !!e4.colDef.editable && e4.event.key === n.KeyCode.SPACE;
                    break;
                  case "date":
                    e3.cellEditor = "agDateCellEditor", e3.keyCreator = r2;
                    break;
                  case "dateString":
                    e3.cellEditor = "agDateStringCellEditor", e3.keyCreator = r2;
                    break;
                  case "object":
                    e3.cellEditorParams = { useFormatter: true }, e3.comparator = (e4, t4) => {
                      const a4 = this.colModel.getColDefCol(o2), n2 = a4 == null ? void 0 : a4.getColDef();
                      if (!a4 || !n2)
                        return 0;
                      const i2 = null == e4 ? "" : r2({ column: a4, node: null, value: e4 }), l2 = null == t4 ? "" : r2({ column: a4, node: null, value: t4 });
                      return i2 === l2 ? 0 : i2 > l2 ? 1 : -1;
                    }, e3.keyCreator = r2;
                }
                (_a = this.beans.filterManager) == null ? void 0 : _a.setColDefPropertiesForDataType(e3, a3, r2);
              }
              getDefaultDataTypes() {
                const e3 = (e4) => !!e4.match("^\\d{4}-\\d{2}-\\d{2}$"), t3 = this.getLocaleTextFunc();
                return { number: { baseDataType: "number", valueParser: (e4) => {
                  var _a, _b;
                  return "" === ((_b = (_a = e4.newValue) == null ? void 0 : _a.trim) == null ? void 0 : _b.call(_a)) ? null : Number(e4.newValue);
                }, valueFormatter: (e4) => null == e4.value ? "" : "number" != typeof e4.value || isNaN(e4.value) ? t3("invalidNumber", "Invalid Number") : String(e4.value), dataTypeMatcher: (e4) => "number" == typeof e4 }, text: { baseDataType: "text", valueParser: (e4) => "" === e4.newValue ? null : (0, l._toStringOrNull)(e4.newValue), dataTypeMatcher: (e4) => "string" == typeof e4 }, boolean: { baseDataType: "boolean", valueParser: (e4) => {
                  var _a, _b;
                  return null == e4.newValue ? e4.newValue : "" === ((_b = (_a = e4.newValue) == null ? void 0 : _a.trim) == null ? void 0 : _b.call(_a)) ? null : "true" === String(e4.newValue).toLowerCase();
                }, valueFormatter: (e4) => null == e4.value ? "" : String(e4.value), dataTypeMatcher: (e4) => "boolean" == typeof e4 }, date: { baseDataType: "date", valueParser: (e4) => (0, i._parseDateTimeFromString)(null == e4.newValue ? null : String(e4.newValue)), valueFormatter: (e4) => {
                  var _a;
                  return null == e4.value ? "" : e4.value instanceof Date && !isNaN(e4.value.getTime()) ? (_a = (0, i._serialiseDate)(e4.value, false)) != null ? _a : "" : t3("invalidDate", "Invalid Date");
                }, dataTypeMatcher: (e4) => e4 instanceof Date }, dateString: { baseDataType: "dateString", dateParser: (e4) => {
                  var _a;
                  return (_a = (0, i._parseDateTimeFromString)(e4)) != null ? _a : void 0;
                }, dateFormatter: (e4) => {
                  var _a;
                  return (_a = (0, i._serialiseDate)(e4 != null ? e4 : null, false)) != null ? _a : void 0;
                }, valueParser: (t4) => e3(String(t4.newValue)) ? t4.newValue : null, valueFormatter: (t4) => e3(String(t4.value)) ? t4.value : "", dataTypeMatcher: (t4) => "string" == typeof t4 && e3(t4) }, object: { baseDataType: "object", valueParser: () => null, valueFormatter: (e4) => {
                  var _a;
                  return (_a = (0, l._toStringOrNull)(e4.value)) != null ? _a : "";
                } } };
              }
              destroyColumnStateUpdateListeners() {
                this.columnStateUpdateListenerDestroyFuncs.forEach((e3) => e3()), this.columnStateUpdateListenerDestroyFuncs = [];
              }
              destroy() {
                this.dataTypeDefinitions = {}, this.dataTypeMatchers = {}, this.formatValueFuncs = {}, this.columnStateUpdatesPendingInference = {}, this.destroyColumnStateUpdateListeners(), super.destroy();
              }
            }
            function p(e3, t3) {
              const a3 = __spreadValues(__spreadValues({}, e3), t3);
              return e3.columnTypes && t3.columnTypes && t3.appendColumnTypes && (a3.columnTypes = [...(0, u.convertColumnTypes)(e3.columnTypes), ...(0, u.convertColumnTypes)(t3.columnTypes)]), a3;
            }
            function m(e3, t3, a3) {
              return t3 ? t3.baseDataType === e3.baseDataType || ((0, d._warn)(46), false) : ((0, d._warn)(45, { parentCellDataType: a3 }), false);
            }
            function f(e3, t3) {
              if (e3.valueFormatter)
                return (a3) => {
                  var _a, _b, _c;
                  if ((_a = a3.node) == null ? void 0 : _a.group) {
                    const n2 = ((_b = a3.colDef.pivotValueColumn) != null ? _b : a3.column).getAggFunc();
                    if (n2) {
                      if ("first" === n2 || "last" === n2)
                        return e3.valueFormatter(a3);
                      if ("number" === e3.baseDataType && "count" !== n2) {
                        if ("number" == typeof a3.value)
                          return e3.valueFormatter(a3);
                        if ("object" == typeof a3.value) {
                          if (!a3.value)
                            return;
                          if ("toNumber" in a3.value)
                            return e3.valueFormatter(__spreadProps(__spreadValues({}, a3), { value: a3.value.toNumber() }));
                          if ("value" in a3.value)
                            return e3.valueFormatter(__spreadProps(__spreadValues({}, a3), { value: a3.value.value }));
                        }
                      }
                      return;
                    }
                    if ("groupRows" === t3.get("groupDisplayType") && !t3.get("treeData"))
                      return;
                  } else if (t3.get("groupHideOpenParents") && a3.column.isRowGroupActive() && "string" == typeof a3.value && !((_c = e3.dataTypeMatcher) == null ? void 0 : _c.call(e3, a3.value)))
                    return;
                  return e3.valueFormatter(a3);
                };
            }
            function v(e3, t3) {
              return [["cellRenderer", "agSparklineCellRenderer"], ["valueGetter", void 0], ["valueParser", void 0], ["refData", void 0]].some(([a3, n2]) => function(e4, t4, a4, n3) {
                if (!t4[a4])
                  return false;
                const o2 = e4[a4];
                return null === o2 ? (t4[a4] = false, false) : void 0 === n3 ? !!o2 : o2 === n3;
              }(e3, t3, a3, n2));
            }
            t2.DataTypeService = h;
          }, 6034: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.GroupInstanceIdCreator = void 0;
            t2.GroupInstanceIdCreator = class {
              constructor() {
                this.existingIds = {};
              }
              getInstanceIdForKey(e3) {
                const t3 = this.existingIds[e3];
                let a2;
                return a2 = "number" != typeof t3 ? 0 : t3 + 1, this.existingIds[e3] = a2, a2;
              }
            };
          }, 5626: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.SelectionColService = t2.CONTROLS_COLUMN_ID_PREFIX = void 0;
            const n = a2(8731), o = a2(3355), r = a2(7274), i = a2(5266), l = a2(3146);
            t2.CONTROLS_COLUMN_ID_PREFIX = "ag-Grid-SelectionColumn";
            class s extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "selectionColSvc";
              }
              postConstruct() {
                this.addManagedPropertyListener("rowSelection", (e3) => {
                  this.onSelectionOptionsChanged(e3.currentValue, e3.previousValue, (0, l._convertColumnEventSourceType)(e3.source));
                });
              }
              addSelectionCols(e3) {
                const t3 = this.selectionCols;
                null != t3 && (e3.list = t3.list.concat(e3.list), e3.tree = t3.tree.concat(e3.tree), (0, l._updateColsMap)(e3));
              }
              createSelectionCols(e3, t3) {
                var _a, _b, _c, _d, _e, _f;
                const a3 = e3.treeDepth, n2 = ((_b = (_a = this.selectionCols) == null ? void 0 : _a.treeDepth) != null ? _b : -1) == a3, o2 = this.generateSelectionCols();
                if ((0, l._areColIdsEqual)(o2, (_d = (_c = this.selectionCols) == null ? void 0 : _c.list) != null ? _d : []) && n2)
                  return;
                (() => {
                  var _a2;
                  (0, l._destroyColumnTree)(this.beans, (_a2 = this.selectionCols) == null ? void 0 : _a2.tree), this.selectionCols = null;
                })();
                const { colGroupSvc: r2 } = this.beans, i2 = (_e = r2 == null ? void 0 : r2.findDepth(e3.tree)) != null ? _e : 0, s2 = (_f = r2 == null ? void 0 : r2.balanceTreeForAutoCols(o2, i2)) != null ? _f : [];
                this.selectionCols = { list: o2, tree: s2, treeDepth: i2, map: {} };
                t3((e4) => {
                  if (!e4)
                    return null;
                  const t4 = e4.filter((e5) => !(0, l.isColumnSelectionCol)(e5));
                  return [...o2, ...t4];
                });
              }
              isSelectionColumnEnabled() {
                var _a, _b, _c;
                const { gos: e3, beans: t3 } = this, a3 = e3.get("rowSelection");
                if ("object" != typeof a3 || !(0, r._isRowSelection)(e3))
                  return false;
                const n2 = ((_c = (_b = (_a = t3.autoColSvc) == null ? void 0 : _a.getAutoCols()) == null ? void 0 : _b.length) != null ? _c : 0) > 0;
                if ("autoGroupColumn" === a3.checkboxLocation && n2)
                  return false;
                const o2 = !!(0, r._getCheckboxes)(a3), i2 = (0, r._getHeaderCheckbox)(a3);
                return o2 || i2;
              }
              generateSelectionCols() {
                if (!this.isSelectionColumnEnabled())
                  return [];
                const { gos: e3, validation: a3 } = this.beans, n2 = e3.get("selectionColumnDef"), r2 = __spreadProps(__spreadValues({ width: 50, resizable: false, suppressHeaderMenuButton: true, sortable: false, suppressMovable: true, lockPosition: e3.get("enableRtl") ? "right" : "left", comparator(e4, t3, a4, n3) {
                  const o2 = a4.isSelected();
                  return o2 === n3.isSelected() ? 0 : o2 ? 1 : -1;
                }, editable: false, suppressFillHandle: true }, n2), { colId: t2.CONTROLS_COLUMN_ID_PREFIX }), i2 = r2.colId;
                a3 == null ? void 0 : a3.validateColDef(r2, i2, true);
                const l2 = new o.AgColumn(r2, null, i2, false);
                return this.createBean(l2), [l2];
              }
              putSelectionColsFirstInList(e3, t3) {
                if (!t3)
                  return null;
                return [...e3, ...t3.filter((e4) => !(0, l.isColumnSelectionCol)(e4))];
              }
              getSelectionCol(e3) {
                var _a, _b;
                return (_b = (_a = this.selectionCols) == null ? void 0 : _a.list.find((t3) => (0, l._columnsMatch)(t3, e3))) != null ? _b : null;
              }
              getSelectionCols() {
                var _a, _b;
                return (_b = (_a = this.selectionCols) == null ? void 0 : _a.list) != null ? _b : null;
              }
              onSelectionOptionsChanged(e3, t3, a3) {
                const n2 = (t3 && "string" != typeof t3 ? (0, r._getCheckboxes)(t3) : void 0) !== (e3 && "string" != typeof e3 ? (0, r._getCheckboxes)(e3) : void 0), o2 = (t3 && "string" != typeof t3 ? (0, r._getHeaderCheckbox)(t3) : void 0) !== (e3 && "string" != typeof e3 ? (0, r._getHeaderCheckbox)(e3) : void 0), i2 = (0, r._getCheckboxLocation)(e3), l2 = (0, r._getCheckboxLocation)(t3);
                (n2 || o2 || i2 !== l2) && this.beans.colModel.refreshAll(a3);
              }
              destroy() {
                var _a;
                (0, l._destroyColumnTree)(this.beans, (_a = this.selectionCols) == null ? void 0 : _a.tree), super.destroy();
              }
              refreshVisibility(e3) {
                var _a;
                if (!this.isSelectionColumnEnabled())
                  return;
                const t3 = this.beans, a3 = (_a = t3.visibleCols.getAllTrees()) != null ? _a : [];
                if (0 !== a3.length) {
                  if (!a3.some(d)) {
                    const a4 = (0, i._getColumnState)(t3).find((e4) => (0, l.isColumnSelectionCol)(e4.colId));
                    a4 && (0, i._applyColumnState)(t3, { state: [{ colId: a4.colId, hide: !a4.hide }] }, e3);
                  }
                  if (1 === a3.length) {
                    const n2 = c(a3[0]);
                    if (!n2)
                      return;
                    (0, i._applyColumnState)(t3, { state: [{ colId: n2.getColId(), hide: true }] }, e3);
                  }
                }
              }
            }
            t2.SelectionColService = s;
            const d = (e3) => {
              var _a, _b;
              return e3.isColumn ? (0, l.isColumnSelectionCol)(e3) : (_b = (_a = e3.getChildren()) == null ? void 0 : _a.some(d)) != null ? _b : false;
            };
            function c(e3) {
              var _a;
              if (e3.isColumn)
                return (0, l.isColumnSelectionCol)(e3) ? e3 : null;
              const t3 = (_a = e3.getChildren()) != null ? _a : [];
              for (const e4 of t3) {
                const t4 = c(e4);
                if (t4)
                  return t4;
              }
              return null;
            }
          }, 6869: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.depthFirstAllColumnTreeSearch = t2.VisibleColsService = void 0;
            const n = a2(8731), o = a2(3355), r = a2(6908), i = a2(1502), l = a2(3146), s = a2(6034);
            class d extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "visibleCols", this.colsAndGroupsMap = {}, this.leftCols = [], this.rightCols = [], this.centerCols = [], this.allCols = [], this.bodyWidth = 0, this.leftWidth = 0, this.rightWidth = 0, this.isBodyWidthDirty = true;
              }
              refresh(e3, t3 = false) {
                var _a;
                const { colModel: a3, colGroupSvc: n2, colViewport: o2 } = this.beans;
                t3 || this.buildTrees(a3, n2), n2 == null ? void 0 : n2.updateOpenClosedVisibility();
                const r2 = g(this.treeLeft);
                this.leftCols = r2, this.centerCols = g(this.treeCenter);
                const i2 = g(this.treeRight);
                this.rightCols = i2, this.joinColsAriaOrder(a3), this.joinCols(), this.setLeftValues(e3), this.autoHeightCols = this.allCols.filter((e4) => e4.isAutoHeight()), (_a = this.beans.colFlex) == null ? void 0 : _a.refreshFlexedColumns(), this.updateBodyWidths(), o2.checkViewportColumns(false), this.setFirstRightAndLastLeftPinned(a3, r2, i2, e3), this.eventSvc.dispatchEvent({ type: "displayedColumnsChanged", source: e3 });
              }
              updateBodyWidths() {
                const e3 = (0, l.getWidthOfColsInList)(this.centerCols), t3 = (0, l.getWidthOfColsInList)(this.leftCols), a3 = (0, l.getWidthOfColsInList)(this.rightCols);
                this.isBodyWidthDirty = this.bodyWidth !== e3;
                (this.bodyWidth !== e3 || this.leftWidth !== t3 || this.rightWidth !== a3) && (this.bodyWidth = e3, this.leftWidth = t3, this.rightWidth = a3, this.eventSvc.dispatchEvent({ type: "columnContainerWidthChanged" }), this.eventSvc.dispatchEvent({ type: "displayedColumnsWidthChanged" }));
              }
              setLeftValues(e3) {
                this.setLeftValuesOfCols(e3), this.setLeftValuesOfGroups();
              }
              setFirstRightAndLastLeftPinned(e3, t3, a3, n2) {
                let o2, r2;
                this.gos.get("enableRtl") ? (o2 = t3 ? t3[0] : null, r2 = a3 ? (0, i._last)(a3) : null) : (o2 = t3 ? (0, i._last)(t3) : null, r2 = a3 ? a3[0] : null), e3.getCols().forEach((e4) => {
                  e4.setLastLeftPinned(e4 === o2, n2), e4.setFirstRightPinned(e4 === r2, n2);
                });
              }
              buildTrees(e3, t3) {
                const a3 = e3.getColsToShow(), n2 = a3.filter((e4) => "left" == e4.getPinned()), o2 = a3.filter((e4) => "right" == e4.getPinned()), r2 = a3.filter((e4) => "left" != e4.getPinned() && "right" != e4.getPinned()), i2 = new s.GroupInstanceIdCreator(), l2 = (e4) => t3 ? t3.createColumnGroups(e4) : e4.columns;
                this.treeLeft = l2({ columns: n2, idCreator: i2, pinned: "left", oldDisplayedGroups: this.treeLeft }), this.treeRight = l2({ columns: o2, idCreator: i2, pinned: "right", oldDisplayedGroups: this.treeRight }), this.treeCenter = l2({ columns: r2, idCreator: i2, pinned: null, oldDisplayedGroups: this.treeCenter }), this.updateColsAndGroupsMap();
              }
              clear() {
                this.leftCols = [], this.rightCols = [], this.centerCols = [], this.allCols = [], this.ariaOrderColumns = [];
              }
              joinColsAriaOrder(e3) {
                const t3 = e3.getCols(), a3 = [], n2 = [], o2 = [];
                for (const e4 of t3) {
                  const t4 = e4.getPinned();
                  t4 ? true === t4 || "left" === t4 ? a3.push(e4) : o2.push(e4) : n2.push(e4);
                }
                this.ariaOrderColumns = a3.concat(n2).concat(o2);
              }
              getAriaColIndex(e3) {
                let t3;
                return t3 = (0, r.isColumnGroup)(e3) ? e3.getLeafColumns()[0] : e3, this.ariaOrderColumns.indexOf(t3) + 1;
              }
              setLeftValuesOfGroups() {
                [this.treeLeft, this.treeRight, this.treeCenter].forEach((e3) => {
                  e3.forEach((e4) => {
                    if ((0, r.isColumnGroup)(e4)) {
                      e4.checkLeft();
                    }
                  });
                });
              }
              setLeftValuesOfCols(e3) {
                const { colModel: t3 } = this.beans;
                if (!t3.getColDefCols())
                  return;
                const a3 = t3.getCols().slice(0), n2 = this.gos.get("enableRtl");
                [this.leftCols, this.rightCols, this.centerCols].forEach((t4) => {
                  if (n2) {
                    let a4 = (0, l.getWidthOfColsInList)(t4);
                    t4.forEach((t5) => {
                      a4 -= t5.getActualWidth(), t5.setLeft(a4, e3);
                    });
                  } else {
                    let a4 = 0;
                    t4.forEach((t5) => {
                      t5.setLeft(a4, e3), a4 += t5.getActualWidth();
                    });
                  }
                  !function(e4, t5) {
                    for (let a4 = 0; a4 < t5.length; a4++) {
                      const n3 = e4.indexOf(t5[a4]);
                      n3 >= 0 && (e4[n3] = e4[e4.length - 1], e4.pop());
                    }
                  }(a3, t4);
                }), a3.forEach((t4) => {
                  t4.setLeft(null, e3);
                });
              }
              joinCols() {
                this.gos.get("enableRtl") ? this.allCols = this.rightCols.concat(this.centerCols).concat(this.leftCols) : this.allCols = this.leftCols.concat(this.centerCols).concat(this.rightCols);
              }
              getAllTrees() {
                return this.treeLeft && this.treeRight && this.treeCenter ? this.treeLeft.concat(this.treeCenter).concat(this.treeRight) : null;
              }
              isColDisplayed(e3) {
                return this.allCols.indexOf(e3) >= 0;
              }
              getLeftColsForRow(e3) {
                const { leftCols: t3, beans: { colModel: a3 } } = this;
                return a3.colSpanActive ? this.getColsForRow(e3, t3) : t3;
              }
              getRightColsForRow(e3) {
                const { rightCols: t3, beans: { colModel: a3 } } = this;
                return a3.colSpanActive ? this.getColsForRow(e3, t3) : t3;
              }
              getColsForRow(e3, t3, a3, n2) {
                const o2 = [];
                let r2 = null;
                for (let i2 = 0; i2 < t3.length; i2++) {
                  const l2 = t3[i2], s2 = t3.length - i2, d2 = Math.min(l2.getColSpan(e3), s2), c2 = [l2];
                  if (d2 > 1) {
                    const e4 = d2 - 1;
                    for (let a4 = 1; a4 <= e4; a4++)
                      c2.push(t3[i2 + a4]);
                    i2 += e4;
                  }
                  let g2;
                  if (a3 ? (g2 = false, c2.forEach((e4) => {
                    a3(e4) && (g2 = true);
                  })) : g2 = true, g2) {
                    if (0 === o2.length && r2) {
                      !!n2 && n2(l2) && o2.push(r2);
                    }
                    o2.push(l2);
                  }
                  r2 = l2;
                }
                return o2;
              }
              getContainerWidth(e3) {
                switch (e3) {
                  case "left":
                    return this.leftWidth;
                  case "right":
                    return this.rightWidth;
                  default:
                    return this.bodyWidth;
                }
              }
              getColBefore(e3) {
                const t3 = this.allCols, a3 = t3.indexOf(e3);
                return a3 > 0 ? t3[a3 - 1] : null;
              }
              isPinningLeft() {
                return this.leftCols.length > 0;
              }
              isPinningRight() {
                return this.rightCols.length > 0;
              }
              updateColsAndGroupsMap() {
                this.colsAndGroupsMap = {};
                const e3 = (e4) => {
                  this.colsAndGroupsMap[e4.getUniqueId()] = e4;
                };
                c(this.treeCenter, false, e3), c(this.treeLeft, false, e3), c(this.treeRight, false, e3);
              }
              isVisible(e3) {
                return this.colsAndGroupsMap[e3.getUniqueId()] === e3;
              }
              getFirstColumn() {
                const e3 = this.gos.get("enableRtl"), t3 = ["leftCols", "centerCols", "rightCols"];
                e3 && t3.reverse();
                for (let a3 = 0; a3 < t3.length; a3++) {
                  const n2 = this[t3[a3]];
                  if (n2.length)
                    return e3 ? (0, i._last)(n2) : n2[0];
                }
                return null;
              }
              getColAfter(e3) {
                const t3 = this.allCols, a3 = t3.indexOf(e3);
                return a3 < t3.length - 1 ? t3[a3 + 1] : null;
              }
              getColsLeftWidth() {
                return (0, l.getWidthOfColsInList)(this.leftCols);
              }
              getDisplayedColumnsRightWidth() {
                return (0, l.getWidthOfColsInList)(this.rightCols);
              }
              isColAtEdge(e3, t3) {
                const a3 = this.allCols;
                if (!a3.length)
                  return false;
                const n2 = "first" === t3;
                let o2;
                if ((0, r.isColumnGroup)(e3)) {
                  const t4 = e3.getDisplayedLeafColumns();
                  if (!t4.length)
                    return false;
                  o2 = n2 ? t4[0] : (0, i._last)(t4);
                } else
                  o2 = e3;
                return (n2 ? a3[0] : (0, i._last)(a3)) === o2;
              }
            }
            function c(e3, t3, a3) {
              if (e3)
                for (let n2 = 0; n2 < e3.length; n2++) {
                  const o2 = e3[n2];
                  if ((0, r.isColumnGroup)(o2)) {
                    c(t3 ? o2.getDisplayedChildren() : o2.getChildren(), t3, a3);
                  }
                  a3(o2);
                }
            }
            function g(e3) {
              const t3 = [];
              return c(e3, true, (e4) => {
                (0, o.isColumn)(e4) && t3.push(e4);
              }), t3;
            }
            t2.VisibleColsService = d, t2.depthFirstAllColumnTreeSearch = c;
          }, 3789: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.setupCompBean = t2.EmptyBean = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
            }
            t2.EmptyBean = o, t2.setupCompBean = function(e3, t3, a3) {
              return a3 && e3.addDestroyFunc(() => t3.destroyBean(a3)), a3 != null ? a3 : e3;
            };
          }, 4309: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.AgComponentUtils = void 0;
            const n = a2(8731), o = a2(3507);
            class r extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "agCompUtils";
              }
              adaptFunction(e3, t3) {
                if (!e3.cellRenderer)
                  return null;
                return class {
                  refresh() {
                    return false;
                  }
                  getGui() {
                    return this.eGui;
                  }
                  init(e4) {
                    const a3 = t3(e4), n2 = typeof a3;
                    this.eGui = "string" !== n2 && "number" !== n2 && "boolean" !== n2 ? null != a3 ? a3 : (0, o._loadTemplate)("<span></span>") : (0, o._loadTemplate)("<span>" + a3 + "</span>");
                  }
                };
              }
            }
            t2.AgComponentUtils = r;
          }, 8414: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.CellRendererFunctionModule = void 0;
            const n = a2(7205), o = a2(4309);
            t2.CellRendererFunctionModule = { moduleName: "CellRendererFunction", version: n.VERSION, beans: [o.AgComponentUtils] };
          }, 8759: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.BaseComponentWrapper = void 0;
            const n = a2(7764);
            t2.BaseComponentWrapper = class {
              wrap(e3, t3, a3, n2) {
                const o = this.createWrapper(e3, n2);
                return t3 == null ? void 0 : t3.forEach((e4) => {
                  this.createMethod(o, e4, true);
                }), a3 == null ? void 0 : a3.forEach((e4) => {
                  this.createMethod(o, e4, false);
                }), o;
              }
              createMethod(e3, t3, a3) {
                e3.addMethod(t3, this.createMethodProxy(e3, t3, a3));
              }
              createMethodProxy(e3, t3, a3) {
                return function() {
                  return e3.hasMethod(t3) ? e3.callMethod(t3, arguments) : (a3 && (0, n._warn)(49, { methodName: t3 }), null);
                };
              }
            };
          }, 4110: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.Registry = void 0;
            const n = a2(8731), o = a2(7764);
            class r extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "registry", this.agGridDefaults = {}, this.agGridDefaultParams = {}, this.jsComps = {}, this.dynamicBeans = {}, this.selectors = {}, this.icons = {};
              }
              postConstruct() {
                const e3 = this.gos.get("components");
                null != e3 && Object.entries(e3).forEach(([e4, t3]) => {
                  this.jsComps[e4] = t3;
                });
              }
              registerModule(e3) {
                const { icons: t3, userComponents: a3, dynamicBeans: n2, selectors: o2 } = e3;
                if (a3) {
                  const e4 = (e5, t4, a4) => {
                    this.agGridDefaults[e5] = t4, a4 && (this.agGridDefaultParams[e5] = a4);
                  };
                  for (const t4 of Object.keys(a3)) {
                    const n3 = a3[t4];
                    "object" == typeof n3 ? e4(t4, n3.classImp, n3.params) : e4(t4, n3);
                  }
                }
                if (n2)
                  for (const e4 of Object.keys(n2))
                    this.dynamicBeans[e4] = n2[e4];
                if (o2 == null ? void 0 : o2.forEach((e4) => {
                  this.selectors[e4.selector] = e4;
                }), t3)
                  for (const e4 of Object.keys(t3))
                    this.icons[e4] = t3[e4];
              }
              getUserComponent(e3, t3) {
                var _a;
                const a3 = (e4, t4, a4) => ({ componentFromFramework: t4, component: e4, params: a4 }), { frameworkOverrides: n2 } = this.beans, o2 = n2.frameworkComponent(t3, this.gos.get("components"));
                if (null != o2)
                  return a3(o2, true);
                const r2 = this.jsComps[t3];
                if (r2) {
                  return a3(r2, n2.isFrameworkComponent(r2));
                }
                const i = this.agGridDefaults[t3];
                return i ? a3(i, false, this.agGridDefaultParams[t3]) : ((_a = this.beans.validation) == null ? void 0 : _a.missingUserComponent(e3, t3, this.agGridDefaults, this.jsComps), null);
              }
              createDynamicBean(e3, t3, ...a3) {
                const n2 = this.dynamicBeans[e3];
                if (null != n2)
                  return new n2(...a3);
                if (t3)
                  throw new Error((0, o._errMsg)(256));
              }
              getSelector(e3) {
                return this.selectors[e3];
              }
              getIcon(e3) {
                return this.icons[e3];
              }
            }
            t2.Registry = r;
          }, 4126: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2._unwrapUserComp = void 0, t2._unwrapUserComp = function(e3) {
              const t3 = e3;
              return null != t3 && null != t3.getFrameworkComponentInstance ? t3.getFrameworkComponentInstance() : e3;
            };
          }, 2036: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2._mergeFilterParamsWithApplicationProvidedParams = t2._getFilterCompKeys = t2._getFloatingFilterCompDetails = t2._getTooltipCompDetails = t2._getNoRowsOverlayCompDetails = t2._getLoadingOverlayCompDetails = t2._getDateCompDetails = t2._getFilterDetails = t2._getCellEditorDetails = t2._getLoadingCellRendererDetails = t2._getEditorRendererDetails = t2._getCellRendererDetails = t2._getFullWidthDetailCellRendererDetails = t2._getFullWidthGroupCellRendererDetails = t2._getFullWidthLoadingCellRendererDetails = t2._getFullWidthCellRendererDetails = t2._getInnerHeaderGroupCompDetails = t2._getHeaderGroupCompDetails = t2._getInnerHeaderCompDetails = t2._getHeaderCompDetails = t2._getInnerCellRendererDetails = t2._getDragAndDropImageCompDetails = void 0;
            const n = a2(1585), o = { name: "dateComponent", mandatoryMethods: ["getDate", "setDate"], optionalMethods: ["afterGuiAttached", "setInputPlaceholder", "setInputAriaLabel", "setDisabled", "refresh"] }, r = { name: "dragAndDropImageComponent", mandatoryMethods: ["setIcon", "setLabel"] }, i = { name: "headerComponent", optionalMethods: ["refresh"] }, l = { name: "innerHeaderComponent" }, s = { name: "innerHeaderGroupComponent" }, d = { name: "headerGroupComponent" }, c = { name: "innerRenderer", cellRenderer: true, optionalMethods: ["afterGuiAttached"] }, g = { name: "cellRenderer", optionalMethods: ["refresh", "afterGuiAttached"], cellRenderer: true }, u = { name: "cellRenderer", optionalMethods: ["refresh", "afterGuiAttached"] }, h = { name: "loadingCellRenderer", cellRenderer: true }, p = { name: "cellEditor", mandatoryMethods: ["getValue"], optionalMethods: ["isPopup", "isCancelBeforeStart", "isCancelAfterEnd", "getPopupPosition", "focusIn", "focusOut", "afterGuiAttached", "refresh"] }, m = { name: "loadingOverlayComponent", optionalMethods: ["refresh"] }, f = { name: "noRowsOverlayComponent", optionalMethods: ["refresh"] }, v = { name: "tooltipComponent" }, b = { name: "filter", mandatoryMethods: ["isFilterActive", "doesFilterPass", "getModel", "setModel"], optionalMethods: ["afterGuiAttached", "afterGuiDetached", "onNewRowsLoaded", "getModelAsString", "onFloatingFilterChanged", "onAnyFilterChanged", "refresh"] }, C = { name: "floatingFilterComponent", mandatoryMethods: ["onParentModelChanged"], optionalMethods: ["afterGuiAttached", "refresh"] }, w = { name: "fullWidthCellRenderer", optionalMethods: ["refresh", "afterGuiAttached"], cellRenderer: true }, y = { name: "loadingCellRenderer", cellRenderer: true }, S = { name: "groupRowRenderer", optionalMethods: ["afterGuiAttached"], cellRenderer: true }, k = { name: "detailCellRenderer", optionalMethods: ["refresh"], cellRenderer: true };
            t2._getDragAndDropImageCompDetails = function(e3, t3) {
              return e3.getCompDetailsFromGridOptions(r, "agDragAndDropImage", t3, true);
            }, t2._getInnerCellRendererDetails = function(e3, t3, a3) {
              return e3.getCompDetails(t3, c, void 0, a3);
            }, t2._getHeaderCompDetails = function(e3, t3, a3) {
              return e3.getCompDetails(t3, i, "agColumnHeader", a3);
            }, t2._getInnerHeaderCompDetails = function(e3, t3, a3) {
              return e3.getCompDetails(t3, l, void 0, a3);
            }, t2._getHeaderGroupCompDetails = function(e3, t3) {
              const a3 = t3.columnGroup.getColGroupDef();
              return e3.getCompDetails(a3, d, "agColumnGroupHeader", t3);
            }, t2._getInnerHeaderGroupCompDetails = function(e3, t3, a3) {
              return e3.getCompDetails(t3, s, void 0, a3);
            }, t2._getFullWidthCellRendererDetails = function(e3, t3) {
              return e3.getCompDetailsFromGridOptions(w, void 0, t3, true);
            }, t2._getFullWidthLoadingCellRendererDetails = function(e3, t3) {
              return e3.getCompDetailsFromGridOptions(y, "agLoadingCellRenderer", t3, true);
            }, t2._getFullWidthGroupCellRendererDetails = function(e3, t3) {
              return e3.getCompDetailsFromGridOptions(S, "agGroupRowRenderer", t3, true);
            }, t2._getFullWidthDetailCellRendererDetails = function(e3, t3) {
              return e3.getCompDetailsFromGridOptions(k, "agDetailCellRenderer", t3, true);
            }, t2._getCellRendererDetails = function(e3, t3, a3) {
              return e3.getCompDetails(t3, g, void 0, a3);
            }, t2._getEditorRendererDetails = function(e3, t3, a3) {
              return e3.getCompDetails(t3, u, void 0, a3);
            }, t2._getLoadingCellRendererDetails = function(e3, t3, a3) {
              return e3.getCompDetails(t3, h, "agSkeletonCellRenderer", a3, true);
            }, t2._getCellEditorDetails = function(e3, t3, a3) {
              return e3.getCompDetails(t3, p, "agCellEditor", a3, true);
            }, t2._getFilterDetails = function(e3, t3, a3, n2) {
              return e3.getCompDetails(t3, b, n2, a3, true);
            }, t2._getDateCompDetails = function(e3, t3) {
              return e3.getCompDetailsFromGridOptions(o, "agDateInput", t3, true);
            }, t2._getLoadingOverlayCompDetails = function(e3, t3) {
              return e3.getCompDetailsFromGridOptions(m, "agLoadingOverlay", t3, true);
            }, t2._getNoRowsOverlayCompDetails = function(e3, t3) {
              return e3.getCompDetailsFromGridOptions(f, "agNoRowsOverlay", t3, true);
            }, t2._getTooltipCompDetails = function(e3, t3) {
              return e3.getCompDetails(t3.colDef, v, "agTooltipComponent", t3, true);
            }, t2._getFloatingFilterCompDetails = function(e3, t3, a3, n2) {
              return e3.getCompDetails(t3, C, n2, a3);
            }, t2._getFilterCompKeys = function(e3, t3) {
              return (0, n._getUserCompKeys)(e3, t3, b);
            }, t2._mergeFilterParamsWithApplicationProvidedParams = function(e3, t3, a3) {
              return e3.mergeParams(t3, b, a3);
            };
          }, 1585: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.UserComponentFactory = t2._getUserCompKeys = void 0;
            const n = a2(8731), o = a2(6996), r = a2(7990), i = a2(7764);
            function l(e3, t3, a3, n2) {
              const { name: o2 } = a3;
              let r2, i2, l2, s2, d, c;
              if (t3) {
                const a4 = t3, g = a4[o2 + "Selector"], u = g ? g(n2) : null, h = (t4) => {
                  if ("string" == typeof t4)
                    r2 = t4;
                  else if (null != t4 && true !== t4) {
                    e3.isFrameworkComponent(t4) ? l2 = t4 : i2 = t4;
                  }
                };
                u ? (h(u.component), s2 = u.params, d = u.popup, c = u.popupPosition) : h(a4[o2]);
              }
              return { compName: r2, jsComp: i2, fwComp: l2, paramsFromSelector: s2, popupFromSelector: d, popupPositionFromSelector: c };
            }
            t2._getUserCompKeys = l;
            class s extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "userCompFactory";
              }
              wireBeans(e3) {
                this.agCompUtils = e3.agCompUtils, this.registry = e3.registry, this.frameworkCompWrapper = e3.frameworkCompWrapper, this.gridOptions = e3.gridOptions;
              }
              getCompDetailsFromGridOptions(e3, t3, a3, n2 = false) {
                return this.getCompDetails(this.gridOptions, e3, t3, a3, n2);
              }
              getCompDetails(e3, t3, a3, n2, o2 = false) {
                var _a;
                const { name: r2, cellRenderer: s2 } = t3;
                let d, { compName: c, jsComp: g, fwComp: u, paramsFromSelector: h, popupFromSelector: p, popupPositionFromSelector: m } = l(this.beans.frameworkOverrides, e3, t3, n2);
                const f = (e4) => {
                  const t4 = this.registry.getUserComponent(r2, e4);
                  t4 && (g = t4.componentFromFramework ? void 0 : t4.component, u = t4.componentFromFramework ? t4.component : void 0, d = t4.params);
                };
                var v;
                if (null != c && f(c), null == g && null == u && null != a3 && f(a3), !g || !s2 || (v = g) && v.prototype && "getGui" in v.prototype || (g = (_a = this.agCompUtils) == null ? void 0 : _a.adaptFunction(t3, g)), !g && !u) {
                  const { validation: e4 } = this.beans;
                  return void (!o2 || c === a3 && a3 ? a3 && !e4 && (0, i._error)(146, { comp: a3 }) : c ? (e4 == null ? void 0 : e4.isProvidedUserComp(c)) || (0, i._error)(50, { compName: c }) : a3 ? e4 || (0, i._error)(260, __spreadProps(__spreadValues({}, this.gos.getModuleErrorParams()), { propName: r2, compName: a3 })) : (0, i._error)(216, { name: r2 }));
                }
                const b = this.mergeParams(e3, t3, n2, h, d), C = null == g, w = g != null ? g : u;
                return { componentFromFramework: C, componentClass: w, params: b, type: t3, popupFromSelector: p, popupPositionFromSelector: m, newAgStackInstance: () => this.newAgStackInstance(w, C, b, t3) };
              }
              newAgStackInstance(e3, t3, a3, n2) {
                var _a;
                let o2;
                o2 = !t3 ? new e3() : this.frameworkCompWrapper.wrap(e3, n2.mandatoryMethods, n2.optionalMethods, n2), this.createBean(o2);
                const i2 = (_a = o2.init) == null ? void 0 : _a.call(o2, a3);
                return null == i2 ? r.AgPromise.resolve(o2) : i2.then(() => o2);
              }
              mergeParams(e3, t3, a3, n2 = null, r2) {
                const i2 = this.gos.getGridCommonParams();
                (0, o._mergeDeep)(i2, a3), r2 && (0, o._mergeDeep)(i2, r2);
                const l2 = e3 && e3[t3.name + "Params"];
                if ("function" == typeof l2) {
                  const e4 = l2(a3);
                  (0, o._mergeDeep)(i2, e4);
                } else
                  "object" == typeof l2 && (0, o._mergeDeep)(i2, l2);
                return (0, o._mergeDeep)(i2, n2), i2;
              }
            }
            t2.UserComponentFactory = s;
          }, 9853: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.KeyCode = void 0, t2.KeyCode = { BACKSPACE: "Backspace", TAB: "Tab", ENTER: "Enter", ESCAPE: "Escape", SPACE: " ", LEFT: "ArrowLeft", UP: "ArrowUp", RIGHT: "ArrowRight", DOWN: "ArrowDown", DELETE: "Delete", F2: "F2", PAGE_UP: "PageUp", PAGE_DOWN: "PageDown", PAGE_HOME: "Home", PAGE_END: "End", A: "KeyA", C: "KeyC", D: "KeyD", V: "KeyV", X: "KeyX", Y: "KeyY", Z: "KeyZ" };
          }, 8731: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.BeanStub = void 0;
            const n = a2(5889), o = a2(7230), r = a2(2979);
            t2.BeanStub = class {
              constructor() {
                this.destroyFunctions = [], this.destroyed = false, this.__v_skip = true, this.propertyListenerId = 0, this.lastChangeSetIdLookup = {}, this.isAlive = () => !this.destroyed;
              }
              preWireBeans(e3) {
                this.beans = e3, this.stubContext = e3.context, this.eventSvc = e3.eventSvc, this.gos = e3.gos;
              }
              destroy() {
                const { destroyFunctions: e3 } = this;
                for (let t3 = 0; t3 < e3.length; t3++)
                  e3[t3]();
                e3.length = 0, this.destroyed = true, this.dispatchLocalEvent({ type: "destroyed" });
              }
              addEventListener(e3, t3, a3) {
                this.localEventService || (this.localEventService = new n.LocalEventService()), this.localEventService.addEventListener(e3, t3, a3);
              }
              removeEventListener(e3, t3, a3) {
                var _a;
                (_a = this.localEventService) == null ? void 0 : _a.removeEventListener(e3, t3, a3);
              }
              dispatchLocalEvent(e3) {
                var _a;
                (_a = this.localEventService) == null ? void 0 : _a.dispatchEvent(e3);
              }
              addManagedElementListeners(e3, t3) {
                return this._setupListeners(e3, t3);
              }
              addManagedEventListeners(e3) {
                return this._setupListeners(this.eventSvc, e3);
              }
              addManagedListeners(e3, t3) {
                return this._setupListeners(e3, t3);
              }
              _setupListeners(e3, t3) {
                const a3 = [];
                for (const n2 of Object.keys(t3)) {
                  const o2 = t3[n2];
                  o2 && a3.push(this._setupListener(e3, n2, o2));
                }
                return a3;
              }
              _setupListener(e3, t3, a3) {
                if (this.destroyed)
                  return () => null;
                e3 instanceof HTMLElement ? (0, r._addSafePassiveEventListener)(this.beans.frameworkOverrides, e3, t3, a3) : e3.addEventListener(t3, a3);
                const n2 = () => (e3.removeEventListener(t3, a3), null);
                return this.destroyFunctions.push(n2), () => (n2(), this.destroyFunctions = this.destroyFunctions.filter((e4) => e4 !== n2), null);
              }
              setupGridOptionListener(e3, t3) {
                const { gos: a3 } = this;
                a3.addPropertyEventListener(e3, t3);
                const n2 = () => (a3.removePropertyEventListener(e3, t3), null);
                return this.destroyFunctions.push(n2), () => (n2(), this.destroyFunctions = this.destroyFunctions.filter((e4) => e4 !== n2), null);
              }
              addManagedPropertyListener(e3, t3) {
                return this.destroyed ? () => null : this.setupGridOptionListener(e3, t3);
              }
              addManagedPropertyListeners(e3, t3) {
                if (this.destroyed)
                  return;
                const a3 = e3.join("-") + this.propertyListenerId++, n2 = (e4) => {
                  if (e4.changeSet) {
                    if (e4.changeSet && e4.changeSet.id === this.lastChangeSetIdLookup[a3])
                      return;
                    this.lastChangeSetIdLookup[a3] = e4.changeSet.id;
                  }
                  const n3 = { type: "gridPropertyChanged", changeSet: e4.changeSet, source: e4.source };
                  t3(n3);
                };
                e3.forEach((e4) => this.setupGridOptionListener(e4, n2));
              }
              getLocaleTextFunc() {
                return (0, o._getLocaleTextFunc)(this.beans.localeSvc);
              }
              addDestroyFunc(e3) {
                this.isAlive() ? this.destroyFunctions.push(e3) : e3();
              }
              createOptionalManagedBean(e3, t3) {
                return e3 ? this.createManagedBean(e3, t3) : void 0;
              }
              createManagedBean(e3, t3) {
                const a3 = this.createBean(e3, t3);
                return this.addDestroyFunc(this.destroyBean.bind(this, e3, t3)), a3;
              }
              createBean(e3, t3, a3) {
                return (t3 || this.stubContext).createBean(e3, a3);
              }
              destroyBean(e3, t3) {
                return (t3 || this.stubContext).destroyBean(e3);
              }
              destroyBeans(e3, t3) {
                return (t3 || this.stubContext).destroyBeans(e3);
              }
            };
          }, 2342: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.Context = void 0;
            const n = a2(2132), o = a2(569);
            class r extends o.GenericContext {
              init(e3) {
                this.gridId = e3.gridId, this.beans.context = this, this.destroyCallback = e3.destroyCallback, super.init(e3);
              }
              destroy() {
                var _a;
                super.destroy(), (0, n._unRegisterGridModules)(this.gridId), (_a = this.destroyCallback) == null ? void 0 : _a.call(this);
              }
              getGridId() {
                return this.gridId;
              }
            }
            t2.Context = r;
          }, 569: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.GenericContext = void 0;
            t2.GenericContext = class {
              constructor(e3) {
                this.beans = {}, this.createdBeans = [], this.destroyed = false, e3 && e3.beanClasses && (this.beanDestroyComparator = e3.beanDestroyComparator, this.init(e3));
              }
              init(e3) {
                var _a;
                Object.entries(e3.providedBeanInstances).forEach(([e4, t3]) => {
                  this.beans[e4] = t3;
                }), e3.beanClasses.forEach((e4) => {
                  const t3 = new e4();
                  t3.beanName ? this.beans[t3.beanName] = t3 : console.error(`Bean ${e4.name} is missing beanName`), this.createdBeans.push(t3);
                }), (_a = e3.derivedBeans) == null ? void 0 : _a.forEach((e4) => {
                  const { beanName: t3, bean: a2 } = e4(this);
                  this.beans[t3] = a2, this.createdBeans.push(a2);
                }), e3.beanInitComparator && this.createdBeans.sort(e3.beanInitComparator), this.initBeans(this.createdBeans);
              }
              getBeanInstances() {
                return Object.values(this.beans);
              }
              createBean(e3, t3) {
                if (!e3)
                  throw Error("null bean");
                return this.initBeans([e3], t3), e3;
              }
              initBeans(e3, t3) {
                e3.forEach((e4) => {
                  var _a, _b;
                  (_a = e4.preWireBeans) == null ? void 0 : _a.call(e4, this.beans), (_b = e4.wireBeans) == null ? void 0 : _b.call(e4, this.beans);
                }), e3.forEach((e4) => {
                  var _a;
                  return (_a = e4.preConstruct) == null ? void 0 : _a.call(e4);
                }), t3 && e3.forEach(t3), e3.forEach((e4) => {
                  var _a;
                  return (_a = e4.postConstruct) == null ? void 0 : _a.call(e4);
                });
              }
              getBeans() {
                return this.beans;
              }
              getBean(e3) {
                return this.beans[e3];
              }
              destroy() {
                if (this.destroyed)
                  return;
                this.destroyed = true;
                const e3 = this.getBeanInstances();
                this.beanDestroyComparator && e3.sort(this.beanDestroyComparator), this.destroyBeans(e3), this.beans = {}, this.createdBeans = [];
              }
              destroyBean(e3) {
                var _a;
                (_a = e3 == null ? void 0 : e3.destroy) == null ? void 0 : _a.call(e3);
              }
              destroyBeans(e3) {
                if (e3)
                  for (let t3 = 0; t3 < e3.length; t3++)
                    this.destroyBean(e3[t3]);
                return [];
              }
              isDestroyed() {
                return this.destroyed;
              }
            };
          }, 3943: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.gridBeanDestroyComparator = t2.gridBeanInitComparator = void 0;
            const a2 = Object.fromEntries(["licenseManager", "environment", "eventSvc", "gos", "paginationAutoPageSizeSvc", "apiFunctionSvc", "gridApi", "registry", "agCompUtils", "userCompFactory", "rowContainerHeight", "horizontalResizeSvc", "localeSvc", "pinnedRowModel", "dragSvc", "colGroupSvc", "visibleCols", "popupSvc", "selectionSvc", "colFilter", "quickFilter", "filterManager", "colModel", "headerNavigation", "pageBounds", "pagination", "pageBoundsListener", "stickyRowSvc", "rowRenderer", "expressionSvc", "alignedGridsSvc", "navigation", "valueCache", "valueSvc", "autoWidthCalc", "filterMenuFactory", "dragAndDrop", "focusSvc", "cellNavigation", "cellStyles", "scrollVisibleSvc", "sortSvc", "colHover", "colAnimation", "autoColSvc", "selectionColSvc", "changeDetectionSvc", "animationFrameSvc", "undoRedo", "colDefFactory", "rowStyleSvc", "rowNodeBlockLoader", "rowNodeSorter", "ctrlsSvc", "pinnedCols", "dataTypeSvc", "syncSvc", "overlays", "stateSvc", "expansionSvc", "apiEventSvc", "ariaAnnounce", "menuSvc", "colMoves", "colAutosize", "colFlex", "colResize", "pivotColsSvc", "valueColsSvc", "rowGroupColsSvc", "funcColsSvc", "colNames", "colViewport", "pivotResultCols", "showRowGroupCols", "validation"].map((e3, t3) => [e3, t3]));
            t2.gridBeanInitComparator = function(e3, t3) {
              var _a, _b;
              return ((_a = e3.beanName ? a2[e3.beanName] : void 0) != null ? _a : Number.MAX_SAFE_INTEGER) - ((_b = t3.beanName ? a2[t3.beanName] : void 0) != null ? _b : Number.MAX_SAFE_INTEGER);
            }, t2.gridBeanDestroyComparator = function(e3, t3) {
              return "gridDestroySvc" === (e3 == null ? void 0 : e3.beanName) ? -1 : 0;
            };
          }, 1310: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.CsvCreator = void 0;
            const n = a2(7331), o = a2(3885), r = a2(7764), i = a2(2927);
            class l extends n.BaseCreator {
              constructor() {
                super(...arguments), this.beanName = "csvCreator";
              }
              wireBeans(e3) {
                this.colModel = e3.colModel, this.colNames = e3.colNames, this.rowGroupColsSvc = e3.rowGroupColsSvc, this.valueSvc = e3.valueSvc;
              }
              getMergedParams(e3) {
                const t3 = this.gos.get("defaultCsvExportParams");
                return Object.assign({}, t3, e3);
              }
              export(e3) {
                if (this.isExportSuppressed())
                  return void (0, r._warn)(51);
                const t3 = this.getMergedParams(e3), a3 = this.getData(t3), n2 = new Blob(["\uFEFF", a3], { type: "text/plain" }), i2 = "function" == typeof t3.fileName ? t3.fileName(this.gos.getGridCommonParams()) : t3.fileName;
                (0, o._downloadFile)(this.getFileName(i2), n2);
              }
              exportDataAsCsv(e3) {
                this.export(e3);
              }
              getDataAsCsv(e3, t3 = false) {
                const a3 = t3 ? Object.assign({}, e3) : this.getMergedParams(e3);
                return this.getData(a3);
              }
              getDefaultFileExtension() {
                return "csv";
              }
              createSerializingSession(e3) {
                const { colModel: t3, colNames: a3, rowGroupColsSvc: n2, valueSvc: o2, gos: r2 } = this, { processCellCallback: l2, processHeaderCallback: s, processGroupHeaderCallback: d, processRowGroupCallback: c, suppressQuotes: g, columnSeparator: u } = e3;
                return new i.CsvSerializingSession({ colModel: t3, colNames: a3, valueSvc: o2, gos: r2, processCellCallback: l2 || void 0, processHeaderCallback: s || void 0, processGroupHeaderCallback: d || void 0, processRowGroupCallback: c || void 0, suppressQuotes: g || false, columnSeparator: u || ",", rowGroupColsSvc: n2 });
              }
              isExportSuppressed() {
                return this.gos.get("suppressCsvExport");
              }
            }
            t2.CsvCreator = l;
          }, 2984: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.exportDataAsCsv = t2.getDataAsCsv = void 0, t2.getDataAsCsv = function(e3, t3) {
              var _a;
              return (_a = e3.csvCreator) == null ? void 0 : _a.getDataAsCsv(t3);
            }, t2.exportDataAsCsv = function(e3, t3) {
              var _a;
              (_a = e3.csvCreator) == null ? void 0 : _a.exportDataAsCsv(t3);
            };
          }, 9734: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.CsvExportModule = void 0;
            const n = a2(2728), o = a2(7205), r = a2(1310), i = a2(2984);
            t2.CsvExportModule = { moduleName: "CsvExport", version: o.VERSION, beans: [r.CsvCreator], apiFunctions: { getDataAsCsv: i.getDataAsCsv, exportDataAsCsv: i.exportDataAsCsv }, dependsOn: [n.SharedExportModule] };
          }, 2927: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.CsvSerializingSession = void 0;
            const n = a2(8376), o = a2(7764);
            class r extends n.BaseGridSerializingSession {
              constructor(e3) {
                super(e3), this.isFirstLine = true, this.result = "";
                const { suppressQuotes: t3, columnSeparator: a3 } = e3;
                this.suppressQuotes = t3, this.columnSeparator = a3;
              }
              addCustomContent(e3) {
                e3 && ("string" == typeof e3 ? (/^\s*\n/.test(e3) || this.beginNewLine(), e3 = e3.replace(/\r?\n/g, "\r\n"), this.result += e3) : e3.forEach((e4) => {
                  this.beginNewLine(), e4.forEach((e5, t3) => {
                    0 !== t3 && (this.result += this.columnSeparator), this.result += this.putInQuotes(e5.data.value || ""), e5.mergeAcross && this.appendEmptyCells(e5.mergeAcross);
                  });
                }));
              }
              onNewHeaderGroupingRow() {
                return this.beginNewLine(), { onColumn: this.onNewHeaderGroupingRowColumn.bind(this) };
              }
              onNewHeaderGroupingRowColumn(e3, t3, a3, n2) {
                0 != a3 && (this.result += this.columnSeparator), this.result += this.putInQuotes(t3), this.appendEmptyCells(n2);
              }
              appendEmptyCells(e3) {
                for (let t3 = 1; t3 <= e3; t3++)
                  this.result += this.columnSeparator + this.putInQuotes("");
              }
              onNewHeaderRow() {
                return this.beginNewLine(), { onColumn: this.onNewHeaderRowColumn.bind(this) };
              }
              onNewHeaderRowColumn(e3, t3) {
                0 != t3 && (this.result += this.columnSeparator), this.result += this.putInQuotes(this.extractHeaderValue(e3));
              }
              onNewBodyRow() {
                return this.beginNewLine(), { onColumn: this.onNewBodyRowColumn.bind(this) };
              }
              onNewBodyRowColumn(e3, t3, a3) {
                var _a;
                0 != t3 && (this.result += this.columnSeparator);
                const n2 = this.extractRowCellValue(e3, t3, t3, "csv", a3);
                this.result += this.putInQuotes((_a = n2.valueFormatted) != null ? _a : n2.value);
              }
              putInQuotes(e3) {
                if (this.suppressQuotes)
                  return e3;
                if (null == e3)
                  return '""';
                let t3;
                "string" == typeof e3 ? t3 = e3 : "function" == typeof e3.toString ? t3 = e3.toString() : ((0, o._warn)(53), t3 = "");
                return '"' + t3.replace(/"/g, '""') + '"';
              }
              parse() {
                return this.result;
              }
              beginNewLine() {
                this.isFirstLine || (this.result += "\r\n"), this.isFirstLine = false;
              }
            }
            t2.CsvSerializingSession = r;
          }, 20: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.CtrlsService = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "ctrlsSvc", this.params = {}, this.ready = false, this.readyCallbacks = [];
              }
              postConstruct() {
                var _a, _b, _c;
                this.addEventListener("ready", () => {
                  this.updateReady(), this.ready && (this.readyCallbacks.forEach((e3) => e3(this.params)), this.readyCallbacks.length = 0);
                }, (_c = (_b = (_a = this.beans.frameworkOverrides).runWhenReadyAsync) == null ? void 0 : _b.call(_a)) != null ? _c : false);
              }
              updateReady() {
                const e3 = Object.values(this.params);
                this.ready = 23 === e3.length && e3.every((e4) => {
                  var _a;
                  return (_a = e4 == null ? void 0 : e4.isAlive()) != null ? _a : false;
                });
              }
              whenReady(e3, t3) {
                this.ready ? t3(this.params) : this.readyCallbacks.push(t3), e3.addDestroyFunc(() => {
                  const e4 = this.readyCallbacks.indexOf(t3);
                  e4 >= 0 && this.readyCallbacks.splice(e4, 1);
                });
              }
              register(e3, t3) {
                this.params[e3] = t3, this.updateReady(), this.ready && this.dispatchLocalEvent({ type: "ready" }), t3.addDestroyFunc(() => {
                  this.updateReady();
                });
              }
              get(e3) {
                return this.params[e3];
              }
              getGridBodyCtrl() {
                return this.params.gridBodyCtrl;
              }
              getHeaderRowContainerCtrls() {
                const { leftHeader: e3, centerHeader: t3, rightHeader: a3 } = this.params;
                return [e3, a3, t3];
              }
              getHeaderRowContainerCtrl(e3) {
                const t3 = this.params;
                switch (e3) {
                  case "left":
                    return t3.leftHeader;
                  case "right":
                    return t3.rightHeader;
                  default:
                    return t3.centerHeader;
                }
              }
              getScrollFeature() {
                return this.getGridBodyCtrl().scrollFeature;
              }
            }
            t2.CtrlsService = o;
          }, 2671: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.dragAndDropImageComponentCSS = void 0, t2.dragAndDropImageComponentCSS = ".ag-dnd-ghost{align-items:center;background-color:var(--ag-drag-and-drop-image-background-color);border:var(--ag-drag-and-drop-image-border);border-radius:var(--ag-border-radius);box-shadow:var(--ag-drag-and-drop-image-shadow);color:var(--ag-text-color);cursor:move;display:flex;font-weight:500;gap:var(--ag-cell-widget-spacing);height:var(--ag-header-height);overflow:hidden;padding-left:var(--ag-cell-horizontal-padding);padding-right:var(--ag-cell-horizontal-padding);text-overflow:ellipsis;transform:translateY(calc(var(--ag-spacing)*2));white-space:nowrap}";
          }, 3814: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.DragAndDropImageComponent = void 0;
            const n = a2(3507), o = a2(9970), r = a2(7766), i = a2(8020), l = a2(2671);
            class s extends i.Component {
              constructor() {
                super(), this.dragSource = null, this.eIcon = i.RefPlaceholder, this.eLabel = i.RefPlaceholder, this.registerCSS(l.dragAndDropImageComponentCSS);
              }
              postConstruct() {
                const e3 = (e4) => (0, o._createIcon)(e4, this.beans, null);
                this.dropIconMap = { pinned: e3("columnMovePin"), hide: e3("columnMoveHide"), move: e3("columnMoveMove"), left: e3("columnMoveLeft"), right: e3("columnMoveRight"), group: e3("columnMoveGroup"), aggregate: e3("columnMoveValue"), pivot: e3("columnMovePivot"), notAllowed: e3("dropNotAllowed") };
              }
              init(e3) {
                this.dragSource = e3.dragSource, this.setTemplate('<div class="ag-dnd-ghost ag-unselectable">\n                <span data-ref="eIcon" class="ag-dnd-ghost-icon ag-shake-left-to-right"></span>\n                <div data-ref="eLabel" class="ag-dnd-ghost-label"></div>\n            </div>');
              }
              destroy() {
                this.dragSource = null, super.destroy();
              }
              setIcon(e3, t3) {
                const { eIcon: a3, dragSource: o2, dropIconMap: r2, gos: i2 } = this;
                (0, n._clearElement)(a3);
                let l2 = null;
                e3 || (e3 = (o2 == null ? void 0 : o2.getDefaultIconName) ? o2.getDefaultIconName() : "notAllowed"), l2 = r2[e3], a3.classList.toggle("ag-shake-left-to-right", t3), l2 === r2.hide && i2.get("suppressDragLeaveHidesColumns") || l2 && a3.appendChild(l2);
              }
              setLabel(e3) {
                this.eLabel.textContent = (0, r._escapeString)(e3);
              }
            }
            t2.DragAndDropImageComponent = s;
          }, 2903: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.DragAndDropService = t2.DragSourceType = void 0;
            const n = a2(2036), o = a2(8731), r = a2(8399), i = a2(7274), l = a2(1502), s = a2(7764);
            var d;
            !function(e3) {
              e3[e3.ToolPanel = 0] = "ToolPanel", e3[e3.HeaderCell = 1] = "HeaderCell", e3[e3.RowDrag = 2] = "RowDrag", e3[e3.ChartPanel = 3] = "ChartPanel", e3[e3.AdvancedFilterBuilder = 4] = "AdvancedFilterBuilder";
            }(d || (t2.DragSourceType = d = {}));
            class c extends o.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "dragAndDrop", this.dragSourceAndParamsList = [], this.dropTargets = [];
              }
              wireBeans(e3) {
                this.ctrlsSvc = e3.ctrlsSvc, this.dragSvc = e3.dragSvc, this.environment = e3.environment, this.userCompFactory = e3.userCompFactory;
              }
              addDragSource(e3, t3 = false) {
                const a3 = { eElement: e3.eElement, dragStartPixels: e3.dragStartPixels, onDragStart: this.onDragStart.bind(this, e3), onDragStop: this.onDragStop.bind(this), onDragging: this.onDragging.bind(this), onDragCancel: this.onDragCancel.bind(this), includeTouch: t3 };
                this.dragSourceAndParamsList.push({ params: a3, dragSource: e3 }), this.dragSvc.addDragSource(a3);
              }
              getDragAndDropImageComponent() {
                const { dragAndDropImageComp: e3 } = this;
                return e3 && e3.comp ? e3.comp : null;
              }
              removeDragSource(e3) {
                const { dragSourceAndParamsList: t3, dragSvc: a3 } = this, n2 = t3.find((t4) => t4.dragSource === e3);
                n2 && (a3.removeDragSource(n2.params), (0, l._removeFromArray)(t3, n2));
              }
              destroy() {
                const { dragSourceAndParamsList: e3, dragSvc: t3, dropTargets: a3 } = this;
                e3.forEach((e4) => t3.removeDragSource(e4.params)), e3.length = 0, a3.length = 0, this.clearDragAndDropProperties(), super.destroy();
              }
              nudge() {
                this.dragging && this.onDragging(this.eventLastTime, true);
              }
              onDragStart(e3, t3) {
                var _a;
                this.dragging = true, this.dragSource = e3, this.eventLastTime = t3, this.dragItem = e3.getDragItem(), (_a = e3.onDragStarted) == null ? void 0 : _a.call(e3), this.createDragAndDropImageComponent();
              }
              onDragStop(e3) {
                var _a, _b;
                (_b = (_a = this.dragSource) == null ? void 0 : _a.onDragStopped) == null ? void 0 : _b.call(_a);
                const { lastDropTarget: t3 } = this;
                if (t3 == null ? void 0 : t3.onDragStop) {
                  const a3 = this.createDropTargetEvent(t3, e3, null, null, false);
                  t3.onDragStop(a3);
                }
                this.clearDragAndDropProperties();
              }
              onDragCancel() {
                var _a;
                const { dragSource: e3, lastDropTarget: t3 } = this;
                (_a = e3 == null ? void 0 : e3.onDragCancelled) == null ? void 0 : _a.call(e3), (t3 == null ? void 0 : t3.onDragCancel) && t3.onDragCancel(this.createDropTargetEvent(t3, this.eventLastTime, null, null, false)), this.clearDragAndDropProperties();
              }
              clearDragAndDropProperties() {
                this.eventLastTime = null, this.dragging = false, this.lastDropTarget = void 0, this.dragItem = null, this.dragSource = null, this.removeDragAndDropImageComponent();
              }
              onDragging(e3, t3 = false) {
                var _a, _b;
                const a3 = this.getHorizontalDirection(e3), n2 = this.getVerticalDirection(e3);
                this.eventLastTime = e3, this.positionDragAndDropImageComp(e3);
                const o2 = this.dropTargets.filter((t4) => this.isMouseOnDropTarget(e3, t4)), r2 = this.findCurrentDropTarget(e3, o2), { lastDropTarget: i2, dragSource: l2, dragAndDropImageComp: s2, dragItem: d2 } = this;
                if (r2 !== i2) {
                  if (this.leaveLastTargetIfExists(e3, a3, n2, t3), null !== i2 && null === r2 && ((_a = l2 == null ? void 0 : l2.onGridExit) == null ? void 0 : _a.call(l2, d2)), null === i2 && null !== r2 && ((_b = l2 == null ? void 0 : l2.onGridEnter) == null ? void 0 : _b.call(l2, d2)), this.enterDragTargetIfExists(r2, e3, a3, n2, t3), r2 && s2) {
                    const { comp: e4, promise: t4 } = s2;
                    e4 ? e4.setIcon(r2.getIconName ? r2.getIconName() : null, false) : t4.then((e5) => {
                      e5 && e5.setIcon(r2.getIconName ? r2.getIconName() : null, false);
                    });
                  }
                  this.lastDropTarget = r2;
                } else if (r2 && r2.onDragging) {
                  const o3 = this.createDropTargetEvent(r2, e3, a3, n2, t3);
                  r2.onDragging(o3);
                }
              }
              getAllContainersFromDropTarget(e3) {
                const t3 = e3.getSecondaryContainers ? e3.getSecondaryContainers() : null, a3 = [[e3.getContainer()]];
                return t3 ? a3.concat(t3) : a3;
              }
              isMouseOnDropTarget(e3, t3) {
                const a3 = this.getAllContainersFromDropTarget(t3);
                let n2 = false;
                const o2 = (e4, t4) => {
                  for (const a4 of t4) {
                    const { width: t5, height: n3, left: o3, right: r3, top: i3, bottom: l2 } = a4.getBoundingClientRect();
                    if (0 === t5 || 0 === n3)
                      return false;
                    const s2 = e4.clientX >= o3 && e4.clientX < r3, d2 = e4.clientY >= i3 && e4.clientY < l2;
                    if (!s2 || !d2)
                      return false;
                  }
                  return true;
                };
                for (const t4 of a3)
                  if (o2(e3, t4)) {
                    n2 = true;
                    break;
                  }
                const { eElement: r2, type: i2 } = this.dragSource;
                return !(t3.targetContainsSource && !t3.getContainer().contains(r2)) && (n2 && t3.isInterestedIn(i2, r2));
              }
              findCurrentDropTarget(e3, t3) {
                const a3 = t3.length;
                if (0 === a3)
                  return null;
                if (1 === a3)
                  return t3[0];
                const n2 = (0, i._getRootNode)(this.beans).elementsFromPoint(e3.clientX, e3.clientY);
                for (const e4 of n2)
                  for (const a4 of t3) {
                    if (-1 !== this.getAllContainersFromDropTarget(a4).flatMap((e5) => e5).indexOf(e4))
                      return a4;
                  }
                return null;
              }
              enterDragTargetIfExists(e3, t3, a3, n2, o2) {
                if (e3 && e3.onDragEnter) {
                  const r2 = this.createDropTargetEvent(e3, t3, a3, n2, o2);
                  e3.onDragEnter(r2);
                }
              }
              leaveLastTargetIfExists(e3, t3, a3, n2) {
                const { lastDropTarget: o2 } = this;
                if (!o2)
                  return;
                if (o2.onDragLeave) {
                  const r3 = this.createDropTargetEvent(o2, e3, t3, a3, n2);
                  o2.onDragLeave(r3);
                }
                const r2 = this.getDragAndDropImageComponent();
                r2 && r2.setIcon(null, false);
              }
              addDropTarget(e3) {
                this.dropTargets.push(e3);
              }
              removeDropTarget(e3) {
                this.dropTargets = this.dropTargets.filter((t3) => t3.getContainer() !== e3.getContainer());
              }
              hasExternalDropZones() {
                return this.dropTargets.some((e3) => e3.external);
              }
              findExternalZone(e3) {
                return this.dropTargets.filter((e4) => e4.external).find((t3) => t3.getContainer() === e3.getContainer()) || null;
              }
              isDropZoneWithinThisGrid(e3) {
                const t3 = this.ctrlsSvc.getGridBodyCtrl().eGridBody, { dropZoneTarget: a3 } = e3;
                return t3.contains(a3);
              }
              getHorizontalDirection(e3) {
                var _a;
                const t3 = (_a = this.eventLastTime) == null ? void 0 : _a.clientX, a3 = e3.clientX;
                return t3 === a3 ? null : t3 > a3 ? "left" : "right";
              }
              getVerticalDirection(e3) {
                var _a;
                const t3 = (_a = this.eventLastTime) == null ? void 0 : _a.clientY, a3 = e3.clientY;
                return t3 === a3 ? null : t3 > a3 ? "up" : "down";
              }
              createDropTargetEvent(e3, t3, a3, n2, o2) {
                const r2 = e3.getContainer(), i2 = r2.getBoundingClientRect(), { dragItem: l2, dragSource: s2, gos: d2 } = this, c2 = t3.clientX - i2.left, g = t3.clientY - i2.top;
                return d2.addGridCommonParams({ event: t3, x: c2, y: g, vDirection: n2, hDirection: a3, dragSource: s2, fromNudge: o2, dragItem: l2, dropZoneTarget: r2 });
              }
              positionDragAndDropImageComp(e3) {
                const t3 = this.getDragAndDropImageComponent();
                t3 && (0, i._anchorElementToMouseMoveEvent)(t3.getGui(), e3, this.beans);
              }
              removeDragAndDropImageComponent() {
                var _a;
                const { dragAndDropImageComp: e3 } = this;
                if (e3) {
                  const { comp: t3 } = e3;
                  if (t3) {
                    const e4 = t3.getGui();
                    (_a = this.dragAndDropImageParent) == null ? void 0 : _a.removeChild(e4), this.destroyBean(t3);
                  }
                }
                this.dragAndDropImageComp = null;
              }
              createDragAndDropImageComponent() {
                const { dragSource: e3 } = this;
                if (!e3)
                  return;
                const t3 = (0, n._getDragAndDropImageCompDetails)(this.userCompFactory, { dragSource: e3 });
                if (!t3)
                  return;
                const a3 = t3.newAgStackInstance();
                this.dragAndDropImageComp = { promise: a3 }, a3.then((e4) => {
                  e4 && this.isAlive() && (this.processDragAndDropImageComponent(e4), this.dragAndDropImageComp.comp = e4);
                });
              }
              processDragAndDropImageComponent(e3) {
                const { dragSource: t3, environment: a3 } = this;
                if (!t3)
                  return;
                const n2 = e3.getGui();
                n2.style.setProperty("position", "absolute"), n2.style.setProperty("z-index", "9999"), (0, r._stampTopLevelGridCompWithGridInstance)(this.gos, n2), a3.applyThemeClasses(n2), e3.setIcon(null, false);
                let { dragItemName: o2 } = t3;
                "function" == typeof o2 && (o2 = o2()), e3.setLabel(o2 || ""), n2.style.top = "20px", n2.style.left = "20px";
                const l2 = (0, i._getPageBody)(this.beans);
                this.dragAndDropImageParent = l2, l2 ? l2.appendChild(n2) : (0, s._warn)(54);
              }
              registerGridDropTarget(e3, t3) {
                const a3 = { getContainer: e3, isInterestedIn: (e4) => e4 === d.HeaderCell || e4 === d.ToolPanel, getIconName: () => "notAllowed" };
                this.addDropTarget(a3), t3.addDestroyFunc(() => this.removeDropTarget(a3));
              }
            }
            t2.DragAndDropService = c;
          }, 2830: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.getRowDropZoneParams = t2.removeRowDropZone = t2.addRowDropZone = void 0, t2.addRowDropZone = function(e3, t3) {
              var _a, _b;
              (_b = (_a = e3.rowDragSvc) == null ? void 0 : _a.rowDragFeature) == null ? void 0 : _b.addRowDropZone(t3);
            }, t2.removeRowDropZone = function(e3, t3) {
              var _a, _b;
              const a2 = (_a = e3.dragAndDrop) == null ? void 0 : _a.findExternalZone(t3);
              a2 && ((_b = e3.dragAndDrop) == null ? void 0 : _b.removeDropTarget(a2));
            }, t2.getRowDropZoneParams = function(e3, t3) {
              var _a, _b;
              return (_b = (_a = e3.rowDragSvc) == null ? void 0 : _a.rowDragFeature) == null ? void 0 : _b.getRowDropZone(t3);
            };
          }, 4388: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.HorizontalResizeModule = t2.RowDragModule = t2.SharedDragAndDropModule = t2.DragAndDropModule = t2.DragModule = void 0;
            const n = a2(714), o = a2(7205), r = a2(3814), i = a2(2903), l = a2(2830), s = a2(2165), d = a2(6843), c = a2(2895);
            t2.DragModule = { moduleName: "Drag", version: o.VERSION, beans: [s.DragService] }, t2.DragAndDropModule = { moduleName: "DragAndDrop", version: o.VERSION, dynamicBeans: { dndSourceComp: n.DndSourceComp }, icons: { rowDrag: "grip" } }, t2.SharedDragAndDropModule = { moduleName: "SharedDragAndDrop", version: o.VERSION, beans: [i.DragAndDropService], dependsOn: [t2.DragModule], userComponents: { agDragAndDropImage: r.DragAndDropImageComponent }, icons: { columnMovePin: "pin", columnMoveHide: "eye-slash", columnMoveMove: "arrows", columnMoveLeft: "left", columnMoveRight: "right", columnMoveGroup: "group", columnMoveValue: "aggregation", columnMovePivot: "pivot", dropNotAllowed: "not-allowed", rowDrag: "grip" } }, t2.RowDragModule = { moduleName: "RowDrag", version: o.VERSION, beans: [c.RowDragService], apiFunctions: { addRowDropZone: l.addRowDropZone, removeRowDropZone: l.removeRowDropZone, getRowDropZoneParams: l.getRowDropZoneParams }, dependsOn: [t2.SharedDragAndDropModule] }, t2.HorizontalResizeModule = { moduleName: "HorizontalResize", version: o.VERSION, beans: [d.HorizontalResizeService], dependsOn: [t2.DragModule] };
          }, 2165: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.DragService = void 0;
            const n = a2(9853), o = a2(8731), r = a2(8399), i = a2(7274), l = a2(1502), s = a2(8667), d = a2(3507), c = a2(4422), g = a2(3276);
            class u extends o.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "dragSvc", this.dragEndFunctions = [], this.dragSources = [];
              }
              destroy() {
                const { dragSources: e3 } = this;
                e3.forEach(this.removeListener.bind(this)), e3.length = 0, super.destroy();
              }
              removeListener(e3) {
                const t3 = e3.dragSource.eElement, a3 = e3.mouseDownListener;
                if (t3.removeEventListener("mousedown", a3), e3.touchEnabled) {
                  const a4 = e3.touchStartListener;
                  t3.removeEventListener("touchstart", a4, { passive: true });
                }
              }
              removeDragSource(e3) {
                const { dragSources: t3 } = this, a3 = t3.find((t4) => t4.dragSource === e3);
                a3 && (this.removeListener(a3), (0, l._removeFromArray)(t3, a3));
              }
              addDragSource(e3) {
                const t3 = this.onMouseDown.bind(this, e3), { eElement: a3, includeTouch: n2, stopPropagationForTouch: o2 } = e3;
                a3.addEventListener("mousedown", t3);
                let r2 = null;
                const i2 = this.gos.get("suppressTouch");
                n2 && !i2 && (r2 = (t4) => {
                  (0, d._isFocusableFormField)(t4.target) || (o2 && t4.stopPropagation(), this.onTouchStart(e3, t4));
                }, a3.addEventListener("touchstart", r2, { passive: false })), this.dragSources.push({ dragSource: e3, mouseDownListener: t3, touchStartListener: r2, touchEnabled: !!n2 });
              }
              onTouchStart(e3, t3) {
                this.currentDragParams = e3, this.dragging = false;
                const a3 = t3.touches[0];
                this.touchLastTime = a3, this.touchStart = a3;
                const n2 = (t4) => this.onTouchUp(t4, e3.eElement), o2 = t3.target, r2 = [{ target: (0, i._getRootNode)(this.beans), type: "touchmove", listener: (e4) => {
                  e4.cancelable && e4.preventDefault();
                }, options: { passive: false } }, { target: o2, type: "touchmove", listener: (t4) => this.onTouchMove(t4, e3.eElement), options: { passive: true } }, { target: o2, type: "touchend", listener: n2, options: { passive: true } }, { target: o2, type: "touchcancel", listener: n2, options: { passive: true } }];
                this.addTemporaryEvents(r2), 0 === e3.dragStartPixels && this.onCommonMove(a3, this.touchStart, e3.eElement);
              }
              onMouseDown(e3, t3) {
                const a3 = t3;
                if (e3.skipMouseEvent && e3.skipMouseEvent(t3))
                  return;
                if (a3._alreadyProcessedByDragService)
                  return;
                if (a3._alreadyProcessedByDragService = true, 0 !== t3.button)
                  return;
                this.shouldPreventMouseEvent(t3) && t3.preventDefault(), this.currentDragParams = e3, this.dragging = false, this.mouseStartEvent = t3, this.startTarget = t3.target;
                const o2 = (0, i._getRootNode)(this.beans), r2 = [{ target: o2, type: "mousemove", listener: (t4) => this.onMouseMove(t4, e3.eElement) }, { target: o2, type: "mouseup", listener: (t4) => this.onMouseUp(t4, e3.eElement) }, { target: o2, type: "contextmenu", listener: (e4) => e4.preventDefault() }, { target: o2, type: "keydown", listener: (t4) => {
                  t4.key === n.KeyCode.ESCAPE && this.cancelDrag(e3.eElement);
                } }];
                this.addTemporaryEvents(r2), 0 === e3.dragStartPixels && this.onMouseMove(t3, e3.eElement);
              }
              addTemporaryEvents(e3) {
                e3.forEach((e4) => {
                  const { target: t3, type: a3, listener: n2, options: o2 } = e4;
                  t3.addEventListener(a3, n2, o2);
                }), this.dragEndFunctions.push(() => {
                  e3.forEach((e4) => {
                    const { target: t3, type: a3, listener: n2, options: o2 } = e4;
                    t3.removeEventListener(a3, n2, o2);
                  });
                });
              }
              isEventNearStartEvent(e3, t3) {
                const { dragStartPixels: a3 } = this.currentDragParams, n2 = (0, c._exists)(a3) ? a3 : 4;
                return (0, g._areEventsNear)(e3, t3, n2);
              }
              getFirstActiveTouch(e3) {
                for (let t3 = 0; t3 < e3.length; t3++)
                  if (e3[t3].identifier === this.touchStart.identifier)
                    return e3[t3];
                return null;
              }
              onCommonMove(e3, t3, a3) {
                var _a;
                if (!this.dragging) {
                  if (this.isEventNearStartEvent(e3, t3))
                    return;
                  if (this.dragging = true, this.eventSvc.dispatchEvent({ type: "dragStarted", target: a3 }), this.currentDragParams.onDragStart(t3), !this.currentDragParams)
                    return void (this.dragging = false);
                  this.currentDragParams.onDragging(t3);
                }
                (_a = this.currentDragParams) == null ? void 0 : _a.onDragging(e3);
              }
              onTouchMove(e3, t3) {
                const a3 = this.getFirstActiveTouch(e3.touches);
                a3 && this.onCommonMove(a3, this.touchStart, t3);
              }
              onMouseMove(e3, t3) {
                var _a;
                if ((0, s._isBrowserSafari)()) {
                  const e4 = (0, i._getDocument)(this.beans);
                  (_a = e4.getSelection()) == null ? void 0 : _a.removeAllRanges();
                }
                this.shouldPreventMouseEvent(e3) && e3.preventDefault(), this.onCommonMove(e3, this.mouseStartEvent, t3);
              }
              shouldPreventMouseEvent(e3) {
                const { gos: t3 } = this, a3 = t3.get("enableCellTextSelection"), n2 = "mousemove" === e3.type;
                return a3 && n2 && e3.cancelable && (0, r._isEventFromThisGrid)(t3, e3) && !((e4) => {
                  const t4 = e4.target, a4 = t4 == null ? void 0 : t4.tagName.toLocaleLowerCase();
                  return !!(a4 == null ? void 0 : a4.match("^a$|textarea|input|select|button"));
                })(e3);
              }
              onTouchUp(e3, t3) {
                let a3 = this.getFirstActiveTouch(e3.changedTouches);
                a3 || (a3 = this.touchLastTime), this.onUpCommon(a3, t3);
              }
              onMouseUp(e3, t3) {
                this.onUpCommon(e3, t3);
              }
              onUpCommon(e3, t3) {
                this.dragging && (this.dragging = false, this.currentDragParams.onDragStop(e3), this.eventSvc.dispatchEvent({ type: "dragStopped", target: t3 })), this.resetDragProperties();
              }
              cancelDrag(e3) {
                var _a, _b;
                this.eventSvc.dispatchEvent({ type: "dragCancelled", target: e3 }), (_b = (_a = this.currentDragParams) == null ? void 0 : _a.onDragCancel) == null ? void 0 : _b.call(_a), this.resetDragProperties();
              }
              resetDragProperties() {
                this.mouseStartEvent = null, this.startTarget = null, this.touchStart = null, this.touchLastTime = null, this.currentDragParams = null;
                const { dragEndFunctions: e3 } = this;
                e3.forEach((e4) => e4()), e3.length = 0;
              }
            }
            t2.DragService = u;
          }, 6843: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.HorizontalResizeService = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "horizontalResizeSvc";
              }
              addResizeBar(e3) {
                const t3 = { dragStartPixels: e3.dragStartPixels || 0, eElement: e3.eResizeBar, onDragStart: this.onDragStart.bind(this, e3), onDragStop: this.onDragStop.bind(this, e3), onDragging: this.onDragging.bind(this, e3), onDragCancel: this.onDragStop.bind(this, e3), includeTouch: true, stopPropagationForTouch: true }, { dragSvc: a3 } = this.beans;
                a3.addDragSource(t3);
                return () => a3.removeDragSource(t3);
              }
              onDragStart(e3, t3) {
                this.dragStartX = t3.clientX, this.setResizeIcons();
                const a3 = t3 instanceof MouseEvent && true === t3.shiftKey;
                e3.onResizeStart(a3);
              }
              setResizeIcons() {
                const e3 = this.beans.ctrlsSvc.get("gridCtrl");
                e3.setResizeCursor(true), e3.disableUserSelect(true);
              }
              onDragStop(e3) {
                e3.onResizeEnd(this.resizeAmount), this.resetIcons();
              }
              resetIcons() {
                const e3 = this.beans.ctrlsSvc.get("gridCtrl");
                e3.setResizeCursor(false), e3.disableUserSelect(false);
              }
              onDragging(e3, t3) {
                this.resizeAmount = t3.clientX - this.dragStartX, e3.onResizing(this.resizeAmount);
              }
            }
            t2.HorizontalResizeService = o;
          }, 1633: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.RowDragComp = void 0;
            const n = a2(8731), o = a2(9970), r = a2(8020), i = a2(2903);
            class l extends r.Component {
              constructor(e3, t3, a3, n2, o2, r2) {
                super(), this.cellValueFn = e3, this.rowNode = t3, this.column = a3, this.customGui = n2, this.dragStartPixels = o2, this.suppressVisibilityChange = r2, this.dragSource = null;
              }
              isCustomGui() {
                return null != this.customGui;
              }
              postConstruct() {
                const { beans: e3, rowNode: t3, column: a3, gos: n2 } = this;
                if (this.customGui ? this.setDragElement(this.customGui, this.dragStartPixels) : (this.setTemplate('<div class="ag-drag-handle ag-row-drag" aria-hidden="true"></div>'), this.getGui().appendChild((0, o._createIconNoSpan)("rowDrag", e3, null)), this.addDragSource()), !this.suppressVisibilityChange) {
                  const e4 = n2.get("rowDragManaged") ? new c(this, t3, a3) : new d(this, t3, a3);
                  this.createManagedBean(e4, this.beans.context);
                }
              }
              setDragElement(e3, t3) {
                this.setTemplateFromElement(e3, void 0, void 0, true), this.addDragSource(t3);
              }
              getSelectedNodes() {
                var _a, _b;
                const e3 = this.rowNode;
                if (!this.gos.get("rowDragMultiRow"))
                  return [e3];
                const t3 = (_b = (_a = this.beans.selectionSvc) == null ? void 0 : _a.getSelectedNodes()) != null ? _b : [];
                return -1 !== t3.indexOf(e3) ? t3 : [e3];
              }
              getDragItem() {
                const { column: e3, rowNode: t3 } = this;
                return { rowNode: t3, rowNodes: this.getSelectedNodes(), columns: e3 ? [e3] : void 0, defaultTextValue: this.cellValueFn() };
              }
              getRowDragText(e3) {
                if (e3) {
                  const t3 = e3.getColDef();
                  if (t3.rowDragText)
                    return t3.rowDragText;
                }
                return this.gos.get("rowDragText");
              }
              addDragSource(e3 = 4) {
                this.dragSource && this.removeDragSource();
                const t3 = this.getGui();
                this.gos.get("enableCellTextSelection") && (this.removeMouseDownListener(), this.mouseDownListener = this.addManagedElementListeners(t3, { mousedown: (e4) => {
                  e4 == null ? void 0 : e4.preventDefault();
                } })[0]);
                const a3 = this.getLocaleTextFunc();
                this.dragSource = { type: i.DragSourceType.RowDrag, eElement: t3, dragItemName: () => {
                  var _a;
                  const e4 = this.getDragItem(), t4 = ((_a = e4.rowNodes) == null ? void 0 : _a.length) || 1, n2 = this.getRowDragText(this.column);
                  return n2 ? n2(e4, t4) : 1 === t4 ? this.cellValueFn() : `${t4} ${a3("rowDragRows", "rows")}`;
                }, getDragItem: () => this.getDragItem(), dragStartPixels: e3, dragSourceDomDataKey: this.gos.getDomDataKey() }, this.beans.dragAndDrop.addDragSource(this.dragSource, true);
              }
              destroy() {
                this.removeDragSource(), this.removeMouseDownListener(), super.destroy();
              }
              removeDragSource() {
                this.dragSource && (this.beans.dragAndDrop.removeDragSource(this.dragSource), this.dragSource = null);
              }
              removeMouseDownListener() {
                this.mouseDownListener && (this.mouseDownListener(), this.mouseDownListener = void 0);
              }
            }
            t2.RowDragComp = l;
            class s extends n.BeanStub {
              constructor(e3, t3, a3) {
                super(), this.parent = e3, this.rowNode = t3, this.column = a3;
              }
              setDisplayedOrVisible(e3) {
                const t3 = { skipAriaHidden: true };
                if (e3)
                  this.parent.setDisplayed(false, t3);
                else {
                  let e4 = true, a3 = false;
                  const { column: n2, rowNode: o2, parent: r2 } = this;
                  n2 && (e4 = n2.isRowDrag(o2) || r2.isCustomGui(), a3 = "function" == typeof n2.getColDef().rowDrag), a3 ? (r2.setDisplayed(true, t3), r2.setVisible(e4, t3)) : (r2.setDisplayed(e4, t3), r2.setVisible(true, t3));
                }
              }
            }
            class d extends s {
              postConstruct() {
                this.addManagedPropertyListener("suppressRowDrag", this.onSuppressRowDrag.bind(this));
                const e3 = this.workOutVisibility.bind(this);
                this.addManagedListeners(this.rowNode, { dataChanged: e3, cellChanged: e3 }), this.addManagedListeners(this.beans.eventSvc, { newColumnsLoaded: e3 }), this.workOutVisibility();
              }
              onSuppressRowDrag() {
                this.workOutVisibility();
              }
              workOutVisibility() {
                const e3 = this.gos.get("suppressRowDrag");
                this.setDisplayedOrVisible(e3);
              }
            }
            class c extends s {
              postConstruct() {
                const e3 = this.workOutVisibility.bind(this);
                this.addManagedListeners(this.beans.eventSvc, { sortChanged: e3, filterChanged: e3, columnRowGroupChanged: e3, newColumnsLoaded: e3 }), this.addManagedListeners(this.rowNode, { dataChanged: e3, cellChanged: e3 }), this.addManagedPropertyListener("suppressRowDrag", this.onSuppressRowDrag.bind(this)), this.workOutVisibility();
              }
              onSuppressRowDrag() {
                this.workOutVisibility();
              }
              workOutVisibility() {
                const { rowDragSvc: e3, dragAndDrop: t3, gos: a3 } = this.beans, n2 = e3.rowDragFeature, o2 = n2 && n2.shouldPreventRowMove(), r2 = a3.get("suppressRowDrag"), i2 = t3.hasExternalDropZones(), l2 = o2 && !i2 || r2;
                this.setDisplayedOrVisible(l2);
              }
            }
          }, 2254: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.RowDragFeature = void 0;
            const n = a2(5628), o = a2(8731), r = a2(6257), i = a2(8399), l = a2(7274), s = a2(1502), d = a2(7764), c = a2(2903);
            class g extends o.BeanStub {
              constructor(e3) {
                super(), this.eContainer = e3;
              }
              postConstruct() {
                const { rowModel: e3, gos: t3, ctrlsSvc: a3 } = this.beans;
                (0, l._isClientSideRowModel)(t3, e3) && (this.clientSideRowModel = e3), a3.whenReady(this, (e4) => {
                  const t4 = e4.gridBodyCtrl;
                  this.autoScrollService = new n.AutoScrollService({ scrollContainer: t4.eBodyViewport, scrollAxis: "y", getVerticalPosition: () => t4.scrollFeature.getVScrollPosition().top, setVerticalPosition: (e5) => t4.scrollFeature.setVerticalScrollPosition(e5), onScrollCallback: () => {
                    this.onDragging(this.lastDraggingEvent);
                  } });
                });
              }
              getContainer() {
                return this.eContainer;
              }
              isInterestedIn(e3) {
                return e3 === c.DragSourceType.RowDrag;
              }
              getIconName() {
                return this.gos.get("rowDragManaged") && this.shouldPreventRowMove() ? "notAllowed" : "move";
              }
              shouldPreventRowMove() {
                var _a;
                const { rowGroupColsSvc: e3, filterManager: t3, sortSvc: a3 } = this.beans;
                if (((_a = e3 == null ? void 0 : e3.columns) != null ? _a : []).length)
                  return true;
                const n2 = t3 == null ? void 0 : t3.isAnyFilterPresent();
                if (n2)
                  return true;
                const o2 = a3 == null ? void 0 : a3.isSortActive();
                return !!o2;
              }
              getRowNodes(e3) {
                var _a, _b;
                if (!this.isFromThisGrid(e3))
                  return e3.dragItem.rowNodes || [];
                const t3 = e3.dragItem.rowNode;
                if (this.gos.get("rowDragMultiRow")) {
                  const e4 = [...(_b = (_a = this.beans.selectionSvc) == null ? void 0 : _a.getSelectedNodes()) != null ? _b : []].sort((e5, t4) => null == e5.rowIndex || null == t4.rowIndex ? 0 : this.getRowIndexNumber(e5) - this.getRowIndexNumber(t4));
                  if (-1 !== e4.indexOf(t3))
                    return e4;
                }
                return [t3];
              }
              onDragEnter(e3) {
                e3.dragItem.rowNodes = this.getRowNodes(e3), this.dispatchGridEvent("rowDragEnter", e3), this.getRowNodes(e3).forEach((e4) => {
                  this.setRowNodeDragging(e4, true);
                }), this.onEnterOrDragging(e3);
              }
              onDragging(e3) {
                this.onEnterOrDragging(e3);
              }
              isFromThisGrid(e3) {
                const { dragSourceDomDataKey: t3 } = e3.dragSource;
                return t3 === this.gos.getDomDataKey();
              }
              onEnterOrDragging(e3) {
                this.dispatchGridEvent("rowDragMove", e3), this.lastDraggingEvent = e3;
                const t3 = (0, i._getNormalisedMousePosition)(this.beans, e3).y;
                this.gos.get("rowDragManaged") && this.doManagedDrag(e3, t3), this.autoScrollService.check(e3.event);
              }
              doManagedDrag(e3, t3) {
                const { dragAndDrop: a3, gos: n2 } = this.beans, o2 = this.isFromThisGrid(e3), r2 = n2.get("rowDragManaged"), i2 = e3.dragItem.rowNodes;
                r2 && this.shouldPreventRowMove() || (n2.get("suppressMoveWhenRowDragging") || !o2 ? a3.isDropZoneWithinThisGrid(e3) && this.clientSideRowModel.highlightRowAtPixel(i2[0], t3) : this.moveRows(i2, t3));
              }
              getRowIndexNumber(e3) {
                const t3 = e3.getRowIndexString();
                return parseInt((0, s._last)(t3.split("-")), 10);
              }
              moveRowAndClearHighlight(e3) {
                const t3 = this.clientSideRowModel, a3 = t3.getLastHighlightedRowNode(), n2 = a3 && "Below" === a3.highlighted, o2 = (0, i._getNormalisedMousePosition)(this.beans, e3).y, r2 = e3.dragItem.rowNodes;
                let s2 = n2 ? 1 : 0;
                if (this.isFromThisGrid(e3))
                  r2.forEach((e4) => {
                    e4.rowTop < o2 && (s2 -= 1);
                  }), this.moveRows(r2, o2, s2);
                else {
                  const e4 = (0, l._getRowIdCallback)(this.gos);
                  let a4 = t3.getRowIndexAtPixel(o2) + 1;
                  "Above" === t3.getHighlightPosition(o2) && a4--, t3.updateRowData({ add: r2.filter((a5) => {
                    var _a;
                    return !t3.getRowNode((_a = e4 == null ? void 0 : e4({ data: a5.data, level: 0, rowPinned: a5.rowPinned })) != null ? _a : a5.data.id);
                  }).map((e5) => e5.data), addIndex: a4 });
                }
                this.clearRowHighlight();
              }
              clearRowHighlight() {
                this.clientSideRowModel.highlightRowAtPixel(null);
              }
              moveRows(e3, t3, a3 = 0) {
                const n2 = this.beans.focusSvc, o2 = n2.getFocusedCell(), i2 = o2 && (0, r._getCellByPosition)(this.beans, o2);
                this.clientSideRowModel.ensureRowsAtPixel(e3, t3, a3) && (i2 ? i2.focusCell() : n2.clearFocusedCell());
              }
              addRowDropZone(e3) {
                if (!e3.getContainer())
                  return void (0, d._warn)(55);
                const t3 = this.beans.dragAndDrop;
                if (t3.findExternalZone(e3))
                  return void (0, d._warn)(56);
                let a3 = { getContainer: e3.getContainer };
                e3.fromGrid ? a3 = e3 : (e3.onDragEnter && (a3.onDragEnter = (t4) => {
                  e3.onDragEnter(this.draggingToRowDragEvent("rowDragEnter", t4));
                }), e3.onDragLeave && (a3.onDragLeave = (t4) => {
                  e3.onDragLeave(this.draggingToRowDragEvent("rowDragLeave", t4));
                }), e3.onDragging && (a3.onDragging = (t4) => {
                  e3.onDragging(this.draggingToRowDragEvent("rowDragMove", t4));
                }), e3.onDragStop && (a3.onDragStop = (t4) => {
                  e3.onDragStop(this.draggingToRowDragEvent("rowDragEnd", t4));
                }), e3.onDragCancel && (a3.onDragCancel = (t4) => {
                  e3.onDragCancel(this.draggingToRowDragEvent("rowDragCancel", t4));
                }));
                const n2 = __spreadValues({ isInterestedIn: (e4) => e4 === c.DragSourceType.RowDrag, getIconName: () => "move", external: true }, a3);
                t3.addDropTarget(n2), this.addDestroyFunc(() => t3.removeDropTarget(n2));
              }
              getRowDropZone(e3) {
                const t3 = this.getContainer.bind(this), a3 = this.onDragEnter.bind(this), n2 = this.onDragLeave.bind(this), o2 = this.onDragging.bind(this), r2 = this.onDragStop.bind(this), i2 = this.onDragCancel.bind(this);
                let l2;
                return l2 = e3 ? { getContainer: t3, onDragEnter: e3.onDragEnter ? (t4) => {
                  a3(t4), e3.onDragEnter(this.draggingToRowDragEvent("rowDragEnter", t4));
                } : a3, onDragLeave: e3.onDragLeave ? (t4) => {
                  n2(t4), e3.onDragLeave(this.draggingToRowDragEvent("rowDragLeave", t4));
                } : n2, onDragging: e3.onDragging ? (t4) => {
                  o2(t4), e3.onDragging(this.draggingToRowDragEvent("rowDragMove", t4));
                } : o2, onDragStop: e3.onDragStop ? (t4) => {
                  r2(t4), e3.onDragStop(this.draggingToRowDragEvent("rowDragEnd", t4));
                } : r2, onDragCancel: e3.onDragCancel ? (t4) => {
                  i2(t4), e3.onDragCancel(this.draggingToRowDragEvent("rowDragCancel", t4));
                } : i2, fromGrid: true } : { getContainer: t3, onDragEnter: a3, onDragLeave: n2, onDragging: o2, onDragStop: r2, onDragCancel: i2, fromGrid: true }, l2;
              }
              draggingToRowDragEvent(e3, t3) {
                const a3 = this.beans, { pageBounds: n2, rowModel: o2, gos: r2 } = a3, l2 = (0, i._getNormalisedMousePosition)(a3, t3).y;
                let s2, d2 = -1;
                l2 > n2.getCurrentPageHeight() || (d2 = o2.getRowIndexAtPixel(l2), s2 = o2.getRow(d2));
                return r2.addGridCommonParams({ type: e3, event: t3.event, node: t3.dragItem.rowNode, nodes: t3.dragItem.rowNodes, overIndex: d2, overNode: s2, y: l2, vDirection: t3.vDirection });
              }
              dispatchGridEvent(e3, t3) {
                const a3 = this.draggingToRowDragEvent(e3, t3);
                this.eventSvc.dispatchEvent(a3);
              }
              onDragLeave(e3) {
                this.dispatchGridEvent("rowDragLeave", e3), this.stopDragging(e3), this.gos.get("rowDragManaged") && this.clearRowHighlight();
              }
              onDragStop(e3) {
                this.dispatchGridEvent("rowDragEnd", e3), this.stopDragging(e3);
                const { dragAndDrop: t3, gos: a3 } = this.beans;
                a3.get("rowDragManaged") && (a3.get("suppressMoveWhenRowDragging") || !this.isFromThisGrid(e3)) && t3.isDropZoneWithinThisGrid(e3) && this.moveRowAndClearHighlight(e3);
              }
              onDragCancel(e3) {
                this.dispatchGridEvent("rowDragCancel", e3), this.stopDragging(e3);
                const { dragAndDrop: t3, gos: a3 } = this.beans;
                a3.get("rowDragManaged") && (a3.get("suppressMoveWhenRowDragging") || !this.isFromThisGrid(e3)) && t3.isDropZoneWithinThisGrid(e3) && this.clearRowHighlight();
              }
              stopDragging(e3) {
                this.autoScrollService.ensureCleared(), this.getRowNodes(e3).forEach((e4) => {
                  this.setRowNodeDragging(e4, false);
                });
              }
              setRowNodeDragging(e3, t3) {
                e3.dragging !== t3 && (e3.dragging = t3, e3.dispatchRowEvent("draggingChanged"));
              }
            }
            t2.RowDragFeature = g;
          }, 2895: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.RowDragService = void 0;
            const n = a2(8731), o = a2(7274), r = a2(1633), i = a2(2254);
            class l extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "rowDragSvc";
              }
              setupRowDrag(e3, t3) {
                const a3 = t3.createManagedBean(new i.RowDragFeature(e3)), n2 = this.beans.dragAndDrop;
                n2.addDropTarget(a3), t3.addDestroyFunc(() => n2.removeDropTarget(a3)), this.rowDragFeature = a3;
              }
              createRowDragComp(e3, t3, a3, n2, o2, i2) {
                return new r.RowDragComp(e3, t3, a3, n2, o2, i2);
              }
              createRowDragCompForRow(e3, t3) {
                if ((0, o._isCellSelectionEnabled)(this.gos))
                  return;
                const a3 = this.getLocaleTextFunc();
                return this.createRowDragComp(() => `1 ${a3("rowDragRow", "row")}`, e3, void 0, t3, void 0, true);
              }
              createRowDragCompForCell(e3, t3, a3, n2, r2, i2) {
                const l2 = this.gos;
                if (l2.get("rowDragManaged") && (!(0, o._isClientSideRowModel)(l2) || l2.get("pagination")))
                  return;
                return this.createRowDragComp(a3, e3, t3, n2, r2, i2);
              }
            }
            t2.RowDragService = l;
          }, 6564: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.cellEditingCSS = void 0, t2.cellEditingCSS = ".ag-cell-inline-editing{border:var(--ag-cell-editing-border)!important;border-radius:var(--ag-border-radius);box-shadow:var(--ag-cell-editing-shadow);padding:0;z-index:1;.ag-cell-edit-wrapper,.ag-cell-editor,.ag-cell-wrapper,:where(.ag-cell-editor) .ag-input-field-input,:where(.ag-cell-editor) .ag-wrapper{height:100%;line-height:normal;width:100%}}:where(.ag-popup-editor) .ag-large-text{background-color:var(--ag-background-color);border-radius:var(--ag-border-radius);box-shadow:var(--ag-dropdown-shadow);padding:0}.ag-large-text-input{height:auto;padding:var(--ag-cell-horizontal-padding)}:where(.ag-rtl .ag-large-text-input) textarea{resize:none}:where(.ag-ltr) .ag-checkbox-edit{padding-left:var(--ag-cell-horizontal-padding)}:where(.ag-rtl) .ag-checkbox-edit{padding-right:var(--ag-cell-horizontal-padding)}";
          }, 227: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.CheckboxCellEditor = void 0;
            const n = a2(5230), o = a2(66), r = a2(8020), i = a2(3598);
            class l extends i.PopupComponent {
              constructor() {
                super('\n            <div class="ag-cell-wrapper ag-cell-edit-wrapper ag-checkbox-edit">\n                <ag-checkbox role="presentation" data-ref="eCheckbox"></ag-checkbox>\n            </div>', [o.AgCheckboxSelector]), this.eCheckbox = r.RefPlaceholder;
              }
              init(e3) {
                var _a;
                this.params = e3;
                const t3 = (_a = e3.value) != null ? _a : void 0, a3 = this.eCheckbox;
                a3.setValue(t3);
                a3.getInputElement().setAttribute("tabindex", "-1"), this.setAriaLabel(t3), this.addManagedListeners(a3, { fieldValueChanged: (e4) => this.setAriaLabel(e4.selected) });
              }
              getValue() {
                return this.eCheckbox.getValue();
              }
              focusIn() {
                this.eCheckbox.getFocusableElement().focus();
              }
              afterGuiAttached() {
                this.params.cellStartedEdit && this.focusIn();
              }
              isPopup() {
                return false;
              }
              setAriaLabel(e3) {
                const t3 = this.getLocaleTextFunc(), a3 = (0, n._getAriaCheckboxStateName)(t3, e3), o2 = t3("ariaToggleCellValue", "Press SPACE to toggle cell value");
                this.eCheckbox.setInputAriaLabel(`${o2} (${a3})`);
              }
            }
            t2.CheckboxCellEditor = l;
          }, 5314: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.DateCellEditor = void 0;
            const n = a2(9827), o = a2(4422), r = a2(3611), i = a2(5336);
            class l {
              getTemplate() {
                return '<ag-input-date-field class="ag-cell-editor" data-ref="eInput"></ag-input-date-field>';
              }
              getAgComponents() {
                return [r.AgInputDateFieldSelector];
              }
              init(e3, t3) {
                this.eInput = e3, this.params = t3;
                const { min: a3, max: n2, step: o2 } = t3;
                null != a3 && e3.setMin(a3), null != n2 && e3.setMax(n2), null != o2 && e3.setStep(o2);
              }
              getValue() {
                const { eInput: e3, params: t3 } = this, a3 = e3.getDate();
                return (0, o._exists)(a3) || (0, o._exists)(t3.value) ? a3 != null ? a3 : null : t3.value;
              }
              getStartValue() {
                const { value: e3 } = this.params;
                if (e3 instanceof Date)
                  return (0, n._serialiseDate)(e3, false);
              }
            }
            class s extends i.SimpleCellEditor {
              constructor() {
                super(new l());
              }
            }
            t2.DateCellEditor = s;
          }, 2059: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.DateStringCellEditor = void 0;
            const n = a2(9827), o = a2(4422), r = a2(3611), i = a2(5336);
            class l {
              constructor(e3) {
                this.getDataTypeService = e3;
              }
              getTemplate() {
                return '<ag-input-date-field class="ag-cell-editor" data-ref="eInput"></ag-input-date-field>';
              }
              getAgComponents() {
                return [r.AgInputDateFieldSelector];
              }
              init(e3, t3) {
                this.eInput = e3, this.params = t3;
                const { min: a3, max: n2, step: o2 } = t3;
                null != a3 && e3.setMin(a3), null != n2 && e3.setMax(n2), null != o2 && e3.setStep(o2);
              }
              getValue() {
                const { params: e3, eInput: t3 } = this, a3 = this.formatDate(t3.getDate());
                return (0, o._exists)(a3) || (0, o._exists)(e3.value) ? e3.parseValue(a3 != null ? a3 : "") : e3.value;
              }
              getStartValue() {
                var _a, _b;
                return (0, n._serialiseDate)((_b = this.parseDate((_a = this.params.value) != null ? _a : void 0)) != null ? _b : null, false);
              }
              parseDate(e3) {
                var _a;
                const t3 = this.getDataTypeService();
                return t3 ? t3.getDateParserFunction(this.params.column)(e3) : (_a = (0, n._parseDateTimeFromString)(e3)) != null ? _a : void 0;
              }
              formatDate(e3) {
                var _a;
                const t3 = this.getDataTypeService();
                return t3 ? t3.getDateFormatterFunction(this.params.column)(e3) : (_a = (0, n._serialiseDate)(e3 != null ? e3 : null, false)) != null ? _a : void 0;
              }
            }
            class s extends i.SimpleCellEditor {
              constructor() {
                super(new l(() => this.beans.dataTypeSvc));
              }
            }
            t2.DateStringCellEditor = s;
          }, 4578: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.LargeTextCellEditor = void 0;
            const n = a2(9853), o = a2(4422), r = a2(6209), i = a2(8020), l = a2(3598);
            class s extends l.PopupComponent {
              constructor() {
                super('<div class="ag-large-text">\n        <ag-input-text-area data-ref="eTextArea" class="ag-large-text-input"></ag-input-text-area>\n        </div>', [r.AgInputTextAreaSelector]), this.eTextArea = i.RefPlaceholder;
              }
              init(e3) {
                this.params = e3, this.focusAfterAttached = e3.cellStartedEdit, this.eTextArea.setMaxLength(e3.maxLength || 200).setCols(e3.cols || 60).setRows(e3.rows || 10), null != e3.value && this.eTextArea.setValue(e3.value.toString(), true), this.addGuiEventListener("keydown", this.onKeyDown.bind(this)), this.activateTabIndex();
              }
              onKeyDown(e3) {
                const t3 = e3.key;
                (t3 === n.KeyCode.LEFT || t3 === n.KeyCode.UP || t3 === n.KeyCode.RIGHT || t3 === n.KeyCode.DOWN || e3.shiftKey && t3 === n.KeyCode.ENTER) && e3.stopPropagation();
              }
              afterGuiAttached() {
                const e3 = this.getLocaleTextFunc();
                this.eTextArea.setInputAriaLabel(e3("ariaInputEditor", "Input Editor")), this.focusAfterAttached && this.eTextArea.getFocusableElement().focus();
              }
              getValue() {
                const e3 = this.eTextArea.getValue(), t3 = this.params;
                return (0, o._exists)(e3) || (0, o._exists)(t3.value) ? t3.parseValue(e3) : t3.value;
              }
            }
            t2.LargeTextCellEditor = s;
          }, 4371: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.NumberCellEditor = void 0;
            const n = a2(9853), o = a2(8667), r = a2(4422), i = a2(8792), l = a2(5336);
            class s {
              getTemplate() {
                return '<ag-input-number-field class="ag-cell-editor" data-ref="eInput"></ag-input-number-field>';
              }
              getAgComponents() {
                return [i.AgInputNumberFieldSelector];
              }
              init(e3, t3) {
                this.eInput = e3, this.params = t3;
                const { max: a3, min: n2, precision: o2, step: r2 } = t3;
                null != a3 && e3.setMax(a3), null != n2 && e3.setMin(n2), null != o2 && e3.setPrecision(o2), null != r2 && e3.setStep(r2);
                const i2 = e3.getInputElement();
                t3.preventStepping ? e3.addManagedElementListeners(i2, { keydown: this.preventStepping }) : t3.showStepperButtons && i2.classList.add("ag-number-field-input-stepper");
              }
              preventStepping(e3) {
                e3.key !== n.KeyCode.UP && e3.key !== n.KeyCode.DOWN || e3.preventDefault();
              }
              getValue() {
                const { eInput: e3, params: t3 } = this, a3 = e3.getValue();
                if (!(0, r._exists)(a3) && !(0, r._exists)(t3.value))
                  return t3.value;
                let n2 = t3.parseValue(a3);
                if (null == n2)
                  return n2;
                if ("string" == typeof n2) {
                  if ("" === n2)
                    return null;
                  n2 = Number(n2);
                }
                return isNaN(n2) ? null : n2;
              }
              getStartValue() {
                return this.params.value;
              }
              setCaret() {
                (0, o._isBrowserSafari)() && this.eInput.getInputElement().focus({ preventScroll: true });
              }
            }
            class d extends l.SimpleCellEditor {
              constructor() {
                super(new s());
              }
            }
            t2.NumberCellEditor = d;
          }, 5609: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.PopupEditorWrapper = void 0;
            const n = a2(7274), o = a2(6466), r = a2(3598);
            class i extends r.PopupComponent {
              constructor(e3) {
                super('<div class="ag-popup-editor" tabindex="-1"/>'), this.params = e3;
              }
              postConstruct() {
                (0, n._setDomData)(this.gos, this.getGui(), "popupEditorWrapper", true), this.addKeyDownListener();
              }
              addKeyDownListener() {
                const e3 = this.getGui(), t3 = this.params;
                this.addManagedElementListeners(e3, { keydown: (e4) => {
                  (0, o._isUserSuppressingKeyboardEvent)(this.gos, e4, t3.node, t3.column, true) || t3.onKeyDown(e4);
                } });
              }
            }
            t2.PopupEditorWrapper = i;
          }, 8774: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.SelectCellEditor = void 0;
            const n = a2(9853), o = a2(4422), r = a2(7764), i = a2(159), l = a2(8020), s = a2(3598);
            class d extends s.PopupComponent {
              wireBeans(e3) {
                this.valueSvc = e3.valueSvc;
              }
              constructor() {
                super('<div class="ag-cell-edit-wrapper">\n                <ag-select class="ag-cell-editor" data-ref="eSelect"></ag-select>\n            </div>', [i.AgSelectSelector]), this.eSelect = l.RefPlaceholder, this.startedByEnter = false;
              }
              init(e3) {
                this.focusAfterAttached = e3.cellStartedEdit;
                const { eSelect: t3, valueSvc: a3, gos: i2 } = this, { values: l2, value: s2, eventKey: d2 } = e3;
                if ((0, o._missing)(l2))
                  return void (0, r._warn)(58);
                this.startedByEnter = null != d2 && d2 === n.KeyCode.ENTER;
                let c = false;
                l2.forEach((n2) => {
                  const o2 = { value: n2 }, r2 = a3.formatValue(e3.column, null, n2), i3 = null != r2;
                  o2.text = i3 ? r2 : n2, t3.addOption(o2), c = c || s2 === n2;
                }), c ? t3.setValue(e3.value, true) : e3.values.length && t3.setValue(e3.values[0], true);
                const { valueListGap: g, valueListMaxWidth: u, valueListMaxHeight: h } = e3;
                null != g && t3.setPickerGap(g), null != h && t3.setPickerMaxHeight(h), null != u && t3.setPickerMaxWidth(u), "fullRow" !== i2.get("editType") && this.addManagedListeners(this.eSelect, { selectedItem: () => e3.stopEditing() });
              }
              afterGuiAttached() {
                this.focusAfterAttached && this.eSelect.getFocusableElement().focus(), this.startedByEnter && setTimeout(() => {
                  this.isAlive() && this.eSelect.showPicker();
                });
              }
              focusIn() {
                this.eSelect.getFocusableElement().focus();
              }
              getValue() {
                return this.eSelect.getValue();
              }
              isPopup() {
                return false;
              }
            }
            t2.SelectCellEditor = d;
          }, 5336: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.SimpleCellEditor = void 0;
            const n = a2(9853), o = a2(8667), r = a2(8020), i = a2(3598);
            class l extends i.PopupComponent {
              constructor(e3) {
                super(`
            <div class="ag-cell-edit-wrapper">
                ${e3.getTemplate()}
            </div>`, e3.getAgComponents()), this.cellEditorInput = e3, this.eInput = r.RefPlaceholder;
              }
              init(e3) {
                this.params = e3;
                const { cellStartedEdit: t3, eventKey: a3, suppressPreventDefault: o2 } = e3, r2 = this.eInput;
                let i2;
                this.cellEditorInput.init(r2, e3);
                let l2 = true;
                t3 ? (this.focusAfterAttached = true, a3 === n.KeyCode.BACKSPACE || a3 === n.KeyCode.DELETE ? i2 = "" : a3 && 1 === a3.length ? o2 ? l2 = false : i2 = a3 : (i2 = this.cellEditorInput.getStartValue(), a3 !== n.KeyCode.F2 && (this.highlightAllOnFocus = true))) : (this.focusAfterAttached = false, i2 = this.cellEditorInput.getStartValue()), l2 && null != i2 && r2.setStartValue(i2), this.addManagedElementListeners(r2.getGui(), { keydown: (e4) => {
                  const { key: t4 } = e4;
                  t4 !== n.KeyCode.PAGE_UP && t4 !== n.KeyCode.PAGE_DOWN || e4.preventDefault();
                } });
              }
              afterGuiAttached() {
                var _a, _b;
                const e3 = this.getLocaleTextFunc(), t3 = this.eInput;
                if (t3.setInputAriaLabel(e3("ariaInputEditor", "Input Editor")), !this.focusAfterAttached)
                  return;
                (0, o._isBrowserSafari)() || t3.getFocusableElement().focus();
                const a3 = t3.getInputElement();
                this.highlightAllOnFocus ? a3.select() : (_b = (_a = this.cellEditorInput).setCaret) == null ? void 0 : _b.call(_a);
              }
              focusIn() {
                const e3 = this.eInput, t3 = e3.getFocusableElement(), a3 = e3.getInputElement();
                t3.focus(), a3.select();
              }
              getValue() {
                return this.cellEditorInput.getValue();
              }
              isPopup() {
                return false;
              }
            }
            t2.SimpleCellEditor = l;
          }, 5457: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.TextCellEditor = void 0;
            const n = a2(4422), o = a2(5946), r = a2(5336);
            class i {
              getTemplate() {
                return '<ag-input-text-field class="ag-cell-editor" data-ref="eInput"></ag-input-text-field>';
              }
              getAgComponents() {
                return [o.AgInputTextFieldSelector];
              }
              init(e3, t3) {
                this.eInput = e3, this.params = t3;
                const a3 = t3.maxLength;
                null != a3 && e3.setMaxLength(a3);
              }
              getValue() {
                const { eInput: e3, params: t3 } = this, a3 = e3.getValue();
                return (0, n._exists)(a3) || (0, n._exists)(t3.value) ? t3.parseValue(a3) : t3.value;
              }
              getStartValue() {
                const e3 = this.params;
                return e3.useFormatter || e3.column.getColDef().refData ? e3.formatValue(e3.value) : e3.value;
              }
              setCaret() {
                const e3 = this.eInput, t3 = e3.getValue(), a3 = (0, n._exists)(t3) && t3.length || 0;
                a3 && e3.getInputElement().setSelectionRange(a3, a3);
              }
            }
            class l extends r.SimpleCellEditor {
              constructor() {
                super(new i());
              }
            }
            t2.TextCellEditor = l;
          }, 89: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.getCurrentRedoSize = t2.getCurrentUndoSize = t2.startEditingCell = t2.stopEditing = t2.getEditingCells = t2.getCellEditorInstances = t2.redoCellEditing = t2.undoCellEditing = void 0;
            const n = a2(1765), o = a2(4126), r = a2(6257), i = a2(7274), l = a2(7764);
            t2.undoCellEditing = function(e3) {
              var _a;
              (_a = e3.undoRedo) == null ? void 0 : _a.undo("api");
            }, t2.redoCellEditing = function(e3) {
              var _a;
              (_a = e3.undoRedo) == null ? void 0 : _a.redo("api");
            }, t2.getCellEditorInstances = function(e3, t3 = {}) {
              const a3 = [];
              return e3.rowRenderer.getCellCtrls(t3.rowNodes, t3.columns).forEach((e4) => {
                var _a;
                const t4 = (_a = e4.comp) == null ? void 0 : _a.getCellEditor();
                t4 && a3.push((0, o._unwrapUserComp)(t4));
              }), a3;
            }, t2.getEditingCells = function(e3) {
              const t3 = [];
              return e3.rowRenderer.getAllCellCtrls().forEach((e4) => {
                if (e4.editing) {
                  const { cellPosition: a3 } = e4;
                  t3.push(a3);
                }
              }), t3;
            }, t2.stopEditing = function(e3, t3 = false) {
              var _a;
              (_a = e3.editSvc) == null ? void 0 : _a.stopAllEditing(t3);
            }, t2.startEditingCell = function(e3, t3) {
              const a3 = e3.colModel.getCol(t3.colKey);
              if (!a3)
                return void (0, l._warn)(12, { colKey: t3.colKey });
              const o2 = { rowIndex: t3.rowIndex, rowPinned: t3.rowPinned || null, column: a3 };
              null == t3.rowPinned && (0, n.ensureIndexVisible)(e3, t3.rowIndex), (0, n.ensureColumnVisible)(e3, t3.colKey);
              const s = (0, r._getCellByPosition)(e3, o2);
              if (!s)
                return;
              const { focusSvc: d, gos: c, editSvc: g } = e3, u = c.get("stopEditingWhenCellsLoseFocus") && (() => {
                const t4 = (0, i._getActiveDomElement)(e3), a4 = s.eGui;
                return t4 !== a4 && !!(a4 == null ? void 0 : a4.contains(t4));
              })();
              !u && d.isCellFocused(o2) || d.setFocusedCell(__spreadProps(__spreadValues({}, o2), { forceBrowserFocus: u, preventScrollOnBrowserFocus: true })), g == null ? void 0 : g.startRowOrCellEdit(s, t3.key);
            }, t2.getCurrentUndoSize = function(e3) {
              var _a, _b;
              return (_b = (_a = e3.undoRedo) == null ? void 0 : _a.getCurrentUndoStackSize()) != null ? _b : 0;
            }, t2.getCurrentRedoSize = function(e3) {
              var _a, _b;
              return (_b = (_a = e3.undoRedo) == null ? void 0 : _a.getCurrentRedoStackSize()) != null ? _b : 0;
            };
          }, 4652: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.CustomEditorModule = t2.LargeTextEditorModule = t2.SelectEditorModule = t2.CheckboxEditorModule = t2.DateEditorModule = t2.NumberEditorModule = t2.TextEditorModule = t2.UndoRedoEditModule = t2.EditCoreModule = void 0;
            const n = a2(7113), o = a2(7205), r = a2(3137), i = a2(6564), l = a2(227), s = a2(5314), d = a2(2059), c = a2(4578), g = a2(4371), u = a2(8774), h = a2(5457), p = a2(89), m = a2(1277), f = a2(6359);
            t2.EditCoreModule = { moduleName: "EditCore", version: o.VERSION, beans: [m.EditService, f.RowEditService], apiFunctions: { getCellEditorInstances: p.getCellEditorInstances, getEditingCells: p.getEditingCells, stopEditing: p.stopEditing, startEditingCell: p.startEditingCell }, dependsOn: [r.PopupModule], css: [i.cellEditingCSS] }, t2.UndoRedoEditModule = { moduleName: "UndoRedoEdit", version: o.VERSION, beans: [n.UndoRedoService], apiFunctions: { undoCellEditing: p.undoCellEditing, redoCellEditing: p.redoCellEditing, getCurrentUndoSize: p.getCurrentUndoSize, getCurrentRedoSize: p.getCurrentRedoSize }, dependsOn: [t2.EditCoreModule] }, t2.TextEditorModule = { moduleName: "TextEditor", version: o.VERSION, userComponents: { agCellEditor: h.TextCellEditor, agTextCellEditor: h.TextCellEditor }, dependsOn: [t2.EditCoreModule] }, t2.NumberEditorModule = { moduleName: "NumberEditor", version: o.VERSION, userComponents: { agNumberCellEditor: { classImp: g.NumberCellEditor, params: { suppressPreventDefault: true } } }, dependsOn: [t2.EditCoreModule] }, t2.DateEditorModule = { moduleName: "DateEditor", version: o.VERSION, userComponents: { agDateCellEditor: s.DateCellEditor, agDateStringCellEditor: d.DateStringCellEditor }, dependsOn: [t2.EditCoreModule] }, t2.CheckboxEditorModule = { moduleName: "CheckboxEditor", version: o.VERSION, userComponents: { agCheckboxCellEditor: l.CheckboxCellEditor }, dependsOn: [t2.EditCoreModule] }, t2.SelectEditorModule = { moduleName: "SelectEditor", version: o.VERSION, userComponents: { agSelectCellEditor: u.SelectCellEditor }, dependsOn: [t2.EditCoreModule] }, t2.LargeTextEditorModule = { moduleName: "LargeTextEditor", version: o.VERSION, userComponents: { agLargeTextCellEditor: c.LargeTextCellEditor }, dependsOn: [t2.EditCoreModule] }, t2.CustomEditorModule = { moduleName: "CustomEditor", version: o.VERSION, dependsOn: [t2.EditCoreModule] };
          }, 1277: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.EditService = void 0;
            const n = a2(2036), o = a2(9853), r = a2(8731), i = a2(8399), l = a2(8667), s = a2(5609);
            class d extends r.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "editSvc";
              }
              startEditing(e3, t3 = null, a3 = false, o2 = null) {
                var _a;
                if (!e3.isCellEditable() || e3.editing)
                  return true;
                if (!e3.comp)
                  return e3.onCompAttachedFuncs.push(() => {
                    this.startEditing(e3, t3, a3, o2);
                  }), true;
                const r2 = this.createCellEditorParams(e3, t3, a3), i2 = e3.column.getColDef(), l2 = (0, n._getCellEditorDetails)(this.beans.userCompFactory, i2, r2), s2 = null != (l2 == null ? void 0 : l2.popupFromSelector) ? l2.popupFromSelector : !!i2.cellEditorPopup, d2 = null != (l2 == null ? void 0 : l2.popupPositionFromSelector) ? l2.popupPositionFromSelector : i2.cellEditorPopupPosition;
                return c(e3, true, l2), e3.comp.setEditDetails(l2, s2, d2, this.gos.get("reactiveCustomComponents")), this.eventSvc.dispatchEvent(e3.createEvent(o2, "cellEditingStarted")), !((_a = l2 == null ? void 0 : l2.params) == null ? void 0 : _a.suppressPreventDefault);
              }
              stopEditing(e3, t3 = false) {
                if (e3.onEditorAttachedFuncs = [], !e3.editing)
                  return false;
                const { comp: a3, column: n2, rowNode: o2 } = e3, { newValue: r2, newValueExists: i2 } = function(e4, t4) {
                  const a4 = { newValueExists: false };
                  if (e4)
                    return a4;
                  const n3 = t4.getCellEditor();
                  if (!n3)
                    return a4;
                  if (n3.isCancelAfterEnd && n3.isCancelAfterEnd())
                    return a4;
                  const o3 = n3.getValue();
                  return { newValue: o3, newValueExists: true };
                }(t3, a3), l2 = this.beans.valueSvc.getValueForDisplay(n2, o2);
                let s2 = false;
                return i2 && (s2 = function(e4, t4, a4, n3, o3) {
                  if (a4 === t4)
                    return false;
                  e4.suppressRefreshCell = true;
                  const r3 = n3.setDataValue(o3, a4, "edit");
                  return e4.suppressRefreshCell = false, r3;
                }(e3, l2, r2, o2, n2)), c(e3, false, void 0), a3.setEditDetails(), e3.updateAndFormatValue(false), e3.refreshCell({ forceRefresh: true, suppressFlash: true }), this.eventSvc.dispatchEvent(__spreadProps(__spreadValues({}, e3.createEvent(null, "cellEditingStopped")), { oldValue: l2, newValue: r2, valueChanged: s2 })), s2;
              }
              handleColDefChanged(e3) {
                var _a;
                const t3 = (_a = e3.comp) == null ? void 0 : _a.getCellEditor();
                if (t3 == null ? void 0 : t3.refresh) {
                  const { eventKey: a3, cellStartedEdit: o2 } = e3.editCompDetails.params, r2 = this.createCellEditorParams(e3, a3, o2), i2 = e3.column.getColDef(), l2 = (0, n._getCellEditorDetails)(this.beans.userCompFactory, i2, r2);
                  t3.refresh(l2.params);
                }
              }
              setFocusOutOnEditor(e3) {
                if (!e3.editing)
                  return;
                const t3 = e3.comp.getCellEditor();
                t3 && t3.focusOut && t3.focusOut();
              }
              setFocusInOnEditor(e3) {
                if (!e3.editing)
                  return;
                const t3 = e3.comp, a3 = t3.getCellEditor();
                (a3 == null ? void 0 : a3.focusIn) ? a3.focusIn() : (e3.focusCell(true), e3.onEditorAttachedFuncs.push(() => {
                  var _a, _b;
                  return (_b = (_a = t3.getCellEditor()) == null ? void 0 : _a.focusIn) == null ? void 0 : _b.call(_a);
                }));
              }
              stopEditingAndFocus(e3, t3 = false, a3 = false) {
                this.stopRowOrCellEdit(e3), e3.focusCell(true), t3 || this.navigateAfterEdit(a3, e3.cellPosition);
              }
              createPopupEditorWrapper(e3) {
                return new s.PopupEditorWrapper(e3);
              }
              stopAllEditing(e3 = false) {
                this.beans.rowRenderer.getAllRowCtrls().forEach((t3) => this.stopRowEditing(t3, e3));
              }
              stopRowEditing(e3, t3 = false) {
                var _a;
                if (e3.stoppingRowEdit)
                  return;
                const a3 = e3.getAllCellCtrls(), n2 = e3.editing;
                e3.stoppingRowEdit = true;
                let o2 = false;
                for (const e4 of a3) {
                  const a4 = e4.stopEditing(t3);
                  n2 && !t3 && !o2 && a4 && (o2 = true);
                }
                o2 && this.eventSvc.dispatchEvent(e3.createRowEvent("rowValueChanged")), n2 && ((_a = this.beans.rowEditSvc) == null ? void 0 : _a.setEditing(e3, false)), e3.stoppingRowEdit = false;
              }
              addStopEditingWhenGridLosesFocus(e3) {
                if (!this.gos.get("stopEditingWhenCellsLoseFocus"))
                  return;
                const t3 = (t4) => {
                  const a3 = t4.relatedTarget;
                  if (null === (0, l._getTabIndex)(a3))
                    return void this.stopAllEditing();
                  let n2 = e3.some((e4) => e4.contains(a3)) && (0, i._isElementInThisGrid)(this.gos, a3);
                  if (!n2) {
                    const e4 = this.beans.popupSvc;
                    n2 = !!e4 && (e4.getActivePopups().some((e5) => e5.contains(a3)) || e4.isElementWithinCustomPopup(a3));
                  }
                  n2 || this.stopAllEditing();
                };
                e3.forEach((e4) => this.addManagedElementListeners(e4, { focusout: t3 }));
              }
              setInlineEditingCss(e3) {
                const t3 = e3.editing || e3.getAllCellCtrls().some((e4) => e4.editing);
                e3.forEachGui(void 0, (e4) => {
                  e4.rowComp.addOrRemoveCssClass("ag-row-inline-editing", t3), e4.rowComp.addOrRemoveCssClass("ag-row-not-inline-editing", !t3);
                });
              }
              isCellEditable(e3, t3) {
                if (t3.group) {
                  if (this.gos.get("treeData")) {
                    if (!t3.data && !this.gos.get("enableGroupEdit"))
                      return false;
                  } else if (!this.gos.get("enableGroupEdit"))
                    return false;
                }
                return e3.isColumnFunc(t3, e3.colDef.editable);
              }
              startRowOrCellEdit(e3, t3, a3 = null) {
                var _a, _b;
                return e3.comp ? "fullRow" === this.gos.get("editType") ? (_b = (_a = this.beans.rowEditSvc) == null ? void 0 : _a.startEditing(e3.rowCtrl, t3, e3)) != null ? _b : true : this.startEditing(e3, t3, true, a3) : (e3.onCompAttachedFuncs.push(() => {
                  this.startRowOrCellEdit(e3, t3, a3);
                }), true);
              }
              stopRowOrCellEdit(e3, t3 = false) {
                "fullRow" === this.gos.get("editType") ? this.stopRowEditing(e3.rowCtrl, t3) : this.stopEditing(e3, t3);
              }
              createCellEditorParams(e3, t3, a3) {
                const { column: n2, rowNode: o2, eGui: r2, cellPosition: { rowIndex: i2 } } = e3, { valueSvc: l2, gos: s2 } = this.beans;
                return s2.addGridCommonParams({ value: l2.getValueForDisplay(n2, o2), eventKey: t3, column: n2, colDef: n2.getColDef(), rowIndex: i2, node: o2, data: o2.data, cellStartedEdit: a3, onKeyDown: e3.onKeyDown.bind(e3), stopEditing: e3.stopEditingAndFocus.bind(e3), eGridCell: r2, parseValue: (t4) => l2.parseValue(n2, o2, t4, e3.value), formatValue: e3.formatValue.bind(e3) });
              }
              navigateAfterEdit(e3, t3) {
                var _a;
                if (this.gos.get("enterNavigatesVerticallyAfterEdit")) {
                  const a3 = e3 ? o.KeyCode.UP : o.KeyCode.DOWN;
                  (_a = this.beans.navigation) == null ? void 0 : _a.navigateToNextCell(null, a3, t3, false);
                }
              }
            }
            function c(e3, t3, a3) {
              e3.editCompDetails = a3, e3.editing !== t3 && (e3.editing = t3);
            }
            t2.EditService = d;
          }, 6359: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.RowEditService = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "rowEditSvc";
              }
              startEditing(e3, t3 = null, a3 = null, n2 = null) {
                if (e3.editing)
                  return true;
                let o2 = true, r = false;
                const { editSvc: i } = this.beans;
                return e3.getAllCellCtrls().forEach((e4) => {
                  var _a;
                  const l = e4 === a3;
                  l ? o2 = (_a = i == null ? void 0 : i.startEditing(e4, t3, l, n2)) != null ? _a : true : i == null ? void 0 : i.startEditing(e4, null, l, n2), r || (r = e4.editing);
                }), r && this.setEditing(e3, true), o2;
              }
              setEditing(e3, t3) {
                e3.editing = t3, e3.forEachGui(void 0, (e4) => e4.rowComp.addOrRemoveCssClass("ag-row-editing", t3));
                const a3 = t3 ? e3.createRowEvent("rowEditingStarted") : e3.createRowEvent("rowEditingStopped");
                this.eventSvc.dispatchEvent(a3);
              }
            }
            t2.RowEditService = o;
          }, 3355: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.AgColumn = t2.isColumn = t2.getNextColInstanceId = void 0;
            const n = a2(8731), o = a2(5889), r = a2(4422), i = a2(6996), l = a2(7764), s = { resizable: true, sortable: true };
            let d = 0;
            function c() {
              return d++;
            }
            t2.getNextColInstanceId = c, t2.isColumn = function(e3) {
              return e3 instanceof g;
            };
            class g extends n.BeanStub {
              constructor(e3, t3, a3, n2) {
                super(), this.colDef = e3, this.userProvidedColDef = t3, this.colId = a3, this.primary = n2, this.isColumn = true, this.instanceId = c(), this.autoHeaderHeight = null, this.moving = false, this.menuVisible = false, this.lastLeftPinned = false, this.firstRightPinned = false, this.filterActive = false, this.colEventSvc = new o.LocalEventService(), this.tooltipEnabled = false, this.rowGroupActive = false, this.pivotActive = false, this.aggregationActive = false, this.flex = null;
              }
              getInstanceId() {
                return this.instanceId;
              }
              setState() {
                const { colDef: e3, beans: { sortSvc: t3, pinnedCols: a3, colFlex: n2 } } = this;
                t3 == null ? void 0 : t3.initCol(this);
                const o2 = e3.hide;
                this.visible = void 0 !== o2 ? !o2 : !e3.initialHide, a3 == null ? void 0 : a3.initCol(this), n2 == null ? void 0 : n2.initCol(this);
              }
              setColDef(e3, t3, a3) {
                this.colDef = e3, this.userProvidedColDef = t3, this.initMinAndMaxWidths(), this.initDotNotation(), this.initTooltip(), this.dispatchColEvent("colDefChanged", a3);
              }
              getUserProvidedColDef() {
                return this.userProvidedColDef;
              }
              getParent() {
                return this.parent;
              }
              getOriginalParent() {
                return this.originalParent;
              }
              postConstruct() {
                this.setState(), this.initMinAndMaxWidths(), this.resetActualWidth("gridInitializing"), this.initDotNotation(), this.initTooltip();
              }
              initDotNotation() {
                const { gos: e3, colDef: { field: t3, tooltipField: a3 } } = this, n2 = e3.get("suppressFieldDotNotation");
                this.fieldContainsDots = (0, r._exists)(t3) && t3.indexOf(".") >= 0 && !n2, this.tooltipFieldContainsDots = (0, r._exists)(a3) && a3.indexOf(".") >= 0 && !n2;
              }
              initMinAndMaxWidths() {
                var _a, _b;
                const e3 = this.colDef;
                this.minWidth = (_a = e3.minWidth) != null ? _a : this.beans.environment.getDefaultColumnMinWidth(), this.maxWidth = (_b = e3.maxWidth) != null ? _b : Number.MAX_SAFE_INTEGER;
              }
              initTooltip() {
                var _a;
                (_a = this.beans.tooltipSvc) == null ? void 0 : _a.initCol(this);
              }
              resetActualWidth(e3) {
                const t3 = this.calculateColInitialWidth(this.colDef);
                this.setActualWidth(t3, e3, true);
              }
              calculateColInitialWidth(e3) {
                let t3;
                const a3 = e3.width, n2 = e3.initialWidth;
                return t3 = null != a3 ? a3 : null != n2 ? n2 : 200, Math.max(Math.min(t3, this.maxWidth), this.minWidth);
              }
              isEmptyGroup() {
                return false;
              }
              isRowGroupDisplayed(e3) {
                var _a, _b;
                return (_b = (_a = this.beans.showRowGroupCols) == null ? void 0 : _a.isRowGroupDisplayed(this, e3)) != null ? _b : false;
              }
              isPrimary() {
                return this.primary;
              }
              isFilterAllowed() {
                return !!this.colDef.filter;
              }
              isFieldContainsDots() {
                return this.fieldContainsDots;
              }
              isTooltipEnabled() {
                return this.tooltipEnabled;
              }
              isTooltipFieldContainsDots() {
                return this.tooltipFieldContainsDots;
              }
              getHighlighted() {
                return this.highlighted;
              }
              addEventListener(e3, t3) {
                var _a, _b, _c, _d;
                this.frameworkEventListenerService = (_b = (_a = this.beans.frameworkOverrides).createLocalEventListenerWrapper) == null ? void 0 : _b.call(_a, this.frameworkEventListenerService, this.colEventSvc);
                const a3 = (_d = (_c = this.frameworkEventListenerService) == null ? void 0 : _c.wrap(t3)) != null ? _d : t3;
                this.colEventSvc.addEventListener(e3, a3);
              }
              removeEventListener(e3, t3) {
                var _a, _b;
                const a3 = (_b = (_a = this.frameworkEventListenerService) == null ? void 0 : _a.unwrap(t3)) != null ? _b : t3;
                this.colEventSvc.removeEventListener(e3, a3);
              }
              createColumnFunctionCallbackParams(e3) {
                return this.gos.addGridCommonParams({ node: e3, data: e3.data, column: this, colDef: this.colDef });
              }
              isSuppressNavigable(e3) {
                var _a, _b;
                return (_b = (_a = this.beans.cellNavigation) == null ? void 0 : _a.isSuppressNavigable(this, e3)) != null ? _b : false;
              }
              isCellEditable(e3) {
                var _a, _b;
                return (_b = (_a = this.beans.editSvc) == null ? void 0 : _a.isCellEditable(this, e3)) != null ? _b : false;
              }
              isSuppressFillHandle() {
                return !!this.colDef.suppressFillHandle;
              }
              isAutoHeight() {
                return !!this.colDef.autoHeight;
              }
              isAutoHeaderHeight() {
                return !!this.colDef.autoHeaderHeight;
              }
              isRowDrag(e3) {
                return this.isColumnFunc(e3, this.colDef.rowDrag);
              }
              isDndSource(e3) {
                return this.isColumnFunc(e3, this.colDef.dndSource);
              }
              isCellCheckboxSelection(e3) {
                var _a, _b;
                return (_b = (_a = this.beans.selectionSvc) == null ? void 0 : _a.isCellCheckboxSelection(this, e3)) != null ? _b : false;
              }
              isSuppressPaste(e3) {
                var _a, _b;
                return this.isColumnFunc(e3, (_b = (_a = this.colDef) == null ? void 0 : _a.suppressPaste) != null ? _b : null);
              }
              isResizable() {
                return !!this.getColDefValue("resizable");
              }
              getColDefValue(e3) {
                var _a;
                return (_a = this.colDef[e3]) != null ? _a : s[e3];
              }
              isColumnFunc(e3, t3) {
                if ("boolean" == typeof t3)
                  return t3;
                if ("function" == typeof t3) {
                  return t3(this.createColumnFunctionCallbackParams(e3));
                }
                return false;
              }
              createColumnEvent(e3, t3) {
                return this.gos.addGridCommonParams({ type: e3, column: this, columns: [this], source: t3 });
              }
              isMoving() {
                return this.moving;
              }
              getSort() {
                return this.sort;
              }
              isSortable() {
                return !!this.getColDefValue("sortable");
              }
              isSortAscending() {
                return "asc" === this.sort;
              }
              isSortDescending() {
                return "desc" === this.sort;
              }
              isSortNone() {
                return (0, r._missing)(this.sort);
              }
              isSorting() {
                return (0, r._exists)(this.sort);
              }
              getSortIndex() {
                return this.sortIndex;
              }
              isMenuVisible() {
                return this.menuVisible;
              }
              getAggFunc() {
                return this.aggFunc;
              }
              getLeft() {
                return this.left;
              }
              getOldLeft() {
                return this.oldLeft;
              }
              getRight() {
                return this.left + this.actualWidth;
              }
              setLeft(e3, t3) {
                this.oldLeft = this.left, this.left !== e3 && (this.left = e3, this.dispatchColEvent("leftChanged", t3));
              }
              isFilterActive() {
                return this.filterActive;
              }
              isHovered() {
                var _a;
                return (0, l._warn)(261), !!((_a = this.beans.colHover) == null ? void 0 : _a.isHovered(this));
              }
              setFirstRightPinned(e3, t3) {
                this.firstRightPinned !== e3 && (this.firstRightPinned = e3, this.dispatchColEvent("firstRightPinnedChanged", t3));
              }
              setLastLeftPinned(e3, t3) {
                this.lastLeftPinned !== e3 && (this.lastLeftPinned = e3, this.dispatchColEvent("lastLeftPinnedChanged", t3));
              }
              isFirstRightPinned() {
                return this.firstRightPinned;
              }
              isLastLeftPinned() {
                return this.lastLeftPinned;
              }
              isPinned() {
                return "left" === this.pinned || "right" === this.pinned;
              }
              isPinnedLeft() {
                return "left" === this.pinned;
              }
              isPinnedRight() {
                return "right" === this.pinned;
              }
              getPinned() {
                return this.pinned;
              }
              setVisible(e3, t3) {
                const a3 = true === e3;
                this.visible !== a3 && (this.visible = a3, this.dispatchColEvent("visibleChanged", t3)), this.dispatchStateUpdatedEvent("hide");
              }
              isVisible() {
                return this.visible;
              }
              isSpanHeaderHeight() {
                return !this.getColDef().suppressSpanHeaderHeight;
              }
              getColumnGroupPaddingInfo() {
                let e3 = this.getParent();
                if (!e3 || !e3.isPadding())
                  return { numberOfParents: 0, isSpanningTotal: false };
                const t3 = e3.getPaddingLevel() + 1;
                let a3 = true;
                for (; e3; ) {
                  if (!e3.isPadding()) {
                    a3 = false;
                    break;
                  }
                  e3 = e3.getParent();
                }
                return { numberOfParents: t3, isSpanningTotal: a3 };
              }
              getColDef() {
                return this.colDef;
              }
              getDefinition() {
                return this.colDef;
              }
              getColumnGroupShow() {
                return this.colDef.columnGroupShow;
              }
              getColId() {
                return this.colId;
              }
              getId() {
                return this.colId;
              }
              getUniqueId() {
                return this.colId;
              }
              getActualWidth() {
                return this.actualWidth;
              }
              getAutoHeaderHeight() {
                return this.autoHeaderHeight;
              }
              setAutoHeaderHeight(e3) {
                const t3 = e3 !== this.autoHeaderHeight;
                return this.autoHeaderHeight = e3, t3;
              }
              createBaseColDefParams(e3) {
                return this.gos.addGridCommonParams({ node: e3, data: e3.data, colDef: this.colDef, column: this });
              }
              getColSpan(e3) {
                if ((0, r._missing)(this.colDef.colSpan))
                  return 1;
                const t3 = this.createBaseColDefParams(e3), a3 = this.colDef.colSpan(t3);
                return Math.max(a3, 1);
              }
              getRowSpan(e3) {
                if ((0, r._missing)(this.colDef.rowSpan))
                  return 1;
                const t3 = this.createBaseColDefParams(e3), a3 = this.colDef.rowSpan(t3);
                return Math.max(a3, 1);
              }
              setActualWidth(e3, t3, a3 = false) {
                e3 = Math.max(e3, this.minWidth), e3 = Math.min(e3, this.maxWidth), this.actualWidth !== e3 && (this.actualWidth = e3, this.flex && "flex" !== t3 && "gridInitializing" !== t3 && (this.flex = null), a3 || this.fireColumnWidthChangedEvent(t3)), this.dispatchStateUpdatedEvent("width");
              }
              fireColumnWidthChangedEvent(e3) {
                this.dispatchColEvent("widthChanged", e3);
              }
              isGreaterThanMax(e3) {
                return e3 > this.maxWidth;
              }
              getMinWidth() {
                return this.minWidth;
              }
              getMaxWidth() {
                return this.maxWidth;
              }
              getFlex() {
                return this.flex;
              }
              isRowGroupActive() {
                return this.rowGroupActive;
              }
              isPivotActive() {
                return this.pivotActive;
              }
              isAnyFunctionActive() {
                return this.isPivotActive() || this.isRowGroupActive() || this.isValueActive();
              }
              isAnyFunctionAllowed() {
                return this.isAllowPivot() || this.isAllowRowGroup() || this.isAllowValue();
              }
              isValueActive() {
                return this.aggregationActive;
              }
              isAllowPivot() {
                return true === this.colDef.enablePivot;
              }
              isAllowValue() {
                return true === this.colDef.enableValue;
              }
              isAllowRowGroup() {
                return true === this.colDef.enableRowGroup;
              }
              dispatchColEvent(e3, t3, a3) {
                const n2 = this.createColumnEvent(e3, t3);
                a3 && (0, i._mergeDeep)(n2, a3), this.colEventSvc.dispatchEvent(n2);
              }
              dispatchStateUpdatedEvent(e3) {
                this.colEventSvc.dispatchEvent({ type: "columnStateUpdated", key: e3 });
              }
            }
            t2.AgColumn = g;
          }, 6908: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.AgColumnGroup = t2.isColumnGroup = t2.createUniqueColumnGroupId = void 0;
            const n = a2(8731), o = a2(1502), r = a2(3355);
            function i(e3, t3) {
              return e3 + "_" + t3;
            }
            function l(e3) {
              return e3 instanceof s;
            }
            t2.createUniqueColumnGroupId = i, t2.isColumnGroup = l;
            class s extends n.BeanStub {
              constructor(e3, t3, a3, n2) {
                super(), this.providedColumnGroup = e3, this.groupId = t3, this.partId = a3, this.pinned = n2, this.isColumn = false, this.displayedChildren = [], this.autoHeaderHeight = null, this.parent = null;
              }
              reset() {
                this.parent = null, this.children = null, this.displayedChildren = null;
              }
              getParent() {
                return this.parent;
              }
              getUniqueId() {
                return i(this.groupId, this.partId);
              }
              isEmptyGroup() {
                return 0 === this.displayedChildren.length;
              }
              isMoving() {
                const e3 = this.getProvidedColumnGroup().getLeafColumns();
                return !(!e3 || 0 === e3.length) && e3.every((e4) => e4.isMoving());
              }
              checkLeft() {
                if (this.displayedChildren.forEach((e3) => {
                  l(e3) && e3.checkLeft();
                }), this.displayedChildren.length > 0)
                  if (this.gos.get("enableRtl")) {
                    const e3 = (0, o._last)(this.displayedChildren).getLeft();
                    this.setLeft(e3);
                  } else {
                    const e3 = this.displayedChildren[0].getLeft();
                    this.setLeft(e3);
                  }
                else
                  this.setLeft(null);
              }
              getLeft() {
                return this.left;
              }
              getOldLeft() {
                return this.oldLeft;
              }
              setLeft(e3) {
                this.oldLeft = this.left, this.left !== e3 && (this.left = e3, this.dispatchLocalEvent({ type: "leftChanged" }));
              }
              getPinned() {
                return this.pinned;
              }
              getGroupId() {
                return this.groupId;
              }
              getPartId() {
                return this.partId;
              }
              getActualWidth() {
                var _a;
                let e3 = 0;
                return (_a = this.displayedChildren) == null ? void 0 : _a.forEach((t3) => {
                  e3 += t3.getActualWidth();
                }), e3;
              }
              isResizable() {
                if (!this.displayedChildren)
                  return false;
                let e3 = false;
                return this.displayedChildren.forEach((t3) => {
                  t3.isResizable() && (e3 = true);
                }), e3;
              }
              getMinWidth() {
                let e3 = 0;
                return this.displayedChildren.forEach((t3) => {
                  e3 += t3.getMinWidth();
                }), e3;
              }
              addChild(e3) {
                this.children || (this.children = []), this.children.push(e3);
              }
              getDisplayedChildren() {
                return this.displayedChildren;
              }
              getLeafColumns() {
                const e3 = [];
                return this.addLeafColumns(e3), e3;
              }
              getDisplayedLeafColumns() {
                const e3 = [];
                return this.addDisplayedLeafColumns(e3), e3;
              }
              getDefinition() {
                return this.providedColumnGroup.getColGroupDef();
              }
              getColGroupDef() {
                return this.providedColumnGroup.getColGroupDef();
              }
              isPadding() {
                return this.providedColumnGroup.isPadding();
              }
              isExpandable() {
                return this.providedColumnGroup.isExpandable();
              }
              isExpanded() {
                return this.providedColumnGroup.isExpanded();
              }
              setExpanded(e3) {
                this.providedColumnGroup.setExpanded(e3);
              }
              isAutoHeaderHeight() {
                var _a;
                return !!((_a = this.getColGroupDef()) == null ? void 0 : _a.autoHeaderHeight);
              }
              getAutoHeaderHeight() {
                return this.autoHeaderHeight;
              }
              setAutoHeaderHeight(e3) {
                const t3 = e3 !== this.autoHeaderHeight;
                return this.autoHeaderHeight = e3, t3;
              }
              addDisplayedLeafColumns(e3) {
                this.displayedChildren.forEach((t3) => {
                  (0, r.isColumn)(t3) ? e3.push(t3) : l(t3) && t3.addDisplayedLeafColumns(e3);
                });
              }
              addLeafColumns(e3) {
                this.children.forEach((t3) => {
                  (0, r.isColumn)(t3) ? e3.push(t3) : l(t3) && t3.addLeafColumns(e3);
                });
              }
              getChildren() {
                return this.children;
              }
              getColumnGroupShow() {
                return this.providedColumnGroup.getColumnGroupShow();
              }
              getProvidedColumnGroup() {
                return this.providedColumnGroup;
              }
              getPaddingLevel() {
                const e3 = this.getParent();
                return this.isPadding() && e3 && e3.isPadding() ? 1 + e3.getPaddingLevel() : 0;
              }
              calculateDisplayedColumns() {
                this.displayedChildren = [];
                let e3 = this;
                for (; null != e3 && e3.isPadding(); )
                  e3 = e3.getParent();
                if (!(!!e3 && e3.getProvidedColumnGroup().isExpandable()))
                  return this.displayedChildren = this.children, void this.dispatchLocalEvent({ type: "displayedChildrenChanged" });
                this.children.forEach((t3) => {
                  if (l(t3) && (!t3.displayedChildren || !t3.displayedChildren.length))
                    return;
                  switch (t3.getColumnGroupShow()) {
                    case "open":
                      e3.getProvidedColumnGroup().isExpanded() && this.displayedChildren.push(t3);
                      break;
                    case "closed":
                      e3.getProvidedColumnGroup().isExpanded() || this.displayedChildren.push(t3);
                      break;
                    default:
                      this.displayedChildren.push(t3);
                  }
                }), this.dispatchLocalEvent({ type: "displayedChildrenChanged" });
              }
            }
            t2.AgColumnGroup = s;
          }, 9409: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.AgProvidedColumnGroup = t2.isProvidedColumnGroup = void 0;
            const n = a2(8731), o = a2(3355);
            function r(e3) {
              return e3 instanceof i;
            }
            t2.isProvidedColumnGroup = r;
            class i extends n.BeanStub {
              constructor(e3, t3, a3, n2) {
                super(), this.colGroupDef = e3, this.groupId = t3, this.padding = a3, this.level = n2, this.isColumn = false, this.expandable = false, this.instanceId = (0, o.getNextColInstanceId)(), this.expandableListenerRemoveCallback = null, this.expanded = !!(e3 == null ? void 0 : e3.openByDefault);
              }
              destroy() {
                this.expandableListenerRemoveCallback && this.reset(null, void 0), super.destroy();
              }
              reset(e3, t3) {
                this.colGroupDef = e3, this.level = t3, this.originalParent = null, this.expandableListenerRemoveCallback && this.expandableListenerRemoveCallback(), this.children = void 0, this.expandable = void 0;
              }
              getInstanceId() {
                return this.instanceId;
              }
              getOriginalParent() {
                return this.originalParent;
              }
              getLevel() {
                return this.level;
              }
              isVisible() {
                return !!this.children && this.children.some((e3) => e3.isVisible());
              }
              isPadding() {
                return this.padding;
              }
              setExpanded(e3) {
                this.expanded = void 0 !== e3 && e3, this.dispatchLocalEvent({ type: "expandedChanged" });
              }
              isExpandable() {
                return this.expandable;
              }
              isExpanded() {
                return this.expanded;
              }
              getGroupId() {
                return this.groupId;
              }
              getId() {
                return this.getGroupId();
              }
              setChildren(e3) {
                this.children = e3;
              }
              getChildren() {
                return this.children;
              }
              getColGroupDef() {
                return this.colGroupDef;
              }
              getLeafColumns() {
                const e3 = [];
                return this.addLeafColumns(e3), e3;
              }
              addLeafColumns(e3) {
                this.children && this.children.forEach((t3) => {
                  (0, o.isColumn)(t3) ? e3.push(t3) : r(t3) && t3.addLeafColumns(e3);
                });
              }
              getColumnGroupShow() {
                const e3 = this.colGroupDef;
                if (e3)
                  return e3.columnGroupShow;
              }
              setupExpandable() {
                this.setExpandable(), this.expandableListenerRemoveCallback && this.expandableListenerRemoveCallback();
                const e3 = this.onColumnVisibilityChanged.bind(this);
                this.getLeafColumns().forEach((t3) => t3.addEventListener("visibleChanged", e3)), this.expandableListenerRemoveCallback = () => {
                  this.getLeafColumns().forEach((t3) => t3.removeEventListener("visibleChanged", e3)), this.expandableListenerRemoveCallback = null;
                };
              }
              setExpandable() {
                if (this.isPadding())
                  return;
                let e3 = false, t3 = false, a3 = false;
                const n2 = this.findChildrenRemovingPadding();
                for (let o3 = 0, r2 = n2.length; o3 < r2; o3++) {
                  const r3 = n2[o3];
                  if (!r3.isVisible())
                    continue;
                  const i2 = r3.getColumnGroupShow();
                  "open" === i2 ? (e3 = true, a3 = true) : "closed" === i2 ? (t3 = true, a3 = true) : (e3 = true, t3 = true);
                }
                const o2 = e3 && t3 && a3;
                this.expandable !== o2 && (this.expandable = o2, this.dispatchLocalEvent({ type: "expandableChanged" }));
              }
              findChildrenRemovingPadding() {
                const e3 = [], t3 = (a3) => {
                  a3.forEach((a4) => {
                    r(a4) && a4.isPadding() ? t3(a4.children) : e3.push(a4);
                  });
                };
                return t3(this.children), e3;
              }
              onColumnVisibilityChanged() {
                this.setExpandable();
              }
            }
            t2.AgProvidedColumnGroup = i;
          }, 5449: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.DefaultColumnTypes = void 0, t2.DefaultColumnTypes = { numericColumn: { headerClass: "ag-right-aligned-header", cellClass: "ag-right-aligned-cell" }, rightAligned: { headerClass: "ag-right-aligned-header", cellClass: "ag-right-aligned-cell" } };
          }, 6257: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2._getCellByPosition = t2._getRowNode = t2._getLastRow = t2._getFirstRow = t2._isSameRow = t2._isRowBefore = t2._areCellsEqual = t2._createCellId = void 0;
            const n = a2(4422);
            t2._createCellId = function(e3) {
              const { rowIndex: t3, rowPinned: a3, column: n2 } = e3;
              return `${t3}.${null == a3 ? "null" : a3}.${n2.getId()}`;
            }, t2._areCellsEqual = function(e3, t3) {
              const a3 = e3.column === t3.column, n2 = e3.rowPinned === t3.rowPinned, o = e3.rowIndex === t3.rowIndex;
              return a3 && n2 && o;
            }, t2._isRowBefore = function(e3, t3) {
              switch (e3.rowPinned) {
                case "top":
                  if ("top" !== t3.rowPinned)
                    return true;
                  break;
                case "bottom":
                  if ("bottom" !== t3.rowPinned)
                    return false;
                  break;
                default:
                  if ((0, n._exists)(t3.rowPinned))
                    return "top" !== t3.rowPinned;
              }
              return e3.rowIndex < t3.rowIndex;
            }, t2._isSameRow = function(e3, t3) {
              return !e3 && !t3 || !(e3 && !t3 || !e3 && t3) && (e3.rowIndex === t3.rowIndex && e3.rowPinned == t3.rowPinned);
            }, t2._getFirstRow = function(e3) {
              let t3, a3 = 0;
              const { pinnedRowModel: n2, rowModel: o, pageBounds: r } = e3;
              return (n2 == null ? void 0 : n2.getPinnedTopRowCount()) ? t3 = "top" : o.getRowCount() ? (t3 = null, a3 = r.getFirstRow()) : (n2 == null ? void 0 : n2.getPinnedBottomRowCount()) && (t3 = "bottom"), void 0 === t3 ? null : { rowIndex: a3, rowPinned: t3 };
            }, t2._getLastRow = function(e3) {
              let t3, a3 = null;
              const { pinnedRowModel: n2, pageBounds: o } = e3, r = n2 == null ? void 0 : n2.getPinnedBottomRowCount(), i = n2 == null ? void 0 : n2.getPinnedTopRowCount();
              return r ? (a3 = "bottom", t3 = r - 1) : e3.rowModel.getRowCount() ? (a3 = null, t3 = o.getLastRow()) : i && (a3 = "top", t3 = i - 1), void 0 === t3 ? null : { rowIndex: t3, rowPinned: a3 };
            }, t2._getRowNode = function(e3, t3) {
              var _a, _b;
              switch (t3.rowPinned) {
                case "top":
                  return (_a = e3.pinnedRowModel) == null ? void 0 : _a.getPinnedTopRow(t3.rowIndex);
                case "bottom":
                  return (_b = e3.pinnedRowModel) == null ? void 0 : _b.getPinnedBottomRow(t3.rowIndex);
                default:
                  return e3.rowModel.getRow(t3.rowIndex);
              }
            }, t2._getCellByPosition = function(e3, t3) {
              const a3 = e3.rowRenderer.getRowByPosition(t3);
              return a3 ? a3.getCellCtrl(t3.column) : null;
            };
          }, 3373: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.RowNode = t2.ROW_ID_PREFIX_BOTTOM_PINNED = t2.ROW_ID_PREFIX_TOP_PINNED = t2.ROW_ID_PREFIX_ROW_GROUP = void 0;
            const n = a2(7274), o = a2(5889), r = a2(7764);
            t2.ROW_ID_PREFIX_ROW_GROUP = "row-group-", t2.ROW_ID_PREFIX_TOP_PINNED = "t-", t2.ROW_ID_PREFIX_BOTTOM_PINNED = "b-";
            let i = 0;
            t2.RowNode = class {
              constructor(e3) {
                this.master = false, this.detail = void 0, this.rowIndex = null, this.key = null, this.sourceRowIndex = -1, this.childrenMapped = {}, this.treeNode = null, this.treeNodeFlags = 0, this.displayed = false, this.rowTop = null, this.oldRowTop = null, this.selectable = true, this.__objectId = i++, this.alreadyRendered = false, this.highlighted = null, this.hovered = false, this.__selected = false, this.beans = e3;
              }
              setData(e3) {
                this.setDataCommon(e3, false);
              }
              updateData(e3) {
                this.setDataCommon(e3, true);
              }
              setDataCommon(e3, t3) {
                var _a, _b, _c;
                const a3 = this.data;
                this.data = e3, (_a = this.beans.valueCache) == null ? void 0 : _a.onDataChanged(), this.updateDataOnDetailNode(), (_b = this.beans.selectionSvc) == null ? void 0 : _b.updateRowSelectable(this), this.resetQuickFilterAggregateText();
                const n2 = this.createDataChangedEvent(e3, a3, t3);
                (_c = this.__localEventService) == null ? void 0 : _c.dispatchEvent(n2);
              }
              updateDataOnDetailNode() {
                this.detailNode && (this.detailNode.data = this.data);
              }
              createDataChangedEvent(e3, t3, a3) {
                return { type: "dataChanged", node: this, oldData: t3, newData: e3, update: a3 };
              }
              getRowIndexString() {
                return null == this.rowIndex ? ((0, r._error)(13), null) : "top" === this.rowPinned ? t2.ROW_ID_PREFIX_TOP_PINNED + this.rowIndex : "bottom" === this.rowPinned ? t2.ROW_ID_PREFIX_BOTTOM_PINNED + this.rowIndex : this.rowIndex.toString();
              }
              setDataAndId(e3, t3) {
                var _a, _b;
                const { selectionSvc: a3 } = this.beans, n2 = (_a = a3 == null ? void 0 : a3.createDaemonNode) == null ? void 0 : _a.call(a3, this), o2 = this.data;
                this.data = e3, this.updateDataOnDetailNode(), this.setId(t3), a3 && (a3.updateRowSelectable(this), a3.syncInRowNode(this, n2));
                const r2 = this.createDataChangedEvent(e3, o2, false);
                (_b = this.__localEventService) == null ? void 0 : _b.dispatchEvent(r2);
              }
              setId(e3) {
                var _a, _b;
                const a3 = (0, n._getRowIdCallback)(this.beans.gos);
                if (a3)
                  if (this.data) {
                    const e4 = (_b = (_a = this.parent) == null ? void 0 : _a.getRoute()) != null ? _b : [];
                    this.id = a3({ data: this.data, parentKeys: e4.length > 0 ? e4 : void 0, level: this.level, rowPinned: this.rowPinned }), this.id.startsWith(t2.ROW_ID_PREFIX_ROW_GROUP) && (0, r._error)(14, { groupPrefix: t2.ROW_ID_PREFIX_ROW_GROUP });
                  } else
                    this.id = void 0;
                else
                  this.id = e3;
              }
              setRowTop(e3) {
                this.oldRowTop = this.rowTop, this.rowTop !== e3 && (this.rowTop = e3, this.dispatchRowEvent("topChanged"), this.setDisplayed(null !== e3));
              }
              clearRowTopAndRowIndex() {
                this.oldRowTop = null, this.setRowTop(null), this.setRowIndex(null);
              }
              setHovered(e3) {
                this.hovered = e3;
              }
              isHovered() {
                return this.hovered;
              }
              setRowHeight(e3, t3 = false) {
                this.rowHeight = e3, this.rowHeightEstimated = t3, this.dispatchRowEvent("heightChanged");
              }
              setExpanded(e3, t3, a3) {
                var _a;
                (_a = this.beans.expansionSvc) == null ? void 0 : _a.setExpanded(this, e3, t3, a3);
              }
              setDataValue(e3, t3, a3) {
                var _a;
                const { colModel: n2, valueSvc: o2, gos: r2, selectionSvc: i2 } = this.beans, l = "string" != typeof e3 ? e3 : (_a = n2.getCol(e3)) != null ? _a : n2.getColDefCol(e3);
                if (!l)
                  return false;
                const s = o2.getValueForDisplay(l, this);
                if (r2.get("readOnlyEdit")) {
                  const { beans: { eventSvc: e4 }, data: n3, rowIndex: o3, rowPinned: r3 } = this;
                  return e4.dispatchEvent({ type: "cellEditRequest", event: null, rowIndex: o3, rowPinned: r3, column: l, colDef: l.colDef, data: n3, node: this, oldValue: s, newValue: t3, value: t3, source: a3 }), false;
                }
                const d = o2.setValue(this, l, t3, a3);
                return this.dispatchCellChangedEvent(l, t3, s), i2 == null ? void 0 : i2.updateRowSelectable(this), d;
              }
              updateHasChildren() {
                let e3 = this.group && !this.footer || this.childrenAfterGroup && this.childrenAfterGroup.length > 0;
                const { rowChildrenSvc: t3 } = this.beans;
                t3 && (e3 = t3.getHasChildrenValue(this)), e3 !== this.__hasChildren && (this.__hasChildren = !!e3, this.dispatchRowEvent("hasChildrenChanged"));
              }
              hasChildren() {
                return null == this.__hasChildren && this.updateHasChildren(), this.__hasChildren;
              }
              dispatchCellChangedEvent(e3, t3, a3) {
                var _a;
                const n2 = { type: "cellChanged", node: this, column: e3, newValue: t3, oldValue: a3 };
                (_a = this.__localEventService) == null ? void 0 : _a.dispatchEvent(n2);
              }
              resetQuickFilterAggregateText() {
                this.quickFilterAggregateText = null;
              }
              isExpandable() {
                var _a, _b;
                return (_b = (_a = this.beans.expansionSvc) == null ? void 0 : _a.isExpandable(this)) != null ? _b : false;
              }
              isSelected() {
                return this.footer ? this.sibling.isSelected() : this.__selected;
              }
              depthFirstSearch(e3) {
                var _a;
                (_a = this.childrenAfterGroup) == null ? void 0 : _a.forEach((t3) => t3.depthFirstSearch(e3)), e3(this);
              }
              dispatchRowEvent(e3) {
                var _a;
                (_a = this.__localEventService) == null ? void 0 : _a.dispatchEvent({ type: e3, node: this });
              }
              setSelected(e3, t3 = false, a3 = "api") {
                var _a;
                (_a = this.beans.selectionSvc) == null ? void 0 : _a.setNodesSelected({ nodes: [this], newValue: e3, clearSelection: t3, source: a3 });
              }
              isRowPinned() {
                return !!this.rowPinned;
              }
              addEventListener(e3, t3) {
                var _a, _b, _c, _d, _e;
                (_a = this.beans.validation) == null ? void 0 : _a.checkRowEvents(e3), this.__localEventService || (this.__localEventService = new o.LocalEventService()), this.frameworkEventListenerService = (_c = (_b = this.beans.frameworkOverrides).createLocalEventListenerWrapper) == null ? void 0 : _c.call(_b, this.frameworkEventListenerService, this.__localEventService);
                const a3 = (_e = (_d = this.frameworkEventListenerService) == null ? void 0 : _d.wrap(t3)) != null ? _e : t3;
                this.__localEventService.addEventListener(e3, a3);
              }
              removeEventListener(e3, t3) {
                var _a, _b;
                if (!this.__localEventService)
                  return;
                const a3 = (_b = (_a = this.frameworkEventListenerService) == null ? void 0 : _a.unwrap(t3)) != null ? _b : t3;
                this.__localEventService.removeEventListener(e3, a3), this.__localEventService.noRegisteredListenersExist() && (this.__localEventService = null);
              }
              isFullWidthCell() {
                if ((0, r._warn)(61), this.detail)
                  return true;
                const e3 = this.beans.gos.getCallback("isFullWidthRow");
                return !!e3 && e3({ rowNode: this });
              }
              getRoute() {
                if (-1 === this.level)
                  return [];
                if (null == this.key)
                  return;
                const e3 = [];
                let t3 = this;
                for (; t3 && null != t3.key; )
                  e3.push(t3.key), t3 = t3.parent;
                return e3.reverse();
              }
              setFirstChild(e3) {
                this.firstChild !== e3 && (this.firstChild = e3, this.dispatchRowEvent("firstChildChanged"));
              }
              setDisplayed(e3) {
                this.displayed !== e3 && (this.displayed = e3, this.dispatchRowEvent("displayedChanged"));
              }
              setRowIndex(e3) {
                this.rowIndex !== e3 && (this.rowIndex = e3, this.dispatchRowEvent("rowIndexChanged"));
              }
              setAllChildrenCount(e3) {
                this.allChildrenCount !== e3 && (this.allChildrenCount = e3, this.dispatchRowEvent("allChildrenCountChanged"));
              }
              setUiLevel(e3) {
                this.uiLevel !== e3 && (this.uiLevel = e3, this.dispatchRowEvent("uiLevelChanged"));
              }
            };
          }, 9888: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2._createGlobalRowEvent = void 0, t2._createGlobalRowEvent = function(e3, t3, a2) {
              return t3.addGridCommonParams({ type: a2, node: e3, data: e3.data, rowIndex: e3.rowIndex, rowPinned: e3.rowPinned });
            };
          }, 9024: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.Environment = void 0;
            const n = a2(8731), o = a2(9621), r = a2(8951), i = a2(2525), l = a2(3507), s = a2(7764), d = { cssName: "--ag-row-height", changeKey: "rowHeightChanged", defaultValue: 42 }, c = { cssName: "--ag-header-height", changeKey: "headerHeightChanged", defaultValue: 48 }, g = { cssName: "--ag-list-item-height", changeKey: "listItemHeightChanged", defaultValue: 24 }, u = { cssName: "--ag-row-border", changeKey: "rowBorderWidthChanged", defaultValue: 1, border: true };
            let h = 0;
            class p extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "environment", this.sizeEls = /* @__PURE__ */ new Map(), this.lastKnownValues = /* @__PURE__ */ new Map(), this.sizesMeasured = false, this.paramsClass = "ag-theme-params-" + ++h, this.globalCSS = [];
              }
              wireBeans(e3) {
                this.eGridDiv = e3.eGridDiv;
              }
              postConstruct() {
                this.addManagedPropertyListener("theme", () => this.handleThemeGridOptionChange()), this.handleThemeGridOptionChange(), this.addManagedPropertyListener("rowHeight", () => this.refreshRowHeightVariable()), this.getSizeEl(d), this.getSizeEl(c), this.getSizeEl(g), this.getSizeEl(u), this.refreshRowBorderWidthVariable(), this.addDestroyFunc(() => (0, r._unregisterGridUsingThemingAPI)(this));
              }
              getDefaultRowHeight() {
                return this.getCSSVariablePixelValue(d);
              }
              getDefaultHeaderHeight() {
                return this.getCSSVariablePixelValue(c);
              }
              getDefaultColumnMinWidth() {
                return Math.min(36, this.getDefaultRowHeight());
              }
              getDefaultListItemHeight() {
                return this.getCSSVariablePixelValue(g);
              }
              getRowBorderWidth() {
                return this.getCSSVariablePixelValue(u);
              }
              applyThemeClasses(e3) {
                const { gridTheme: t3 } = this;
                let a3 = "";
                if (t3)
                  a3 = `${this.paramsClass} ${t3._getCssClass()}`;
                else {
                  let e4 = this.eGridDiv;
                  for (; e4; ) {
                    for (const t4 of Array.from(e4.classList))
                      t4.startsWith("ag-theme-") && (a3 = a3 ? `${a3} ${t4}` : t4);
                    e4 = e4.parentElement;
                  }
                }
                for (const t4 of Array.from(e3.classList))
                  t4.startsWith("ag-theme-") && e3.classList.remove(t4);
                if (a3) {
                  const t4 = e3.className;
                  e3.className = t4 + (t4 ? " " : "") + a3;
                }
              }
              refreshRowHeightVariable() {
                const { eGridDiv: e3 } = this, t3 = e3.style.getPropertyValue("--ag-line-height").trim(), a3 = this.gos.get("rowHeight");
                if (null == a3 || isNaN(a3) || !isFinite(a3))
                  return null !== t3 && e3.style.setProperty("--ag-line-height", null), -1;
                const n2 = `${a3}px`;
                return t3 != n2 ? (e3.style.setProperty("--ag-line-height", n2), a3) : "" != t3 ? parseFloat(t3) : -1;
              }
              addGlobalCSS(e3, t3) {
                this.gridTheme ? (0, r._injectGlobalCSS)(e3, this.eGridDiv, t3) : this.globalCSS.push([e3, t3]);
              }
              getCSSVariablePixelValue(e3) {
                const t3 = this.lastKnownValues.get(e3);
                if (null != t3)
                  return t3;
                const a3 = this.measureSizeEl(e3);
                return "detached" === a3 || "no-styles" === a3 ? e3.defaultValue : (this.lastKnownValues.set(e3, a3), a3);
              }
              measureSizeEl(e3) {
                const t3 = this.getSizeEl(e3);
                if (null == t3.offsetParent)
                  return "detached";
                const a3 = t3.offsetWidth;
                return a3 === m ? "no-styles" : (this.sizesMeasured = true, a3);
              }
              getMeasurementContainer() {
                let e3 = this.eMeasurementContainer;
                return e3 || (e3 = this.eMeasurementContainer = document.createElement("div"), e3.className = "ag-measurement-container", this.eGridDiv.appendChild(e3)), e3;
              }
              getSizeEl(e3) {
                let t3 = this.sizeEls.get(e3);
                if (t3)
                  return t3;
                const a3 = this.getMeasurementContainer();
                t3 = document.createElement("div");
                const { border: n2 } = e3;
                n2 ? (t3.className = "ag-measurement-element-border", t3.style.setProperty("--ag-internal-measurement-border", `var(${e3.cssName}, solid ${m}px`)) : t3.style.width = `var(${e3.cssName}, ${m}px)`, a3.appendChild(t3), this.sizeEls.set(e3, t3);
                let o2 = this.measureSizeEl(e3);
                "no-styles" === o2 && (0, s._warn)(9, { variable: e3 });
                const r2 = (0, l._observeResize)(this.beans, t3, () => {
                  const t4 = this.measureSizeEl(e3);
                  "detached" !== t4 && "no-styles" !== t4 && (this.lastKnownValues.set(e3, t4), t4 !== o2 && (o2 = t4, this.fireGridStylesChangedEvent(e3.changeKey)));
                });
                return this.addDestroyFunc(() => r2()), t3;
              }
              fireGridStylesChangedEvent(e3) {
                "rowBorderWidthChanged" === e3 && this.refreshRowBorderWidthVariable(), this.eventSvc.dispatchEvent({ type: "gridStylesChanged", [e3]: true });
              }
              refreshRowBorderWidthVariable() {
                const e3 = this.getCSSVariablePixelValue(u);
                this.eGridDiv.style.setProperty("--ag-internal-row-border-width", `${e3}px`);
              }
              handleThemeGridOptionChange() {
                const { gos: e3, eGridDiv: t3, globalCSS: a3, gridTheme: n2 } = this, l2 = e3.get("theme");
                let d2;
                if ("legacy" === l2)
                  d2 = void 0;
                else {
                  const e4 = l2 != null ? l2 : i.themeQuartz;
                  e4 instanceof o.ThemeImpl ? d2 = e4 : (0, s._error)(240, { theme: e4 });
                }
                if (d2 !== n2) {
                  if (d2) {
                    (0, r._registerGridUsingThemingAPI)(this), (0, r._injectCoreAndModuleCSS)(t3);
                    for (const [e4, n4] of a3)
                      (0, r._injectGlobalCSS)(e4, t3, n4);
                    a3.length = 0;
                  }
                  this.gridTheme = d2, d2 == null ? void 0 : d2._startUse({ loadThemeGoogleFonts: e3.get("loadThemeGoogleFonts"), container: t3 });
                  let n3 = this.eParamsStyle;
                  n3 || (n3 = this.eParamsStyle = document.createElement("style"), t3.appendChild(n3)), r.IS_SSR || (n3.textContent = (d2 == null ? void 0 : d2._getPerGridCss(this.paramsClass)) || ""), this.applyThemeClasses(t3), this.fireGridStylesChangedEvent("themeChanged");
                }
                d2 && getComputedStyle(this.getMeasurementContainer()).getPropertyValue("--ag-legacy-styles-loaded") && (l2 ? (0, s._error)(106) : (0, s._error)(239));
              }
            }
            t2.Environment = p;
            const m = 15538;
          }, 8778: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.EventService = void 0;
            const n = a2(8731), o = a2(5889);
            class r extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "eventSvc", this.globalEventService = new o.LocalEventService();
              }
              postConstruct() {
                const { globalListener: e3, globalSyncListener: t3 } = this.beans;
                e3 && this.addGlobalListener(e3, true), t3 && this.addGlobalListener(t3, false);
              }
              addEventListener(e3, t3, a3) {
                this.globalEventService.addEventListener(e3, t3, a3);
              }
              removeEventListener(e3, t3, a3) {
                this.globalEventService.removeEventListener(e3, t3, a3);
              }
              addGlobalListener(e3, t3 = false) {
                this.globalEventService.addGlobalListener(e3, t3);
              }
              removeGlobalListener(e3, t3 = false) {
                this.globalEventService.removeGlobalListener(e3, t3);
              }
              dispatchLocalEvent() {
              }
              dispatchEvent(e3) {
                this.globalEventService.dispatchEvent(this.gos.addGridCommonParams(e3));
              }
              dispatchEventOnce(e3) {
                this.globalEventService.dispatchEventOnce(this.gos.addGridCommonParams(e3));
              }
            }
            t2.EventService = r;
          }, 3080: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2._ALL_EVENTS = t2._INTERNAL_EVENTS = t2._PUBLIC_EVENTS = void 0, t2._PUBLIC_EVENTS = ["columnEverythingChanged", "newColumnsLoaded", "columnPivotModeChanged", "pivotMaxColumnsExceeded", "columnRowGroupChanged", "expandOrCollapseAll", "columnPivotChanged", "gridColumnsChanged", "columnValueChanged", "columnMoved", "columnVisible", "columnPinned", "columnGroupOpened", "columnResized", "displayedColumnsChanged", "virtualColumnsChanged", "columnHeaderMouseOver", "columnHeaderMouseLeave", "columnHeaderClicked", "columnHeaderContextMenu", "asyncTransactionsFlushed", "rowGroupOpened", "rowDataUpdated", "pinnedRowDataChanged", "rangeSelectionChanged", "cellSelectionChanged", "chartCreated", "chartRangeSelectionChanged", "chartOptionsChanged", "chartDestroyed", "toolPanelVisibleChanged", "toolPanelSizeChanged", "modelUpdated", "cutStart", "cutEnd", "pasteStart", "pasteEnd", "fillStart", "fillEnd", "cellSelectionDeleteStart", "cellSelectionDeleteEnd", "rangeDeleteStart", "rangeDeleteEnd", "undoStarted", "undoEnded", "redoStarted", "redoEnded", "cellClicked", "cellDoubleClicked", "cellMouseDown", "cellContextMenu", "cellValueChanged", "cellEditRequest", "rowValueChanged", "headerFocused", "cellFocused", "rowSelected", "selectionChanged", "tooltipShow", "tooltipHide", "cellKeyDown", "cellMouseOver", "cellMouseOut", "filterChanged", "filterModified", "filterOpened", "advancedFilterBuilderVisibleChanged", "sortChanged", "virtualRowRemoved", "rowClicked", "rowDoubleClicked", "gridReady", "gridPreDestroyed", "gridSizeChanged", "viewportChanged", "firstDataRendered", "dragStarted", "dragStopped", "dragCancelled", "rowEditingStarted", "rowEditingStopped", "cellEditingStarted", "cellEditingStopped", "bodyScroll", "bodyScrollEnd", "paginationChanged", "componentStateChanged", "storeRefreshed", "stateUpdated", "columnMenuVisibleChanged", "contextMenuVisibleChanged", "rowDragEnter", "rowDragMove", "rowDragLeave", "rowDragEnd", "rowDragCancel"], t2._INTERNAL_EVENTS = ["scrollbarWidthChanged", "keyShortcutChangedCellStart", "keyShortcutChangedCellEnd", "pinnedHeightChanged", "cellFocusCleared", "fullWidthRowFocused", "checkboxChanged", "heightScaleChanged", "suppressMovableColumns", "suppressMenuHide", "suppressFieldDotNotation", "columnPanelItemDragStart", "columnPanelItemDragEnd", "bodyHeightChanged", "columnContainerWidthChanged", "displayedColumnsWidthChanged", "scrollVisibilityChanged", "scrollGapChanged", "columnHoverChanged", "flashCells", "paginationPixelOffsetChanged", "displayedRowsChanged", "leftPinnedWidthChanged", "rightPinnedWidthChanged", "rowContainerHeightChanged", "headerHeightChanged", "columnGroupHeaderHeightChanged", "columnHeaderHeightChanged", "gridStylesChanged", "storeUpdated", "filterDestroyed", "rowDataUpdateStarted", "rowCountReady", "advancedFilterEnabledChanged", "dataTypesInferred", "fieldValueChanged", "fieldPickerValueSelected", "richSelectListRowSelected", "sideBarUpdated", "alignedGridScroll", "alignedGridColumn", "gridOptionsChanged", "chartTitleEdit", "recalculateRowBounds", "stickyTopOffsetChanged", "overlayExclusiveChanged", "beforeRefreshModel"], t2._ALL_EVENTS = [...t2._PUBLIC_EVENTS, ...t2._INTERNAL_EVENTS];
          }, 7968: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ALWAYS_SYNC_GLOBAL_EVENTS = void 0, t2.ALWAYS_SYNC_GLOBAL_EVENTS = /* @__PURE__ */ new Set(["gridPreDestroyed", "fillStart", "pasteStart"]);
          }, 7331: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.BaseCreator = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
              getFileName(e3) {
                const t3 = this.getDefaultFileExtension();
                return null != e3 && e3.length || (e3 = this.getDefaultFileName()), -1 === e3.indexOf(".") ? `${e3}.${t3}` : e3;
              }
              getData(e3) {
                const t3 = this.createSerializingSession(e3);
                return this.beans.gridSerializer.serialize(t3, e3);
              }
              getDefaultFileName() {
                return `export.${this.getDefaultFileExtension()}`;
              }
            }
            t2.BaseCreator = o;
          }, 8376: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.BaseGridSerializingSession = void 0;
            const n = a2(7274);
            t2.BaseGridSerializingSession = class {
              constructor(e3) {
                this.groupColumns = [];
                const { colModel: t3, rowGroupColsSvc: a3, colNames: n2, valueSvc: o, gos: r, processCellCallback: i, processHeaderCallback: l, processGroupHeaderCallback: s, processRowGroupCallback: d } = e3;
                this.colModel = t3, this.rowGroupColsSvc = a3, this.colNames = n2, this.valueSvc = o, this.gos = r, this.processCellCallback = i, this.processHeaderCallback = l, this.processGroupHeaderCallback = s, this.processRowGroupCallback = d;
              }
              prepare(e3) {
                this.groupColumns = e3.filter((e4) => !!e4.getColDef().showRowGroup);
              }
              extractHeaderValue(e3) {
                var _a;
                return (_a = this.getHeaderName(this.processHeaderCallback, e3)) != null ? _a : "";
              }
              extractRowCellValue(e3, t3, a3, n2, o) {
                const r = this.gos.get("groupHideOpenParents") && !o.footer || !this.shouldRenderGroupSummaryCell(o, e3, t3) ? this.valueSvc.getValue(e3, o) : this.createValueForGroupNode(e3, o);
                return this.processCell({ accumulatedRowIndex: a3, rowNode: o, column: e3, value: r, processCellCallback: this.processCellCallback, type: n2 });
              }
              shouldRenderGroupSummaryCell(e3, t3, a3) {
                var _a, _b;
                if (!(e3 && e3.group))
                  return false;
                if (-1 !== this.groupColumns.indexOf(t3)) {
                  if (void 0 !== ((_a = e3.groupData) == null ? void 0 : _a[t3.getId()]))
                    return true;
                  if ((0, n._isServerSideRowModel)(this.gos) && e3.group)
                    return true;
                  if (e3.footer && -1 === e3.level) {
                    const e4 = t3.getColDef();
                    return null == e4 || true === e4.showRowGroup || e4.showRowGroup === ((_b = this.rowGroupColsSvc) == null ? void 0 : _b.columns[0].getId());
                  }
                }
                const o = (0, n._isGroupUseEntireRow)(this.gos, this.colModel.isPivotMode());
                return 0 === a3 && o;
              }
              getHeaderName(e3, t3) {
                return e3 ? e3(this.gos.addGridCommonParams({ column: t3 })) : this.colNames.getDisplayNameForColumn(t3, "csv", true);
              }
              createValueForGroupNode(e3, t3) {
                if (this.processRowGroupCallback)
                  return this.processRowGroupCallback(this.gos.addGridCommonParams({ column: e3, node: t3 }));
                const a3 = this.gos.get("treeData"), o = (t4) => {
                  var _a, _b;
                  if (a3)
                    return t4.key;
                  const n2 = (_a = t4.groupData) == null ? void 0 : _a[e3.getId()];
                  return n2 && t4.rowGroupColumn && false !== t4.rowGroupColumn.getColDef().useValueFormatterForExport ? (_b = this.valueSvc.formatValue(t4.rowGroupColumn, t4, n2)) != null ? _b : n2 : n2;
                }, r = t3.footer, i = [o(t3)];
                if (!(0, n._isGroupMultiAutoColumn)(this.gos))
                  for (; t3.parent; )
                    t3 = t3.parent, i.push(o(t3));
                const l = i.reverse().join(" -> ");
                return r ? `Total ${l}` : l;
              }
              processCell(e3) {
                var _a;
                const { accumulatedRowIndex: t3, rowNode: a3, column: n2, value: o, processCellCallback: r, type: i } = e3;
                return r ? { value: (_a = r(this.gos.addGridCommonParams({ accumulatedRowIndex: t3, column: n2, node: a3, value: o, type: i, parseValue: (e4) => this.valueSvc.parseValue(n2, a3, e4, this.valueSvc.getValue(n2, a3)), formatValue: (e4) => {
                  var _a2;
                  return (_a2 = this.valueSvc.formatValue(n2, a3, e4)) != null ? _a2 : e4;
                } }))) != null ? _a : "" } : false !== n2.getColDef().useValueFormatterForExport ? { value: o != null ? o : "", valueFormatted: this.valueSvc.formatValue(n2, a3, o) } : { value: o != null ? o : "" };
              }
            };
          }, 3885: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2._downloadFile = void 0;
            const n = a2(7764);
            t2._downloadFile = function(e3, t3) {
              const a3 = document.defaultView || window;
              if (!a3)
                return void (0, n._warn)(52);
              const o = document.createElement("a"), r = a3.URL.createObjectURL(t3);
              o.setAttribute("href", r), o.setAttribute("download", e3), o.style.display = "none", document.body.appendChild(o), o.dispatchEvent(new MouseEvent("click", { bubbles: false, cancelable: true, view: a3 })), document.body.removeChild(o), a3.setTimeout(() => {
                a3.URL.revokeObjectURL(r);
              }, 0);
            };
          }, 2728: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.SharedExportModule = void 0;
            const n = a2(7205), o = a2(826);
            t2.SharedExportModule = { moduleName: "SharedExport", version: n.VERSION, beans: [o.GridSerializer] };
          }, 826: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.GridSerializer = void 0;
            const n = a2(3146), o = a2(6034), r = a2(8731), i = a2(6908), l = a2(7274), s = a2(1502);
            class d extends r.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "gridSerializer";
              }
              wireBeans(e3) {
                this.visibleCols = e3.visibleCols, this.colModel = e3.colModel, this.rowModel = e3.rowModel, this.pinnedRowModel = e3.pinnedRowModel;
              }
              serialize(e3, t3 = {}) {
                const { allColumns: a3, columnKeys: n2, skipRowGroups: o2 } = t3, r2 = this.getColumnsToExport(a3, o2, n2);
                return [this.prepareSession(r2), this.prependContent(t3), this.exportColumnGroups(t3, r2), this.exportHeaders(t3, r2), this.processPinnedTopRows(t3, r2), this.processRows(t3, r2), this.processPinnedBottomRows(t3, r2), this.appendContent(t3)].reduce((e4, t4) => t4(e4), e3).parse();
              }
              processRow(e3, t3, a3, n2) {
                var _a;
                const o2 = t3.shouldRowBeSkipped || (() => false), r2 = null != t3.rowPositions || !!t3.onlySelected, i2 = this.gos.get("groupHideOpenParents") && !r2, s2 = this.colModel.isPivotMode() ? n2.leafGroup : !n2.group, d2 = !!n2.footer, c = 1 === n2.allChildrenCount && 1 === ((_a = n2.childrenAfterGroup) == null ? void 0 : _a.length) && (0, l._canSkipShowingRowGroup)(this.gos, n2);
                if (!s2 && !d2 && (t3.skipRowGroups || c || i2) || t3.onlySelected && !n2.isSelected() || t3.skipPinnedTop && "top" === n2.rowPinned || t3.skipPinnedBottom && "bottom" === n2.rowPinned)
                  return;
                if (-1 === n2.level && !s2 && !d2)
                  return;
                if (o2(this.gos.addGridCommonParams({ node: n2 })))
                  return;
                const g = e3.onNewBodyRow(n2);
                if (a3.forEach((e4, t4) => {
                  g.onColumn(e4, t4, n2);
                }), t3.getCustomContentBelowRow) {
                  const a4 = t3.getCustomContentBelowRow(this.gos.addGridCommonParams({ node: n2 }));
                  a4 && e3.addCustomContent(a4);
                }
              }
              appendContent(e3) {
                return (t3) => {
                  const a3 = e3.appendContent;
                  return a3 && t3.addCustomContent(a3), t3;
                };
              }
              prependContent(e3) {
                return (t3) => {
                  const a3 = e3.prependContent;
                  return a3 && t3.addCustomContent(a3), t3;
                };
              }
              prepareSession(e3) {
                return (t3) => (t3.prepare(e3), t3);
              }
              exportColumnGroups(e3, t3) {
                return (a3) => {
                  if (!e3.skipColumnGroupHeaders) {
                    const n2 = new o.GroupInstanceIdCreator(), { colGroupSvc: r2 } = this.beans, i2 = r2 ? r2.createColumnGroups({ columns: t3, idCreator: n2, pinned: null, isStandaloneStructure: true }) : t3;
                    this.recursivelyAddHeaderGroups(i2, a3, e3.processGroupHeaderCallback);
                  }
                  return a3;
                };
              }
              exportHeaders(e3, t3) {
                return (a3) => {
                  if (!e3.skipColumnHeaders) {
                    const e4 = a3.onNewHeaderRow();
                    t3.forEach((t4, a4) => {
                      e4.onColumn(t4, a4, void 0);
                    });
                  }
                  return a3;
                };
              }
              processPinnedTopRows(e3, t3) {
                return (a3) => {
                  var _a;
                  const n2 = this.processRow.bind(this, a3, e3, t3);
                  return e3.rowPositions ? e3.rowPositions.filter((e4) => "top" === e4.rowPinned).sort((e4, t4) => e4.rowIndex - t4.rowIndex).map((e4) => {
                    var _a2;
                    return (_a2 = this.pinnedRowModel) == null ? void 0 : _a2.getPinnedTopRow(e4.rowIndex);
                  }).forEach(n2) : (_a = this.pinnedRowModel) == null ? void 0 : _a.forEachPinnedRow("top", n2), a3;
                };
              }
              processRows(e3, t3) {
                return (a3) => {
                  var _a, _b;
                  const n2 = this.rowModel, o2 = (0, l._isClientSideRowModel)(this.gos, n2), r2 = (0, l._isServerSideRowModel)(this.gos, n2), i2 = !o2 && e3.onlySelected, s2 = this.processRow.bind(this, a3, e3, t3), { exportedRows: d2 = "filteredAndSorted" } = e3;
                  if (e3.rowPositions)
                    return e3.rowPositions.filter((e4) => null == e4.rowPinned).sort((e4, t4) => e4.rowIndex - t4.rowIndex).map((e4) => n2.getRow(e4.rowIndex)).forEach(s2), a3;
                  if (this.colModel.isPivotMode())
                    return o2 ? n2.forEachPivotNode(s2, true) : r2 ? n2.forEachNodeAfterFilterAndSort(s2, true) : n2.forEachNode(s2), a3;
                  if (e3.onlySelectedAllPages || i2) {
                    const e4 = (_b = (_a = this.beans.selectionSvc) == null ? void 0 : _a.getSelectedNodes()) != null ? _b : [];
                    this.replicateSortedOrder(e4), e4.forEach(s2);
                  } else
                    "all" === d2 ? n2.forEachNode(s2) : o2 || r2 ? n2.forEachNodeAfterFilterAndSort(s2, true) : n2.forEachNode(s2);
                  return a3;
                };
              }
              replicateSortedOrder(e3) {
                const { sortSvc: t3, rowNodeSorter: a3 } = this.beans;
                if (!t3 || !a3)
                  return;
                const n2 = t3.getSortOptions(), o2 = (e4, t4) => {
                  var _a, _b, _c, _d2;
                  return null != e4.rowIndex && null != t4.rowIndex ? e4.rowIndex - t4.rowIndex : e4.level === t4.level ? ((_a = e4.parent) == null ? void 0 : _a.id) === ((_b = t4.parent) == null ? void 0 : _b.id) ? a3.compareRowNodes(n2, { rowNode: e4, currentPos: (_c = e4.rowIndex) != null ? _c : -1 }, { rowNode: t4, currentPos: (_d2 = t4.rowIndex) != null ? _d2 : -1 }) : o2(e4.parent, t4.parent) : e4.level > t4.level ? o2(e4.parent, t4) : o2(e4, t4.parent);
                };
                e3.sort(o2);
              }
              processPinnedBottomRows(e3, t3) {
                return (a3) => {
                  var _a;
                  const n2 = this.processRow.bind(this, a3, e3, t3);
                  return e3.rowPositions ? e3.rowPositions.filter((e4) => "bottom" === e4.rowPinned).sort((e4, t4) => e4.rowIndex - t4.rowIndex).map((e4) => {
                    var _a2;
                    return (_a2 = this.pinnedRowModel) == null ? void 0 : _a2.getPinnedBottomRow(e4.rowIndex);
                  }).forEach(n2) : (_a = this.pinnedRowModel) == null ? void 0 : _a.forEachPinnedRow("bottom", n2), a3;
                };
              }
              getColumnsToExport(e3 = false, t3 = false, a3) {
                const { colModel: o2, gos: r2, visibleCols: i2 } = this, l2 = o2.isPivotMode();
                if (a3 && a3.length)
                  return o2.getColsForKeys(a3);
                const s2 = r2.get("treeData");
                let d2 = [];
                return d2 = e3 && !l2 ? o2.getCols() : i2.allCols, d2 = d2.filter((e4) => !((0, n.isColumnSelectionCol)(e4) || t3 && !s2 && (0, n.isColumnGroupAutoCol)(e4))), d2;
              }
              recursivelyAddHeaderGroups(e3, t3, a3) {
                const n2 = [];
                e3.forEach((e4) => {
                  const t4 = e4;
                  t4.getChildren && t4.getChildren().forEach((e5) => n2.push(e5));
                }), e3.length > 0 && (0, i.isColumnGroup)(e3[0]) && this.doAddHeaderHeader(t3, e3, a3), n2 && n2.length > 0 && this.recursivelyAddHeaderGroups(n2, t3, a3);
              }
              doAddHeaderHeader(e3, t3, a3) {
                const n2 = e3.onNewHeaderGroupingRow();
                let o2 = 0;
                t3.forEach((e4) => {
                  const t4 = e4;
                  let r2;
                  r2 = a3 ? a3(this.gos.addGridCommonParams({ columnGroup: t4 })) : this.beans.colNames.getDisplayNameForColumnGroup(t4, "header");
                  const i2 = t4.getLeafColumns().reduce((e5, t5, a4, n3) => {
                    let o3 = (0, s._last)(e5);
                    return "open" === t5.getColumnGroupShow() ? o3 && null == o3[1] || (o3 = [a4], e5.push(o3)) : o3 && null == o3[1] && (o3[1] = a4 - 1), a4 === n3.length - 1 && o3 && null == o3[1] && (o3[1] = a4), e5;
                  }, []);
                  n2.onColumn(t4, r2 || "", o2++, t4.getLeafColumns().length - 1, i2);
                });
              }
            }
            t2.GridSerializer = d;
          }, 6331: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.columnFiltersCSS = void 0, t2.columnFiltersCSS = ".ag-set-filter{--ag-indentation-level:0}.ag-set-filter-item{align-items:center;display:flex;height:100%}:where(.ag-ltr) .ag-set-filter-item{padding-left:calc(var(--ag-widget-container-horizontal-padding) + var(--ag-indentation-level)*var(--ag-set-filter-indent-size))}:where(.ag-rtl) .ag-set-filter-item{padding-right:calc(var(--ag-widget-container-horizontal-padding) + var(--ag-indentation-level)*var(--ag-set-filter-indent-size))}.ag-set-filter-item-checkbox{display:flex;height:100%;width:100%}.ag-set-filter-group-icons{display:block;>*{cursor:pointer}}:where(.ag-ltr) .ag-set-filter-group-icons{margin-right:var(--ag-widget-container-horizontal-padding)}:where(.ag-rtl) .ag-set-filter-group-icons{margin-left:var(--ag-widget-container-horizontal-padding)}.ag-filter-body-wrapper{display:flex;flex-direction:column}:where(.ag-menu:not(.ag-tabs) .ag-filter) .ag-filter-body-wrapper,:where(.ag-menu:not(.ag-tabs) .ag-filter)>:not(.ag-filter-wrapper){min-width:180px}.ag-filter-filter{flex:1 1 0px}.ag-filter-condition{display:flex;justify-content:center}.ag-floating-filter-body{display:flex;flex:1 1 auto;height:100%;position:relative}.ag-floating-filter-full-body{align-items:center;display:flex;flex:1 1 auto;height:100%;overflow:hidden;width:100%}.ag-floating-filter-input{align-items:center;display:flex;width:100%;>*{flex:1 1 auto}:where(.ag-input-field-input[type=date]){width:1px}}.ag-floating-filter-button{display:flex;flex:none}.ag-set-floating-filter-input [disabled]{pointer-events:none}.ag-floating-filter-button-button{-webkit-appearance:none;-moz-appearance:none;appearance:none;border:none;height:var(--ag-icon-size);width:var(--ag-icon-size)}.ag-filter-loading{background-color:var(--ag-chrome-background-color);height:100%;padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);position:absolute;width:100%;z-index:1;:where(.ag-menu) &{background-color:var(--ag-menu-background-color)}}.ag-filter-separator{border-top:1px solid var(--menu-separator-color)}:where(.ag-filter-select) .ag-picker-field-wrapper{width:0}.ag-filter-condition-operator{height:17px}:where(.ag-ltr) .ag-filter-condition-operator-or{margin-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-filter-condition-operator-or{margin-right:calc(var(--ag-spacing)*2)}.ag-set-filter-select-all{padding-top:var(--ag-widget-container-vertical-padding)}.ag-filter-no-matches,.ag-set-filter-list{height:calc(var(--ag-list-item-height)*6)}.ag-filter-no-matches{padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding)}.ag-set-filter-tree-list{height:calc(var(--ag-list-item-height)*10)}.ag-set-filter-filter{margin-left:var(--ag-widget-container-horizontal-padding);margin-right:var(--ag-widget-container-horizontal-padding);margin-top:var(--ag-widget-container-vertical-padding)}.ag-filter-to{margin-top:var(--ag-widget-vertical-spacing)}.ag-mini-filter{margin:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding)}:where(.ag-ltr) .ag-set-filter-add-group-indent{margin-left:calc(var(--ag-icon-size) + var(--ag-widget-container-horizontal-padding))}:where(.ag-rtl) .ag-set-filter-add-group-indent{margin-right:calc(var(--ag-icon-size) + var(--ag-widget-container-horizontal-padding))}:where(.ag-filter-menu) .ag-set-filter-list{min-width:200px}.ag-filter-virtual-list-item:focus-visible{box-shadow:inset var(--ag-focus-shadow)}.ag-filter-apply-panel{display:flex;justify-content:flex-end;overflow:hidden;padding:var(--ag-widget-vertical-spacing) var(--ag-widget-container-horizontal-padding) var(--ag-widget-container-vertical-padding)}.ag-filter-apply-panel-button{line-height:1.5}:where(.ag-ltr) .ag-filter-apply-panel-button{margin-left:calc(var(--ag-spacing)*2)}:where(.ag-rtl) .ag-filter-apply-panel-button{margin-right:calc(var(--ag-spacing)*2)}.ag-simple-filter-body-wrapper{display:flex;flex-direction:column;min-height:calc(var(--ag-list-item-height) + var(--ag-widget-container-vertical-padding) + var(--ag-widget-vertical-spacing));overflow-y:auto;padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding);padding-bottom:calc(var(--ag-widget-container-vertical-padding) - var(--ag-widget-vertical-spacing));&>*{margin-bottom:var(--ag-widget-vertical-spacing)}:where(.ag-resizer-wrapper){margin:0}}.ag-multi-filter-menu-item{margin:var(--ag-spacing) 0}.ag-multi-filter-group-title-bar{background-color:transparent;color:var(--ag-header-text-color);font-weight:500;padding:calc(var(--ag-spacing)*1.5) var(--ag-spacing)}.ag-group-filter-field-select-wrapper{display:flex;flex-direction:column;gap:var(--ag-widget-vertical-spacing);padding:var(--ag-widget-container-vertical-padding) var(--ag-widget-container-horizontal-padding)}";
          }, 4527: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.showColumnFilter = t2.setColumnFilterModel = t2.getColumnFilterModel = t2.getFilterModel = t2.setFilterModel = t2.destroyFilter = t2.getColumnFilterInstance = t2.isColumnFilterPresent = void 0;
            const n = a2(7764);
            t2.isColumnFilterPresent = function(e3) {
              const t3 = e3.filterManager;
              return !!(t3 == null ? void 0 : t3.isColumnFilterPresent()) || !!(t3 == null ? void 0 : t3.isAggregateFilterPresent());
            }, t2.getColumnFilterInstance = function(e3, t3) {
              var _a, _b;
              return (_b = (_a = e3.filterManager) == null ? void 0 : _a.getColumnFilterInstance(t3)) != null ? _b : Promise.resolve(void 0);
            }, t2.destroyFilter = function(e3, t3) {
              var _a;
              const a3 = e3.colModel.getColDefCol(t3);
              if (a3)
                return (_a = e3.filterManager) == null ? void 0 : _a.destroyFilter(a3, "api");
            }, t2.setFilterModel = function(e3, t3) {
              e3.frameworkOverrides.wrapIncoming(() => {
                var _a;
                return (_a = e3.filterManager) == null ? void 0 : _a.setFilterModel(t3);
              });
            }, t2.getFilterModel = function(e3) {
              var _a, _b;
              return (_b = (_a = e3.filterManager) == null ? void 0 : _a.getFilterModel()) != null ? _b : {};
            }, t2.getColumnFilterModel = function(e3, t3) {
              var _a, _b;
              return (_b = (_a = e3.filterManager) == null ? void 0 : _a.getColumnFilterModel(t3)) != null ? _b : null;
            }, t2.setColumnFilterModel = function(e3, t3, a3) {
              var _a, _b;
              return (_b = (_a = e3.filterManager) == null ? void 0 : _a.setColumnFilterModel(t3, a3)) != null ? _b : Promise.resolve();
            }, t2.showColumnFilter = function(e3, t3) {
              var _a;
              const a3 = e3.colModel.getCol(t3);
              a3 ? (_a = e3.menuSvc) == null ? void 0 : _a.showFilterMenu({ column: a3, containerType: "columnFilter", positionBy: "auto" }) : (0, n._error)(12, { colKey: t3 });
            };
          }, 219: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ColumnFilterService = void 0;
            const n = a2(4126), o = a2(2036), r = a2(8731), i = a2(7274), l = a2(4422), s = a2(7990), d = a2(7764), c = a2(9990), g = { january: "January", february: "February", march: "March", april: "April", may: "May", june: "June", july: "July", august: "August", september: "September", october: "October", november: "November", december: "December" }, u = ["january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"];
            function h(e3, t3) {
              return null == e3 ? -1 : null == t3 ? 1 : parseFloat(e3) - parseFloat(t3);
            }
            class p extends r.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "colFilter", this.allColumnFilters = /* @__PURE__ */ new Map(), this.allColumnListeners = /* @__PURE__ */ new Map(), this.activeAggregateFilters = [], this.activeColumnFilters = [], this.processingFilterChange = false, this.filterModelUpdateQueue = [], this.columnFilterModelUpdateQueue = [];
              }
              postConstruct() {
                var _a, _b, _c;
                this.addManagedEventListeners({ gridColumnsChanged: this.onColumnsChanged.bind(this), beforeRefreshModel: ({ params: e3 }) => {
                  var _a2;
                  (e3.rowDataUpdated || ((_a2 = e3.changedProps) == null ? void 0 : _a2.has("treeData"))) && this.onNewRowsLoaded("rowDataUpdated");
                }, dataTypesInferred: this.processFilterModelUpdateQueue.bind(this) }), this.initialFilterModel = __spreadValues({}, (_c = (_b = (_a = this.gos.get("initialState")) == null ? void 0 : _a.filter) == null ? void 0 : _b.filterModel) != null ? _c : {});
              }
              setFilterModel(e3, t3 = "api") {
                const { colModel: a3, dataTypeSvc: n2, filterManager: o2 } = this.beans;
                if (n2 == null ? void 0 : n2.isPendingInference)
                  return void this.filterModelUpdateQueue.push({ model: e3, source: t3 });
                const r2 = [], i2 = this.getFilterModel(true);
                if (e3) {
                  const t4 = new Set(Object.keys(e3));
                  this.allColumnFilters.forEach((a4, n3) => {
                    const o3 = e3[n3];
                    r2.push(m(a4.filterPromise, o3)), t4.delete(n3);
                  }), t4.forEach((t5) => {
                    const n3 = a3.getColDefCol(t5) || a3.getCol(t5);
                    if (!n3)
                      return void (0, d._warn)(62, { colId: t5 });
                    if (!n3.isFilterAllowed())
                      return void (0, d._warn)(63, { colId: t5 });
                    const o3 = this.getOrCreateFilterWrapper(n3);
                    o3 ? r2.push(m(o3.filterPromise, e3[t5])) : (0, d._warn)(64, { colId: t5 });
                  });
                } else
                  this.allColumnFilters.forEach((e4) => {
                    r2.push(m(e4.filterPromise, null));
                  });
                s.AgPromise.all(r2).then(() => {
                  const e4 = this.getFilterModel(true), a4 = [];
                  this.allColumnFilters.forEach((t4, n3) => {
                    const o3 = i2 ? i2[n3] : null, r3 = e4 ? e4[n3] : null;
                    (0, l._jsonEquals)(o3, r3) || a4.push(t4.column);
                  }), a4.length > 0 && (o2 == null ? void 0 : o2.onFilterChanged({ columns: a4, source: t3 }));
                });
              }
              getFilterModel(e3) {
                const t3 = {}, { allColumnFilters: a3, initialFilterModel: n2, beans: { colModel: o2 } } = this;
                return a3.forEach((e4, a4) => {
                  const n3 = this.getModelFromFilterWrapper(e4);
                  (0, l._exists)(n3) && (t3[a4] = n3);
                }), e3 || Object.entries(n2).forEach(([e4, n3]) => {
                  var _a;
                  (0, l._exists)(n3) && !a3.has(e4) && ((_a = o2.getCol(e4)) == null ? void 0 : _a.isFilterAllowed()) && (t3[e4] = n3);
                }), t3;
              }
              getModelFromFilterWrapper(e3) {
                const { filter: t3 } = e3;
                return t3 ? "function" != typeof t3.getModel ? ((0, d._warn)(66), null) : t3.getModel() : this.getModelFromInitialState(e3.column);
              }
              getModelFromInitialState(e3) {
                var _a;
                return (_a = this.initialFilterModel[e3.getColId()]) != null ? _a : null;
              }
              isColumnFilterPresent() {
                return this.activeColumnFilters.length > 0;
              }
              isAggregateFilterPresent() {
                return !!this.activeAggregateFilters.length;
              }
              disableColumnFilters() {
                const { allColumnFilters: e3 } = this;
                return !!e3.size && (e3.forEach((e4) => this.disposeFilterWrapper(e4, "advancedFilterEnabled")), true);
              }
              doAggregateFiltersPass(e3, t3) {
                return this.doColumnFiltersPass(e3, t3, true);
              }
              updateActiveFilters() {
                const { colModel: e3, gos: t3 } = this.beans, a3 = !!(0, i._getGroupAggFiltering)(t3), n2 = [], o2 = [];
                return this.forEachColumnFilter((t4, r2) => {
                  const i2 = ((e4) => !!e4 && (e4.isFilterActive ? e4.isFilterActive() : ((0, d._warn)(67), false)))(t4);
                  i2 && (((t5) => {
                    if (!t5.isPrimary())
                      return true;
                    const n3 = !e3.isPivotActive();
                    return !(!t5.isValueActive() || !n3) && (!!e3.isPivotMode() || a3);
                  })(r2.column) ? n2.push(t4) : o2.push(t4));
                }).then(() => {
                  this.activeAggregateFilters = n2, this.activeColumnFilters = o2;
                });
              }
              updateFilterFlagInColumns(e3, t3) {
                return this.forEachColumnFilter((a3, n2) => this.setColFilterActive(n2.column, a3.isFilterActive(), e3, t3));
              }
              forEachColumnFilter(e3) {
                const t3 = [];
                return this.allColumnFilters.forEach((a3) => {
                  const n2 = a3.filterPromise;
                  n2 && t3.push(n2.then((t4) => e3(t4, a3)));
                }), s.AgPromise.all(t3);
              }
              doColumnFiltersPass(e3, t3, a3) {
                const { data: n2, aggData: o2 } = e3, r2 = a3 ? this.activeAggregateFilters : this.activeColumnFilters, i2 = a3 ? o2 : n2;
                for (let a4 = 0; a4 < r2.length; a4++) {
                  const n3 = r2[a4];
                  if (null != n3 && n3 !== t3)
                    if ("function" == typeof n3.doesFilterPass) {
                      if (!n3.doesFilterPass({ node: e3, data: i2 }))
                        return false;
                    } else
                      (0, d._error)(91);
                }
                return true;
              }
              callOnFilterChangedOutsideRenderCycle(e3) {
                const { rowRenderer: t3, filterManager: a3 } = this.beans, n2 = () => {
                  this.isAlive() && (a3 == null ? void 0 : a3.onFilterChanged(e3));
                };
                t3.isRefreshInProgress() ? setTimeout(n2, 0) : n2();
              }
              updateBeforeFilterChanged(e3 = {}) {
                const { filterInstance: t3, additionalEventAttributes: a3 } = e3;
                return this.updateDependentFilters(), this.updateActiveFilters().then(() => this.updateFilterFlagInColumns("filterChanged", a3).then(() => {
                  this.allColumnFilters.forEach((e4) => {
                    e4.filterPromise && e4.filterPromise.then((e5) => {
                      e5 && e5 !== t3 && e5.onAnyFilterChanged && e5.onAnyFilterChanged();
                    });
                  }), this.processingFilterChange = true;
                }));
              }
              updateAfterFilterChanged() {
                this.processingFilterChange = false;
              }
              isSuppressFlashingCellsBecauseFiltering() {
                var _a;
                return !((_a = this.gos.get("allowShowChangeAfterFilter")) != null ? _a : false) && this.processingFilterChange;
              }
              onNewRowsLoaded(e3) {
                this.forEachColumnFilter((e4) => {
                  var _a;
                  (_a = e4.onNewRowsLoaded) == null ? void 0 : _a.call(e4);
                }).then(() => this.updateFilterFlagInColumns(e3, { afterDataChange: true })).then(() => this.updateActiveFilters());
              }
              createGetValue(e3) {
                const { filterValueSvc: t3, colModel: a3 } = this.beans;
                return (n2, o2) => {
                  const r2 = o2 ? a3.getCol(o2) : e3;
                  return r2 ? t3.getValue(r2, n2) : void 0;
                };
              }
              isFilterActive(e3) {
                var _a;
                const { filter: t3 } = (_a = this.cachedFilter(e3)) != null ? _a : {};
                return t3 ? t3.isFilterActive() : null != this.getModelFromInitialState(e3);
              }
              getOrCreateFilterWrapper(e3) {
                if (!e3.isFilterAllowed())
                  return null;
                let t3 = this.cachedFilter(e3);
                return t3 || (t3 = this.createFilterWrapper(e3), this.setColumnFilterWrapper(e3, t3)), t3;
              }
              cachedFilter(e3) {
                return this.allColumnFilters.get(e3.getColId());
              }
              getDefaultFilter(e3) {
                let t3;
                const { gos: a3, dataTypeSvc: n2 } = this.beans;
                if ((0, i._isSetFilterByDefault)(a3))
                  t3 = "agSetColumnFilter";
                else {
                  const a4 = n2 == null ? void 0 : n2.getBaseDataType(e3);
                  t3 = "number" === a4 ? "agNumberColumnFilter" : "date" === a4 || "dateString" === a4 ? "agDateColumnFilter" : "agTextColumnFilter";
                }
                return t3;
              }
              getDefaultFloatingFilter(e3) {
                let t3;
                const { gos: a3, dataTypeSvc: n2 } = this.beans;
                if ((0, i._isSetFilterByDefault)(a3))
                  t3 = "agSetColumnFloatingFilter";
                else {
                  const a4 = n2 == null ? void 0 : n2.getBaseDataType(e3);
                  t3 = "number" === a4 ? "agNumberColumnFloatingFilter" : "date" === a4 || "dateString" === a4 ? "agDateColumnFloatingFilter" : "agTextColumnFloatingFilter";
                }
                return t3;
              }
              createFilterInstance(e3, t3) {
                const a3 = this.getDefaultFilter(e3), n2 = e3.getColDef();
                let r2;
                const i2 = __spreadProps(__spreadValues({}, this.createFilterParams(e3, n2)), { filterModifiedCallback: () => this.filterModifiedCallbackFactory(r2, e3)(), filterChangedCallback: (t4) => this.filterChangedCallbackFactory(r2, e3)(t4), doesRowPassOtherFilter: (e4) => {
                  var _a, _b;
                  return (_b = (_a = this.beans.filterManager) == null ? void 0 : _a.doesRowPassOtherFilters(r2, e4)) != null ? _b : true;
                } }), l2 = (0, o._getFilterDetails)(this.beans.userCompFactory, n2, i2, a3);
                return l2 ? { filterPromise: () => {
                  const e4 = l2.newAgStackInstance();
                  return e4.then((e5) => {
                    r2 = e5, t3 && (t3.filter = e5 != null ? e5 : void 0);
                  }), e4;
                }, compDetails: l2 } : { filterPromise: null, compDetails: null };
              }
              createFilterParams(e3, t3) {
                return this.gos.addGridCommonParams({ column: e3, colDef: t3, rowModel: this.beans.rowModel, filterChangedCallback: () => {
                }, filterModifiedCallback: () => {
                }, getValue: this.createGetValue(e3), doesRowPassOtherFilter: () => true });
              }
              createFilterWrapper(e3) {
                var _a;
                const t3 = { column: e3, filterPromise: null, compDetails: null }, { filterPromise: a3, compDetails: n2 } = this.createFilterInstance(e3, t3);
                return t3.filterPromise = (_a = a3 == null ? void 0 : a3()) != null ? _a : null, t3.compDetails = n2, t3;
              }
              onColumnsChanged() {
                const e3 = [], { colModel: t3, filterManager: a3 } = this.beans;
                this.allColumnFilters.forEach((a4, n3) => {
                  let o2;
                  o2 = a4.column.isPrimary() ? t3.getColDefCol(n3) : t3.getCol(n3), o2 && o2 === a4.column || (e3.push(a4.column), this.disposeFilterWrapper(a4, "columnChanged"), this.disposeColumnListener(n3));
                });
                const n2 = e3.every((e4) => "agGroupColumnFilter" === e4.getColDef().filter);
                e3.length > 0 && !n2 ? a3 == null ? void 0 : a3.onFilterChanged({ columns: e3, source: "api" }) : this.updateDependentFilters();
              }
              updateDependentFilters() {
                var _a, _b;
                (_b = (_a = this.beans.autoColSvc) == null ? void 0 : _a.getAutoCols()) == null ? void 0 : _b.forEach((e3) => {
                  "agGroupColumnFilter" === e3.getColDef().filter && this.getOrCreateFilterWrapper(e3);
                });
              }
              isFilterAllowed(e3) {
                var _a;
                if (!e3.isFilterAllowed())
                  return false;
                const { filter: t3 } = (_a = this.allColumnFilters.get(e3.getColId())) != null ? _a : {};
                return !t3 || ("function" != typeof (t3 == null ? void 0 : t3.isFilterAllowed) || t3.isFilterAllowed());
              }
              getFloatingFilterCompDetails(e3, t3) {
                const a3 = (t4) => {
                  var _a;
                  const a4 = (_a = this.getOrCreateFilterWrapper(e3)) == null ? void 0 : _a.filterPromise;
                  null != a4 && a4.then((e4) => {
                    t4((0, n._unwrapUserComp)(e4));
                  });
                }, r2 = e3.getColDef(), i2 = __spreadProps(__spreadValues({}, this.createFilterParams(e3, r2)), { filterChangedCallback: () => a3((t4) => this.filterChangedCallbackFactory(t4, e3)()) }), { userCompFactory: l2, frameworkOverrides: s2 } = this.beans, d2 = (0, o._mergeFilterParamsWithApplicationProvidedParams)(l2, r2, i2);
                let g2 = (0, c._getDefaultFloatingFilterType)(s2, r2, () => this.getDefaultFloatingFilter(e3));
                null == g2 && (g2 = "agReadOnlyFloatingFilter");
                const u2 = { column: e3, filterParams: d2, currentParentModel: () => this.getCurrentFloatingFilterParentModel(e3), parentFilterInstance: a3, showParentFilter: t3 };
                return (0, o._getFloatingFilterCompDetails)(l2, r2, u2, g2);
              }
              getCurrentFloatingFilterParentModel(e3) {
                var _a;
                return this.getModelFromFilterWrapper((_a = this.cachedFilter(e3)) != null ? _a : { column: e3 });
              }
              destroyFilter(e3, t3 = "api") {
                var _a;
                const a3 = e3.getColId(), n2 = this.allColumnFilters.get(a3);
                this.disposeColumnListener(a3), delete this.initialFilterModel[a3], n2 && (this.disposeFilterWrapper(n2, t3), (_a = this.beans.filterManager) == null ? void 0 : _a.onFilterChanged({ columns: [e3], source: "api" }));
              }
              disposeColumnListener(e3) {
                const t3 = this.allColumnListeners.get(e3);
                t3 && (this.allColumnListeners.delete(e3), t3());
              }
              disposeFilterWrapper(e3, t3) {
                var _a;
                (_a = e3.filterPromise) == null ? void 0 : _a.then((a3) => {
                  this.destroyBean(a3), this.setColFilterActive(e3.column, false, "filterDestroyed"), this.allColumnFilters.delete(e3.column.getColId()), this.eventSvc.dispatchEvent({ type: "filterDestroyed", source: t3, column: e3.column });
                });
              }
              filterModifiedCallbackFactory(e3, t3) {
                return () => {
                  this.eventSvc.dispatchEvent({ type: "filterModified", column: t3, filterInstance: e3 });
                };
              }
              filterChangedCallbackFactory(e3, t3) {
                return (a3) => {
                  var _a;
                  const n2 = { filter: e3, additionalEventAttributes: a3, columns: [t3], source: (_a = a3 == null ? void 0 : a3.source) != null ? _a : "columnFilter" };
                  this.callOnFilterChangedOutsideRenderCycle(n2);
                };
              }
              checkDestroyFilter(e3) {
                const t3 = this.allColumnFilters.get(e3);
                if (!t3)
                  return;
                const a3 = t3.column, { compDetails: n2 } = a3.isFilterAllowed() ? this.createFilterInstance(a3) : { compDetails: null };
                if (this.areFilterCompsDifferent(t3.compDetails, n2))
                  return void this.destroyFilter(a3, "paramsUpdated");
                const o2 = a3.getColDef().filterParams;
                t3.filterPromise ? t3.filterPromise.then((e4) => {
                  false === (!(e4 == null ? void 0 : e4.refresh) || e4.refresh(__spreadValues(__spreadProps(__spreadValues({}, this.createFilterParams(a3, a3.getColDef())), { filterModifiedCallback: this.filterModifiedCallbackFactory(e4, a3), filterChangedCallback: this.filterChangedCallbackFactory(e4, a3), doesRowPassOtherFilter: (t4) => {
                    var _a, _b;
                    return (_b = (_a = this.beans.filterManager) == null ? void 0 : _a.doesRowPassOtherFilters(e4, t4)) != null ? _b : true;
                  } }), o2))) && this.destroyFilter(a3, "paramsUpdated");
                }) : this.destroyFilter(a3, "paramsUpdated");
              }
              setColumnFilterWrapper(e3, t3) {
                const a3 = e3.getColId();
                this.allColumnFilters.set(a3, t3), this.allColumnListeners.set(a3, this.addManagedListeners(e3, { colDefChanged: () => this.checkDestroyFilter(a3) })[0]);
              }
              areFilterCompsDifferent(e3, t3) {
                if (!t3 || !e3)
                  return true;
                const { componentClass: a3 } = e3, { componentClass: n2 } = t3;
                return !(a3 === n2 || (a3 == null ? void 0 : a3.render) && (n2 == null ? void 0 : n2.render) && a3.render === n2.render);
              }
              hasFloatingFilters() {
                return this.beans.colModel.getCols().some((e3) => e3.getColDef().floatingFilter);
              }
              getColumnFilterInstance(e3) {
                return new Promise((t3) => {
                  this.getFilterInstanceImpl(e3).then((e4) => {
                    t3((0, n._unwrapUserComp)(e4));
                  });
                });
              }
              getFilterInstanceImpl(e3) {
                var _a;
                const t3 = this.beans.colModel.getColDefCol(e3);
                if (!t3)
                  return s.AgPromise.resolve(void 0);
                const a3 = (_a = this.getOrCreateFilterWrapper(t3)) == null ? void 0 : _a.filterPromise;
                return a3 != null ? a3 : s.AgPromise.resolve(null);
              }
              processFilterModelUpdateQueue() {
                this.filterModelUpdateQueue.forEach(({ model: e3, source: t3 }) => this.setFilterModel(e3, t3)), this.filterModelUpdateQueue = [], this.columnFilterModelUpdateQueue.forEach(({ key: e3, model: t3, resolve: a3 }) => {
                  this.setColumnFilterModel(e3, t3).then(() => a3());
                }), this.columnFilterModelUpdateQueue = [];
              }
              getColumnFilterModel(e3) {
                const t3 = this.getFilterWrapper(e3);
                return t3 ? this.getModelFromFilterWrapper(t3) : null;
              }
              setColumnFilterModel(e3, t3) {
                const { colModel: a3, dataTypeSvc: n2 } = this.beans;
                if (n2 == null ? void 0 : n2.isPendingInference) {
                  let a4 = () => {
                  };
                  const n3 = new Promise((e4) => {
                    a4 = e4;
                  });
                  return this.columnFilterModelUpdateQueue.push({ key: e3, model: t3, resolve: a4 }), n3;
                }
                const o2 = a3.getColDefCol(e3), r2 = o2 ? this.getOrCreateFilterWrapper(o2) : null;
                return r2 ? (i2 = m(r2.filterPromise, t3), new Promise((e4) => {
                  i2.then((t4) => e4(t4));
                })) : Promise.resolve();
                var i2;
              }
              getFilterWrapper(e3) {
                var _a;
                const t3 = this.beans.colModel.getColDefCol(e3);
                return t3 ? (_a = this.cachedFilter(t3)) != null ? _a : null : null;
              }
              setColDefPropertiesForDataType(e3, t3, a3) {
                const n2 = (0, i._isSetFilterByDefault)(this.gos), o2 = this.getLocaleTextFunc(), r2 = (t4) => {
                  const { filterParams: a4 } = e3;
                  e3.filterParams = "object" == typeof a4 ? __spreadValues(__spreadValues({}, a4), t4) : t4;
                };
                switch (t3.baseDataType) {
                  case "number":
                    n2 && r2({ comparator: h });
                    break;
                  case "boolean":
                    r2(n2 ? { valueFormatter: (e4) => (0, l._exists)(e4.value) ? o2(String(e4.value), e4.value ? "True" : "False") : o2("blanks", "(Blanks)") } : { maxNumConditions: 1, debounceMs: 0, filterOptions: ["empty", { displayKey: "true", displayName: "True", predicate: (e4, t4) => t4, numberOfInputs: 0 }, { displayKey: "false", displayName: "False", predicate: (e4, t4) => false === t4, numberOfInputs: 0 }] });
                    break;
                  case "date":
                    n2 && r2({ valueFormatter: (e4) => {
                      const t4 = a3(e4);
                      return (0, l._exists)(t4) ? t4 : o2("blanks", "(Blanks)");
                    }, treeList: true, treeListFormatter: (e4, t4) => {
                      if (1 === t4 && null != e4) {
                        const t5 = u[Number(e4) - 1];
                        return o2(t5, g[t5]);
                      }
                      return e4 != null ? e4 : o2("blanks", "(Blanks)");
                    } });
                    break;
                  case "dateString": {
                    const e4 = t3.dateParser;
                    r2(n2 ? { valueFormatter: (e5) => {
                      const t4 = a3(e5);
                      return (0, l._exists)(t4) ? t4 : o2("blanks", "(Blanks)");
                    }, treeList: true, treeListPathGetter: (t4) => {
                      const a4 = e4(t4 != null ? t4 : void 0);
                      return a4 ? [String(a4.getFullYear()), String(a4.getMonth() + 1), String(a4.getDate())] : null;
                    }, treeListFormatter: (e5, t4) => {
                      if (1 === t4 && null != e5) {
                        const t5 = u[Number(e5) - 1];
                        return o2(t5, g[t5]);
                      }
                      return e5 != null ? e5 : o2("blanks", "(Blanks)");
                    } } : { comparator: (t4, a4) => {
                      const n3 = e4(a4);
                      return null == a4 || n3 < t4 ? -1 : n3 > t4 ? 1 : 0;
                    } });
                    break;
                  }
                  case "object":
                    n2 ? r2({ valueFormatter: (e4) => {
                      const t4 = a3(e4);
                      return (0, l._exists)(t4) ? t4 : o2("blanks", "(Blanks)");
                    } }) : e3.filterValueGetter = (e4) => a3({ column: e4.column, node: e4.node, value: this.beans.valueSvc.getValue(e4.column, e4.node) });
                }
              }
              setColFilterActive(e3, t3, a3, n2) {
                e3.filterActive !== t3 && (e3.filterActive = t3, e3.dispatchColEvent("filterActiveChanged", a3)), e3.dispatchColEvent("filterChanged", a3, n2);
              }
              destroy() {
                super.destroy(), this.allColumnFilters.forEach((e3) => this.disposeFilterWrapper(e3, "gridDestroyed")), this.allColumnListeners.clear();
              }
            }
            function m(e3, t3) {
              return e3 ? new s.AgPromise((a3) => {
                e3.then((e4) => {
                  "function" != typeof e4.setModel && ((0, d._warn)(65), a3()), (e4.setModel(t3) || s.AgPromise.resolve()).then(() => a3());
                });
              }) : s.AgPromise.resolve();
            }
            t2.ColumnFilterService = p;
          }, 9002: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.onFilterChanged = t2.isAnyFilterPresent = void 0, t2.isAnyFilterPresent = function(e3) {
              var _a;
              return !!((_a = e3.filterManager) == null ? void 0 : _a.isAnyFilterPresent());
            }, t2.onFilterChanged = function(e3, t3 = "api") {
              var _a;
              (_a = e3.filterManager) == null ? void 0 : _a.onFilterChanged({ source: t3 });
            };
          }, 5741: function(e2, t2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.FILTER_LOCALE_TEXT = void 0, t2.FILTER_LOCALE_TEXT = { applyFilter: "Apply", clearFilter: "Clear", resetFilter: "Reset", cancelFilter: "Cancel", textFilter: "Text Filter", numberFilter: "Number Filter", dateFilter: "Date Filter", setFilter: "Set Filter", filterOoo: "Filter...", empty: "Choose one", equals: "Equals", notEqual: "Does not equal", lessThan: "Less than", greaterThan: "Greater than", inRange: "Between", inRangeStart: "From", inRangeEnd: "To", lessThanOrEqual: "Less than or equal to", greaterThanOrEqual: "Greater than or equal to", contains: "Contains", notContains: "Does not contain", startsWith: "Begins with", endsWith: "Ends with", blank: "Blank", notBlank: "Not blank", before: "Before", after: "After", andCondition: "AND", orCondition: "OR", dateFormatOoo: "yyyy-mm-dd" };
          }, 8681: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.FilterManager = void 0;
            const n = a2(8731), o = a2(7274), r = a2(6996), i = a2(7990), l = a2(7764);
            class s extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "filterManager", this.advFilterModelUpdateQueue = [];
              }
              wireBeans(e3) {
                this.quickFilter = e3.quickFilter, this.advancedFilter = e3.advancedFilter, this.colFilter = e3.colFilter;
              }
              postConstruct() {
                const e3 = this.refreshFiltersForAggregations.bind(this), t3 = this.updateAdvFilterColumns.bind(this);
                this.addManagedEventListeners({ columnValueChanged: e3, columnPivotChanged: e3, columnPivotModeChanged: e3, newColumnsLoaded: t3, columnVisible: t3, advancedFilterEnabledChanged: ({ enabled: e4 }) => this.onAdvFilterEnabledChanged(e4), dataTypesInferred: this.processFilterModelUpdateQueue.bind(this) }), this.externalFilterPresent = this.isExternalFilterPresentCallback(), this.addManagedPropertyListeners(["isExternalFilterPresent", "doesExternalFilterPass"], () => {
                  this.onFilterChanged({ source: "api" });
                }), this.updateAggFiltering(), this.addManagedPropertyListener("groupAggFiltering", () => {
                  this.updateAggFiltering(), this.onFilterChanged();
                }), this.quickFilter && this.addManagedListeners(this.quickFilter, { quickFilterChanged: () => this.onFilterChanged({ source: "quickFilter" }) });
                const { gos: a3 } = this;
                this.alwaysPassFilter = a3.get("alwaysPassFilter"), this.addManagedPropertyListener("alwaysPassFilter", () => {
                  this.alwaysPassFilter = a3.get("alwaysPassFilter"), this.onFilterChanged({ source: "api" });
                });
              }
              isExternalFilterPresentCallback() {
                const e3 = this.gos.getCallback("isExternalFilterPresent");
                return "function" == typeof e3 && e3({});
              }
              doesExternalFilterPass(e3) {
                const t3 = this.gos.get("doesExternalFilterPass");
                return "function" == typeof t3 && t3(e3);
              }
              setFilterModel(e3, t3 = "api") {
                var _a;
                this.isAdvFilterEnabled() ? this.warnAdvFilters() : (_a = this.colFilter) == null ? void 0 : _a.setFilterModel(e3, t3);
              }
              getFilterModel() {
                var _a, _b;
                return (_b = (_a = this.colFilter) == null ? void 0 : _a.getFilterModel()) != null ? _b : {};
              }
              isColumnFilterPresent() {
                var _a;
                return !!((_a = this.colFilter) == null ? void 0 : _a.isColumnFilterPresent());
              }
              isAggregateFilterPresent() {
                var _a;
                return !!((_a = this.colFilter) == null ? void 0 : _a.isAggregateFilterPresent());
              }
              isChildFilterPresent() {
                return this.isColumnFilterPresent() || this.isQuickFilterPresent() || this.externalFilterPresent || this.isAdvFilterPresent();
              }
              isAnyFilterPresent() {
                return this.isChildFilterPresent() || this.isAggregateFilterPresent();
              }
              isAdvFilterPresent() {
                return this.isAdvFilterEnabled() && this.advancedFilter.isFilterPresent();
              }
              onAdvFilterEnabledChanged(e3) {
                var _a, _b;
                e3 ? ((_a = this.colFilter) == null ? void 0 : _a.disableColumnFilters()) && this.onFilterChanged({ source: "advancedFilter" }) : ((_b = this.advancedFilter) == null ? void 0 : _b.isFilterPresent()) && (this.advancedFilter.setModel(null), this.onFilterChanged({ source: "advancedFilter" }));
              }
              isAdvFilterEnabled() {
                var _a;
                return !!((_a = this.advancedFilter) == null ? void 0 : _a.isEnabled());
              }
              isAdvFilterHeaderActive() {
                return this.isAdvFilterEnabled() && this.advancedFilter.isHeaderActive();
              }
              resetQuickFilterCache() {
                var _a;
                (_a = this.quickFilter) == null ? void 0 : _a.resetCache();
              }
              refreshFiltersForAggregations() {
                (0, o._getGroupAggFiltering)(this.gos) && this.onFilterChanged();
              }
              onFilterChanged(e3 = {}) {
                const { source: t3, additionalEventAttributes: a3, columns: n2 = [] } = e3;
                this.externalFilterPresent = this.isExternalFilterPresentCallback(), (this.colFilter ? this.colFilter.updateBeforeFilterChanged(e3) : i.AgPromise.resolve()).then(() => {
                  var _a;
                  const e4 = { source: t3, type: "filterChanged", columns: n2 };
                  a3 && (0, r._mergeDeep)(e4, a3), this.eventSvc.dispatchEvent(e4), (_a = this.colFilter) == null ? void 0 : _a.updateAfterFilterChanged();
                });
              }
              isSuppressFlashingCellsBecauseFiltering() {
                var _a;
                return !!((_a = this.colFilter) == null ? void 0 : _a.isSuppressFlashingCellsBecauseFiltering());
              }
              isQuickFilterPresent() {
                var _a;
                return !!((_a = this.quickFilter) == null ? void 0 : _a.isFilterPresent());
              }
              updateAggFiltering() {
                this.aggFiltering = !!(0, o._getGroupAggFiltering)(this.gos);
              }
              isAggregateQuickFilterPresent() {
                return this.isQuickFilterPresent() && this.shouldApplyQuickFilterAfterAgg();
              }
              isNonAggregateQuickFilterPresent() {
                return this.isQuickFilterPresent() && !this.shouldApplyQuickFilterAfterAgg();
              }
              shouldApplyQuickFilterAfterAgg() {
                return (this.aggFiltering || this.beans.colModel.isPivotMode()) && !this.gos.get("applyQuickFilterBeforePivotOrAgg");
              }
              doesRowPassOtherFilters(e3, t3) {
                return this.doesRowPassFilter({ rowNode: t3, filterInstanceToSkip: e3 });
              }
              doesRowPassAggregateFilters(e3) {
                var _a;
                const { rowNode: t3 } = e3;
                return !!((_a = this.alwaysPassFilter) == null ? void 0 : _a.call(this, t3)) || !(this.isAggregateQuickFilterPresent() && !this.quickFilter.doesRowPass(t3)) && !(this.isAggregateFilterPresent() && !this.colFilter.doAggregateFiltersPass(t3, e3.filterInstanceToSkip));
              }
              doesRowPassFilter(e3) {
                var _a;
                const { rowNode: t3 } = e3;
                return !!((_a = this.alwaysPassFilter) == null ? void 0 : _a.call(this, t3)) || !(this.isNonAggregateQuickFilterPresent() && !this.quickFilter.doesRowPass(t3)) && (!(this.externalFilterPresent && !this.doesExternalFilterPass(t3)) && (!(this.isColumnFilterPresent() && !this.colFilter.doColumnFiltersPass(t3, e3.filterInstanceToSkip)) && !(this.isAdvFilterPresent() && !this.advancedFilter.doesFilterPass(t3))));
              }
              isFilterActive(e3) {
                var _a;
                return !!((_a = this.colFilter) == null ? void 0 : _a.isFilterActive(e3));
              }
              getOrCreateFilterWrapper(e3) {
                var _a, _b;
                return (_b = (_a = this.colFilter) == null ? void 0 : _a.getOrCreateFilterWrapper(e3)) != null ? _b : null;
              }
              getDefaultFloatingFilter(e3) {
                return this.colFilter.getDefaultFloatingFilter(e3);
              }
              createFilterParams(e3, t3) {
                return this.colFilter.createFilterParams(e3, t3);
              }
              isFilterAllowed(e3) {
                var _a;
                return !this.isAdvFilterEnabled() && !!((_a = this.colFilter) == null ? void 0 : _a.isFilterAllowed(e3));
              }
              getFloatingFilterCompDetails(e3, t3) {
                var _a;
                return (_a = this.colFilter) == null ? void 0 : _a.getFloatingFilterCompDetails(e3, t3);
              }
              getCurrentFloatingFilterParentModel(e3) {
                var _a;
                return (_a = this.colFilter) == null ? void 0 : _a.getCurrentFloatingFilterParentModel(e3);
              }
              destroyFilter(e3, t3 = "api") {
                var _a;
                (_a = this.colFilter) == null ? void 0 : _a.destroyFilter(e3, t3);
              }
              areFilterCompsDifferent(e3, t3) {
                var _a;
                return !!((_a = this.colFilter) == null ? void 0 : _a.areFilterCompsDifferent(e3, t3));
              }
              getAdvFilterModel() {
                return this.isAdvFilterEnabled() ? this.advancedFilter.getModel() : null;
              }
              setAdvFilterModel(e3) {
                var _a;
                this.isAdvFilterEnabled() && (((_a = this.beans.dataTypeSvc) == null ? void 0 : _a.isPendingInference) ? this.advFilterModelUpdateQueue.push(e3) : (this.advancedFilter.setModel(e3 != null ? e3 : null), this.onFilterChanged({ source: "advancedFilter" })));
              }
              toggleAdvFilterBuilder(e3, t3) {
                this.isAdvFilterEnabled() && this.advancedFilter.getCtrl().toggleFilterBuilder({ source: t3, force: e3 });
              }
              updateAdvFilterColumns() {
                this.isAdvFilterEnabled() && this.advancedFilter.updateValidity() && this.onFilterChanged({ source: "advancedFilter" });
              }
              hasFloatingFilters() {
                var _a;
                return !this.isAdvFilterEnabled() && !!((_a = this.colFilter) == null ? void 0 : _a.hasFloatingFilters());
              }
              getColumnFilterInstance(e3) {
                var _a, _b;
                return this.isAdvFilterEnabled() ? (this.warnAdvFilters(), Promise.resolve(void 0)) : (_b = (_a = this.colFilter) == null ? void 0 : _a.getColumnFilterInstance(e3)) != null ? _b : Promise.resolve(void 0);
              }
              warnAdvFilters() {
                (0, l._warn)(68);
              }
              setupAdvFilterHeaderComp(e3) {
                var _a;
                (_a = this.advancedFilter) == null ? void 0 : _a.getCtrl().setupHeaderComp(e3);
              }
              getHeaderRowCount() {
                return this.isAdvFilterHeaderActive() ? 1 : 0;
              }
              getHeaderHeight() {
                return this.isAdvFilterHeaderActive() ? this.advancedFilter.getCtrl().getHeaderHeight() : 0;
              }
              processFilterModelUpdateQueue() {
                this.advFilterModelUpdateQueue.forEach((e3) => this.setAdvFilterModel(e3)), this.advFilterModelUpdateQueue = [];
              }
              getColumnFilterModel(e3) {
                var _a;
                return (_a = this.colFilter) == null ? void 0 : _a.getColumnFilterModel(e3);
              }
              setColumnFilterModel(e3, t3) {
                var _a, _b;
                return this.isAdvFilterEnabled() ? (this.warnAdvFilters(), Promise.resolve()) : (_b = (_a = this.colFilter) == null ? void 0 : _a.setColumnFilterModel(e3, t3)) != null ? _b : Promise.resolve();
              }
              setColDefPropertiesForDataType(e3, t3, a3) {
                var _a;
                (_a = this.colFilter) == null ? void 0 : _a.setColDefPropertiesForDataType(e3, t3, a3);
              }
            }
            t2.FilterManager = s;
          }, 9665: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.FilterMenuFactory = void 0;
            const n = a2(9853), o = a2(8731), r = a2(7274), i = a2(8994), l = a2(5230), s = a2(3507), d = a2(2331), c = a2(7764), g = a2(1854);
            class u extends o.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "filterMenuFactory";
              }
              wireBeans(e3) {
                this.popupSvc = e3.popupSvc;
              }
              hideActiveMenu() {
                var _a;
                (_a = this.hidePopup) == null ? void 0 : _a.call(this);
              }
              showMenuAfterMouseEvent(e3, t3, a3) {
                this.showPopup(e3, (n2) => {
                  var _a;
                  (_a = this.popupSvc) == null ? void 0 : _a.positionPopupUnderMouseEvent({ column: e3, type: a3, mouseEvent: t3, ePopup: n2 });
                }, a3, t3.target, (0, r._isLegacyMenuEnabled)(this.gos));
              }
              showMenuAfterButtonClick(e3, t3, a3) {
                let n2 = -1, o2 = "left";
                const i2 = (0, r._isLegacyMenuEnabled)(this.gos);
                !i2 && this.gos.get("enableRtl") && (n2 = 1, o2 = "right");
                const l2 = i2 ? void 0 : 4 * n2, s2 = i2 ? void 0 : 4;
                this.showPopup(e3, (n3) => {
                  var _a;
                  (_a = this.popupSvc) == null ? void 0 : _a.positionPopupByComponent({ type: a3, eventSource: t3, ePopup: n3, nudgeX: l2, nudgeY: s2, alignSide: o2, keepWithinBounds: true, position: "under", column: e3 });
                }, a3, t3, i2);
              }
              showPopup(e3, t3, a3, n2, o2) {
                var _a;
                const u2 = e3 ? this.createBean(new g.FilterWrapperComp(e3, "COLUMN_MENU")) : void 0;
                if (this.activeMenu = u2, !(u2 == null ? void 0 : u2.hasFilter()) || !e3)
                  return void (0, c._error)(57);
                const h = document.createElement("div");
                let p;
                (0, l._setAriaRole)(h, "presentation"), h.classList.add("ag-menu"), o2 || h.classList.add("ag-filter-menu"), [this.tabListener] = this.addManagedElementListeners(h, { keydown: (e4) => this.trapFocusWithin(e4, h) }), h.appendChild(u2 == null ? void 0 : u2.getGui());
                const m = (0, r._isColumnMenuAnchoringEnabled)(this.gos) ? n2 != null ? n2 : this.beans.ctrlsSvc.getGridBodyCtrl().eGridBody : void 0, f = this.getLocaleTextFunc(), v = o2 && "columnFilter" !== a3 ? f("ariaLabelColumnMenu", "Column Menu") : f("ariaLabelColumnFilter", "Column Filter"), b = (_a = this.popupSvc) == null ? void 0 : _a.addPopup({ modal: true, eChild: h, closeOnEsc: true, closedCallback: (t4) => {
                  (0, i._setColMenuVisible)(e3, false, "contextMenu");
                  const o3 = t4 instanceof KeyboardEvent;
                  if (this.tabListener && (this.tabListener = this.tabListener()), o3 && n2 && (0, s._isVisible)(n2)) {
                    const e4 = (0, d._findTabbableParent)(n2);
                    e4 == null ? void 0 : e4.focus({ preventScroll: true });
                  }
                  u2 == null ? void 0 : u2.afterGuiDetached(), this.destroyBean(this.activeMenu), this.dispatchVisibleChangedEvent(false, a3, e3);
                }, positionCallback: () => t3(h), anchorToElement: m, ariaLabel: v });
                b && (this.hidePopup = p = b.hideFunc), u2.afterInit().then(() => {
                  t3(h), u2.afterGuiAttached({ container: a3, hidePopup: p });
                }), (0, i._setColMenuVisible)(e3, true, "contextMenu"), this.dispatchVisibleChangedEvent(true, a3, e3);
              }
              trapFocusWithin(e3, t3) {
                e3.key !== n.KeyCode.TAB || e3.defaultPrevented || (0, d._findNextFocusableElement)(this.beans, t3, false, e3.shiftKey) || (e3.preventDefault(), (0, d._focusInto)(t3, e3.shiftKey));
              }
              dispatchVisibleChangedEvent(e3, t3, a3) {
                this.eventSvc.dispatchEvent({ type: "columnMenuVisibleChanged", visible: e3, switchingTab: false, key: t3, column: a3 != null ? a3 : null, columnGroup: null });
              }
              isMenuEnabled(e3) {
                var _a;
                return e3.isFilterAllowed() && ((_a = e3.getColDef().menuTabs) != null ? _a : ["filterMenuTab"]).includes("filterMenuTab");
              }
              showMenuAfterContextMenuEvent() {
              }
              destroy() {
                this.destroyBean(this.activeMenu), super.destroy();
              }
            }
            t2.FilterMenuFactory = u;
          }, 5432: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ExternalFilterModule = t2.QuickFilterModule = t2.DateFilterModule = t2.NumberFilterModule = t2.TextFilterModule = t2.CustomFilterModule = t2.ColumnFilterModule = t2.FilterValueModule = t2.FilterCoreModule = t2.ClientSideRowModelFilterModule = void 0;
            const n = a2(8287), o = a2(3868), r = a2(3472), i = a2(7205), l = a2(3137), s = a2(6331), d = a2(4527), c = a2(219), g = a2(9002), u = a2(8681), h = a2(9665), p = a2(3508), m = a2(6657), f = a2(3725), v = a2(3091), b = a2(5459), C = a2(8988), w = a2(4789), y = a2(2811), S = a2(8305), k = a2(5381), x = a2(1238);
            t2.ClientSideRowModelFilterModule = { moduleName: "ClientSideRowModelFilter", version: i.VERSION, rowModels: ["clientSide"], beans: [n.FilterStage] }, t2.FilterCoreModule = { moduleName: "FilterCore", version: i.VERSION, beans: [u.FilterManager], apiFunctions: { isAnyFilterPresent: g.isAnyFilterPresent, onFilterChanged: g.onFilterChanged }, css: [s.columnFiltersCSS], dependsOn: [t2.ClientSideRowModelFilterModule] }, t2.FilterValueModule = { moduleName: "FilterValue", version: i.VERSION, beans: [p.FilterValueService] }, t2.ColumnFilterModule = { moduleName: "ColumnFilter", version: i.VERSION, beans: [c.ColumnFilterService, h.FilterMenuFactory], dynamicBeans: { headerFilterCellCtrl: o.HeaderFilterCellCtrl }, icons: { filter: "filter", filterActive: "filter" }, apiFunctions: { isColumnFilterPresent: d.isColumnFilterPresent, getColumnFilterInstance: d.getColumnFilterInstance, destroyFilter: d.destroyFilter, setFilterModel: d.setFilterModel, getFilterModel: d.getFilterModel, getColumnFilterModel: d.getColumnFilterModel, setColumnFilterModel: d.setColumnFilterModel, showColumnFilter: d.showColumnFilter }, dependsOn: [t2.FilterCoreModule, l.PopupModule, t2.FilterValueModule, r.SharedMenuModule] }, t2.CustomFilterModule = { moduleName: "CustomFilter", version: i.VERSION, userComponents: { agReadOnlyFloatingFilter: m.ReadOnlyFloatingFilter }, dependsOn: [t2.ColumnFilterModule] }, t2.TextFilterModule = { moduleName: "TextFilter", version: i.VERSION, dependsOn: [t2.ColumnFilterModule], userComponents: { agTextColumnFilter: y.TextFilter, agTextColumnFloatingFilter: S.TextFloatingFilter } }, t2.NumberFilterModule = { moduleName: "NumberFilter", version: i.VERSION, dependsOn: [t2.ColumnFilterModule], userComponents: { agNumberColumnFilter: C.NumberFilter, agNumberColumnFloatingFilter: w.NumberFloatingFilter } }, t2.DateFilterModule = { moduleName: "DateFilter", version: i.VERSION, dependsOn: [t2.ColumnFilterModule], userComponents: { agDateColumnFilter: f.DateFilter, agDateInput: b.DefaultDateComponent, agDateColumnFloatingFilter: v.DateFloatingFilter } }, t2.QuickFilterModule = { moduleName: "QuickFilter", version: i.VERSION, rowModels: ["clientSide"], beans: [x.QuickFilterService], apiFunctions: { isQuickFilterPresent: k.isQuickFilterPresent, getQuickFilter: k.getQuickFilter, resetQuickFilter: k.resetQuickFilter }, dependsOn: [t2.FilterCoreModule, t2.FilterValueModule] }, t2.ExternalFilterModule = { moduleName: "ExternalFilter", version: i.VERSION, dependsOn: [t2.FilterCoreModule] };
          }, 3508: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.FilterValueService = void 0;
            const n = a2(8731);
            class o extends n.BeanStub {
              constructor() {
                super(...arguments), this.beanName = "filterValueSvc";
              }
              getValue(e3, t3) {
                if (!t3)
                  return;
                const a3 = e3.getColDef(), { filterValueGetter: n2 } = a3;
                return n2 ? this.executeFilterValueGetter(n2, t3.data, e3, t3, a3) : this.beans.valueSvc.getValue(e3, t3);
              }
              executeFilterValueGetter(e3, t3, a3, n2, o2) {
                const { expressionSvc: r, valueSvc: i } = this.beans, l = this.gos.addGridCommonParams({ data: t3, node: n2, column: a3, colDef: o2, getValue: i.getValueCallback.bind(this, n2) });
                return "function" == typeof e3 ? e3(l) : r == null ? void 0 : r.evaluate(e3, l);
              }
            }
            t2.FilterValueService = o;
          }, 1854: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.FilterWrapperComp = void 0;
            const n = a2(3507), o = a2(4422), r = a2(7990), i = a2(7764), l = a2(8020);
            class s extends l.Component {
              constructor(e3, t3) {
                super('<div class="ag-filter"></div>'), this.column = e3, this.source = t3, this.filterWrapper = null;
              }
              postConstruct() {
                this.createFilter(true), this.addManagedEventListeners({ filterDestroyed: this.onFilterDestroyed.bind(this) });
              }
              hasFilter() {
                return !!this.filterWrapper;
              }
              getFilter() {
                var _a, _b;
                return (_b = (_a = this.filterWrapper) == null ? void 0 : _a.filterPromise) != null ? _b : null;
              }
              afterInit() {
                var _a, _b, _c;
                return (_c = (_b = (_a = this.filterWrapper) == null ? void 0 : _a.filterPromise) == null ? void 0 : _b.then(() => {
                })) != null ? _c : r.AgPromise.resolve();
              }
              afterGuiAttached(e3) {
                var _a, _b;
                (_b = (_a = this.filterWrapper) == null ? void 0 : _a.filterPromise) == null ? void 0 : _b.then((t3) => {
                  var _a2;
                  (_a2 = t3 == null ? void 0 : t3.afterGuiAttached) == null ? void 0 : _a2.call(t3, e3);
                });
              }
              afterGuiDetached() {
                var _a, _b;
                (_b = (_a = this.filterWrapper) == null ? void 0 : _a.filterPromise) == null ? void 0 : _b.then((e3) => {
                  var _a2;
                  (_a2 = e3 == null ? void 0 : e3.afterGuiDetached) == null ? void 0 : _a2.call(e3);
                });
              }
              createFilter(e3) {
                var _a, _b, _c;
                const { column: t3, source: a3 } = this;
                this.filterWrapper = (_b = (_a = this.beans.filterManager) == null ? void 0 : _a.getOrCreateFilterWrapper(t3)) != null ? _b : null, ((_c = this.filterWrapper) == null ? void 0 : _c.filterPromise) && this.filterWrapper.filterPromise.then((n2) => {
                  const r2 = n2.getGui();
                  (0, o._exists)(r2) || (0, i._warn)(69, { guiFromFilter: r2 }), this.appendChild(r2), e3 && this.eventSvc.dispatchEvent({ type: "filterOpened", column: t3, source: a3, eGui: this.getGui() });
                });
              }
              onFilterDestroyed(e3) {
                "api" !== e3.source && "paramsUpdated" !== e3.source || e3.column.getId() !== this.column.getId() || !this.beans.colModel.getColDefCol(this.column) || ((0, n._clearElement)(this.getGui()), this.createFilter());
              }
              destroy() {
                this.filterWrapper = null, super.destroy();
              }
            }
            t2.FilterWrapperComp = s;
          }, 9990: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2._getDefaultFloatingFilterType = void 0;
            const n = a2(2036);
            t2._getDefaultFloatingFilterType = function(e3, t3, a3) {
              if (null == t3)
                return null;
              let o = null;
              const { compName: r, jsComp: i, fwComp: l } = (0, n._getFilterCompKeys)(e3, t3);
              if (r) {
                o = { agSetColumnFilter: "agSetColumnFloatingFilter", agMultiColumnFilter: "agMultiColumnFloatingFilter", agGroupColumnFilter: "agGroupColumnFloatingFilter", agNumberColumnFilter: "agNumberColumnFloatingFilter", agDateColumnFilter: "agDateColumnFloatingFilter", agTextColumnFilter: "agTextColumnFloatingFilter" }[r];
              } else {
                null == i && null == l && true === t3.filter && (o = a3());
              }
              return o;
            };
          }, 7287: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.FloatingFilterTextInputService = void 0;
            const n = a2(8731), o = a2(5946), r = a2(8020);
            class i extends n.BeanStub {
              constructor(e3) {
                super(), this.params = e3, this.eInput = r.RefPlaceholder, this.onValueChanged = () => {
                };
              }
              setupGui(e3) {
                var _a;
                this.eInput = this.createManagedBean(new o.AgInputTextField((_a = this.params) == null ? void 0 : _a.config));
                const t3 = this.eInput.getGui();
                e3.appendChild(t3);
                const a3 = (e4) => this.onValueChanged(e4);
                this.addManagedListeners(t3, { input: a3, keydown: a3 });
              }
              setEditable(e3) {
                this.eInput.setDisabled(!e3);
              }
              getValue() {
                return this.eInput.getValue();
              }
              setValue(e3, t3) {
                this.eInput.setValue(e3, t3);
              }
              setValueChangedListener(e3) {
                this.onValueChanged = e3;
              }
              setParams({ ariaLabel: e3, autoComplete: t3 }) {
                const { eInput: a3 } = this;
                a3.setInputAriaLabel(e3), void 0 !== t3 && a3.setAutoComplete(t3);
              }
            }
            t2.FloatingFilterTextInputService = i;
          }, 361: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.isUseApplyButton = t2.getDebounceMs = void 0;
            const n = a2(7764);
            function o(e3) {
              var _a, _b;
              return ((_b = (_a = e3.buttons) == null ? void 0 : _a.indexOf("apply")) != null ? _b : -1) >= 0;
            }
            t2.getDebounceMs = function(e3, t3) {
              const { debounceMs: a3 } = e3;
              return o(e3) ? (null != a3 && (0, n._warn)(71), 0) : a3 != null ? a3 : t3;
            }, t2.isUseApplyButton = o;
          }, 6657: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.ReadOnlyFloatingFilter = void 0;
            const n = a2(5946), o = a2(8020);
            class r extends o.Component {
              constructor() {
                super('\n            <div class="ag-floating-filter-input" role="presentation">\n                <ag-input-text-field data-ref="eFloatingFilterText"></ag-input-text-field>\n            </div>', [n.AgInputTextFieldSelector]), this.eFloatingFilterText = o.RefPlaceholder;
              }
              init(e3) {
                this.params = e3;
                const t3 = this.beans.colNames.getDisplayNameForColumn(e3.column, "header", true);
                this.eFloatingFilterText.setDisabled(true).setInputAriaLabel(`${t3} ${this.getLocaleTextFunc()("ariaFilterInput", "Filter Input")}`);
              }
              onParentModelChanged(e3) {
                null != e3 ? this.params.parentFilterInstance((t3) => {
                  if (t3.getModelAsString) {
                    const a3 = t3.getModelAsString(e3);
                    this.eFloatingFilterText.setValue(a3);
                  }
                }) : this.eFloatingFilterText.setValue("");
              }
              refresh(e3) {
                this.init(e3);
              }
            }
            t2.ReadOnlyFloatingFilter = r;
          }, 3141: function(e2, t2, a2) {
            Object.defineProperty(t2, "__esModule", { value: true }), t2.SimpleFloatingFilter = void 0;
            const n = a2(8020), o = a2(4824);
            class r extends n.Component {
              constructor() {
                super(...arguments), this.defaultDebounceMs = 0;
              }
              setLastTypeFromModel(e3) {
                if (!e3)
                  return void (this.lastType = this.optionsFactory.defaultOption);
                let t3;
                if (e3.operator) {
                  t3 = e3.conditions[0];
                } else
                  t3 = e3;
                this.lastType = t3.type;
              }
              canWeEditAfterModelFromParentFilter(e3) {
                if (!e3)
                  return this.isTypeEditable(this.lastType);
                if (e3.operator)
                  return false;
                const t3 = e3;
                return this.isTypeEditable(t3.type);
              }
              init(e3) {
                this.setSimpleParams(e3, false);
              }
              setSimpleParams(e3, t3 = true) {
                const a3 = new o.OptionsFactory();
    