defmodule DaProductApp.DisputesFixtures do
  @moduledoc """
  This module defines test helpers for creating
  entities via the `DaProductApp.Disputes` context.
  """

  @doc """
  Generate a dispute.
  """
  def dispute_fixture(attrs \\ %{}) do
    {:ok, dispute} =
      attrs
      |> Enum.into(%{
        txn_id: "TXN1003",
        reason: "Transaction not credited",
        merchant_comment: "Please verify settlement mismatch",
        contact_email: "merchant@example.com",
        status: "open",
        bank_user_id: "BANK_USER_001"
      })
      |> DaProductApp.Disputes.create_dispute()

    dispute
  end
end
