defmodule DaProductApp.SettlementsFixtures do
  @moduledoc """
  This module defines test helpers for creating
  entities via the `DaProductApp.Settlements` context.
  """

  def unique_settlement_id, do: "SETT#{System.unique_integer([:positive])}"

  @doc """
  Generate a settlement.
  """
  def settlement_fixture(attrs \\ %{}) do
    {:ok, settlement} =
      attrs
      |> Enum.into(%{
        settlement_id: unique_settlement_id(),
        date: Date.utc_today(),
        amount: Decimal.new("1000.00"),
        status: "pending",
        total_transaction_count: 5,
        merchant_id: "MRC123",
        provider_id: 1,
        bank_user_id: "BANK_USER_DEFAULT"
      })
      |> DaProductApp.Settlements.create_settlement()

    settlement
  end
end
