defmodule DaProductApp.Repo.Migrations.CreateComponents do
  use Ecto.Migration

  def up do
    execute("""
    CREATE TABLE components (
      id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
      component_name VARCHAR(255),
      version VARCHAR(255),
      supplier_type VARCHAR(255),
      supplier_name VARCHAR(255),
      relationship VARCHAR(255),
      checksum_type VARCHAR(255),
      checksum_algorithm VARCHAR(255),
      checksum_value VARCHAR(255),
      user_id BIGINT,
      application_id BIGINT,
      organization_id BIGINT,
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL
    ) ENGINE=InnoDB
    """)
  end

  def down do
    execute("DROP TABLE IF EXISTS components")
  end
end
