defmodule DaProductApp.Repo.Migrations.CreateStores do
  use Ecto.Migration

  def up do
    execute("""
    CREATE TABLE stores (
      id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
      code VARCHAR(255) NOT NULL,
      name VARCHAR(255) NOT NULL,
      brand_id BIGINT UNSIGNED,
      neo_merchant_id VARCHAR(255) NULL,
      address_id BIGINT UNSIGNED,
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL,
      CONSTRAINT fk_brand FOREIGN KEY (brand_id) REFERENCES brands(id),
      CONSTRAINT fk_address FOREIGN KEY (address_id) REFERENCES addresses(id)
    ) ENGINE=InnoDB
    """)
  end

  def down do
    execute("DROP TABLE IF EXISTS stores")
  end
end
