defmodule DaProductApp.Repo.Migrations.CreateTransactionRefunds do
  use Ecto.Migration

  def change do
    create table(:transaction_refunds) do
      add :transaction_id, :bigint, null: false
      add :refund_id, :string
      add :refund_request_id, :string
      add :refund_amount_value, :string
      add :refund_amount_currency, :string
      add :settlement_amount_value, :string
      add :settlement_amount_currency, :string
      add :result_code, :string
      add :result_status, :string
      add :result_message, :string
      add :refund_time, :utc_datetime
      add :settlement_quote_currency_pair, :string
      add :settlement_quote_expiry_time, :utc_datetime
      add :settlement_quote_id, :string
      add :settlement_quote_price, :string
      add :settlement_quote_start_time, :utc_datetime

      timestamps()
    end

    # Use raw SQL to modify the column to unsigned and add foreign key
    execute("ALTER TABLE transaction_refunds MODIFY transaction_id BIGINT UNSIGNED")
    execute("ALTER TABLE transaction_refunds ADD CONSTRAINT transaction_refunds_transaction_id_fkey FOREIGN KEY (transaction_id) REFERENCES transactions(id)")

    create unique_index(:transaction_refunds, [:refund_id])
    create index(:transaction_refunds, [:transaction_id])
  end

  def down do
    drop table(:transaction_refunds)
  end
end
